/*
 * Decompiled with CFR 0.152.
 */
package org.egov.services.budget;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.script.ScriptContext;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.CFinancialYear;
import org.egov.commons.CFunction;
import org.egov.commons.EgwStatus;
import org.egov.commons.Functionary;
import org.egov.commons.Fund;
import org.egov.commons.Scheme;
import org.egov.commons.SubScheme;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.commons.service.ChartOfAccountsService;
import org.egov.eis.entity.Assignment;
import org.egov.eis.entity.Employee;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.EisCommonService;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.utils.SequenceNumberGenerator;
import org.egov.infra.script.entity.Script;
import org.egov.infra.script.service.ScriptService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.workflow.entity.State;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.infra.workflow.service.WorkflowService;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.budget.Budget;
import org.egov.model.budget.BudgetDetail;
import org.egov.model.budget.BudgetGroup;
import org.egov.model.budget.BudgetUpload;
import org.egov.model.repository.BudgetDetailRepository;
import org.egov.model.voucher.WorkflowBean;
import org.egov.pims.commons.Designation;
import org.egov.pims.commons.Position;
import org.egov.pims.model.PersonalInformation;
import org.egov.services.budget.BudgetGroupService;
import org.egov.services.budget.BudgetService;
import org.egov.utils.BudgetAccountType;
import org.egov.utils.BudgetingType;
import org.egov.utils.Constants;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Property;
import org.hibernate.criterion.Restrictions;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.SQLGrammarException;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class BudgetDetailService
extends PersistenceService<BudgetDetail, Long> {
    private static final String BE = "BE";
    private static final String RE = "RE";
    @Autowired
    protected EisCommonService eisCommonService;
    protected WorkflowService<BudgetDetail> budgetDetailWorkflowService;
    private ScriptService scriptExecutionService;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    @Qualifier(value="budgetService")
    private BudgetService budgetService;
    @Autowired
    @Qualifier(value="budgetGroupService")
    private BudgetGroupService budgetGroupService;
    @Autowired
    private SequenceNumberGenerator sequenceNumberGenerator;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;
    @Autowired
    @Qualifier(value="chartOfAccountsService")
    private ChartOfAccountsService chartOfAccountsService;
    @Autowired
    private EgwStatusHibernateDAO egwStatusDAO;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    @Qualifier(value="workflowService")
    private SimpleWorkflowService<BudgetDetail> budgetDetailWFService;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private BudgetDetailRepository budgetDetailRepository;
    private static final String DUPLICATE = "budgetDetail.duplicate";
    private static final String EXISTS = "budgetdetail.exists";
    private static final Logger LOGGER = Logger.getLogger(BudgetDetailService.class);
    private static final String BUDGET_STATES_INSERT = "insert into eg_wf_states (ID,TYPE,VALUE,CREATEDBY,CREATEDDATE,LASTMODIFIEDDATE,LASTMODIFIEDBY,DATEINFO,OWNER_POS,STATUS,VERSION) values (:stateId,'Budget','NEW',1,current_date,current_date,1,current_date,1,1,0)";
    private static final String BUDGETDETAIL_STATES_INSERT = "insert into eg_wf_states (ID,TYPE,VALUE,CREATEDBY,CREATEDDATE,LASTMODIFIEDDATE,LASTMODIFIEDBY,DATEINFO,OWNER_POS,STATUS,VERSION) values (:stateId,'BudgetDetail','NEW',1,current_date,current_date,1,current_date,1,1,0)";

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public BudgetDetailService() {
        super(BudgetDetail.class);
    }

    public BudgetDetailService(Class<BudgetDetail> type) {
        super(type);
    }

    public Long getCountByBudget(Long budgetId) {
        return ((BigInteger)this.persistenceService.getSession().createSQLQuery("select count(*) from egf_budgetdetail where budget = " + budgetId).uniqueResult()).longValue();
    }

    public boolean canViewApprovedAmount(PersistenceService persistenceService, Budget budget) {
        Script script = (Script)persistenceService.findAllByNamedQuery("Script.findByName", new Object[]{"budget.report.view.access"}).get(0);
        ScriptContext context = ScriptService.createContext((Object[])new Object[]{"wfItem", budget, "eisCommonServiceBean", this.eisCommonService, "userId", ApplicationThreadLocals.getUserId().intValue()});
        Integer result = (Integer)this.scriptExecutionService.executeScript(script, context);
        return result == 1;
    }

    public BudgetDetail createBudgetDetail(BudgetDetail detail, Position position, PersistenceService service) {
        try {
            this.setRelatedEntitesOn(detail);
            return detail;
        }
        catch (ConstraintViolationException e) {
            throw new ValidationException(Arrays.asList(new ValidationError(DUPLICATE, EXISTS)));
        }
    }

    public List<BudgetDetail> searchBy(BudgetDetail detail) {
        return this.constructCriteria(detail).list();
    }

    public List<BudgetDetail> searchByCriteriaAndFY(Long financialYear, BudgetDetail detail, boolean isApprove, Position pos) {
        Criteria criteria = this.constructCriteria(detail).createCriteria("budget").add((Criterion)Restrictions.eq((String)"financialYear.id", (Object)financialYear));
        if (isApprove) {
            criteria.createCriteria("state").add((Criterion)Restrictions.eq((String)"owner", (Object)pos));
        } else {
            criteria.createCriteria("state").add((Criterion)Restrictions.eq((String)"value", (Object)"NEW"));
        }
        return criteria.list();
    }

    public List<BudgetDetail> searchByCriteriaWithTypeAndFY(Long financialYear, String type, BudgetDetail detail) {
        if (detail.getBudget() != null && detail.getBudget().getId() != 0L) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            this.addCriteriaExcludingBudget(detail, map);
            Criteria criteria = this.getSession().createCriteria(BudgetDetail.class);
            this.addBudgetDetailCriteria(map, criteria);
            criteria.addOrder(Order.asc((String)"id"));
            return criteria.createCriteria("budget").add((Criterion)Restrictions.eq((String)"financialYear.id", (Object)financialYear)).add((Criterion)Restrictions.eq((String)"isbere", (Object)type)).list();
        }
        return this.constructCriteria(detail).createCriteria("budget").add((Criterion)Restrictions.eq((String)"financialYear.id", (Object)financialYear)).add((Criterion)Restrictions.eq((String)"isbere", (Object)type)).list();
    }

    private Map<String, Object> createCriteriaMap(BudgetDetail detail) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.addCriteriaExcludingBudget(detail, map);
        map.put("budget", detail.getBudget() == null ? 0L : detail.getBudget().getId());
        return map;
    }

    protected void addCriteriaExcludingBudget(BudgetDetail detail, Map<String, Object> map) {
        map.put("budgetGroup", detail.getBudgetGroup() == null ? 0L : detail.getBudgetGroup().getId());
        map.put("function", detail.getFunction() == null ? 0L : detail.getFunction().getId());
        map.put("functionary", detail.getFunctionary() == null ? 0 : detail.getFunctionary().getId());
        map.put("scheme", detail.getScheme() == null ? 0 : detail.getScheme().getId());
        map.put("subScheme", detail.getSubScheme() == null ? 0 : detail.getSubScheme().getId());
        map.put("executingDepartment", detail.getExecutingDepartment() == null ? 0L : detail.getExecutingDepartment().getId());
        map.put("boundary", detail.getBoundary() == null ? 0L : detail.getBoundary().getId());
        map.put("fund", detail.getFund() == null ? 0 : detail.getFund().getId());
        map.put("status", detail.getStatus() == null ? 0 : detail.getStatus().getId());
    }

    public List<BudgetDetail> findAllBudgetDetailsFor(Budget budget, BudgetDetail example) {
        ArrayList<Budget> budgets = new ArrayList<Budget>();
        this.collectLeafBudgets(budget, budgets);
        budgets.add(this.findBudget(budget));
        Criteria criteria = this.constructCriteria(example);
        criteria.add(Restrictions.in((String)"budget", budgets));
        criteria.addOrder(Property.forName((String)"budget").asc());
        criteria.createAlias("budgetGroup", "bg");
        criteria.addOrder(Property.forName((String)"bg.name").asc());
        return criteria.list();
    }

    public List<BudgetDetail> findAllBudgetDetailsForParent(Budget budget, BudgetDetail example, PersistenceService persistenceService) {
        if (budget == null || budget.getId() == null) {
            return Collections.EMPTY_LIST;
        }
        budget = (Budget)((Object)persistenceService.find("from Budget where id=?", new Object[]{budget.getId()}));
        BudgetDetail detail = new BudgetDetail();
        detail.copyFrom(example);
        detail.setBudget(null);
        String materializedPath = budget.getMaterializedPath();
        return this.constructCriteria(detail).addOrder(Property.forName((String)"executingDepartment").asc()).createCriteria("budget").add((Criterion)Restrictions.like((String)"materializedPath", (Object)(materializedPath == null ? "" : materializedPath.concat("%")))).list();
    }

    public List<BudgetDetail> findAllBudgetDetailsWithReAppropriation(Budget budget, BudgetDetail example) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting findAllBudgetDetailsWithReAppropriation...");
        }
        List<BudgetDetail> budgetDetails = this.findAllBudgetDetailsFor(budget, example);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Done findAllBudgetDetailsWithReAppropriation.");
        }
        return budgetDetails;
    }

    private Budget findBudget(Budget budget) {
        return (Budget)((Object)this.getSession().load(Budget.class, (Serializable)budget.getId()));
    }

    public List<Budget> findBudgetsForFY(Long financialYear) {
        Criteria criteria = this.getSession().createCriteria(Budget.class);
        return criteria.add((Criterion)Restrictions.eq((String)"financialYear.id", (Object)financialYear)).add((Criterion)Restrictions.eq((String)"isActiveBudget", (Object)true)).list();
    }

    public List<Budget> findApprovedBudgetsForFY(Long financialYear) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"starting findApprovedBudgetsForFY...");
        }
        Criteria criteria = this.getSession().createCriteria(Budget.class);
        return criteria.add((Criterion)Restrictions.eq((String)"financialYear.id", (Object)financialYear)).add((Criterion)Restrictions.eq((String)"isActiveBudget", (Object)true)).addOrder(Property.forName((String)"name").asc()).createCriteria("status", "status").add((Criterion)Restrictions.eq((String)"status.code", (Object)"Approved")).list();
    }

    public List<Budget> findBudgetsForFYWithNewState(Long financialYear) {
        Criteria criteria = this.getSession().createCriteria(Budget.class);
        criteria.createCriteria("status", "status").add((Criterion)Restrictions.eq((String)"status.code", (Object)"Created"));
        return criteria.add((Criterion)Restrictions.eq((String)"financialYear.id", (Object)financialYear)).add((Criterion)Restrictions.eq((String)"isActiveBudget", (Object)true)).list();
    }

    public List<Budget> findPrimaryBudgetForFY(Long financialYear) {
        Criteria criteria = this.getSession().createCriteria(Budget.class);
        return criteria.add((Criterion)Restrictions.eq((String)"financialYear.id", (Object)financialYear)).add((Criterion)Restrictions.eq((String)"isActiveBudget", (Object)true)).add((Criterion)Restrictions.eq((String)"isPrimaryBudget", (Object)true)).add(Restrictions.isNull((String)"parent")).list();
    }

    public Budget findApprovedPrimaryParentBudgetForFY(Long financialYear) {
        Criteria c;
        Criteria criteria = this.getSession().createCriteria(Budget.class);
        List budgetList = criteria.add((Criterion)Restrictions.eq((String)"financialYear.id", (Object)financialYear)).add((Criterion)Restrictions.eq((String)"isbere", (Object)RE)).add((Criterion)Restrictions.eq((String)"isActiveBudget", (Object)true)).add((Criterion)Restrictions.eq((String)"isPrimaryBudget", (Object)true)).add(Restrictions.isNull((String)"parent")).addOrder(Property.forName((String)"name").asc()).createCriteria("status", "status").add((Criterion)Restrictions.eq((String)"status.code", (Object)"Approved")).list();
        if (budgetList.isEmpty() && (budgetList = (c = this.getSession().createCriteria(Budget.class)).add((Criterion)Restrictions.eq((String)"financialYear.id", (Object)financialYear)).add((Criterion)Restrictions.eq((String)"isbere", (Object)BE)).add((Criterion)Restrictions.eq((String)"isActiveBudget", (Object)true)).add((Criterion)Restrictions.eq((String)"isPrimaryBudget", (Object)true)).add(Restrictions.isNull((String)"parent")).addOrder(Property.forName((String)"name").asc()).createCriteria("status", "status").add((Criterion)Restrictions.eq((String)"status.code", (Object)"Approved")).list()).isEmpty()) {
            return null;
        }
        return (Budget)((Object)budgetList.get(0));
    }

    public Set<Budget> findBudgetTree(Budget budget, BudgetDetail example) {
        if (budget == null) {
            return Collections.EMPTY_SET;
        }
        Criteria budgetDetailCriteria = this.constructCriteria(example);
        budgetDetailCriteria.createCriteria("budget");
        List leafBudgets = budgetDetailCriteria.setProjection(Projections.distinct((Projection)Projections.property((String)"budget"))).list();
        ArrayList<Budget> parents = new ArrayList<Budget>();
        LinkedHashSet<Budget> budgetTree = new LinkedHashSet<Budget>();
        Iterator iterator = leafBudgets.iterator();
        while (iterator.hasNext()) {
            Budget leaf;
            parents.clear();
            for (leaf = (Budget)((Object)iterator.next()); leaf != null && leaf.getId() != budget.getId(); leaf = leaf.getParent()) {
                parents.add(leaf);
            }
            if (leaf == null) continue;
            parents.add(leaf);
            budgetTree.addAll(parents);
        }
        return budgetTree;
    }

    private List<Budget> findChildren(Budget parent) {
        return this.findAllBy("from Budget b where b.parent=?", new Object[]{parent});
    }

    private void collectLeafBudgets(Budget parent, List<Budget> children) {
        List<Budget> myChildren = this.findChildren(parent);
        for (Budget child : myChildren) {
            this.collectLeafBudgets(child, children);
            if (!this.findChildren(child).isEmpty()) continue;
            children.add(child);
        }
    }

    private Criteria constructCriteria(BudgetDetail example) {
        Map<String, Object> map = this.createCriteriaMap(example);
        Criteria criteria = this.getSession().createCriteria(BudgetDetail.class);
        this.addBudgetDetailCriteria(map, criteria);
        return criteria;
    }

    private void addBudgetDetailCriteria(Map<String, Object> map, Criteria criteria) {
        for (Map.Entry<String, Object> criterion : map.entrySet()) {
            if (!this.isIdPresent(criterion.getValue())) continue;
            criteria.createCriteria(criterion.getKey()).add(Restrictions.idEq((Object)criterion.getValue()));
        }
    }

    private void addBudgetDetailCriteriaIncudingNullRestrictions(Map<String, Object> map, Criteria criteria) {
        for (Map.Entry<String, Object> criterion : map.entrySet()) {
            if (this.isIdPresent(criterion.getValue())) {
                criteria.createCriteria(criterion.getKey()).add(Restrictions.idEq((Object)criterion.getValue()));
                continue;
            }
            criteria.add(Restrictions.isNull((String)criterion.getKey()));
        }
    }

    protected boolean isIdPresent(Object value) {
        return Long.valueOf(value.toString()) != 0L && Long.valueOf(value.toString()) != -1L;
    }

    @Transactional
    public BudgetDetail persist(BudgetDetail detail) {
        try {
            detail.setUniqueNo(detail.getFund().getId() + "-" + detail.getExecutingDepartment().getId() + "-" + detail.getFunction().getId() + "-" + detail.getBudgetGroup().getId());
            if (!this.chequeUnique(detail).booleanValue() && detail.getId() == null) {
                throw new ValidationException(Arrays.asList(new ValidationError(DUPLICATE, EXISTS)));
            }
            this.checkForDuplicates(detail);
            return (BudgetDetail)((Object)super.persist((Object)detail));
        }
        catch (Exception e) {
            throw new ValidationException(Arrays.asList(new ValidationError(DUPLICATE, EXISTS)));
        }
    }

    private Boolean chequeUnique(BudgetDetail detail) {
        Criteria criteria = this.constructCriteria(detail).add((Criterion)Restrictions.eq((String)"budget.id", (Object)detail.getBudget().getId()));
        criteria.add((Criterion)Restrictions.eq((String)"budgetGroup.id", (Object)detail.getBudgetGroup().getId()));
        criteria.add((Criterion)Restrictions.eq((String)"fund.id", (Object)detail.getFund().getId()));
        criteria.add((Criterion)Restrictions.eq((String)"function.id", (Object)detail.getFunction().getId()));
        criteria.add((Criterion)Restrictions.eq((String)"executingDepartment.id", (Object)detail.getExecutingDepartment().getId()));
        return criteria.list().isEmpty();
    }

    public void checkForDuplicates(BudgetDetail detail) {
        Criteria criteria = this.getSession().createCriteria(BudgetDetail.class);
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.addCriteriaExcludingBudget(detail, map);
        this.addBudgetDetailCriteriaIncudingNullRestrictions(map, criteria);
        if (detail.getBudget() == null || detail.getBudget().getId() == null || detail.getBudget().getId() == 0L || detail.getBudget().getId() == -1L) {
            return;
        }
        Budget root = this.getRootFor(detail.getBudget());
        criteria.createCriteria("budget").add((Criterion)Restrictions.eq((String)"materializedPath", (Object)(root == null ? "" : root.getMaterializedPath())));
        List existingDetails = criteria.list();
        if (!existingDetails.isEmpty() && !((BudgetDetail)((Object)existingDetails.get(0))).getId().equals(detail.getId())) {
            throw new ValidationException(Arrays.asList(new ValidationError(DUPLICATE, EXISTS)));
        }
    }

    private Budget getRootFor(Budget budget) {
        if (budget == null || StringUtils.isBlank((String)budget.getMaterializedPath())) {
            return null;
        }
        if (budget.getMaterializedPath().length() == 1) {
            return budget;
        }
        return (Budget)((Object)this.persistenceService.find("from Budget where materializedPath=?", new Object[]{budget.getMaterializedPath().split("\\.")[0]}));
    }

    protected User getUser() {
        return (User)this.find(" from User where id=?", new Object[]{ApplicationThreadLocals.getUserId()});
    }

    public Position getPositionForEmployee(Employee emp) throws ApplicationRuntimeException {
        return this.eisCommonService.getPrimaryAssignmentPositionForEmp(emp.getId());
    }

    public void setEisCommonService(EisCommonService eisCommonService) {
        this.eisCommonService = eisCommonService;
    }

    public AppConfigValueService getAppConfigValuesService() {
        return this.appConfigValuesService;
    }

    public void setAppConfigValuesService(AppConfigValueService appConfigValuesService) {
        this.appConfigValuesService = appConfigValuesService;
    }

    public Department getDepartmentForBudget(BudgetDetail detail) throws ApplicationRuntimeException {
        Department dept = null;
        if (detail.getExecutingDepartment() == null) {
            throw new ApplicationRuntimeException("Department not found for the Budget" + detail.getId());
        }
        dept = detail.getExecutingDepartment();
        return dept;
    }

    public Department depertmentForEmployee(Employee emp) {
        Department dept = null;
        Date currDate = new Date();
        try {
            Assignment empAssignment = this.eisCommonService.getLatestAssignmentForEmployeeByToDate(emp.getId(), currDate);
            dept = empAssignment.getDepartment();
            return dept;
        }
        catch (NullPointerException ne) {
            throw new ApplicationRuntimeException(ne.getMessage());
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("Error while getting Department fort the employee" + emp.getName());
        }
    }

    public List<BudgetDetail> getRemainingDetailsForApproveOrReject(Budget budget) {
        Criteria criteria = this.getSession().createCriteria(BudgetDetail.class);
        criteria.createCriteria("budget", "budget").add((Criterion)Restrictions.eq((String)"budget.id", (Object)budget.getId()));
        return criteria.list();
    }

    public List<BudgetDetail> getRemainingDetailsForSave(Budget budget, Position currPos) {
        Criteria criteria = this.getSession().createCriteria(BudgetDetail.class);
        criteria.createCriteria("state", "state").add((Criterion)Restrictions.eq((String)"state.owner", (Object)currPos));
        criteria.createCriteria("budget", "budget").add((Criterion)Restrictions.eq((String)"budget.id", (Object)budget.getId()));
        return criteria.list();
    }

    public BudgetDetail setRelatedEntitesOn(BudgetDetail detail) {
        detail.setStatus(this.egwStatusDAO.getStatusByModuleAndCode("BUDGETDETAIL", "Approved"));
        if (detail.getBudget() != null) {
            detail.setBudget((Budget)((Object)this.persistenceService.getSession().load(Budget.class, (Serializable)detail.getBudget().getId())));
            this.addMaterializedPath(detail);
        }
        if (detail.getFunction() != null) {
            detail.setFunction((CFunction)this.persistenceService.getSession().load(CFunction.class, (Serializable)detail.getFunction().getId()));
        }
        if (detail.getFunctionary() != null) {
            detail.setFunctionary((Functionary)this.persistenceService.getSession().load(Functionary.class, (Serializable)detail.getFunctionary().getId()));
        }
        if (detail.getExecutingDepartment() != null) {
            detail.setExecutingDepartment((Department)this.persistenceService.getSession().load(Department.class, (Serializable)detail.getExecutingDepartment().getId()));
        }
        if (detail.getScheme() != null) {
            detail.setScheme((Scheme)this.persistenceService.getSession().load(Scheme.class, (Serializable)detail.getScheme().getId()));
        }
        if (detail.getSubScheme() != null) {
            detail.setSubScheme((SubScheme)this.persistenceService.getSession().load(SubScheme.class, (Serializable)detail.getSubScheme().getId()));
        }
        if (detail.getFund() != null) {
            detail.setFund((Fund)this.persistenceService.getSession().load(Fund.class, (Serializable)detail.getFund().getId()));
        }
        if (detail.getBudgetGroup() != null) {
            detail.setBudgetGroup((BudgetGroup)((Object)this.persistenceService.getSession().load(BudgetGroup.class, (Serializable)detail.getBudgetGroup().getId())));
        }
        if (detail.getBoundary() != null) {
            detail.setBoundary((Boundary)this.persistenceService.getSession().load(Boundary.class, (Serializable)detail.getBoundary().getId()));
        }
        return detail;
    }

    private void addMaterializedPath(BudgetDetail detail) {
        String materializedPath = "";
        String count = "";
        if (detail.getBudget() != null) {
            materializedPath = detail.getBudget().getMaterializedPath();
            List parallelBudgetDetails = this.findAllBy("from BudgetDetail bd where bd.budget=?", new Object[]{detail.getBudget()});
            if (parallelBudgetDetails != null) {
                count = String.valueOf(parallelBudgetDetails.size() + 1);
            }
            if (materializedPath != null && !materializedPath.isEmpty()) {
                materializedPath = materializedPath + "." + count;
            }
            detail.setMaterializedPath(materializedPath);
        }
    }

    public void transitionToEnd(BudgetDetail detail, Position position) {
        detail.transition(true).end().withOwner(position);
    }

    public List<Object[]> fetchActualsForFYDate(String fromDate, String toVoucherDate, List<String> mandatoryFields) {
        List list;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Starting fetchActualsForFY" + fromDate));
        }
        if ((list = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "exclude_status_forbudget_actual")).isEmpty()) {
            throw new ValidationException("", "exclude_status_forbudget_actual is not defined in AppConfig", new String[0]);
        }
        StringBuffer miscQuery = this.getMiscQuery(mandatoryFields, "vmis", "gl", "vh");
        StringBuffer budgetGroupQuery = new StringBuffer();
        budgetGroupQuery.append(" (select bg1.id as id,bg1.accounttype as accounttype, c1.glcode as mincode,c2.glcode as maxcode,c3.glcode as majorcode from egf_budgetgroup bg1 left outer join chartofaccounts c1 on c1.id=bg1.mincode left outer join chartofaccounts c2 on c2.id=bg1.maxcode left outer join chartofaccounts c3 on c3.id=bg1.majorcode ) bg ");
        String voucherstatusExclude = ((AppConfigValues)list.get(0)).getValue();
        StringBuffer query = new StringBuffer();
        query = query.append("select bd.id,SUM(gl.debitAmount)-SUM(gl.creditAmount) from egf_budgetdetail bd,generalledger gl,voucherheader vh,vouchermis vmis," + budgetGroupQuery + ",egf_budget b where bd.budget=b.id and vmis.VOUCHERHEADERID=vh.id and gl.VOUCHERHEADERID=vh.id and bd.budgetgroup=bg.id and " + "(bg.ACCOUNTTYPE='REVENUE_EXPENDITURE' or bg.ACCOUNTTYPE='CAPITAL_EXPENDITURE') and vh.status not in (" + voucherstatusExclude + ") and " + "vh.voucherDate>= to_date('" + fromDate + "','dd/MM/yyyy') and vh.voucherDate <= to_date('" + toVoucherDate + "','dd/MM/yyyy') " + miscQuery + " and (gl.glcode = bg.mincode or gl.glcode=bg.majorcode) group by bd.id" + " union " + "select bd.id,SUM(gl.creditAmount)-SUM(gl.debitAmount) from egf_budgetdetail bd,generalledger gl,voucherheader vh," + "vouchermis vmis," + budgetGroupQuery + ",egf_budget b where bd.budget=b.id and vmis.VOUCHERHEADERID=vh.id and gl.VOUCHERHEADERID=vh.id and bd.budgetgroup=bg.id and " + "(bg.ACCOUNTTYPE='REVENUE_RECEIPTS' or bg.ACCOUNTTYPE='CAPITAL_RECEIPTS') and vh.status not in (" + voucherstatusExclude + ") and " + "vh.voucherDate>= to_date('" + fromDate + "','dd/MM/yyyy') and vh.voucherDate <= to_date('" + toVoucherDate + "','dd/MM/yyyy') " + miscQuery + " and (gl.glcode = bg.mincode or gl.glcode=bg.majorcode) group by bd.id");
        List result = this.getSession().createSQLQuery(query.toString()).list();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Finished fetchActualsForFY" + fromDate));
        }
        return result;
    }

    public String generateUniqueNo(BudgetDetail detail) {
        return detail.getFund().getId() + "-" + detail.getExecutingDepartment().getId() + "-" + detail.getFunction().getId() + "-" + detail.getBudgetGroup().getId();
    }

    public List<Object[]> fetchActualsForFY(CFinancialYear fy, List<String> mandatoryFields, Budget topBudget, Budget referingTopBudget, Date date, Integer dept, Long fun) {
        List list;
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Starting fetchActualsForFY" + fy.getStartingDate().getYear() + "-" + fy.getEndingDate().getYear()));
        }
        String dateCondition = "";
        if (date != null) {
            dateCondition = " AND vh.voucherdate <='" + Constants.DDMMYYYYFORMAT1.format(date) + "' ";
        }
        if ((list = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "exclude_status_forbudget_actual")).isEmpty()) {
            throw new ValidationException("", "exclude_status_forbudget_actual is not defined in AppConfig", new String[0]);
        }
        StringBuffer miscQuery = this.getMiscQuery(mandatoryFields, "vmis", "gl", "vh");
        if (dept != null) {
            miscQuery.append(" and bd.executing_department=" + dept);
        }
        if (fun != null) {
            miscQuery = miscQuery.append(" AND bd.function=" + fun);
        }
        StringBuffer referingUniqueNoQry = new StringBuffer(200);
        referingUniqueNoQry.append(" ");
        if (referingTopBudget != null) {
            referingUniqueNoQry.append(" and bd.uniqueno in (select uniqueno from egf_budgetdetail where MATERIALIZEDPATH like '" + referingTopBudget.getMaterializedPath() + "%'  )");
        }
        StringBuffer budgetGroupQuery = new StringBuffer();
        budgetGroupQuery.append(" (select bg1.id as id,bg1.accounttype as accounttype,case when c1.glcode =  NULL then -1 else to_number(c1.glcode,'999999999') end as mincode,case when c2.glcode = null then  999999999 else c2.glcode end as maxcode,case when c3.glcode = null then -1 else to_number(c3.glcode,'999999999') end  as majorcode from egf_budgetgroup bg1 left outer join chartofaccounts c1 on c1.id=bg1.mincode left outer join chartofaccounts c2 on c2.id=bg1.maxcode left outer join chartofaccounts c3 on c3.id=bg1.majorcode ) bg ");
        String voucherstatusExclude = ((AppConfigValues)list.get(0)).getValue();
        StringBuffer query = new StringBuffer();
        query = query.append("  select bd.uniqueno,SUM(gl.debitAmount)-SUM(gl.creditAmount) from egf_budgetdetail bd,vouchermis vmis,egf_budgetgroup bg,egf_budget b,financialyear f,fiscalperiod p,voucherheader vh,generalledger gl where bd.budget=b.id and p.financialyearid=f.id and f.id=" + fy.getId() + " and vh.fiscalperiodid=p.id " + dateCondition + " and " + " b.financialyearid=" + topBudget.getFinancialYear().getId() + " and b.MATERIALIZEDPATH like '" + topBudget.getMaterializedPath() + "%' " + referingUniqueNoQry.toString() + " and  vmis.VOUCHERHEADERID=vh.id and gl.VOUCHERHEADERID=vh.id " + " and bd.budgetgroup=bg.id " + " and vh.status not in (" + voucherstatusExclude + ")  " + miscQuery + " " + " and gl.glcodeid=bg.mincode and gl.glcodeid=bg.maxcode and  bg.majorcode is null group by bd.uniqueno");
        List result = this.getSession().createSQLQuery(query.toString()).list();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Finished fetchActualsForFY " + result.size() + "      " + query.toString()));
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"==============================================================================================");
        }
        return result;
    }

    public List<Object[]> fetchActualsForFinYear(CFinancialYear fy, List<String> mandatoryFields, Budget topBudget, Budget referingTopBudget, Date date, Integer dept, Long fun, List<AppConfigValues> list) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Starting fetchActualsForFY" + fy.getStartingDate().getYear() + "-" + fy.getEndingDate().getYear()));
        }
        String dateCondition = "";
        if (date != null) {
            dateCondition = " AND vh.voucherdate <='" + Constants.DDMMYYYYFORMAT1.format(date) + "' ";
        }
        StringBuffer miscQuery = this.getMiscQuery(mandatoryFields, "vmis", "gl", "vh");
        if (dept != null) {
            miscQuery.append(" and bd.executing_department=" + dept);
        }
        if (fun != null) {
            miscQuery = miscQuery.append(" AND bd.function=" + fun);
        }
        StringBuffer referingUniqueNoQry = new StringBuffer(200);
        referingUniqueNoQry.append(" ");
        if (referingTopBudget != null) {
            referingUniqueNoQry.append(" and bd.uniqueno in (select uniqueno from egf_budgetdetail where MATERIALIZEDPATH like '" + referingTopBudget.getMaterializedPath() + "%'  )");
        }
        StringBuffer budgetGroupQuery = new StringBuffer();
        budgetGroupQuery.append(" (select bg1.id as id,bg1.accounttype as accounttype,case when c1.glcode =  NULL then -1 else to_number(c1.glcode,'999999999') end as mincode,case when c2.glcode = null then  999999999 else c2.glcode end as maxcode,case when c3.glcode = null then -1 else to_number(c3.glcode,'999999999') end  as majorcode from egf_budgetgroup bg1 left outer join chartofaccounts c1 on c1.id=bg1.mincode left outer join chartofaccounts c2 on c2.id=bg1.maxcode left outer join chartofaccounts c3 on c3.id=bg1.majorcode ) bg ");
        String voucherstatusExclude = list.get(0).getValue();
        StringBuffer query = new StringBuffer();
        String sum = "";
        sum = topBudget.getName().contains("Receipt") ? "SUM(gl.creditAmount)-SUM(gl.debitAmount)" : "SUM(gl.debitAmount)-SUM(gl.creditAmount)";
        query = query.append("  select bd.uniqueno," + sum + " from egf_budgetdetail bd," + "vouchermis vmis,egf_budgetgroup bg,egf_budget b,financialyear f,fiscalperiod p,voucherheader vh,generalledger gl " + "where bd.budget=b.id and p.financialyearid=f.id and f.id=" + fy.getId() + " and vh.fiscalperiodid=p.id " + dateCondition + " and " + " b.financialyearid=" + topBudget.getFinancialYear().getId() + " and b.MATERIALIZEDPATH like '" + topBudget.getMaterializedPath() + "%' " + referingUniqueNoQry.toString() + " and  vmis.VOUCHERHEADERID=vh.id and gl.VOUCHERHEADERID=vh.id " + " and bd.budgetgroup=bg.id " + " and vh.status not in (" + voucherstatusExclude + ")  " + miscQuery + " " + " and gl.glcodeid=bg.mincode and gl.glcodeid=bg.maxcode and  bg.majorcode is null group by bd.uniqueno");
        List result = this.getSession().createSQLQuery(query.toString()).list();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Finished fetchActualsForFY " + result.size() + "      " + query.toString()));
        }
        return result;
    }

    public List<Object[]> fetchMajorCodeAndActuals(CFinancialYear financialYear, Budget topBudget, Date date, CFunction function, Department dept, Position pos) {
        List list;
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Starting fetchMajorCodeAndActuals................");
        }
        StringBuffer query = new StringBuffer();
        String dateCondition = "";
        if (date != null) {
            dateCondition = " AND vh.voucherdate <='" + Constants.DDMMYYYYFORMAT1.format(date) + "' ";
        }
        String functionCondition = "";
        if (function != null) {
            functionCondition = " and gl.functionId=" + function.getId();
        }
        if ((list = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "exclude_status_forbudget_actual")).isEmpty()) {
            throw new ValidationException("", "exclude_status_forbudget_actual is not defined in AppConfig", new String[0]);
        }
        String voucherstatusExclude = ((AppConfigValues)list.get(0)).getValue();
        String sum = "";
        sum = topBudget.getName().contains("Receipt") ? "SUM(gl.creditAmount)-SUM(gl.debitAmount)" : "SUM(gl.debitAmount)-SUM(gl.creditAmount)";
        query = query.append("SELECT substr(gl.glcode,1,3)," + sum + " FROM egf_budgetdetail bd, vouchermis vmis, egf_budgetgroup bg, egf_budget b, financialyear f, fiscalperiod p, voucherheader vh, generalledger gl, eg_wf_states wf" + " WHERE bd.budget      =b.id AND p.financialyearid=f.id AND f.id =" + financialYear.getId() + " AND vh.fiscalperiodid=p.id " + dateCondition + " AND b.financialyearid=" + topBudget.getFinancialYear().getId() + " AND b.id = " + topBudget.getId() + " AND vmis.VOUCHERHEADERID=vh.id AND gl.VOUCHERHEADERID  =vh.id" + " AND bd.budgetgroup      =bg.id  AND vh.status NOT      IN (" + voucherstatusExclude + ") AND vh.fundId =bd.fund AND gl.functionId =bd.function " + functionCondition + "" + " AND vmis.departmentid   =bd.executing_department and bd.executing_department =" + dept.getId() + " AND gl.glcodeid         =bg.mincode AND gl.glcodeid         =bg.maxcode AND bg.majorcode       IS NULL AND (wf.value='END' OR wf.owner_pos=" + pos.getId() + ") AND bd.state_id = wf.id GROUP BY substr(gl.glcode,1,3)");
        List result = this.getSession().createSQLQuery(query.toString()).list();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Finished fetchMajorCodeAndActuals......." + query.toString()));
        }
        return result;
    }

    public List<Object[]> fetchMajorCodeAndName(Budget topBudget, BudgetDetail budgetDetail, CFunction function, Position pos) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Starting fetchMajorCodeAndName............");
        }
        StringBuffer query = new StringBuffer();
        String functionCondition = "";
        if (function != null) {
            functionCondition = " AND bd.function = " + function.getId();
        }
        query = query.append("SELECT cao.majorcode, cao1.glcode||'-'||cao1.name FROM egf_budgetdetail bd, egf_budgetgroup bg, egf_budget b, chartofaccounts cao, chartofaccounts cao1, financialyear f, eg_wf_states wf WHERE bd.budget=b.id AND f.id=" + topBudget.getFinancialYear().getId() + " AND b.financialyearid=" + topBudget.getFinancialYear().getId() + " AND b.MATERIALIZEDPATH LIKE '" + topBudget.getMaterializedPath() + "%' AND bd.budgetgroup=bg.id " + " AND cao.id=bg.mincode AND cao.id=bg.maxcode AND bg.majorcode IS NULL AND bd.executing_department = " + budgetDetail.getExecutingDepartment().getId() + functionCondition + " and cao1.glcode = cao.majorcode AND (wf.value='END' OR wf.owner_pos=" + pos.getId() + ") AND bd.state_id = wf.id GROUP BY cao.majorcode, cao1.glcode||'-'||cao1.name");
        List result = this.getSession().createSQLQuery(query.toString()).list();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Finished fetchMajorCodeAndName..........." + query.toString()));
        }
        return result;
    }

    public List<Object[]> fetchMajorCodeAndBEAmount(Budget topBudget, BudgetDetail budgetDetail, CFunction function, Position pos) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Starting fetchMajorCodeAndBEAmount................");
        }
        StringBuffer query = new StringBuffer();
        String functionCondition1 = "";
        String functionCondition2 = "";
        if (function != null) {
            functionCondition1 = " AND bd1.function = " + function.getId();
            functionCondition2 = " AND bd2.function = " + function.getId();
        }
        query = query.append("SELECT cao.majorcode, SUM(bd2.approvedamount) FROM egf_budgetdetail bd1, egf_budgetdetail bd2, egf_budgetgroup bg, egf_budget b1, egf_budget b2, chartofaccounts cao, financialyear f, eg_wf_states wf WHERE bd1.budget =b1.id AND bd2.budget =b2.id AND f.id =" + topBudget.getFinancialYear().getId() + " AND b1.financialyearid=" + topBudget.getFinancialYear().getId() + " AND b2.financialyearid=" + topBudget.getFinancialYear().getId() + " AND b1.MATERIALIZEDPATH LIKE '" + topBudget.getMaterializedPath() + "%' and b2.isbere='BE' AND bd2.budgetgroup =bg.id  " + " AND cao.id =bg.mincode AND cao.id =bg.maxcode AND bg.majorcode IS NULL AND bd2.executing_department = " + budgetDetail.getExecutingDepartment().getId() + functionCondition2 + " AND bd1.executing_department = " + budgetDetail.getExecutingDepartment().getId() + functionCondition1 + " AND bd1.uniqueno = bd2.uniqueno AND (wf.value='END' OR wf.owner_pos=" + pos.getId() + ") AND bd1.state_id = wf.id GROUP BY cao.majorcode");
        List result = this.getSession().createSQLQuery(query.toString()).list();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Finished fetchMajorCodeAndBEAmount");
        }
        return result;
    }

    public List<Object[]> fetchUniqueNoAndBEAmount(Budget topBudget, BudgetDetail budgetDetail, CFunction function, Position pos) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Starting fetchUniqueNoAndBEAmount................");
        }
        StringBuffer query = new StringBuffer();
        String functionCondition1 = "";
        String functionCondition2 = "";
        if (function != null) {
            functionCondition1 = " AND bd1.function = " + function.getId();
            functionCondition2 = " AND bd2.function = " + function.getId();
        }
        query = query.append("SELECT bd2.uniqueno, SUM(bd2.approvedamount) FROM egf_budgetdetail bd1, egf_budgetdetail bd2, egf_budgetgroup bg, egf_budget b1, egf_budget b2, chartofaccounts cao, financialyear f, eg_wf_states wf WHERE bd1.budget =b1.id AND bd2.budget =b2.id AND f.id =" + topBudget.getFinancialYear().getId() + " AND b1.financialyearid=" + topBudget.getFinancialYear().getId() + " AND b2.financialyearid=" + topBudget.getFinancialYear().getId() + " AND b1.MATERIALIZEDPATH LIKE '" + topBudget.getMaterializedPath() + "%' and b2.isbere='BE' AND bd2.budgetgroup =bg.id  " + " AND cao.id =bg.mincode AND cao.id =bg.maxcode AND bg.majorcode IS NULL AND bd2.executing_department = " + budgetDetail.getExecutingDepartment().getId() + functionCondition2 + " AND bd1.executing_department = " + budgetDetail.getExecutingDepartment().getId() + functionCondition1 + " AND bd1.uniqueno = bd2.uniqueno AND (wf.value='END' OR wf.owner_pos=" + pos.getId() + ") AND bd1.state_id = wf.id GROUP BY bd2.uniqueno");
        List result = this.getSession().createSQLQuery(query.toString()).list();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Finished fetchUniqueNoAndBEAmount");
        }
        return result;
    }

    public List<Object[]> fetchMajorCodeAndAppropriation(Budget topBudget, BudgetDetail budgetDetail, CFunction function, Position pos, Date asOnDate) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Starting fetchMajorCodeAndAppropriation................");
        }
        StringBuffer query = new StringBuffer();
        String functionCondition1 = "";
        String functionCondition2 = "";
        String dateCondition = "";
        String ReappropriationTable = " ";
        if (function != null) {
            functionCondition1 = " AND bd1.function = " + function.getId();
            functionCondition2 = " AND bd2.function = " + function.getId();
        }
        if (asOnDate != null) {
            ReappropriationTable = " egf_reappropriation_misc bmisc,";
            dateCondition = " and bapp.reappropriation_misc= bmisc.id and  bmisc.reappropriation_date <= '" + Constants.DDMMYYYYFORMAT1.format(asOnDate) + "'";
        }
        query = query.append("SELECT cao.majorcode, SUM(bapp.addition_amount)-SUM(bapp.deduction_amount) FROM egf_budgetdetail bd1, egf_budgetdetail bd2, egf_budgetgroup bg, egf_budget b1, egf_budget b2, chartofaccounts cao, financialyear f, egf_budget_reappropriation bapp, " + ReappropriationTable + " eg_wf_states wf" + " WHERE bd1.budget=b1.id and bd2.budget=b2.id AND f.id   =" + topBudget.getFinancialYear().getId() + " AND b1.financialyearid=" + topBudget.getFinancialYear().getId() + " AND b2.financialyearid=" + topBudget.getFinancialYear().getId() + " AND b1.MATERIALIZEDPATH LIKE '" + topBudget.getMaterializedPath() + "%' and b2.isbere='BE' AND bd2.budgetgroup          =bg.id " + dateCondition + " AND cao.id=bg.mincode AND cao.id=bg.maxcode AND bg.majorcode IS NULL AND bd1.executing_department = " + budgetDetail.getExecutingDepartment().getId() + " " + functionCondition1 + " AND bd2.executing_department = " + budgetDetail.getExecutingDepartment().getId() + "" + " " + functionCondition2 + " AND bapp.budgetdetail  = bd2.id AND (wf.value ='END' OR wf.owner_pos =" + pos.getId() + ") AND bd1.state_id             = wf.id and bd1.uniqueno = bd2.uniqueno GROUP BY cao.majorcode");
        List result = this.getSession().createSQLQuery(query.toString()).list();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Finished fetchMajorCodeAndAppropriation");
        }
        return result;
    }

    public List<Object[]> fetchUniqueNoAndApprAmount(Budget topBudget, BudgetDetail budgetDetail, CFunction function, Position pos) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Starting fetchUniqueNoAndApprAmount................");
        }
        StringBuffer query = new StringBuffer();
        String functionCondition1 = "";
        String functionCondition2 = "";
        if (function != null) {
            functionCondition1 = " AND bd1.function = " + function.getId();
            functionCondition2 = " AND bd2.function = " + function.getId();
        }
        query = query.append("SELECT bd2.uniqueno, SUM(bapp.addition_amount)-SUM(bapp.deduction_amount) FROM egf_budgetdetail bd1, egf_budgetdetail bd2, egf_budgetgroup bg, egf_budget b1, egf_budget b2, chartofaccounts cao, financialyear f, egf_budget_reappropriation bapp, eg_wf_states wf WHERE bd1.budget      =b1.id and bd2.budget =b2.id AND f.id =" + topBudget.getFinancialYear().getId() + " AND b1.financialyearid=" + topBudget.getFinancialYear().getId() + " AND b2.financialyearid=" + topBudget.getFinancialYear().getId() + " AND b1.MATERIALIZEDPATH LIKE '" + topBudget.getMaterializedPath() + "%' and b2.isbere='BE' AND bd2.budgetgroup          =bg.id " + " AND cao.id                  =bg.mincode AND cao.id                  =bg.maxcode AND bg.majorcode           IS NULL AND bd1.executing_department = " + budgetDetail.getExecutingDepartment().getId() + " " + functionCondition1 + " AND bd2.executing_department = " + budgetDetail.getExecutingDepartment().getId() + "" + " " + functionCondition2 + " AND bapp.budgetdetail = bd2.id AND (wf.value               ='END' OR wf.owner_pos                 =" + pos.getId() + ") AND bd1.state_id             = wf.id and bd1.uniqueno = bd2.uniqueno GROUP BY bd2.uniqueno");
        List result = this.getSession().createSQLQuery(query.toString()).list();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Finished fetchUniqueNoAndApprAmount");
        }
        return result;
    }

    public List<Object[]> fetchMajorCodeAndAnticipatory(Budget topBudget, BudgetDetail budgetDetail, CFunction function, Position pos) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Starting fetchMajorCodeAndAnticipatory................");
        }
        StringBuffer query = new StringBuffer();
        String functionCondition = "";
        if (function != null) {
            functionCondition = " AND bd.function = " + function.getId();
        }
        query = query.append("SELECT cao.majorcode, SUM(bd.anticipatory_amount) as anticipatory_amount, SUM(bd.originalamount) as originalamount, SUM(bd.approvedamount) as approvedamount FROM egf_budgetdetail bd, egf_budgetgroup bg, egf_budget b, chartofaccounts cao, financialyear f, eg_wf_states wf WHERE bd.budget =b.id AND f.id =" + topBudget.getFinancialYear().getId() + " AND b.financialyearid=" + topBudget.getFinancialYear().getId() + " AND b.MATERIALIZEDPATH LIKE '" + topBudget.getMaterializedPath() + "%' AND bd.budgetgroup =bg.id  AND cao.id =bg.mincode AND cao.id =bg.maxcode AND bg.majorcode IS NULL AND bd.executing_department = " + budgetDetail.getExecutingDepartment().getId() + functionCondition + " AND (wf.value='END' OR wf.owner_pos=" + pos.getId() + ") AND bd.state_id = wf.id GROUP BY cao.majorcode");
        List result = this.getSession().createSQLQuery(query.toString()).list();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Finished fetchMajorCodeAndAnticipatory");
        }
        return result;
    }

    public List<Object[]> fetchMajorCodeAndOriginalAmount(Budget topBudget, BudgetDetail budgetDetail, CFunction function, Position pos) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Starting fetchMajorCodeAndOriginalAmount................");
        }
        StringBuffer query = new StringBuffer();
        String functionCondition = "";
        if (function != null) {
            functionCondition = " AND bd.function = " + function.getId();
        }
        query = query.append("SELECT cao.majorcode, SUM(bd.originalamount) FROM egf_budgetdetail bd, egf_budgetgroup bg, egf_budget b, chartofaccounts cao, financialyear f, eg_wf_states wf WHERE bd.budget =b.id AND f.id =" + topBudget.getFinancialYear().getId() + " AND b.financialyearid=" + topBudget.getFinancialYear().getId() + " AND b.MATERIALIZEDPATH LIKE '" + topBudget.getMaterializedPath() + "%' AND bd.budgetgroup =bg.id  AND cao.id =bg.mincode AND cao.id =bg.maxcode AND bg.majorcode IS NULL AND bd.executing_department = " + budgetDetail.getExecutingDepartment().getId() + functionCondition + " AND (wf.value='END' OR wf.owner_pos=" + pos.getId() + ") AND bd.state_id = wf.id GROUP BY cao.majorcode");
        List result = this.getSession().createSQLQuery(query.toString()).list();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Finished fetchMajorCodeAndOriginalAmount");
        }
        return result;
    }

    public List<Object[]> fetchMajorCodeAndBENextYr(Budget topBudget, BudgetDetail budgetDetail, CFunction function, Position pos) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Starting fetchMajorCodeAndBENextYr................");
        }
        StringBuffer query = new StringBuffer();
        String functionCondition1 = "";
        String functionCondition2 = "";
        if (function != null) {
            functionCondition1 = " AND bd1.function = " + function.getId();
            functionCondition2 = " AND bd2.function = " + function.getId();
        }
        query = query.append("SELECT cao.majorcode, SUM(bd2.originalamount) as originalamount, SUM(bd2.approvedamount) as approvedamount  FROM egf_budgetdetail bd1, egf_budgetdetail bd2, egf_budgetgroup bg, egf_budget b1, egf_budget b2, chartofaccounts cao, eg_wf_states wf WHERE bd1.budget =b1.id AND bd2.budget =b2.id AND b1.financialyearid=" + topBudget.getFinancialYear().getId() + " AND b1.MATERIALIZEDPATH LIKE '" + topBudget.getMaterializedPath() + "%' AND bd2.budgetgroup =bg.id " + " AND cao.id =bg.mincode AND cao.id =bg.maxcode AND bg.majorcode IS NULL AND bd2.executing_department = " + budgetDetail.getExecutingDepartment().getId() + functionCondition2 + " AND bd1.executing_department = " + budgetDetail.getExecutingDepartment().getId() + functionCondition1 + " AND bd1.uniqueno = bd2.uniqueno AND b2.reference_budget = b1.id AND (wf.value='END' OR wf.owner_pos=" + pos.getId() + ") AND bd1.state_id = wf.id GROUP BY cao.majorcode");
        List result = this.getSession().createSQLQuery(query.toString()).list();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Finished fetchMajorCodeAndBENextYr");
        }
        return result;
    }

    public List<Object[]> fetchMajorCodeAndApprovedAmount(Budget topBudget, BudgetDetail budgetDetail, CFunction function, Position pos) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Starting fetchMajorCodeAndApprovedAmount................");
        }
        StringBuffer query = new StringBuffer();
        String functionCondition = "";
        if (function != null) {
            functionCondition = " AND bd.function = " + function.getId();
        }
        query = query.append("SELECT cao.majorcode, SUM(bd.approvedamount) as approvedamount  FROM egf_budgetdetail bd, egf_budgetgroup bg, egf_budget b, chartofaccounts cao, financialyear f, eg_wf_states wf WHERE bd.budget =b.id AND f.id =" + topBudget.getFinancialYear().getId() + " AND b.financialyearid=" + topBudget.getFinancialYear().getId() + " AND b.MATERIALIZEDPATH LIKE '" + topBudget.getMaterializedPath() + "%' AND bd.budgetgroup =bg.id  AND cao.id =bg.mincode AND cao.id =bg.maxcode AND bg.majorcode IS NULL AND bd.executing_department = " + budgetDetail.getExecutingDepartment().getId() + functionCondition + " AND (wf.value='END' OR wf.owner_pos=" + pos.getId() + ") AND bd.state_id = wf.id GROUP BY cao.majorcode");
        List result = this.getSession().createSQLQuery(query.toString()).list();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Finished fetchMajorCodeAndApprovedAmount");
        }
        return result;
    }

    public List<Object[]> fetchMajorCodeAndBENextYrApproved(Budget topBudget, BudgetDetail budgetDetail, CFunction function, Position pos) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Starting fetchMajorCodeAndBENextYrApproved................");
        }
        StringBuffer query = new StringBuffer();
        String functionCondition1 = "";
        String functionCondition2 = "";
        if (function != null) {
            functionCondition1 = " AND bd1.function = " + function.getId();
            functionCondition2 = " AND bd2.function = " + function.getId();
        }
        query = query.append("SELECT cao.majorcode, SUM(bd2.approvedamount) FROM egf_budgetdetail bd1, egf_budgetdetail bd2, egf_budgetgroup bg, egf_budget b1, egf_budget b2, chartofaccounts cao, eg_wf_states wf WHERE bd1.budget =b1.id AND bd2.budget =b2.id AND b1.financialyearid=" + topBudget.getFinancialYear().getId() + " AND b1.MATERIALIZEDPATH LIKE '" + topBudget.getMaterializedPath() + "%' AND bd2.budgetgroup =bg.id " + " AND cao.id =bg.mincode AND cao.id =bg.maxcode AND bg.majorcode IS NULL AND bd2.executing_department = " + budgetDetail.getExecutingDepartment().getId() + functionCondition2 + " AND bd1.executing_department = " + budgetDetail.getExecutingDepartment().getId() + functionCondition1 + " AND bd1.uniqueno = bd2.uniqueno AND b2.reference_budget = b1.id AND (wf.value='END' OR wf.owner_pos=" + pos.getId() + ") AND bd1.state_id = wf.id GROUP BY cao.majorcode");
        List result = this.getSession().createSQLQuery(query.toString()).list();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Finished fetchMajorCodeAndBENextYrApproved");
        }
        return result;
    }

    public List<Object[]> fetchMajorCodeAndNameForReport(CFinancialYear financialYear, String fundType, String budgetType) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Starting fetchMajorCodeAndName............");
        }
        String budgetingType = fundType.toUpperCase() + "_" + budgetType.toUpperCase();
        String excludeDept = " and bd.executing_department!=(Select id_dept from eg_department where dept_code='Z') ";
        StringBuffer query = new StringBuffer();
        query = query.append("SELECT cao.majorcode, cao1.glcode||'-'||cao1.name FROM egf_budgetdetail bd, egf_budgetgroup bg, egf_budget b, chartofaccounts cao, chartofaccounts cao1, financialyear f, egw_status wf WHERE bd.budget=b.id AND b.isbere='RE' AND f.id=" + financialYear.getId() + " AND b.financialyearid=" + financialYear.getId() + " AND bd.budgetgroup =bg.id AND bg.ACCOUNTTYPE ='" + budgetingType + "'" + " and bd.executing_department!=(Select id_dept from eg_department where dept_code='Z') " + " AND ((cao.id BETWEEN bg.mincode AND bg.maxcode) OR cao.majorcode=bg.majorcode) AND bg.mincode!=bg.maxcode AND wf.code='Approved' AND bd.status = wf.id GROUP BY cao.majorcode, cao1.glcode||'-'||cao1.name");
        query = query.append(" UNION ");
        query = query.append("SELECT cao.majorcode, cao1.glcode||'-'||cao1.name FROM egf_budgetdetail bd, egf_budgetgroup bg, egf_budget b, chartofaccounts cao, chartofaccounts cao1, financialyear f, egw_status wf WHERE bd.budget=b.id AND b.isbere='RE' AND f.id=" + financialYear.getId() + " AND b.financialyearid=" + financialYear.getId() + " AND bd.budgetgroup=bg.id AND bg.ACCOUNTTYPE ='" + budgetingType + "'" + " and bd.executing_department!=(Select id_dept from eg_department where dept_code='Z') " + " AND cao.id=bg.mincode AND cao.id=bg.maxcode AND bg.majorcode IS NULL and cao1.glcode = cao.majorcode AND wf.code='Approved' AND bd.status = wf.id GROUP BY cao.majorcode, cao1.glcode||'-'||cao1.name");
        List result = this.getSession().createSQLQuery(query.toString()).list();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Finished fetchMajorCodeAndName");
        }
        return result;
    }

    public List<Object[]> fetchMajorCodeAndActualsForReport(CFinancialYear financialYear, CFinancialYear prevFinYear, String fundType, String budgetType) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Starting fetchMajorCodeAndActuals................");
        }
        String excludeDept = " and bd.executing_department!=(Select id_dept from eg_department where dept_code='Z') ";
        String budgetingType = fundType.toUpperCase() + "_" + budgetType.toUpperCase();
        String condition = " SUM(gl.debitAmount)-SUM(gl.creditAmount) ";
        if (budgetingType.contains("RECEIPT")) {
            condition = " SUM(gl.creditAmount)-SUM(gl.debitAmount) ";
        }
        StringBuffer query = new StringBuffer();
        List list = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "exclude_status_forbudget_actual");
        if (list.isEmpty()) {
            throw new ValidationException("", "exclude_status_forbudget_actual is not defined in AppConfig", new String[0]);
        }
        String voucherstatusExclude = ((AppConfigValues)list.get(0)).getValue();
        query = query.append("SELECT substr(gl.glcode,1,3), " + condition + " FROM egf_budgetdetail bd, vouchermis vmis," + " (SELECT bg1.id AS id, bg1.accounttype AS accounttype, case when c1.glcode =  NULL then -1 else to_number(c1.glcode,'999999999') end  AS mincode, case when c2.glcode = null then  999999999 else c2.glcode end AS maxcode, case when c3.glcode = null then -1 else to_number(c3.glcode,'999999999') end  AS majorcode" + " FROM egf_budgetgroup bg1 LEFT OUTER JOIN chartofaccounts c1 ON c1.id=bg1.mincode LEFT OUTER JOIN chartofaccounts c2 ON c2.id=bg1.maxcode LEFT OUTER JOIN chartofaccounts c3 ON c3.id=bg1.majorcode) bg ," + " egf_budget b, financialyear f, fiscalperiod p, voucherheader vh, generalledger gl, egw_status wf" + " WHERE bd.budget =b.id AND b.isbere='RE' AND p.financialyearid=f.id AND f.id =" + prevFinYear.getId() + " AND vh.fiscalperiodid=p.id AND b.financialyearid=" + financialYear.getId() + " AND vmis.VOUCHERHEADERID=vh.id AND gl.VOUCHERHEADERID  =vh.id" + " AND bd.budgetgroup =bg.id AND bg.ACCOUNTTYPE ='" + budgetingType + "'" + " and bd.executing_department!=(Select id_dept from eg_department where dept_code='Z') " + " AND vh.status NOT IN (" + voucherstatusExclude + ") AND vh.fundId =bd.fund AND vmis.departmentid =bd.executing_department AND gl.functionid = bd.function " + " AND ((gl.glcode BETWEEN bg.mincode AND bg.maxcode) OR gl.glcode =bg.majorcode) AND bg.mincode!=bg.maxcode AND wf.code='Approved' AND bd.status = wf.id GROUP BY substr(gl.glcode,1,3)");
        query = query.append(" UNION ");
        query = query.append("SELECT substr(gl.glcode,1,3), " + condition + " FROM egf_budgetdetail bd, vouchermis vmis, egf_budgetgroup bg, egf_budget b, financialyear f, fiscalperiod p, voucherheader vh, generalledger gl, egw_status wf" + " WHERE bd.budget      =b.id AND b.isbere='RE' AND p.financialyearid=f.id AND f.id             =" + prevFinYear.getId() + " AND vh.fiscalperiodid=p.id AND b.financialyearid=" + financialYear.getId() + " AND vmis.VOUCHERHEADERID=vh.id AND gl.VOUCHERHEADERID  =vh.id" + " AND bd.budgetgroup      =bg.id AND bg.ACCOUNTTYPE ='" + budgetingType + "'" + " and bd.executing_department!=(Select id_dept from eg_department where dept_code='Z') " + " AND vh.status NOT      IN (" + voucherstatusExclude + ") AND vh.fundId           =bd.fund AND gl.functionid = bd.function " + " AND vmis.departmentid   =bd.executing_department AND gl.glcodeid         =bg.mincode AND gl.glcodeid =bg.maxcode AND bg.majorcode       IS NULL AND wf.code='Approved' AND bd.status = wf.id GROUP BY substr(gl.glcode,1,3)");
        List result = this.getSession().createSQLQuery(query.toString()).list();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Finished fetchMajorCodeAndActuals");
        }
        return result;
    }

    public List<Object[]> fetchMajorCodeAndBEAmountForReport(CFinancialYear financialYear, String fundType, String budgetType) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Starting fetchMajorCodeAndBEAmount................");
        }
        String excludeDept = " and bd2.executing_department!=(Select id_dept from eg_department where dept_code='Z') ";
        String budgetingType = fundType.toUpperCase() + "_" + budgetType.toUpperCase();
        StringBuffer query = new StringBuffer();
        query = query.append("SELECT cao.majorcode, SUM(round(bd2.approvedamount/1000,0)) FROM egf_budgetdetail bd1, egf_budgetdetail bd2, egf_budgetgroup bg, egf_budget b1, egf_budget b2, chartofaccounts cao, financialyear f, egw_status wf WHERE bd1.budget =b1.id AND bd2.budget =b2.id AND b1.isbere='RE' AND b2.isbere='BE' AND f.id =" + financialYear.getId() + " AND b1.financialyearid=" + financialYear.getId() + " AND b2.financialyearid=" + financialYear.getId() + " AND bd2.budgetgroup =bg.id AND bg.ACCOUNTTYPE ='" + budgetingType + "'" + " and bd2.executing_department!=(Select id_dept from eg_department where dept_code='Z') " + " AND ((cao.id BETWEEN bg.mincode AND bg.maxcode) OR cao.majorcode   =bg.majorcode) AND bd1.uniqueno = bd2.uniqueno AND wf.code='Approved' AND bd1.status = wf.id GROUP BY cao.majorcode");
        query = query.append(" UNION ");
        query = query.append("SELECT cao.majorcode, SUM(round(bd2.approvedamount/1000,0)) FROM egf_budgetdetail bd1, egf_budgetdetail bd2, egf_budgetgroup bg, egf_budget b1, egf_budget b2, chartofaccounts cao, financialyear f, egw_status wf WHERE bd1.budget =b1.id AND bd2.budget =b2.id AND b1.isbere='RE' AND b2.isbere='BE' AND f.id =" + financialYear.getId() + " AND b1.financialyearid=" + financialYear.getId() + " AND b2.financialyearid=" + financialYear.getId() + "  AND bd2.budgetgroup =bg.id AND bg.ACCOUNTTYPE ='" + budgetingType + "'" + " and bd2.executing_department!=(Select id_dept from eg_department where dept_code='Z') " + " AND cao.id =bg.mincode AND cao.id =bg.maxcode AND bg.majorcode IS NULL AND bd1.uniqueno = bd2.uniqueno AND wf.value='Approved' AND bd1.status = wf.id GROUP BY cao.majorcode");
        List result = this.getSession().createSQLQuery(query.toString()).list();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"------------------------------------------------------------------------------------------------------");
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Finished fetchMajorCodeAndBEAmount" + query.toString()));
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"------------------------------------------------------------------------------------------------------");
        }
        return result;
    }

    public List<Object[]> fetchMajorCodeAndApprovedAmountForReport(CFinancialYear financialYear, String fundType, String budgetType) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Starting fetchMajorCodeAndApprovedAmount................");
        }
        String excludeDept = " and bd.executing_department!=(Select id_dept from eg_department where dept_code='Z') ";
        String budgetingType = fundType.toUpperCase() + "_" + budgetType.toUpperCase();
        StringBuffer query = new StringBuffer();
        query = query.append("SELECT cao.majorcode, SUM(round(bd.approvedamount/1000,0)) FROM egf_budgetdetail bd, egf_budgetgroup bg, egf_budget b, chartofaccounts cao, financialyear f, egw_status wf WHERE bd.budget =b.id AND b.isbere='RE' AND f.id =" + financialYear.getId() + " AND b.financialyearid=" + financialYear.getId() + " AND bd.budgetgroup =bg.id AND bg.ACCOUNTTYPE ='" + budgetingType + "'" + " and bd.executing_department!=(Select id_dept from eg_department where dept_code='Z') " + " AND ((cao.id BETWEEN bg.mincode AND bg.maxcode) OR cao.majorcode =bg.majorcode) AND bg.mincode! =bg.maxcode AND wf.code='Approved' AND bd.status = wf.id GROUP BY cao.majorcode");
        query = query.append(" UNION ");
        query = query.append("SELECT cao.majorcode, SUM(round(bd.approvedamount/1000,0)) FROM egf_budgetdetail bd, egf_budgetgroup bg, egf_budget b, chartofaccounts cao, financialyear f, egw_status wf WHERE bd.budget =b.id AND b.isbere='RE' AND f.id =" + financialYear.getId() + " AND b.financialyearid=" + financialYear.getId() + " AND bd.budgetgroup =bg.id AND bg.ACCOUNTTYPE ='" + budgetingType + "'" + " and bd.executing_department!=(Select id_dept from eg_department where dept_code='Z') " + " AND cao.id =bg.mincode AND cao.id =bg.maxcode AND bg.majorcode IS NULL AND wf.code='Approved' AND bd.status = wf.id GROUP BY cao.majorcode");
        List result = this.getSession().createSQLQuery(query.toString()).list();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Finished fetchMajorCodeAndApprovedAmount");
        }
        return result;
    }

    public List<Object[]> fetchMajorCodeAndBENextYrApprovedForReport(CFinancialYear financialYear, String fundType, String budgetType) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Starting fetchMajorCodeAndBENextYrApproved................");
        }
        String excludeDept = " and bd2.executing_department!=(Select id_dept from eg_department where dept_code='Z') ";
        String budgetingType = fundType.toUpperCase() + "_" + budgetType.toUpperCase();
        StringBuffer query = new StringBuffer();
        query = query.append("SELECT cao.majorcode, SUM(round(bd2.approvedamount/1000,0)) FROM egf_budgetdetail bd1, egf_budgetdetail bd2, egf_budgetgroup bg, egf_budget b1, egf_budget b2, chartofaccounts cao, egw_status wf WHERE bd1.budget =b1.id AND bd2.budget =b2.id AND b1.isbere='RE' AND b2.isbere='BE' AND b1.financialyearid=" + financialYear.getId() + " AND bd2.budgetgroup =bg.id AND bg.ACCOUNTTYPE ='" + budgetingType + "'" + " and bd2.executing_department!=(Select id_dept from eg_department where dept_code='Z') " + " AND ((cao.id BETWEEN bg.mincode AND bg.maxcode) OR cao.majorcode   =bg.majorcode) AND bd1.uniqueno = bd2.uniqueno AND b2.reference_budget = b1.id AND wf.code='Approved' AND bd1.status = wf.id GROUP BY cao.majorcode");
        query = query.append(" UNION ");
        query = query.append("SELECT cao.majorcode, SUM(round(bd2.approvedamount/1000,0)) FROM egf_budgetdetail bd1, egf_budgetdetail bd2, egf_budgetgroup bg, egf_budget b1, egf_budget b2, chartofaccounts cao, egw_status wf WHERE bd1.budget =b1.id AND bd2.budget =b2.id AND b1.isbere='RE' AND b2.isbere='BE' AND b1.financialyearid=" + financialYear.getId() + " AND bd2.budgetgroup =bg.id AND bg.ACCOUNTTYPE ='" + budgetingType + "'" + " and bd2.executing_department!=(Select id_dept from eg_department where dept_code='Z') " + " AND cao.id =bg.mincode AND cao.id =bg.maxcode AND bg.majorcode IS NULL AND bd1.uniqueno = bd2.uniqueno AND b2.reference_budget = b1.id AND wf.code='Approved' AND bd1.status = wf.id GROUP BY cao.majorcode");
        List result = this.getSession().createSQLQuery(query.toString()).list();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Finished fetchMajorCodeAndBENextYrApproved");
        }
        return result;
    }

    public List<Object[]> fetchGlCodeAndNameForReport(CFinancialYear financialYear, String fundType, String budgetType) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Starting fetchGlCodeAndNameForReport............");
        }
        String excludeDept = " and bd.executing_department!=(Select id_dept from eg_department where dept_code='Z') ";
        String budgetingType = fundType.toUpperCase() + "_" + budgetType.toUpperCase();
        StringBuffer query = new StringBuffer();
        query = query.append("SELECT substr(cao.glcode,0,3)||'-'||substr(cao.glcode,4,2)||'-'||substr(cao.glcode,6,2)||'-'||substr(cao.glcode,8,2), cao.glcode||'-'||cao.name FROM egf_budgetdetail bd, egf_budgetgroup bg, egf_budget b, chartofaccounts cao, chartofaccounts cao1, financialyear f, egw_status wf WHERE bd.budget=b.id AND b.isbere='RE' AND f.id=" + financialYear.getId() + " AND b.financialyearid=" + financialYear.getId() + " AND bd.budgetgroup =bg.id AND bg.ACCOUNTTYPE ='" + budgetingType + "'" + " and bd.executing_department!=(Select id_dept from eg_department where dept_code='Z') " + " AND ((cao.id BETWEEN bg.mincode AND bg.maxcode) OR cao.majorcode=bg.majorcode) AND bg.mincode!=bg.maxcode AND wf.code='Approved' AND bd.status = wf.id GROUP BY substr(cao.glcode,0,3)||'-'||substr(cao.glcode,4,2)||'-'||substr(cao.glcode,6,2)||'-'||substr(cao.glcode,8,2), cao.glcode||'-'||cao.name");
        query = query.append(" UNION ");
        query = query.append("SELECT substr(cao.glcode,0,3)||'-'||substr(cao.glcode,4,2)||'-'||substr(cao.glcode,6,2)||'-'||substr(cao.glcode,8,2), cao.glcode||'-'||cao.name FROM egf_budgetdetail bd, egf_budgetgroup bg, egf_budget b, chartofaccounts cao, chartofaccounts cao1, financialyear f, egw_status wf WHERE bd.budget=b.id AND b.isbere='RE' AND f.id=" + financialYear.getId() + " AND b.financialyearid=" + financialYear.getId() + " AND bd.budgetgroup=bg.id AND bg.ACCOUNTTYPE ='" + budgetingType + "'" + " and bd.executing_department!=(Select id_dept from eg_department where dept_code='Z') " + " AND cao.id=bg.mincode AND cao.id=bg.maxcode AND bg.majorcode IS NULL and cao1.glcode = cao.majorcode AND wf.code='Approved' AND bd.status = wf.id GROUP BY substr(cao.glcode,0,3)||'-'||substr(cao.glcode,4,2)||'-'||substr(cao.glcode,6,2)||'-'||substr(cao.glcode,8,2), cao.glcode||'-'||cao.name");
        List result = this.getSession().createSQLQuery(query.toString()).list();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Finished fetchGlCodeAndNameForReport");
        }
        return result;
    }

    public List<Object[]> fetchActualsForReport(CFinancialYear financialYear, CFinancialYear prevFinYear, String fundType, String budgetType) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Starting fetchActualsForReport................");
        }
        String excludeDept = " and bd.executing_department!=(Select id_dept from eg_department where dept_code='Z') ";
        String budgetingType = fundType.toUpperCase() + "_" + budgetType.toUpperCase();
        String condition = " SUM(gl.debitAmount)-SUM(gl.creditAmount) ";
        if (budgetingType.contains("RECEIPT")) {
            condition = " SUM(gl.creditAmount)-SUM(gl.debitAmount) ";
        }
        StringBuffer query = new StringBuffer();
        List list = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "exclude_status_forbudget_actual");
        if (list.isEmpty()) {
            throw new ValidationException("", "exclude_status_forbudget_actual is not defined in AppConfig", new String[0]);
        }
        String voucherstatusExclude = ((AppConfigValues)list.get(0)).getValue();
        query = query.append("SELECT substr(gl.glcode,0,3)||'-'||substr(gl.glcode,4,2)||'-'||substr(gl.glcode,6,2)||'-'||substr(gl.glcode,8,2)," + condition + " FROM egf_budgetdetail bd, vouchermis vmis," + " (SELECT bg1.id AS id, bg1.accounttype AS accounttype, case when c1.glcode =  NULL then -1 else to_number(c1.glcode,'999999999') end AS mincode, case when c2.glcode = null then  999999999 else c2.glcode end AS maxcode, case when c3.glcode = null then -1 else to_number(c3.glcode,'999999999') end  AS majorcode" + " FROM egf_budgetgroup bg1 LEFT OUTER JOIN chartofaccounts c1 ON c1.id=bg1.mincode LEFT OUTER JOIN chartofaccounts c2 ON c2.id=bg1.maxcode LEFT OUTER JOIN chartofaccounts c3 ON c3.id=bg1.majorcode) bg ," + " egf_budget b, financialyear f, fiscalperiod p, voucherheader vh, generalledger gl, egw_status wf" + " WHERE bd.budget =b.id AND b.isbere='RE' AND p.financialyearid=f.id AND f.id =" + prevFinYear.getId() + " AND vh.fiscalperiodid=p.id AND b.financialyearid=" + financialYear.getId() + " AND vmis.VOUCHERHEADERID=vh.id AND gl.VOUCHERHEADERID  =vh.id" + " AND bd.budgetgroup =bg.id AND bg.ACCOUNTTYPE ='" + budgetingType + "'" + " and bd.executing_department!=(Select id_dept from eg_department where dept_code='Z') " + " AND vh.status NOT IN (" + voucherstatusExclude + ") AND vh.fundId =bd.fund AND vmis.departmentid =bd.executing_department AND gl.functionid = bd.function " + " AND ((gl.glcode BETWEEN bg.mincode AND bg.maxcode) OR gl.glcode =bg.majorcode) AND bg.mincode!=bg.maxcode AND wf.code='Approved' AND bd.status = wf.id GROUP BY substr(gl.glcode,0,3)||'-'||substr(gl.glcode,4,2)||'-'||substr(gl.glcode,6,2)||'-'||substr(gl.glcode,8,2)");
        query = query.append(" UNION ");
        query = query.append("SELECT substr(gl.glcode,0,3)||'-'||substr(gl.glcode,4,2)||'-'||substr(gl.glcode,6,2)||'-'||substr(gl.glcode,8,2)," + condition + " FROM egf_budgetdetail bd, vouchermis vmis, egf_budgetgroup bg, egf_budget b, financialyear f, fiscalperiod p, voucherheader vh, generalledger gl, egw_status wf" + " WHERE bd.budget      =b.id AND b.isbere='RE' AND p.financialyearid=f.id AND f.id =" + prevFinYear.getId() + " AND vh.fiscalperiodid=p.id AND b.financialyearid=" + financialYear.getId() + " AND vmis.VOUCHERHEADERID=vh.id AND gl.VOUCHERHEADERID  =vh.id" + " AND bd.budgetgroup      =bg.id AND bg.ACCOUNTTYPE ='" + budgetingType + "'" + " and bd.executing_department!=(Select id_dept from eg_department where dept_code='Z') " + " AND vh.status NOT      IN (" + voucherstatusExclude + ") AND vh.fundId           =bd.fund AND gl.functionid = bd.function " + " AND vmis.departmentid   =bd.executing_department AND gl.glcodeid  =bg.mincode AND gl.glcodeid =bg.maxcode AND bg.majorcode IS NULL AND wf.code='Approved' AND bd.status = wf.id GROUP BY substr(gl.glcode,0,3)||'-'||substr(gl.glcode,4,2)||'-'||substr(gl.glcode,6,2)||'-'||substr(gl.glcode,8,2)");
        List result = this.getSession().createSQLQuery(query.toString()).list();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Finished fetchActualsForReport");
        }
        return result;
    }

    public List<Object[]> fetchGlCodeAndBEAmountForReport(CFinancialYear financialYear, String fundType, String budgetType) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Starting fetchGlCodeAndBEAmountForReport................");
        }
        String excludeDept = " and bd2.executing_department!=(Select id_dept from eg_department where dept_code='Z') ";
        String budgetingType = fundType.toUpperCase() + "_" + budgetType.toUpperCase();
        StringBuffer query = new StringBuffer();
        query = query.append("SELECT substr(cao.glcode,0,3)||'-'||substr(cao.glcode,4,2)||'-'||substr(cao.glcode,6,2)||'-'||substr(cao.glcode,8,2), SUM(round(bd2.approvedamount/1000,0)) FROM egf_budgetdetail bd1, egf_budgetdetail bd2, egf_budgetgroup bg, egf_budget b1, egf_budget b2, chartofaccounts cao, financialyear f, egw_status wf WHERE bd1.budget =b1.id AND bd2.budget =b2.id AND b1.isbere='RE' AND b2.isbere='BE' AND f.id =" + financialYear.getId() + " AND b1.financialyearid=" + financialYear.getId() + " AND b2.financialyearid=" + financialYear.getId() + " AND bd2.budgetgroup =bg.id AND bg.ACCOUNTTYPE ='" + budgetingType + "'" + " and bd2.executing_department!=(Select id_dept from eg_department where dept_code='Z') " + " AND ((cao.id BETWEEN bg.mincode AND bg.maxcode) OR cao.majorcode   =bg.majorcode) AND bd1.uniqueno = bd2.uniqueno AND wf.code='Approved' AND bd1.status = wf.id GROUP BY substr(cao.glcode,0,3)||'-'||substr(cao.glcode,4,2)||'-'||substr(cao.glcode,6,2)||'-'||substr(cao.glcode,8,2)");
        query = query.append(" UNION ");
        query = query.append("SELECT substr(cao.glcode,0,3)||'-'||substr(cao.glcode,4,2)||'-'||substr(cao.glcode,6,2)||'-'||substr(cao.glcode,8,2), SUM(round(bd2.approvedamount/1000,0)) FROM egf_budgetdetail bd1, egf_budgetdetail bd2, egf_budgetgroup bg, egf_budget b1, egf_budget b2, chartofaccounts cao, financialyear f, egw_status wf WHERE bd1.budget =b1.id AND bd2.budget =b2.id AND b1.isbere='RE' AND b2.isbere='BE' AND f.id =" + financialYear.getId() + " AND b1.financialyearid=" + financialYear.getId() + " AND b2.financialyearid=" + financialYear.getId() + "  AND bd2.budgetgroup =bg.id AND bg.ACCOUNTTYPE ='" + budgetingType + "'" + " and bd2.executing_department!=(Select id_dept from eg_department where dept_code='Z') " + " AND cao.id =bg.mincode AND cao.id =bg.maxcode AND bg.majorcode IS NULL AND bd1.uniqueno = bd2.uniqueno AND wf.code='Approved' AND bd1.status = wf.id GROUP BY substr(cao.glcode,0,3)||'-'||substr(cao.glcode,4,2)||'-'||substr(cao.glcode,6,2)||'-'||substr(cao.glcode,8,2)");
        List result = this.getSession().createSQLQuery(query.toString()).list();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"------------------------------------------------------------------------------------------------------");
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Finished fetchGlCodeAndBEAmountForReport" + query.toString()));
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"------------------------------------------------------------------------------------------------------");
        }
        return result;
    }

    public List<Object[]> fetchGlCodeAndApprovedAmountForReport(CFinancialYear financialYear, String fundType, String budgetType) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Starting fetchGlCodeAndApprovedAmountForReport................");
        }
        String excludeDept = " and bd.executing_department!=(Select id_dept from eg_department where dept_code='Z') ";
        String budgetingType = fundType.toUpperCase() + "_" + budgetType.toUpperCase();
        StringBuffer query = new StringBuffer();
        query = query.append("SELECT substr(cao.glcode,0,3)||'-'||substr(cao.glcode,4,2)||'-'||substr(cao.glcode,6,2)||'-'||substr(cao.glcode,8,2), SUM(round(bd.approvedamount/1000,0)) FROM egf_budgetdetail bd, egf_budgetgroup bg, egf_budget b, chartofaccounts cao, financialyear f, egw_status wf WHERE bd.budget =b.id AND b.isbere='RE' AND f.id =" + financialYear.getId() + " AND b.financialyearid=" + financialYear.getId() + " AND bd.budgetgroup =bg.id AND bg.ACCOUNTTYPE ='" + budgetingType + "'" + " and bd.executing_department!=(Select id_dept from eg_department where dept_code='Z') " + " AND ((cao.id BETWEEN bg.mincode AND bg.maxcode) OR cao.majorcode =bg.majorcode) AND bg.mincode! =bg.maxcode AND wf.code='Approved' AND bd.status = wf.id GROUP BY substr(cao.glcode,0,3)||'-'||substr(cao.glcode,4,2)||'-'||substr(cao.glcode,6,2)||'-'||substr(cao.glcode,8,2)");
        query = query.append(" UNION ");
        query = query.append("SELECT substr(cao.glcode,0,3)||'-'||substr(cao.glcode,4,2)||'-'||substr(cao.glcode,6,2)||'-'||substr(cao.glcode,8,2), SUM(round(bd.approvedamount/1000,0)) FROM egf_budgetdetail bd, egf_budgetgroup bg, egf_budget b, chartofaccounts cao, financialyear f, egw_status wf WHERE bd.budget =b.id AND b.isbere='RE' AND f.id =" + financialYear.getId() + " AND b.financialyearid=" + financialYear.getId() + " AND bd.budgetgroup =bg.id AND bg.ACCOUNTTYPE ='" + budgetingType + "'" + " and bd.executing_department!=(Select id_dept from eg_department where dept_code='Z') " + " AND cao.id =bg.mincode AND cao.id =bg.maxcode AND bg.majorcode IS NULL AND wf.code='Approved' AND bd.status = wf.id GROUP BY substr(cao.glcode,0,3)||'-'||substr(cao.glcode,4,2)||'-'||substr(cao.glcode,6,2)||'-'||substr(cao.glcode,8,2)");
        List result = this.getSession().createSQLQuery(query.toString()).list();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Finished fetchGlCodeAndApprovedAmountForReport");
        }
        return result;
    }

    public List<Object[]> fetchGlCodeAndBENextYrApprovedForReport(CFinancialYear financialYear, String fundType, String budgetType) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Starting fetchGlCodeAndBENextYrApprovedForReport................");
        }
        String excludeDept = " and bd2.executing_department!=(Select id_dept from eg_department where dept_code='Z') ";
        String budgetingType = fundType.toUpperCase() + "_" + budgetType.toUpperCase();
        StringBuffer query = new StringBuffer();
        query = query.append("SELECT substr(cao.glcode,0,3)||'-'||substr(cao.glcode,4,2)||'-'||substr(cao.glcode,6,2)||'-'||substr(cao.glcode,8,2), SUM(round(bd2.approvedamount/1000,0)) FROM egf_budgetdetail bd1, egf_budgetdetail bd2, egf_budgetgroup bg, egf_budget b1, egf_budget b2, chartofaccounts cao, egw_status wf WHERE bd1.budget =b1.id AND bd2.budget =b2.id AND b1.isbere='RE' AND b2.isbere='BE' AND b1.financialyearid=" + financialYear.getId() + " AND bd2.budgetgroup =bg.id AND bg.ACCOUNTTYPE ='" + budgetingType + "'" + " and bd2.executing_department!=(Select id_dept from eg_department where dept_code='Z') " + " AND ((cao.id BETWEEN bg.mincode AND bg.maxcode) OR cao.majorcode   =bg.majorcode) AND bd1.uniqueno = bd2.uniqueno AND b2.reference_budget = b1.id AND wf.code='Approved' AND bd1.status = wf.id GROUP BY substr(cao.glcode,0,3)||'-'||substr(cao.glcode,4,2)||'-'||substr(cao.glcode,6,2)||'-'||substr(cao.glcode,8,2)");
        query = query.append(" UNION ");
        query = query.append("SELECT substr(cao.glcode,0,3)||'-'||substr(cao.glcode,4,2)||'-'||substr(cao.glcode,6,2)||'-'||substr(cao.glcode,8,2), SUM(round(bd2.approvedamount/1000,0)) FROM egf_budgetdetail bd1, egf_budgetdetail bd2, egf_budgetgroup bg, egf_budget b1, egf_budget b2, chartofaccounts cao, egw_status wf WHERE bd1.budget =b1.id AND bd2.budget =b2.id AND b1.isbere='RE' AND b2.isbere='BE' AND b1.financialyearid=" + financialYear.getId() + " AND bd2.budgetgroup =bg.id AND bg.ACCOUNTTYPE ='" + budgetingType + "'" + " and bd2.executing_department!=(Select id_dept from eg_department where dept_code='Z') " + " AND cao.id =bg.mincode AND cao.id =bg.maxcode AND bg.majorcode IS NULL AND bd1.uniqueno = bd2.uniqueno AND b2.reference_budget = b1.id AND wf.code='Approved' AND bd1.status = wf.id GROUP BY substr(cao.glcode,0,3)||'-'||substr(cao.glcode,4,2)||'-'||substr(cao.glcode,6,2)||'-'||substr(cao.glcode,8,2)");
        List result = this.getSession().createSQLQuery(query.toString()).list();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Finished fetchGlCodeAndBENextYrApprovedForReport");
        }
        return result;
    }

    public List<Object[]> fetchActualsForBill(String fromDate, String toVoucherDate, List<String> mandatoryFields) {
        StringBuffer miscQuery = this.getMiscQuery(mandatoryFields, "bmis", "bdetail", "bmis");
        StringBuffer query = new StringBuffer();
        query = query.append("select bd.id,SUM(case when bdetail.debitAmount = null then 0  else bdetail.debitAmount  end)-SUM(case when bdetail.creditAmount=null then 0 else bdetail.creditAmount end) from egf_budgetdetail bd,eg_billdetails bdetail, eg_billregistermis bmis, eg_billregister br,egf_budgetgroup bg where bmis.billid=br.id and bdetail.billid=br.id and bd.budgetgroup=bg.id and (bg.ACCOUNTTYPE='REVENUE_EXPENDITURE' or bg.ACCOUNTTYPE='CAPITAL_EXPENDITURE') and br.billstatus != 'Cancelled'  and bmis.voucherheaderid is null and br.billdate>=to_date('" + fromDate + "','dd/MM/yyyy') and br.billdate <= to_date('" + toVoucherDate + "','dd/MM/yyyy') " + miscQuery + " and " + " (bmis.budgetCheckReq is null or bmis.budgetCheckReq=true) and " + "((bdetail.glcodeid between bg.mincode and bg.maxcode) or bdetail.glcodeid=bg.majorcode) group by bd.id" + " union " + "select bd.id,SUM(case when bdetail.creditAmount=null then 0 else bdetail.creditAmount end)-SUM(case when bdetail.debitAmount = null then 0  else bdetail.debitAmount  end) from egf_budgetdetail bd,eg_billdetails bdetail, eg_billregistermis bmis, eg_billregister br," + "egf_budgetgroup bg where bmis.billid=br.id and bdetail.billid=br.id and bd.budgetgroup=bg.id and " + " (bmis.budgetCheckReq is null or bmis.budgetCheckReq=true) and " + "(bg.ACCOUNTTYPE='REVENUE_RECEIPTS' or bg.ACCOUNTTYPE='CAPITAL_RECEIPTS') and br.billstatus != 'Cancelled' and bmis.voucherheaderid " + "is null and br.billdate>= to_date('" + fromDate + "','dd/MM/yyyy') and br.billdate <= to_date('" + toVoucherDate + "','dd/MM/yyyy') " + miscQuery + " and ((bdetail.glcodeid between bg.mincode " + "and bg.maxcode) or bdetail.glcodeid=bg.majorcode) group by bd.id");
        List result = this.getSession().createSQLQuery(query.toString()).list();
        return result;
    }

    public List<Object[]> fetchActualsForFYWithParams(String fromDate, String toVoucherDate, StringBuffer miscQuery) {
        List list = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "exclude_status_forbudget_actual");
        if (list.isEmpty()) {
            throw new ValidationException("", "exclude_status_forbudget_actual is not defined in AppConfig", new String[0]);
        }
        StringBuffer budgetGroupQuery = new StringBuffer();
        budgetGroupQuery.append(" (select bg1.id as id,bg1.accounttype as accounttype ,c1.glcode as mincode, c2.glcode as maxcode,c3.glcode as majorcode from egf_budgetgroup bg1 left outer join chartofaccounts c1 on c1.id=bg1.mincode left outer join chartofaccounts c2 on c2.id=bg1.maxcode left outer join chartofaccounts  c3 on c3.id=bg1.majorcode )  bg ");
        String voucherstatusExclude = ((AppConfigValues)list.get(0)).getValue();
        StringBuffer query = new StringBuffer();
        query = query.append("select bd.id as id,(SUM(gl.debitAmount)-SUM(gl.creditAmount)) as amount from egf_budgetdetail bd,generalledger gl,voucherheader vh,vouchermis vmis," + budgetGroupQuery + ",egf_budget b where bd.budget=b.id and vmis.VOUCHERHEADERID=vh.id and gl.VOUCHERHEADERID=vh.id and bd.budgetgroup=bg.id and " + "(bg.ACCOUNTTYPE='REVENUE_EXPENDITURE' or bg.ACCOUNTTYPE='CAPITAL_EXPENDITURE') and vh.status not in (" + voucherstatusExclude + ") and (vmis.budgetary_appnumber  != 'null' and vmis.budgetary_appnumber is not null) and " + "vh.voucherDate>= to_date('" + fromDate + "','dd/MM/yyyy') and vh.voucherDate <= to_date(" + toVoucherDate + ",'dd/MM/yyyy') " + miscQuery + " and (gl.glcode =bg.mincode or gl.glcode=bg.majorcode ) group by bd.id" + " union " + "select bd.id as id,(SUM(gl.creditAmount)-SUM(gl.debitAmount)) as amount from egf_budgetdetail bd,generalledger gl,voucherheader vh," + "vouchermis vmis," + budgetGroupQuery + ",egf_budget b where bd.budget=b.id and vmis.VOUCHERHEADERID=vh.id and gl.VOUCHERHEADERID=vh.id and bd.budgetgroup=bg.id and " + "(bg.ACCOUNTTYPE='REVENUE_RECEIPTS' or bg.ACCOUNTTYPE='CAPITAL_RECEIPTS') and vh.status not in (" + voucherstatusExclude + ") and (vmis.budgetary_appnumber  != 'null' and vmis.budgetary_appnumber is not null) and " + "vh.voucherDate>= to_date('" + fromDate + "','dd/MM/yyyy') and vh.voucherDate <= to_date(" + toVoucherDate + ",'dd/MM/yyyy') " + miscQuery + " and (gl.glcode = bg.mincode  or gl.glcode=bg.majorcode ) group by bd.id");
        List result = this.getSession().createSQLQuery(query.toString()).list();
        return result;
    }

    public List<Object[]> fetchActualsForBillWithParams(String fromDate, String toVoucherDate, StringBuffer miscQuery) {
        StringBuffer query = new StringBuffer();
        query = query.append("select bud,sum(amt) from (select bd.id as bud,SUM(case when bdetail.debitAmount = null then 0  else bdetail.debitAmount  end)-SUM(case when bdetail.creditAmount=null then 0 else bdetail.creditAmount end) as amt from egf_budgetdetail bd,eg_billdetails bdetail, eg_billregistermis bmis, eg_billregister br,egf_budgetgroup bg where bmis.billid=br.id and bdetail.billid=br.id and bd.budgetgroup=bg.id and (bg.ACCOUNTTYPE='REVENUE_EXPENDITURE' or bg.ACCOUNTTYPE='CAPITAL_EXPENDITURE') and br.statusid not in (select id from egw_status where description='Cancelled' and moduletype in ('EXPENSEBILL', 'SALBILL', 'WORKSBILL', 'PURCHBILL', 'CBILL', 'SBILL', 'CONTRACTORBILL'))  and bmis.voucherheaderid is null and br.billdate>=to_date('" + fromDate + "','dd/MM/yyyy') and br.billdate <= to_date(" + toVoucherDate + ",'dd/MM/yyyy') " + miscQuery + " and " + " (bmis.budgetCheckReq is null or bmis.budgetCheckReq=true) and " + "((bdetail.glcodeid between bg.mincode and bg.maxcode) or bdetail.glcodeid=bg.majorcode) group by bd.id" + " union " + "select bd.id as bud,SUM(case when bdetail.debitAmount = null then 0  else bdetail.debitAmount  end)-SUM(case when bdetail.creditAmount=null then 0 else bdetail.creditAmount end) as amt from egf_budgetdetail bd,eg_billdetails bdetail, eg_billregistermis bmis, eg_billregister br," + "egf_budgetgroup bg,voucherheader vh where bmis.billid=br.id and bdetail.billid=br.id and bd.budgetgroup=bg.id and " + "(bg.ACCOUNTTYPE='REVENUE_EXPENDITURE' or bg.ACCOUNTTYPE='CAPITAL_EXPENDITURE') and br.statusid not in (select id from egw_status where description='Cancelled' and moduletype in ('EXPENSEBILL', 'SALBILL', 'WORKSBILL', 'PURCHBILL', 'CBILL', 'SBILL', 'CONTRACTORBILL'))  and " + "bmis.voucherheaderid =vh.id and vh.status=4 and br.billdate>=to_date('" + fromDate + "','dd/MM/yyyy') and br.billdate <= to_date(" + toVoucherDate + ",'dd/MM/yyyy') " + miscQuery + " and " + " (bmis.budgetCheckReq is null or bmis.budgetCheckReq=true) and " + "((bdetail.glcodeid between bg.mincode and bg.maxcode) or bdetail.glcodeid=bg.majorcode) group by bd.id" + " union " + "select bd.id as bud,SUM(case when bdetail.creditAmount=null then 0 else bdetail.creditAmount end)-SUM(case when bdetail.debitAmount = null then 0  else bdetail.debitAmount  end) as amt from egf_budgetdetail bd,eg_billdetails bdetail, eg_billregistermis bmis, eg_billregister br," + "egf_budgetgroup bg,voucherheader vh where bmis.billid=br.id and bdetail.billid=br.id and bd.budgetgroup=bg.id and " + " (bmis.budgetCheckReq is null or bmis.budgetCheckReq=true) and " + "(bg.ACCOUNTTYPE='REVENUE_RECEIPTS' or bg.ACCOUNTTYPE='CAPITAL_RECEIPTS') and br.statusid not in (select id from egw_status where description='Cancelled' and moduletype in ('EXPENSEBILL', 'SALBILL', 'WORKSBILL', 'PURCHBILL', 'CBILL', 'SBILL', 'CONTRACTORBILL'))  and " + " bmis.voucherheaderid =vh.id and vh.status=4 and br.billdate>= to_date('" + fromDate + "','dd/MM/yyyy') and br.billdate <= to_date(" + toVoucherDate + ",'dd/MM/yyyy') " + miscQuery + " and ((bdetail.glcodeid between bg.mincode " + "and bg.maxcode) or bdetail.glcodeid=bg.majorcode) group by bd.id" + " union " + "select bd.id as bud,SUM(case when bdetail.creditAmount=null then 0 else bdetail.creditAmount end)-SUM(case when bdetail.debitAmount = null then 0  else bdetail.debitAmount  end) as amt from egf_budgetdetail bd,eg_billdetails bdetail, eg_billregistermis bmis, eg_billregister br," + "egf_budgetgroup bg where bmis.billid=br.id and bdetail.billid=br.id and bd.budgetgroup=bg.id and " + " (bmis.budgetCheckReq is null or bmis.budgetCheckReq=true) and " + "(bg.ACCOUNTTYPE='REVENUE_RECEIPTS' or bg.ACCOUNTTYPE='CAPITAL_RECEIPTS') and br.statusid not in (select id from egw_status where description='Cancelled' and moduletype in ('EXPENSEBILL', 'SALBILL', 'WORKSBILL', 'PURCHBILL', 'CBILL', 'SBILL', 'CONTRACTORBILL'))  and bmis.voucherheaderid " + "is null and br.billdate>= to_date('" + fromDate + "','dd/MM/yyyy') and br.billdate <= to_date(" + toVoucherDate + ",'dd/MM/yyyy') " + miscQuery + " and ((bdetail.glcodeid between bg.mincode " + "and bg.maxcode) or bdetail.glcodeid=bg.majorcode) group by bd.id" + " ) group by bud ");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(" Main Query :" + query));
        }
        List result = this.getSession().createSQLQuery(query.toString()).list();
        return result;
    }

    public List<Object[]> fetchActualsForBillWithVouchersParams(String fromDate, String toVoucherDate, StringBuffer miscQuery) {
        StringBuffer query = new StringBuffer();
        query = query.append("select bd.id as bud,SUM(case when bdetail.debitAmount is null then 0  else bdetail.debitAmount  end)   -SUM(case when bdetail.creditAmount is null then 0 else bdetail.creditAmount end)   as amt from egf_budgetdetail bd,eg_billdetails bdetail, eg_billregistermis bmis, eg_billregister br,egf_budgetgroup bg,voucherheader vh, vouchermis vmis where bmis.billid=br.id and bdetail.billid=br.id and bd.budgetgroup=bg.id and (bg.ACCOUNTTYPE='REVENUE_EXPENDITURE' or bg.ACCOUNTTYPE='CAPITAL_EXPENDITURE') and br.statusid not in (select id from egw_status where description='Cancelled' and moduletype in ('EXPENSEBILL', 'SALBILL', 'WORKSBILL', 'PURCHBILL', 'CBILL', 'SBILL', 'CONTRACTORBILL'))  and bmis.voucherheaderid =vh.id and vh.status!=4 and br.billdate>=to_date('" + fromDate + "','dd/MM/yyyy') and br.billdate <= to_date(" + toVoucherDate + ",'dd/MM/yyyy') " + miscQuery + " and (bmis.budgetCheckReq is null or bmis.budgetCheckReq=true) and vh.id = vmis.voucherheaderid and (bmis.budgetary_appnumber != 'null' and bmis.budgetary_appnumber is not null) " + " and ((bdetail.glcodeid between bg.mincode  and bg.maxcode ) or bdetail.glcodeid=bg.majorcode ) group by bd.id" + " UNION " + "select bd.id as bud,SUM(case when bdetail.creditAmount is null then 0 else bdetail.creditAmount end)-SUM(case when bdetail.debitAmount is null then 0  else bdetail.debitAmount  end) as amt from egf_budgetdetail bd,eg_billdetails bdetail, eg_billregistermis bmis, eg_billregister br," + "egf_budgetgroup bg,voucherheader vh, vouchermis vmis where bmis.billid=br.id and bdetail.billid=br.id and bd.budgetgroup=bg.id and " + " (bmis.budgetCheckReq is null or bmis.budgetCheckReq=true) and vh.id = vmis.voucherheaderid and (bmis.budgetary_appnumber != 'null' and bmis.budgetary_appnumber is not null) " + " and (bg.ACCOUNTTYPE='REVENUE_RECEIPTS' or bg.ACCOUNTTYPE='CAPITAL_RECEIPTS') and br.statusid not in (select id as idd from egw_status where description='Cancelled' and moduletype in ('EXPENSEBILL', 'SALBILL', 'WORKSBILL', 'PURCHBILL', 'CBILL', 'SBILL', 'CONTRACTORBILL'))  and " + " bmis.voucherheaderid =vh.id and vh.status!=4 and br.billdate>= to_date('" + fromDate + "','dd/MM/yyyy') and br.billdate <= to_date(" + toVoucherDate + ",'dd/MM/yyyy') " + miscQuery + " and ((bdetail.glcodeid between bg.mincode and bg.maxcode ) or bdetail.glcodeid=bg.majorcode  ) group by bd.id" + " UNION " + " select bd.id as bud,SUM(case when bdetail.debitAmount is null then 0  else bdetail.debitAmount  end)   -SUM(case when bdetail.creditAmount is null then 0 else bdetail.creditAmount end)   as amt " + " from egf_budgetdetail bd,eg_billdetails bdetail, eg_billregister br,egf_budgetgroup bg, eg_billregistermis bmis left outer join voucherheader vh on vh.id=bmis.voucherheaderid " + " where bmis.billid=br.id and bdetail.billid=br.id and bd.budgetgroup=bg.id and " + "(bg.ACCOUNTTYPE='REVENUE_EXPENDITURE' or bg.ACCOUNTTYPE='CAPITAL_EXPENDITURE') and br.statusid not in (select id from egw_status where description='Cancelled' and moduletype in ('EXPENSEBILL', 'SALBILL', 'WORKSBILL', 'PURCHBILL', 'CBILL', 'SBILL', 'CONTRACTORBILL'))  and " + "(bmis.voucherheaderid is NULL or vh.status=4) and  br.billdate>=to_date('" + fromDate + "','dd/MM/yyyy') and br.billdate <= to_date(" + toVoucherDate + ",'dd/MM/yyyy') " + miscQuery + " and (bmis.budgetCheckReq is null or bmis.budgetCheckReq=true) and (bmis.budgetary_appnumber != 'null' and bmis.budgetary_appnumber is not null) " + " and ((bdetail.glcodeid between bg.mincode  and bg.maxcode ) or bdetail.glcodeid=bg.majorcode ) group by bd.id" + " UNION " + "select bd.id as bud,SUM(case when bdetail.creditAmount is null then 0 else bdetail.creditAmount end)-SUM(case when bdetail.debitAmount is null then 0  else bdetail.debitAmount  end) as amt" + " from egf_budgetdetail bd,eg_billdetails bdetail, egf_budgetgroup bg, eg_billregister br,eg_billregistermis bmis  left outer join voucherheader vh on vh.id=bmis.voucherheaderid " + " where bmis.billid=br.id and bdetail.billid=br.id and bd.budgetgroup=bg.id and " + " (bmis.budgetCheckReq is null or bmis.budgetCheckReq=true) and (bmis.budgetary_appnumber != 'null' and bmis.budgetary_appnumber is not null) " + " and (bg.ACCOUNTTYPE='REVENUE_RECEIPTS' or bg.ACCOUNTTYPE='CAPITAL_RECEIPTS') and br.statusid not in (select id as idd from egw_status where description='Cancelled' and moduletype in ('EXPENSEBILL', 'SALBILL', 'WORKSBILL', 'PURCHBILL', 'CBILL', 'SBILL', 'CONTRACTORBILL'))  and " + " (bmis.voucherheaderid is NULL or vh.status=4)  and  br.billdate>= to_date('" + fromDate + "','dd/MM/yyyy') and br.billdate <= to_date(" + toVoucherDate + ",'dd/MM/yyyy') " + miscQuery + " and ((bdetail.glcodeid between bg.mincode and bg.maxcode ) or bdetail.glcodeid=bg.majorcode  ) group by bd.id");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(" Main Query :" + query));
        }
        List result = this.getSession().createSQLQuery(query.toString()).list();
        return result;
    }

    private StringBuffer getMiscQuery(List<String> mandatoryFields, String mis, String gl, String detail) {
        StringBuffer miscQuery = new StringBuffer();
        if (mandatoryFields.contains("field")) {
            miscQuery = miscQuery.append(" and " + mis + ".divisionid=bd.boundary ");
        }
        if (mandatoryFields.contains("fund")) {
            miscQuery = miscQuery.append(" and " + detail + ".fundId=bd.fund ");
        }
        if (mandatoryFields.contains("scheme")) {
            miscQuery = miscQuery.append(" and " + mis + ".schemeid=bd.scheme ");
        }
        if (mandatoryFields.contains("subScheme")) {
            miscQuery = miscQuery.append(" and " + mis + ".subschemeid=bd.subscheme ");
        }
        if (mandatoryFields.contains("functionary")) {
            miscQuery = miscQuery.append(" and " + mis + ".functionaryid=bd.functionary ");
        }
        if (mandatoryFields.contains("function")) {
            miscQuery = miscQuery.append(" and " + gl + ".functionId=bd.function ");
        }
        if (mandatoryFields.contains("executingDepartment")) {
            miscQuery = miscQuery.append(" and " + mis + ".departmentid=bd.executing_department ");
        }
        return miscQuery;
    }

    public PersonalInformation getEmpForCurrentUser() {
        return this.eisCommonService.getEmployeeByUserId(ApplicationThreadLocals.getUserId());
    }

    public void setBudgetDetailWorkflowService(WorkflowService<BudgetDetail> budgetDetailWorkflowService) {
        this.budgetDetailWorkflowService = budgetDetailWorkflowService;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public void setScriptExecutionService(ScriptService scriptService) {
    }

    public boolean toBeConsolidated() {
        String[] functionaryDesignationObj;
        Assignment empAssignment = this.eisCommonService.getLatestAssignmentForEmployeeByToDate(ApplicationThreadLocals.getUserId(), new Date());
        Functionary empfunctionary = empAssignment.getFunctionary();
        Designation designation = empAssignment.getDesignation();
        Boolean consolidateBudget = Boolean.FALSE;
        List list = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "budget_toplevel_approver_designation");
        if (list.isEmpty()) {
            throw new ValidationException("", "budget_toplevel_approver_designation is not defined in AppConfig", new String[0]);
        }
        List list2 = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "budget_secondlevel_approver_designation");
        if (list2.isEmpty()) {
            throw new ValidationException("", "budget_secondlevel_approver_designation is not defined in AppConfig", new String[0]);
        }
        for (String strObj : functionaryDesignationObj = ((AppConfigValues)list2.get(0)).getValue().split(",")) {
            if (strObj.contains(":")) {
                String[] functionaryName = strObj.split(":");
                if (empfunctionary == null || !empfunctionary.getName().equalsIgnoreCase(functionaryName[0])) continue;
                consolidateBudget = Boolean.TRUE;
                break;
            }
            if (designation.getName().equalsIgnoreCase(strObj)) {
                consolidateBudget = Boolean.TRUE;
                break;
            }
            consolidateBudget = Boolean.FALSE;
        }
        return consolidateBudget;
    }

    @Transactional
    public List<BudgetUpload> loadBudget(List<BudgetUpload> budgetUploadList, CFinancialYear reFYear, CFinancialYear beFYear) {
        try {
            Budget budget = this.budgetService.getByName("RE-" + reFYear.getFinYearRange());
            if (budget == null) {
                TreeSet<String> deptSet = new TreeSet<String>();
                ArrayList<String> deptList = new ArrayList<String>();
                List departments = this.departmentService.getAllDepartments();
                for (Department dept : departments) {
                    deptSet.add(dept.getCode());
                }
                deptList.addAll(deptSet);
                EgwStatus budgetStatus = this.egwStatusDAO.getStatusByModuleAndCode("BUDGET", "Created");
                this.createRootBudget(RE, beFYear, reFYear, deptList, budgetStatus);
                this.createRootBudget(BE, beFYear, reFYear, deptList, budgetStatus);
            }
            EgwStatus budgetDetailStatus = this.egwStatusDAO.getStatusByModuleAndCode("BUDGETDETAIL", "Created");
            budgetUploadList = this.createBudgetDetails(RE, budgetUploadList, reFYear, budgetDetailStatus);
            budgetUploadList = this.createBudgetDetails(BE, budgetUploadList, beFYear, budgetDetailStatus);
        }
        catch (SQLException e) {
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
        catch (ValidationException e) {
            throw new ValidationException(Arrays.asList(new ValidationError(((ValidationError)e.getErrors().get(0)).getMessage(), ((ValidationError)e.getErrors().get(0)).getMessage())));
        }
        catch (Exception e) {
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
        return budgetUploadList;
    }

    @Transactional
    public List<BudgetUpload> createBudgetDetails(String budgetType, List<BudgetUpload> budgetUploadList, CFinancialYear fyear, EgwStatus status) {
        ArrayList<BudgetUpload> tempList = new ArrayList<BudgetUpload>();
        try {
            for (BudgetUpload budgetUpload : budgetUploadList) {
                BudgetDetail budgetDetail = new BudgetDetail();
                BudgetDetail temp = this.getBudgetDetail(budgetUpload.getFund().getId(), budgetUpload.getFunction().getId(), budgetUpload.getDept().getId(), budgetUpload.getCoa().getId(), fyear, budgetType);
                if (temp != null) {
                    if (temp.getStatus().getCode().equalsIgnoreCase("Created")) {
                        BigDecimal amount = budgetType.equalsIgnoreCase(RE) ? budgetUpload.getReAmount() : budgetUpload.getBeAmount();
                        if (amount.compareTo(temp.getApprovedAmount()) != 0) {
                            temp.setApprovedAmount(amount);
                            temp.setOriginalAmount(amount);
                            temp.setBudgetAvailable(temp.getApprovedAmount().multiply(temp.getPlanningPercent()).divide(new BigDecimal(String.valueOf(100))));
                            this.applyAuditing((AbstractAuditable)temp);
                            budgetDetail = (BudgetDetail)((Object)this.update((Object)temp));
                            budgetUpload.setFinalStatus("Success");
                            tempList.add(budgetUpload);
                            continue;
                        }
                        budgetUpload.setFinalStatus("Already budget is defined for this combination");
                        tempList.add(budgetUpload);
                        continue;
                    }
                    budgetUpload.setFinalStatus("Already budget is defined for this combination and Approved");
                    tempList.add(budgetUpload);
                    continue;
                }
                if (temp != null) continue;
                budgetDetail.setFund(budgetUpload.getFund());
                budgetDetail.setFunction(budgetUpload.getFunction());
                budgetDetail.setExecutingDepartment(budgetUpload.getDept());
                budgetDetail.setAnticipatoryAmount(BigDecimal.ZERO);
                budgetDetail.setPlanningPercent(BigDecimal.valueOf(budgetUpload.getPlanningPercentage()));
                if (budgetType.equalsIgnoreCase(RE)) {
                    budgetDetail.setOriginalAmount(budgetUpload.getReAmount());
                    budgetDetail.setApprovedAmount(budgetUpload.getReAmount());
                    budgetDetail.setBudgetAvailable(budgetUpload.getReAmount().multiply(budgetDetail.getPlanningPercent()).divide(new BigDecimal(String.valueOf(100))));
                } else {
                    budgetDetail.setOriginalAmount(budgetUpload.getBeAmount());
                    budgetDetail.setApprovedAmount(budgetUpload.getBeAmount());
                    budgetDetail.setBudgetAvailable(budgetUpload.getBeAmount().multiply(budgetDetail.getPlanningPercent()).divide(new BigDecimal(String.valueOf(100))));
                }
                budgetDetail.setBudgetGroup(this.createBudgetGroup(budgetUpload.getCoa()));
                budgetDetail.setBudget(this.budgetService.getBudget(budgetUpload.getBudgetHead(), budgetUpload.getDeptCode(), budgetType, fyear.getFinYearRange()));
                budgetDetail.setMaterializedPath(this.getmaterializedpathforbudget(budgetDetail.getBudget()));
                budgetDetail.setStatus(status);
                this.applyAuditing((AbstractAuditable)budgetDetail);
                this.persist(budgetDetail);
                budgetUpload.setFinalStatus("Success");
                tempList.add(budgetUpload);
            }
        }
        catch (ValidationException e) {
            throw new ValidationException(Arrays.asList(new ValidationError(((ValidationError)e.getErrors().get(0)).getMessage(), ((ValidationError)e.getErrors().get(0)).getMessage())));
        }
        catch (Exception e) {
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
        return tempList;
    }

    @Transactional
    public BudgetDetail setBudgetDetailStatus(BudgetDetail budgetDetail) {
        Object sequenceNumber = null;
        State budgetDetailState = null;
        try {
            sequenceNumber = this.sequenceNumberGenerator.getNextSequence("seq_eg_wf_states");
        }
        catch (SQLGrammarException sQLGrammarException) {
            // empty catch block
        }
        Long stateId = Long.valueOf(sequenceNumber.toString());
        this.persistenceService.getSession().createSQLQuery(BUDGETDETAIL_STATES_INSERT).setLong("stateId", stateId.longValue()).executeUpdate();
        budgetDetailState = (State)this.persistenceService.find("from State where id = ?", new Object[]{stateId});
        budgetDetail.setWfState(budgetDetailState);
        return budgetDetail;
    }

    private String getmaterializedpathforbudget(Budget budget) {
        return budget.getMaterializedPath() + "." + (this.getCountByBudget(budget.getId()) + 1L);
    }

    @Transactional
    public BudgetGroup createBudgetGroup(CChartOfAccounts coa) {
        BudgetGroup budgetGroup = this.budgetGroupService.getBudgetGroup(coa.getId());
        try {
            Object sequenceNumber = null;
            try {
                sequenceNumber = this.sequenceNumberGenerator.getNextSequence("seq_egf_budgetgroup");
            }
            catch (SQLGrammarException sQLGrammarException) {
                // empty catch block
            }
            Long.valueOf(sequenceNumber.toString());
            if (budgetGroup == null) {
                budgetGroup = new BudgetGroup();
                budgetGroup.setName(coa.getGlcode() + "-" + coa.getName());
                budgetGroup.setDescription(coa.getName());
                budgetGroup.setIsActive(true);
                if (coa.getType().compareTo(Character.valueOf('E')) == 0) {
                    budgetGroup.setAccountType(BudgetAccountType.REVENUE_EXPENDITURE);
                    budgetGroup.setBudgetingType(BudgetingType.DEBIT);
                } else if (coa.getType().compareTo(Character.valueOf('A')) == 0) {
                    budgetGroup.setAccountType(BudgetAccountType.CAPITAL_EXPENDITURE);
                    budgetGroup.setBudgetingType(BudgetingType.DEBIT);
                } else if (coa.getType().compareTo(Character.valueOf('L')) == 0) {
                    budgetGroup.setAccountType(BudgetAccountType.CAPITAL_RECEIPTS);
                    budgetGroup.setBudgetingType(BudgetingType.CREDIT);
                } else if (coa.getType().compareTo(Character.valueOf('I')) == 0) {
                    budgetGroup.setAccountType(BudgetAccountType.REVENUE_RECEIPTS);
                    budgetGroup.setBudgetingType(BudgetingType.CREDIT);
                }
                if (coa.getClassification().compareTo(1L) == 0 || coa.getClassification().compareTo(2L) == 0 || coa.getClassification().compareTo(4L) == 0) {
                    budgetGroup.setMinCode(coa);
                    budgetGroup.setMaxCode(coa);
                }
                budgetGroup.setMajorCode(null);
                this.budgetGroupService.applyAuditing(budgetGroup);
                budgetGroup = (BudgetGroup)((Object)this.budgetGroupService.persist((Object)budgetGroup));
                if (coa.getType().compareTo(Character.valueOf('E')) == 0 || coa.getType().compareTo(Character.valueOf('A')) == 0) {
                    coa.setBudgetCheckReq(Boolean.valueOf(true));
                    coa = (CChartOfAccounts)this.chartOfAccountsService.update((Object)coa);
                }
            }
        }
        catch (ValidationException e) {
            throw new ValidationException(Arrays.asList(new ValidationError(((ValidationError)e.getErrors().get(0)).getMessage(), ((ValidationError)e.getErrors().get(0)).getMessage())));
        }
        catch (Exception e) {
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
        return budgetGroup;
    }

    @Transactional
    public void createRootBudget(String budgetType, CFinancialYear beFYear, CFinancialYear reFYear, List<String> deptList, EgwStatus status) throws SQLException {
        Budget budget = new Budget();
        try {
            CFinancialYear budgetFinancialYear;
            String budgetDes;
            String budgetName;
            if (budgetType.equalsIgnoreCase(BE)) {
                budgetName = budgetType + "-" + beFYear.getFinYearRange();
                budgetDes = "Budget - " + budgetType + " for the year " + beFYear.getFinYearRange();
                budgetFinancialYear = beFYear;
            } else {
                budgetName = budgetType + "-" + reFYear.getFinYearRange();
                budgetDes = "Budget - " + budgetType + " for the year " + reFYear.getFinYearRange();
                budgetFinancialYear = reFYear;
            }
            String rootmaterial = this.getNewRootMaterializedPath();
            if (budgetType.equalsIgnoreCase(BE)) {
                Budget refBudget = this.budgetService.getByName("RE-" + reFYear.getFinYearRange());
                budget.setName(budgetName);
                budget.setIsActiveBudget(true);
                budget.setIsPrimaryBudget(true);
                budget.setDescription(budgetDes);
                budget.setFinancialYear(budgetFinancialYear);
                budget.setIsbere(budgetType);
                budget.setMaterializedPath(rootmaterial);
                budget.setReferenceBudget(refBudget);
                this.budgetService.applyAuditing((AbstractAuditable)budget);
                budget.setStatus(status);
                budget = (Budget)((Object)this.budgetService.persist((Object)budget));
            } else {
                budget.setName(budgetName);
                budget.setDescription(budgetDes);
                budget.setIsActiveBudget(true);
                budget.setIsPrimaryBudget(true);
                budget.setFinancialYear(budgetFinancialYear);
                budget.setIsbere(budgetType);
                budget.setMaterializedPath(rootmaterial);
                this.budgetService.applyAuditing((AbstractAuditable)budget);
                budget.setStatus(status);
                budget = (Budget)((Object)this.budgetService.persist((Object)budget));
            }
            this.createCapitalOrRevenueBudget(budget, "Capital", rootmaterial + ".1", budgetType, beFYear, reFYear, deptList, status);
            this.createCapitalOrRevenueBudget(budget, "Revenue", rootmaterial + ".2", budgetType, beFYear, reFYear, deptList, status);
        }
        catch (ValidationException e) {
            throw new ValidationException(Arrays.asList(new ValidationError(((ValidationError)e.getErrors().get(0)).getMessage(), ((ValidationError)e.getErrors().get(0)).getMessage())));
        }
        catch (Exception e) {
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
    }

    private String getNewRootMaterializedPath() {
        SQLQuery query = this.persistenceService.getSession().createSQLQuery("select count(*)+1 from egf_budget where parent is null");
        String rootmaterial = query.uniqueResult().toString();
        return rootmaterial;
    }

    @Transactional
    public Budget setBudgetState(Budget budget) {
        Long stateId;
        Serializable sequenceNumber = null;
        try {
            sequenceNumber = this.sequenceNumberGenerator.getNextSequence("seq_eg_wf_states");
            stateId = Long.valueOf(sequenceNumber.toString());
        }
        catch (SQLGrammarException e) {
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
        this.persistenceService.getSession().createSQLQuery(BUDGET_STATES_INSERT).setLong("stateId", stateId.longValue()).executeUpdate();
        State budgetState = (State)this.persistenceService.find("from State where id = ?", new Object[]{stateId});
        budget.setWfState(budgetState);
        return budget;
    }

    @Transactional
    public void createCapitalOrRevenueBudget(Budget parent, String capitalOrRevenue, String rootmaterial, String budgetType, CFinancialYear beFYear, CFinancialYear reFYear, List<String> deptList, EgwStatus status) throws SQLException {
        Budget budget = new Budget();
        try {
            CFinancialYear budgetFinancialYear;
            String budgetDes;
            String budgetName;
            if (budgetType.equalsIgnoreCase(BE)) {
                budgetName = capitalOrRevenue + "-" + budgetType + "-" + beFYear.getFinYearRange();
                budgetDes = capitalOrRevenue + " Budget - " + budgetType + " for the year " + beFYear.getFinYearRange();
                budgetFinancialYear = beFYear;
            } else {
                budgetName = capitalOrRevenue + "-" + budgetType + "-" + reFYear.getFinYearRange();
                budgetDes = capitalOrRevenue + " Budget - " + budgetType + " for the year " + reFYear.getFinYearRange();
                budgetFinancialYear = reFYear;
            }
            if (budgetType.equalsIgnoreCase(BE)) {
                Budget refBudget = this.budgetService.getByName(capitalOrRevenue + "-RE-" + reFYear.getFinYearRange());
                budget.setName(budgetName);
                budget.setDescription(budgetDes);
                budget.setFinancialYear(budgetFinancialYear);
                budget.setIsActiveBudget(true);
                budget.setIsPrimaryBudget(true);
                budget.setStatus(status);
                budget.setIsbere(budgetType);
                budget.setMaterializedPath(rootmaterial);
                budget.setReferenceBudget(refBudget);
                budget.setParent(parent);
                this.budgetService.applyAuditing((AbstractAuditable)budget);
                budget = (Budget)((Object)this.budgetService.persist((Object)budget));
            } else {
                budget.setName(budgetName);
                budget.setDescription(budgetDes);
                budget.setFinancialYear(budgetFinancialYear);
                budget.setIsActiveBudget(true);
                budget.setIsPrimaryBudget(true);
                budget.setStatus(status);
                budget.setIsbere(budgetType);
                budget.setMaterializedPath(rootmaterial);
                budget.setParent(parent);
                this.budgetService.applyAuditing((AbstractAuditable)budget);
                budget = (Budget)((Object)this.budgetService.persist((Object)budget));
            }
            this.createDeptBudgetHeads(budget, capitalOrRevenue, budgetType, beFYear, reFYear, capitalOrRevenue.substring(0, 3), deptList, status);
        }
        catch (ValidationException e) {
            throw new ValidationException(Arrays.asList(new ValidationError(((ValidationError)e.getErrors().get(0)).getMessage(), ((ValidationError)e.getErrors().get(0)).getMessage())));
        }
        catch (Exception e) {
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
    }

    @Transactional
    public void createDeptBudgetHeads(Budget parent, String capitalOrRevenue, String budgetType, CFinancialYear beFYear, CFinancialYear reFYear, String revOrCap, List<String> deptList, EgwStatus status) throws SQLException {
        String rootmaterial;
        String materialPath = rootmaterial = parent.getMaterializedPath() + ".";
        try {
            Query query = this.persistenceService.getSession().createSQLQuery("select count(*)+1 from egf_budget c,egf_budget p where c.parent = p.id and p.name = :parentName").setString("parentName", parent.getName());
            String count = query.uniqueResult().toString();
            Integer capOrRevCount = Integer.valueOf(count);
            for (String deptCode : deptList) {
                CFinancialYear budgetFinancialYear;
                String budgetDes;
                String budgetName;
                Budget budget = new Budget();
                if (budgetType.equalsIgnoreCase(BE)) {
                    budgetName = deptCode + "-" + budgetType + "-" + revOrCap + "-" + beFYear.getFinYearRange();
                    budgetDes = this.departmentService.getDepartmentByCode(deptCode).getName() + " " + budgetType + " " + capitalOrRevenue + "Budget for the year " + beFYear.getFinYearRange();
                    budgetFinancialYear = beFYear;
                } else {
                    budgetName = deptCode + "-" + budgetType + "-" + revOrCap + "-" + reFYear.getFinYearRange();
                    budgetDes = this.departmentService.getDepartmentByCode(deptCode).getName() + " " + budgetType + " " + capitalOrRevenue + "Budget for the year " + reFYear.getFinYearRange();
                    budgetFinancialYear = reFYear;
                }
                if (this.budgetService.getByName(budgetName) != null) continue;
                Integer n = capOrRevCount;
                Integer n2 = capOrRevCount = Integer.valueOf(capOrRevCount + 1);
                materialPath = rootmaterial + n;
                if (budgetType.equalsIgnoreCase(BE)) {
                    Budget refBudget = this.budgetService.getByName(deptCode + "-RE-" + revOrCap + "-" + reFYear.getFinYearRange());
                    budget.setName(budgetName);
                    budget.setDescription(budgetDes);
                    budget.setFinancialYear(budgetFinancialYear);
                    budget.setIsActiveBudget(true);
                    budget.setIsPrimaryBudget(true);
                    budget.setStatus(status);
                    budget.setIsbere(budgetType);
                    budget.setMaterializedPath(materialPath);
                    budget.setReferenceBudget(refBudget);
                    budget.setParent(parent);
                    this.budgetService.applyAuditing((AbstractAuditable)budget);
                    budget = (Budget)((Object)this.budgetService.persist((Object)budget));
                    continue;
                }
                budget.setName(budgetName);
                budget.setDescription(budgetDes);
                budget.setFinancialYear(budgetFinancialYear);
                budget.setIsActiveBudget(true);
                budget.setIsPrimaryBudget(true);
                budget.setStatus(status);
                budget.setIsbere(budgetType);
                budget.setMaterializedPath(materialPath);
                budget.setParent(parent);
                this.budgetService.applyAuditing((AbstractAuditable)budget);
                budget = (Budget)((Object)this.budgetService.persist((Object)budget));
            }
        }
        catch (ValidationException e) {
            throw new ValidationException(Arrays.asList(new ValidationError(((ValidationError)e.getErrors().get(0)).getMessage(), ((ValidationError)e.getErrors().get(0)).getMessage())));
        }
        catch (Exception e) {
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
    }

    public BudgetDetail getBudgetDetail(Integer fundId, Long functionId, Long deptId, Long glCodeId, CFinancialYear fYear, String budgetType) {
        return (BudgetDetail)((Object)this.find("from BudgetDetail bd where bd.fund.id = ? and bd.function.id = ? and bd.executingDepartment.id = ? and bd.budgetGroup.maxCode.id = ? and bd.budget.financialYear.id = ? and bd.budget.isbere = ?", new Object[]{fundId, functionId, deptId, glCodeId, fYear.getId(), budgetType}));
    }

    public BudgetDetail getBudgetDetail(Integer fundId, Long functionId, Long deptId, Long budgetGroupId) {
        return (BudgetDetail)((Object)this.find("from BudgetDetail bd where bd.fund.id = ? and bd.function.id = ? and bd.executingDepartment.id = ? and bd.budgetGroup.id= ?", new Object[]{fundId, functionId, deptId, budgetGroupId}));
    }

    public List<BudgetDetail> getDepartmentFromBudgetDetailByFundId(Integer fundId) {
        Criteria criteria = this.getSession().createCriteria(BudgetDetail.class);
        return criteria.add((Criterion)Restrictions.eq((String)"fund.id", (Object)fundId)).setProjection(Projections.distinct((Projection)Projections.property((String)"executingDepartment"))).addOrder(Order.asc((String)"executingDepartment")).list();
    }

    public List<BudgetDetail> getFunctionFromBudgetDetailByDepartmentId(Long departmentId) {
        Criteria criteria = this.getSession().createCriteria(BudgetDetail.class);
        return criteria.add((Criterion)Restrictions.eq((String)"executingDepartment.id", (Object)departmentId)).setProjection(Projections.distinct((Projection)Projections.property((String)"function"))).addOrder(Order.asc((String)"function")).list();
    }

    public List<BudgetDetail> getBudgetDetailByFunctionId(Long functionId) {
        Criteria criteria = this.getSession().createCriteria(BudgetDetail.class);
        return criteria.add((Criterion)Restrictions.eq((String)"function.id", (Object)functionId)).setProjection(Projections.distinct((Projection)Projections.property((String)"budgetGroup"))).addOrder(Order.asc((String)"budgetGroup")).list();
    }

    @Transactional
    public void updateByMaterializedPath(String materializedPath) {
        EgwStatus approvedStatus = this.egwStatusDAO.getStatusByModuleAndCode("BUDGETDETAIL", "Approved");
        EgwStatus createdStatus = this.egwStatusDAO.getStatusByModuleAndCode("BUDGETDETAIL", "Created");
        this.persistenceService.getSession().createSQLQuery("update egf_budgetdetail  set status = :approvedStatus where status =:createdStatus and  materializedPath like'" + materializedPath + "%'").setLong("approvedStatus", (long)approvedStatus.getId().intValue()).setLong("createdStatus", (long)createdStatus.getId().intValue()).executeUpdate();
    }

    public List<BudgetDetail> sortByDepartmentName(List<BudgetDetail> budgetDetails) {
        Collections.sort(budgetDetails, (o1, o2) -> o1.getExecutingDepartment().getName().toUpperCase().compareTo(o2.getExecutingDepartment().getName().toUpperCase()));
        return budgetDetails;
    }

    public Assignment getWorkflowInitiator(BudgetDetail budgetDetail) {
        return (Assignment)this.assignmentService.findByEmployeeAndGivenDate(budgetDetail.getCreatedBy().getId(), new Date()).get(0);
    }

    @Transactional
    public BudgetDetail transitionWorkFlow(BudgetDetail budgetDetail, WorkflowBean workflowBean) {
        User user = this.securityUtils.getCurrentUser();
        Assignment userAssignment = (Assignment)this.assignmentService.findByEmployeeAndGivenDate(user.getId(), new Date()).get(0);
        Position pos = null;
        Object wfInitiator = null;
        if (budgetDetail.getId() != null && budgetDetail.getId() != 0L) {
            wfInitiator = this.getWorkflowInitiator(budgetDetail);
        }
        if ("Reject".equalsIgnoreCase(workflowBean.getWorkFlowAction())) {
            if (wfInitiator.equals(userAssignment)) {
                budgetDetail.transition(true).end().withSenderName(user.getName()).withComments(workflowBean.getApproverComments()).withDateInfo(new Date());
            } else {
                String stateValue = "Rejected";
                budgetDetail.transition(true).withSenderName(user.getName()).withComments(workflowBean.getApproverComments()).withStateValue("Rejected").withDateInfo(new Date()).withOwner(wfInitiator.getPosition()).withNextAction("EOA Approval Pending");
            }
        } else if ("Verify".equalsIgnoreCase(workflowBean.getWorkFlowAction())) {
            budgetDetail.transition(true).withSenderName(user.getName()).withComments(workflowBean.getApproverComments()).withStateValue(" Approved").withDateInfo(new Date()).withOwner(pos);
            budgetDetail.transition(true).end().withSenderName(user.getName()).withComments(workflowBean.getApproverComments()).withDateInfo(new Date());
            budgetDetail.setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("BUDGETDETAIL", "VERIFIED"));
        } else if ("Cancel".equalsIgnoreCase(workflowBean.getWorkFlowAction())) {
            budgetDetail.setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("BUDGETDETAIL", "Cancelled"));
            budgetDetail.transition(true).end().withStateValue("Cancelled").withSenderName(user.getName()).withComments(workflowBean.getApproverComments()).withDateInfo(new Date());
        } else if ("Save".equalsIgnoreCase(workflowBean.getWorkFlowAction())) {
            if (budgetDetail.getState() == null) {
                budgetDetail.transition().start().withSenderName(user.getName()).withComments(workflowBean.getApproverComments()).withStateValue("NEW").withDateInfo(new Date()).withOwner(userAssignment.getPosition());
                budgetDetail.setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("BUDGETDETAIL", "NEW"));
            }
        } else {
            if (null != workflowBean.getApproverPositionId() && workflowBean.getApproverPositionId() != -1L) {
                pos = (Position)this.persistenceService.find("from Position where id=?", new Object[]{workflowBean.getApproverPositionId()});
            }
            if (null == budgetDetail.getState()) {
                budgetDetail.transition().start().withSenderName(user.getName()).withComments(workflowBean.getApproverComments()).withStateValue("Created").withDateInfo(new Date()).withOwner(pos);
                budgetDetail.setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("BUDGETDETAIL", "Created"));
            } else if (budgetDetail.getCurrentState().getNextAction() != null && budgetDetail.getCurrentState().getNextAction().equalsIgnoreCase("END")) {
                budgetDetail.transition(true).end().withSenderName(user.getName()).withComments(workflowBean.getApproverComments()).withDateInfo(new Date());
            } else {
                budgetDetail.transition(true).withSenderName(user.getName()).withComments(workflowBean.getApproverComments()).withStateValue("Created").withDateInfo(new Date()).withOwner(pos);
            }
        }
        return budgetDetail;
    }

    @Transactional
    public BudgetDetail rejectWorkFlow(BudgetDetail budgetDetail, String comment) {
        DateTime currentDate = new DateTime();
        User user = this.securityUtils.getCurrentUser();
        Assignment wfInitiator = new Assignment();
        if (budgetDetail.getId() != null && budgetDetail.getId() != 0L) {
            wfInitiator = this.getWorkflowInitiator(budgetDetail);
        }
        String stateValue = "Rejected";
        budgetDetail.transition(true).withSenderName(user.getName()).withStateValue("Rejected").withComments(comment).withDateInfo(currentDate.toDate()).withOwner(wfInitiator.getPosition()).withNextAction("EOA Approval Pending");
        this.applyAuditing((AbstractAuditable)budgetDetail.getState());
        return budgetDetail;
    }

    public List<Long> getBudgetIdList() {
        String query = "select distinct bd.budget.id from BudgetDetail bd ";
        List budgetDetailsList = this.persistenceService.getSession().createQuery("select distinct bd.budget.id from BudgetDetail bd ").list();
        return budgetDetailsList;
    }

    public List<BudgetDetail> getBudgetDetailsByBudgetGroupId(Long budgetGroupId) {
        Query qry = this.getCurrentSession().createQuery("from BudgetDetail where budgetGroup.id=:budgetGroupId");
        qry.setLong("budgetGroupId", budgetGroupId.longValue());
        List budgetDetails = null;
        budgetDetails = !qry.list().isEmpty() ? qry.list() : Collections.emptyList();
        return budgetDetails;
    }

    public List<BudgetDetail> getBudgetDetailsByBudgetId(Long budgetId) {
        Query qry = this.getCurrentSession().createQuery("from BudgetDetail where budget.id=:budgetId");
        qry.setLong("budgetId", budgetId.longValue());
        List budgetDetails = null;
        budgetDetails = !qry.list().isEmpty() ? qry.list() : Collections.emptyList();
        return budgetDetails;
    }

    public List<Budget> getBudgetByStatusAndFinancialYearId(Integer statusId, Long financialYearId) {
        Query qry = this.getCurrentSession().createQuery("select distinct budgetDetail.budget from BudgetDetail budgetDetail where budgetDetail.status.id=:statusId and budgetDetail.budget.id in(select id from Budget where financialYear.id=:financialYearId)");
        qry.setInteger("statusId", statusId.intValue());
        qry.setLong("financialYearId", financialYearId.longValue());
        List budget = !qry.list().isEmpty() ? qry.list() : Collections.emptyList();
        return budget;
    }

    public List<BudgetDetail> getBudgetDetails(List<Long> budgetId) {
        return this.budgetDetailRepository.findByBudgetIdInAndStatusId(budgetId, this.getBudgetDetailStatus("VERIFIED").getId());
    }

    public EgwStatus getBudgetDetailStatus(String code) {
        return this.egwStatusHibernateDAO.getStatusByModuleAndCode("BUDGETDETAIL", code);
    }

    public String getDeptNameForBudgetId(Long budgetId) {
        BudgetDetail bg = this.budgetDetailRepository.findByBudgetIdAndStatusId(budgetId, this.getBudgetDetailStatus("VERIFIED").getId()).get(0);
        return bg == null ? "" : bg.getExecutingDepartment().getName();
    }

    public String getNextYrBEName(Budget budget) {
        BudgetDetail bg = this.budgetDetailRepository.findByBudgetReferenceBudgetId(budget.getId()).get(0);
        return bg == null ? "" : bg.getBudget().getName();
    }

    public BigDecimal getREAmount(Budget budget) {
        return this.budgetDetailRepository.findBudgetAmount(budget.getId(), this.getBudgetDetailStatus("VERIFIED").getId());
    }

    public BigDecimal getBEAmount(Budget budget) {
        BudgetDetail bg = this.budgetDetailRepository.findByBudgetReferenceBudgetId(budget.getId()).get(0);
        return this.budgetDetailRepository.findBudgetAmount(bg.getBudget().getId(), this.getBudgetDetailStatus("VERIFIED").getId());
    }

    public List<BudgetDetail> getNotApprovedBudgetDetails(Long budgetId) {
        return this.budgetDetailRepository.findByBudgetIdInAndStatusIdNotIn(budgetId, this.getBudgetDetailStatus("Approved").getId());
    }

    public Long getBudgetDetailCount(Budget budget) {
        return this.budgetDetailRepository.countByBudgetIdAndStatusId(budget.getId(), this.getBudgetDetailStatus("VERIFIED").getId());
    }

    public List<BudgetDetail> getNotApprovedBudgetDetailsForBudget(List<Long> budgetId) {
        return this.budgetDetailRepository.findByBudgetIdInAndStatusId(budgetId, this.getBudgetDetailStatus("VERIFIED").getId());
    }

    public BudgetDetail getBudgetDetailByReferencceBudget(String uniqueNo, Long budgetId) {
        return this.budgetDetailRepository.findByReferenceBudget(uniqueNo, budgetId);
    }
}

