/*
 * Decompiled with CFR 0.152.
 */
package org.egov.model.advance;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.egov.commons.EgwStatus;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.model.advance.EgAdvanceRequisitionDetails;
import org.egov.model.advance.EgAdvanceRequisitionMis;

@Entity
@Table(name="EG_ADVANCEREQUISITION")
@Inheritance(strategy=InheritanceType.JOINED)
@SequenceGenerator(name="SEQ_EG_ADVANCEREQUISITION", sequenceName="SEQ_EG_ADVANCEREQUISITION", allocationSize=1)
public class EgAdvanceRequisition
extends StateAware {
    private static final long serialVersionUID = 5350085164408760402L;
    public static final String SEQ_EG_ADVANCEREQUISITION = "SEQ_EG_ADVANCEREQUISITION";
    @Id
    @GeneratedValue(generator="SEQ_EG_ADVANCEREQUISITION", strategy=GenerationType.SEQUENCE)
    private Long id;
    private String advanceRequisitionNumber;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="statusid", nullable=false)
    private EgwStatus status;
    private Date advanceRequisitionDate;
    private BigDecimal advanceRequisitionAmount;
    private String narration;
    private String arftype;
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="egAdvanceRequisition", targetEntity=EgAdvanceRequisitionMis.class)
    private EgAdvanceRequisitionMis egAdvanceReqMises;
    @OrderBy(value="id")
    @OneToMany(orphanRemoval=true, cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="egAdvanceRequisition", targetEntity=EgAdvanceRequisitionDetails.class)
    private List<EgAdvanceRequisitionDetails> egAdvanceReqDetailses = new ArrayList<EgAdvanceRequisitionDetails>(0);

    public EgAdvanceRequisition() {
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getStateDetails() {
        return this.getAdvanceRequisitionNumber();
    }

    public String getAdvanceRequisitionNumber() {
        return this.advanceRequisitionNumber;
    }

    public void setAdvanceRequisitionNumber(String advanceRequisitionNumber) {
        this.advanceRequisitionNumber = advanceRequisitionNumber;
    }

    public EgwStatus getStatus() {
        return this.status;
    }

    public void setStatus(EgwStatus status) {
        this.status = status;
    }

    public Date getAdvanceRequisitionDate() {
        return this.advanceRequisitionDate;
    }

    public void setAdvanceRequisitionDate(Date advanceRequisitionDate) {
        this.advanceRequisitionDate = advanceRequisitionDate;
    }

    public BigDecimal getAdvanceRequisitionAmount() {
        return this.advanceRequisitionAmount;
    }

    public void setAdvanceRequisitionAmount(BigDecimal advanceRequisitionAmount) {
        this.advanceRequisitionAmount = advanceRequisitionAmount;
    }

    public String getNarration() {
        return this.narration;
    }

    public void setNarration(String narration) {
        this.narration = narration;
    }

    public String getArftype() {
        return this.arftype;
    }

    public void setArftype(String arftype) {
        this.arftype = arftype;
    }

    public EgAdvanceRequisitionMis getEgAdvanceReqMises() {
        return this.egAdvanceReqMises;
    }

    public void setEgAdvanceReqMises(EgAdvanceRequisitionMis egAdvanceReqMises) {
        this.egAdvanceReqMises = egAdvanceReqMises;
    }

    public List<EgAdvanceRequisitionDetails> getEgAdvanceReqDetailses() {
        return this.egAdvanceReqDetailses;
    }

    public void setEgAdvanceReqDetailses(List<EgAdvanceRequisitionDetails> egAdvanceReqDetailses) {
        this.egAdvanceReqDetailses = egAdvanceReqDetailses;
    }

    public void addEgAdvanceReqDetails(EgAdvanceRequisitionDetails advanceReqDetail) {
        if (advanceReqDetail != null) {
            this.getEgAdvanceReqDetailses().add(advanceReqDetail);
        }
    }

    public EgAdvanceRequisition(Long id, String advanceRequisitionNumber, EgwStatus status, Date advanceRequisitionDate, BigDecimal advanceRequisitionAmount, String narration, String arftype, EgAdvanceRequisitionMis egAdvanceReqMises, List<EgAdvanceRequisitionDetails> egAdvanceReqDetailses) {
        this.advanceRequisitionNumber = advanceRequisitionNumber;
        this.status = status;
        this.advanceRequisitionDate = advanceRequisitionDate;
        this.advanceRequisitionAmount = advanceRequisitionAmount;
        this.narration = narration;
        this.arftype = arftype;
        this.egAdvanceReqMises = egAdvanceReqMises;
        this.egAdvanceReqDetailses = egAdvanceReqDetailses;
    }

    public String toString() {
        return "EgAdvanceRequisition ( Id :  " + (null != this.getId() ? this.getId() : "") + "EgAdvanceRequisition arftype: " + (null != this.getArftype() ? this.getArftype() : "") + ")";
    }
}

