/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.advancepayment.service;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.lang.StringUtils;
import org.egov.billsaccounting.services.CreateVoucher;
import org.egov.commons.Bankaccount;
import org.egov.commons.CVoucherHeader;
import org.egov.commons.EgPartytype;
import org.egov.commons.service.BankAccountService;
import org.egov.commons.utils.EntityType;
import org.egov.egf.advancepayment.SearchAdvanceRequisition;
import org.egov.egf.advancepayment.repository.AdvancePaymentRepository;
import org.egov.egf.expensebill.service.ExpenseBillService;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.model.advance.EgAdvanceReqPayeeDetails;
import org.egov.model.advance.EgAdvanceRequisition;
import org.egov.model.advance.EgAdvanceRequisitionDetails;
import org.egov.model.advance.EgAdvanceRequisitionMis;
import org.egov.model.bills.EgBillregister;
import org.egov.model.bills.Miscbilldetail;
import org.egov.model.payment.Paymentheader;
import org.egov.pims.commons.Position;
import org.egov.services.masters.EgPartyTypeService;
import org.egov.services.payment.MiscbilldetailService;
import org.egov.services.payment.PaymentService;
import org.egov.utils.FinancialConstants;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.BindingResult;

@Service
@Transactional(readOnly=true)
public class AdvancePaymentService {
    private static final Logger LOG = LoggerFactory.getLogger(AdvancePaymentService.class);
    @Autowired
    private AdvancePaymentRepository advancePaymentRepository;
    @Autowired
    private MiscbilldetailService miscbilldetailService;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    @Qualifier(value="workflowService")
    private SimpleWorkflowService<Paymentheader> advancePaymentWorkflowService;
    @Autowired
    private PositionMasterService positionMasterService;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    protected PaymentService paymentService;
    @Autowired
    private ExpenseBillService expenseBillService;
    @Autowired
    private BankAccountService bankAccountService;
    @Autowired
    private CreateVoucher createVoucher;
    @Autowired
    private EgPartyTypeService egPartyTypeService;

    public List<String> getArfNumber(String advanceRequisitionNumber) {
        ArrayList<String> advanceRequisitionNotPaid = new ArrayList<String>();
        List<EgAdvanceRequisition> advanceRequisition = this.advancePaymentRepository.findARFNumberToSearchAdvanceBill("%" + advanceRequisitionNumber + "%", "APPROVED");
        for (EgAdvanceRequisition ear : advanceRequisition) {
            Miscbilldetail miscBill;
            if (ear.getEgAdvanceReqMises().getEgBillregister() == null || ear.getEgAdvanceReqMises().getEgBillregister().getEgBillregistermis().getVoucherHeader() == null || !FinancialConstants.CREATEDVOUCHERSTATUS.equals(ear.getEgAdvanceReqMises().getEgBillregister().getEgBillregistermis().getVoucherHeader().getStatus()) || (miscBill = this.miscbilldetailService.findByBillvhId(ear.getEgAdvanceReqMises().getEgBillregister().getEgBillregistermis().getVoucherHeader().getId())) != null && !FinancialConstants.CANCELLEDVOUCHERSTATUS.equals(miscBill.getPayVoucherHeader().getStatus())) continue;
            advanceRequisitionNotPaid.add(ear.getAdvanceRequisitionNumber());
        }
        return advanceRequisitionNotPaid;
    }

    public List<EgPartytype> getPartytypeByArfNumber(String arfNumber) {
        ArrayList<EgPartytype> egPartytype = new ArrayList<EgPartytype>();
        EgAdvanceRequisition advanceRequisition = this.advancePaymentRepository.findByAdvanceRequisitionNumber(arfNumber);
        if (advanceRequisition != null) {
            egPartytype.add(this.egPartyTypeService.findByCode(advanceRequisition.getArftype()));
        }
        return egPartytype;
    }

    public List<EgAdvanceRequisition> searchAdvanceBill(SearchAdvanceRequisition searchAdvanceRequisition) {
        ArrayList<EgAdvanceRequisition> advanceRequisitionNotPaid = new ArrayList<EgAdvanceRequisition>();
        StringBuilder queryStr = new StringBuilder(500);
        this.buildWhereClause(searchAdvanceRequisition, queryStr);
        Query query = this.setParameterForSearchAdvanceBill(searchAdvanceRequisition, queryStr);
        List advanceRequisitionList = query.getResultList();
        for (EgAdvanceRequisition ear : advanceRequisitionList) {
            Miscbilldetail miscBill;
            if (ear.getEgAdvanceReqMises().getEgBillregister() == null || ear.getEgAdvanceReqMises().getEgBillregister().getEgBillregistermis().getVoucherHeader() == null || !FinancialConstants.CREATEDVOUCHERSTATUS.equals(ear.getEgAdvanceReqMises().getEgBillregister().getEgBillregistermis().getVoucherHeader().getStatus()) || (miscBill = this.miscbilldetailService.findByBillvhId(ear.getEgAdvanceReqMises().getEgBillregister().getEgBillregistermis().getVoucherHeader().getId())) != null && !FinancialConstants.CANCELLEDVOUCHERSTATUS.equals(miscBill.getPayVoucherHeader().getStatus())) continue;
            advanceRequisitionNotPaid.add(ear);
        }
        return advanceRequisitionNotPaid;
    }

    private void buildWhereClause(SearchAdvanceRequisition searchAdvanceRequisition, StringBuilder queryStr) {
        queryStr.append("from EgAdvanceRequisition  ear where ");
        if (StringUtils.isNotBlank((String)searchAdvanceRequisition.getArfNumber())) {
            queryStr.append(" upper(ear.advanceRequisitionNumber) = :advanceRequisitionNumber ");
            if (searchAdvanceRequisition.getPartyType() != null) {
                queryStr.append(" and upper(ear.arftype) = :partyType");
            }
        } else if (searchAdvanceRequisition.getPartyType() != null) {
            queryStr.append(" upper(ear.arftype) = :partyType");
        }
        if (searchAdvanceRequisition.getFund() != null) {
            queryStr.append(" and ear.egAdvanceReqMises.fund.id = :fund");
        }
        if (searchAdvanceRequisition.getFromDate() != null) {
            queryStr.append(" and ear.egAdvanceReqMises.egBillregister.createdDate >= :fromDate");
        }
        if (searchAdvanceRequisition.getToDate() != null) {
            queryStr.append(" and ear.egAdvanceReqMises.egBillregister.createdDate <= :toDate");
        }
        queryStr.append(" and ear.egAdvanceReqMises.egBillregister.egBillregistermis.voucherHeader != null and ear.egAdvanceReqMises.egBillregister.egBillregistermis.voucherHeader.status=0");
    }

    private Query setParameterForSearchAdvanceBill(SearchAdvanceRequisition searchAdvanceRequisition, StringBuilder queryStr) {
        Query qry = this.entityManager.createQuery(queryStr.toString());
        if (searchAdvanceRequisition != null) {
            if (StringUtils.isNotBlank((String)searchAdvanceRequisition.getArfNumber())) {
                qry.setParameter("advanceRequisitionNumber", (Object)searchAdvanceRequisition.getArfNumber().toUpperCase());
            }
            if (searchAdvanceRequisition.getPartyType() != null) {
                qry.setParameter("partyType", (Object)((EgPartytype)this.egPartyTypeService.findById(Integer.valueOf(Integer.parseInt(searchAdvanceRequisition.getPartyType())), false)).getCode().toUpperCase());
            }
            if (searchAdvanceRequisition.getFund() != null) {
                qry.setParameter("fund", (Object)searchAdvanceRequisition.getFund().getId());
            }
            if (searchAdvanceRequisition.getFromDate() != null) {
                qry.setParameter("fromDate", (Object)searchAdvanceRequisition.getFromDate());
            }
            if (searchAdvanceRequisition.getToDate() != null) {
                qry.setParameter("toDate", (Object)searchAdvanceRequisition.getToDate());
            }
        }
        return qry;
    }

    public EgAdvanceRequisition getAdvaceRequisitionByBillRegId(Long egBillRegisterId) {
        return this.advancePaymentRepository.findByEgAdvanceReqMises_EgBillregister_Id(egBillRegisterId);
    }

    public EgAdvanceRequisition validateVoucherDetails(EgBillregister egBillRegister, String modeOfPay, BindingResult resultBinder) throws ApplicationException {
        EgBillregister billRegister = this.expenseBillService.getByVoucherHeaderId(egBillRegister.getEgBillregistermis().getVoucherHeader().getId());
        EgAdvanceRequisition egAdvanceRequisition = this.getAdvaceRequisitionByBillRegId(billRegister.getId());
        this.validateAdvancePaymentExists(resultBinder, egAdvanceRequisition);
        if (modeOfPay.equalsIgnoreCase("rtgs")) {
            this.validateRTGS(egAdvanceRequisition, resultBinder);
        }
        return egAdvanceRequisition;
    }

    @Transactional
    public Paymentheader createAdvancePayment(EgBillregister egBillRegister, CVoucherHeader voucherHeader, EgAdvanceRequisition egAdvanceRequisition, String bankAccount, String modeOfPay, String workFlowAction, String approvalComment, Long approvalPosition, BigDecimal totalAmount) throws ApplicationException {
        this.setVoucherHeaderValues(voucherHeader);
        CVoucherHeader voucherhdr = this.createVoucherAndledger(egAdvanceRequisition, voucherHeader, bankAccount, totalAmount);
        Paymentheader payHeader = this.setPaymentHeader(voucherhdr, totalAmount, modeOfPay, bankAccount);
        Paymentheader paymentHeader = this.createPaymentHeader(payHeader, workFlowAction, approvalPosition, approvalComment, null);
        this.createMiscBill(egBillRegister, paymentHeader);
        return paymentHeader;
    }

    private void setVoucherHeaderValues(CVoucherHeader voucherheader) {
        voucherheader.setType("Payment");
        voucherheader.setName("Advance Payment");
    }

    public CVoucherHeader createVoucherAndledger(EgAdvanceRequisition egAdvanceRequisition, CVoucherHeader voucherHeader, String bankAccount, BigDecimal totalAmount) throws ApplicationException {
        HashMap<String, Object> headerDetails = this.createHeaderAndMisDetails(voucherHeader, egAdvanceRequisition);
        HashMap<String, Object> detailMap = new HashMap<String, Object>();
        ArrayList<HashMap<String, Object>> accountdetails = new ArrayList<HashMap<String, Object>>();
        ArrayList<HashMap<String, Object>> subledgerDetails = new ArrayList<HashMap<String, Object>>();
        Bankaccount account = (Bankaccount)this.bankAccountService.findById((Serializable)Long.valueOf(Long.parseLong(bankAccount)), false);
        HashMap<String, String> glcodeMap = new HashMap<String, String>();
        detailMap.put("creditamount", egAdvanceRequisition.getAdvanceRequisitionAmount());
        detailMap.put("debitamount", BigDecimal.ZERO);
        detailMap.put("glcode", account.getChartofaccounts().getGlcode());
        accountdetails.add(detailMap);
        detailMap = new HashMap();
        detailMap.put("debitamount", egAdvanceRequisition.getAdvanceRequisitionAmount());
        detailMap.put("creditamount", BigDecimal.ZERO);
        for (EgAdvanceRequisitionDetails advanceRequisitionDetails : egAdvanceRequisition.getEgAdvanceReqDetailses()) {
            detailMap.put("glcode", advanceRequisitionDetails.getChartofaccounts().getGlcode());
        }
        accountdetails.add(detailMap);
        glcodeMap.put(detailMap.get("glcode").toString(), "debit");
        for (EgAdvanceRequisitionDetails advanceDetail : egAdvanceRequisition.getEgAdvanceReqDetailses()) {
            for (EgAdvanceReqPayeeDetails payeeDetail : advanceDetail.getEgAdvanceReqpayeeDetailses()) {
                HashMap<String, Object> subledgertDetailMap = new HashMap<String, Object>();
                BigDecimal debitAmount = payeeDetail.getDebitAmount() == null ? BigDecimal.ZERO : payeeDetail.getDebitAmount();
                BigDecimal creditAmount = payeeDetail.getCreditAmount() == null ? BigDecimal.ZERO : payeeDetail.getCreditAmount();
                subledgertDetailMap.put("debitamount", creditAmount);
                subledgertDetailMap.put("creditamount", debitAmount);
                subledgertDetailMap.put("detailtypeid", payeeDetail.getAccountDetailType().getId());
                subledgertDetailMap.put("detailkeyid", payeeDetail.getAccountdetailKeyId());
                subledgertDetailMap.put("glcode", advanceDetail.getChartofaccounts().getGlcode());
                subledgerDetails.add(subledgertDetailMap);
            }
        }
        CVoucherHeader cVoucherHeader = this.createVoucher.createPreApprovedVoucher(headerDetails, accountdetails, subledgerDetails);
        return cVoucherHeader;
    }

    protected HashMap<String, Object> createHeaderAndMisDetails(CVoucherHeader voucherHeader, EgAdvanceRequisition advanceRequisition) {
        HashMap<String, Object> headerdetails = new HashMap<String, Object>();
        headerdetails.put("vouchername", voucherHeader.getName());
        headerdetails.put("vouchertype", voucherHeader.getType());
        headerdetails.put("voucherdate", voucherHeader.getVoucherDate());
        headerdetails.put("description", voucherHeader.getDescription());
        EgAdvanceRequisitionMis egAdvanceReqMises = advanceRequisition.getEgAdvanceReqMises();
        if (egAdvanceReqMises != null) {
            if (egAdvanceReqMises.getFund() != null && egAdvanceReqMises.getFund().getId() != null) {
                headerdetails.put("fundcode", egAdvanceReqMises.getFund().getCode());
            }
            if (egAdvanceReqMises.getEgDepartment() != null && egAdvanceReqMises.getEgDepartment().getId() != null) {
                headerdetails.put("departmentcode", egAdvanceReqMises.getEgDepartment().getCode());
            }
            if (egAdvanceReqMises.getFundsource() != null && egAdvanceReqMises.getFundsource().getId() != null) {
                headerdetails.put("fundsourcecode", egAdvanceReqMises.getFundsource().getCode());
            }
            if (egAdvanceReqMises.getScheme() != null && egAdvanceReqMises.getScheme().getId() != null) {
                headerdetails.put("schemecode", egAdvanceReqMises.getScheme().getCode());
            }
            if (egAdvanceReqMises.getSubScheme() != null && egAdvanceReqMises.getSubScheme().getId() != null) {
                headerdetails.put("subschemecode", egAdvanceReqMises.getSubScheme().getCode());
            }
            if (egAdvanceReqMises.getFunctionaryId() != null && egAdvanceReqMises.getFunctionaryId().getId() != null) {
                headerdetails.put("functionarycode", egAdvanceReqMises.getFunctionaryId().getCode());
            }
            if (egAdvanceReqMises.getFunction() != null && egAdvanceReqMises.getFunction().getId() != null) {
                headerdetails.put("functioncode", egAdvanceReqMises.getFunction().getCode());
            }
            if (egAdvanceReqMises.getFieldId() != null && egAdvanceReqMises.getFieldId().getId() != null) {
                headerdetails.put("divisionid", egAdvanceReqMises.getFieldId().getId());
            }
        }
        return headerdetails;
    }

    @Transactional
    protected void createMiscBill(EgBillregister egBillRegister, Paymentheader paymentheader) {
        EgAdvanceRequisition advanceRequisition = this.getAdvaceRequisitionByBillRegId(egBillRegister.getId());
        Miscbilldetail miscbilldetail = new Miscbilldetail();
        miscbilldetail.setBillnumber(advanceRequisition.getEgAdvanceReqMises().getEgBillregister().getBillnumber());
        miscbilldetail.setBilldate(advanceRequisition.getEgAdvanceReqMises().getEgBillregister().getBilldate());
        miscbilldetail.setBillamount(advanceRequisition.getEgAdvanceReqMises().getEgBillregister().getBillamount());
        miscbilldetail.setPassedamount(advanceRequisition.getEgAdvanceReqMises().getEgBillregister().getPassedamount());
        miscbilldetail.setPaidamount(advanceRequisition.getEgAdvanceReqMises().getEgBillregister().getBillamount());
        miscbilldetail.setPaidto(advanceRequisition.getEgAdvanceReqMises().getEgBillregister().getEgBillregistermis().getPayto());
        miscbilldetail.setPayVoucherHeader(paymentheader.getVoucherheader());
        miscbilldetail.setPaidby(this.securityUtils.getCurrentUser());
        miscbilldetail.setBillVoucherHeader(advanceRequisition.getEgAdvanceReqMises().getEgBillregister().getEgBillregistermis().getVoucherHeader());
        this.miscbilldetailService.persist(miscbilldetail);
    }

    public Paymentheader setPaymentHeader(CVoucherHeader voucherHeader, BigDecimal amount, String modeOfPayment, String bankAccount) {
        Paymentheader paymentHeader = new Paymentheader();
        paymentHeader.setType(modeOfPayment);
        paymentHeader.setVoucherheader(voucherHeader);
        paymentHeader.setBankaccount((Bankaccount)this.bankAccountService.findById((Serializable)Long.valueOf(Long.parseLong(bankAccount)), false));
        paymentHeader.setPaymentAmount(amount);
        paymentHeader.setCreatedBy(this.securityUtils.getCurrentUser());
        return paymentHeader;
    }

    private void validateAdvancePaymentExists(BindingResult resultBinder, EgAdvanceRequisition egAdvanceRequisition) {
        Miscbilldetail miscbillDetails = this.miscbilldetailService.findByBillvhId(egAdvanceRequisition.getEgAdvanceReqMises().getEgBillregister().getEgBillregistermis().getVoucherHeader().getId());
        if (miscbillDetails != null && miscbillDetails.getPayVoucherHeader() != null && !FinancialConstants.CANCELLEDVOUCHERSTATUS.equals(miscbillDetails.getPayVoucherHeader().getStatus())) {
            resultBinder.reject("msg.arf.payment.uniqueCheck.validate.message", (Object[])new String[]{egAdvanceRequisition.getAdvanceRequisitionNumber()}, null);
        }
    }

    private void validateRTGS(EgAdvanceRequisition egAdvanceRequisition, BindingResult resultBinder) throws ApplicationException {
        block2: for (EgAdvanceRequisitionDetails advanceDetail : egAdvanceRequisition.getEgAdvanceReqDetailses()) {
            if (!advanceDetail.getEgAdvanceReqpayeeDetailses().isEmpty()) {
                for (EgAdvanceReqPayeeDetails payeeDetail : advanceDetail.getEgAdvanceReqpayeeDetailses()) {
                    try {
                        EntityType entity = this.paymentService.getEntity(payeeDetail.getAccountDetailType().getId(), payeeDetail.getAccountdetailKeyId());
                        if (entity == null) {
                            resultBinder.reject("no.entity.for.detailkey", null, null);
                            continue block2;
                        }
                        if (!StringUtils.isBlank((String)entity.getPanno()) && !StringUtils.isBlank((String)entity.getBankname()) && !StringUtils.isBlank((String)entity.getBankaccount()) && !StringUtils.isBlank((String)entity.getIfsccode())) continue;
                        resultBinder.reject("validate.paymentMode.rtgs.subledger.details", (Object[])new String[]{entity.getCode() + "-" + entity.getName()}, null);
                    }
                    catch (ValidationException e) {
                        resultBinder.reject("Exception to get EntityType", null, null);
                    }
                }
                continue;
            }
            resultBinder.reject("no.subledger.cannot.create.rtgs.payment", null, null);
        }
    }

    public void workflowTransition(Paymentheader paymentheader, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(" Create WorkFlow Transition Started  ...");
        }
        User user = this.securityUtils.getCurrentUser();
        DateTime currentDate = new DateTime();
        Position pos = null;
        Assignment wfInitiator = null;
        String currState = "";
        if (null != paymentheader.getId()) {
            wfInitiator = this.assignmentService.getPrimaryAssignmentForUser(paymentheader.getCreatedBy().getId());
        }
        if ("Reject".toString().equalsIgnoreCase(workFlowAction)) {
            String stateValue = "Rejected";
            paymentheader.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue("Rejected").withDateInfo(currentDate.toDate()).withOwner(wfInitiator.getPosition()).withNextAction("").withNatureOfTask("Advance Payment");
        } else {
            if (null != approvalPosition && approvalPosition != -1L && !approvalPosition.equals(0L)) {
                pos = this.positionMasterService.getPositionById(approvalPosition);
            }
            if (null == paymentheader.getState()) {
                WorkFlowMatrix wfmatrix = this.advancePaymentWorkflowService.getWfMatrix(paymentheader.getStateType(), null, null, additionalRule, "", null);
                paymentheader.transition().start().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue(wfmatrix.getNextState()).withDateInfo(new Date()).withOwner(pos).withNextAction(wfmatrix.getNextAction()).withNatureOfTask("Advance Payment");
            } else if ("Cancel".toString().equalsIgnoreCase(workFlowAction)) {
                String stateValue = "Cancelled";
                paymentheader.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue("Cancelled").withDateInfo(currentDate.toDate()).withOwner(pos).withNextAction("").withNatureOfTask("Advance Payment");
            } else {
                WorkFlowMatrix wfmatrix = this.advancePaymentWorkflowService.getWfMatrix(paymentheader.getStateType(), null, null, additionalRule, paymentheader.getCurrentState().getValue(), null);
                paymentheader.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue(wfmatrix.getNextState()).withDateInfo(new Date()).withOwner(pos).withNextAction(wfmatrix.getNextAction()).withNatureOfTask("Advance Payment");
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(" WorkFlow Transition Completed  ...");
        }
    }

    @Transactional
    public Paymentheader createPaymentHeader(Paymentheader paymentHeader, String workFlowAction, Long approvalPosition, String approvalComent, String additionalRule) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting createPaymentHeader...");
        }
        if ("Create And Approve".equalsIgnoreCase(workFlowAction) && paymentHeader.getVoucherheader().getState() == null) {
            paymentHeader.getVoucherheader().setStatus(FinancialConstants.CREATEDVOUCHERSTATUS);
        }
        Paymentheader savedPaymentHeader = (Paymentheader)this.paymentService.create(paymentHeader);
        savedPaymentHeader.getVoucherheader().getVouchermis().setSourcePath("/EGF/advancepayment/view/" + savedPaymentHeader.getId());
        if (!workFlowAction.equals("Create And Approve")) {
            this.workflowTransition(savedPaymentHeader, approvalPosition, approvalComent, additionalRule, workFlowAction);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Completed createPaymentHeader.");
        }
        return paymentHeader;
    }

    @Transactional
    public Paymentheader updatePaymentHeader(Paymentheader paymentheader, String workFlowAction, Long approvalPosition, String approvalComment, String additionalRule) {
        Paymentheader updatedPaymentHeader = (Paymentheader)this.paymentService.update(paymentheader);
        this.workflowTransition(updatedPaymentHeader, approvalPosition, approvalComment, null, workFlowAction);
        return paymentheader;
    }

    public EgBillregister getBillRegisterFromPayVhid(Paymentheader paymentheader) {
        Miscbilldetail miscbilldetail = this.miscbilldetailService.findByPayvhId(paymentheader.getVoucherheader().getId());
        return this.expenseBillService.getByVoucherHeaderId(miscbilldetail.getBillVoucherHeader().getId());
    }
}

