/*
 * Decompiled with CFR 0.152.
 */
package org.egov.deduction.dao;

import java.io.Serializable;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.log4j.Logger;
import org.egov.commons.CFinancialYear;
import org.egov.commons.Fund;
import org.egov.deduction.model.EgRemittance;
import org.egov.model.recoveries.Recovery;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class EgRemittanceHibernateDAO {
    @PersistenceContext
    private EntityManager entityManager;
    private static final Logger LOGGER = Logger.getLogger(EgRemittanceHibernateDAO.class);

    @Transactional
    public EgRemittance update(EgRemittance entity) {
        this.getCurrentSession().update((Object)entity);
        return entity;
    }

    @Transactional
    public EgRemittance create(EgRemittance entity) {
        this.getCurrentSession().persist((Object)entity);
        return entity;
    }

    @Transactional
    public void delete(EgRemittance entity) {
        this.getCurrentSession().delete((Object)entity);
    }

    public EgRemittance findById(Number id, boolean lock) {
        return (EgRemittance)this.getCurrentSession().load(EgRemittance.class, (Serializable)id);
    }

    public List<EgRemittance> findAll() {
        return this.getCurrentSession().createCriteria(EgRemittance.class).list();
    }

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public List<EgRemittance> getEgRemittanceFilterBy(Fund fund, Recovery recovery, String month, CFinancialYear financialyear) {
        StringBuffer qryStr = new StringBuffer();
        List egRemittanceList = null;
        qryStr.append("From EgRemittance rmt where rmt.voucherheader.type='Payment' and rmt.voucherheader.status=0");
        Query qry = this.getCurrentSession().createQuery(qryStr.toString());
        if (fund != null) {
            qryStr.append(" and (rmt.fund = :fund)");
            qry = this.getCurrentSession().createQuery(qryStr.toString());
        }
        if (recovery != null) {
            qryStr.append(" and (rmt.tds = :recovery)");
            qry = this.getCurrentSession().createQuery(qryStr.toString());
        }
        if (month != null) {
            qryStr.append(" and (rmt.month = :month)");
            qry = this.getCurrentSession().createQuery(qryStr.toString());
        }
        if (financialyear != null) {
            qryStr.append(" and (rmt.financialyear =:financialyear)");
            qry = this.getCurrentSession().createQuery(qryStr.toString());
        }
        qryStr.append(" order by upper(rmt.tds.type)");
        qry = this.getCurrentSession().createQuery(qryStr.toString());
        if (fund != null) {
            qry.setEntity("fund", (Object)fund);
        }
        if (recovery != null) {
            qry.setEntity("recovery", (Object)recovery);
        }
        if (month != null) {
            qry.setString("month", month);
        }
        if (financialyear != null) {
            qry.setEntity("financialyear", (Object)financialyear);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("qryStr " + qryStr.toString()));
        }
        egRemittanceList = qry.list();
        return egRemittanceList;
    }
}

