/*
 * Decompiled with CFR 0.152.
 */
package com.exilant.exility.updateservice;

import com.exilant.exility.updateservice.DataType;
import java.util.Date;

public class ColumnDefinition {
    public String name;
    public String dataType;
    public boolean isRequired;
    public String min;
    public String max;
    public int maxLength = 0;
    public String defaultValue;
    public String descriptionId;
    int dataTypeInt = 0;
    int dataSubType = 0;
    double dblMin;
    double dblMax;
    boolean requiresQuote = true;
    Date dateMin;
    Date dateMax;

    public boolean isValid(String value) {
        if (null == value || value.length() == 0) {
            return this.defaultValue != null || !this.isRequired;
        }
        if (!DataType.isValid(this.dataTypeInt, value)) {
            return false;
        }
        if (this.maxLength != 0 && value.length() > this.maxLength) {
            return false;
        }
        if (DataType.isNumericType(this.dataTypeInt) ? !this.isValidNumericField(value) : DataType.isDateType(this.dataTypeInt) && !this.isValidDateField(value)) {
            return false;
        }
        if (this.descriptionId == null || this.descriptionId.length() > 0) {
            // empty if block
        }
        return true;
    }

    private boolean isValidNumericField(String value) {
        if (null == this.min && null == this.max) {
            return true;
        }
        double doubleValue = Double.parseDouble(value);
        if (null != this.min && doubleValue < this.dblMin) {
            return false;
        }
        return null == this.max || !(doubleValue > this.dblMax);
    }

    private boolean isValidDateField(String value) {
        Date mdate;
        if (null == this.dateMin && null == this.dateMax && this.dataTypeInt == 7) {
            return true;
        }
        Date date = DataType.getDate(value);
        Date today = DataType.getToday();
        if (null != this.dateMin) {
            mdate = this.dateMin;
            if (this.dataTypeInt == 9 && this.dateMin.before(today)) {
                mdate = today;
            }
            if (date.before(mdate)) {
                return false;
            }
        } else if (this.dataTypeInt == 9 && date.before(today)) {
            return false;
        }
        if (null != this.dateMax) {
            mdate = this.dateMax;
            if (this.dataTypeInt == 8 && this.dateMax.after(today)) {
                mdate = today;
            }
            if (date.after(mdate)) {
                return false;
            }
        } else if (this.dataTypeInt == 8 && date.after(today)) {
            return false;
        }
        return true;
    }

    public void optimize() {
        this.dataTypeInt = DataType.getTypeInt(this.dataType);
        if (DataType.isNumericType(this.dataTypeInt)) {
            this.dataSubType = 1;
            if (null != this.min || null != this.max) {
                this.dblMin = null == this.min ? Double.MIN_VALUE : Double.parseDouble(this.min);
                this.dblMax = null == this.max ? Double.MAX_VALUE : Double.parseDouble(this.max);
            }
        } else if (DataType.isDateType(this.dataTypeInt)) {
            this.dataSubType = 2;
            if (null != this.max) {
                this.dateMax = DataType.getDate(this.max);
            }
            if (null != this.min) {
                this.dateMin = DataType.getDate(this.min);
            }
        } else {
            this.dataSubType = 0;
        }
        this.requiresQuote = this.dataSubType != 1 && this.dataTypeInt != 11;
    }
}

