/*
 * Decompiled with CFR 0.152.
 */
package com.exilant.exility.service;

import com.exilant.exility.common.DataCollection;
import com.exilant.exility.common.ExilServiceInterface;
import com.exilant.exility.dataservice.SQLTask;
import java.sql.Connection;
import org.apache.log4j.Logger;

public class ListService
implements ExilServiceInterface {
    private static final Logger LOGGER = Logger.getLogger(ListService.class);
    private static ListService singletonInstance;

    public static ListService getService() {
        if (singletonInstance == null) {
            singletonInstance = new ListService();
        }
        return singletonInstance;
    }

    private ListService() {
    }

    @Override
    public void doService(DataCollection dc) {
        String[] services = dc.getValueList("serviceID");
        if (null == services || services.length == 0) {
            String serviceID = dc.getValue("serviceID");
            if (null == serviceID || serviceID.length() == 0) {
                dc.addMessage("exilNoServiceID");
                return;
            }
            services = new String[]{serviceID};
        }
        Connection con = null;
        SQLTask task = SQLTask.getTask();
        try {
            con = null;
            for (int i = 0; i < services.length; ++i) {
                task.execute(services[i], services[i], dc, con, false, false, "");
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug((Object)(" tasks executed in " + i + " for service id = ????????  " + services[i]));
            }
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Exp=" + e.getMessage()));
            }
            dc.addMessage("exilDBError", e.getMessage());
        }
    }

    public static void main(String[] args) {
        ListService ls = new ListService();
        DataCollection dc = new DataCollection();
        dc.addValue("serviceID", "SQLDefinition1");
        ls.doService(dc);
    }
}

