/*
 * Decompiled with CFR 0.152.
 */
package org.egov.services.report;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.egov.commons.CFinancialYear;
import org.egov.commons.CVoucherHeader;
import org.egov.commons.Fund;
import org.egov.commons.dao.FinancialYearHibernateDAO;
import org.egov.egf.model.IEStatementEntry;
import org.egov.egf.model.Statement;
import org.egov.egf.model.StatementEntry;
import org.egov.egf.model.StatementResultObject;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infstr.services.PersistenceService;
import org.egov.utils.Constants;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.Transformers;
import org.hibernate.type.BigDecimalType;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class ReportService {
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    AppConfigValueService appConfigValuesService;
    int minorCodeLength;
    List<Character> coaType = new ArrayList<Character>();
    @Autowired
    private FinancialYearHibernateDAO financialYearDAO;
    static final Logger LOGGER = Logger.getLogger(ReportService.class);

    public Date getPreviousYearFor(Date date) {
        GregorianCalendar previousYearToDate = new GregorianCalendar();
        previousYearToDate.setTime(date);
        int prevYear = previousYearToDate.get(1) - 1;
        previousYearToDate.set(1, prevYear);
        return previousYearToDate.getTime();
    }

    public List<Fund> getFunds() {
        Criteria voucherHeaderCriteria = this.persistenceService.getSession().createCriteria(CVoucherHeader.class);
        List fundIdList = voucherHeaderCriteria.setProjection(Projections.distinct((Projection)Projections.property((String)"fundId.id"))).list();
        if (!fundIdList.isEmpty()) {
            return this.persistenceService.getSession().createCriteria(Fund.class).add(Restrictions.in((String)"id", (Collection)fundIdList)).list();
        }
        return new ArrayList<Fund>();
    }

    public String getGlcodeForPurposeCode(Integer purposeId) {
        SQLQuery query = this.persistenceService.getSession().createSQLQuery("select majorcode from chartofaccounts where purposeid=" + purposeId);
        List list = query.list();
        String glCode = "";
        if (list.get(0) != null) {
            glCode = list.get(0).toString();
        }
        return glCode;
    }

    protected String getFilterQuery(Statement balanceSheet) {
        String query = "";
        if (balanceSheet.getDepartment() != null && balanceSheet.getDepartment().getId() != null && balanceSheet.getDepartment().getId() != 0L) {
            query = query + " and mis.departmentid=" + balanceSheet.getDepartment().getId().toString();
        }
        if (balanceSheet.getFunction() != null && balanceSheet.getFunction().getId() != null && balanceSheet.getFunction().getId() != 0L) {
            query = query + " and g.functionid=" + balanceSheet.getFunction().getId().toString();
        }
        if (balanceSheet.getFund() != null && balanceSheet.getFund().getId() != null && balanceSheet.getFund().getId() != 0) {
            query = query + " and v.fundid=" + balanceSheet.getFund().getId().toString();
        }
        return query;
    }

    public String getFundNameForId(List<Fund> fundList, Integer id) {
        for (Fund fund : fundList) {
            if (!id.equals(fund.getId())) continue;
            return fund.getName();
        }
        return "";
    }

    public String getfundList(List<Fund> fundList) {
        StringBuffer fundId = new StringBuffer();
        fundId.append("(");
        for (Fund fund : fundList) {
            fundId.append(fund.getId()).append(",");
        }
        fundId.setLength(fundId.length() - 1);
        fundId.append(")");
        return fundId.toString();
    }

    public BigDecimal divideAndRound(BigDecimal value, BigDecimal divisor) {
        value = value.divide(divisor, 2, 4);
        return value;
    }

    protected String getTransactionQuery(Statement balanceSheet) {
        String query = "";
        if (balanceSheet.getDepartment() != null && balanceSheet.getDepartment().getId() != null && balanceSheet.getDepartment().getId() != 0L) {
            query = query + " and ts.departmentid=" + balanceSheet.getDepartment().getId().toString();
        }
        if (balanceSheet.getFunction() != null && balanceSheet.getFunction().getId() != null && balanceSheet.getFunction().getId() != 0L) {
            query = query + " and ts.functionid=" + balanceSheet.getFunction().getId().toString();
        }
        if (balanceSheet.getFund() != null && balanceSheet.getFund().getId() != null && balanceSheet.getFund().getId() != 0) {
            query = query + " and ts.fundid=" + balanceSheet.getFund().getId().toString();
        }
        return query;
    }

    public String getFormattedDate(Date date) {
        SimpleDateFormat formatter = Constants.DDMMYYYYFORMAT1;
        return formatter.format(date);
    }

    public String getFormattedDate2(Date date) {
        SimpleDateFormat formatter = Constants.DDMMYYYYFORMAT2;
        return formatter.format(date);
    }

    public String getAppConfigValueFor(String module, String key) {
        try {
            return ((AppConfigValues)this.appConfigValuesService.getConfigValuesByModuleAndKey(module, key).get(0)).getValue();
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            new ValidationException(Arrays.asList(new ValidationError(key + "is not defined in appconfig", key + "is not defined in appconfig")));
            return "";
        }
    }

    void addFundAmount(List<Fund> fundList, Statement type, BigDecimal divisor, StatementResultObject row) {
        for (int index = 0; index < type.size(); ++index) {
            BigDecimal amount = this.divideAndRound(row.getAmount(), divisor);
            if (type.get(index).getGlCode() == null || !row.getGlCode().equals(type.get(index).getGlCode())) continue;
            type.get(index).getFundWiseAmount().put(this.getFundNameForId(fundList, (int)row.getFundId()), amount);
        }
    }

    void addFundAmountIE(List<Fund> fundList, Statement type, BigDecimal divisor, StatementResultObject row) {
        for (int index = 0; index < type.sizeIE(); ++index) {
            BigDecimal amount = this.divideAndRound(row.getAmount(), divisor);
            if (type.getIE(index).getGlCode() == null || !row.getGlCode().equals(type.getIE(index).getGlCode())) continue;
            type.getIE(index).getNetAmount().put(this.getFundNameForId(fundList, (int)row.getFundId()), amount);
        }
    }

    List<StatementResultObject> getRowWithGlCode(List<StatementResultObject> results, String glCode) {
        ArrayList<StatementResultObject> resultList = new ArrayList<StatementResultObject>();
        for (StatementResultObject balanceSheetQueryObject : results) {
            if (!glCode.equalsIgnoreCase(balanceSheetQueryObject.getGlCode()) || balanceSheetQueryObject.getAmount().compareTo(BigDecimal.ZERO) == 0) continue;
            resultList.add(balanceSheetQueryObject);
        }
        return resultList;
    }

    protected abstract void addRowsToStatement(Statement var1, Statement var2, Statement var3);

    protected List<StatementResultObject> getAllGlCodesFor(String scheduleReportType) {
        Query query = this.persistenceService.getSession().createSQLQuery("select distinct coa.majorcode as glCode,s.schedule as scheduleNumber,s.schedulename as scheduleName,coa.type as type from chartofaccounts coa, schedulemapping s where s.id=coa.scheduleid and coa.classification=2 and s.reporttype = '" + scheduleReportType + "' order by coa.majorcode").addScalar("glCode").addScalar("scheduleNumber").addScalar("scheduleName").addScalar("type").setResultTransformer(Transformers.aliasToBean(StatementResultObject.class));
        return query.list();
    }

    List<StatementResultObject> getTransactionAmount(String filterQuery, Date toDate, Date fromDate, String coaType, String subReportType) {
        String voucherStatusToExclude = this.getAppConfigValueFor("EGF", "statusexcludeReport");
        Query query = this.persistenceService.getSession().createSQLQuery("select c.majorcode as glCode,v.fundid as fundId,c.type as type,sum(debitamount)-sum(creditamount) as amount from generalledger g,chartofaccounts c,voucherheader v ,vouchermis mis where v.id=mis.voucherheaderid and v.id=g.voucherheaderid and c.type in(" + coaType + ") and c.id=g.glcodeid and v.status not in(" + voucherStatusToExclude + ")  AND v.voucherdate <= '" + this.getFormattedDate(toDate) + "' and v.voucherdate >='" + this.getFormattedDate(fromDate) + "' and substr(c.glcode,1," + this.minorCodeLength + ") in (select distinct coa2.glcode from chartofaccounts coa2, schedulemapping s where s.id=coa2.scheduleid and coa2.classification=2 and s.reporttype = '" + subReportType + "') " + filterQuery + " group by c.majorcode,v.fundid,c.type order by c.majorcode").addScalar("glCode").addScalar("fundId", (Type)BigDecimalType.INSTANCE).addScalar("type").addScalar("amount", (Type)BigDecimalType.INSTANCE).setResultTransformer(Transformers.aliasToBean(StatementResultObject.class));
        return query.list();
    }

    protected Map<String, String> getSubSchedule(String subReportType) {
        HashMap<String, String> scheduleNumberToName = new HashMap<String, String>();
        List rows = this.persistenceService.getSession().createSQLQuery("select s.schedule,sub.subschedulename from egf_subschedule sub,schedulemapping s where sub.reporttype='" + subReportType + "' and sub.SUBSCHNAME=s.REPSUBTYPE").list();
        for (Object[] row : rows) {
            scheduleNumberToName.put(row[0].toString(), row[1].toString());
        }
        return scheduleNumberToName;
    }

    public Date getFromDate(Statement statement) {
        CFinancialYear financialYear = null;
        if ("Date".equalsIgnoreCase(statement.getPeriod()) && statement.getAsOndate() != null) {
            String financialYearId = this.financialYearDAO.getFinancialYearId(this.getFormattedDate2(statement.getAsOndate()));
            financialYear = this.financialYearDAO.getFinancialYearById(Long.valueOf(financialYearId));
            statement.setFinancialYear(financialYear);
        } else {
            financialYear = statement.getFinancialYear();
        }
        return financialYear.getStartingDate();
    }

    public Date getToDate(Statement statement) {
        if ("Date".equalsIgnoreCase(statement.getPeriod()) && statement.getAsOndate() != null) {
            return statement.getAsOndate();
        }
        if ("Half Yearly".equalsIgnoreCase(statement.getPeriod())) {
            String halfYearly = this.getAppConfigValueFor("EGF", "bs_report_half_yearly");
            String[] halfYearComponents = halfYearly.split("/");
            Calendar fin = Calendar.getInstance();
            fin.setTime(statement.getFinancialYear().getStartingDate());
            Calendar calendar = Calendar.getInstance();
            calendar.set(fin.get(1), Integer.parseInt(halfYearComponents[1]) - 1, Integer.parseInt(halfYearComponents[0]));
            return calendar.getTime();
        }
        return statement.getFinancialYear().getEndingDate();
    }

    void addFundAmount(StatementEntry entry, Map<String, BigDecimal> fundTotals) {
        for (Map.Entry<String, BigDecimal> row : entry.getFundWiseAmount().entrySet()) {
            String key = row.getKey();
            if (!fundTotals.containsKey(key)) {
                fundTotals.put(key, BigDecimal.ZERO);
            }
            fundTotals.put(key, row.getValue().add(fundTotals.get(key)));
        }
    }

    void addTotalRowToPreviousGroup(List<StatementEntry> list, Map<String, String> schedueNumberToNameMap, StatementEntry entry) {
        list.add(new StatementEntry("", schedueNumberToNameMap.get(entry.getScheduleNo()), "", null, null, true));
    }

    void addTotalRowToPreviousGroupIE(List<IEStatementEntry> list, Map<String, String> schedueNumberToNameMap, IEStatementEntry entry) {
        list.add(new IEStatementEntry("", schedueNumberToNameMap.get(entry.getScheduleNo()), true));
    }

    void removeFundsWithNoDataIE(Statement statement) {
        HashMap<String, Boolean> fundToBeRemoved = new HashMap<String, Boolean>();
        for (Fund fund : statement.getFunds()) {
            fundToBeRemoved.put(fund.getName(), Boolean.TRUE);
        }
        Iterator<Fund> fund = statement.getFunds().iterator();
        while (fund.hasNext()) {
            Fund next = fund.next();
            for (IEStatementEntry balanceSheetEntry : statement.getIeEntries()) {
                if (!balanceSheetEntry.getNetAmount().containsKey(next.getName()) && !balanceSheetEntry.getPreviousYearAmount().containsKey(next.getName())) continue;
                fundToBeRemoved.put(next.getName(), Boolean.FALSE);
            }
            if (!((Boolean)fundToBeRemoved.get(next.getName())).booleanValue()) continue;
            fund.remove();
        }
    }

    void removeFundsWithNoData(Statement statement) {
        HashMap<String, Boolean> fundToBeRemoved = new HashMap<String, Boolean>();
        for (Fund fund : statement.getFunds()) {
            fundToBeRemoved.put(fund.getName(), Boolean.TRUE);
        }
        Iterator<Fund> fund = statement.getFunds().iterator();
        while (fund.hasNext()) {
            Fund next = fund.next();
            for (StatementEntry balanceSheetEntry : statement.getEntries()) {
                if (!balanceSheetEntry.getFundWiseAmount().containsKey(next.getName())) continue;
                fundToBeRemoved.put(next.getName(), Boolean.FALSE);
            }
            if (!((Boolean)fundToBeRemoved.get(next.getName())).booleanValue()) continue;
            fund.remove();
        }
    }

    protected void populateSchedule(Statement statement, String reportSubType) {
        SQLQuery query = this.persistenceService.getSession().createSQLQuery("select c.majorcode,s.schedulename,s.schedule from chartofaccounts c,schedulemapping s where s.id=c.scheduleid and s.reporttype = '" + reportSubType + "' and c.type in('A','L') group by c.majorcode,s.schedulename,s.schedule ORDER BY c.majorcode");
        List scheduleList = query.list();
        for (Object[] obj : scheduleList) {
            for (int index = 0; index < statement.size(); ++index) {
                if (obj[0] == null) {
                    obj[0] = "";
                }
                if (statement.get(index).getGlCode() == null || !obj[0].toString().equals(statement.get(index).getGlCode())) continue;
                statement.get(index).setAccountName(obj[1].toString());
                statement.get(index).setScheduleNo(obj[2].toString());
            }
        }
    }

    protected BigDecimal zeroOrValue(BigDecimal value) {
        return value == null ? BigDecimal.ZERO : value;
    }

    protected void computeCurrentYearTotals(Statement statement, String type1, String type2) {
        for (StatementEntry balanceSheetEntry : statement.getEntries()) {
            if (type1.equals(balanceSheetEntry.getAccountName()) || type2.equals(balanceSheetEntry.getAccountName()) || balanceSheetEntry.isDisplayBold()) continue;
            BigDecimal currentYearTotal = BigDecimal.ZERO;
            for (Map.Entry<String, BigDecimal> entry : balanceSheetEntry.getFundWiseAmount().entrySet()) {
                currentYearTotal = currentYearTotal.add(entry.getValue());
            }
            balanceSheetEntry.setCurrentYearTotal(currentYearTotal);
        }
    }
}

