/*
 * Decompiled with CFR 0.152.
 */
package org.egov.services.payment;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.model.instrument.InstrumentHeader;
import org.egov.model.payment.ChequeAssignment;
import org.egov.services.payment.PaymentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
@Service
public class ChequeAssignmentHelper {
    private static final Logger LOGGER = Logger.getLogger(ChequeAssignmentHelper.class);
    @Autowired
    @Qualifier(value="paymentService")
    private PaymentService paymentService;

    @Transactional
    public List<InstrumentHeader> reassignInstrument(List<ChequeAssignment> chequeAssignmentList, String paymentMode, Integer bankaccount, Map<String, String[]> parameters, Department dept) throws Exception {
        ArrayList<InstrumentHeader> instHeaderList = new ArrayList();
        try {
            instHeaderList = this.paymentService.reassignInstrument(chequeAssignmentList, paymentMode, bankaccount, parameters, dept);
        }
        catch (ValidationException e) {
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", ((ValidationError)e.getErrors().get(0)).getMessage()));
            throw new ValidationException(errors);
        }
        catch (Exception e) {
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", e.getMessage()));
            throw new ValidationException(errors);
        }
        return instHeaderList;
    }

    @Transactional
    public List<InstrumentHeader> createInstrument(List<ChequeAssignment> chequeAssignmentList, String paymentMode, Integer bankaccount, Map<String, String[]> parameters, Department dept) throws Exception {
        ArrayList<InstrumentHeader> instHeaderList = new ArrayList();
        try {
            instHeaderList = this.paymentService.createInstrument(chequeAssignmentList, paymentMode, bankaccount, parameters, dept);
        }
        catch (ValidationException e) {
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", ((ValidationError)e.getErrors().get(0)).getMessage()));
            throw new ValidationException(errors);
        }
        catch (Exception e) {
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", e.getMessage()));
            throw new ValidationException(errors);
        }
        return instHeaderList;
    }
}

