/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.voucher.service;

import com.exilant.eGov.src.transactions.VoucherTypeForULB;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang.StringUtils;
import org.egov.commons.CFiscalPeriod;
import org.egov.commons.CGeneralLedger;
import org.egov.commons.CGeneralLedgerDetail;
import org.egov.commons.CVoucherHeader;
import org.egov.commons.EgwStatus;
import org.egov.commons.Scheme;
import org.egov.commons.SubScheme;
import org.egov.commons.dao.FiscalPeriodHibernateDAO;
import org.egov.commons.service.FundService;
import org.egov.egf.autonumber.JVBillNumberGenerator;
import org.egov.egf.autonumber.VouchernumberGenerator;
import org.egov.egf.billsubtype.service.EgBillSubTypeService;
import org.egov.egf.expensebill.service.ExpenseBillService;
import org.egov.egf.utils.FinancialUtils;
import org.egov.egf.voucher.repository.JournalVoucherRepository;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.persistence.utils.ApplicationSequenceNumberGenerator;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.utils.autonumber.AutonumberServiceBeanResolver;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.model.bills.EgBillPayeedetails;
import org.egov.model.bills.EgBillSubType;
import org.egov.model.bills.EgBilldetails;
import org.egov.model.bills.EgBillregister;
import org.egov.model.bills.EgBillregistermis;
import org.egov.pims.commons.Position;
import org.egov.services.masters.SchemeService;
import org.egov.services.masters.SubSchemeService;
import org.egov.services.voucher.VoucherService;
import org.egov.utils.FinancialConstants;
import org.hibernate.Session;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class JournalVoucherService {
    private static final String JOURNALVOUCHER = "JOURNALVOUCHER";
    private static final Logger LOG = LoggerFactory.getLogger(JournalVoucherService.class);
    @PersistenceContext
    private EntityManager entityManager;
    private final JournalVoucherRepository journalVoucherRepository;
    @Autowired
    private SchemeService schemeService;
    @Autowired
    private SubSchemeService subSchemeService;
    @Autowired
    private FinancialUtils financialUtils;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    protected AppConfigValueService appConfigValuesService;
    @Autowired
    private AutonumberServiceBeanResolver beanResolver;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private PositionMasterService positionMasterService;
    @Autowired
    @Qualifier(value="voucherService")
    private VoucherService voucherService;
    @Autowired
    private VoucherTypeForULB voucherTypeForULB;
    @Autowired
    private FiscalPeriodHibernateDAO fiscalPeriodHibernateDAO;
    @Autowired
    @Qualifier(value="workflowService")
    private SimpleWorkflowService<CVoucherHeader> cvoucherHeaderRegisterWorkflowService;
    @Autowired
    private FundService fundService;
    @Autowired
    private ApplicationSequenceNumberGenerator applicationSequenceNumberGenerator;
    @Autowired
    private EgBillSubTypeService egBillSubTypeService;
    @Autowired
    private ExpenseBillService expenseBillService;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Autowired
    public JournalVoucherService(JournalVoucherRepository journalVoucherRepository) {
        this.journalVoucherRepository = journalVoucherRepository;
    }

    public CVoucherHeader getById(Long id) {
        return (CVoucherHeader)this.journalVoucherRepository.findOne(id);
    }

    public CVoucherHeader getByVoucherNumber(String voucherNumber) {
        return this.journalVoucherRepository.findByVoucherNumber(voucherNumber);
    }

    @Transactional
    public CVoucherHeader create(CVoucherHeader voucherHeader, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction) {
        voucherHeader.setFiscalPeriodId(Integer.valueOf(this.fiscalPeriodHibernateDAO.getFiscalPeriodByDate(voucherHeader.getVoucherDate()).getId().intValue()));
        if (voucherHeader.getFundId() != null && voucherHeader.getFundId().getId() != null) {
            voucherHeader.setFundId(this.fundService.findOne(voucherHeader.getFundId().getId()));
        }
        if (voucherHeader.getVouchermis().getSchemeid() != null && voucherHeader.getVouchermis().getSchemeid().getId() != null) {
            voucherHeader.getVouchermis().setSchemeid((Scheme)this.schemeService.findById(voucherHeader.getVouchermis().getSchemeid().getId(), false));
        } else {
            voucherHeader.getVouchermis().setSchemeid(null);
        }
        if (voucherHeader.getVouchermis().getSubschemeid() != null && voucherHeader.getVouchermis().getSubschemeid().getId() != null) {
            voucherHeader.getVouchermis().setSubschemeid((SubScheme)this.subSchemeService.findById(voucherHeader.getVouchermis().getSubschemeid().getId(), false));
        } else {
            voucherHeader.getVouchermis().setSubschemeid(null);
        }
        this.populateVoucherNumber(voucherHeader, null);
        this.populateCGVNNumber(voucherHeader);
        if (!"JVGeneral".equalsIgnoreCase(voucherHeader.getName())) {
            this.createBillForVoucherHeader(voucherHeader);
        }
        CVoucherHeader savedVoucherHeader = (CVoucherHeader)this.journalVoucherRepository.save(voucherHeader);
        voucherHeader.getVouchermis().setSourcePath("/EGF/voucher/journalVoucherModify-beforeModify.action?voucherHeader.id=" + voucherHeader.getId());
        this.update(voucherHeader);
        if (workFlowAction.equals("Create And Approve")) {
            voucherHeader.setStatus(FinancialConstants.CREATEDVOUCHERSTATUS);
        } else {
            voucherHeader.setStatus(FinancialConstants.PREAPPROVEDVOUCHERSTATUS);
            this.createVoucherHeaderRegisterWorkflowTransition(savedVoucherHeader, approvalPosition, approvalComent, additionalRule, workFlowAction);
        }
        return (CVoucherHeader)this.journalVoucherRepository.save(savedVoucherHeader);
    }

    @Transactional
    public CVoucherHeader update(CVoucherHeader voucherHeader) {
        return (CVoucherHeader)this.journalVoucherRepository.save(voucherHeader);
    }

    @Transactional
    public void createBillForVoucherHeader(CVoucherHeader voucherHeader) {
        EgBillregister egBillregister = new EgBillregister();
        EgwStatus egwstatus = null;
        if ("Contractor Journal".equalsIgnoreCase(voucherHeader.getName())) {
            egwstatus = this.financialUtils.getStatusByModuleAndCode("CONTRACTORBILL", "APPROVED");
            egBillregister.setExpendituretype("Works");
        } else if ("Supplier Journal".equalsIgnoreCase(voucherHeader.getName())) {
            egwstatus = this.financialUtils.getStatusByModuleAndCode("SBILL", "Approved");
            egBillregister.setExpendituretype("Purchase");
        } else if ("Salary Journal".equalsIgnoreCase(voucherHeader.getName())) {
            egwstatus = this.financialUtils.getStatusByModuleAndCode("SALBILL", "Approved");
            egBillregister.setExpendituretype("Salary");
        } else if ("Expense Journal".equalsIgnoreCase(voucherHeader.getName())) {
            egwstatus = this.financialUtils.getStatusByModuleAndCode("EXPENSEBILL", "Approved");
            egBillregister.setExpendituretype("Expense");
        } else if ("Pension Journal".equalsIgnoreCase(voucherHeader.getName())) {
            egwstatus = this.financialUtils.getStatusByModuleAndCode("PENSIONBILL", "Expense");
            egBillregister.setExpendituretype("Pension");
        }
        egBillregister.setStatus(egwstatus);
        if (null != voucherHeader.getBillDate()) {
            egBillregister.setBilldate(voucherHeader.getBillDate());
        } else {
            egBillregister.setBilldate(voucherHeader.getVoucherDate());
        }
        if (null != voucherHeader.getVouchermis().getDivisionid()) {
            egBillregister.setFieldid(new BigDecimal(voucherHeader.getVouchermis().getDivisionid().getId().toString()));
        }
        egBillregister.setNarration(voucherHeader.getDescription());
        egBillregister.setIsactive(true);
        egBillregister.setBilltype("Final Bill");
        egBillregister.setPassedamount(voucherHeader.getTotalAmount());
        egBillregister.setBillamount(voucherHeader.getTotalAmount());
        EgBillregistermis egBillregistermis = new EgBillregistermis();
        egBillregistermis.setFund(voucherHeader.getFundId());
        egBillregistermis.setEgDepartment(voucherHeader.getVouchermis().getDepartmentid());
        egBillregistermis.setFunctionaryid(voucherHeader.getVouchermis().getFunctionary());
        egBillregistermis.setFunction(voucherHeader.getVouchermis().getFunction());
        egBillregistermis.setFundsource(voucherHeader.getVouchermis().getFundsource());
        egBillregistermis.setScheme(voucherHeader.getVouchermis().getSchemeid());
        egBillregistermis.setSubScheme(voucherHeader.getVouchermis().getSubschemeid());
        egBillregistermis.setNarration(voucherHeader.getDescription());
        egBillregistermis.setPartyBillDate(voucherHeader.getPartyBillDate());
        egBillregistermis.setPayto(voucherHeader.getPartyName());
        egBillregistermis.setPartyBillNumber(voucherHeader.getPartyBillNumber());
        egBillregistermis.setFieldid(voucherHeader.getVouchermis().getDivisionid());
        if ("fixedassetjv".equalsIgnoreCase(voucherHeader.getVoucherNumType())) {
            EgBillSubType egBillSubType = this.egBillSubTypeService.getByExpenditureTypeAndName("Purchase", "Fixed Asset");
            egBillregistermis.setEgBillSubType(egBillSubType);
        }
        egBillregistermis.setLastupdatedtime(new Date());
        egBillregistermis.setVoucherHeader(voucherHeader);
        egBillregister.setEgBillregistermis(egBillregistermis);
        if (null != voucherHeader.getBillNumber() && StringUtils.isNotEmpty((String)voucherHeader.getBillNumber())) {
            egBillregister.setBillnumber(voucherHeader.getBillNumber());
        } else {
            JVBillNumberGenerator b = (JVBillNumberGenerator)this.beanResolver.getAutoNumberServiceFor(JVBillNumberGenerator.class);
            String billNumber = b.getNextNumber(egBillregister);
            egBillregister.setBillnumber(billNumber);
        }
        if (!this.expenseBillService.isBillNumUnique(egBillregister.getBillnumber())) {
            throw new ValidationException(Arrays.asList(new ValidationError("bill number", "Duplicate Bill Number : " + egBillregister.getBillnumber())));
        }
        egBillregistermis.setEgBillregister(egBillregister);
        this.populateBillDetails(egBillregister, voucherHeader);
        this.expenseBillService.create(egBillregister);
    }

    private void populateBillDetails(EgBillregister egBillregister, CVoucherHeader voucherHeader) {
        egBillregister.getEgBilldetailes().clear();
        for (CGeneralLedger gl : voucherHeader.getGeneralLedger()) {
            EgBilldetails details = new EgBilldetails();
            details.setEgBillregister(egBillregister);
            details.setLastupdatedtime(new Date());
            details.setDebitamount(BigDecimal.valueOf(gl.getDebitAmount()));
            details.setCreditamount(BigDecimal.valueOf(gl.getCreditAmount()));
            if (gl.getFunctionId() != null) {
                details.setFunctionid(BigDecimal.valueOf(gl.getFunctionId().intValue()));
            }
            details.setGlcodeid(BigDecimal.valueOf(gl.getGlcodeId().getId()));
            for (CGeneralLedgerDetail gld : gl.getGeneralLedgerDetails()) {
                EgBillPayeedetails payeeDetails = new EgBillPayeedetails();
                payeeDetails.setAccountDetailTypeId(gld.getDetailTypeId().getId());
                payeeDetails.setAccountDetailKeyId(gld.getDetailKeyId());
                if (details.getDebitamount() != null && details.getDebitamount().compareTo(BigDecimal.ZERO) == 1) {
                    payeeDetails.setDebitAmount(gld.getAmount());
                    payeeDetails.setCreditAmount(BigDecimal.ZERO);
                } else {
                    payeeDetails.setDebitAmount(BigDecimal.ZERO);
                    payeeDetails.setCreditAmount(gld.getAmount());
                }
                details.getEgBillPaydetailes().add(payeeDetails);
            }
            egBillregister.getEgBilldetailes().add(details);
        }
    }

    public void createVoucherHeaderRegisterWorkflowTransition(CVoucherHeader voucherHeader, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(" Create WorkFlow Transition Started  ...");
        }
        User user = this.securityUtils.getCurrentUser();
        DateTime currentDate = new DateTime();
        Position pos = null;
        Assignment wfInitiator = null;
        String currState = "";
        if (null != voucherHeader.getId()) {
            wfInitiator = this.assignmentService.getPrimaryAssignmentForUser(voucherHeader.getCreatedBy().getId());
        }
        if ("Reject".toString().equalsIgnoreCase(workFlowAction)) {
            String stateValue = "Rejected";
            voucherHeader.transition().progressWithStateCopy().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue("Rejected").withDateInfo(currentDate.toDate()).withOwner(wfInitiator.getPosition()).withNextAction("").withNatureOfTask("Voucher");
        } else {
            if (null != approvalPosition && approvalPosition != -1L && !approvalPosition.equals(0L)) {
                pos = this.positionMasterService.getPositionById(approvalPosition);
            }
            if (null == voucherHeader.getState()) {
                WorkFlowMatrix wfmatrix = this.cvoucherHeaderRegisterWorkflowService.getWfMatrix(voucherHeader.getStateType(), null, null, additionalRule, "", null);
                voucherHeader.transition().start().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue(wfmatrix.getNextState()).withDateInfo(new Date()).withOwner(pos).withNextAction(wfmatrix.getNextAction()).withNatureOfTask("Voucher");
            } else if ("Approve".toString().equalsIgnoreCase(workFlowAction)) {
                String stateValue = "Approved";
                voucherHeader.setStatus(FinancialConstants.CREATEDVOUCHERSTATUS);
                WorkFlowMatrix wfmatrix = this.cvoucherHeaderRegisterWorkflowService.getWfMatrix(voucherHeader.getStateType(), null, null, additionalRule, voucherHeader.getCurrentState().getValue(), null);
                voucherHeader.transition().progressWithStateCopy().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue("Approved").withDateInfo(currentDate.toDate()).withOwner(pos).withNextAction("").withNatureOfTask("Voucher");
            } else if ("Cancel".toString().equalsIgnoreCase(workFlowAction)) {
                String stateValue = "Cancelled";
                voucherHeader.setStatus(FinancialConstants.CANCELLEDVOUCHERSTATUS);
                WorkFlowMatrix wfmatrix = this.cvoucherHeaderRegisterWorkflowService.getWfMatrix(voucherHeader.getStateType(), null, null, additionalRule, voucherHeader.getCurrentState().getValue(), null);
                voucherHeader.transition().progressWithStateCopy().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue("Cancelled").withDateInfo(currentDate.toDate()).withOwner(pos).withNextAction("").withNatureOfTask("Voucher");
            } else {
                WorkFlowMatrix wfmatrix = this.cvoucherHeaderRegisterWorkflowService.getWfMatrix(voucherHeader.getStateType(), null, null, additionalRule, voucherHeader.getCurrentState().getValue(), null);
                voucherHeader.transition().progressWithStateCopy().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue(wfmatrix.getNextState()).withDateInfo(new Date()).withOwner(pos).withNextAction(wfmatrix.getNextAction()).withNatureOfTask("Voucher");
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(" WorkFlow Transition Completed  ...");
        }
    }

    public Long getApprovalPositionByMatrixDesignation(CVoucherHeader voucherHeader, String additionalRule, String mode, String workFlowAction) {
        Long approvalPosition = null;
        WorkFlowMatrix wfmatrix = this.cvoucherHeaderRegisterWorkflowService.getWfMatrix(voucherHeader.getStateType(), null, null, additionalRule, voucherHeader.getCurrentState().getValue(), null);
        if (voucherHeader.getState() != null && !voucherHeader.getState().getHistory().isEmpty() && voucherHeader.getState().getOwnerPosition() != null) {
            approvalPosition = voucherHeader.getState().getOwnerPosition().getId();
        } else if (wfmatrix != null) {
            approvalPosition = this.financialUtils.getApproverPosition(wfmatrix.getNextDesignation(), voucherHeader.getState(), voucherHeader.getCreatedBy().getId());
        }
        if (workFlowAction.equals("Cancel")) {
            approvalPosition = null;
        }
        return approvalPosition;
    }

    public void populateVoucherNumber(CVoucherHeader voucherHeader, Long moduleId) {
        String voucherType = voucherHeader.getType();
        String vNumGenMode = "Journal Voucher".equalsIgnoreCase(voucherType) ? this.voucherTypeForULB.readVoucherTypes("Journal") : this.voucherTypeForULB.readVoucherTypes(voucherType);
        voucherType = voucherType.toUpperCase().replaceAll(" ", "");
        String voucherSubType = null;
        if (voucherHeader.getVoucherSubType() != null) {
            voucherSubType = voucherHeader.getVoucherSubType().toUpperCase().replaceAll(" ", "");
        }
        if (moduleId != null) {
            vNumGenMode = "Auto";
        }
        if ("Auto".equals(vNumGenMode)) {
            voucherHeader.setVoucherNumberPrefix(this.getVoucherNumberPrefix(voucherType, voucherSubType));
            VouchernumberGenerator v = (VouchernumberGenerator)this.beanResolver.getAutoNumberServiceFor(VouchernumberGenerator.class);
            String strVoucherNumber = v.getNextNumber(voucherHeader);
            voucherHeader.setVoucherNumber(strVoucherNumber);
        }
    }

    private String getVoucherNumberPrefix(String type, String vsubtype) {
        if (vsubtype == null) {
            vsubtype = type;
        }
        String subtype = vsubtype.toUpperCase().trim();
        String voucherNumberPrefix = null;
        String typetoCheck = subtype;
        if ("Journal Voucher".equalsIgnoreCase(subtype)) {
            typetoCheck = JOURNALVOUCHER;
        }
        switch (voucherSubTypeEnum.valueOf(typetoCheck)) {
            case JVGENERAL: {
                voucherNumberPrefix = FinancialConstants.JOURNAL_VOUCHERNO_TYPE;
                break;
            }
            case JOURNALVOUCHER: {
                voucherNumberPrefix = FinancialConstants.JOURNAL_VOUCHERNO_TYPE;
                break;
            }
            case CONTRA: {
                voucherNumberPrefix = FinancialConstants.CONTRA_VOUCHERNO_TYPE;
                break;
            }
            case RECEIPT: {
                voucherNumberPrefix = FinancialConstants.RECEIPT_VOUCHERNO_TYPE;
                break;
            }
            case PAYMENT: {
                voucherNumberPrefix = FinancialConstants.PAYMENT_VOUCHERNO_TYPE;
                break;
            }
            case PURCHASEJOURNAL: {
                voucherNumberPrefix = FinancialConstants.PURCHBILL_VOUCHERNO_TYPE;
                break;
            }
            case WORKS: {
                voucherNumberPrefix = FinancialConstants.WORKSBILL_VOUCHERNO_TYPE;
                break;
            }
            case CONTRACTORJOURNAL: {
                voucherNumberPrefix = FinancialConstants.WORKSBILL_VOUCHERNO_TYPE;
                break;
            }
            case WORKSJOURNAL: {
                voucherNumberPrefix = FinancialConstants.WORKSBILL_VOUCHERNO_TYPE;
                break;
            }
            case FIXEDASSETJOURNAL: {
                voucherNumberPrefix = FinancialConstants.FIXEDASSET_VOUCHERNO_TYPE;
                break;
            }
            case CONTINGENTJOURNAL: {
                voucherNumberPrefix = FinancialConstants.CBILL_VOUCHERNO_TYPE;
                break;
            }
            case PURCHASE: {
                voucherNumberPrefix = FinancialConstants.PURCHBILL_VOUCHERNO_TYPE;
                break;
            }
            case EXPENSEJOURNAL: {
                voucherNumberPrefix = FinancialConstants.CBILL_VOUCHERNO_TYPE;
                break;
            }
            case EXPENSE: {
                voucherNumberPrefix = FinancialConstants.CBILL_VOUCHERNO_TYPE;
                break;
            }
            case SALARYJOURNAL: {
                voucherNumberPrefix = FinancialConstants.SALBILL_VOUCHERNO_TYPE;
                break;
            }
            case SALARY: {
                voucherNumberPrefix = FinancialConstants.SALBILL_VOUCHERNO_TYPE;
                break;
            }
            case FIXEDASSET: {
                voucherNumberPrefix = FinancialConstants.FIXEDASSET_VOUCHERNO_TYPE;
                break;
            }
            case PENSIONJOURNAL: {
                voucherNumberPrefix = FinancialConstants.PENBILL_VOUCHERNO_TYPE;
                break;
            }
            case PENSION: {
                voucherNumberPrefix = FinancialConstants.PENBILL_VOUCHERNO_TYPE;
                break;
            }
            default: {
                if (voucherNumberPrefix != null) break;
                voucherNumberPrefix = this.checkWithVoucherType(type);
            }
        }
        return voucherNumberPrefix;
    }

    private String checkWithVoucherType(String type) {
        String typetoCheck = type;
        if ("Journal Voucher".equalsIgnoreCase(type)) {
            typetoCheck = JOURNALVOUCHER;
        }
        String voucherNumberPrefix = null;
        switch (voucherTypeEnum.valueOf(typetoCheck)) {
            case JOURNALVOUCHER: {
                voucherNumberPrefix = FinancialConstants.JOURNAL_VOUCHERNO_TYPE;
                break;
            }
            case CONTRA: {
                voucherNumberPrefix = FinancialConstants.CONTRA_VOUCHERNO_TYPE;
                break;
            }
            case RECEIPT: {
                voucherNumberPrefix = FinancialConstants.RECEIPT_VOUCHERNO_TYPE;
                break;
            }
            case PAYMENT: {
                voucherNumberPrefix = FinancialConstants.PAYMENT_VOUCHERNO_TYPE;
                break;
            }
        }
        return voucherNumberPrefix;
    }

    public void populateCGVNNumber(CVoucherHeader voucherHeader) {
        CFiscalPeriod fiscalPeriod = this.fiscalPeriodHibernateDAO.getFiscalPeriodByDate(voucherHeader.getVoucherDate());
        if (fiscalPeriod == null) {
            throw new ApplicationRuntimeException("Fiscal period is not defined for the voucher date");
        }
        String sequenceName = "sq_" + voucherHeader.getFundId().getIdentifier() + "_" + this.getCgnType(voucherHeader.getType()).toLowerCase() + "_cgvn_" + fiscalPeriod.getName();
        Serializable nextSequence = this.applicationSequenceNumberGenerator.getNextSequence(sequenceName);
        String cgvnNumber = String.format("%s/%s/%s%010d", voucherHeader.getFundId().getIdentifier(), this.getCgnType(voucherHeader.getType()), "CGVN", nextSequence);
        voucherHeader.setCgvn(cgvnNumber);
    }

    protected String getCgnType(String vouType) {
        String vType = vouType.toUpperCase().replaceAll(" ", "");
        String cgnType = null;
        String typetoCheck = vType;
        if ("Journal Voucher".equalsIgnoreCase(vType)) {
            typetoCheck = JOURNALVOUCHER;
        }
        switch (voucherTypeEnum.valueOf(typetoCheck.toUpperCase())) {
            case JOURNALVOUCHER: {
                cgnType = "JVG";
                break;
            }
            case CONTRA: {
                cgnType = "CSL";
                break;
            }
            case RECEIPT: {
                cgnType = "MSR";
                break;
            }
            case PAYMENT: {
                cgnType = "DBP";
                break;
            }
        }
        return cgnType;
    }

    static enum voucherSubTypeEnum {
        JOURNALVOUCHER,
        CONTRA,
        RECEIPT,
        PAYMENT,
        PURCHASEJOURNAL,
        PENSIONJOURNAL,
        PURCHASE,
        WORKS,
        CONTRACTORJOURNAL,
        FIXEDASSETJOURNAL,
        FIXEDASSET,
        PENSION,
        WORKSJOURNAL,
        CONTINGENTJOURNAL,
        SALARY,
        SALARYJOURNAL,
        EXPENSE,
        EXPENSEJOURNAL,
        JVGENERAL;

    }

    static enum voucherTypeEnum {
        JOURNALVOUCHER,
        CONTRA,
        RECEIPT,
        PAYMENT;

    }
}

