/*
 * Decompiled with CFR 0.152.
 */
package org.egov.dao.bills;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.log4j.Logger;
import org.egov.dao.bills.EgBilldetailsDAO;
import org.egov.infra.exception.ApplicationException;
import org.egov.model.bills.EgBilldetails;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional(readOnly=true)
public class EgBilldetailsHibernateDAO
implements EgBilldetailsDAO {
    @PersistenceContext
    private EntityManager entityManager;
    private final Logger logger = Logger.getLogger((String)this.getClass().getName());

    @Override
    @Transactional
    public EgBilldetails update(EgBilldetails entity) {
        this.getCurrentSession().update((Object)entity);
        return entity;
    }

    @Override
    @Transactional
    public EgBilldetails create(EgBilldetails entity) {
        this.getCurrentSession().persist((Object)entity);
        return entity;
    }

    @Override
    @Transactional
    public void delete(EgBilldetails entity) {
        this.getCurrentSession().delete((Object)entity);
    }

    @Override
    public EgBilldetails findById(Number id, boolean lock) {
        return (EgBilldetails)this.getCurrentSession().load(EgBilldetails.class, (Serializable)id);
    }

    @Override
    public List<EgBilldetails> findAll() {
        return this.getCurrentSession().createCriteria(EgBilldetails.class).list();
    }

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Override
    public BigDecimal getOtherBillsAmount(Long minGlCodeId, Long maxGlCodeId, Long majGlCodeId, String finYearID, String functionId, String schemeId, String subSchemeId, String asOnDate, String billType) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"------- Inside getOtherBillsAmount() -----------");
        }
        Query qry = null;
        StringBuffer qryStr = new StringBuffer();
        BigDecimal result = new BigDecimal("0.00");
        try {
            String dateCond = "";
            String funcStr = "";
            String schStr = "";
            String glcodeStr = "";
            qryStr.append("select sum(bd.debitamount) from EgBilldetails bd, EgBillregister br, EgBillregistermis brm where br.id=bd.egBillregister.id and br.id=brm.egBillregister.id and bd.egBillregister.id=brm.egBillregister.id and brm.financialyear.id =:finYearID and br.expendituretype not in ( :billType)  and br.status.id not in (SELECT es.id FROM EgwStatus es  WHERE  UPPER(es.description) LIKE '%CANCELLED%') ");
            if (asOnDate != null && !"".equals(asOnDate)) {
                dateCond = " and br.billdate <=:asOnDate";
            }
            if (functionId != null && !"".equals(functionId)) {
                funcStr = " and bd.functionid =:functionId";
            }
            if (schemeId != null && !"".equals(schemeId) && (subSchemeId == null || "".equals(subSchemeId))) {
                schStr = "  and brm.scheme =:schemeId";
            }
            if (schemeId != null && !"".equals(schemeId) && subSchemeId != null && !"".equals(subSchemeId)) {
                schStr = "  and brm.scheme =:schemeId and brm.subScheme =:subSchemeId";
            }
            if (minGlCodeId != 0L && maxGlCodeId != 0L) {
                glcodeStr = " and bd.glcodeid between :minGlCodeId and :maxGlCodeId";
            } else if (maxGlCodeId != 0L) {
                glcodeStr = " and bd.glcodeid =:maxGlCodeId";
            } else if (majGlCodeId != 0L) {
                glcodeStr = " and bd.glcodeid =:majGlCodeId";
            }
            qryStr.append(dateCond);
            qryStr.append(funcStr);
            qryStr.append(schStr);
            qryStr.append(glcodeStr);
            qry = this.getCurrentSession().createQuery(qryStr.toString());
            if (functionId != "" && functionId != null) {
                qry.setString("functionId", functionId);
            }
            if (schemeId != "" && schemeId != null && (subSchemeId == "" || subSchemeId == null)) {
                qry.setString("schemeId", schemeId);
            }
            if (schemeId != "" && schemeId != null && subSchemeId != "" && subSchemeId != null) {
                qry.setString("schemeId", schemeId);
                qry.setString("subSchemeId", subSchemeId);
            }
            if (asOnDate != "" && asOnDate != null) {
                qry.setString("asOnDate", asOnDate);
            }
            if (minGlCodeId != 0L && maxGlCodeId != 0L) {
                qry.setLong("minGlCodeId", minGlCodeId.longValue());
                qry.setLong("maxGlCodeId", maxGlCodeId.longValue());
            } else if (maxGlCodeId != 0L) {
                qry.setLong("maxGlCodeId", maxGlCodeId.longValue());
            } else if (majGlCodeId != 0L) {
                qry.setLong("majGlCodeId", majGlCodeId.longValue());
            }
            qry.setString("finYearID", finYearID);
            qry.setString("billType", billType);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("qry---------> " + qry));
            }
            if (qry.uniqueResult() != null) {
                return new BigDecimal(qry.uniqueResult().toString());
            }
            return result;
        }
        catch (Exception e) {
            this.logger.error((Object)(e.getCause() + " Error in getOtherBillsAmount"));
            throw new ApplicationException(e.getMessage());
        }
    }

    @Override
    public EgBilldetails getBillDetails(Long billId, List glcodeIdList) throws Exception {
        Query qry = null;
        StringBuffer qryStr = new StringBuffer();
        EgBilldetails billdetails = null;
        try {
            qryStr.append("from EgBilldetails bd where bd.creditamount>0 AND bd.glcodeid IN (:glcodeIds) AND billid=:billId ");
            qry = this.getCurrentSession().createQuery(qryStr.toString());
            qry.setParameterList("glcodeIds", (Collection)glcodeIdList);
            qry.setLong("billId", billId.longValue());
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("qry---------> " + qry));
            }
            billdetails = (EgBilldetails)qry.uniqueResult();
        }
        catch (Exception e) {
            this.logger.error((Object)(e.getCause() + " Error in getBillDetails"));
            throw new ApplicationException(e.getMessage());
        }
        return billdetails;
    }
}

