/*
 * Decompiled with CFR 0.152.
 */
package com.exilant.eGov.src.domain;

import com.exilant.eGov.src.common.EGovernCommon;
import com.exilant.exility.common.TaskFailedException;
import com.exilant.exility.updateservice.PrimaryKeyGenerator;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infstr.services.PersistenceService;
import org.egov.infstr.utils.EgovMasterDataCaching;
import org.hibernate.HibernateException;
import org.hibernate.SQLQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class ChartOfAccts {
    private String id = null;
    private String glCode = null;
    private String name = null;
    private String description = null;
    private String isActiveForPosting = "0";
    private String parentId = null;
    private String lastModified = "";
    private String modifiedBy = null;
    private String created = "";
    private String purposeid = null;
    private String operation = null;
    private String type = null;
    private String classname = "0";
    private String classification = null;
    private String functionreqd = "0";
    private String scheduleId = null;
    private Integer FIEscheduleId = null;
    private String FIEoperation = null;
    private String receiptscheduleid = null;
    private String receiptoperation = null;
    private String paymentscheduleid = null;
    private String paymentoperation = null;
    private String budgetCheckReqd = null;
    private boolean isId = false;
    private boolean isField = false;
    private static final Logger LOGGER = Logger.getLogger(ChartOfAccts.class);
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private EgovMasterDataCaching masterDataCache;
    @Autowired
    private EGovernCommon eGovernCommon;
    private final SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy", Locale.getDefault());
    private final SimpleDateFormat formatter = new SimpleDateFormat("dd-MMM-yyyy", Locale.getDefault());

    public void setId(String aId) {
        this.id = aId;
        this.isId = true;
    }

    public String getId() {
        return this.id;
    }

    public void setGLCode(String aGLCode) {
        this.glCode = aGLCode;
        this.isField = true;
    }

    public void setName(String aName) {
        this.name = aName;
        this.isField = true;
    }

    public void setDescription(String aDescription) {
        this.description = aDescription;
        this.isField = true;
    }

    public void setIsActiveForPosting(String aIsActiveForPosting) {
        this.isActiveForPosting = aIsActiveForPosting;
        this.isField = true;
    }

    public void setParentId(String aParentId) {
        this.parentId = aParentId;
        this.isField = true;
    }

    public void setLastModified(String aLastModified) {
        this.lastModified = aLastModified;
        this.isField = true;
    }

    public void setModifiedBy(String aModifiedBy) {
        this.modifiedBy = aModifiedBy;
        this.isField = true;
    }

    public void setCreated(String aCreated) {
        this.created = aCreated;
        this.isField = true;
    }

    public void setOperation(String aOperation) {
        this.operation = aOperation;
        this.isField = true;
    }

    public void setType(String aType) {
        this.type = aType;
        this.isField = true;
    }

    public void setClass(String aclass) {
        this.classname = aclass;
        this.isField = true;
    }

    public void setPurposeId(String aPurposeId) {
        this.purposeid = aPurposeId;
        this.isField = true;
    }

    public void setFunctionReqd(String aFunctionReqd) {
        this.functionreqd = aFunctionReqd;
        this.isField = true;
    }

    public void setClassification(String aClassification) {
        this.classification = aClassification;
        this.isField = true;
    }

    public void setScheduleId(String aScheduleId) {
        this.scheduleId = aScheduleId;
        this.isField = true;
    }

    public void setReceiptscheduleid(String aReceiptscheduleid) {
        this.receiptscheduleid = aReceiptscheduleid;
        this.isField = true;
    }

    public void setReceiptoperation(String aReceiptoperation) {
        this.receiptoperation = aReceiptoperation;
        this.isField = true;
    }

    public void setPaymentscheduleid(String aPaymentscheduleid) {
        this.paymentscheduleid = aPaymentscheduleid;
        this.isField = true;
    }

    public void setPaymentoperation(String aPaymentoperation) {
        this.paymentoperation = aPaymentoperation;
        this.isField = true;
    }

    public void setBudgetCheckReqd(String aBudgetCheckReqd) {
        this.budgetCheckReqd = aBudgetCheckReqd;
        this.isField = true;
    }

    public Integer getFIEscheduleId() {
        return this.FIEscheduleId;
    }

    public void setFIEscheduleId(int escheduleId) {
        this.FIEscheduleId = escheduleId;
        this.isField = true;
    }

    public String getFIEoperation() {
        return this.FIEoperation;
    }

    public void setFIEoperation(String eoperation) {
        this.FIEoperation = eoperation;
        this.isField = true;
    }

    @Transactional
    public void insert(Connection connection) throws SQLException, TaskFailedException {
        this.created = new SimpleDateFormat("dd/mm/yyyy").format(new Date());
        try {
            this.created = this.formatter.format(this.sdf.parse(this.created));
            EgovMasterDataCaching.removeFromCache((String)"egi-activeCoaCodes");
            EgovMasterDataCaching.removeFromCache((String)"egi-coaCodes");
            EgovMasterDataCaching.removeFromCache((String)"egi-chartOfAccounts");
            EgovMasterDataCaching.removeFromCache((String)"egi-coaPurposeId10");
            EgovMasterDataCaching.removeFromCache((String)"egi-accountCodes");
            EgovMasterDataCaching.removeFromCache((String)"egi-liabilityCOACodes");
            EgovMasterDataCaching.removeFromCache((String)"egi-coaCodesForLiability");
            this.setLastModified(this.created);
            this.setId(String.valueOf(PrimaryKeyGenerator.getNextKey("ChartOfAccounts")));
            String insertQuery = "INSERT INTO ChartOfAccounts (id, glCode, name, description, isActiveForPosting,  parentId, lastModified, modifiedBy, created,  purposeid,functionreqd, operation,type,classification,class,budgetCheckReq,majorcode)values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"INSERT INTO ChartOfAccounts (id, glCode, name, description, isActiveForPosting,  parentId, lastModified, modifiedBy, created,  purposeid,functionreqd, operation,type,classification,class,budgetCheckReq,majorcode)values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            }
            this.persistenceService.getSession().createSQLQuery("INSERT INTO ChartOfAccounts (id, glCode, name, description, isActiveForPosting,  parentId, lastModified, modifiedBy, created,  purposeid,functionreqd, operation,type,classification,class,budgetCheckReq,majorcode)values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)").setInteger(0, Integer.parseInt(this.id)).setString(1, this.removeSingleQuotes(this.glCode)).setString(2, this.removeSingleQuotes(this.name)).setString(3, this.removeSingleQuotes(this.description)).setString(4, this.removeSingleQuotes(this.isActiveForPosting)).setString(5, this.removeSingleQuotes(this.parentId)).setString(6, this.removeSingleQuotes(this.lastModified)).setString(7, this.removeSingleQuotes(this.modifiedBy)).setString(8, this.removeSingleQuotes(this.created)).setString(9, this.removeSingleQuotes(this.purposeid)).setString(10, this.removeSingleQuotes(this.functionreqd)).setString(11, this.removeSingleQuotes(this.operation)).setString(12, this.removeSingleQuotes(this.type)).setString(13, this.removeSingleQuotes(this.classification)).setString(14, this.removeSingleQuotes(this.classname)).setString(15, this.removeSingleQuotes(this.budgetCheckReqd)).setString(16, this.removeSingleQuotes(this.getMajorCode(this.glCode))).executeUpdate();
        }
        catch (HibernateException e) {
            LOGGER.error((Object)("Exception occured while getting the data  " + e.getMessage()), (Throwable)new HibernateException(e.getMessage()));
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exception occured while getting the data  " + e.getMessage()), (Throwable)new Exception(e.getMessage()));
        }
    }

    private String removeSingleQuotes(String obj) {
        if (obj != null) {
            obj = obj.replaceAll("'", "");
        }
        return obj;
    }

    private String getMajorCode(String glcode) throws TaskFailedException {
        List appList = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "coa_majorcode_length");
        if (appList == null || appList.isEmpty()) {
            throw new TaskFailedException("coa_majorcode_length is not defined in appconfig");
        }
        int majorcodelength = Integer.valueOf(((AppConfigValues)appList.get(0)).getValue());
        String glcode1 = glcode.substring(0, glcode.length());
        return glcode1.length() >= majorcodelength ? "'" + glcode1.substring(0, majorcodelength) + "'" : "''";
    }

    @Transactional
    public void update() throws SQLException, TaskFailedException {
        if (this.isId && this.isField) {
            this.newUpdate();
        }
    }

    public void newUpdate() throws TaskFailedException, SQLException {
        SQLQuery pstmt;
        block49: {
            this.created = this.eGovernCommon.getCurrentDate();
            pstmt = null;
            try {
                this.created = this.formatter.format(this.sdf.parse(this.created));
            }
            catch (ParseException parseExp) {
                if (!LOGGER.isDebugEnabled()) break block49;
                LOGGER.debug((Object)parseExp.getMessage(), (Throwable)parseExp);
            }
        }
        this.setCreated(this.created);
        this.setLastModified(this.created);
        StringBuilder query = new StringBuilder(500);
        query.append("update ChartOfAccounts set ");
        if (this.glCode != null) {
            query.append("glCode=?,");
        }
        if (this.name != null) {
            query.append("name=?,");
        }
        if (this.description != null) {
            query.append("description=?,");
        }
        if (this.isActiveForPosting != null) {
            query.append("ISACTIVEFORPOSTING=?,");
        }
        if (this.parentId != null) {
            query.append("PARENTID=?,");
        }
        if (this.lastModified != null) {
            query.append("LASTMODIFIED=?,");
        }
        if (this.modifiedBy != null) {
            query.append("MODIFIEDBY=?,");
        }
        if (this.created != null) {
            query.append("CREATED=?,");
        }
        if (this.purposeid != null) {
            query.append("PURPOSEID=?,");
        }
        if (this.operation != null) {
            query.append("OPERATION=?,");
        }
        if (this.FIEoperation != null) {
            query.append("FIEOPERATION=?,");
        }
        if (this.type != null) {
            query.append("type=?,");
        }
        if (this.classname != null) {
            query.append("class=?,");
        }
        if (this.classification != null) {
            query.append("CLASSIFICATION=?,");
        }
        if (this.functionreqd != null) {
            query.append("FUNCTIONREQD=?,");
        }
        if (this.scheduleId != null) {
            query.append("SCHEDULEID=?,");
        }
        if (this.FIEscheduleId != null) {
            query.append("FIEscheduleId=?,");
        }
        if (this.receiptscheduleid != null) {
            query.append("RECEIPTSCHEDULEID=?,");
        }
        if (this.receiptoperation != null) {
            query.append("RECEIPTOPERATION=?,");
        }
        if (this.paymentscheduleid != null) {
            query.append("PAYMENTSCHEDULEID=?,");
        }
        if (this.paymentoperation != null) {
            query.append("PAYMENTOPERATION=?,");
        }
        if (this.budgetCheckReqd != null) {
            query.append("BUDGETCHECKREQ=?,");
        }
        int lastIndexOfComma = query.lastIndexOf(",");
        query.deleteCharAt(lastIndexOfComma);
        query.append(" where id=?");
        try {
            int i = 1;
            pstmt = this.persistenceService.getSession().createSQLQuery(query.toString());
            if (this.glCode != null) {
                pstmt.setString(i++, this.glCode);
            }
            if (this.name != null) {
                pstmt.setString(i++, this.name);
            }
            if (this.description != null) {
                pstmt.setString(i++, this.description);
            }
            if (this.isActiveForPosting != null) {
                pstmt.setString(i++, this.isActiveForPosting);
            }
            if (this.parentId != null) {
                pstmt.setString(i++, this.parentId);
            }
            if (this.lastModified != null) {
                pstmt.setString(i++, this.lastModified);
            }
            if (this.modifiedBy != null) {
                pstmt.setString(i++, this.modifiedBy);
            }
            if (this.created != null) {
                pstmt.setString(i++, this.created);
            }
            if (this.purposeid != null) {
                pstmt.setString(i++, this.purposeid);
            }
            if (this.operation != null) {
                pstmt.setString(i++, this.operation);
            }
            if (this.FIEoperation != null) {
                pstmt.setString(i++, this.FIEoperation);
            }
            if (this.type != null) {
                pstmt.setString(i++, this.type);
            }
            if (this.classname != null) {
                pstmt.setString(i++, this.classname);
            }
            if (this.classification != null) {
                pstmt.setString(i++, this.classification);
            }
            if (this.functionreqd != null) {
                pstmt.setString(i++, this.functionreqd);
            }
            if (this.scheduleId != null) {
                pstmt.setString(i++, this.scheduleId);
            }
            if (this.FIEscheduleId != null) {
                pstmt.setInteger(i++, this.FIEscheduleId.intValue());
            }
            if (this.receiptscheduleid != null) {
                pstmt.setString(i++, this.receiptscheduleid);
            }
            if (this.receiptoperation != null) {
                pstmt.setString(i++, this.receiptoperation);
            }
            if (this.paymentscheduleid != null) {
                pstmt.setString(i++, this.paymentscheduleid);
            }
            if (this.paymentoperation != null) {
                pstmt.setString(i++, this.paymentoperation);
            }
            if (this.budgetCheckReqd != null) {
                pstmt.setString(i++, this.budgetCheckReqd);
            }
            pstmt.setString(i++, this.id);
            pstmt.executeUpdate();
        }
        catch (HibernateException e) {
            LOGGER.error((Object)("Exception occured while getting the data  " + e.getMessage()), (Throwable)new HibernateException(e.getMessage()));
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exception occured while getting the data  " + e.getMessage()), (Throwable)new Exception(e.getMessage()));
        }
    }
}

