/*
 * Decompiled with CFR 0.152.
 */
package com.exilant.GLEngine;

import com.exilant.GLEngine.AccountDetailType;
import com.exilant.GLEngine.ChartOfAccounts;
import com.exilant.GLEngine.GLAccount;
import com.exilant.GLEngine.GLParameter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.egov.commons.CChartOfAccountDetail;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.service.ChartOfAccountDetailService;
import org.egov.infra.cache.impl.ApplicationCacheManager;
import org.egov.infstr.services.PersistenceService;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.transform.Transformers;
import org.hibernate.type.BooleanType;
import org.hibernate.type.IntegerType;
import org.hibernate.type.LongType;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class CoaCache
implements Serializable {
    @Autowired
    @Qualifier(value="persistenceService")
    PersistenceService persistenceService;
    @Autowired
    @Qualifier(value="chartOfAccountDetailService")
    private ChartOfAccountDetailService chartOfAccountDetailService;
    @Autowired
    private ApplicationCacheManager applicationCacheManager;
    private static final Logger LOGGER = Logger.getLogger(ChartOfAccounts.class);
    private static final String ROOTNODE = "/COA";
    private static final String GLACCCODENODE = "GlAccountCodes";
    private static final String GLACCIDNODE = "GlAccountIds";
    private static final String ACCOUNTDETAILTYPENODE = "AccountDetailType";
    private static final String EXP = "Exp=";
    private static final String EXILRPERROR = "exilRPError";

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void loadAccountData() {
        HashMap<String, Serializable> glAccountCodes = new HashMap<String, Serializable>();
        HashMap<Long, Serializable> glAccountIds = new HashMap<Long, Serializable>();
        HashMap<String, AccountDetailType> accountDetailType = new HashMap<String, AccountDetailType>();
        String sql = "select id as \"id\",name as \"name\",tableName as \"tableName\",description as \"description\",columnName as \"columnName\",attributeName as \"attributeName\",nbrOfLevels as  \"nbrOfLevels\" from AccountDetailType";
        Session currentSession = this.persistenceService.getSession();
        SQLQuery createSQLQuery = currentSession.createSQLQuery(sql);
        createSQLQuery.addScalar("id", (Type)IntegerType.INSTANCE).addScalar("name").addScalar("tableName").addScalar("description").addScalar("columnName").addScalar("attributeName").setResultTransformer(Transformers.aliasToBean(AccountDetailType.class));
        List accountDetailTypeList = new ArrayList();
        List glAccountCodesList = new ArrayList();
        new ArrayList();
        accountDetailTypeList = createSQLQuery.list();
        for (Serializable type : accountDetailTypeList) {
            accountDetailType.put(((AccountDetailType)type).getAttributeName(), (AccountDetailType)type);
        }
        sql = "select ID as \"ID\", glCode as \"glCode\" ,name as \"name\" ,isActiveForPosting as \"isActiveForPosting\" ,classification as \"classification\", functionReqd as \"functionRequired\" from chartofaccounts ";
        createSQLQuery = currentSession.createSQLQuery(sql);
        createSQLQuery.addScalar("ID", (Type)IntegerType.INSTANCE).addScalar("glCode").addScalar("name").addScalar("isActiveForPosting", (Type)BooleanType.INSTANCE).addScalar("classification", (Type)LongType.INSTANCE).addScalar("functionRequired", (Type)BooleanType.INSTANCE).setResultTransformer(Transformers.aliasToBean(GLAccount.class));
        glAccountCodesList = createSQLQuery.list();
        for (Serializable type : glAccountCodesList) {
            glAccountCodes.put(((GLAccount)type).getCode(), type);
        }
        for (Serializable type : glAccountCodesList) {
            glAccountIds.put(((GLAccount)type).getId(), type);
        }
        this.loadParameters(glAccountCodes, glAccountIds);
        HashMap<String, HashMap<Object, Serializable>> hm = new HashMap<String, HashMap<Object, Serializable>>();
        hm.put(ACCOUNTDETAILTYPENODE, accountDetailType);
        hm.put(GLACCCODENODE, glAccountCodes);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Loading size:" + glAccountCodes.size()));
        }
        hm.put(GLACCIDNODE, glAccountIds);
        this.applicationCacheManager.put((Object)ROOTNODE, hm);
    }

    private synchronized void loadParameters(HashMap glAccountCodes, HashMap glAccountIds) {
        List chList = this.chartOfAccountDetailService.findAllBy("from CChartOfAccountDetail", new Object[0]);
        for (CChartOfAccountDetail chartOfAccountDetail : chList) {
            GLParameter parameter = new GLParameter();
            parameter.setDetailId(chartOfAccountDetail.getDetailTypeId().getId());
            parameter.setDetailName(chartOfAccountDetail.getDetailTypeId().getAttributename());
            GLAccount glAccCode = CoaCache.getGlAccCode(chartOfAccountDetail.getGlCodeId(), glAccountCodes);
            GLAccount glAccId = CoaCache.getGlAccId(chartOfAccountDetail.getGlCodeId(), glAccountIds);
            if (glAccCode != null && glAccCode.getGLParameters() != null) {
                glAccCode.getGLParameters().add(parameter);
            }
            if (glAccId == null || glAccId.getGLParameters() == null) continue;
            glAccId.getGLParameters().add(parameter);
        }
    }

    private static GLAccount getGlAccCode(CChartOfAccounts glCodeId, Map glAccountCodes) {
        for (Object key : glAccountCodes.keySet()) {
            if (!((String)key).equalsIgnoreCase(glCodeId.getGlcode())) continue;
            return (GLAccount)glAccountCodes.get(key);
        }
        return null;
    }

    private static GLAccount getGlAccId(CChartOfAccounts glCodeId, Map glAccountIds) {
        for (Object key : glAccountIds.keySet()) {
            if (!key.toString().equalsIgnoreCase(glCodeId.getId().toString())) continue;
            return (GLAccount)glAccountIds.get(key);
        }
        return null;
    }

    private void clear() {
        this.applicationCacheManager.remove((Object)ROOTNODE);
    }

    public void reLoad() {
        this.applicationCacheManager.remove((Object)ROOTNODE);
        this.loadAccountData();
    }
}

