/*
 * Decompiled with CFR 0.152.
 */
package org.egov.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.egov.infra.admin.master.entity.AppConfig;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infstr.services.PersistenceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class BudgetDetailConfig {
    private static final String DELIMITER = ",";
    @Autowired
    @Qualifier(value="persistenceService")
    private final PersistenceService persistenceService;
    List<String> headerFields = new ArrayList<String>();
    List<String> gridFields = new ArrayList<String>();
    List<String> mandatoryFields = new ArrayList<String>();

    public BudgetDetailConfig(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
        this.headerFields = this.fetchAppConfigValues("budgetDetail.header.component");
        this.gridFields = this.fetchAppConfigValues("budgetDetail.grid.component");
        this.mandatoryFields = this.fetchAppConfigValues("budgetDetail_mandatory_fields");
    }

    public final List<String> getGridFields() {
        return this.gridFields;
    }

    public final List<String> getMandatoryFields() {
        return this.mandatoryFields;
    }

    public final List<String> getHeaderFields() {
        return this.headerFields;
    }

    final List<String> fetchAppConfigValues(String keyName) {
        AppConfig appConfig = (AppConfig)this.persistenceService.find("from AppConfig where key_name='" + keyName + "'");
        if (appConfig != null && appConfig.getAppDataValues() != null && appConfig.getAppDataValues().iterator().hasNext()) {
            AppConfigValues appDataValues = (AppConfigValues)appConfig.getAppDataValues().iterator().next();
            return Arrays.asList(appDataValues.getValue().split(DELIMITER));
        }
        return new ArrayList<String>();
    }

    public final boolean shouldShowField(List<String> fieldList, String field) {
        return fieldList.isEmpty() || fieldList.contains(field);
    }

    public void checkHeaderMandatoryField(Map<String, Object> valuesToBeChecked) {
        for (Map.Entry<String, Object> entry : valuesToBeChecked.entrySet()) {
            if (!this.headerFields.contains(entry.getKey()) || !this.mandatoryFields.contains(entry.getKey()) || entry.getValue() != null) continue;
            throw new ValidationException(Arrays.asList(new ValidationError("budgetDetail." + entry.getKey() + ".mandatory", "budgetDetail." + entry.getKey() + ".mandatory")));
        }
    }

    public void checkGridMandatoryField(Map<String, Object> valuesToBeChecked) {
        for (Map.Entry<String, Object> entry : valuesToBeChecked.entrySet()) {
            if (!this.gridFields.contains(entry.getKey()) || !this.mandatoryFields.contains(entry.getKey()) || entry.getValue() != null) continue;
            throw new ValidationException(Arrays.asList(new ValidationError("budgetDetail." + entry.getKey() + ".mandatory", "budgetDetail." + entry.getKey() + ".mandatory")));
        }
    }
}

