/*
 * Decompiled with CFR 0.152.
 */
package org.egov.services.report;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.egov.commons.Fund;
import org.egov.egf.model.IEStatementEntry;
import org.egov.egf.model.Statement;
import org.egov.egf.model.StatementResultObject;
import org.egov.infstr.services.PersistenceService;
import org.egov.services.report.FunctionwiseIEService;
import org.egov.services.report.ReportService;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class IncomeExpenditureService
extends ReportService {
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    private static final String I = "I";
    private static final String E = "E";
    private static final String IE = "IE";
    Date fromDate;
    Date toDate;
    private static final BigDecimal NEGATIVE = new BigDecimal(-1);
    private FunctionwiseIEService functionwiseIEService;

    public FunctionwiseIEService getFunctionwiseIEService() {
        return this.functionwiseIEService;
    }

    public void setFunctionwiseIEService(FunctionwiseIEService functionwiseIEService) {
        this.functionwiseIEService = functionwiseIEService;
    }

    @Override
    protected void addRowsToStatement(Statement balanceSheet, Statement assets, Statement liabilities) {
        IEStatementEntry incomeEntry = new IEStatementEntry();
        IEStatementEntry expenseEntry = new IEStatementEntry();
        List<Object> totalIncomeOverExpense = new ArrayList();
        if (liabilities.sizeIE() > 0) {
            balanceSheet.addIE(new IEStatementEntry(null, "INCOME", "", true));
            incomeEntry = this.getTotalIncomeFundwise(liabilities);
            balanceSheet.addAllIE(liabilities);
            balanceSheet.addIE(incomeEntry);
        }
        if (assets.sizeIE() > 0) {
            balanceSheet.addIE(new IEStatementEntry(null, "EXPENDITURE", "", true));
            expenseEntry = this.getTotalExpenseFundwise(assets);
            balanceSheet.addAllIE(assets);
            balanceSheet.addIE(expenseEntry);
        }
        totalIncomeOverExpense = this.computeTotalsIncomeExpense(incomeEntry, expenseEntry);
        for (IEStatementEntry iEStatementEntry : totalIncomeOverExpense) {
            balanceSheet.addIE(iEStatementEntry);
        }
    }

    public void populateIEStatement(Statement ie) {
        this.minorCodeLength = Integer.valueOf(this.getAppConfigValueFor("EGF", "coa_minorcode_length"));
        this.coaType.add(Character.valueOf('I'));
        this.coaType.add(Character.valueOf('E'));
        this.fromDate = this.getFromDate(ie);
        this.toDate = this.getToDate(ie);
        String filterQuery = this.getFilterQuery(ie);
        this.populateCurrentYearAmountPerFund(ie, filterQuery, this.toDate, this.fromDate, IE);
        ie = this.addBudgetDetails(ie);
        this.removeFundsWithNoDataIE(ie);
    }

    private Statement addBudgetDetails(Statement ie) {
        List<StatementResultObject> budgetForMajorCodes = this.getBudgetForMajorCodes(ie);
        LOGGER.error((Object)"Budget Amounts.................................");
        this.print(budgetForMajorCodes);
        List<StatementResultObject> budgetReappForMajorCodes = this.getBudgetReappMinorCodes(ie);
        LOGGER.error((Object)"Budget Reapp Amounts...........................");
        this.print(budgetReappForMajorCodes);
        BigDecimal totalBudget = BigDecimal.ZERO;
        for (StatementResultObject statementResultObject : budgetForMajorCodes) {
            for (StatementResultObject stm : budgetReappForMajorCodes) {
                if (statementResultObject.getGlCode() == null || !statementResultObject.getGlCode().equalsIgnoreCase(stm.getGlCode())) continue;
                if (statementResultObject.getAmount() != null) {
                    if (stm.getAmount() == null) continue;
                    statementResultObject.setAmount(statementResultObject.getAmount().add(stm.getAmount()));
                    continue;
                }
                if (stm.getAmount() == null) continue;
                statementResultObject.setAmount(stm.getAmount());
            }
        }
        for (IEStatementEntry iEStatementEntry : ie.getIeEntries()) {
            for (StatementResultObject stm : budgetForMajorCodes) {
                if (iEStatementEntry.getGlCode() == null || !iEStatementEntry.getGlCode().equalsIgnoreCase(stm.getGlCode())) continue;
                iEStatementEntry.setBudgetAmount(stm.getAmount().setScale(2));
                totalBudget = totalBudget.add(iEStatementEntry.getBudgetAmount());
            }
        }
        for (IEStatementEntry iEStatementEntry : ie.getIeEntries()) {
            if (iEStatementEntry.getAccountName() == null || !iEStatementEntry.getAccountName().equalsIgnoreCase("Total EXPENDITURE")) continue;
            iEStatementEntry.setBudgetAmount(totalBudget);
        }
        return ie;
    }

    private void print(List<StatementResultObject> list) {
        for (StatementResultObject stm : list) {
            LOGGER.error((Object)(stm.getGlCode() + "         " + stm.getAmount()));
        }
    }

    public void populateCurrentYearAmountPerFund(Statement statement, String filterQuery, Date toDate, Date fromDate, String scheduleReportType) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)" inside populateCurrentYearAmountPerFund ");
        }
        BigDecimal divisor = statement.getDivisor();
        Statement expenditure = new Statement();
        Statement income = new Statement();
        List<StatementResultObject> allGlCodes = this.getAllGlCodesFor(scheduleReportType);
        List<StatementResultObject> results = this.getTransactionAmount(filterQuery, toDate, fromDate, "'I','E'", IE);
        List<StatementResultObject> PreYearResults = this.getTransactionAmount(filterQuery, this.getPreviousYearFor(toDate), this.getPreviousYearFor(fromDate), "'I','E'", scheduleReportType);
        for (StatementResultObject queryObject : allGlCodes) {
            List<StatementResultObject> rows;
            if (queryObject.getGlCode() == null) {
                queryObject.setGlCode("");
            }
            if ((rows = this.getRowWithGlCode(results, queryObject.getGlCode())).isEmpty() && queryObject.getGlCode() != null) {
                if (!this.contains(PreYearResults, queryObject.getGlCode())) continue;
                List<StatementResultObject> preRow = this.getRowWithGlCode(PreYearResults, queryObject.getGlCode());
                IEStatementEntry preentry = new IEStatementEntry();
                for (StatementResultObject pre : preRow) {
                    if (I.equalsIgnoreCase(queryObject.getType().toString())) {
                        if (pre.isIncome()) {
                            pre.negateAmount();
                        }
                        preentry.getPreviousYearAmount().put(this.getFundNameForId(statement.getFunds(), (int)pre.getFundId()), this.divideAndRound(pre.getAmount(), divisor));
                        continue;
                    }
                    if (!E.equalsIgnoreCase(queryObject.getType().toString())) continue;
                    if (pre.isIncome()) {
                        pre.negateAmount();
                    }
                    preentry.getPreviousYearAmount().put(this.getFundNameForId(statement.getFunds(), (int)pre.getFundId()), this.divideAndRound(pre.getAmount(), divisor));
                }
                if (queryObject.getGlCode() != null) {
                    preentry.setGlCode(queryObject.getGlCode());
                    preentry.setAccountName(queryObject.getScheduleName());
                    preentry.setScheduleNo(queryObject.getScheduleNumber());
                }
                if (I.equalsIgnoreCase(queryObject.getType().toString())) {
                    income.addIE(preentry);
                    continue;
                }
                if (!E.equalsIgnoreCase(queryObject.getType().toString())) continue;
                expenditure.addIE(preentry);
                continue;
            }
            for (StatementResultObject row : rows) {
                if (row.isIncome()) {
                    row.negateAmount();
                }
                if (income.containsIEStatementEntry(row.getGlCode()) || expenditure.containsIEStatementEntry(row.getGlCode())) {
                    if (I.equalsIgnoreCase(row.getType().toString())) {
                        this.addFundAmountIE(statement.getFunds(), income, divisor, row);
                        continue;
                    }
                    if (!E.equalsIgnoreCase(row.getType().toString())) continue;
                    this.addFundAmountIE(statement.getFunds(), expenditure, divisor, row);
                    continue;
                }
                IEStatementEntry entry = new IEStatementEntry();
                if (row.getAmount() != null && row.getFundId() != null) {
                    entry.getNetAmount().put(this.getFundNameForId(statement.getFunds(), (int)row.getFundId()), this.divideAndRound(row.getAmount(), divisor));
                    if (queryObject.getGlCode() != null && this.contains(PreYearResults, row.getGlCode())) {
                        List<StatementResultObject> preRow = this.getRowWithGlCode(PreYearResults, queryObject.getGlCode());
                        for (StatementResultObject pre : preRow) {
                            if (pre.isIncome()) {
                                pre.negateAmount();
                            }
                            if (pre.getGlCode() == null || !pre.getGlCode().equals(row.getGlCode())) continue;
                            entry.getPreviousYearAmount().put(this.getFundNameForId(statement.getFunds(), (int)pre.getFundId()), this.divideAndRound(pre.getAmount(), divisor));
                        }
                    }
                }
                if (queryObject.getGlCode() != null) {
                    entry.setGlCode(queryObject.getGlCode());
                    entry.setAccountName(queryObject.getScheduleName());
                    entry.setScheduleNo(queryObject.getScheduleNumber());
                }
                if (I.equalsIgnoreCase(row.getType().toString())) {
                    income.addIE(entry);
                    continue;
                }
                if (!E.equalsIgnoreCase(row.getType().toString())) continue;
                expenditure.addIE(entry);
            }
        }
        this.addRowsToStatement(statement, expenditure, income);
    }

    private List<IEStatementEntry> computeTotalsIncomeExpense(IEStatementEntry incomeFundTotals, IEStatementEntry expenditureFundTotals) {
        BigDecimal amount;
        HashMap<String, BigDecimal> netTotal = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> preTotal = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> netTotalin_ex = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> preTotalin_ex = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> netTotalex_in = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> preTotalex_in = new HashMap<String, BigDecimal>();
        HashSet<Object> netFundSet = new HashSet();
        HashSet<Object> preFundSet = new HashSet();
        BigDecimal curAmount = BigDecimal.ZERO;
        String prevoius = "PREVIOUS";
        String current = "CURRENT";
        netFundSet = this.getAllKey(incomeFundTotals, expenditureFundTotals, "CURRENT");
        preFundSet = this.getAllKey(incomeFundTotals, expenditureFundTotals, "PREVIOUS");
        IEStatementEntry income = new IEStatementEntry();
        IEStatementEntry expense = new IEStatementEntry();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Calculating income over expenses");
        }
        ArrayList<IEStatementEntry> incomeOverExpenditure = new ArrayList<IEStatementEntry>();
        for (String string : netFundSet) {
            if (incomeFundTotals.getNetAmount().containsKey(string)) {
                amount = this.zeroOrValue(incomeFundTotals.getNetAmount().get(string));
                netTotal.put(string, amount.subtract(this.zeroOrValue(expenditureFundTotals.getNetAmount().get(string))));
                continue;
            }
            if (!expenditureFundTotals.getNetAmount().containsKey(string) || incomeFundTotals.getNetAmount().containsKey(string)) continue;
            amount = this.zeroOrValue(incomeFundTotals.getNetAmount().get(string));
            netTotal.put(string, amount.subtract(this.zeroOrValue(expenditureFundTotals.getNetAmount().get(string))));
        }
        for (String string : preFundSet) {
            if (incomeFundTotals.getPreviousYearAmount().containsKey(string)) {
                amount = this.zeroOrValue(incomeFundTotals.getPreviousYearAmount().get(string));
                preTotal.put(string, amount.subtract(this.zeroOrValue(expenditureFundTotals.getPreviousYearAmount().get(string))));
                continue;
            }
            if (!expenditureFundTotals.getPreviousYearAmount().containsKey(string) || incomeFundTotals.getPreviousYearAmount().containsKey(string)) continue;
            this.zeroOrValue(incomeFundTotals.getPreviousYearAmount().get(string));
            preTotal.put(string, expenditureFundTotals.getPreviousYearAmount().get(string));
        }
        for (String string : netFundSet) {
            int isIncome = ((BigDecimal)netTotal.get(string)).signum();
            if (isIncome > 0) {
                netTotalin_ex.put(string, (BigDecimal)netTotal.get(string));
                income.setGlCode("A-B");
                income.setAccountName("Income Over Expenditure");
                income.setDisplayBold(true);
                income.setNetAmount(netTotalin_ex);
                continue;
            }
            curAmount = this.zeroOrValue((BigDecimal)netTotal.get(string)).negate();
            netTotalex_in.put(string, curAmount);
            expense.setGlCode("B-A");
            expense.setAccountName("Expenditure Over Income");
            expense.setNetAmount(netTotalex_in);
            expense.setDisplayBold(true);
        }
        for (String string : preFundSet) {
            int isIncome = ((BigDecimal)preTotal.get(string)).signum();
            if (isIncome > 0) {
                if (income.getGlCode() != null) {
                    preTotalin_ex.put(string, (BigDecimal)preTotal.get(string));
                    income.setPreviousYearAmount(preTotalin_ex);
                    continue;
                }
                preTotalin_ex.put(string, (BigDecimal)preTotal.get(string));
                income.setPreviousYearAmount(preTotalin_ex);
                income.setGlCode("A-B");
                income.setAccountName("Income Over Expenditure");
                income.setDisplayBold(true);
                preTotalin_ex.put(string, (BigDecimal)preTotal.get(string));
                income.setPreviousYearAmount(preTotalin_ex);
                continue;
            }
            if (expense.getGlCode() != null) {
                preTotalex_in.put(string, ((BigDecimal)preTotal.get(string)).negate());
                expense.setPreviousYearAmount(preTotalex_in);
                continue;
            }
            curAmount = this.zeroOrValue((BigDecimal)preTotal.get(string)).negate();
            preTotalex_in.put(string, curAmount);
            expense.setGlCode("B-A");
            expense.setAccountName("Expenditure Over Income");
            expense.setDisplayBold(true);
            preTotalex_in.put(string, curAmount);
            expense.setPreviousYearAmount(preTotalex_in);
        }
        incomeOverExpenditure.add(income);
        incomeOverExpenditure.add(expense);
        return incomeOverExpenditure;
    }

    boolean contains(List<StatementResultObject> result, String glCode) {
        for (StatementResultObject row : result) {
            if (row.getGlCode() == null || !row.getGlCode().equalsIgnoreCase(glCode)) continue;
            return true;
        }
        return false;
    }

    void addFundPreviousAmountIE(List<Fund> fundList, Statement type, BigDecimal divisor, StatementResultObject row) {
        for (int index = 0; index < type.size(); ++index) {
            BigDecimal amount = this.divideAndRound(row.getAmount(), divisor);
            if (type.get(index).getGlCode() == null || !row.getGlCode().equals(type.get(index).getGlCode())) continue;
            type.getIE(index).getPreviousYearAmount().put(this.getFundNameForId(fundList, (int)row.getFundId()), amount);
        }
    }

    private IEStatementEntry getTotalIncomeFundwise(Statement income_expense) {
        HashMap<String, BigDecimal> fundNetTotals = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> fundPreTotals = new HashMap<String, BigDecimal>();
        BigDecimal netAmount = BigDecimal.ZERO;
        BigDecimal preAmount = BigDecimal.ZERO;
        for (IEStatementEntry entry : income_expense.getIeEntries()) {
            for (Map.Entry<String, BigDecimal> row : entry.getNetAmount().entrySet()) {
                if (fundNetTotals.get(row.getKey()) == null) {
                    fundNetTotals.put(row.getKey(), BigDecimal.ZERO);
                }
                netAmount = this.zeroOrValue(row.getValue());
                fundNetTotals.put(row.getKey(), netAmount.add(this.zeroOrValue((BigDecimal)fundNetTotals.get(row.getKey()))));
            }
            for (Map.Entry<String, BigDecimal> prerow : entry.getPreviousYearAmount().entrySet()) {
                if (fundPreTotals.get(prerow.getKey()) == null) {
                    fundPreTotals.put(prerow.getKey(), BigDecimal.ZERO);
                }
                preAmount = this.zeroOrValue(prerow.getValue());
                fundPreTotals.put(prerow.getKey(), preAmount.add(this.zeroOrValue((BigDecimal)fundPreTotals.get(prerow.getKey()))));
            }
        }
        return new IEStatementEntry("A", "Total INCOME", fundNetTotals, fundPreTotals, true);
    }

    private IEStatementEntry getTotalExpenseFundwise(Statement income_expense) {
        HashMap<String, BigDecimal> fundNetTotals = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> fundPreTotals = new HashMap<String, BigDecimal>();
        BigDecimal netAmount = BigDecimal.ZERO;
        BigDecimal preAmount = BigDecimal.ZERO;
        for (IEStatementEntry entry : income_expense.getIeEntries()) {
            for (Map.Entry<String, BigDecimal> row : entry.getNetAmount().entrySet()) {
                if (fundNetTotals.get(row.getKey()) == null) {
                    fundNetTotals.put(row.getKey(), BigDecimal.ZERO);
                }
                netAmount = this.zeroOrValue(row.getValue());
                fundNetTotals.put(row.getKey(), netAmount.add(this.zeroOrValue((BigDecimal)fundNetTotals.get(row.getKey()))));
            }
            for (Map.Entry<String, BigDecimal> prerow : entry.getPreviousYearAmount().entrySet()) {
                if (fundPreTotals.get(prerow.getKey()) == null) {
                    fundPreTotals.put(prerow.getKey(), BigDecimal.ZERO);
                }
                preAmount = this.zeroOrValue(prerow.getValue());
                fundPreTotals.put(prerow.getKey(), preAmount.add(this.zeroOrValue((BigDecimal)fundPreTotals.get(prerow.getKey()))));
            }
        }
        return new IEStatementEntry("B", "Total EXPENDITURE", fundNetTotals, fundPreTotals, true);
    }

    private HashSet<String> getAllKey(IEStatementEntry incomeFundTotals, IEStatementEntry expenditureFundTotals, String amtType) {
        HashSet<String> allFundSet = new HashSet<String>();
        if (amtType.equals("CURRENT")) {
            for (Map.Entry<String, BigDecimal> row : incomeFundTotals.getNetAmount().entrySet()) {
                allFundSet.add(row.getKey());
            }
            for (Map.Entry<String, BigDecimal> row : expenditureFundTotals.getNetAmount().entrySet()) {
                allFundSet.add(row.getKey());
            }
        } else {
            for (Map.Entry<String, BigDecimal> row : incomeFundTotals.getPreviousYearAmount().entrySet()) {
                allFundSet.add(row.getKey());
            }
            for (Map.Entry<String, BigDecimal> row : expenditureFundTotals.getPreviousYearAmount().entrySet()) {
                allFundSet.add(row.getKey());
            }
        }
        return allFundSet;
    }

    private List<StatementResultObject> getBudgetForMajorCodes(Statement incomeExpenditureStatement) {
        StringBuffer queryStr = new StringBuffer(1024);
        queryStr.append(" select coa.majorCode as glcode, sum(bd.approvedamount) as amount ");
        queryStr.append(" from egf_budgetdetail bd , egf_budgetgroup bg,egf_budget b, chartofaccounts coa, eg_wf_states wfs ");
        queryStr.append("where ((bg.maxcode<=coa.id and bg.mincode>=coa.id) or bg.majorcode=coa.id ) and bd.budgetgroup= bg.id  and bd.budget=b.id and  bd.state_id=wfs.id  and wfs.value='END'  and b.isbere=:isBeRe and b.financialyearid=:finYearId   ");
        if (incomeExpenditureStatement.getFund() != null && incomeExpenditureStatement.getFund().getId() != null && incomeExpenditureStatement.getFund().getId() != 0) {
            queryStr.append(" and bd.fund=" + incomeExpenditureStatement.getFund().getId());
        }
        if (incomeExpenditureStatement.getDepartment() != null && incomeExpenditureStatement.getDepartment().getId() != 0L) {
            queryStr.append(" and bd.executing_department=" + incomeExpenditureStatement.getDepartment().getId());
        }
        if (incomeExpenditureStatement.getFunction() != null && incomeExpenditureStatement.getFunction().getId() != null && incomeExpenditureStatement.getFunction().getId() != 0L) {
            queryStr.append("  and bd.function= " + incomeExpenditureStatement.getFunction().getId());
        }
        queryStr.append(" and coa.majorcode is not null  group by coa.majorCode ");
        queryStr.append(" order by 1");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("query is " + queryStr.toString()));
        }
        SQLQuery budgteQuery = this.persistenceService.getSession().createSQLQuery(queryStr.toString());
        budgteQuery.addScalar("glCode").addScalar("amount").setResultTransformer(Transformers.aliasToBean(StatementResultObject.class));
        budgteQuery.setLong("finYearId", incomeExpenditureStatement.getFinancialYear().getId().longValue()).setString("isBeRe", "RE");
        List list = budgteQuery.list();
        return list;
    }

    private List<StatementResultObject> getBudgetReappMinorCodes(Statement incomeExpenditureStatement) {
        StringBuffer queryStr = new StringBuffer(1024);
        queryStr.append(" select coa.majorcode as glCode, sum(bdr.addition_amount- bdr.deduction_amount) as amount ");
        queryStr.append(" from egf_budgetdetail bd , egf_budgetgroup bg,egf_budget b, chartofaccounts coa,eg_wf_states wfs,egf_budget_reappropriation bdr where ((bg.maxcode<=coa.id and bg.mincode>=coa.id) or bg.majorcode=coa.id ) and bd.budgetgroup= bg.id   and bdr.budgetdetail=bd.id and bd.budget=b.id and bdr.state_id=wfs.id  and wfs.value='END' and b.isbere=:isBeRe and b.financialyearid=:finYearId  ");
        if (incomeExpenditureStatement.getFund() != null && incomeExpenditureStatement.getFund().getId() != null && incomeExpenditureStatement.getFund().getId() != 0) {
            queryStr.append(" and bd.fund=" + incomeExpenditureStatement.getFund().getId());
        }
        if (incomeExpenditureStatement.getDepartment() != null && incomeExpenditureStatement.getDepartment().getId() != 0L) {
            queryStr.append(" and bd.executing_department=" + incomeExpenditureStatement.getDepartment().getId());
        }
        if (incomeExpenditureStatement.getFunction() != null && incomeExpenditureStatement.getFunction().getId() != null && incomeExpenditureStatement.getFunction().getId() != 0L) {
            queryStr.append("  and bd.function= " + incomeExpenditureStatement.getFunction().getId());
        }
        queryStr.append("  group by coa.majorCode ");
        queryStr.append(" order by 1 asc");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("query is " + queryStr.toString()));
        }
        SQLQuery budgteReappQuery = this.persistenceService.getSession().createSQLQuery(queryStr.toString());
        budgteReappQuery.addScalar("glCode").addScalar("amount").setResultTransformer(Transformers.aliasToBean(StatementResultObject.class));
        budgteReappQuery.setLong("finYearId", incomeExpenditureStatement.getFinancialYear().getId().longValue()).setString("isBeRe", "RE");
        List list = budgteReappQuery.list();
        return list;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }
}

