/*
 * Decompiled with CFR 0.152.
 */
package org.egov.services.report;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.Fund;
import org.egov.egf.model.IEStatementEntry;
import org.egov.egf.model.Statement;
import org.egov.egf.model.StatementEntry;
import org.egov.infstr.services.PersistenceService;
import org.egov.services.report.ChartOfAccount;
import org.egov.services.report.IncomeExpenditureService;
import org.egov.services.report.ScheduleService;
import org.egov.services.report.Schedules;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class IncomeExpenditureScheduleService
extends ScheduleService {
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    private static final String IE = "IE";
    private static final String I = "I";
    private IncomeExpenditureService incomeExpenditureService;
    private static final Logger LOGGER = Logger.getLogger(IncomeExpenditureScheduleService.class);

    public void populateDataForLedgerSchedule(Statement statement, String majorCode) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Getting ledger details for selected schedlue");
        }
        this.voucherStatusToExclude = this.getAppConfigValueFor("EGF", "statusexcludeReport");
        this.minorCodeLength = Integer.valueOf(this.incomeExpenditureService.getAppConfigValueFor("EGF", "coa_minorcode_length"));
        Date fromDate = this.incomeExpenditureService.getFromDate(statement);
        Date toDate = this.incomeExpenditureService.getToDate(statement);
        String filterQuery = this.incomeExpenditureService.getFilterQuery(statement);
        CChartOfAccounts coa = (CChartOfAccounts)this.find("from CChartOfAccounts where glcode=?", new Object[]{majorCode});
        this.populateCurrentYearAmountForDetail(statement, toDate, fromDate, majorCode, coa.getType(), filterQuery);
        this.incomeExpenditureService.removeFundsWithNoDataIE(statement);
        this.computeAndAddScheduleTotals(statement);
    }

    public void populateDataForAllSchedules(Statement statement) {
        this.voucherStatusToExclude = this.getAppConfigValueFor("EGF", "statusexcludeReport");
        this.minorCodeLength = Integer.valueOf(this.incomeExpenditureService.getAppConfigValueFor("EGF", "coa_minorcode_length"));
        Date fromDate = this.incomeExpenditureService.getFromDate(statement);
        Date toDate = this.incomeExpenditureService.getToDate(statement);
        List<Fund> fundList = statement.getFunds();
        this.populateCurrentYearAmountForAllSchedules(statement, fundList, this.amountPerFundQueryForAllSchedules(this.incomeExpenditureService.getFilterQuery(statement), toDate, fromDate, IE));
        this.populatePreviousYearTotalsForAllSchedules(statement, this.incomeExpenditureService.getFilterQuery(statement), toDate, fromDate);
        this.incomeExpenditureService.removeFundsWithNoData(statement);
        this.incomeExpenditureService.computeCurrentYearTotals(statement, "LIABILITIES", "ASSETS");
        this.computeAndAddTotals(statement);
    }

    private Query populatePreviousYearTotals(Statement statement, Date toDate, Date fromDate, String majorCode, String filterQuery, String fundId) {
        String formattedToDate = "";
        String voucherStatusToExclude = this.getAppConfigValueFor("EGF", "statusexcludeReport");
        String majorCodeQuery = "";
        if (!majorCodeQuery.equals("") && !majorCodeQuery.isEmpty()) {
            majorCodeQuery = " and c.majorcode = '" + majorCode + "' ";
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Getting previous year Details");
        }
        formattedToDate = "Yearly".equalsIgnoreCase(statement.getPeriod()) ? this.incomeExpenditureService.getFormattedDate(fromDate) : this.incomeExpenditureService.getFormattedDate(this.incomeExpenditureService.getPreviousYearFor(toDate));
        SQLQuery query = this.persistenceService.getSession().createSQLQuery("select c.glcode,c.name ,sum(g.debitamount)-sum(g.creditamount),v.fundid ,c.type ,c.majorcode  from generalledger g,chartofaccounts c,voucherheader v ,vouchermis mis where v.id=mis.voucherheaderid and  v.fundid in" + fundId + " and v.id=g.voucherheaderid " + " and c.id=g.glcodeid and v.status not in(" + voucherStatusToExclude + ")  AND v.voucherdate < '" + formattedToDate + "' and v.voucherdate >='" + this.incomeExpenditureService.getFormattedDate(this.incomeExpenditureService.getPreviousYearFor(fromDate)) + "'" + majorCodeQuery + filterQuery + " group by c.glcode, v.fundid,c.name ,c.type ,c.majorcode order by c.glcode,v.fundid,c.type");
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("prevoius year to Date=" + formattedToDate + " and from Date=" + this.incomeExpenditureService.getPreviousYearFor(fromDate)));
        }
        return query;
    }

    public void populateDetailcode(Statement statement) {
        Date fromDate = this.incomeExpenditureService.getFromDate(statement);
        Date toDate = this.incomeExpenditureService.getToDate(statement);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"preparing list to load all detailcode");
        }
        this.populateAmountForAllSchedules(statement, toDate, fromDate, "('I','E')");
        this.incomeExpenditureService.removeFundsWithNoDataIE(statement);
    }

    boolean isIEContainsScheduleEntry(List<Object[]> accountCodeList, String majorCode) {
        for (Object[] row : accountCodeList) {
            if (row[3] == null || !majorCode.equals(row[3].toString())) continue;
            return true;
        }
        return false;
    }

    private void populateAmountForAllSchedules(Statement statement, Date toDate, Date fromDate, String reportType) {
        boolean addrow = false;
        BigDecimal divisor = statement.getDivisor();
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal preAmount = BigDecimal.ZERO;
        new HashMap();
        IEStatementEntry scheduleEntry = new IEStatementEntry();
        HashMap<String, BigDecimal> currentYearScheduleTotal = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> previousYearScheduleTotal = new HashMap<String, BigDecimal>();
        new HashMap();
        new HashMap();
        new HashMap();
        new HashMap();
        boolean addschedulerow = false;
        String forAllCOA = "";
        String filterQuery = this.incomeExpenditureService.getFilterQuery(statement);
        String fundId = this.incomeExpenditureService.getfundList(statement.getFunds());
        this.majorCodeLength = Integer.valueOf(this.incomeExpenditureService.getAppConfigValueFor("EGF", "coa_majorcode_length"));
        List previousLedgerBalance = this.populatePreviousYearTotals(statement, toDate, fromDate, "", filterQuery, fundId).list();
        List<Object[]> CurrentYearLedgerDetail = this.getAllLedgerTransaction("", toDate, fromDate, fundId, filterQuery);
        List<Object[]> schduleMap = this.getAllGlCodesForSchedule(reportType);
        for (Object[] row : schduleMap) {
            String fundnm;
            row[0].toString();
            if (!statement.containsMajorCodeEntry(row[0].toString().substring(1, this.majorCodeLength))) {
                if (statement.getIeEntries().size() > 1) {
                    statement.addIE(new IEStatementEntry(null, "Schedule Total", currentYearScheduleTotal, previousYearScheduleTotal, true));
                    statement.addIE(new IEStatementEntry("Schedule " + row[1].toString() + ":", row[2].toString(), "", row[0].toString().substring(1, this.majorCodeLength), true));
                    currentYearScheduleTotal = new HashMap();
                    previousYearScheduleTotal = new HashMap();
                } else {
                    statement.addIE(new IEStatementEntry("Schedule " + row[1].toString() + ":", row[2].toString(), "", row[0].toString().substring(1, this.majorCodeLength), true));
                }
            }
            if (statement.containsIEStatementEntry(row[0].toString())) continue;
            IEStatementEntry ieEntry = new IEStatementEntry();
            if (this.ieContains(CurrentYearLedgerDetail, row[0].toString())) {
                for (Object[] cur : CurrentYearLedgerDetail) {
                    fundnm = this.incomeExpenditureService.getFundNameForId(statement.getFunds(), Integer.valueOf(cur[3].toString()));
                    if (!cur[0].toString().equals(row[0].toString())) continue;
                    addrow = true;
                    amount = I.equalsIgnoreCase(cur[4].toString()) ? ((BigDecimal)cur[2]).multiply(NEGATIVE) : (BigDecimal)cur[2];
                    if (currentYearScheduleTotal.containsKey(fundnm)) {
                        currentYearScheduleTotal.put(fundnm, ((BigDecimal)currentYearScheduleTotal.get(fundnm)).add(this.zeroOrValue(this.incomeExpenditureService.divideAndRound(amount, divisor))));
                    } else {
                        currentYearScheduleTotal.put(fundnm, this.incomeExpenditureService.divideAndRound(amount, divisor));
                    }
                    ieEntry.getNetAmount().put(fundnm, this.incomeExpenditureService.divideAndRound(amount, divisor));
                }
            }
            if (this.ieContains(previousLedgerBalance, row[0].toString())) {
                for (Object[] pre : previousLedgerBalance) {
                    if (!pre[0].toString().equals(row[0].toString())) continue;
                    fundnm = this.incomeExpenditureService.getFundNameForId(statement.getFunds(), Integer.valueOf(pre[3].toString()));
                    addrow = true;
                    preAmount = I.equalsIgnoreCase(pre[4].toString()) ? ((BigDecimal)pre[2]).multiply(NEGATIVE) : (BigDecimal)pre[2];
                    if (previousYearScheduleTotal.containsKey(fundnm)) {
                        previousYearScheduleTotal.put(fundnm, ((BigDecimal)previousYearScheduleTotal.get(fundnm)).add(this.zeroOrValue(this.incomeExpenditureService.divideAndRound(preAmount, divisor))));
                    } else {
                        previousYearScheduleTotal.put(fundnm, this.incomeExpenditureService.divideAndRound(preAmount, divisor));
                    }
                    ieEntry.getPreviousYearAmount().put(fundnm, this.incomeExpenditureService.divideAndRound(preAmount, divisor));
                }
            }
            if (addschedulerow && !statement.containsIEStatementEntry(row[0].toString())) {
                statement.addIE(scheduleEntry);
            }
            if (addrow) {
                ieEntry.setGlCode(row[0].toString());
                ieEntry.setAccountName(row[4].toString());
                ieEntry.setMajorCode(row[2] != null ? row[2].toString() : "");
                statement.addIE(ieEntry);
            }
            addrow = false;
            addschedulerow = false;
        }
        int lastIndex = statement.getIeEntries().size();
        if (statement.getIE(lastIndex - 1).getGlCode().contains("Schedule") && !statement.getIE(lastIndex - 1).getGlCode().contains("Schedule Total")) {
            statement.getIeEntries().remove(lastIndex - 1);
        }
    }

    @Override
    void computeAndAddTotalsForSchedules(Statement statement) {
        BigDecimal currentTotal = BigDecimal.ZERO;
        BigDecimal previousTotal = BigDecimal.ZERO;
        HashMap<Object, BigDecimal> fundNetTotals = new HashMap<Object, BigDecimal>();
        HashMap<Object, BigDecimal> fundPreTotals = new HashMap<Object, BigDecimal>();
        for (IEStatementEntry entry : statement.getIeEntries()) {
            if (entry.getAccountName().equals("Schedule Total")) {
                for (Map.Entry<Object, Object> entry2 : fundNetTotals.entrySet()) {
                    if (fundNetTotals.get(entry2.getKey()) != null) continue;
                    entry.getNetAmount().put((String)entry2.getKey(), (BigDecimal)fundNetTotals.get(entry2.getKey()));
                }
                for (Map.Entry<Object, Object> entry3 : fundPreTotals.entrySet()) {
                    if (fundNetTotals.get(entry3.getKey()) != null) continue;
                    entry.getPreviousYearAmount().put((String)entry3.getKey(), (BigDecimal)fundPreTotals.get(entry3.getKey()));
                }
                currentTotal = BigDecimal.ZERO;
                previousTotal = BigDecimal.ZERO;
                continue;
            }
            for (Map.Entry<Object, Object> entry4 : entry.getNetAmount().entrySet()) {
                if (fundNetTotals.get(entry4.getKey()) == null) {
                    fundNetTotals.put(entry4.getKey(), BigDecimal.ZERO);
                }
                currentTotal = this.zeroOrValue((BigDecimal)entry4.getValue());
                fundNetTotals.put(entry4.getKey(), currentTotal.add(this.zeroOrValue((BigDecimal)fundNetTotals.get(entry4.getKey()))));
            }
            for (Map.Entry<Object, Object> entry5 : entry.getPreviousYearAmount().entrySet()) {
                if (fundPreTotals.get(entry5.getKey()) == null) {
                    fundPreTotals.put(entry5.getKey(), BigDecimal.ZERO);
                }
                previousTotal = this.zeroOrValue((BigDecimal)entry5.getValue());
                fundPreTotals.put(entry5.getKey(), previousTotal.add(this.zeroOrValue((BigDecimal)fundPreTotals.get(entry5.getKey()))));
            }
        }
    }

    private void populateCurrentYearAmountForDetail(Statement statement, Date toDate, Date fromDate, String majorCode, Character type, String filterQuery) {
        boolean addrow = false;
        BigDecimal divisor = statement.getDivisor();
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal preAmount = BigDecimal.ZERO;
        String fundId = this.incomeExpenditureService.getfundList(statement.getFunds());
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Getting All ledger codes ..");
        }
        List AllLedger = this.persistenceService.getSession().createSQLQuery("select coa.glcode,coa.name from chartofaccounts coa where coa.majorcode='" + majorCode + "' and coa.classification=4 and coa.type='" + type + "'  order by coa.glcode").list();
        List previousLedgerBalance = this.populatePreviousYearTotals(statement, toDate, fromDate, majorCode, filterQuery, fundId).list();
        List<Object[]> allGlCodes = this.getAllGlCodesForSubSchedule(majorCode, type, IE);
        List<Object[]> CurrentYearLedgerDetail = this.getAllLedgerTransaction(majorCode, toDate, fromDate, fundId, filterQuery);
        this.addRowForIESchedule(statement, allGlCodes);
        for (Object[] row : AllLedger) {
            if (statement.containsIEStatementEntry(row[0].toString())) continue;
            IEStatementEntry ieEntry = new IEStatementEntry();
            if (this.ieContains(CurrentYearLedgerDetail, row[0].toString())) {
                for (Object[] cur : CurrentYearLedgerDetail) {
                    if (!cur[0].toString().equals(row[0].toString())) continue;
                    addrow = true;
                    amount = I.equalsIgnoreCase(type.toString()) ? ((BigDecimal)cur[2]).multiply(NEGATIVE) : (BigDecimal)cur[2];
                    ieEntry.getNetAmount().put(this.incomeExpenditureService.getFundNameForId(statement.getFunds(), Integer.valueOf(cur[3].toString())), this.incomeExpenditureService.divideAndRound(amount, divisor));
                }
            }
            if (this.ieContains(previousLedgerBalance, row[0].toString())) {
                for (Object[] pre : previousLedgerBalance) {
                    if (!pre[0].toString().equals(row[0].toString())) continue;
                    addrow = true;
                    preAmount = I.equalsIgnoreCase(type.toString()) ? ((BigDecimal)pre[2]).multiply(NEGATIVE) : (BigDecimal)pre[2];
                    ieEntry.getPreviousYearAmount().put(this.incomeExpenditureService.getFundNameForId(statement.getFunds(), Integer.valueOf(pre[3].toString())), this.incomeExpenditureService.divideAndRound(preAmount, divisor));
                }
            }
            if (addrow) {
                ieEntry.setGlCode(row[0].toString());
                ieEntry.setAccountName(row[1].toString());
                statement.addIE(ieEntry);
            }
            addrow = false;
        }
    }

    private void populateCurrentYearAmountForAllSchedules(Statement statement, List<Fund> fundList, List<Object[]> currentYearAmounts) {
        BigDecimal divisor = statement.getDivisor();
        Map<String, Schedules> scheduleToGlCodeMap = this.getScheduleToGlCodeMap(IE, "('I','E')");
        for (Map.Entry<String, Schedules> entry : scheduleToGlCodeMap.entrySet()) {
            String scheduleNumber = entry.getValue().scheduleNumber;
            String scheduleName = entry.getValue().scheduleName;
            String type = entry.getValue().chartOfAccount.size() > 0 ? entry.getValue().chartOfAccount.iterator().next().type : "";
            statement.add(new StatementEntry(scheduleNumber, scheduleName, "", null, null, true));
            for (Object[] row : currentYearAmounts) {
                String glCode = row[2].toString();
                if (!entry.getValue().contains(glCode)) continue;
                if (!statement.containsBalanceSheetEntry(glCode)) {
                    StatementEntry balanceSheetEntry = new StatementEntry();
                    if (row[0] != null && row[1] != null) {
                        BigDecimal total = (BigDecimal)row[0];
                        if (I.equalsIgnoreCase(type)) {
                            total = total.multiply(NEGATIVE);
                        }
                        balanceSheetEntry.getFundWiseAmount().put(this.incomeExpenditureService.getFundNameForId(fundList, new Integer(row[1].toString())), this.incomeExpenditureService.divideAndRound(total, divisor));
                    }
                    balanceSheetEntry.setGlCode(glCode);
                    balanceSheetEntry.setAccountName(entry.getValue().getCoaName(glCode));
                    statement.add(balanceSheetEntry);
                    continue;
                }
                for (int index = 0; index < statement.size(); ++index) {
                    BigDecimal amount = this.incomeExpenditureService.divideAndRound((BigDecimal)row[0], divisor);
                    if (I.equalsIgnoreCase(type)) {
                        amount = amount.multiply(NEGATIVE);
                    }
                    if (statement.get(index).getGlCode() == null || !row[2].toString().equals(statement.get(index).getGlCode())) continue;
                    String fundNameForId = this.incomeExpenditureService.getFundNameForId(fundList, new Integer(row[1].toString()));
                    if (statement.get(index).getFundWiseAmount().get(fundNameForId) == null) {
                        statement.get(index).getFundWiseAmount().put(this.incomeExpenditureService.getFundNameForId(fundList, new Integer(row[1].toString())), amount);
                        continue;
                    }
                    statement.get(index).getFundWiseAmount().put(this.incomeExpenditureService.getFundNameForId(fundList, new Integer(row[1].toString())), statement.get(index).getFundWiseAmount().get(this.incomeExpenditureService.getFundNameForId(fundList, new Integer(row[1].toString()))).add(amount));
                }
            }
            for (ChartOfAccount s : entry.getValue().chartOfAccount) {
                if (statement.containsBalanceSheetEntry(s.glCode)) continue;
                StatementEntry statementEntry = new StatementEntry();
                statementEntry.setGlCode(s.glCode);
                statementEntry.setAccountName(s.name);
                statement.add(statementEntry);
            }
        }
    }

    boolean ieContains(List<Object[]> previousBalance, String glCode) {
        for (Object[] row : previousBalance) {
            if (row[0] == null || !glCode.equals(row[0].toString())) continue;
            return true;
        }
        return false;
    }

    private void populatePreviousYearTotalsForAllSchedules(Statement statement, String filterQuery, Date toDate, Date fromDate) {
        Date formattedToDate = null;
        BigDecimal divisor = statement.getDivisor();
        formattedToDate = "Yearly".equalsIgnoreCase(statement.getPeriod()) ? fromDate : this.incomeExpenditureService.getPreviousYearFor(toDate);
        List<Object[]> resultMap = this.amountPerFundQueryForAllSchedules(filterQuery, formattedToDate, this.incomeExpenditureService.getPreviousYearFor(fromDate), IE);
        List<Object[]> allGlCodes = this.getAllGlCodesForAllSchedule(IE, "('I','E')");
        for (Object[] obj : allGlCodes) {
            for (Object[] row : resultMap) {
                String glCode = row[2].toString();
                if (!glCode.substring(1, 3).equals(obj[0].toString())) continue;
                String type = obj[3].toString();
                if (!statement.containsBalanceSheetEntry(row[2].toString())) {
                    this.addRowToStatement(statement, row, glCode);
                    continue;
                }
                for (int index = 0; index < statement.size(); ++index) {
                    BigDecimal amount = this.incomeExpenditureService.divideAndRound((BigDecimal)row[0], divisor);
                    if (I.equalsIgnoreCase(type)) {
                        amount = amount.multiply(NEGATIVE);
                    }
                    if (statement.get(index).getGlCode() == null || !row[2].toString().equals(statement.get(index).getGlCode())) continue;
                    statement.get(index).setPreviousYearTotal(amount);
                }
            }
        }
    }

    void computeAndAddScheduleTotals(Statement statement) {
        HashMap<String, BigDecimal> fundNetTotals = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> fundPreTotals = new HashMap<String, BigDecimal>();
        BigDecimal netAmount = BigDecimal.ZERO;
        BigDecimal preAmount = BigDecimal.ZERO;
        for (IEStatementEntry entry : statement.getIeEntries()) {
            for (Map.Entry<String, BigDecimal> row : entry.getNetAmount().entrySet()) {
                if (fundNetTotals.get(row.getKey()) == null) {
                    fundNetTotals.put(row.getKey(), BigDecimal.ZERO);
                }
                netAmount = this.zeroOrValue(row.getValue());
                fundNetTotals.put(row.getKey(), netAmount.add(this.zeroOrValue((BigDecimal)fundNetTotals.get(row.getKey()))));
            }
            for (Map.Entry<String, BigDecimal> prerow : entry.getPreviousYearAmount().entrySet()) {
                if (fundPreTotals.get(prerow.getKey()) == null) {
                    fundPreTotals.put(prerow.getKey(), BigDecimal.ZERO);
                }
                preAmount = this.zeroOrValue(prerow.getValue());
                fundPreTotals.put(prerow.getKey(), preAmount.add(this.zeroOrValue((BigDecimal)fundPreTotals.get(prerow.getKey()))));
            }
        }
        statement.addIE(new IEStatementEntry(null, "Total", fundNetTotals, fundPreTotals, true));
    }

    private BigDecimal zeroOrValue(BigDecimal value) {
        return value == null ? BigDecimal.ZERO : value;
    }

    public void setIncomeExpenditureService(IncomeExpenditureService incomeExpenditureService) {
        this.incomeExpenditureService = incomeExpenditureService;
    }
}

