/*
 * Decompiled with CFR 0.152.
 */
package org.egov.services.cheque;

import java.util.Arrays;
import java.util.List;
import org.egov.commons.Bankaccount;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.cheque.AccountCheques;

public class ChequeService
extends PersistenceService<AccountCheques, Long> {
    private static final String REQUIRED_NUMBER_OF_CHEQUES_ARE_NOT_AVAILABLE = "Required number of cheques are not available";
    private PersistenceService persistenceService;

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public ChequeService(Class<AccountCheques> accountCheques) {
        this.type = accountCheques;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String nextChequeNumber(String accId, int noChqs, int allotId) {
        String nextChequeNumber = "";
        int count = 1;
        int i = 0;
        Bankaccount bankaccount = this.getBankaccount(accId);
        Department department = this.getDepartment(allotId);
        String chqQuery = "select ac from AccountCheques ac, ChequeDeptMapping cd where ac.id=cd.accountCheque.id and ac.bankAccountId=? and cd.allotedTo=?  and (ac.isExhausted is null or ac.isExhausted=0)  order by ac.id";
        List chqList = this.findAllBy("select ac from AccountCheques ac, ChequeDeptMapping cd where ac.id=cd.accountCheque.id and ac.bankAccountId=? and cd.allotedTo=?  and (ac.isExhausted is null or ac.isExhausted=0)  order by ac.id", new Object[]{bankaccount, department});
        if (chqList == null || chqList.size() == 0) {
            throw new ValidationException(Arrays.asList(new ValidationError("No cheques available", "No cheques available")));
        }
        AccountCheques chq = (AccountCheques)((Object)chqList.get(i));
        while (count <= noChqs) {
            if (i < chqList.size()) {
                if (chq.getNextChqNo() == null) {
                    nextChequeNumber = nextChequeNumber + this.addComma(nextChequeNumber) + chq.getFromChequeNumber();
                    chq.setNextChqNo(this.increment(chq.getFromChequeNumber()));
                } else if (chq.getNextChqNo().equals(chq.getToChequeNumber())) {
                    nextChequeNumber = nextChequeNumber + this.addComma(nextChequeNumber) + chq.getToChequeNumber();
                    chq.setIsExhausted(true);
                    ++i;
                    if (count == noChqs) {
                        ++count;
                        continue;
                    }
                    if (i >= chqList.size()) throw new ApplicationRuntimeException(REQUIRED_NUMBER_OF_CHEQUES_ARE_NOT_AVAILABLE);
                    chq = (AccountCheques)((Object)chqList.get(i));
                } else {
                    nextChequeNumber = nextChequeNumber + this.addComma(nextChequeNumber) + chq.getNextChqNo();
                    chq.setNextChqNo(this.increment(chq.getNextChqNo()));
                }
                ++count;
                continue;
            }
            if (i >= noChqs) continue;
            throw new ApplicationRuntimeException(REQUIRED_NUMBER_OF_CHEQUES_ARE_NOT_AVAILABLE);
        }
        return nextChequeNumber;
    }

    private String addComma(String nextChequeNumber) {
        if (nextChequeNumber.equals("")) {
            return "";
        }
        return ",";
    }

    private String increment(String fromChequeNumber) {
        StringBuffer temp = new StringBuffer(fromChequeNumber);
        StringBuffer numBuff = new StringBuffer();
        Long num = Long.valueOf(fromChequeNumber);
        num = num + 1L;
        numBuff = new StringBuffer(num.toString());
        while (numBuff.length() < temp.length()) {
            numBuff.insert(0, "0");
        }
        return numBuff.toString();
    }

    private Bankaccount getBankaccount(String accId) {
        Bankaccount account = (Bankaccount)this.persistenceService.find("from Bankaccount where id=? ", new Object[]{Integer.valueOf(accId)});
        if (account == null) {
            throw new IllegalArgumentException("Bankaccount doesnot exist in the system for id:" + accId);
        }
        return account;
    }

    private Department getDepartment(int allotId) {
        Department dept = (Department)this.persistenceService.find("from Department where id=? ", new Object[]{allotId});
        if (dept == null) {
            throw new IllegalArgumentException("Department doesnot exist in the system for id:" + allotId);
        }
        return dept;
    }
}

