/*
 * Decompiled with CFR 0.152.
 */
package org.egov.model.recoveries;

import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import org.egov.commons.Bank;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.EgPartytype;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.validator.annotation.Unique;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="TDS")
@SequenceGenerator(name="SEQ_TDS", sequenceName="SEQ_TDS", allocationSize=1)
@Unique(id="id", tableName="TDS", fields={"type"}, columnName={"type"}, enableDfltMsg=true)
public class Recovery
extends AbstractAuditable {
    private static final long serialVersionUID = 6136656142691290863L;
    public static final String SEQ_RECOVERY = "SEQ_TDS";
    @Id
    @GeneratedValue(generator="SEQ_TDS", strategy=GenerationType.SEQUENCE)
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="glcodeid")
    private CChartOfAccounts chartofaccounts;
    @Length(max=20)
    private String type;
    private Boolean isactive;
    private BigDecimal rate;
    @Length(max=100)
    private String remitted;
    @Length(max=200)
    private String description;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="partytypeid")
    private EgPartytype egPartytype;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="bankid")
    private Bank bank;
    private BigDecimal caplimit;
    @Length(max=50)
    private String recoveryName;
    @Length(max=50)
    private String calculationType;
    @Length(max=16)
    private String ifscCode;
    @Length(max=32)
    private String accountNumber;
    @NotNull
    @Column(name="recovery_mode")
    private Character recoveryMode;
    @Column(name="remittance_mode")
    private Character remittanceMode;
    @Transient
    private Boolean bankLoan;

    public Recovery() {
    }

    public Recovery(Long id, BigDecimal createdby) {
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public CChartOfAccounts getChartofaccounts() {
        return this.chartofaccounts;
    }

    public void setChartofaccounts(CChartOfAccounts chartofaccounts) {
        this.chartofaccounts = chartofaccounts;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Boolean getIsactive() {
        return this.isactive;
    }

    public void setIsactive(Boolean isactive) {
        this.isactive = isactive;
    }

    public BigDecimal getRate() {
        return this.rate;
    }

    public void setRate(BigDecimal rate) {
        this.rate = rate;
    }

    public String getRemitted() {
        return this.remitted;
    }

    public void setRemitted(String remitted) {
        this.remitted = remitted;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public EgPartytype getEgPartytype() {
        return this.egPartytype;
    }

    public void setEgPartytype(EgPartytype egPartytype) {
        this.egPartytype = egPartytype;
    }

    public Bank getBank() {
        return this.bank;
    }

    public void setBank(Bank bank) {
        this.bank = bank;
    }

    public BigDecimal getCaplimit() {
        return this.caplimit;
    }

    public void setCaplimit(BigDecimal caplimit) {
        this.caplimit = caplimit;
    }

    public String getRecoveryName() {
        return this.recoveryName;
    }

    public void setRecoveryName(String recoveryName) {
        this.recoveryName = recoveryName;
    }

    public String getCalculationType() {
        return this.calculationType;
    }

    public void setCalculationType(String calculationType) {
        this.calculationType = calculationType;
    }

    public String getIfscCode() {
        return this.ifscCode;
    }

    public void setIfscCode(String ifscCode) {
        this.ifscCode = ifscCode;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public Character getRecoveryMode() {
        return this.recoveryMode;
    }

    public void setRecoveryMode(Character recoveryMode) {
        this.recoveryMode = recoveryMode;
    }

    public Character getRemittanceMode() {
        return this.remittanceMode;
    }

    public void setRemittanceMode(Character remittanceMode) {
        this.remittanceMode = remittanceMode;
    }

    public Boolean getBankLoan() {
        return this.bankLoan;
    }

    public void setBankLoan(Boolean bankLoan) {
        this.bankLoan = bankLoan;
    }
}

