/*
 * Decompiled with CFR 0.152.
 */
package org.egov.model.instrument;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.CVoucherHeader;
import org.egov.commons.EgwStatus;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.model.instrument.DishonorChequeDetails;
import org.egov.model.instrument.InstrumentHeader;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="EGF_DISHONORCHEQUE")
@SequenceGenerator(name="SEQ_EGF_DISHONORCHQ", sequenceName="SEQ_EGF_DISHONORCHQ", allocationSize=1)
public class DishonorCheque
extends StateAware {
    private static final long serialVersionUID = -6134188498111765210L;
    public static final String SEQ_EGF_DISHONORCHEQUE = "SEQ_EGF_DISHONORCHQ";
    @Id
    @GeneratedValue(generator="SEQ_EGF_DISHONORCHQ", strategy=GenerationType.SEQUENCE)
    private Long id;
    @ManyToOne
    @JoinColumn(name="instrumentheaderid")
    private InstrumentHeader instrumentHeader;
    @Transient
    private Integer payinSlipCreator;
    @Transient
    private User payinSlipCreatorUser;
    @ManyToOne
    @JoinColumn(name="originalvhid")
    private CVoucherHeader originalVoucherHeader;
    @ManyToOne
    @JoinColumn(name="statusid")
    private EgwStatus status;
    @Column(name="bankcharges")
    private BigDecimal bankChargesAmt;
    @ManyToOne
    @JoinColumn(name="bankchargeglcodeid")
    private CChartOfAccounts bankchargeGlCodeId;
    private Date transactionDate;
    @Length(max=20)
    private String bankReferenceNumber;
    private String instrumentDishonorReason;
    private String bankreason;
    @ManyToOne
    @JoinColumn(name="reversalvhid")
    private CVoucherHeader reversalVoucherHeader;
    @ManyToOne
    @JoinColumn(name="bankchargesvhid")
    private CVoucherHeader bankchargesVoucherHeader;
    @Transient
    private boolean firstStepWk;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="header", targetEntity=DishonorChequeDetails.class)
    private Set<DishonorChequeDetails> details = new HashSet<DishonorChequeDetails>(0);

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getStateDetails() {
        String instInfo = "Instrument Number :" + this.getInstrumentHeader().getInstrumentNumber() + " Amount : " + this.getInstrumentHeader().getInstrumentAmount();
        return instInfo;
    }

    public Date getTransactionDate() {
        return this.transactionDate;
    }

    public void setTransactionDate(Date transactionDate) {
        this.transactionDate = transactionDate;
    }

    public Integer getPayinSlipCreator() {
        return this.payinSlipCreator;
    }

    public User getPayinSlipCreatorUser() {
        return this.payinSlipCreatorUser;
    }

    public void setPayinSlipCreatorUser(User payinSlipCreatorUser) {
        this.payinSlipCreatorUser = payinSlipCreatorUser;
    }

    public void setPayinSlipCreator(Integer payinSlipCreator) {
        this.payinSlipCreator = payinSlipCreator;
    }

    public String getBankReferenceNumber() {
        return this.bankReferenceNumber;
    }

    public void setBankReferenceNumber(String bankReferenceNumber) {
        this.bankReferenceNumber = bankReferenceNumber;
    }

    public InstrumentHeader getInstrumentHeader() {
        return this.instrumentHeader;
    }

    public void setInstrumentHeader(InstrumentHeader instrumentHeader) {
        this.instrumentHeader = instrumentHeader;
    }

    public CVoucherHeader getOriginalVoucherHeader() {
        return this.originalVoucherHeader;
    }

    public void setOriginalVoucherHeader(CVoucherHeader originalVoucherHeader) {
        this.originalVoucherHeader = originalVoucherHeader;
    }

    public EgwStatus getStatus() {
        return this.status;
    }

    public void setStatus(EgwStatus status) {
        this.status = status;
    }

    public BigDecimal getBankChargesAmt() {
        return this.bankChargesAmt;
    }

    public void setBankChargesAmt(BigDecimal bankChargesAmt) {
        this.bankChargesAmt = bankChargesAmt;
    }

    public CChartOfAccounts getBankchargeGlCodeId() {
        return this.bankchargeGlCodeId;
    }

    public void setBankchargeGlCodeId(CChartOfAccounts bankchargeGlCodeId) {
        this.bankchargeGlCodeId = bankchargeGlCodeId;
    }

    public CVoucherHeader getReversalVoucherHeader() {
        return this.reversalVoucherHeader;
    }

    public void setReversalVoucherHeader(CVoucherHeader reversalVoucherHeader) {
        this.reversalVoucherHeader = reversalVoucherHeader;
    }

    public CVoucherHeader getBankchargesVoucherHeader() {
        return this.bankchargesVoucherHeader;
    }

    public void setBankchargesVoucherHeader(CVoucherHeader bankchargesVoucherHeader) {
        this.bankchargesVoucherHeader = bankchargesVoucherHeader;
    }

    public Set<DishonorChequeDetails> getDetails() {
        return this.details;
    }

    public void setDetails(Set<DishonorChequeDetails> details) {
        this.details = details;
    }

    public Set<DishonorChequeDetails> addDishonorChqDetails(DishonorChequeDetails chqDet) {
        this.details.add(chqDet);
        return this.details;
    }

    public boolean isFirstStepWk() {
        return this.firstStepWk;
    }

    public void setFirstStepWk(boolean firstStepWk) {
        this.firstStepWk = firstStepWk;
    }

    public String getInstrumentDishonorReason() {
        return this.instrumentDishonorReason;
    }

    public String getBankreason() {
        return this.bankreason;
    }

    public void setInstrumentDishonorReason(String instrumentDishonorReason) {
        this.instrumentDishonorReason = instrumentDishonorReason;
    }

    public void setBankreason(String bankreason) {
        this.bankreason = bankreason;
    }

    public String myLinkId() {
        return this.getId().toString();
    }
}

