/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.egov.commons.CFinancialYear;
import org.egov.commons.CFunction;
import org.egov.commons.Functionary;
import org.egov.commons.Fund;
import org.egov.egf.model.IEStatementEntry;
import org.egov.egf.model.StatementEntry;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Department;

public class Statement {
    String period;
    CFinancialYear financialYear;
    Date asOndate;
    Date fromDate;
    Date toDate;
    String currency;
    BigDecimal currencyInAmount;
    Department department;
    Functionary functionary;
    CFunction function;
    Boundary field;
    Fund fund;
    List<Fund> fundList = new ArrayList<Fund>();
    private List<IEStatementEntry> ieEntries = new ArrayList<IEStatementEntry>();
    private List<StatementEntry> entries = new ArrayList<StatementEntry>();

    public void setEntries(List<StatementEntry> entries) {
        this.entries = entries;
    }

    public List<IEStatementEntry> getIeEntries() {
        return this.ieEntries;
    }

    public void setIeEntries(List<IEStatementEntry> ieEntries) {
        this.ieEntries = ieEntries;
    }

    public void setPeriod(String period) {
        this.period = period;
    }

    public void setFinancialYear(CFinancialYear financialYear) {
        this.financialYear = financialYear;
    }

    public void setAsOndate(Date asOndate) {
        this.asOndate = asOndate;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
        if (this.currency.equalsIgnoreCase("rupees")) {
            this.currencyInAmount = new BigDecimal(1);
        }
        if (this.currency.equalsIgnoreCase("thousands")) {
            this.currencyInAmount = new BigDecimal(1000);
        }
        if (this.currency.equalsIgnoreCase("lakhs")) {
            this.currencyInAmount = new BigDecimal(100000);
        }
    }

    public void setDepartment(Department department) {
        this.department = department;
    }

    public void setFunctionary(Functionary functionary) {
        this.functionary = functionary;
    }

    public void setFunction(CFunction function) {
        this.function = function;
    }

    public void setField(Boundary field) {
        this.field = field;
    }

    public String getPeriod() {
        return this.period;
    }

    public CFinancialYear getFinancialYear() {
        return this.financialYear;
    }

    public Date getAsOndate() {
        return this.asOndate;
    }

    public String getCurrency() {
        return this.currency;
    }

    public Department getDepartment() {
        return this.department;
    }

    public Functionary getFunctionary() {
        return this.functionary;
    }

    public CFunction getFunction() {
        return this.function;
    }

    public Boundary getField() {
        return this.field;
    }

    public List<Fund> getFunds() {
        return this.fundList;
    }

    public Fund getFund() {
        return this.fund;
    }

    public void setFund(Fund fund) {
        this.fund = fund;
    }

    public void setFunds(List<Fund> list) {
        this.fundList = list;
    }

    public void add(StatementEntry entry) {
        this.entries.add(entry);
    }

    public void addIE(IEStatementEntry entry) {
        this.ieEntries.add(entry);
    }

    public List<StatementEntry> getEntries() {
        return this.entries;
    }

    public int size() {
        return this.entries.size();
    }

    public int sizeIE() {
        return this.ieEntries.size();
    }

    public StatementEntry get(int index) {
        return this.entries.get(index);
    }

    public void addAll(Statement balanceSheet) {
        this.entries.addAll(balanceSheet.getEntries());
    }

    public void addAllIE(Statement balanceSheet) {
        this.ieEntries.addAll(balanceSheet.getIeEntries());
    }

    public IEStatementEntry getIE(int index) {
        return this.ieEntries.get(index);
    }

    public BigDecimal getDivisor() {
        if ("Thousands".equalsIgnoreCase(this.currency)) {
            return new BigDecimal(1000);
        }
        if ("Lakhs".equalsIgnoreCase(this.currency)) {
            return new BigDecimal(100000);
        }
        return BigDecimal.ONE;
    }

    public boolean containsStatementEntryScheduleNo(String scheduleNo) {
        if (scheduleNo == null) {
            return false;
        }
        for (StatementEntry StatementEntryObj : this.getEntries()) {
            if (StatementEntryObj.getScheduleNo() == null || !scheduleNo.equals(StatementEntryObj.getScheduleNo())) continue;
            return true;
        }
        return false;
    }

    public boolean containsStatementEntryOfDetailedCode(String glcode) {
        if (glcode == null) {
            return false;
        }
        for (StatementEntry StatementEntryObj : this.getEntries()) {
            if (StatementEntryObj.getGlCode() == null || !glcode.equals(StatementEntryObj.getGlCode())) continue;
            return true;
        }
        return false;
    }

    public boolean containsBalanceSheetEntry(String glCode) {
        if (glCode == null) {
            return false;
        }
        for (StatementEntry balanceSheetEntry : this.getEntries()) {
            if (balanceSheetEntry.getGlCode() == null || !glCode.equals(balanceSheetEntry.getGlCode())) continue;
            return true;
        }
        return false;
    }

    public boolean containsIEStatementEntry(String glCode) {
        if (glCode == null) {
            return false;
        }
        for (IEStatementEntry balanceSheetEntry : this.getIeEntries()) {
            if (balanceSheetEntry.getGlCode() == null || !glCode.equals(balanceSheetEntry.getGlCode())) continue;
            return true;
        }
        return false;
    }

    public boolean containsMajorCodeEntry(String majorcode) {
        if (majorcode == null) {
            return false;
        }
        for (IEStatementEntry balanceSheetEntry : this.getIeEntries()) {
            if (balanceSheetEntry.getMajorCode() == null || !majorcode.equals(balanceSheetEntry.getMajorCode())) continue;
            return true;
        }
        return false;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public BigDecimal getCurrencyInAmount() {
        return this.currencyInAmount;
    }
}

