/*
 * Decompiled with CFR 0.152.
 */
package com.exilant.exility.dataservice;

import com.exilant.exility.common.DataCollection;
import com.exilant.exility.common.TaskFailedException;
import com.exilant.exility.dataservice.SQLParameter;

public class SQLTemplate {
    protected String id;
    protected String template;
    protected boolean addColumnHeading = false;
    public SQLParameter[] parameters;

    public String getSQL(DataCollection dc) throws TaskFailedException {
        StringBuffer sql = new StringBuffer(this.template);
        if (this.parameters == null) {
            return sql.toString();
        }
        int paramCount = 0;
        for (int k = 0; k < this.parameters.length; ++k) {
            SQLParameter parameterName = this.parameters[k];
            String val = dc.getValue(parameterName.dataSource);
            if (null == val || val.length() == 0) {
                val = parameterName.defaultValue;
            }
            if (val != null && val.length() > 0) {
                ++paramCount;
            }
            if (parameterName.isList) {
                String[] vals = dc.getValueList(parameterName.dataSource);
                if (null == vals || vals.length == 0) {
                    if (null == val || val.length() == 0) {
                        if (!parameterName.isRequired) continue;
                        dc.addMessage("exilNoValueForParameter", parameterName.dataSource, this.id);
                        throw new TaskFailedException();
                    }
                    vals = new String[]{val};
                }
                ++paramCount;
                val = "";
                String prefix = "";
                for (String val2 : vals) {
                    val = parameterName.listRequiresQuotes ? val + prefix + "'" + val2 + "'" : val + prefix + val2;
                    prefix = ",";
                }
            } else if ((null == val || val.length() == 0) && parameterName.isRequired) {
                dc.addMessage("exilNoValueForParameter", parameterName.dataSource);
                throw new TaskFailedException();
            }
            this.substitute(k + 1, sql, val, parameterName.isRequired, dc);
        }
        boolean removeText = false;
        if (paramCount == 0) {
            removeText = true;
            this.removeBraces(sql, dc, removeText);
        }
        return sql.toString();
    }

    private void substitute(int paramNumber, StringBuffer sbf, String value, boolean isRequired, DataCollection dc) throws TaskFailedException {
        int paramAt = sbf.indexOf("@" + paramNumber);
        int paramSize = String.valueOf(paramNumber).length();
        if (paramAt < 0) {
            dc.addMessage("exilParameterMismatch", this.id, Integer.valueOf(paramNumber).toString());
            throw new TaskFailedException();
        }
        if (isRequired) {
            sbf.replace(paramAt, paramAt + paramSize + 1, value);
            return;
        }
        int openBracketAt = sbf.lastIndexOf("{", paramAt);
        int closeBracketAt = sbf.indexOf("}", paramAt);
        if (openBracketAt < 0 || closeBracketAt < 0) {
            dc.addMessage("exilBracesNotFound", this.id, Integer.valueOf(paramNumber).toString());
            throw new TaskFailedException();
        }
        if (value == null || value.length() == 0) {
            sbf.replace(openBracketAt, closeBracketAt + 1, "");
            return;
        }
        sbf.deleteCharAt(openBracketAt);
        sbf.deleteCharAt(closeBracketAt - 1);
        sbf.replace(paramAt - 1, paramAt + paramSize, value);
    }

    private void removeBraces(StringBuffer sql, DataCollection dc, boolean removeText) throws TaskFailedException {
        int openBracketAt = sql.lastIndexOf("{");
        int closeBracketAt = sql.indexOf("}");
        if (openBracketAt < 0 && closeBracketAt < 0) {
            return;
        }
        if (openBracketAt < 0 || closeBracketAt < 0 || openBracketAt > closeBracketAt) {
            dc.addMessage("exilUnmatchedBraces", this.id);
            throw new TaskFailedException();
        }
        if (removeText) {
            int numberOfCharactersToRemove = closeBracketAt - openBracketAt + 1;
            sql.delete(openBracketAt, numberOfCharactersToRemove);
        } else {
            sql.deleteCharAt(closeBracketAt);
            sql.deleteCharAt(openBracketAt);
        }
    }
}

