/*
 * Decompiled with CFR 0.152.
 */
package com.exilant.exility.common;

import com.exilant.exility.common.ObjectGetSetter;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class XMLGenerator {
    private static XMLGenerator xmlGenerator = null;
    private static final Logger LOGGER = Logger.getLogger(XMLGenerator.class);

    private XMLGenerator() {
    }

    public static XMLGenerator getInstance() {
        if (xmlGenerator == null) {
            xmlGenerator = new XMLGenerator();
        }
        return xmlGenerator;
    }

    public String toXML(Object object, String tag, String tabs) {
        Class<?> objclass = object.getClass();
        Class[] clsarr = new Class[]{String.class, String.class};
        Object[] objarr = new Object[]{tag, tabs};
        try {
            Method method = objclass.getMethod("toXML", clsarr);
            method.setAccessible(true);
            return (String)method.invoke(object, objarr);
        }
        catch (Exception e) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("Failed to invoke method" + e.getMessage()));
            }
            StringBuffer sbf = new StringBuffer(tabs);
            if (tag == null || tag.length() == 0) {
                try {
                    tag = ObjectGetSetter.get(object, "type").toString();
                }
                catch (Exception e2) {
                    LOGGER.error((Object)("Error in toXML" + e2.getMessage()));
                }
            }
            if (tag == null || tag.length() == 0) {
                tag = object.getClass().getName();
                tag = tag.substring(tag.lastIndexOf(46) + 1);
                tag = tag.substring(0, 1).toLowerCase() + tag.substring(1);
            }
            sbf.append('<');
            sbf.append(tag);
            sbf.append(' ');
            if (objclass.isPrimitive() || objclass.getName().indexOf("java.lang.") == 0) {
                sbf.append("value=\"");
                sbf.append(object.toString());
                sbf.append("\"/>\n");
            } else if (objclass.isArray()) {
                sbf.append(this.arrayToXML(object, tag, tabs));
            } else if (objclass.equals(HashMap.class)) {
                sbf.append(this.hashMapToXML((HashMap)object, tag, tabs));
            } else if (objclass.equals(ArrayList.class)) {
                sbf.append(this.arrayListToXML((ArrayList)object, tag, tabs));
            } else {
                HashMap values = ObjectGetSetter.getAll(object, false);
                sbf.append(this.hashMapToXML(values, tag, tabs));
            }
            return sbf.toString();
        }
    }

    private String arrayToXML(Object object, String tag, String tabs) {
        String newtag;
        StringBuffer sbf = new StringBuffer();
        sbf.append("class=\"Array\" length=\"");
        int len = Array.getLength(object);
        sbf.append(len);
        sbf.append("\" ");
        if (len == 0) {
            sbf.append("/>\n");
            return sbf.toString();
        }
        Class<?> cls = object.getClass().getComponentType();
        if (cls.isArray()) {
            newtag = "Array_" + cls.getComponentType();
        } else {
            newtag = cls.getName();
            newtag = newtag.substring(newtag.lastIndexOf(".") + 1);
            newtag = newtag.substring(0, 1).toLowerCase() + newtag.substring(1);
        }
        sbf.append(" type=\"");
        sbf.append(newtag);
        sbf.append("\">\n");
        String newtabs = tabs + '\t';
        if (cls.isPrimitive() || cls.getName().indexOf("java.lang.") == 0) {
            for (int i = 0; i < len; ++i) {
                sbf.append(newtabs);
                sbf.append('<');
                sbf.append(newtag);
                sbf.append(" index=\"");
                sbf.append(i);
                sbf.append("\" value=\"");
                sbf.append(Array.get(object, i));
                sbf.append("\" />\n");
            }
        } else {
            XMLGenerator xg = XMLGenerator.getInstance();
            for (int i = 0; i < len; ++i) {
                sbf.append(xg.toXML(Array.get(object, i), newtag, newtabs));
            }
        }
        sbf.append(tabs);
        sbf.append('<');
        sbf.append(tag);
        sbf.append("/>\n");
        return sbf.toString();
    }

    private String hashMapToXML(HashMap object, String tag, String tabs) {
        String key;
        Object obj;
        StringBuffer sbf = new StringBuffer();
        boolean childfound = false;
        for (Map.Entry entry : object.entrySet()) {
            obj = entry.getKey();
            if (!obj.getClass().equals(String.class)) continue;
            key = (String)obj;
            obj = entry.getValue();
            if (obj == null) continue;
            Class<?> cls = obj.getClass();
            if (cls.isPrimitive() || cls.getName().indexOf("java.lang.") == 0) {
                sbf.append(key);
                sbf.append("=\"");
                sbf.append(entry.getValue().toString());
                sbf.append("\" ");
                continue;
            }
            childfound = true;
        }
        if (childfound) {
            sbf.append(">\n");
            String newtabs = tabs + '\t';
            XMLGenerator xg = XMLGenerator.getInstance();
            for (Map.Entry newEntry : object.entrySet()) {
                obj = newEntry.getKey();
                if (!obj.getClass().equals(String.class)) continue;
                key = (String)obj;
                obj = newEntry.getValue();
                if (obj == null || obj.getClass().isPrimitive() || obj.getClass().getName().indexOf("java.lang.") == 0) continue;
                sbf.append(xg.toXML(newEntry.getValue(), key, newtabs));
            }
            sbf.append(tabs);
            sbf.append('<');
            sbf.append(tag);
            sbf.append("/>\n");
        } else {
            sbf.append("/>\n");
        }
        return sbf.toString();
    }

    private String arrayListToXML(ArrayList object, String tag, String tabs) {
        int size = object.size();
        StringBuffer sbf = new StringBuffer();
        sbf.append(" class=\"ArrayList\" size=\"");
        sbf.append(size);
        sbf.append("\" ");
        if (size == 0) {
            sbf.append("/>\n");
        } else {
            sbf.append(">\n");
            XMLGenerator xg = XMLGenerator.getInstance();
            String newtabs = tabs + '\t';
            for (int i = 0; i < size; ++i) {
                sbf.append(xg.toXML(object.get(i), null, newtabs));
            }
            sbf.append(tabs);
            sbf.append('<');
            sbf.append(tag);
            sbf.append("/>\n");
        }
        return sbf.toString();
    }
}

