/*
 * Decompiled with CFR 0.152.
 */
package com.exilant.eGov.src.transactions;

import com.exilant.exility.common.AbstractTask;
import com.exilant.exility.common.DataCollection;
import com.exilant.exility.common.TaskFailedException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class IESchedules
extends AbstractTask {
    private static final Logger LOGGER = Logger.getLogger(IESchedules.class);
    Connection conn;
    NumberFormat formatter;

    @Override
    public void execute(String taskName, String gridName, DataCollection dc, Connection conn, boolean erroOrNoData, boolean gridHasColumnHeading, String prefix) throws TaskFailedException {
        this.conn = conn;
        this.formatter = new DecimalFormat();
        this.formatter = new DecimalFormat("###############.00");
        this.printSchedules(dc);
    }

    private void printSchedules(DataCollection dc) throws TaskFailedException {
        String tableTime = dc.getValue("tableToDrop");
        String mainTable = "coaie" + tableTime;
        String report = "SELECT scheduleglCode AS \"glcode\", case when operation = 'L' then 'Less: ' else ' ' end  || schedulename AS \"name\", 'Schedule ' || schschedule || ': ' || summaryname || '[Code No ' || summaryglcode || ']' AS \"schTitle\", case when schschedule = NULL then '-' else schschedule AS \"schedule\", curYearAmount AS \"curyearamount\", preyearamount AS \"preyearamount\", operation AS \"operation\", TYPE AS \"type\" FROM " + mainTable + " WHERE TYPE = 'I' OR TYPE = 'E' ORDER BY scheduleglCode, TYPE, operation";
        PreparedStatement pst = null;
        ResultSet rs = null;
        ArrayList<String[]> ar = new ArrayList<String[]>();
        double curAmt = 0.0;
        double preAmt = 0.0;
        double sumCur = 0.0;
        double sumPre = 0.0;
        String operation = "";
        String schedule = "";
        String preSchedule = "";
        String title = "";
        String[] schTitle = new String[20];
        int grids = 0;
        int rowCount = 0;
        int cnt = 0;
        int[] rows = new int[20];
        String sDate = dc.getValue("sDate") == null ? "start of FY" : dc.getValue("sDate");
        String eDate = dc.getValue("eDate") == null ? "today" : dc.getValue("eDate");
        dc.addValue("pageTitle", "Income & Expenditure Schedules For the period of " + sDate + " to " + eDate);
        try {
            pst = this.conn.prepareStatement(report);
            rs = pst.executeQuery();
            while (rs.next()) {
                String[] total;
                curAmt = rs.getDouble("curyearamount");
                preAmt = rs.getDouble("preyearamount");
                schedule = rs.getString("schedule");
                operation = rs.getString("operation");
                if (!preSchedule.equalsIgnoreCase(schedule)) {
                    ++grids;
                }
                if (preSchedule.equalsIgnoreCase("")) {
                    preSchedule = schedule;
                }
                if (!preSchedule.equalsIgnoreCase(schedule)) {
                    schTitle[cnt] = title;
                    if (sumCur != 0.0 || sumPre != 0.0) {
                        dc.addValue("showRowIESchedule" + (cnt + 1), "true");
                    } else {
                        dc.addValue("showRowIESchedule" + (cnt + 1), "false");
                        int n = cnt;
                        schTitle[n] = schTitle[n] + " -No Data";
                    }
                    total = new String[]{"-", "Total", this.formatter.format(sumCur), this.formatter.format(sumPre)};
                    ar.add(total);
                    rows[cnt++] = ++rowCount;
                    rowCount = 0;
                    sumPre = 0.0;
                    sumCur = 0.0;
                }
                ++rowCount;
                title = rs.getString("schTitle");
                if (operation.equalsIgnoreCase("L") && preSchedule.equalsIgnoreCase(schedule)) {
                    total = new String[]{"-", "Sub Total", this.formatter.format(sumCur), this.formatter.format(sumPre)};
                    ar.add(total);
                    ++rowCount;
                }
                if (operation.equalsIgnoreCase("L")) {
                    sumCur -= curAmt;
                    sumPre -= preAmt;
                } else {
                    sumCur += curAmt;
                    sumPre += preAmt;
                }
                String[] row = new String[]{rs.getString("glcode"), rs.getString("name"), this.formatter.format(curAmt), this.formatter.format(preAmt)};
                ar.add(row);
                preSchedule = schedule;
            }
        }
        catch (SQLException ex) {
            LOGGER.error((Object)ex.getMessage(), (Throwable)ex);
            throw new TaskFailedException();
        }
        String[][][] grid = new String[grids][][];
        int nextRow = 0;
        for (int gridNo = 0; gridNo < grids - 1; ++gridNo) {
            String[][] gridData = new String[rows[gridNo] + 1][4];
            gridData[0][0] = "glCode";
            gridData[0][1] = "name";
            gridData[0][2] = "amountCurYear";
            gridData[0][3] = "amountPreYear";
            for (int rowNo = 0; rowNo < rows[gridNo]; ++rowNo) {
                gridData[rowNo + 1] = (String[])ar.get(nextRow++);
            }
            grid[gridNo] = gridData;
        }
        for (int i = 0; i < grids - 1; ++i) {
            if (grid[i] != null) {
                dc.addValue("schTitle" + (i + 1), schTitle[i]);
                dc.addGrid("gridIESchedule" + (i + 1), grid[i]);
                continue;
            }
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug((Object)("grid is null: " + i));
        }
    }
}

