/*
 * Decompiled with CFR 0.152.
 */
package com.exilant.eGov.src.reports;

import com.exilant.eGov.src.reports.CommnFunctions;
import com.exilant.eGov.src.reports.DishonoredChequeBean;
import com.exilant.exility.common.TaskFailedException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.egov.infstr.services.PersistenceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class DishonoredChequeReport {
    List<Object[]> rs;
    TaskFailedException taskExc;
    String chqFromDate = "";
    String chqToDate = "";
    String chequeNo = "";
    String intrumentMode = "";
    Long fundId;
    public String[] originalVcId;
    public String[] bankRefNo;
    public String[] bankCharge;
    ArrayList arList = new ArrayList();
    Date dt = new Date();
    SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
    SimpleDateFormat formatter = new SimpleDateFormat("dd-MMM-yyyy");
    private final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd kk:mm:ss.SSS", Locale.getDefault());
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    CommnFunctions commnFunctions;
    private static final Logger LOGGER = Logger.getLogger(DishonoredChequeReport.class);

    public ArrayList getDishonoredChequeDetails(DishonoredChequeBean disChqBean) throws TaskFailedException, Exception {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)" INSIDE getDishonoredChequeDetails()>>>>>>>> ");
        }
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Chq From date---->" + disChqBean.getStartDate()));
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Chq To date------>" + disChqBean.getEndDate()));
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Fund id--->" + disChqBean.getFundLst()));
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Mode --->" + disChqBean.getMode()));
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Cheque Number --->" + disChqBean.getChequeNo()));
            }
            if (!"".equals(disChqBean.getStartDate())) {
                this.dt = this.sdf.parse(disChqBean.getStartDate());
                this.chqFromDate = this.formatter.format(this.dt);
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info((Object)("After convert Chq From date is--->" + this.chqFromDate));
                }
            }
            if (!"".equals(disChqBean.getEndDate())) {
                this.dt = this.sdf.parse(disChqBean.getEndDate());
                this.chqToDate = this.formatter.format(this.dt);
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info((Object)("After convert Chq To date is--->" + this.chqToDate));
                }
            }
            if (!"".equals(disChqBean.getFundLst())) {
                this.fundId = Long.parseLong(disChqBean.getFundLst());
            }
            if (!"".equals(disChqBean.getChequeNo())) {
                this.chequeNo = disChqBean.getChequeNo();
            }
            if (!"".equals(disChqBean.getMode())) {
                this.intrumentMode = disChqBean.getMode().equals("1") ? "dd" : "cheque";
            }
            this.getBankEntryDetails();
            StringBuffer basicquery1 = new StringBuffer("SELECT distinct vh.id as \"voucherHeaderId\",vh.id as \"payinVHeaderId\",vh.cgn as \"cgnumber\",vh.VOUCHERNUMBER as \"voucherNumber\",vh.TYPE as \"type\",vh.FUNDID as \"fundId\",vh.FUNDSOURCEID as \"fundSourceId\",ih.INSTRUMENTNUMBER as \"chequeNumber\", ih.INSTRUMENTDATE as \"chequeDate\",ih.INSTRUMENTAMOUNT as \"amount\",bank.NAME as \"bank\",bacc.ACCOUNTNUMBER as \"accNumber\",bacc.ID as \"accIdParam\",ih.PAYTO as \"payTo\" ,ih.ISPAYCHEQUE AS \"payCheque\", vmis.DEPARTMENTID AS \"departmentId\",vmis.FUNCTIONARYID AS \"functionaryId\",iod.INSTRUMENTSTATUSDATE as \"recChequeDate\" ,iod.dishonorbankrefno  as \"dishonorBankRefNo\",status.description  as \"status\" FROM VOUCHERHEADER vh,egf_instrumentheader ih,BANK bank,BANKACCOUNT bacc,VOUCHERMIS vmis,bankbranch branch,egf_instrumenttype it,EGF_INSTRUMENTVOUCHER iv, egf_instrumentotherdetails iod, egw_status status ");
            StringBuffer wherequery1 = new StringBuffer(" WHERE vh.status=0 AND vh.id=vmis.voucherheaderid  and ih.INSTRUMENTTYPE=it.id and it.TYPE='" + this.intrumentMode + "' and iv.VOUCHERHEADERID=vh.ID and iv.INSTRUMENTHEADERID=ih.id " + " and iod.instrumentheaderid=ih.id " + " and ih.id_status=status.id and  status.moduletype='Instrument' and  status.description  in ('Dishonored','dishonour cheque in workflow') " + " and ih.BANKACCOUNTID=bacc.id and bacc.BRANCHID=branch.id and branch.BANKID=bank.id");
            StringBuffer orderbyquery = new StringBuffer(" ORDER BY \"voucherNumber\",\"type\",\"chequeDate\" ");
            if (this.fundId != null && this.fundId != 0L) {
                wherequery1 = wherequery1.append(" AND vh.FUNDID=").append(this.fundId);
            }
            if (!"".equals(this.chqFromDate)) {
                wherequery1 = wherequery1.append(" AND ih.INSTRUMENTDATE  >='").append(this.chqFromDate).append("'");
            }
            if (!"".equals(this.chqToDate)) {
                wherequery1 = wherequery1.append(" AND ih.INSTRUMENTDATE  <='").append(this.chqToDate).append("'");
            }
            if (!"".equals(this.chequeNo)) {
                wherequery1 = wherequery1.append(" AND ih.INSTRUMENTNUMBER=trim('").append(this.chequeNo).append("')");
            }
            String query = new StringBuffer().append(basicquery1).append(wherequery1).append(orderbyquery).toString();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("  getDishonoredChequeDetails Query is  " + query));
            }
            this.rs = this.persistenceService.getSession().createSQLQuery(query).list();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"After Execute Query----getDishonoredChequeDetails");
            }
            int i = 1;
            for (Object[] element : this.rs) {
                boolean bkChgAvailable = false;
                String voucherHeaderId = "";
                String payinSlipVHeaderId = "";
                String cgnum = "";
                String voucherNumber = "";
                String voucherType = "";
                String fundId = "";
                String chequeNumber = "";
                String chequeDate = "";
                String amount = "";
                String bankName = "";
                String accIdParam = "";
                String recChequeDate = "";
                String payeeName = "";
                String bankReferenceNo = "";
                String status = "";
                HashMap<String, String> data = new HashMap<String, String>();
                voucherHeaderId = element[0].toString() != null ? element[0].toString() : "&nbsp;";
                for (int k = 0; k < this.originalVcId.length; ++k) {
                    if (!this.originalVcId[k].equals(voucherHeaderId)) continue;
                    bkChgAvailable = true;
                    data.put("bankChargeAmt", this.bankCharge[k]);
                }
                if (!bkChgAvailable) {
                    data.put("bankChargeAmt", "&nbsp;");
                }
                payinSlipVHeaderId = element[1].toString() != null ? element[1].toString() : "&nbsp;";
                bankReferenceNo = element[18].toString() != null ? element[18].toString() : "&nbsp;";
                cgnum = element[2].toString() != null ? element[2].toString() : "&nbsp;";
                voucherNumber = element[3].toString() != null ? element[3].toString() : "&nbsp;";
                voucherType = element[4].toString() != null ? element[4].toString() : "&nbsp;";
                fundId = element[5].toString() != null ? element[5].toString() : "&nbsp;";
                chequeNumber = element[7].toString() != null ? element[7].toString() : "&nbsp;";
                if (element[8].toString() != null) {
                    this.dt = this.format.parse(element[8].toString());
                    chequeDate = this.formatter.format(this.dt);
                } else {
                    chequeDate = "&nbsp;";
                }
                amount = element[9].toString() != null ? element[9].toString() : "&nbsp;";
                bankName = element[10].toString() != null ? element[10].toString() : "&nbsp;";
                accIdParam = element[12].toString() != null ? element[12].toString() : "&nbsp;";
                if (element[17].toString() != null) {
                    this.dt = this.format.parse(element[17].toString());
                    recChequeDate = this.formatter.format(this.dt);
                } else {
                    recChequeDate = "&nbsp;";
                }
                payeeName = element[13].toString() != null ? element[13].toString() : "&nbsp;";
                status = element[19].toString() != null ? element[19].toString() : "&nbsp;";
                data.put("voucherHeaderId", voucherHeaderId);
                data.put("payinSlipVHeaderId", payinSlipVHeaderId);
                data.put("cgnum", cgnum);
                data.put("insMode", this.intrumentMode);
                data.put("voucherNumber", voucherNumber);
                data.put("bankRefNumber", bankReferenceNo);
                data.put("voucherType", voucherType);
                data.put("fundId", fundId);
                data.put("chequeNumber", chequeNumber);
                data.put("chequeDate", chequeDate);
                data.put("amount", amount);
                data.put("bankName", bankName);
                data.put("accIdParam", accIdParam);
                data.put("recChequeDate", recChequeDate);
                data.put("payeeName", payeeName);
                data.put("status", status);
                data.put("serialNo", i + "");
                ++i;
                this.arList.add(data);
            }
        }
        catch (SQLException sqlE) {
            LOGGER.error((Object)("Exception in main " + sqlE));
            throw this.taskExc;
        }
        return this.arList;
    }

    private void getBankEntryDetails() throws Exception {
        try {
            StringBuffer basicquery1 = new StringBuffer("SELECT rvh.id AS \"voucherHeaderId\",rvh.cgn AS \"cgnumber\",rvh.VOUCHERNUMBER AS \"voucherNumber\", rvh.TYPE AS \"vouType\",rvh.FUNDID AS \"fundId\",rvh.ORIGINALVCID AS \"oldVhId\", be.REFNO AS \"bankRefNumber\",be.TXNDATE AS \"bankRefDate\",be.TXNAMOUNT AS \"bankChargeAmt\"  FROM VOUCHERHEADER rvh,bankentries be");
            StringBuffer wherequery1 = new StringBuffer(" WHERE rvh.NAME='Bank Entry' AND rvh.ID=be.VOUCHERHEADERID  AND rvh.ORIGINALVCID!=0  AND rvh.TYPE='Payment' ");
            StringBuffer orderbyquery = new StringBuffer(" ORDER BY \"oldVhId\" ");
            if (this.fundId != null && this.fundId != 0L) {
                wherequery1 = wherequery1.append(" AND rvh.FUNDID=").append(this.fundId);
            }
            if (!this.chqFromDate.equals("") && !this.chqToDate.equals("")) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info((Object)" INSIDE FROM AND TO DATE ");
                }
                wherequery1 = wherequery1.append(" AND be.txndate BETWEEN ").append("to_date('" + this.chqFromDate + "')").append(" and ").append("to_date('" + this.chqToDate + "')");
            } else {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info((Object)" INSIDE FROM OR TO DATE ");
                }
                if (!this.chqFromDate.equals("")) {
                    wherequery1 = wherequery1.append(" AND be.txndate >='").append(this.chqFromDate).append("'");
                }
                if (!this.chqToDate.equals("")) {
                    wherequery1 = wherequery1.append(" AND be.txndate <='").append(this.chqToDate).append("'");
                }
            }
            String query = new StringBuffer().append(basicquery1).append(wherequery1).append(orderbyquery).toString();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("  getBankEntryDetails Query is  " + query));
            }
            this.rs = this.persistenceService.getSession().createSQLQuery(query).list();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)"After Execute Query----getBankEntryDetails");
            }
            int resSize = 0;
            int i = 0;
            resSize = this.rs.size();
            this.originalVcId = new String[resSize];
            this.bankRefNo = new String[resSize];
            this.bankCharge = new String[resSize];
            for (Object[] element : this.rs) {
                this.originalVcId[i] = element[5].toString();
                this.bankRefNo[i] = element[6].toString();
                this.bankCharge[i] = this.commnFunctions.numberToString(element[8].toString()).toString();
                ++i;
            }
        }
        catch (Exception sqlE) {
            LOGGER.error((Object)("Exception in main " + sqlE));
            throw this.taskExc;
        }
    }
}

