/*
 * Decompiled with CFR 0.152.
 */
package org.egov.utils;

import com.opensymphony.xwork2.util.ValueStack;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.egov.commons.CFinancialYear;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.dao.budget.BudgetDetailsDAO;
import org.egov.egf.model.BudgetAmountView;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.model.budget.BudgetDetail;
import org.egov.utils.Constants;
import org.springframework.beans.factory.annotation.Autowired;

public class BudgetDetailHelper {
    @Autowired
    private BudgetDetailsDAO budgetDetailsDAO;
    @Autowired
    private FinancialYearDAO financialYearDAO;

    public void setBudgetDetailsDAO(BudgetDetailsDAO budgetDetailsDAO) {
        this.budgetDetailsDAO = budgetDetailsDAO;
    }

    public void setFinancialYearDAO(FinancialYearDAO financialYearDAO) {
        this.financialYearDAO = financialYearDAO;
    }

    public Date getBudgetAsOnDate(BudgetDetail detail) {
        if (detail.getBudget() != null && detail.getBudget().getAsOnDate() != null) {
            return detail.getBudget().getAsOnDate();
        }
        return new Date();
    }

    public void removeEmptyBudgetDetails(List<BudgetDetail> budgetDetailList) {
        Iterator<BudgetDetail> detail = budgetDetailList.iterator();
        while (detail.hasNext()) {
            if (detail.next() != null) continue;
            detail.remove();
        }
    }

    public String getActualsFor(Map<String, Object> paramMap, Date asOn) {
        paramMap.put("asondate", asOn);
        try {
            return this.budgetDetailsDAO.getActualBudgetUtilized(paramMap).setScale(0, 2).toString();
        }
        catch (ValidationException e) {
            return "0.0";
        }
        catch (ArithmeticException e) {
            return "0.0";
        }
    }

    public BigDecimal getTotalActualsFor(Map<String, Object> paramMap, Date asOn) {
        BigDecimal actuals = BigDecimal.ZERO;
        paramMap.put("asondate", asOn);
        try {
            actuals = this.budgetDetailsDAO.getActualBudgetUtilized(paramMap);
            actuals = actuals == null ? BigDecimal.ZERO : actuals;
            actuals = actuals.add(this.budgetDetailsDAO.getBillAmountForBudgetCheck(paramMap));
        }
        catch (ValidationException e) {
            return BigDecimal.ZERO;
        }
        return actuals;
    }

    public void populateData(BudgetAmountView amountDisplay, Map<String, Object> paramMap, Date asOnDate, boolean isRe) {
        Date previousYear = this.subtractYear(asOnDate);
        String actualsFor = this.getActualsFor(paramMap, previousYear);
        amountDisplay.setPreviousYearActuals(actualsFor == null ? BigDecimal.ZERO.setScale(0, 2) : new BigDecimal(actualsFor).setScale(0, 2));
        amountDisplay.setOldActuals(this.getActualsFor(paramMap, this.subtractYear(previousYear)));
        String currentYearActuals = this.getActualsFor(paramMap, asOnDate);
        amountDisplay.setCurrentYearBeActuals(currentYearActuals == null ? BigDecimal.ZERO.setScale(2) : new BigDecimal(currentYearActuals).setScale(0, 2));
    }

    public String getPreviousActualData(Map<String, Object> paramMap, Date asOnDate) {
        return this.getActualsFor(paramMap, this.subtractYear(asOnDate));
    }

    public BigDecimal getTotalPreviousActualData(Map<String, Object> paramMap, Date asOnDate) {
        return this.getTotalActualsFor(paramMap, this.subtractYear(asOnDate));
    }

    protected Date subtractYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(1, -1);
        return cal.getTime();
    }

    public Long getFinancialYear() {
        return Long.valueOf(this.financialYearDAO.getCurrYearFiscalId());
    }

    public Map<String, Object> constructParamMap(ValueStack valueStack, BudgetDetail detail) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        valueStack.setValue("budgetDetail", (Object)detail);
        paramMap.put("deptid", Constants.INT_ZERO.equals(valueStack.findValue("budgetDetail.executingDepartment.id")) ? null : valueStack.findValue("budgetDetail.executingDepartment.id"));
        paramMap.put("functionid", Constants.LONG_ZERO.equals(valueStack.findValue("budgetDetail.function.id")) ? null : valueStack.findValue("budgetDetail.function.id"));
        paramMap.put("functionaryid", Constants.INT_ZERO.equals(valueStack.findValue("budgetDetail.functionary.id")) ? null : valueStack.findValue("budgetDetail.functionary.id"));
        paramMap.put("schemeid", Constants.INT_ZERO.equals(valueStack.findValue("budgetDetail.scheme.id")) ? null : valueStack.findValue("budgetDetail.scheme.id"));
        paramMap.put("subschemeid", Constants.INT_ZERO.equals(valueStack.findValue("budgetDetail.subScheme.id")) ? null : valueStack.findValue("budgetDetail.subScheme.id"));
        paramMap.put("budgetheadid", Constants.LONG_ZERO.equals(valueStack.findValue("budgetDetail.budgetGroup.id")) ? null : valueStack.findValue("budgetDetail.budgetGroup.id"));
        paramMap.put("glcodeid", Constants.LONG_ZERO.equals(valueStack.findValue("budgetDetail.budgetGroup.minCode.id")) ? null : valueStack.findValue("budgetDetail.budgetGroup.minCode.id"));
        paramMap.put("boundaryid", Constants.INT_ZERO.equals(valueStack.findValue("budgetDetail.boundary.id")) ? null : valueStack.findValue("budgetDetail.boundary.id"));
        paramMap.put("fundid", Constants.INT_ZERO.equals(valueStack.findValue("budgetDetail.fund.id")) ? null : valueStack.findValue("budgetDetail.fund.id"));
        return paramMap;
    }

    public BigDecimal getBillAmountForBudgetCheck(Map<String, Object> constructParamMap) {
        return this.budgetDetailsDAO.getBillAmountForBudgetCheck(constructParamMap);
    }

    public String computePreviousYearRange(String currentYearRange) {
        if (StringUtils.isNotBlank((String)currentYearRange)) {
            String[] list = currentYearRange.split("-");
            return this.subtract(list[0]) + "-" + this.subtract(list[1]);
        }
        return "";
    }

    public String computeNextYearRange(String currentYearRange) {
        if (StringUtils.isNotBlank((String)currentYearRange)) {
            String[] list = currentYearRange.split("-");
            return this.add(list[0]) + "-" + this.add(list[1]);
        }
        return "";
    }

    protected String subtract(String value) {
        int val = Integer.parseInt(value) - 1;
        if (val < 10) {
            return "0" + val;
        }
        return String.valueOf(val);
    }

    protected String add(String value) {
        int val = Integer.parseInt(value) + 1;
        if (val < 10) {
            return "0" + val;
        }
        return String.valueOf(val);
    }

    public CFinancialYear getPreviousYearFor(CFinancialYear financialYear) {
        try {
            return this.financialYearDAO.getFinancialYearByDate(this.subtractYear(financialYear.getStartingDate()));
        }
        catch (ApplicationRuntimeException e) {
            return null;
        }
    }

    public String accountTypeForFunctionDeptMap(String budgetName) {
        String accountType = budgetName.toLowerCase().contains("cap") ? "CAPITAL_EXPENDITURE" : "REVENUE_EXPENDITURE";
        return accountType;
    }
}

