/*
 * Decompiled with CFR 0.152.
 */
package org.egov.services.voucher;

import com.exilant.GLEngine.Transaxtion;
import com.exilant.GLEngine.TransaxtionParameter;
import com.exilant.eGov.src.common.EGovernCommon;
import com.exilant.eGov.src.transactions.VoucherTypeForULB;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.CFinancialYear;
import org.egov.commons.CFiscalPeriod;
import org.egov.commons.CGeneralLedger;
import org.egov.commons.CGeneralLedgerDetail;
import org.egov.commons.CVoucherHeader;
import org.egov.commons.EgfRecordStatus;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.AccountdetailtypeHibernateDAO;
import org.egov.commons.dao.ChartOfAccountsDAO;
import org.egov.commons.dao.FinancialYearHibernateDAO;
import org.egov.commons.dao.FunctionDAO;
import org.egov.commons.dao.VoucherHeaderDAO;
import org.egov.commons.utils.EntityType;
import org.egov.dao.budget.BudgetDetailsDAO;
import org.egov.dao.budget.BudgetDetailsHibernateDAO;
import org.egov.dao.voucher.VoucherHibernateDAO;
import org.egov.egf.autonumber.JVBillNumberGenerator;
import org.egov.egf.commons.EgovCommon;
import org.egov.eis.entity.Assignment;
import org.egov.eis.entity.Employee;
import org.egov.eis.entity.EmployeeView;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.DesignationService;
import org.egov.eis.service.EisCommonService;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.utils.ApplicationSequenceNumberGenerator;
import org.egov.infra.script.entity.Script;
import org.egov.infra.script.service.ScriptService;
import org.egov.infra.utils.autonumber.AutonumberServiceBeanResolver;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infstr.services.EISServeable;
import org.egov.infstr.services.PersistenceService;
import org.egov.infstr.utils.EGovConfig;
import org.egov.model.bills.EgBillPayeedetails;
import org.egov.model.bills.EgBillSubType;
import org.egov.model.bills.EgBilldetails;
import org.egov.model.bills.EgBillregister;
import org.egov.model.bills.EgBillregistermis;
import org.egov.model.payment.Paymentheader;
import org.egov.model.voucher.VoucherDetails;
import org.egov.model.voucher.VoucherTypeBean;
import org.egov.pims.commons.Designation;
import org.egov.pims.commons.Position;
import org.egov.pims.model.PersonalInformation;
import org.egov.pims.service.EmployeeServiceOld;
import org.egov.services.bills.EgBillRegisterService;
import org.egov.utils.Constants;
import org.egov.utils.FinancialConstants;
import org.egov.utils.VoucherHelper;
import org.hibernate.HibernateException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class VoucherService
extends PersistenceService<CVoucherHeader, Long> {
    private static final Logger LOGGER = Logger.getLogger(VoucherService.class);
    @Autowired
    @Qualifier(value="persistenceService")
    protected PersistenceService persistenceService;
    @Autowired
    @Qualifier(value="eisCommonService")
    protected EisCommonService eisCommonService;
    @Autowired
    @Qualifier(value="budgetDetailsDAO")
    private BudgetDetailsDAO budgetDetailsDAO;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    @Qualifier(value="voucherHibDAO")
    private VoucherHibernateDAO voucherHibDAO;
    @Autowired
    private ChartOfAccountsDAO coaDAO;
    @Autowired
    private VoucherTypeForULB voucherTypeForULB;
    @Autowired
    private FunctionDAO functionDAO;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private VoucherHeaderDAO voucherHeaderDAO;
    @Autowired
    @Qualifier(value="voucherHelper")
    private VoucherHelper voucherHelper;
    @Autowired
    @Qualifier(value="eGovernCommon")
    private EGovernCommon eGovernCommon;
    private static final SimpleDateFormat FORMATDDMMYYYY = new SimpleDateFormat("dd/MM/yyyy", Constants.LOCALE);
    public static final SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy", Constants.LOCALE);
    @Autowired
    private ApplicationSequenceNumberGenerator sequenceGenerator;
    @Autowired
    @Qualifier(value="financialYearDAO")
    private FinancialYearHibernateDAO financialYearDAO;
    @Autowired
    private EgovCommon egovCommon;
    @Autowired
    private DesignationService designationService;
    @Autowired
    private AutonumberServiceBeanResolver beanResolver;
    private EISServeable eisService;
    private EmployeeServiceOld employeeService;
    @Autowired
    private ScriptService scriptService;
    @Autowired
    @Qualifier(value="egBillRegisterService")
    private EgBillRegisterService egBillRegisterService;
    @Autowired
    private EntityManager entityManager;
    @Autowired
    private AccountdetailtypeHibernateDAO accountdetailtypeHibernateDAO;
    @Autowired
    @Qualifier(value="recordStatusPersistenceService")
    private PersistenceService recordStatusPersistenceService;

    public VoucherService(Class<CVoucherHeader> voucherHeader) {
        super(voucherHeader);
    }

    public VoucherService() {
        super(CVoucherHeader.class);
    }

    public Boundary getBoundaryForUser(CVoucherHeader rv) {
        return this.egovCommon.getBoundaryForUser(rv.getCreatedBy());
    }

    public String getEmployeeNameForPositionId(Position pos) throws ApplicationRuntimeException {
        Assignment assignment = (Assignment)this.assignmentService.getAssignmentsForPosition(Long.valueOf(pos.getId()), new Date()).get(0);
        return assignment.getEmployee().getName() + " (" + assignment.getDesignation().getName() + ")";
    }

    public Department getCurrentDepartment() {
        Assignment assignment = this.eisCommonService.getLatestAssignmentForEmployeeByDate(ApplicationThreadLocals.getUserId(), new Date());
        return assignment.getDepartment();
    }

    public Department getDepartmentForWfItem(CVoucherHeader cv) {
        Assignment assignment = this.eisCommonService.getLatestAssignmentForEmployeeByDate(cv.getCreatedBy().getId(), new Date());
        return assignment.getDepartment();
    }

    public Department getTempDepartmentForWfItem(CVoucherHeader cv, Position position) {
        Department d = null;
        this.eisCommonService.getEmployeeByUserId(cv.getCreatedBy().getId());
        d = (Department)this.persistenceService.find("select v.deptId from EmployeeView v left join v.userMaster  as user where v.isPrimary=true and user.id=?", new Object[]{ApplicationThreadLocals.getUserId()});
        return d;
    }

    public Department getDepartmentForUser(User user) {
        return this.egovCommon.getDepartmentForUser(user, this.eisCommonService, this.employeeService, this.persistenceService);
    }

    public PersonalInformation getEmpForCurrentUser() {
        return this.eisCommonService.getEmployeeByUserId(ApplicationThreadLocals.getUserId());
    }

    public Position getPositionForWfItem(CVoucherHeader rv) {
        return this.eisCommonService.getPositionByUserId(rv.getCreatedBy().getId());
    }

    public boolean budgetaryCheck(EgBillregister billregister) throws ValidationException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        CChartOfAccounts coa = null;
        boolean result = false;
        paramMap.put("asondate", billregister.getBilldate());
        if (billregister.getEgBillregistermis().getScheme() != null) {
            paramMap.put("schemeid", billregister.getEgBillregistermis().getScheme().getId());
        }
        if (billregister.getEgBillregistermis().getSubScheme() != null) {
            paramMap.put("subschemeid", billregister.getEgBillregistermis().getSubScheme().getId());
        }
        if (billregister.getEgBillregistermis().getFieldid() != null) {
            paramMap.put("boundaryid", billregister.getEgBillregistermis().getFieldid().getId());
        }
        if (billregister.getEgBillregistermis().getEgDepartment() != null) {
            paramMap.put("deptid", billregister.getEgBillregistermis().getEgDepartment().getId());
        }
        if (billregister.getEgBillregistermis().getFunctionaryid() != null) {
            paramMap.put("functionaryid", billregister.getEgBillregistermis().getFunctionaryid().getId());
        }
        if (billregister.getEgBillregistermis().getFund() != null) {
            paramMap.put("fundid", billregister.getEgBillregistermis().getFund().getId());
        }
        paramMap.put("mis.budgetcheckreq", billregister.getEgBillregistermis().isBudgetCheckReq());
        for (EgBilldetails detail : billregister.getEgBilldetailes()) {
            paramMap.put("debitAmt", detail.getDebitamount());
            paramMap.put("creditAmt", detail.getCreditamount());
            coa = (CChartOfAccounts)this.persistenceService.find(" from CChartOfAccounts where id=?", new Object[]{Long.valueOf(detail.getGlcodeid().toString())});
            paramMap.put("glcode", coa.getGlcode());
            if (detail.getFunctionid() != null) {
                paramMap.put("functionid", Long.valueOf(detail.getFunctionid().toString()));
            }
            paramMap.put("bill", billregister);
            result = this.budgetDetailsDAO.budgetaryCheckForBill(paramMap);
            if (result) continue;
            throw new ValidationException("", "Budget Check failed for " + coa.getGlcode(), new String[0]);
        }
        return result;
    }

    public Map<String, Object> getDesgByDeptAndTypeAndVoucherDate(String type, String scriptName, Date vouDate, Paymentheader paymentheader) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Voucher Service | getDesgUserByDeptAndDesgName | Start");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        Designation designation = null;
        Double grossAmount = this.getJVsGrassAmount(paymentheader);
        List list = (List)this.scriptService.executeScript(scriptName, ScriptService.createContext((Object[])new Object[]{"eisCommonServiceBean", this.eisCommonService, "grossAmount", grossAmount, "userId", ApplicationThreadLocals.getUserId().intValue(), "DATE", new Date(), "type", type, "vouDate", vouDate.getTime(), "paymentheader", paymentheader}));
        ArrayList designationList = new ArrayList();
        for (String desgFuncryName : list) {
            if (desgFuncryName.trim().length() != 0 && !desgFuncryName.equalsIgnoreCase("END")) {
                HashMap<String, String> desgFuncryMap = new HashMap<String, String>();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Designation and Functionary  Name  = " + desgFuncryName));
                }
                designation = this.designationService.getDesignationByName(desgFuncryName.substring(desgFuncryName.indexOf(45) + 1));
                desgFuncryMap.put("designationName", desgFuncryName.substring(0, desgFuncryName.indexOf(45)).split("~")[0] + "-" + designation.getName());
                desgFuncryMap.put("designationId", designation.getId() + "-" + desgFuncryName.substring(0, desgFuncryName.indexOf(45)));
                designationList.add(desgFuncryMap);
                continue;
            }
            if (!desgFuncryName.equalsIgnoreCase("END")) continue;
            map.put("wfitemstate", "END");
        }
        map.put("designationList", designationList);
        return map;
    }

    public Double getJVsGrassAmount(Paymentheader paymentheader) {
        if (paymentheader != null) {
            if (!paymentheader.getVoucherheader().getName().equalsIgnoreCase("Direct Bank Payment")) {
                Paymentheader ph = (Paymentheader)this.persistenceService.find("select ph from Paymentheader ph , Miscbilldetail misc ,CVoucherHeader vh,CGeneralLedger gl where misc.payVoucherHeader = ph.voucherheader and misc.billVoucherHeader = vh and gl.voucherHeaderId = vh and vh.status not in (" + FinancialConstants.CANCELLEDVOUCHERSTATUS + ") and gl.debitAmount > 0  and (gl.glcode like '210%' or gl.glcode like '460%') and ph = ? ", new Object[]{paymentheader});
                if (ph != null) {
                    return 0.0;
                }
                Double grossAmount = (Double)this.persistenceService.find("select sum(gl.debitAmount) from Paymentheader ph , Miscbilldetail misc ,CVoucherHeader vh,CGeneralLedger gl where misc.payVoucherHeader = ph.voucherheader and misc.billVoucherHeader = vh and gl.voucherHeaderId = vh and vh.status not in (" + FinancialConstants.CANCELLEDVOUCHERSTATUS + ") and gl.debitAmount > 0 and ph = ?", new Object[]{paymentheader});
                return grossAmount != null ? grossAmount : 0.0;
            }
            Paymentheader ph = (Paymentheader)this.persistenceService.find("select ph from Paymentheader ph ,CVoucherHeader vh,CGeneralLedger gl where ph.voucherheader = vh and gl.voucherHeaderId = vh and vh.status not in (" + FinancialConstants.CANCELLEDVOUCHERSTATUS + ") and gl.debitAmount > 0 and (gl.glcode like '210%' or gl.glcode like '460%') and ph = ? ", new Object[]{paymentheader});
            if (ph != null) {
                return 0.0;
            }
            Double grossAmount = (Double)this.persistenceService.find("select sum(gl.debitAmount) from Paymentheader ph ,CVoucherHeader vh,CGeneralLedger gl where ph.voucherheader = vh and gl.voucherHeaderId = vh and vh.status not in (" + FinancialConstants.CANCELLEDVOUCHERSTATUS + ") and gl.debitAmount > 0 and ph = ?", new Object[]{paymentheader});
            return grossAmount != null ? grossAmount : 0.0;
        }
        return 0.0;
    }

    public void createVoucherfromPreApprovedVoucher(CVoucherHeader vh) {
        List appList = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "APPROVEDVOUCHERSTATUS");
        String approvedVoucherStatus = ((AppConfigValues)appList.get(0)).getValue();
        vh.setStatus(Integer.valueOf(approvedVoucherStatus));
    }

    public List<Map<String, Object>> getJournalVouchers(CVoucherHeader voucherHeader, Map<String, Object> searchFilterMap) throws ApplicationException, ParseException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"VoucherService | getJournalVouchers | Start");
        }
        List<CVoucherHeader> vouchers = this.voucherHibDAO.getVoucherList(voucherHeader, searchFilterMap);
        HashMap<String, Object> voucherMap = null;
        ArrayList<Map<String, Object>> voucherList = new ArrayList<Map<String, Object>>();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("voucherList size = " + voucherList.size()));
        }
        for (CVoucherHeader voucherheader : vouchers) {
            voucherMap = new HashMap<String, Object>();
            BigDecimal amt = BigDecimal.ZERO;
            voucherMap.put("id", voucherheader.getId());
            voucherMap.put("vouchernumber", voucherheader.getVoucherNumber());
            voucherMap.put("type", voucherheader.getType());
            voucherMap.put("voucherdate", voucherheader.getVoucherDate());
            voucherMap.put("fundname", voucherheader.getFundId().getName());
            Set vDetailSet = voucherheader.getGeneralledger();
            for (CGeneralLedger detail : vDetailSet) {
                amt = amt.add(new BigDecimal(detail.getDebitAmount()));
            }
            voucherMap.put("amount", amt);
            if (voucherheader.getStatus() != null) {
                voucherMap.put("status", voucherheader.getStatus() == 0 ? (voucherheader.getIsConfirmed() == 0 ? "UnConfirmed" : "Confirmed") : (voucherheader.getStatus() == 1 ? "Reversed" : (voucherheader.getStatus() == 2 ? "Reversal" : "")));
            }
            voucherList.add(voucherMap);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Total number of vouchers = " + voucherList.size()));
        }
        return voucherList;
    }

    public Map<String, Object> getVoucherInfo(Long voucherId) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"VoucherService | getVoucherDetails | Start");
        }
        HashMap<String, Object> voucherMap = new HashMap<String, Object>();
        CVoucherHeader voucherHeader = (CVoucherHeader)this.persistenceService.find("from CVoucherHeader where id=?", new Object[]{voucherId});
        voucherMap.put("voucherHeader", voucherHeader);
        List<CGeneralLedger> glList = this.voucherHibDAO.getGLInfo(voucherHeader.getId());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("total number of general ledger entry " + glList.size()));
        }
        ArrayList<VoucherDetails> billDetailslist = new ArrayList<VoucherDetails>();
        ArrayList<VoucherDetails> subLedgerlist = new ArrayList<VoucherDetails>();
        BigDecimal crAmount = BigDecimal.ZERO;
        BigDecimal drAmount = BigDecimal.ZERO;
        try {
            for (CGeneralLedger generalLedger : glList) {
                VoucherDetails voucherDetail = new VoucherDetails();
                if (null != generalLedger.getFunctionId()) {
                    voucherDetail.setFunctionIdDetail(Long.valueOf(generalLedger.getFunctionId().toString()));
                    voucherDetail.setFunctionDetail(this.functionDAO.getFunctionById(Long.valueOf(generalLedger.getFunctionId().toString())).getName());
                }
                voucherDetail.setGlcodeIdDetail(generalLedger.getGlcodeId().getId());
                voucherDetail.setGlcodeDetail(generalLedger.getGlcodeId().getGlcode());
                voucherDetail.setAccounthead(this.coaDAO.findById((Number)generalLedger.getGlcodeId().getId(), false).getName());
                drAmount = new BigDecimal(generalLedger.getDebitAmount());
                crAmount = new BigDecimal(generalLedger.getCreditAmount());
                voucherDetail.setDebitAmountDetail(drAmount.setScale(2, 4));
                voucherDetail.setCreditAmountDetail(crAmount.setScale(2, 4));
                billDetailslist.add(voucherDetail);
                List<CGeneralLedgerDetail> gledgerDetailList = this.voucherHibDAO.getGeneralledgerdetail(generalLedger.getId());
                for (CGeneralLedgerDetail gledgerDetail : gledgerDetailList) {
                    VoucherDetails subLedgerDetail = new VoucherDetails();
                    subLedgerDetail.setAmount(gledgerDetail.getAmount().setScale(2));
                    subLedgerDetail.setGlcode(this.coaDAO.findById((Number)generalLedger.getGlcodeId().getId(), false));
                    subLedgerDetail.setSubledgerCode(generalLedger.getGlcodeId().getGlcode());
                    Accountdetailtype accountdetailtype = this.voucherHibDAO.getAccountDetailById(gledgerDetail.getDetailTypeId().getId());
                    subLedgerDetail.setDetailType(accountdetailtype);
                    subLedgerDetail.setDetailTypeName(accountdetailtype.getName());
                    EntityType entity = this.voucherHibDAO.getEntityInfo(gledgerDetail.getDetailKeyId(), accountdetailtype.getId());
                    subLedgerDetail.setDetailCode(entity.getCode());
                    subLedgerDetail.setDetailKeyId(gledgerDetail.getDetailKeyId());
                    subLedgerDetail.setDetailKey(entity.getName());
                    subLedgerDetail.setFunctionDetail(generalLedger.getFunctionId() != null ? generalLedger.getFunctionId().toString() : "0");
                    subLedgerlist.add(subLedgerDetail);
                }
            }
        }
        catch (HibernateException e) {
            LOGGER.error((Object)("Exception occured in VoucherSerive |getVoucherInfo " + (Object)((Object)e)));
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exception occured in VoucherSerive |getVoucherInfo " + e));
        }
        voucherMap.put("glDetailList", billDetailslist);
        if (subLedgerlist.isEmpty()) {
            subLedgerlist.add(new VoucherDetails());
        }
        voucherMap.put("subLedgerDetail", subLedgerlist);
        return voucherMap;
    }

    public CVoucherHeader updateVoucherHeader(CVoucherHeader voucherHeader) {
        String voucherNumType = voucherHeader.getType();
        return this.updateVoucherHeader(voucherHeader, voucherNumType);
    }

    @Transactional
    public CVoucherHeader updateVoucherHeader(CVoucherHeader voucherHeader, VoucherTypeBean voucherTypeBean) {
        String voucherNumType = voucherTypeBean.getVoucherNumType();
        if (voucherTypeBean.getVoucherNumType() == null) {
            voucherNumType = voucherHeader.getType();
        }
        return this.updateVoucherHeader(voucherHeader, voucherNumType);
    }

    @Transactional
    public CVoucherHeader updateVoucherHeader(CVoucherHeader voucherHeader, String voucherNumType) {
        CVoucherHeader existingVH = null;
        try {
            if (voucherHeader.getId() != null && voucherHeader.getId() != -1L) {
                existingVH = (CVoucherHeader)this.find("from CVoucherHeader where id=?", new Object[]{voucherHeader.getId()});
            }
            existingVH = this.getUpdatedVNumCGVN(existingVH, voucherHeader, voucherNumType);
            existingVH.setFundId(voucherHeader.getFundId());
            existingVH.getVouchermis().setDepartmentid(voucherHeader.getVouchermis().getDepartmentid());
            existingVH.getVouchermis().setFunction(voucherHeader.getVouchermis().getFunction());
            existingVH.getVouchermis().setSchemeid(voucherHeader.getVouchermis().getSchemeid());
            existingVH.getVouchermis().setSubschemeid(voucherHeader.getVouchermis().getSubschemeid());
            existingVH.getVouchermis().setFunctionary(voucherHeader.getVouchermis().getFunctionary());
            existingVH.getVouchermis().setDivisionid(voucherHeader.getVouchermis().getDivisionid());
            existingVH.getVouchermis().setFundsource(voucherHeader.getVouchermis().getFundsource());
            existingVH.setVoucherDate(voucherHeader.getVoucherDate());
            existingVH.setDescription(voucherHeader.getDescription());
            this.applyAuditing((AbstractAuditable)existingVH);
            this.update(existingVH);
        }
        catch (HibernateException e) {
            LOGGER.error((Object)e);
            throw new HibernateException("Exception occured in voucher service while updating voucher header" + (Object)((Object)e));
        }
        catch (ApplicationRuntimeException e) {
            LOGGER.error((Object)e);
            throw new ApplicationRuntimeException("Exception occured in voucher service while updating voucher header" + (Object)((Object)e));
        }
        return existingVH;
    }

    public CVoucherHeader getUpdatedVNumCGVN(CVoucherHeader existingVH, CVoucherHeader voucherHeader, String voucherNumType) {
        String autoVoucherType = null;
        if (voucherNumType.equalsIgnoreCase("Journal Voucher")) {
            voucherNumType = "Journal";
        }
        autoVoucherType = existingVH.getVoucherNumber().substring(Integer.parseInt(FinancialConstants.VOUCHERNO_TYPE_LENGTH) - Integer.parseInt(FinancialConstants.VOUCHERNO_TYPE_SUBLENGTH), Integer.parseInt(FinancialConstants.VOUCHERNO_TYPE_LENGTH));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("autoVoucherType FOR MODIFIED VOUCHER :" + autoVoucherType));
        }
        String vNumGenMode = this.voucherTypeForULB.readVoucherTypes(voucherNumType);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("new fund id :" + voucherHeader.getFundId().getId()));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("old fund id :" + existingVH.getFundId().getId()));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("new voucher date :" + voucherHeader.getVoucherDate()));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("old voucher date :" + existingVH.getVoucherDate()));
        }
        try {
            String fiscalPeriodIdStr = this.eGovernCommon.getFiscalPeriod(sdf.format(voucherHeader.getVoucherDate()));
            if (null == fiscalPeriodIdStr) {
                throw new ApplicationRuntimeException("Voucher Date not within an open period or Financial year not open for posting, fiscalPeriod := " + fiscalPeriodIdStr);
            }
            voucherHeader.setFiscalPeriodId(Integer.valueOf(Integer.parseInt(fiscalPeriodIdStr)));
            if (!voucherHeader.getFundId().equals(existingVH.getFundId())) {
                String strVoucherNumber = this.voucherHelper.getGeneratedVoucherNumber(voucherHeader.getFundId().getId(), autoVoucherType, voucherHeader.getVoucherDate(), vNumGenMode, voucherHeader.getVoucherNumber());
                existingVH.setVoucherNumber(strVoucherNumber);
                String vType = voucherHeader.getFundId().getIdentifier().toString() + "/" + this.getCgnType(voucherHeader.getType()) + "/CGVN";
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Voucher type  : " + vType));
                }
                String eg_voucher = this.voucherHelper.getEg_Voucher(vType, existingVH.getFiscalPeriodId().toString());
                for (int i = eg_voucher.length(); i < 10; ++i) {
                    eg_voucher = "0" + eg_voucher;
                }
                existingVH.setCgvn(vType + eg_voucher);
            } else if (!voucherHeader.getVoucherDate().equals(existingVH.getVoucherDate())) {
                CFiscalPeriod fiscalPeriod = (CFiscalPeriod)this.persistenceService.find(" from CFiscalPeriod where id=?", new Object[]{Long.valueOf(fiscalPeriodIdStr)});
                String financialYearId = this.financialYearDAO.getFinancialYearId(Constants.DDMMYYYYFORMAT2.format(existingVH.getVoucherDate()));
                CFinancialYear financialYear = this.financialYearDAO.getFinancialYearById(Long.valueOf(financialYearId));
                if (existingVH.getFiscalPeriodId().equals(voucherHeader.getFiscalPeriodId()) && fiscalPeriod.getcFinancialYear().getId().longValue() == financialYear.getId().longValue()) {
                    String vDate = Constants.DDMMYYYYFORMAT2.format(voucherHeader.getVoucherDate());
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("Voucher Number  : " + existingVH.getVoucherNumber()));
                    }
                    String strTempVoucherNumber = existingVH.getVoucherNumber();
                    String strVoucherNumber = "";
                    String[] newDate = vDate.split("/");
                    String[] voucherArr = strTempVoucherNumber.split("/");
                    strVoucherNumber = voucherArr[0] + "/" + voucherArr[1] + "/" + voucherArr[2] + "/" + newDate[1] + "/" + voucherArr[4];
                    existingVH.setVoucherNumber(strVoucherNumber);
                } else {
                    String strVoucherNumber = this.voucherHelper.getGeneratedVoucherNumber(voucherHeader.getFundId().getId(), autoVoucherType, voucherHeader.getVoucherDate(), vNumGenMode, voucherHeader.getVoucherNumber());
                    existingVH.setVoucherNumber(strVoucherNumber);
                    String vType = voucherHeader.getFundId().getIdentifier().toString() + "/" + this.getCgnType(voucherHeader.getType()) + "/CGVN";
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("Voucher type  : " + vType));
                    }
                    String eg_voucher = this.voucherHelper.getEg_Voucher(vType, existingVH.getFiscalPeriodId().toString());
                    for (int i = eg_voucher.length(); i < 10; ++i) {
                        eg_voucher = "0" + eg_voucher;
                    }
                    existingVH.setCgvn(vType + eg_voucher);
                }
            } else if ("Manual".equalsIgnoreCase(vNumGenMode) && !existingVH.getVoucherNumber().substring(Integer.valueOf(FinancialConstants.VOUCHERNO_TYPE_LENGTH)).equalsIgnoreCase(voucherHeader.getVoucherNumber())) {
                String strVoucherNumber = this.voucherHelper.getGeneratedVoucherNumber(voucherHeader.getFundId().getId(), autoVoucherType, voucherHeader.getVoucherDate(), vNumGenMode, voucherHeader.getVoucherNumber());
                existingVH.setVoucherNumber(strVoucherNumber);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            throw new ApplicationRuntimeException("Exception occured while getting upadetd voucher number and cgvn number" + e);
        }
        return existingVH;
    }

    @Transactional
    public void deleteGLDetailByVHId(Object voucherHeaderId) {
        this.voucherHibDAO.deleteGLDetailByVHId(voucherHeaderId);
    }

    public List<Transaxtion> postInTransaction(List<VoucherDetails> billDetailslist, List<VoucherDetails> subLedgerlist, CVoucherHeader voucherHeader) {
        ArrayList<Transaxtion> transaxtionList = new ArrayList<Transaxtion>();
        String accDetailFunc = "";
        String detailedFunc = "";
        Integer voucherLineId = 1;
        List<String> repeatedglCodes = VoucherHelper.getRepeatedGlcodes(billDetailslist);
        try {
            for (VoucherDetails accountDetails : billDetailslist) {
                String glcodeId = accountDetails.getGlcodeIdDetail().toString();
                Transaxtion transaction = new Transaxtion();
                transaction.setGlCode(accountDetails.getGlcodeDetail());
                transaction.setGlName(accountDetails.getAccounthead());
                Integer n = voucherLineId;
                voucherLineId = voucherLineId + 1;
                Integer n2 = voucherLineId;
                transaction.setVoucherLineId(String.valueOf(n));
                transaction.setVoucherHeaderId(voucherHeader.getId().toString());
                transaction.setCrAmount(accountDetails.getCreditAmountDetail().toString());
                transaction.setDrAmount(accountDetails.getDebitAmountDetail().toString());
                if (null != accountDetails.getFunctionIdDetail()) {
                    transaction.setFunctionId(accountDetails.getFunctionIdDetail().toString());
                }
                ArrayList<TransaxtionParameter> reqParams = new ArrayList<TransaxtionParameter>();
                for (VoucherDetails subledgerDetails : subLedgerlist) {
                    String detailGlCode = subledgerDetails.getGlcode().getId().toString();
                    detailedFunc = null != voucherHeader.getIsRestrictedtoOneFunctionCenter() && voucherHeader.getIsRestrictedtoOneFunctionCenter() != false ? voucherHeader.getVouchermis().getFunction().toString() : subledgerDetails.getFunctionDetail();
                    String detailtypeid = subledgerDetails.getDetailType().getId().toString();
                    if (!glcodeId.equals(detailGlCode) || repeatedglCodes.contains(glcodeId) && !"".equals(detailedFunc)) continue;
                    TransaxtionParameter reqData = new TransaxtionParameter();
                    Accountdetailtype adt = this.accountdetailtypeHibernateDAO.findById((Number)Integer.valueOf(detailtypeid), false);
                    reqData.setDetailName(adt.getAttributename());
                    reqData.setGlcodeId(detailGlCode);
                    reqData.setDetailAmt(subledgerDetails.getAmount().toString());
                    reqData.setDetailKey(subledgerDetails.getDetailKeyId().toString());
                    reqData.setDetailTypeId(detailtypeid);
                    reqParams.add(reqData);
                }
                if (reqParams != null && reqParams.size() > 0) {
                    transaction.setTransaxtionParam(reqParams);
                }
                transaxtionList.add(transaction);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Exception occured while posting data into voucher detail and transaction");
            throw new ApplicationRuntimeException("Exception occured while posting data into voucher detail and transaction" + e.getMessage());
        }
        return transaxtionList;
    }

    public void setVoucherHeaderDetails(CVoucherHeader voucherHeader, VoucherTypeBean voucherTypeBean) throws Exception {
        voucherHeader.setName(voucherTypeBean.getVoucherName());
        voucherHeader.setType(voucherTypeBean.getVoucherType());
        String vNumGenMode = null;
        vNumGenMode = null != voucherHeader.getType() && "Journal Voucher".equalsIgnoreCase(voucherHeader.getType()) ? this.voucherTypeForULB.readVoucherTypes("Journal") : this.voucherTypeForULB.readVoucherTypes(voucherTypeBean.getVoucherNumType());
        String autoVoucherType = EGovConfig.getProperty((String)"egf_config.xml", (String)voucherTypeBean.getVoucherNumType().toLowerCase(), (String)"", (String)"vouchernumberformat");
        String vocuherNumber = this.voucherHelper.getGeneratedVoucherNumber(voucherHeader.getFundId().getId(), autoVoucherType, voucherHeader.getVoucherDate(), vNumGenMode, voucherHeader.getVoucherNumber());
        voucherHeader.setVoucherNumber(vocuherNumber);
    }

    public CVoucherHeader postIntoVoucherHeader(CVoucherHeader voucherHeader, VoucherTypeBean voucherTypeBean) throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"start | insertIntoVoucherHeader");
        }
        voucherHeader.setName(voucherTypeBean.getVoucherName());
        voucherHeader.setType(voucherTypeBean.getVoucherType());
        String vNumGenMode = null;
        vNumGenMode = null != voucherHeader.getType() && "Journal Voucher".equalsIgnoreCase(voucherHeader.getType()) ? this.voucherTypeForULB.readVoucherTypes("Journal") : this.voucherTypeForULB.readVoucherTypes(voucherTypeBean.getVoucherNumType());
        String autoVoucherType = EGovConfig.getProperty((String)"egf_config.xml", (String)voucherTypeBean.getVoucherNumType().toLowerCase(), (String)"", (String)"vouchernumberformat");
        String vocuherNumber = this.voucherHelper.getGeneratedVoucherNumber(voucherHeader.getFundId().getId(), autoVoucherType, voucherHeader.getVoucherDate(), vNumGenMode, voucherHeader.getVoucherNumber());
        voucherHeader.setVoucherNumber(vocuherNumber);
        try {
            String vdt = Constants.DDMMYYYYFORMAT1.format(voucherHeader.getVoucherDate());
            String fiscalPeriod = null;
            fiscalPeriod = this.eGovernCommon.getFiscalPeriod(vdt);
            if (null == fiscalPeriod) {
                throw new ApplicationRuntimeException("Voucher Date not within an open period or Financial year not open for posting, fiscalPeriod := " + fiscalPeriod);
            }
            voucherHeader.setFiscalPeriodId(Integer.valueOf(fiscalPeriod));
            String vType = voucherHeader.getFundId().getIdentifier() + "/" + this.getCgnType(voucherHeader.getType()) + "/CGVN";
            String eg_voucher = this.eGovernCommon.getEg_Voucher(vType, fiscalPeriod);
            for (int i = eg_voucher.length(); i < 10; ++i) {
                eg_voucher = "0" + eg_voucher;
            }
            String cgNum = vType + eg_voucher;
            voucherHeader.setCgvn(cgNum);
            voucherHeader.setEffectiveDate(new Date());
            if (!this.eGovernCommon.isUniqueVN(voucherHeader.getVoucherNumber(), vdt)) {
                throw new ApplicationRuntimeException("Duplicate Voucher Number");
            }
            voucherHeader.getVouchermis().setVoucherheaderid(voucherHeader);
            voucherHeader.setStatus(FinancialConstants.PREAPPROVEDVOUCHERSTATUS);
            List appConfig = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "JournalVoucher_ConfirmonCreate");
            if (null != appConfig && !appConfig.isEmpty()) {
                for (AppConfigValues appConfigVal : appConfig) {
                    voucherHeader.setIsConfirmed(Integer.valueOf(appConfigVal.getValue()));
                }
            }
            this.persist(voucherHeader);
            if (!voucherHeader.getType().equalsIgnoreCase("Journal Voucher")) {
                StringBuffer sourcePath = new StringBuffer();
                sourcePath.append(voucherHeader.getVouchermis().getSourcePath()).append(voucherHeader.getId().toString());
                voucherHeader.getVouchermis().setSourcePath(sourcePath.toString());
                this.update(voucherHeader);
            }
        }
        catch (ApplicationRuntimeException e) {
            LOGGER.error((Object)e);
            throw new ApplicationRuntimeException(e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            throw new ApplicationRuntimeException(e.getMessage());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"End | insertIntoVoucherHeader");
        }
        return voucherHeader;
    }

    protected String getCgnType(String vType) {
        vType = vType.toUpperCase().replaceAll(" ", "");
        String cgnType = null;
        String typetoCheck = vType;
        if (vType.equalsIgnoreCase("JOURNAL VOUCHER")) {
            typetoCheck = "JOURNALVOUCHER";
        }
        switch (voucherTypeEnum.valueOf(typetoCheck.toUpperCase())) {
            case JOURNALVOUCHER: {
                cgnType = "JVG";
                break;
            }
            case CONTRA: {
                cgnType = "CSL";
                break;
            }
            case RECEIPT: {
                cgnType = "MSR";
                break;
            }
            case PAYMENT: {
                cgnType = "DBP";
            }
        }
        return cgnType;
    }

    public void insertIntoRecordStatus(CVoucherHeader voucherHeader) throws Exception {
        try {
            EgfRecordStatus recordStatus = new EgfRecordStatus();
            String code = EGovConfig.getProperty((String)"egf_config.xml", (String)"confirmoncreate", (String)"", (String)voucherHeader.getType());
            if ("N".equalsIgnoreCase(code)) {
                recordStatus.setStatus(Integer.valueOf(1));
            } else {
                recordStatus.setStatus(Integer.valueOf(0));
            }
            recordStatus.setUpdatedtime(new Date());
            recordStatus.setVoucherheader(voucherHeader);
            recordStatus.setRecordType(voucherHeader.getType());
            recordStatus.setUserid(Integer.valueOf(ApplicationThreadLocals.getUserId().intValue()));
            this.recordStatusPersistenceService.persist((Object)recordStatus);
        }
        catch (HibernateException he) {
            LOGGER.error((Object)he.getMessage());
            throw new HibernateException((Throwable)he);
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage());
            throw new HibernateException((Throwable)e);
        }
    }

    public Map<String, Object> getDesgByDeptAndType(String type, String scriptName) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Voucher Service | getDesgUserByDeptAndDesgName | Start");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList designationList = new ArrayList();
        map.put("wfitemstate", "END");
        map.put("designationList", designationList);
        return map;
    }

    public Map<String, Object> getDesgByDeptAndTypeAndvouDate(String type, String scriptName, Date vouDate) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Voucher Service | getDesgUserByDeptAndDesgName | Start");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        Designation designation = null;
        this.persistenceService.findAllByNamedQuery("Script.findByName", new Object[]{scriptName}).get(0);
        List list = null;
        ArrayList designationList = new ArrayList();
        for (String desgFuncryName : list) {
            if (desgFuncryName.trim().length() != 0 && !desgFuncryName.equalsIgnoreCase("END")) {
                HashMap<String, String> desgFuncryMap = new HashMap<String, String>();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Designation and Functionary  Name  = " + desgFuncryName));
                }
                designation = this.designationService.getDesignationByName(desgFuncryName.substring(desgFuncryName.indexOf(45) + 1));
                desgFuncryMap.put("designationName", designation.getName());
                desgFuncryMap.put("designationId", designation.getId() + "-" + desgFuncryName.substring(0, desgFuncryName.indexOf(45)));
                designationList.add(desgFuncryMap);
                continue;
            }
            if (!desgFuncryName.equalsIgnoreCase("END")) continue;
            map.put("wfitemstate", "END");
        }
        map.put("designationList", designationList);
        return map;
    }

    public Map<String, Object> getDesgByDeptAndTypeAndVoudate(String type, String scriptName, Date vouDate) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Voucher Service | getDesgUserByDeptAndDesgName | Start");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        Designation designation = null;
        this.persistenceService.findAllByNamedQuery("Script.findByName", new Object[]{scriptName}).get(0);
        List list = null;
        ArrayList designationList = new ArrayList();
        for (String desgFuncryName : list) {
            if (desgFuncryName.trim().length() != 0 && !desgFuncryName.equalsIgnoreCase("END")) {
                HashMap<String, String> desgFuncryMap = new HashMap<String, String>();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Designation and Functionary  Name  = " + desgFuncryName));
                }
                designation = this.designationService.getDesignationByName(desgFuncryName.substring(desgFuncryName.indexOf(45) + 1));
                desgFuncryMap.put("designationName", designation.getName());
                desgFuncryMap.put("designationId", designation.getId() + "-" + desgFuncryName.substring(0, desgFuncryName.indexOf(45)));
                designationList.add(desgFuncryMap);
                continue;
            }
            if (!desgFuncryName.equalsIgnoreCase("END")) continue;
            map.put("wfitemstate", "END");
        }
        map.put("designationList", designationList);
        return map;
    }

    public Map<String, Object> getDesgBYPassingWfItem(String scriptName, Object wfitem, Integer deptId) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Voucher Service | getDesgUserByDeptAndDesgName | Start");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        Designation designation = null;
        Script validScript = (Script)this.persistenceService.findAllByNamedQuery("Script.findByName", new Object[]{scriptName}).get(0);
        List list = (List)this.scriptService.executeScript(validScript, ScriptService.createContext((Object[])new Object[]{"eisCommonServiceBean", this.eisCommonService, "userId", ApplicationThreadLocals.getUserId().intValue(), "DATE", new Date(), "wfitem", wfitem, "deptId", deptId, "persistenceService", this.persistenceService}));
        List<Object> designationList = new ArrayList();
        for (String desgFuncryName : list) {
            if (desgFuncryName.trim().length() != 0 && !desgFuncryName.equalsIgnoreCase("END") && !desgFuncryName.equalsIgnoreCase("ANYFUNCTIONARY-ANYDESG")) {
                HashMap<String, String> desgFuncryMap = new HashMap<String, String>();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Designation and Functionary  Name  = " + desgFuncryName));
                }
                designation = this.designationService.getDesignationByName(desgFuncryName.substring(desgFuncryName.indexOf(45) + 1));
                desgFuncryMap.put("designationName", designation.getName());
                desgFuncryMap.put("designationId", designation.getId() + "-" + desgFuncryName.substring(0, desgFuncryName.indexOf(45)));
                designationList.add(desgFuncryMap);
                map.put("wfitemstate", desgFuncryName);
                continue;
            }
            if (desgFuncryName.equalsIgnoreCase("ANYFUNCTIONARY-ANYDESG")) {
                designationList = this.getAllDesgByAndDept(deptId, desgFuncryName);
                map.put("wfitemstate", desgFuncryName);
                continue;
            }
            if (!desgFuncryName.equalsIgnoreCase("END")) continue;
            map.put("wfitemstate", desgFuncryName);
        }
        map.put("designationList", designationList);
        return map;
    }

    public List<Map<String, Object>> getAllDesgByAndDept(Integer deptId, String desgfuncry) {
        ArrayList<Map<String, Object>> desgList = new ArrayList<Map<String, Object>>();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"VoucherService | getAllDesgByFuncryAndDept | Start");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("department id = " + deptId));
        }
        StringBuffer query = new StringBuffer(200);
        query.append("select DISTINCT desg.name,desg.id from Designation desg , EmployeeView ev where ").append(" desg.id=ev.desigId.id and ev.deptId.id = ? and ev.userMaster is not null");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("getAllDesgByFuncryAndDept Query : = " + query.toString()));
        }
        List list = this.persistenceService.findAllBy(query.toString(), new Object[]{deptId});
        for (Object[] objects : list) {
            HashMap<String, Object> desgMap = new HashMap<String, Object>();
            desgMap.put("designationName", objects[0]);
            desgMap.put("designationId", objects[1] + "-" + desgfuncry.substring(0, desgfuncry.indexOf(45)));
            desgList.add(desgMap);
        }
        return desgList;
    }

    public List<EmployeeView> getUserByDeptAndDesgName(String departmentId, String designationId, String functionaryId) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("departmentId", departmentId);
        paramMap.put("designationId", designationId);
        paramMap.put("functionaryId", functionaryId);
        List empInfoList = this.eisService.getEmployeeInfoList(paramMap);
        return empInfoList;
    }

    @Transactional
    public EgBillregister createBillForVoucherSubType(List<VoucherDetails> billDetailslist, List<VoucherDetails> subLedgerlist, CVoucherHeader voucherHeader, VoucherTypeBean voucherTypeBean, BigDecimal totalBillAmount) throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"VoucherService | createBillForVoucherSubType | Start");
        }
        EgBillregister egBillregister = new EgBillregister();
        try {
            egBillregister.setBillstatus("APPROVED");
            EgwStatus egwstatus = null;
            if ("Contractor Journal".equalsIgnoreCase(voucherTypeBean.getVoucherName())) {
                egwstatus = (EgwStatus)this.persistenceService.find("from EgwStatus where upper(moduletype)=? and upper(description)=?", new Object[]{"CONTRACTORBILL", "APPROVED"});
                egBillregister.setExpendituretype("Works");
            } else if ("Supplier Journal".equalsIgnoreCase(voucherTypeBean.getVoucherName())) {
                egwstatus = (EgwStatus)this.persistenceService.find("from EgwStatus where upper(moduletype)=? and upper(description)=?", new Object[]{"SBILL", "APPROVED"});
                egBillregister.setExpendituretype("Purchase");
            } else if ("Salary Journal".equalsIgnoreCase(voucherTypeBean.getVoucherName())) {
                egwstatus = (EgwStatus)this.persistenceService.find("from EgwStatus where upper(moduletype)=? and upper(description)=?", new Object[]{"SALBILL", "APPROVED"});
                egBillregister.setExpendituretype("Salary");
            } else if ("Expense Journal".equalsIgnoreCase(voucherTypeBean.getVoucherName())) {
                egwstatus = (EgwStatus)this.persistenceService.find("from EgwStatus where upper(moduletype)=? and upper(description)=?", new Object[]{"EXPENSEBILL", "APPROVED"});
                egBillregister.setExpendituretype("Expense");
            } else if ("Pension Journal".equalsIgnoreCase(voucherTypeBean.getVoucherName())) {
                egwstatus = (EgwStatus)this.persistenceService.find("from EgwStatus where upper(moduletype)=? and upper(description)=?", new Object[]{"PENSIONBILL", "APPROVED"});
                egBillregister.setExpendituretype("Pension");
            }
            egBillregister.setStatus(egwstatus);
            if (null != voucherTypeBean.getBillDate()) {
                egBillregister.setBilldate(voucherTypeBean.getBillDate());
            } else {
                egBillregister.setBilldate(voucherHeader.getVoucherDate());
            }
            if (null != voucherHeader.getVouchermis().getDivisionid()) {
                egBillregister.setFieldid(new BigDecimal(voucherHeader.getVouchermis().getDivisionid().getId().toString()));
            }
            egBillregister.setNarration(voucherHeader.getDescription());
            egBillregister.setIsactive(true);
            egBillregister.setBilltype("Final Bill");
            egBillregister.setPassedamount(totalBillAmount);
            egBillregister.setBillamount(totalBillAmount);
            EgBillregistermis egBillregistermis = new EgBillregistermis();
            egBillregistermis.setFund(voucherHeader.getFundId());
            egBillregistermis.setEgDepartment(voucherHeader.getVouchermis().getDepartmentid());
            egBillregistermis.setFunctionaryid(voucherHeader.getVouchermis().getFunctionary());
            egBillregistermis.setFunction(voucherHeader.getVouchermis().getFunction());
            egBillregistermis.setFundsource(voucherHeader.getVouchermis().getFundsource());
            egBillregistermis.setScheme(voucherHeader.getVouchermis().getSchemeid());
            egBillregistermis.setSubScheme(voucherHeader.getVouchermis().getSubschemeid());
            egBillregistermis.setNarration(voucherHeader.getDescription());
            egBillregistermis.setPartyBillDate(voucherTypeBean.getPartyBillDate());
            egBillregistermis.setPayto(voucherTypeBean.getPartyName());
            egBillregistermis.setPartyBillNumber(voucherTypeBean.getPartyBillNum());
            egBillregistermis.setFieldid(voucherHeader.getVouchermis().getDivisionid());
            if (voucherTypeBean.getVoucherNumType().equalsIgnoreCase("fixedassetjv")) {
                EgBillSubType egBillSubType = (EgBillSubType)this.persistenceService.find("from EgBillSubType where name=? and expenditureType=?", new Object[]{"Fixed Asset", "Purchase"});
                egBillregistermis.setEgBillSubType(egBillSubType);
            }
            egBillregistermis.setLastupdatedtime(new Date());
            egBillregistermis.setVoucherHeader(voucherHeader);
            egBillregister.setEgBillregistermis(egBillregistermis);
            if (null != voucherTypeBean.getBillNum() && StringUtils.isNotEmpty((String)voucherTypeBean.getBillNum())) {
                egBillregister.setBillnumber(voucherTypeBean.getBillNum());
            } else {
                JVBillNumberGenerator b = (JVBillNumberGenerator)this.beanResolver.getAutoNumberServiceFor(JVBillNumberGenerator.class);
                String billNumber = b.getNextNumber(egBillregister);
                egBillregister.setBillnumber(billNumber);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("VoucherService | createBillForVoucherSubType | Bill number generated :=" + billNumber));
                }
            }
            if (!this.isBillNumUnique(egBillregister.getBillnumber())) {
                throw new ValidationException(Arrays.asList(new ValidationError("bill number", "Duplicate Bill Number : " + egBillregister.getBillnumber())));
            }
            egBillregistermis.setEgBillregister(egBillregister);
            Set<EgBilldetails> egBilldetailes = new HashSet<EgBilldetails>(0);
            egBilldetailes = this.prepareBillDetails(egBillregister, billDetailslist, subLedgerlist, voucherHeader, egBilldetailes);
            egBillregister.setEgBilldetailes(egBilldetailes);
            this.egBillRegisterService.applyAuditing((AbstractAuditable)egBillregister);
            this.egBillRegisterService.persist(egBillregister);
            voucherHeader.getVouchermis().setSourcePath("/EGF/voucher/journalVoucherModify-beforeModify.action?voucherHeader.id=" + voucherHeader.getId());
            this.update(voucherHeader);
            this.persistenceService.getSession().flush();
        }
        catch (ValidationException e) {
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", ((ValidationError)e.getErrors().get(0)).getMessage()));
            throw new ValidationException(errors);
        }
        catch (Exception e) {
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", e.getMessage()));
            throw new ValidationException(errors);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("VoucherService | createBillForVoucherSubType | End | bill number : = " + egBillregister.getBillnumber()));
        }
        return egBillregister;
    }

    @Transactional
    public EgBillregister updateBillForVSubType(List<VoucherDetails> billDetailslist, List<VoucherDetails> subLedgerlist, CVoucherHeader voucherHeader, VoucherTypeBean voucherTypeBean, BigDecimal totalBillAmount) throws ValidationException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Voucher Service | updateBillForVSubType | Start");
        }
        EgBillregister egBillregister = null;
        try {
            egBillregister = (EgBillregister)this.persistenceService.find("from EgBillregister br where br.egBillregistermis.voucherHeader.id=" + voucherHeader.getId());
            EgBillregistermis egBillregistermis = egBillregister.getEgBillregistermis();
            if (null != voucherTypeBean.getBillDate()) {
                egBillregister.setBilldate(voucherTypeBean.getBillDate());
            } else {
                egBillregister.setBilldate(voucherHeader.getVoucherDate());
            }
            if (null != voucherTypeBean.getBillNum() && StringUtils.isNotEmpty((String)voucherTypeBean.getBillNum()) && !voucherTypeBean.getBillNum().equalsIgnoreCase(egBillregister.getBillnumber())) {
                if (!this.isBillNumUnique(voucherTypeBean.getBillNum())) {
                    throw new ValidationException(Arrays.asList(new ValidationError("bill number", "Duplicate Bill Number : " + voucherTypeBean.getBillNum())));
                }
                egBillregister.setBillnumber(voucherTypeBean.getBillNum());
            }
            if (null != voucherHeader.getVouchermis().getDivisionid()) {
                egBillregister.setFieldid(new BigDecimal(voucherHeader.getVouchermis().getDivisionid().getId().toString()));
            }
            egBillregister.setNarration(voucherHeader.getDescription());
            egBillregister.setPassedamount(totalBillAmount);
            egBillregister.setBillamount(totalBillAmount);
            egBillregistermis.setFund(voucherHeader.getFundId());
            egBillregistermis.setEgDepartment(voucherHeader.getVouchermis().getDepartmentid());
            egBillregistermis.setFunction(voucherHeader.getVouchermis().getFunction());
            egBillregistermis.setFunctionaryid(voucherHeader.getVouchermis().getFunctionary());
            egBillregistermis.setFundsource(voucherHeader.getVouchermis().getFundsource());
            egBillregistermis.setScheme(voucherHeader.getVouchermis().getSchemeid());
            egBillregistermis.setSubScheme(voucherHeader.getVouchermis().getSubschemeid());
            egBillregistermis.setNarration(voucherHeader.getDescription());
            egBillregistermis.setPartyBillDate(voucherTypeBean.getPartyBillDate());
            egBillregistermis.setPayto(voucherTypeBean.getPartyName());
            egBillregistermis.setPartyBillNumber(voucherTypeBean.getPartyBillNum());
            Set<EgBilldetails> egBilldetailes = egBillregister.getEgBilldetailes();
            egBilldetailes.clear();
            this.prepareBillDetails(egBillregister, billDetailslist, subLedgerlist, voucherHeader, egBilldetailes);
            this.egBillRegisterService.update(egBillregister);
        }
        catch (ValidationException e) {
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", ((ValidationError)e.getErrors().get(0)).getMessage()));
            throw new ValidationException(errors);
        }
        catch (Exception e) {
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", e.getMessage()));
            throw new ValidationException(errors);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Voucher Service | updateBillForVSubType | End");
        }
        return egBillregister;
    }

    @Transactional
    private Set<EgBilldetails> prepareBillDetails(EgBillregister egBillregister, List<VoucherDetails> billDetailslist, List<VoucherDetails> subLedgerlist, CVoucherHeader voucherHeader, Set<EgBilldetails> egBilldetailes) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Voucher Service | prepareBillDetails | Start");
        }
        for (VoucherDetails accountDetail : billDetailslist) {
            EgBilldetails egBilldetail = new EgBilldetails();
            egBilldetail.setEgBillregister(egBillregister);
            egBilldetail.setGlcodeid(new BigDecimal(accountDetail.getGlcodeIdDetail().toString()));
            egBilldetail.setDebitamount(accountDetail.getDebitAmountDetail());
            egBilldetail.setCreditamount(accountDetail.getCreditAmountDetail());
            if (null != accountDetail.getFunctionIdDetail()) {
                egBilldetail.setFunctionid(new BigDecimal(accountDetail.getFunctionIdDetail()));
            }
            if (voucherHeader.getVouchermis().getFunction() != null && !voucherHeader.getVouchermis().getFunction().equals("0")) {
                egBilldetail.setFunctionid(new BigDecimal(voucherHeader.getVouchermis().getFunction().getId()));
            }
            egBilldetail.setNarration(voucherHeader.getDescription());
            HashSet<EgBillPayeedetails> egBillPaydetailes = null;
            for (VoucherDetails subledgerDetail : subLedgerlist) {
                if (!accountDetail.getGlcodeIdDetail().equals(subledgerDetail.getGlcode().getId())) continue;
                if (null == egBillPaydetailes) {
                    egBillPaydetailes = new HashSet<EgBillPayeedetails>(0);
                }
                EgBillPayeedetails egBillPaydetail = new EgBillPayeedetails();
                egBillPaydetail.setEgBilldetailsId(egBilldetail);
                egBillPaydetail.setAccountDetailTypeId(subledgerDetail.getDetailType().getId());
                egBillPaydetail.setAccountDetailKeyId(subledgerDetail.getDetailKeyId());
                if (egBilldetail.getDebitamount().compareTo(BigDecimal.ZERO) == 1) {
                    egBillPaydetail.setDebitAmount(subledgerDetail.getAmount());
                } else {
                    egBillPaydetail.setCreditAmount(subledgerDetail.getAmount());
                }
                egBillPaydetail.setNarration(voucherHeader.getDescription());
                egBillPaydetail.setLastUpdatedTime(new Date());
                egBillPaydetailes.add(egBillPaydetail);
            }
            egBilldetail.setEgBillPaydetailes(egBillPaydetailes);
            egBilldetail.setLastupdatedtime(new Date());
            egBilldetailes.add(egBilldetail);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Voucher Service | prepareBillDetails | End");
        }
        return egBilldetailes;
    }

    private boolean isBillNumUnique(String billNumber) {
        String billNum = (String)this.persistenceService.find("select billnumber from EgBillregister where upper(billnumber)='" + billNumber.toUpperCase() + "'");
        return null == billNum;
    }

    public void setEisCommonService(EisCommonService eisCommonService) {
        this.eisCommonService = eisCommonService;
    }

    public void setBudgetDetailsDAO(BudgetDetailsHibernateDAO detailsHibernateDAO) {
        this.budgetDetailsDAO = detailsHibernateDAO;
    }

    public VoucherHibernateDAO getVoucherHibDAO() {
        return this.voucherHibDAO;
    }

    public void setVoucherHibDAO(VoucherHibernateDAO voucherHibDAO) {
        this.voucherHibDAO = voucherHibDAO;
    }

    public void cancelVoucher(CVoucherHeader voucher) {
        voucher.setStatus(Integer.valueOf(4));
        this.update(voucher);
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public Position getPositionForEmployee(Employee emp) throws ApplicationRuntimeException {
        return this.eisCommonService.getPrimaryAssignmentPositionForEmp(emp.getId());
    }

    public void setSequenceGenerator(ApplicationSequenceNumberGenerator sequenceGenerator) {
        this.sequenceGenerator = sequenceGenerator;
    }

    public void setScriptService(ScriptService scriptService) {
        this.scriptService = scriptService;
    }

    public Integer getDefaultDepartment() {
        Department dept;
        this.persistenceService.findAllByNamedQuery("Script.findByName", new Object[]{"BudgetDetail.get.default.department"}).get(0);
        String defaultDepartmentName = null;
        if (!"".equalsIgnoreCase(defaultDepartmentName) && (dept = (Department)this.persistenceService.find("from Department where name=?", new Object[]{defaultDepartmentName})) != null) {
            return dept.getId().intValue();
        }
        return 0;
    }

    public FinancialYearHibernateDAO getFinancialYearDAO() {
        return this.financialYearDAO;
    }

    public void setFinancialYearDAO(FinancialYearHibernateDAO financialYearDAO) {
        this.financialYearDAO = financialYearDAO;
    }

    public void setEmployeeService(EmployeeServiceOld employeeService) {
        this.employeeService = employeeService;
    }

    public void setEisService(EISServeable eisService) {
        this.eisService = eisService;
    }

    public VoucherHelper getVoucherHelper() {
        return this.voucherHelper;
    }

    public void setVoucherHelper(VoucherHelper voucherHelper) {
        this.voucherHelper = voucherHelper;
    }

    static enum voucherTypeEnum {
        JOURNALVOUCHER,
        CONTRA,
        RECEIPT,
        PAYMENT;

    }
}

