/*
 * Decompiled with CFR 0.152.
 */
package org.egov.services.payment;

import com.exilant.GLEngine.ChartOfAccounts;
import com.exilant.GLEngine.Transaxtion;
import com.exilant.eGov.src.common.EGovernCommon;
import com.exilant.eGov.src.transactions.VoucherTypeForULB;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.billsaccounting.services.BillsAccountingService;
import org.egov.billsaccounting.services.CreateVoucher;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.Bankaccount;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.CGeneralLedger;
import org.egov.commons.CGeneralLedgerDetail;
import org.egov.commons.CVoucherHeader;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.ChartOfAccountsHibernateDAO;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.commons.service.ObjectTypeService;
import org.egov.commons.utils.EntityType;
import org.egov.egf.commons.EgovCommon;
import org.egov.eis.entity.Assignment;
import org.egov.eis.entity.Employee;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.EisCommonService;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.bills.EgBillSubType;
import org.egov.model.bills.EgBillregister;
import org.egov.model.bills.Miscbilldetail;
import org.egov.model.instrument.InstrumentHeader;
import org.egov.model.instrument.InstrumentVoucher;
import org.egov.model.payment.ChequeAssignment;
import org.egov.model.payment.PaymentBean;
import org.egov.model.payment.Paymentheader;
import org.egov.model.recoveries.Recovery;
import org.egov.model.voucher.WorkflowBean;
import org.egov.pims.commons.Position;
import org.egov.pims.model.PersonalInformation;
import org.egov.services.cheque.ChequeAssignmentService;
import org.egov.services.cheque.ChequeService;
import org.egov.services.instrument.InstrumentHeaderService;
import org.egov.services.instrument.InstrumentService;
import org.egov.services.payment.MiscbilldetailService;
import org.egov.services.report.FundFlowService;
import org.egov.services.voucher.VoucherService;
import org.egov.utils.Constants;
import org.egov.utils.FinancialConstants;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.hibernate.type.BigDecimalType;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.transaction.annotation.Transactional;

public class PaymentService
extends PersistenceService<Paymentheader, Long> {
    private static final Logger LOGGER = Logger.getLogger(PaymentService.class);
    public SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy", Constants.LOCALE);
    public final SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy", Constants.LOCALE);
    private static final String PAYMENTID = "paymentid";
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private FinancialYearDAO financialYearDAO;
    @Autowired
    private VoucherTypeForULB voucherTypeForULB;
    @Autowired
    private CreateVoucher createVoucher;
    public List<CChartOfAccounts> purchaseBillGlcodeList = new ArrayList<CChartOfAccounts>();
    public List<CChartOfAccounts> worksBillGlcodeList = new ArrayList<CChartOfAccounts>();
    public List<CChartOfAccounts> salaryBillGlcodeList = new ArrayList<CChartOfAccounts>();
    public List<CChartOfAccounts> pensionBillGlcodeList = new ArrayList<CChartOfAccounts>();
    public List<CChartOfAccounts> contingentBillGlcodeList = new ArrayList<CChartOfAccounts>();
    public List<BigDecimal> cBillGlcodeIdList = null;
    protected List<Miscbilldetail> miscBillList = null;
    @Autowired
    private EGovernCommon eGovernCommon;
    private static final String EMPTY_STRING = "";
    private static final String DELIMETER = "~";
    private static final String EXCEPTION_WHILE_SAVING_DATA = "Exception while saving Data";
    private static final String TRANSACTION_FAILED = "Transaction failed";
    private List<HashMap<String, Object>> accountcodedetails = null;
    private List<HashMap<String, Object>> subledgerdetails = null;
    @Autowired
    @Qualifier(value="instrumentService")
    private InstrumentService instrumentService;
    @Autowired
    @Qualifier(value="instrumentHeaderService")
    private InstrumentHeaderService instrumentHeaderService;
    @Autowired
    @Qualifier(value="chequeService")
    private ChequeService chequeService;
    private User user = null;
    private int conBillIdlength = 0;
    public Integer selectedRows = 0;
    private final Date currentDate = new Date();
    List<InstrumentVoucher> instVoucherList;
    @Autowired
    private EisCommonService eisCommonService;
    private BillsAccountingService billsAccountingService;
    @Autowired
    private EgovCommon egovCommon;
    private FundFlowService fundFlowService;
    private ChequeAssignmentService chequeAssignmentService;
    private VoucherService voucherService;
    private ObjectTypeService objectTypeService;
    @Autowired
    private ChartOfAccountsHibernateDAO coaDAO;
    @Autowired
    private EgwStatusHibernateDAO egwStatusDAO;
    @Autowired
    @Qualifier(value="miscbilldetailService")
    private MiscbilldetailService miscbilldetailService;
    @Autowired
    private EntityManager entityManager;
    @Autowired
    ChartOfAccounts chartOfAccounts;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    @Qualifier(value="workflowService")
    private SimpleWorkflowService<Paymentheader> paymentHeaderWorkflowService;
    List<ChequeAssignment> chequeList = null;

    public PaymentService(Class<Paymentheader> type) {
        super(type);
    }

    public BigDecimal getAccountBalance(String accountId, String voucherDate, BigDecimal amount, Long paymentId, Long accGlcodeID) throws ParseException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting getAccountBalance...");
        }
        this.egovCommon.setPersistenceService(this.persistenceService);
        this.egovCommon.setFundFlowService(this.fundFlowService);
        this.egovCommon.setAppConfigValuesService(this.appConfigValuesService);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed getAccountBalance.");
        }
        return this.egovCommon.getAccountBalance(this.formatter.parse(voucherDate), Long.valueOf(accountId), amount, paymentId, accGlcodeID);
    }

    public boolean isChequeNoGenerationAuto() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting isChequeNoGenerationAuto...");
        }
        List appList = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "Cheque_no_generation_auto");
        String chequeNoGeneration = ((AppConfigValues)appList.get(0)).getValue();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed isChequeNoGenerationAuto.");
        }
        return chequeNoGeneration.equalsIgnoreCase("Y");
    }

    public boolean isRtgsNoGenerationAuto() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting isRtgsNoGenerationAuto...");
        }
        List appList = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "RTGSNO_GENERATION_AUTO");
        String chequeNoGeneration = ((AppConfigValues)appList.get(0)).getValue();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed isRtgsNoGenerationAuto.");
        }
        return chequeNoGeneration.equalsIgnoreCase("Y");
    }

    public Paymentheader createPayment(Map<String, String[]> parameters, HashMap<String, Object> headerdetails, List<HashMap<String, Object>> accountcodedetails, List<HashMap<String, Object>> subledgerdetails, Bankaccount bankaccount) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting createPayment...");
        }
        CVoucherHeader voucherHeader = this.createVoucher.createPreApprovedVoucher(headerdetails, accountcodedetails, subledgerdetails);
        Paymentheader paymentheader = this.createPaymentHeader(voucherHeader, bankaccount, parameters);
        paymentheader.getVoucherheader().getVouchermis().setSourcePath("/EGF/payment/payment-view.action?paymentid=" + paymentheader.getId());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed createPayment.");
        }
        return paymentheader;
    }

    @Transactional
    public Paymentheader createPayment(Map<String, String[]> parameters, List<PaymentBean> billList, EgBillregister billregister, WorkflowBean workflowBean) throws ApplicationRuntimeException, ValidationException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting createPayment...");
        }
        Paymentheader paymentheader = null;
        try {
            this.accountcodedetails = new ArrayList<HashMap<String, Object>>();
            this.subledgerdetails = new ArrayList<HashMap<String, Object>>();
            this.conBillIdlength = 0;
            this.getGlcodeIds();
            HashMap<String, Object> headerdetails = new HashMap<String, Object>();
            this.user = (User)this.persistenceService.find(" from User where id = ?", new Object[]{ApplicationThreadLocals.getUserId()});
            if (billList != null && billList.size() > 0 && "salary".equalsIgnoreCase(billList.get(0).getExpType())) {
                headerdetails.put("vouchername", "Salary Bill Payment");
            } else if (billList != null && billList.size() > 0 && "pension".equalsIgnoreCase(billList.get(0).getExpType())) {
                headerdetails.put("vouchername", "Pension Bill Payment");
            } else {
                headerdetails.put("vouchername", "Bill Payment");
            }
            headerdetails.put("vouchertype", "Payment");
            if (parameters.get("description") != null) {
                headerdetails.put("description", parameters.get("description")[0]);
            }
            if (parameters.get("voucherdate") != null && !parameters.get("voucherdate")[0].equals(EMPTY_STRING)) {
                headerdetails.put("voucherdate", this.formatter.parse(parameters.get("voucherdate")[0]));
            }
            if (billregister.getEgBillregistermis().getFund() != null) {
                headerdetails.put("fundcode", billregister.getEgBillregistermis().getFund().getCode());
            }
            if (parameters.get("vouchernumber") != null) {
                headerdetails.put("vouchernumber", parameters.get("vouchernumber")[0]);
            }
            if (billregister.getEgBillregistermis().getEgDepartment() != null) {
                headerdetails.put("departmentcode", billregister.getEgBillregistermis().getEgDepartment().getCode());
            }
            if (billregister.getEgBillregistermis().getFundsource() != null) {
                headerdetails.put("fundsourcecode", billregister.getEgBillregistermis().getFundsource().getCode());
            }
            if (billregister.getEgBillregistermis().getScheme() != null) {
                headerdetails.put("schemecode", billregister.getEgBillregistermis().getScheme().getCode());
            }
            if (billregister.getEgBillregistermis().getSubScheme() != null) {
                headerdetails.put("subschemecode", billregister.getEgBillregistermis().getSubScheme().getCode());
            }
            if (billregister.getEgBillregistermis().getFunctionaryid() != null) {
                headerdetails.put("functionarycode", billregister.getEgBillregistermis().getFunctionaryid().getCode());
            }
            if (billregister.getEgBillregistermis().getFunction() != null) {
                headerdetails.put("functioncode", billregister.getEgBillregistermis().getFunction().getCode());
            }
            if (billregister.getEgBillregistermis().getFieldid() != null) {
                headerdetails.put("divisionid", billregister.getEgBillregistermis().getFieldid().getId());
            }
            String[] contractorids = parameters.get("contractorIds")[0] == null || parameters.get("contractorIds")[0].equals(EMPTY_STRING) ? null : parameters.get("contractorIds")[0].split(",");
            String[] supplierids = parameters.get("supplierIds")[0] == null || parameters.get("supplierIds")[0].equals(EMPTY_STRING) ? null : parameters.get("supplierIds")[0].split(",");
            String[] salaryids = parameters.get("salaryIds")[0] == null || parameters.get("salaryIds")[0].equals(EMPTY_STRING) ? null : parameters.get("salaryIds")[0].split(",");
            String[] pensionids = parameters.get("pensionIds")[0] == null || parameters.get("pensionIds")[0].equals(EMPTY_STRING) ? null : parameters.get("pensionIds")[0].split(",");
            String[] contingencyIds = null;
            if (parameters.get("contingentIds") != null) {
                contingencyIds = parameters.get("contingentIds")[0] == null || parameters.get("contingentIds")[0].equals(EMPTY_STRING) ? null : parameters.get("contingentIds")[0].split(",");
            }
            this.miscBillList = new ArrayList<Miscbilldetail>();
            this.prepareVoucherdetails(contractorids, parameters, this.worksBillGlcodeList, billList);
            this.prepareVoucherdetails(supplierids, parameters, this.purchaseBillGlcodeList, billList);
            this.prepareVoucherdetails(contingencyIds, parameters, this.contingentBillGlcodeList, billList);
            this.prepareVoucherdetails(salaryids, parameters, this.salaryBillGlcodeList, billList);
            this.prepareVoucherdetails(pensionids, parameters, this.pensionBillGlcodeList, billList);
            HashMap<String, Object> accdetailsMap = new HashMap<String, Object>();
            Bankaccount ba = (Bankaccount)this.persistenceService.find(" from Bankaccount where id = ? ", new Object[]{Long.valueOf(parameters.get("bankaccount")[0])});
            accdetailsMap.put("glcode", ba.getChartofaccounts().getGlcode());
            accdetailsMap.put("narration", ba.getChartofaccounts().getName());
            accdetailsMap.put("debitamount", 0);
            accdetailsMap.put("creditamount", parameters.get("grandTotal")[0]);
            this.accountcodedetails.add(accdetailsMap);
            CVoucherHeader voucherHeader = this.createVoucher.createPreApprovedVoucher(headerdetails, this.accountcodedetails, this.subledgerdetails);
            paymentheader = this.createPaymentHeader(voucherHeader, ba, parameters);
            this.entityManager.flush();
            for (Miscbilldetail miscbilldetail : this.miscBillList) {
                miscbilldetail.setPayVoucherHeader(voucherHeader);
                this.miscbilldetailService.create(miscbilldetail);
            }
            paymentheader.getVoucherheader().getVouchermis().setSourcePath("/EGF/payment/payment-view.action?paymentid=" + paymentheader.getId());
            if ("Create And Approve".equalsIgnoreCase(workflowBean.getWorkFlowAction()) && voucherHeader.getState() == null) {
                paymentheader.getVoucherheader().setStatus(FinancialConstants.CREATEDVOUCHERSTATUS);
            } else {
                paymentheader = this.transitionWorkFlow(paymentheader, workflowBean);
                this.applyAuditing((AbstractAuditable)paymentheader.getState());
                this.applyAuditing((AbstractAuditable)paymentheader);
            }
            this.update(paymentheader);
            this.entityManager.flush();
        }
        catch (ValidationException e) {
            e.printStackTrace();
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("createPayment", ((ValidationError)e.getErrors().get(0)).getMessage()));
            throw new ValidationException(errors);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("createPayment", e.getMessage()));
            throw new ValidationException(errors);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed createPayment.");
        }
        return paymentheader;
    }

    protected Assignment getWorkflowInitiator(Paymentheader paymentheader) {
        Assignment wfInitiator = (Assignment)this.assignmentService.findByEmployeeAndGivenDate(paymentheader.getCreatedBy().getId(), new Date()).get(0);
        return wfInitiator;
    }

    @Transactional
    public Paymentheader transitionWorkFlow(Paymentheader paymentheader, WorkflowBean workflowBean) {
        DateTime currentDate = new DateTime();
        User user = this.securityUtils.getCurrentUser();
        Assignment userAssignment = (Assignment)this.assignmentService.findByEmployeeAndGivenDate(user.getId(), new Date()).get(0);
        Position pos = null;
        Assignment wfInitiator = null;
        if (null != paymentheader.getId()) {
            wfInitiator = this.getWorkflowInitiator(paymentheader);
        }
        if ("Reject".equalsIgnoreCase(workflowBean.getWorkFlowAction())) {
            if (wfInitiator.equals(userAssignment)) {
                paymentheader.transition(true).end().withSenderName(user.getName()).withComments(workflowBean.getApproverComments()).withDateInfo(currentDate.toDate());
            } else {
                String stateValue = "Rejected";
                paymentheader.transition(true).withSenderName(user.getName()).withComments(workflowBean.getApproverComments()).withStateValue("Rejected").withDateInfo(currentDate.toDate()).withOwner(wfInitiator.getPosition()).withNextAction("EOA Approval Pending");
            }
        } else if ("Approve".equalsIgnoreCase(workflowBean.getWorkFlowAction())) {
            WorkFlowMatrix wfmatrix = this.paymentHeaderWorkflowService.getWfMatrix(paymentheader.getStateType(), null, null, null, paymentheader.getCurrentState().getValue(), null);
            paymentheader.transition(true).withSenderName(user.getName()).withComments(workflowBean.getApproverComments()).withStateValue(wfmatrix.getCurrentDesignation() + " Approved").withDateInfo(currentDate.toDate()).withOwner(pos).withNextAction(wfmatrix.getNextAction());
            paymentheader.getVoucherheader().setStatus(FinancialConstants.CREATEDVOUCHERSTATUS);
            paymentheader.transition(true).end().withSenderName(user.getName()).withComments(workflowBean.getApproverComments()).withDateInfo(currentDate.toDate());
        } else if ("Cancel".equalsIgnoreCase(workflowBean.getWorkFlowAction())) {
            paymentheader.getVoucherheader().setStatus(FinancialConstants.CANCELLEDVOUCHERSTATUS);
            paymentheader.transition(true).end().withStateValue("Cancelled").withSenderName(user.getName()).withComments(workflowBean.getApproverComments()).withDateInfo(currentDate.toDate());
        } else {
            if (null != workflowBean.getApproverPositionId() && workflowBean.getApproverPositionId() != -1L) {
                pos = (Position)this.persistenceService.find("from Position where id=?", new Object[]{workflowBean.getApproverPositionId()});
            }
            if (null == paymentheader.getState()) {
                WorkFlowMatrix wfmatrix = this.paymentHeaderWorkflowService.getWfMatrix(paymentheader.getStateType(), null, null, null, workflowBean.getCurrentState(), null);
                paymentheader.transition().start().withSenderName(user.getName()).withComments(workflowBean.getApproverComments()).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner(pos).withNextAction(wfmatrix.getNextAction());
            } else if (paymentheader.getCurrentState().getNextAction().equalsIgnoreCase("END")) {
                paymentheader.transition(true).end().withSenderName(user.getName()).withComments(workflowBean.getApproverComments()).withDateInfo(currentDate.toDate());
            } else {
                WorkFlowMatrix wfmatrix = this.paymentHeaderWorkflowService.getWfMatrix(paymentheader.getStateType(), null, null, null, paymentheader.getCurrentState().getValue(), null);
                paymentheader.transition(true).withSenderName(user.getName()).withComments(workflowBean.getApproverComments()).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner(pos).withNextAction(wfmatrix.getNextAction());
            }
        }
        return paymentheader;
    }

    @SkipValidation
    public void getPaymentBills(Paymentheader paymentheader) {
        try {
            this.miscBillList = this.miscbilldetailService.findAllBy(" from Miscbilldetail where payVoucherHeader.id = ? order by paidto", new Object[]{paymentheader.getVoucherheader().getId()});
        }
        catch (Exception e) {
            throw new ValidationException(EMPTY_STRING, "Total Paid Amount Exceeding Net Amount For This Bill", new String[0]);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Retrived bill details fro the paymentheader");
        }
    }

    private void prepareVoucherdetails(String[] ids, Map<String, String[]> parameters, List<CChartOfAccounts> glcodeList, List<PaymentBean> billList) {
        String newPartyName;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting prepareVoucherdetails...");
        }
        EgBillregister egBillregister = null;
        CGeneralLedger gl = null;
        CGeneralLedgerDetail ledgerDetail2 = null;
        String tmp = EMPTY_STRING;
        HashMap<String, BigDecimal> tmpaccdetailsMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> tmpsublegDetailMap = new HashMap<String, BigDecimal>();
        HashMap<String, Object> accdetailsMap = null;
        HashMap<String, Object> sublegDetailMap = null;
        ArrayList<PaymentBean> tempBillList = new ArrayList<PaymentBean>();
        if (ids != null && billList != null) {
            for (PaymentBean bean : billList) {
                for (String billId : ids) {
                    if (!bean.getBillId().toString().equalsIgnoreCase(billId)) continue;
                    tempBillList.add(bean);
                }
            }
        }
        String changePartyName = parameters.get("changePartyName") == null ? "false" : parameters.get("changePartyName")[0];
        String string = newPartyName = parameters.get("newPartyName") == null ? EMPTY_STRING : parameters.get("newPartyName")[0];
        if (ids != null) {
            for (int i = 0; i < ids.length; ++i) {
                egBillregister = (EgBillregister)this.persistenceService.find("from EgBillregister where id = ? ", new Object[]{Long.valueOf(ids[i])});
                if ("true".equalsIgnoreCase(changePartyName)) {
                    this.generateMiscBillForSalary(egBillregister, ((PaymentBean)tempBillList.get(i + this.conBillIdlength)).getPaymentAmt(), ((PaymentBean)tempBillList.get(i + this.conBillIdlength)).getNetAmt(), newPartyName);
                } else {
                    this.generateMiscBill(egBillregister, ((PaymentBean)tempBillList.get(i + this.conBillIdlength)).getPaymentAmt(), ((PaymentBean)tempBillList.get(i + this.conBillIdlength)).getNetAmt());
                }
                gl = this.getPayableAccount(ids[i], glcodeList, "getGeneralLedger");
                if (gl == null) {
                    throw new ValidationException("Voucher is created with invalid netpayble code so payment is not allowed for this bill ", "Voucher is created with invalid netpayble code so payment is not allowed for this bill", new String[0]);
                }
                tmp = gl.getGlcodeId().getGlcode() + DELIMETER + gl.getGlcodeId().getName();
                if (tmpaccdetailsMap.get(tmp) == null) {
                    tmpaccdetailsMap.put(tmp, ((PaymentBean)tempBillList.get(i + this.conBillIdlength)).getPaymentAmt());
                } else {
                    tmpaccdetailsMap.put(tmp, ((BigDecimal)tmpaccdetailsMap.get(tmp)).add(((PaymentBean)tempBillList.get(i + this.conBillIdlength)).getPaymentAmt()));
                }
                if (gl.getGeneralLedgerDetails().size() > 1 && ((PaymentBean)tempBillList.get(i + this.conBillIdlength)).getPaymentAmt().compareTo(BigDecimal.valueOf(gl.getCreditAmount())) != 0) {
                    throw new ValidationException(Arrays.asList(new ValidationError("partial.payment.not.allowed.for", "Partial payment not allowed for " + ((PaymentBean)tempBillList.get(i + this.conBillIdlength)).getBillNumber())));
                }
                for (CGeneralLedgerDetail ledgerDetail2 : gl.getGeneralLedgerDetails()) {
                    tmp = "Salary".equalsIgnoreCase(((PaymentBean)tempBillList.get(i + this.conBillIdlength)).getExpType()) ? gl.getId() + DELIMETER + gl.getGlcodeId().getGlcode() + DELIMETER + ledgerDetail2.getDetailTypeId().getId() + DELIMETER + ledgerDetail2.getDetailKeyId() : gl.getGlcodeId().getGlcode() + DELIMETER + ledgerDetail2.getDetailTypeId().getId() + DELIMETER + ledgerDetail2.getDetailKeyId();
                    if (tmpsublegDetailMap.get(tmp) == null) {
                        if (gl.getGeneralLedgerDetails().size() > 1 && ((PaymentBean)tempBillList.get(i + this.conBillIdlength)).getPaymentAmt().compareTo(BigDecimal.valueOf(gl.getCreditAmount())) == 0) {
                            tmpsublegDetailMap.put(tmp, ledgerDetail2.getAmount());
                            continue;
                        }
                        tmpsublegDetailMap.put(tmp, ((PaymentBean)tempBillList.get(i + this.conBillIdlength)).getPaymentAmt());
                        continue;
                    }
                    if ("Expense".equalsIgnoreCase(((PaymentBean)tempBillList.get(i + this.conBillIdlength)).getExpType())) {
                        tmpsublegDetailMap.put(tmp, ((BigDecimal)tmpsublegDetailMap.get(tmp)).add(ledgerDetail2.getAmount()));
                        continue;
                    }
                    if (gl.getGeneralLedgerDetails().size() > 1 && ((PaymentBean)tempBillList.get(i + this.conBillIdlength)).getPaymentAmt().compareTo(BigDecimal.valueOf(gl.getCreditAmount())) == 0) {
                        tmpsublegDetailMap.put(tmp, ((BigDecimal)tmpsublegDetailMap.get(tmp)).add(ledgerDetail2.getAmount()));
                        continue;
                    }
                    tmpsublegDetailMap.put(tmp, ((BigDecimal)tmpsublegDetailMap.get(tmp)).add(((PaymentBean)tempBillList.get(i + this.conBillIdlength)).getPaymentAmt()));
                }
            }
        }
        Iterator conIterator = tmpaccdetailsMap.keySet().iterator();
        String key = EMPTY_STRING;
        while (conIterator.hasNext()) {
            key = conIterator.next().toString();
            accdetailsMap = new HashMap<String, Object>();
            accdetailsMap.put("glcode", key.split(DELIMETER)[0]);
            accdetailsMap.put("narration", key.split(DELIMETER)[1]);
            accdetailsMap.put("debitamount", tmpaccdetailsMap.get(key));
            accdetailsMap.put("creditamount", 0);
            this.accountcodedetails.add(accdetailsMap);
        }
        conIterator = tmpsublegDetailMap.keySet().iterator();
        while (conIterator.hasNext()) {
            key = conIterator.next().toString();
            sublegDetailMap = new HashMap<String, Object>();
            if (key.split(DELIMETER).length == 4) {
                sublegDetailMap.put("glcode", key.split(DELIMETER)[1]);
                sublegDetailMap.put("detailtypeid", key.split(DELIMETER)[2]);
                sublegDetailMap.put("detailkeyid", key.split(DELIMETER)[3]);
            } else {
                sublegDetailMap.put("glcode", key.split(DELIMETER)[0]);
                sublegDetailMap.put("detailtypeid", key.split(DELIMETER)[1]);
                sublegDetailMap.put("detailkeyid", key.split(DELIMETER)[2]);
            }
            sublegDetailMap.put("debitamount", tmpsublegDetailMap.get(key));
            sublegDetailMap.put("creditamount", BigDecimal.valueOf(0L));
            this.subledgerdetails.add(sublegDetailMap);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed prepareVoucherdetails.");
        }
    }

    protected Paymentheader createPaymentHeader(CVoucherHeader voucherHeader, Bankaccount ba, Map<String, String[]> parameters) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting createPaymentHeader...");
        }
        Paymentheader paymentheader = new Paymentheader();
        paymentheader.setType(parameters.get("paymentMode")[0]);
        paymentheader.setVoucherheader(voucherHeader);
        paymentheader.setBankaccount(ba);
        paymentheader.setPaymentAmount(BigDecimal.valueOf(Double.valueOf(parameters.get("grandTotal")[0])));
        this.applyAuditing((AbstractAuditable)paymentheader);
        this.persist(paymentheader);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed createPaymentHeader.");
        }
        return paymentheader;
    }

    @Transactional
    protected void generateMiscBill(EgBillregister egBillregister, BigDecimal paidAmt, BigDecimal passedAmt) {
        BigDecimal sum;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting generateMiscBill...");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Verifying total paid amount generateMiscBill...");
        }
        if ((sum = (BigDecimal)this.persistenceService.find("select sum(paidamount) from Miscbilldetail where billVoucherHeader=? and payVoucherHeader.status not in (1,2,4)", new Object[]{egBillregister.getEgBillregistermis().getVoucherHeader()})) != null) {
            egBillregister.getPassedamount().subtract(sum);
            if (egBillregister.getPassedamount().compareTo(sum) <= 0) {
                String errorMsg = " Canot continue payment as bill " + egBillregister.getBillnumber() + " is fully paid";
                throw new ValidationException(Arrays.asList(new ValidationError(errorMsg, errorMsg)));
            }
        }
        Miscbilldetail miscbilldetail = new Miscbilldetail();
        miscbilldetail.setBillnumber(egBillregister.getBillnumber());
        miscbilldetail.setBilldate(egBillregister.getBilldate());
        miscbilldetail.setBillamount(egBillregister.getBillamount());
        miscbilldetail.setPassedamount(passedAmt);
        miscbilldetail.setPaidamount(paidAmt);
        miscbilldetail.setPaidby(this.user);
        miscbilldetail.setPaidto(egBillregister.getEgBillregistermis().getPayto().trim());
        miscbilldetail.setBillVoucherHeader(egBillregister.getEgBillregistermis().getVoucherHeader());
        this.miscBillList.add(miscbilldetail);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed generateMiscBill.");
        }
    }

    protected void generateMiscBillForSalary(EgBillregister egBillregister, BigDecimal paidAmt, BigDecimal passedAmt, String newPartyName) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting generateMiscBillForSalary...");
        }
        Miscbilldetail miscbilldetail = new Miscbilldetail();
        miscbilldetail.setBillnumber(egBillregister.getBillnumber());
        miscbilldetail.setBilldate(egBillregister.getBilldate());
        miscbilldetail.setBillamount(egBillregister.getBillamount());
        miscbilldetail.setPassedamount(passedAmt);
        miscbilldetail.setPaidamount(paidAmt);
        miscbilldetail.setPaidby(this.user);
        miscbilldetail.setPaidto(newPartyName.trim());
        miscbilldetail.setBillVoucherHeader(egBillregister.getEgBillregistermis().getVoucherHeader());
        this.miscBillList.add(miscbilldetail);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed generateMiscBillForSalary.");
        }
    }

    public Paymentheader updatePayment(Map<String, String[]> parameters, List<PaymentBean> billList, Paymentheader payheader) throws ApplicationRuntimeException, ValidationException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting updatePayment...");
        }
        Paymentheader paymentheader = null;
        try {
            this.miscBillList = new ArrayList<Miscbilldetail>();
            this.user = (User)this.persistenceService.find(" from User where id = ?", new Object[]{ApplicationThreadLocals.getUserId()});
            Bankaccount ba = (Bankaccount)this.persistenceService.find("from Bankaccount where id=?", new Object[]{payheader.getBankaccount().getId()});
            paymentheader = (Paymentheader)this.persistenceService.find(" from Paymentheader where id=? ", new Object[]{payheader.getId()});
            this.deleteMiscBill(paymentheader.getVoucherheader().getId());
            CVoucherHeader voucher = this.updateVoucher(parameters, billList, ba, payheader);
            paymentheader.setPaymentAmount(new BigDecimal(parameters.get("grandTotal")[0]));
            paymentheader.setType(payheader.getType());
            paymentheader.setBankaccount(ba);
            paymentheader.setVoucherheader(voucher);
            this.update(paymentheader);
            for (Miscbilldetail miscbilldetail : this.miscBillList) {
                miscbilldetail.setPayVoucherHeader(paymentheader.getVoucherheader());
                this.miscbilldetailService.create(miscbilldetail);
            }
        }
        catch (ValidationException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage());
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("createPayment", e.getMessage()));
            throw new ValidationException(errors);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed updatePayment.");
        }
        return paymentheader;
    }

    private CVoucherHeader updateVoucher(Map<String, String[]> parameters, List<PaymentBean> billList, Bankaccount ba, Paymentheader paymentheader) throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting updateVoucher...");
        }
        CVoucherHeader existingVH = (CVoucherHeader)this.persistenceService.find(" from CVoucherHeader where id=?", new Object[]{paymentheader.getVoucherheader().getId()});
        this.createVoucher.deleteVoucherdetailAndGL(existingVH);
        this.updateVoucherHeader(parameters, existingVH, paymentheader.getVoucherheader());
        this.prepareVoucherDetailsForModify(billList, parameters, ba);
        List<Transaxtion> transactions = this.createVoucher.createTransaction(null, this.accountcodedetails, this.subledgerdetails, existingVH);
        this.getSession().flush();
        Transaxtion[] txnList = new Transaxtion[transactions.size()];
        txnList = transactions.toArray(txnList);
        if (!this.chartOfAccounts.postTransaxtions(txnList, this.sdf.format(existingVH.getVoucherDate()))) {
            throw new ValidationException(Arrays.asList(new ValidationError(EXCEPTION_WHILE_SAVING_DATA, TRANSACTION_FAILED)));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed updateVoucher.");
        }
        return existingVH;
    }

    private void updateVoucherHeader(Map<String, String[]> parameters, CVoucherHeader existingVH, CVoucherHeader voucherHeader) throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting updateVoucherHeader...");
        }
        String vNumGenMode = this.voucherTypeForULB.readVoucherTypes("Payment");
        String autoVoucherType = FinancialConstants.PAYMENT_VOUCHERNO_TYPE;
        String manualVoucherNumber = EMPTY_STRING;
        if (parameters.get("voucherNumberSuffix") != null) {
            manualVoucherNumber = parameters.get("voucherNumberSuffix")[0];
        }
        voucherHeader.setFundId(existingVH.getFundId());
        this.voucherService.getUpdatedVNumCGVN(existingVH, voucherHeader, existingVH.getType());
        String vType = existingVH.getVoucherNumber().substring(0, Integer.parseInt(FinancialConstants.VOUCHERNO_TYPE_LENGTH));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Voucher type  : " + vType));
        }
        String eg_voucher = this.eGovernCommon.getEg_Voucher(vType, existingVH.getFiscalPeriodId().toString());
        for (int i = eg_voucher.length(); i < 5; ++i) {
            eg_voucher = "0" + eg_voucher;
        }
        existingVH.setDescription(voucherHeader.getDescription());
        existingVH.setVoucherDate(voucherHeader.getVoucherDate());
        existingVH.setCgvn(vType + eg_voucher);
        existingVH.setLastModifiedDate(new Date());
        existingVH.setLastModifiedBy(this.user);
        this.persistenceService.update((Object)existingVH);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed updateVoucherHeader.");
        }
    }

    private void prepareVoucherDetailsForModify(List<PaymentBean> paymentBillList, Map<String, String[]> parameters, Bankaccount ba) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting prepareVoucherDetailsForModify...");
        }
        CGeneralLedger gl = null;
        EgBillregister br = null;
        CGeneralLedgerDetail ledgerDetail2 = null;
        this.getGlcodeIds();
        String tmp = EMPTY_STRING;
        HashMap<String, BigDecimal> tmpaccdetailsMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> tmpsublegDetailMap = new HashMap<String, BigDecimal>();
        HashMap<String, Object> accdetailsMap = null;
        HashMap<String, String> sublegDetailMap = null;
        this.accountcodedetails = new ArrayList<HashMap<String, Object>>();
        this.subledgerdetails = new ArrayList<HashMap<String, Object>>();
        String changePartyName = parameters.get("changePartyName") == null ? "false" : parameters.get("changePartyName")[0];
        String newPartyName = parameters.get("newPartyName") == null ? EMPTY_STRING : parameters.get("newPartyName")[0];
        for (PaymentBean bean : paymentBillList) {
            if (bean == null) continue;
            br = (EgBillregister)this.persistenceService.find(" from EgBillregister br where br.egBillregistermis.voucherHeader.id=?", new Object[]{bean.getCsBillId()});
            if ("true".equalsIgnoreCase(changePartyName)) {
                this.prepareMiscBillForSalary(bean, br, newPartyName);
            } else {
                this.prepareMiscBill(bean, br);
            }
            gl = br.getExpendituretype().equals("Works") ? this.getPayableAccount(bean.getCsBillId().toString(), this.worksBillGlcodeList, "getGeneralLedgerByVoucherHeaderId") : (br.getExpendituretype().equals("Purchase") ? this.getPayableAccount(bean.getCsBillId().toString(), this.purchaseBillGlcodeList, "getGeneralLedgerByVoucherHeaderId") : this.getPayableAccount(bean.getCsBillId().toString(), this.contingentBillGlcodeList, "getGeneralLedgerByVoucherHeaderId"));
            tmp = gl.getGlcodeId().getGlcode() + DELIMETER + gl.getGlcodeId().getName();
            if (tmpaccdetailsMap.get(tmp) == null) {
                tmpaccdetailsMap.put(tmp, bean.getPaymentAmt());
            } else {
                tmpaccdetailsMap.put(tmp, ((BigDecimal)tmpaccdetailsMap.get(tmp)).add(bean.getPaymentAmt()));
            }
            for (CGeneralLedgerDetail ledgerDetail2 : gl.getGeneralLedgerDetails()) {
                tmp = gl.getGlcodeId().getGlcode() + DELIMETER + ledgerDetail2.getDetailTypeId() + DELIMETER + ledgerDetail2.getDetailKeyId();
                if (tmpsublegDetailMap.get(tmp) == null) {
                    tmpsublegDetailMap.put(tmp, bean.getPaymentAmt());
                    continue;
                }
                tmpsublegDetailMap.put(tmp, ((BigDecimal)tmpsublegDetailMap.get(tmp)).add(bean.getPaymentAmt()));
            }
        }
        Iterator conIterator = tmpaccdetailsMap.keySet().iterator();
        String key = EMPTY_STRING;
        while (conIterator.hasNext()) {
            key = conIterator.next().toString();
            accdetailsMap = new HashMap<String, Object>();
            accdetailsMap.put("glcode", key.split(DELIMETER)[0]);
            accdetailsMap.put("narration", key.split(DELIMETER)[1]);
            accdetailsMap.put("debitamount", tmpaccdetailsMap.get(key));
            accdetailsMap.put("creditamount", 0);
            this.accountcodedetails.add(accdetailsMap);
        }
        conIterator = tmpsublegDetailMap.keySet().iterator();
        while (conIterator.hasNext()) {
            key = conIterator.next().toString();
            sublegDetailMap = new HashMap<String, String>();
            sublegDetailMap.put("glcode", key.split(DELIMETER)[0]);
            sublegDetailMap.put("detailtypeid", key.split(DELIMETER)[1]);
            sublegDetailMap.put("detailkeyid", key.split(DELIMETER)[2]);
            sublegDetailMap.put("debitamount", (String)tmpsublegDetailMap.get(key));
            this.subledgerdetails.add(sublegDetailMap);
        }
        accdetailsMap = new HashMap();
        accdetailsMap.put("glcode", ba.getChartofaccounts().getGlcode());
        accdetailsMap.put("narration", ba.getChartofaccounts().getName());
        accdetailsMap.put("debitamount", 0);
        accdetailsMap.put("creditamount", parameters.get("grandTotal")[0]);
        this.accountcodedetails.add(accdetailsMap);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed prepareVoucherDetailsForModify.");
        }
    }

    protected void prepareMiscBill(PaymentBean bean, EgBillregister br) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting prepareMiscBill...");
        }
        Miscbilldetail miscbilldetail = new Miscbilldetail();
        miscbilldetail.setBillnumber(bean.getBillNumber());
        miscbilldetail.setBilldate(bean.getBillDate());
        miscbilldetail.setBillamount(bean.getNetAmt());
        miscbilldetail.setPassedamount(bean.getPassedAmt());
        miscbilldetail.setPaidamount(bean.getPaymentAmt());
        miscbilldetail.setPaidby(this.user);
        miscbilldetail.setPaidto(bean.getPayTo());
        miscbilldetail.setBillVoucherHeader(br.getEgBillregistermis().getVoucherHeader());
        this.miscBillList.add(miscbilldetail);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed prepareMiscBill.");
        }
    }

    protected void prepareMiscBillForSalary(PaymentBean bean, EgBillregister br, String newPartyName) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting prepareMiscBillForSalary...");
        }
        Miscbilldetail miscbilldetail = new Miscbilldetail();
        miscbilldetail.setBillnumber(bean.getBillNumber());
        miscbilldetail.setBilldate(bean.getBillDate());
        miscbilldetail.setBillamount(bean.getNetAmt());
        miscbilldetail.setPassedamount(bean.getPassedAmt());
        miscbilldetail.setPaidamount(bean.getPaymentAmt());
        miscbilldetail.setPaidby(this.user);
        miscbilldetail.setPaidto(newPartyName);
        miscbilldetail.setBillVoucherHeader(br.getEgBillregistermis().getVoucherHeader());
        this.miscBillList.add(miscbilldetail);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed prepareMiscBillForSalary.");
        }
    }

    protected void deleteMiscBill(Long payVHId) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting deleteMiscBill...");
        }
        try {
            SQLQuery st = this.getSession().createSQLQuery("delete from miscbilldetail where PAYVHID=" + payVHId);
            st.executeUpdate();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Inside exception deleteMiscBill" + e.getMessage()));
            throw new ApplicationRuntimeException(e.getMessage());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed deleteMiscBill.");
        }
    }

    private CGeneralLedger getPayableAccount(String id, List<CChartOfAccounts> glcodeIdList, String namedQuery) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Inside getPayableAccount...");
        }
        return (CGeneralLedger)this.persistenceService.findByNamedQuery(namedQuery, new Object[]{Long.valueOf(id), glcodeIdList});
    }

    public void getGlcodeIds() throws ApplicationRuntimeException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting getGlcodeIds...");
        }
        try {
            this.worksBillGlcodeList = this.populateGlCodeIds("worksBillPurposeIds");
            this.purchaseBillGlcodeList = this.populateGlCodeIds("purchaseBillPurposeIds");
            this.salaryBillGlcodeList = this.populateGlCodeIds("salaryBillPurposeIds");
            this.pensionBillGlcodeList = this.populateGlCodeIds("pensionBillPurposeIds");
            List appList = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "contingencyBillPurposeIds");
            this.cBillGlcodeIdList = new ArrayList<BigDecimal>();
            if (appList != null && appList.size() > 0) {
                Integer[] iPurposeIds = new Integer[appList.size()];
                int z = 0;
                for (AppConfigValues appConfigValues : appList) {
                    iPurposeIds[z] = Integer.parseInt(appConfigValues.getValue());
                    ++z;
                }
                List coaList = this.coaDAO.getAccountCodeByListOfPurposeId(iPurposeIds);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Size contingentBillGlcodeList" + coaList.size()));
                }
                this.contingentBillGlcodeList = coaList;
                for (CChartOfAccounts coa1 : coaList) {
                    this.cBillGlcodeIdList.add(BigDecimal.valueOf(coa1.getId()));
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage());
            throw new ApplicationRuntimeException(e.getMessage());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed getGlcodeIds.");
        }
    }

    private List<CChartOfAccounts> populateGlCodeIds(String appConfigKey) throws ApplicationException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting populateGlCodeIds...");
        }
        ArrayList<CChartOfAccounts> glCodeList = new ArrayList<CChartOfAccounts>();
        List appList = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", appConfigKey);
        String purposeids = ((AppConfigValues)appList.get(0)).getValue();
        if (purposeids != null && !purposeids.equals(EMPTY_STRING)) {
            String[] purposeIds;
            for (String purposeId : purposeIds = purposeids.split(",")) {
                List coaList = this.coaDAO.getAccountCodeByPurpose(Integer.valueOf(Integer.parseInt(purposeId)));
                for (CChartOfAccounts coa1 : coaList) {
                    glCodeList.add(coa1);
                }
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed populateGlCodeIds.");
        }
        return glCodeList;
    }

    public Map<Long, BigDecimal> getDeductionAmt(List<EgBillregister> billList, String type) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting getDeductionAmt...");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Calling getDeductionAmt..................................$$$$$$$$$$$$$$$$$$$$$$ ");
        }
        HashMap<String, List<CChartOfAccounts>> glCodeList = new HashMap<String, List<CChartOfAccounts>>();
        glCodeList.put("Works", this.worksBillGlcodeList);
        glCodeList.put("Purchase", this.purchaseBillGlcodeList);
        glCodeList.put("Expense", this.contingentBillGlcodeList);
        glCodeList.put("Salary", this.salaryBillGlcodeList);
        glCodeList.put("Pension", this.pensionBillGlcodeList);
        HashMap<Long, BigDecimal> deductionAmtMap = new HashMap<Long, BigDecimal>();
        List list = (List)glCodeList.get(type);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Calling getDeductionAmt..................................$$$$$$$$$$$$$$$$$$$$$$ " + list.size()));
        }
        for (CChartOfAccounts coa : list) {
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug((Object)("#################################" + coa.getGlcode() + ":::::" + coa.getPurposeId()));
        }
        this.populateDeductionData(billList, deductionAmtMap, type, (List)glCodeList.get(type));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed getDeductionAmt.");
        }
        return deductionAmtMap;
    }

    private void populateDeductionData(List<EgBillregister> billList, Map<Long, BigDecimal> deductionAmtMap, String type, List<CChartOfAccounts> glcodeList) {
        List<Object[]> dedList;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting populateDeductionData...");
        }
        ArrayList<Long> billIds = new ArrayList<Long>();
        if (billList != null && billList.size() != 0) {
            for (EgBillregister row : billList) {
                billIds.add(row.getId());
            }
        }
        if (billList != null && billList.size() != 0 && (dedList = this.getDeductionList(type, glcodeList)) != null && dedList.size() != 0) {
            for (Object[] obj : dedList) {
                BigInteger id = (BigInteger)obj[0];
                if (!billIds.contains(id.longValue())) continue;
                deductionAmtMap.put(id.longValue(), obj[1] == null ? BigDecimal.ZERO : (BigDecimal)obj[1]);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed populateDeductionData.");
        }
    }

    private List<Object[]> getDeductionList(String expendituretype, List<CChartOfAccounts> glcodeList) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting getDeductionList...");
        }
        String mainquery = "select bill.id as id, sum (gl.creditAmount) from eg_Billregister bill,eg_billregistermis billmis left join voucherheader vh on vh.id=billmis.voucherheaderid left join (select sum(paidamount) as paidamount,billvhid as billvhid from miscbilldetail misc,voucherheader vh1 where  misc.payvhid=vh1.id and vh1.status not in (1,2,4) group by billvhid) misc on misc.billvhid=vh.id,GeneralLedger gl where billmis.voucherheaderid is not null and billmis.billid=bill.id and vh.status=0 and bill.expendituretype='" + expendituretype + "' and gl.voucherHeaderId=billmis.voucherHeaderid and gl.glcodeId not in(:glCodeList) and gl.creditAmount>0 and (misc.billvhid is null or (bill.passedamount > misc.paidamount)) group by bill.id";
        List dedList = this.getSession().createSQLQuery(mainquery).setParameterList("glCodeList", glcodeList).list();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed getDeductionList.");
        }
        return dedList;
    }

    private List<Object[]> getEarlierPaymentAmtList(String expendituretype) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting getEarlierPaymentAmtList...");
        }
        String mainquery = "select bill.id as id,misc.paidamount from eg_Billregister bill,eg_billregistermis billmis left join voucherheader vh on vh.id=billmis.voucherheaderid left join (select sum(paidamount) as paidamount,billvhid as billvhid from miscbilldetail  misc,voucherheader vh where  misc.payvhid=vh.id and vh.status not in (1,2,4)    group by billvhid) misc on misc.billvhid=vh.id where billmis.voucherheaderid is not null and billmis.billid=bill.id and vh.status=0 and bill.expendituretype='" + expendituretype + "' and (bill.passedamount > misc.paidamount)";
        List dedList = this.getSession().createSQLQuery(mainquery).list();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed getEarlierPaymentAmtList.");
        }
        return dedList;
    }

    public Map<Long, BigDecimal> getEarlierPaymentAmt(List<EgBillregister> billList, String type) {
        List<Object[]> paidList;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting getEarlierPaymentAmt...");
        }
        HashMap<Long, BigDecimal> paymentAmtMap = new HashMap<Long, BigDecimal>();
        ArrayList<Long> billIds = new ArrayList<Long>();
        if (billList != null && billList.size() != 0) {
            for (EgBillregister row : billList) {
                billIds.add(row.getId());
            }
        }
        if (billList != null && billList.size() != 0 && (paidList = this.getEarlierPaymentAmtList(type)) != null && paidList.size() != 0) {
            for (Object[] obj : paidList) {
                long id = ((BigInteger)obj[0]).longValue();
                if (!billIds.contains(id)) continue;
                paymentAmtMap.put(((BigInteger)obj[0]).longValue(), obj[1] == null ? BigDecimal.ZERO : (BigDecimal)obj[1]);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed getEarlierPaymentAmt.");
        }
        return paymentAmtMap;
    }

    private void validateEntity(EntityType entity) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting validateEntity...");
        }
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (StringUtils.isBlank((String)entity.getPanno()) || StringUtils.isBlank((String)entity.getBankname()) || StringUtils.isBlank((String)entity.getBankaccount()) || StringUtils.isBlank((String)entity.getIfsccode())) {
            LOGGER.error((Object)("BankAccount,IFSC Code, Pan number is mandatory for RTGS Payment for " + entity.getName()));
            errors.add(new ValidationError("paymentMode", "BankName, BankAccount,IFSC Code, Pan number is mandatory for RTGS Payment for " + entity.getName()));
            throw new ValidationException(errors);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed validateEntity.");
        }
    }

    private void validateCBill(PaymentBean bean, String mode) throws ValidationException, ApplicationException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting validateCBill...");
        }
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        EntityType entity = null;
        List list = null;
        list = mode.equalsIgnoreCase("Create") ? this.persistenceService.findAllByNamedQuery("getPayeeDetailsForPayableCode", new Object[]{bean.getBillId(), this.cBillGlcodeIdList}) : this.persistenceService.findAllByNamedQuery("getPayeeDetailsForPayableCodeForVoucher", new Object[]{bean.getBillId(), this.contingentBillGlcodeList});
        if (list == null || list.size() == 0) {
            list = mode.equalsIgnoreCase("Create") ? this.persistenceService.findAllByNamedQuery("getPayeeDetailsForDebitCode", new Object[]{bean.getBillId()}) : this.persistenceService.findAllByNamedQuery("getPayeeDetailsForDebitCodeForVoucher", new Object[]{bean.getBillId()});
            if (list == null || list.size() == 0) {
                LOGGER.error((Object)("Sub ledger details are missing for this bill id ->" + bean.getBillId()));
                errors.add(new ValidationError("entityType", "Sub ledger details are missing for this bill number : " + bean.getBillNumber()));
                throw new ValidationException(errors);
            }
            for (Object[] obj : list) {
                entity = this.getEntity(Integer.valueOf(obj[0].toString()), Long.valueOf(obj[1].toString()));
                this.validateEntity(entity);
            }
        } else {
            for (Object[] obj : list) {
                entity = this.getEntity(Integer.valueOf(obj[0].toString()), Long.valueOf(obj[1].toString()));
                this.validateEntity(entity);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed validateCBill.");
        }
    }

    public void validateForRTGSPayment(List<PaymentBean> billList, String type) throws ValidationException, ApplicationException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting validateForRTGSPayment...");
        }
        this.getGlcodeIds();
        EntityType entity = null;
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        Object[] obj = null;
        if (billList != null) {
            for (PaymentBean bean : billList) {
                if (bean == null) continue;
                if (type.equals("Contractor")) {
                    obj = (Object[])this.persistenceService.findByNamedQuery("getGlDetailForPayableCode", new Object[]{bean.getBillId(), this.worksBillGlcodeList});
                } else if (type.equals("Supplier")) {
                    obj = (Object[])this.persistenceService.findByNamedQuery("getGlDetailForPayableCode", new Object[]{bean.getBillId(), this.purchaseBillGlcodeList});
                } else if (type.equals("Expense")) {
                    this.validateCBill(bean, "Create");
                }
                if (!type.equals("Contractor") && !type.equals("Supplier")) continue;
                if (obj == null) {
                    LOGGER.error((Object)("Sub ledger details are missing for this bill id ->" + bean.getBillId()));
                    errors.add(new ValidationError("entityType", "Sub ledger details are missing for this bill number : " + bean.getBillNumber()));
                    throw new ValidationException(errors);
                }
                entity = this.getEntity(Integer.valueOf(obj[0].toString()), (Serializable)obj[1]);
                if (type.equals("Supplier") && (StringUtils.isBlank((String)entity.getTinno()) || StringUtils.isBlank((String)entity.getBankname()) || StringUtils.isBlank((String)entity.getBankaccount()) || StringUtils.isBlank((String)entity.getIfsccode()))) {
                    LOGGER.error((Object)("BankAccount,IFSC Code, Tin number is mandatory for RTGS Payment for " + entity.getName()));
                    errors.add(new ValidationError("paymentMode", "BankName, BankAccount,IFSC Code, Tin number is mandatory for RTGS Payment for " + entity.getName()));
                    throw new ValidationException(errors);
                }
                this.validateEntity(entity);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed validateForRTGSPayment.");
        }
    }

    public void validateForContractorSupplierDetailCodes(List<PaymentBean> billList, String type) throws ValidationException, ApplicationException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting validateForRTGSPayment...");
        }
        this.getGlcodeIds();
        EntityType entity = null;
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        Object[] obj = null;
        if (billList != null) {
            for (PaymentBean bean : billList) {
                if (bean == null) continue;
                if (type.equals("Contractor")) {
                    obj = (Object[])this.persistenceService.findByNamedQuery("getGlDetailForPayableCode", new Object[]{bean.getBillId(), this.worksBillGlcodeList});
                } else if (type.equals("Supplier")) {
                    obj = (Object[])this.persistenceService.findByNamedQuery("getGlDetailForPayableCode", new Object[]{bean.getBillId(), this.purchaseBillGlcodeList});
                } else if (type.equals("Expense")) {
                    this.validateCBill(bean, "Create");
                }
                if (!type.equals("Contractor") && !type.equals("Supplier")) continue;
                if (obj == null) {
                    LOGGER.error((Object)("Sub ledger details are missing for this bill id ->" + bean.getBillId()));
                    errors.add(new ValidationError("entityType", "Sub ledger details are missing for this bill number : " + bean.getBillNumber()));
                    throw new ValidationException(errors);
                }
                entity = this.getEntity(Integer.valueOf(obj[0].toString()), (Serializable)obj[1]);
                if (type.equals("Supplier") && (StringUtils.isBlank((String)entity.getTinno()) || StringUtils.isBlank((String)entity.getBankname()) || StringUtils.isBlank((String)entity.getBankaccount()) || StringUtils.isBlank((String)entity.getIfsccode()))) {
                    LOGGER.error((Object)("BankAccount,IFSC Code, Tin number is mandatory for RTGS Payment for " + entity.getName()));
                    errors.add(new ValidationError("paymentMode", "BankName, BankAccount,IFSC Code, Tin number is mandatory for RTGS Payment for " + entity.getName()));
                    throw new ValidationException(errors);
                }
                this.validateEntity(entity);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed validateForRTGSPayment.");
        }
    }

    public void validatePaymentForRTGSAssignment(List<ChequeAssignment> billList, String type) throws ValidationException, ApplicationException {
        Long billId = null;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting validateForRTGSPayment...");
        }
        this.getGlcodeIds();
        EntityType entity = null;
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        Object[] obj = null;
        if (billList != null) {
            for (ChequeAssignment bean : billList) {
                billId = bean.getBillId().longValue();
                if (bean == null) continue;
                if (type.equals("Contractor")) {
                    obj = (Object[])this.persistenceService.findByNamedQuery("getGlDetailForPayableCode", new Object[]{billId, this.worksBillGlcodeList});
                } else if (type.equals("Supplier")) {
                    obj = (Object[])this.persistenceService.findByNamedQuery("getGlDetailForPayableCode", new Object[]{billId, this.purchaseBillGlcodeList});
                }
                if (!type.equals("Contractor") && !type.equals("Supplier")) continue;
                if (obj == null) {
                    LOGGER.error((Object)("Sub ledger details are missing for this bill id ->" + billId));
                    errors.add(new ValidationError("entityType", "Sub ledger details are missing for this bill number : " + bean.getBillNumber()));
                    throw new ValidationException(errors);
                }
                entity = this.getEntity(Integer.valueOf(obj[0].toString()), (Serializable)obj[1]);
                if (type.equals("Supplier") && (StringUtils.isBlank((String)entity.getTinno()) || StringUtils.isBlank((String)entity.getBankname()) || StringUtils.isBlank((String)entity.getBankaccount()) || StringUtils.isBlank((String)entity.getIfsccode()))) {
                    LOGGER.error((Object)("BankAccount,IFSC Code, Tin number is mandatory for RTGS Payment for " + entity.getName()));
                    errors.add(new ValidationError("paymentMode", "BankName, BankAccount,IFSC Code, Tin number is mandatory for RTGS Assignment for " + bean.getVoucherNumber() + "\\n Party Name " + entity.getName()));
                    throw new ValidationException(errors);
                }
                if (!StringUtils.isBlank((String)entity.getPanno()) && !StringUtils.isBlank((String)entity.getBankname()) && !StringUtils.isBlank((String)entity.getBankaccount()) && !StringUtils.isBlank((String)entity.getIfsccode())) continue;
                LOGGER.error((Object)("Mandatory details for RTGS Assignment for " + bean.getVoucherNumber() + " for Party Name " + entity.getName() + " is missing missing"));
                errors.add(new ValidationError("paymentMode", "Mandatory details for RTGS Assignment for " + bean.getVoucherNumber() + " for Party Name " + entity.getName() + " is missing missing"));
                throw new ValidationException(errors);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed validateForRTGSPayment.");
        }
    }

    public boolean isAnyItemSelected(List<PaymentBean> billList, String paymentMd, Date restrictedDate) throws ValidationException {
        int billDateFlag = 0;
        if (billList != null) {
            for (PaymentBean bean : billList) {
                if (bean == null || bean.getBillDate().compareTo(restrictedDate) <= 0 || paymentMd.equalsIgnoreCase("RTGS")) continue;
                ++billDateFlag;
            }
        }
        return billDateFlag > 0;
    }

    public boolean isRestrictPaymentToOnlyRtgsForContractor() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting isRestrictPaymentToOnlyRtgsForContractor...");
        }
        List appList = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "RESTRICT_PAYEMENT_TOONLY_RTGS_FOR_CONTRACTOR_CODES");
        String restrictingPayment = ((AppConfigValues)appList.get(0)).getValue();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed isRestrictPaymentToOnlyRtgsForContractor.");
        }
        return restrictingPayment.equalsIgnoreCase("Y");
    }

    public boolean CheckForContractorSubledgerCodes(List<PaymentBean> billList, Date restrictedDate) throws NumberFormatException, ApplicationException {
        int billDateFlag = 0;
        String query = "Select gld.detailkeyid from generalledger gl,voucherheader vh, generalledgerdetail gld where gl.id= gld.generalledgerid and vh.id= gl.voucherheaderid and gl.creditamount>0 and gld.detailtypeid in (select id from accountdetailtype t where t.name in   ('Creditor','contractor') ) and vh.vouchernumber=?";
        if (null != billList && !billList.isEmpty()) {
            for (PaymentBean bean : billList) {
                if (bean == null) continue;
                SQLQuery createSQLQuery = this.getSession().createSQLQuery("Select gld.detailkeyid from generalledger gl,voucherheader vh, generalledgerdetail gld where gl.id= gld.generalledgerid and vh.id= gl.voucherheaderid and gl.creditamount>0 and gld.detailtypeid in (select id from accountdetailtype t where t.name in   ('Creditor','contractor') ) and vh.vouchernumber=?");
                createSQLQuery.setString(0, bean.getBillVoucherNumber());
                if (createSQLQuery.list().size() <= 0 || bean.getBillDate().compareTo(restrictedDate) <= 0) continue;
                ++billDateFlag;
                break;
            }
        }
        return billDateFlag > 0;
    }

    public void validateRTGSPaymentForModify(List<PaymentBean> billList) throws ValidationException, ApplicationException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting validateRTGSPaymentForModify...");
        }
        this.getGlcodeIds();
        EntityType entity = null;
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (billList != null) {
            for (PaymentBean bean : billList) {
                if (bean == null) continue;
                Object[] obj = (Object[])this.persistenceService.find("select gld.detailTypeId.id,gld.detailKeyId,billmis.egBillregister.expendituretype from CGeneralLedgerDetail gld,CGeneralLedger gl,EgBillregistermis billmis where gl.id=gld.generalLedgerId.id and billmis.voucherHeader = gl.voucherHeaderId and billmis.voucherHeader.id=?", new Object[]{bean.getCsBillId()});
                if (obj == null) {
                    LOGGER.error((Object)("Sub ledger details are missing for this bill number ->" + bean.getBillNumber()));
                    errors.add(new ValidationError("entityType", "Sub ledger details are missing for this bill number->" + bean.getBillNumber()));
                    throw new ValidationException(errors);
                }
                if (obj[2].equals("Expense")) {
                    this.validateCBill(bean, "Modify");
                    continue;
                }
                entity = this.getEntity(Integer.valueOf(obj[0].toString()), (Serializable)obj[1]);
                if (obj[2].equals("Works") && (StringUtils.isBlank((String)entity.getPanno()) || StringUtils.isBlank((String)entity.getBankname()) || StringUtils.isBlank((String)entity.getBankaccount()) || StringUtils.isBlank((String)entity.getIfsccode()))) {
                    LOGGER.error((Object)("BankAccount,IFSC Code, Pan number is mandatory for RTGS Payment for " + entity.getName()));
                    errors.add(new ValidationError("paymentMode", "BankName, BankAccount,IFSC Code, Pan number is mandatory for RTGS Payment for " + entity.getName()));
                    throw new ValidationException(errors);
                }
                if (!obj[2].equals("Purchase") || !StringUtils.isBlank((String)entity.getTinno()) && !StringUtils.isBlank((String)entity.getBankname()) && !StringUtils.isBlank((String)entity.getBankaccount()) && !StringUtils.isBlank((String)entity.getIfsccode())) continue;
                LOGGER.error((Object)("BankAccount,IFSC Code, Tin number is mandatory for RTGS Payment for " + entity.getName()));
                errors.add(new ValidationError("paymentMode", "BankName, BankAccount,IFSC Code, Tin number is mandatory for RTGS Payment for " + entity.getName()));
                throw new ValidationException(errors);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed validateRTGSPaymentForModify.");
        }
    }

    public EntityType getEntity(Integer detailTypeId, Serializable detailKeyId) throws ApplicationException {
        EntityType entity;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting getEntity...");
        }
        try {
            Accountdetailtype accountdetailtype = (Accountdetailtype)this.persistenceService.find(" from Accountdetailtype where id=?", new Object[]{detailTypeId});
            Class<?> service = Class.forName(accountdetailtype.getFullQualifiedName());
            String detailTypeName = service.getSimpleName();
            String dataType = EMPTY_STRING;
            Method method = service.getMethod("getId", new Class[0]);
            dataType = method.getReturnType().getSimpleName();
            entity = dataType.equals("Long") ? (EntityType)this.persistenceService.find("from " + detailTypeName + " where id=? order by name", new Object[]{Long.valueOf(detailKeyId + EMPTY_STRING)}) : (EntityType)this.persistenceService.find("from " + detailTypeName + " where id=? order by name", new Object[]{Integer.valueOf(detailKeyId + EMPTY_STRING)});
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exception to get EntityType=" + e.getMessage()));
            throw new ApplicationException("Exception to get EntityType=" + e.getMessage());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed getEntity.");
        }
        return entity;
    }

    public List<PaymentBean> getMiscBillList(Paymentheader header) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting getMiscBillList...");
        }
        List paymentBeanList = null;
        Query query = this.getSession().createSQLQuery("select mb.billvhId as billId,mb.billnumber as billNumber,mb.billdate as billDate,mb.paidto as payTo,mb.amount as netAmt,   mb.passedamount as passedAmt,mb.paidamount as paymentAmt,br.expendituretype as expType from miscbilldetail mb, eg_billregister br , eg_billregistermis mis  where mb.payvhid=" + header.getVoucherheader().getId() + " and br.id= mis.billid and mis.voucherheaderid=billvhid order by mb.paidto,mb.BILLDATE").addScalar("billId", (Type)BigDecimalType.INSTANCE).addScalar("billNumber").addScalar("billDate").addScalar("payTo").addScalar("netAmt", (Type)BigDecimalType.INSTANCE).addScalar("passedAmt", (Type)BigDecimalType.INSTANCE).addScalar("paymentAmt", (Type)BigDecimalType.INSTANCE).addScalar("expType").setResultTransformer(Transformers.aliasToBean(PaymentBean.class));
        paymentBeanList = query.list();
        for (PaymentBean bean : paymentBeanList) {
            bean.setIsSelected(true);
            BigDecimal earlierAmt = (BigDecimal)this.persistenceService.find(" select sum(paidamount) from Miscbilldetail where billVoucherHeader.id=? and payVoucherHeader.status not in(?,?)", new Object[]{bean.getCsBillId(), FinancialConstants.CANCELLEDVOUCHERSTATUS, FinancialConstants.REVERSEDVOUCHERSTATUS});
            if (earlierAmt == null) {
                earlierAmt = BigDecimal.ZERO;
            }
            bean.setEarlierPaymentAmt(earlierAmt.subtract(bean.getPaymentAmt()));
            bean.setPayableAmt(bean.getNetAmt().subtract(bean.getEarlierPaymentAmt()));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed getMiscBillList.");
        }
        return paymentBeanList;
    }

    public List<ChequeAssignment> getPaymentVoucherForRTGSInstrument(Map<String, String[]> parameters, CVoucherHeader voucherHeader) throws ApplicationException, ParseException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting getPaymentVoucherNotInInstrument...");
        }
        List<ChequeAssignment> chequeAssignmentList = new ArrayList<ChequeAssignment>();
        StringBuffer sql = new StringBuffer();
        if (!EMPTY_STRING.equals(parameters.get("fromDate")[0])) {
            sql.append(" and vh.voucherDate>='" + this.sdf.format(this.formatter.parse(parameters.get("fromDate")[0])) + "' ");
        }
        if (!EMPTY_STRING.equals(parameters.get("toDate")[0])) {
            sql.append(" and vh.voucherDate<='" + this.sdf.format(this.formatter.parse(parameters.get("toDate")[0])) + "'");
        }
        if (!StringUtils.isEmpty((String)voucherHeader.getVoucherNumber())) {
            sql.append(" and vh.voucherNumber like '%" + voucherHeader.getVoucherNumber() + "%'");
        }
        if (voucherHeader.getFundId() != null) {
            sql.append(" and vh.fundId=" + voucherHeader.getFundId().getId());
        }
        if (voucherHeader.getVouchermis().getFundsource() != null) {
            sql.append(" and vmis.fundsourceId=" + voucherHeader.getVouchermis().getFundsource().getId());
        }
        if (voucherHeader.getVouchermis().getDepartmentid() != null) {
            sql.append(" and vmis.departmentid=" + voucherHeader.getVouchermis().getDepartmentid().getId());
        }
        if (voucherHeader.getVouchermis().getSchemeid() != null) {
            sql.append(" and vmis.schemeid=" + voucherHeader.getVouchermis().getSchemeid().getId());
        }
        if (voucherHeader.getVouchermis().getSubschemeid() != null) {
            sql.append(" and vmis.subschemeid=" + voucherHeader.getVouchermis().getSubschemeid().getId());
        }
        if (voucherHeader.getVouchermis().getFunctionary() != null) {
            sql.append(" and vmis.functionaryid=" + voucherHeader.getVouchermis().getFunctionary().getId());
        }
        if (voucherHeader.getVouchermis().getDivisionid() != null) {
            sql.append(" and vmis.divisionid=" + voucherHeader.getVouchermis().getDivisionid().getId());
        }
        if (parameters.get("bankaccount") != null && !parameters.get("bankaccount")[0].equals("-1")) {
            sql.append(" and ph.bankaccountnumberid=" + parameters.get("bankaccount")[0]);
            sql.append(" and lower(ph.type)=lower('" + parameters.get("paymentMode")[0] + "')");
            sql.append(" and ph.bankaccountnumberid=ba.id");
        } else {
            sql.append(" and ph.bankaccountnumberid=ba.id").append(" and lower(ph.type)=lower('" + parameters.get("paymentMode")[0] + "')");
        }
        sql.append(" and vmis.departmentid     =dept.id  ");
        List appList = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "APPROVEDVOUCHERSTATUS");
        String approvedstatus = ((AppConfigValues)appList.get(0)).getValue();
        ArrayList<String> descriptionList = new ArrayList<String>();
        descriptionList.add("New");
        descriptionList.add("Reconciled");
        List egwStatusList = this.egwStatusDAO.getStatusListByModuleAndCodeList("Instrument", descriptionList);
        String statusId = EMPTY_STRING;
        for (EgwStatus egwStatus : egwStatusList) {
            statusId = statusId + egwStatus.getId() + ",";
        }
        statusId = statusId.substring(0, statusId.length() - 1);
        this.persistenceService.find(" from Bankaccount where id=?", new Object[]{Long.valueOf(parameters.get("bankaccount")[0])});
        Query query = null;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("statusId -- > " + statusId));
        }
        this.chequeList = new ArrayList<ChequeAssignment>();
        if (voucherHeader.getName() == null || !voucherHeader.getName().equalsIgnoreCase("Remittance Payment")) {
            query = this.getSession().createSQLQuery(" select  vh.id as voucherid ,vh.voucherNumber as voucherNumber , dept.name   AS departmentName, vh.voucherDate as voucherDate, misbill.paidto as paidTo,sum(misbill.paidamount) as paidAmount,current_date as chequeDate , ba.accountnumber   AS bankAccNumber, ba.id  AS bankAccountId , bill.id                 as billId, bill.billnumber       as billNumber ,bill.expenditureType as expenditureType from Paymentheader ph, eg_department dept, bankaccount ba, voucherheader vh   LEFT JOIN  EGF_INSTRUMENTVOUCHER IV ON VH.ID=IV.VOUCHERHEADERID LEFT JOIN EGF_INSTRUMENTHEADER IH ON IV.INSTRUMENTHEADERID=IH.ID, vouchermis vmis, Miscbilldetail misbill ,eg_billregistermis bmis, eg_billregister bill  where ph.voucherheaderid=misbill.payvhid and ph.voucherheaderid=vh.id and vmis.voucherheaderid= vh.id  and vh.status =" + approvedstatus + " " + sql + "  and bmis.voucherheaderid=misbill.billvhid     and bmis.billid=bill.Id and  IV.VOUCHERHEADERID IS NULL  and vh.type='" + "Payment" + "'  and vh.name NOT IN ('" + "Remittance Payment" + "' , '" + "Salary Bill Payment" + "','" + "Pension Bill Payment" + "')  group by vh.id,  vh.voucherNumber,  dept.name ,  vh.voucherDate,misbill.paidto,  ba.accountnumber, ba.id , bill.id, bill.billnumber,bill.expenditureType  order by ba.id,dept.name,vh.voucherNumber ").addScalar("voucherid", (Type)BigDecimalType.INSTANCE).addScalar("voucherNumber").addScalar("departmentName").addScalar("voucherDate").addScalar("paidTo").addScalar("paidAmount", (Type)BigDecimalType.INSTANCE).addScalar("chequeDate").addScalar("bankAccNumber").addScalar("bankAccountId", (Type)BigDecimalType.INSTANCE).addScalar("billId", (Type)BigDecimalType.INSTANCE).addScalar("billNumber").addScalar("expenditureType").setResultTransformer(Transformers.aliasToBean(ChequeAssignment.class));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)(" for non salary and remittance" + query));
            }
            LOGGER.info((Object)(" for non salary and remittance" + query));
            chequeAssignmentList = query.list();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"checking  cheque assigned and surrendard");
            }
            query = this.getSession().createSQLQuery("select vh.id as voucherid ,vh.voucherNumber as voucherNumber , dept.name   AS departmentName, vh.voucherDate as voucherDate, misbill.paidto as         paidTo,sum(misbill.paidamount) as paidAmount,current_date as chequeDate , ba.accountnumber AS bankAccNumber  , ba.id  AS bankAccountId ,  bill.id    as billId, bill.billnumber as billNumber ,bill.expenditureType as expenditureType from Paymentheader ph,eg_department dept, bankaccount ba,eg_billregistermis bmis,  eg_billregister bill ,voucherheader vh   LEFT  JOIN EGF_INSTRUMENTVOUCHER IV ON VH.ID=IV.VOUCHERHEADERID LEFT JOIN EGF_INSTRUMENTHEADER IH  ON IV.INSTRUMENTHEADERID=IH.ID,vouchermis vmis, Miscbilldetail misbill ,(select max(iv1.instrumentheaderid) as maxihid,iv1.voucherheaderid as iv1vhid from egf_instrumentvoucher iv1 group by iv1.voucherheaderid) as table1 where ph.voucherheaderid=misbill.payvhid and ph.voucherheaderid=vh.id and vmis.voucherheaderid= vh.id  and vh.status =" + approvedstatus + " " + sql + "  and bmis.voucherheaderid=misbill.billvhid     and bmis.billid=bill.Id  and  IV.VOUCHERHEADERID IS NOT  NULL and iv.instrumentheaderid=table1.maxihid and  table1.iv1vhid=vh.id and ih.id_status not in (" + statusId + ") and vh.type='" + "Payment" + "' and vh.name NOT IN ('" + "Remittance Payment" + "' , '" + "Salary Bill Payment" + "', '" + "Pension Bill Payment" + "')  group by   vh.id,  vh.voucherNumber,  dept.name ,  vh.voucherDate,misbill.paidto,ba.accountnumber, ba.id , bill.id, bill.billnumber ,bill.expenditureType order by ba.id,dept.name,vh.voucherNumber ").addScalar("voucherid", (Type)BigDecimalType.INSTANCE).addScalar("voucherNumber").addScalar("departmentName").addScalar("voucherDate").addScalar("paidTo").addScalar("paidAmount", (Type)BigDecimalType.INSTANCE).addScalar("chequeDate").addScalar("bankAccNumber").addScalar("bankAccountId", (Type)BigDecimalType.INSTANCE).addScalar("billId", (Type)BigDecimalType.INSTANCE).addScalar("billNumber").addScalar("expenditureType").setResultTransformer(Transformers.aliasToBean(ChequeAssignment.class));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)(" Surrendered rtgs nos" + query));
            }
            LOGGER.info((Object)(" Surrendered rtgs nos" + query));
            chequeAssignmentList.addAll(query.list());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed getPaymentVoucherNotInInstrument.");
        }
        return chequeAssignmentList;
    }

    public List<ChequeAssignment> getPaymentVoucherForTNEBRTGSInstrument(Map<String, String[]> parameters, CVoucherHeader voucherHeader) throws ApplicationException, ParseException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting getPaymentVoucherNotInInstrument...");
        }
        List<ChequeAssignment> chequeAssignmentList = new ArrayList<ChequeAssignment>();
        StringBuffer sql = new StringBuffer();
        StringBuffer TNEBsql = new StringBuffer();
        EgBillSubType egSubType = new EgBillSubType();
        egSubType = (EgBillSubType)this.persistenceService.find(" from EgBillSubType where name = ?", new Object[]{"TNEB"});
        if (egSubType.getId() != null) {
            TNEBsql.append(" bmis.billsubtype = " + egSubType.getId() + EMPTY_STRING);
        }
        if (parameters.get("region")[0] != null && !parameters.get("region")[0].equalsIgnoreCase(EMPTY_STRING)) {
            TNEBsql.append(" and ebd.region = '" + parameters.get("region")[0] + "'");
        }
        if (!EMPTY_STRING.equals(parameters.get("fromDate")[0])) {
            sql.append(" and vh.voucherDate>='" + this.sdf.format(this.formatter.parse(parameters.get("fromDate")[0])) + "' ");
        }
        if (!EMPTY_STRING.equals(parameters.get("toDate")[0])) {
            sql.append(" and vh.voucherDate<='" + this.sdf.format(this.formatter.parse(parameters.get("toDate")[0])) + "'");
        }
        if (!StringUtils.isEmpty((String)voucherHeader.getVoucherNumber())) {
            sql.append(" and vh.voucherNumber like '%" + voucherHeader.getVoucherNumber() + "%'");
        }
        if (voucherHeader.getFundId() != null) {
            sql.append(" and vh.fundId=" + voucherHeader.getFundId().getId());
        }
        if (voucherHeader.getVouchermis().getFundsource() != null) {
            sql.append(" and vmis.fundsourceId=" + voucherHeader.getVouchermis().getFundsource().getId());
        }
        if (voucherHeader.getVouchermis().getDepartmentid() != null) {
            sql.append(" and vmis.departmentid=" + voucherHeader.getVouchermis().getDepartmentid().getId());
        }
        if (voucherHeader.getVouchermis().getSchemeid() != null) {
            sql.append(" and vmis.schemeid=" + voucherHeader.getVouchermis().getSchemeid().getId());
        }
        if (voucherHeader.getVouchermis().getSubschemeid() != null) {
            sql.append(" and vmis.subschemeid=" + voucherHeader.getVouchermis().getSubschemeid().getId());
        }
        if (voucherHeader.getVouchermis().getFunctionary() != null) {
            sql.append(" and vmis.functionaryid=" + voucherHeader.getVouchermis().getFunctionary().getId());
        }
        if (voucherHeader.getVouchermis().getDivisionid() != null) {
            sql.append(" and vmis.divisionid=" + voucherHeader.getVouchermis().getDivisionid().getId());
        }
        if (parameters.get("bankaccount") != null && !parameters.get("bankaccount")[0].equals("-1")) {
            sql.append(" and ph.bankaccountnumberid=" + parameters.get("bankaccount")[0]);
            sql.append(" and lower(ph.type)=lower('" + parameters.get("paymentMode")[0] + "')");
            sql.append(" and ph.bankaccountnumberid=ba.id");
        } else {
            sql.append(" and ph.bankaccountnumberid=ba.id").append(" and lower(ph.type)=lower('" + parameters.get("paymentMode")[0] + "')");
        }
        sql.append(" and vmis.departmentid     =dept.id  ");
        List appList = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "APPROVEDVOUCHERSTATUS");
        String approvedstatus = ((AppConfigValues)appList.get(0)).getValue();
        ArrayList<String> descriptionList = new ArrayList<String>();
        descriptionList.add("New");
        descriptionList.add("Reconciled");
        List egwStatusList = this.egwStatusDAO.getStatusListByModuleAndCodeList("Instrument", descriptionList);
        String statusId = EMPTY_STRING;
        for (EgwStatus egwStatus : egwStatusList) {
            statusId = statusId + egwStatus.getId() + ",";
        }
        statusId = statusId.substring(0, statusId.length() - 1);
        this.persistenceService.find(" from Bankaccount where id=?", new Object[]{Long.valueOf(parameters.get("bankaccount")[0])});
        String payTo = null;
        try {
            List configValues = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "EB Voucher Property-BankBranch");
            for (AppConfigValues appConfigVal : configValues) {
                payTo = appConfigVal.getValue();
            }
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("Appconfig value for EB Voucher propartys is not defined in the system");
        }
        if (payTo != null) {
            payTo = payTo.substring(0, 20);
        }
        Query query = null;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("statusId -- > " + statusId));
        }
        this.chequeList = new ArrayList<ChequeAssignment>();
        if (voucherHeader.getName() == null || !voucherHeader.getName().equalsIgnoreCase("Remittance Payment")) {
            query = this.getSession().createSQLQuery(" SELECT vh.id AS voucherid , vh.voucherNumber AS voucherNumber , dept.name   AS departmentName,  vh.voucherDate AS voucherDate, '" + payTo + "' AS paidTo , ph.paymentamount AS paidAmount, current_date AS chequeDate ,ba.accountnumber AS bankAccNumber , ba.id AS bankAccountId FROM paymentheader ph , eg_department dept, bankaccount ba, voucherheader vh LEFT JOIN EGF_INSTRUMENTVOUCHER IV  ON VH.ID=IV.VOUCHERHEADERID LEFT JOIN EGF_INSTRUMENTHEADER IH ON IV.INSTRUMENTHEADERID=IH.ID,vouchermis vmis  WHERE ph.voucherheaderid IN ( SELECT DISTINCT misbill.payvhid  FROM egf_ebdetails ebd , eg_billregistermis bmis, eg_billregister bill , Miscbilldetail misbill WHERE  bill.id = ebd.billid  AND bmis.billid = bill.id AND  " + TNEBsql + " AND bmis.voucherheaderid = misbill.billvhid ) AND ph.voucherheaderid = vh.id  AND vmis.voucherheaderid  = vh.id AND vh.status = " + approvedstatus + " " + sql + "  AND ph.bankaccountnumberid=ba.id AND vmis.departmentid = dept.id AND IV.VOUCHERHEADERID IS NULL AND  vh.type = '" + "Payment" + "' AND vh.name NOT IN  ('" + "Remittance Payment" + "' , '" + "Salary Bill Payment" + "', '" + "Pension Bill Payment" + "')  GROUP BY vh.id,vh.voucherNumber,dept.name , vh.voucherDate, ba.accountnumber, ba.id , ph.paymentamount ORDER BY ba.id,dept.name,vh.voucherNumber ").addScalar("voucherid", (Type)BigDecimalType.INSTANCE).addScalar("voucherNumber").addScalar("departmentName").addScalar("voucherDate").addScalar("paidTo", (Type)StringType.INSTANCE).addScalar("paidAmount", (Type)BigDecimalType.INSTANCE).addScalar("chequeDate").addScalar("bankAccNumber").addScalar("bankAccountId", (Type)BigDecimalType.INSTANCE).setResultTransformer(Transformers.aliasToBean(ChequeAssignment.class));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)(" for non salary and remittance" + query));
            }
            LOGGER.info((Object)(" for non salary and remittance" + query));
            chequeAssignmentList = query.list();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"checking  cheque assigned and surrendard");
            }
            query = this.getSession().createSQLQuery(" SELECT vh.id AS voucherid , vh.voucherNumber AS voucherNumber , dept.name   AS departmentName,  vh.voucherDate AS voucherDate, '" + payTo + "' AS paidTo , ph.paymentamount AS paidAmount, current_date AS chequeDate ,ba.accountnumber AS bankAccNumber , ba.id AS bankAccountId FROM paymentheader ph , eg_department dept, bankaccount ba, voucherheader vh LEFT JOIN EGF_INSTRUMENTVOUCHER IV  ON VH.ID=IV.VOUCHERHEADERID LEFT JOIN EGF_INSTRUMENTHEADER IH ON IV.INSTRUMENTHEADERID=IH.ID,vouchermis vmis,(SELECT MAX(iv1.instrumentheaderid) AS maxihid, iv1.voucherheaderid AS iv1vhid FROM egf_instrumentvoucher iv1 GROUP BY iv1.voucherheaderid ) as table1 WHERE ph.voucherheaderid IN ( SELECT DISTINCT misbill.payvhid  FROM egf_ebdetails ebd , eg_billregistermis bmis, eg_billregister bill , Miscbilldetail misbill WHERE bill.id = ebd.billid  AND bmis.billid = bill.id AND " + TNEBsql + " AND bmis.voucherheaderid = misbill.billvhid ) AND ph.voucherheaderid = vh.id  AND vmis.voucherheaderid  = vh.id AND vh.status = " + approvedstatus + " " + sql + "  AND ph.bankaccountnumberid=ba.id AND vmis.departmentid = dept.id AND IV.VOUCHERHEADERID IS NOT NULL AND iv.instrumentheaderid = table1.maxihid AND table1.iv1vhid = vh.id AND  ih.id_status NOT IN (" + statusId + ") AND vh.type = '" + "Payment" + "' AND vh.name NOT IN  ('" + "Remittance Payment" + "' , '" + "Salary Bill Payment" + "', '" + "Pension Bill Payment" + "')  GROUP BY vh.id,vh.voucherNumber,dept.name , vh.voucherDate, ba.accountnumber, ba.id , ph.paymentamount ORDER BY ba.id,dept.name,vh.voucherNumber ").addScalar("voucherid", (Type)BigDecimalType.INSTANCE).addScalar("voucherNumber").addScalar("departmentName").addScalar("voucherDate").addScalar("paidTo", (Type)StringType.INSTANCE).addScalar("paidAmount", (Type)BigDecimalType.INSTANCE).addScalar("chequeDate").addScalar("bankAccNumber").addScalar("bankAccountId", (Type)BigDecimalType.INSTANCE).setResultTransformer(Transformers.aliasToBean(ChequeAssignment.class));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)(" Surrendered rtgs nos" + query));
            }
            LOGGER.info((Object)(" Surrendered rtgs nos" + query));
            chequeAssignmentList.addAll(query.list());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed getPaymentVoucherNotInInstrument.");
        }
        return chequeAssignmentList;
    }

    public List<ChequeAssignment> getDirectBankPaymentVoucherForRTGSInstrument(Map<String, String[]> parameters, CVoucherHeader voucherHeader) throws ApplicationException, ParseException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting getPaymentVoucherNotInInstrument...");
        }
        ArrayList<ChequeAssignment> chequeAssignmentList = new ArrayList<ChequeAssignment>();
        StringBuffer sql = new StringBuffer();
        if (!EMPTY_STRING.equals(parameters.get("fromDate")[0])) {
            sql.append(" and vh.voucherDate>='" + this.sdf.format(this.formatter.parse(parameters.get("fromDate")[0])) + "' ");
        }
        if (!EMPTY_STRING.equals(parameters.get("toDate")[0])) {
            sql.append(" and vh.voucherDate<='" + this.sdf.format(this.formatter.parse(parameters.get("toDate")[0])) + "'");
        }
        if (!StringUtils.isEmpty((String)voucherHeader.getVoucherNumber())) {
            sql.append(" and vh.voucherNumber like '%" + voucherHeader.getVoucherNumber() + "%'");
        }
        if (voucherHeader.getFundId() != null) {
            sql.append(" and vh.fundId=" + voucherHeader.getFundId().getId());
        }
        if (voucherHeader.getVouchermis().getFundsource() != null) {
            sql.append(" and vmis.fundsourceId=" + voucherHeader.getVouchermis().getFundsource().getId());
        }
        if (voucherHeader.getVouchermis().getDepartmentid() != null) {
            sql.append(" and vmis.departmentid=" + voucherHeader.getVouchermis().getDepartmentid().getId());
        }
        if (voucherHeader.getVouchermis().getSchemeid() != null) {
            sql.append(" and vmis.schemeid=" + voucherHeader.getVouchermis().getSchemeid().getId());
        }
        if (voucherHeader.getVouchermis().getSubschemeid() != null) {
            sql.append(" and vmis.subschemeid=" + voucherHeader.getVouchermis().getSubschemeid().getId());
        }
        if (voucherHeader.getVouchermis().getFunctionary() != null) {
            sql.append(" and vmis.functionaryid=" + voucherHeader.getVouchermis().getFunctionary().getId());
        }
        if (voucherHeader.getVouchermis().getDivisionid() != null) {
            sql.append(" and vmis.divisionid=" + voucherHeader.getVouchermis().getDivisionid().getId());
        }
        if (parameters.get("bankaccount") != null && !parameters.get("bankaccount")[0].equals("-1")) {
            sql.append(" and ph.bankaccountnumberid=" + parameters.get("bankaccount")[0]);
            sql.append(" and lower(ph.type)=lower('" + parameters.get("paymentMode")[0] + "')");
            sql.append(" and ph.bankaccountnumberid=ba.id");
        } else {
            sql.append(" and ph.bankaccountnumberid=ba.id").append(" and lower(ph.type)=lower('" + parameters.get("paymentMode")[0] + "')");
        }
        sql.append(" and vmis.departmentid     =dept.id  ");
        List appList = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "APPROVEDVOUCHERSTATUS");
        String approvedstatus = ((AppConfigValues)appList.get(0)).getValue();
        ArrayList<String> descriptionList = new ArrayList<String>();
        descriptionList.add("New");
        descriptionList.add("Reconciled");
        List egwStatusList = this.egwStatusDAO.getStatusListByModuleAndCodeList("Instrument", descriptionList);
        String statusId = EMPTY_STRING;
        for (EgwStatus egwStatus : egwStatusList) {
            statusId = statusId + egwStatus.getId() + ",";
        }
        statusId = statusId.substring(0, statusId.length() - 1);
        this.persistenceService.find(" from Bankaccount where id=?", new Object[]{Long.valueOf(parameters.get("bankaccount")[0])});
        Query query = null;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("statusId -- > " + statusId));
        }
        this.chequeList = new ArrayList<ChequeAssignment>();
        if (voucherHeader.getName() == null || !voucherHeader.getName().equalsIgnoreCase("Remittance Payment")) {
            query = this.getSession().createSQLQuery(" SELECT vh.id   AS voucherid , vh.voucherNumber        AS voucherNumber ,dept.name          AS departmentName,  vh.voucherDate  AS voucherDate , misbill.paidto  AS paidTo, SUM(misbill.paidamount) AS paidAmount,current_date AS chequeDate,   ba.accountnumber  AS bankAccNumber, ba.id  AS bankAccountId ,vh.name     AS expenditureType    FROM Paymentheader ph,  voucherheader vh,  vouchermis vmis,  Miscbilldetail misbill,  eg_department dept,  bankaccount ba,  egf_instrumentvoucher iv RIGHT OUTER JOIN voucherheader pvh ON (pvh.id    =iv.VOUCHERHEADERID) WHERE ph.voucherheaderid  =misbill.payvhid AND ph.voucherheaderid    =vh.id AND vh.name  ='Direct Bank Payment' AND vmis.voucherheaderid  = vh.id  AND vh.status   =" + approvedstatus + sql + " AND pvh.id      =vh.id AND iv.id     IS NULL AND dept.id  = vmis.departmentid AND ph.bankaccountnumberid= ba.id GROUP BY vh.id,   vh.voucherNumber,  dept.name ,  vh.voucherDate,  misbill.paidto,ba.accountnumber,  ba.id,vh.name UNION SELECT vh.id  AS voucherid ,vh.voucherNumber AS voucherNumber ,dept.name AS departmentName,vh.voucherDate          AS voucherDate ,  misbill.paidto          AS paidTo, SUM(misbill.paidamount) AS paidAmount, current_date   AS chequeDate,ba.accountnumber  AS bankAccNumber, ba.id   AS bankAccountId, vh.name  AS expenditureType FROM Paymentheader ph,voucherheader vh,vouchermis vmis,eg_department dept,bankaccount ba, Miscbilldetail misbill, egf_instrumentvoucher iv RIGHT OUTER JOIN voucherheader pvh ON (pvh.id=iv.VOUCHERHEADERID) LEFT OUTER JOIN egf_instrumentheader ih ON (ih.ID   =iv.INSTRUMENTHEADERID) WHERE ph.voucherheaderid  =misbill.payvhid AND ph.voucherheaderid    =vh.id AND vh.name ='" + "Direct Bank Payment" + "' AND vmis.voucherheaderid  = vh.id AND vh.status  =" + approvedstatus + sql + " AND pvh.id   =vh.id AND dept.id          = vmis.departmentid AND ph.bankaccountnumberid= ba.id AND ih.id IN  (SELECT MAX(ih.id)  FROM egf_instrumentvoucher iv  RIGHT OUTER JOIN voucherheader pvh ON (pvh.id=iv.VOUCHERHEADERID) LEFT OUTER JOIN egf_instrumentheader ih   ON (ih.ID    =iv.INSTRUMENTHEADERID)  WHERE pvh.id =vh.id      ) and ih.id_status not in (" + statusId + ") GROUP BY vh.id,  vh.voucherNumber,  dept.name ,  vh.voucherDate,  misbill.paidto,  ba.accountnumber,  ba.id,  vh.name                                            order by bankAccountId, departmentName,  voucherNumber ").addScalar("voucherid", (Type)BigDecimalType.INSTANCE).addScalar("voucherNumber").addScalar("departmentName").addScalar("voucherDate").addScalar("paidTo").addScalar("paidAmount", (Type)BigDecimalType.INSTANCE).addScalar("chequeDate").addScalar("bankAccNumber").addScalar("bankAccountId", (Type)BigDecimalType.INSTANCE).addScalar("expenditureType").setResultTransformer(Transformers.aliasToBean(ChequeAssignment.class));
            chequeAssignmentList.addAll(query.list());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed getPaymentVoucherNotInInstrument.");
        }
        return chequeAssignmentList;
    }

    public List<ChequeAssignment> getPaymentVoucherNotInInstrument(Map<String, String[]> parameters, CVoucherHeader voucherHeader) throws ApplicationException, ParseException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting getPaymentVoucherNotInInstrument...");
        }
        List<ChequeAssignment> chequeAssignmentList = new ArrayList<ChequeAssignment>();
        if (parameters.get("paymentMode")[0].equals("cheque")) {
            String billType = parameters.get("billType")[0];
            this.chequeAssignmentService.setStatusAndFilterValues(parameters, voucherHeader);
            if (voucherHeader.getName() != null && voucherHeader.getName().equalsIgnoreCase("Pension Bill Payment")) {
                String[] voucherName = new String[]{voucherHeader.getName()};
                parameters.put("voucherName", voucherName);
            }
            if (billType == null || billType.equalsIgnoreCase("-1") || billType.equalsIgnoreCase("0")) {
                chequeAssignmentList.addAll(this.chequeAssignmentService.getPaymentVoucherNotInInstrument(parameters));
            } else if (billType.equalsIgnoreCase("Expense")) {
                chequeAssignmentList.addAll(this.chequeAssignmentService.getExpenseBillPayments());
            } else if (billType.equalsIgnoreCase("Works-Purchase")) {
                chequeAssignmentList.addAll(this.chequeAssignmentService.getContractorSupplierPaymentsForChequeAssignment(parameters));
            } else if (billType.equalsIgnoreCase("Direct Bank Payment")) {
                chequeAssignmentList.addAll(this.chequeAssignmentService.getDirectBankPaymentsForChequeAssignment());
            }
        } else {
            List<ChequeAssignment> tempChequeAssignmentList;
            StringBuffer sql = new StringBuffer();
            if (!EMPTY_STRING.equals(parameters.get("fromDate")[0])) {
                sql.append(" and vh.voucherDate>='" + this.sdf.format(this.formatter.parse(parameters.get("fromDate")[0])) + "' ");
            }
            if (!EMPTY_STRING.equals(parameters.get("toDate")[0])) {
                sql.append(" and vh.voucherDate<='" + this.sdf.format(this.formatter.parse(parameters.get("toDate")[0])) + "'");
            }
            if (!StringUtils.isEmpty((String)voucherHeader.getVoucherNumber())) {
                sql.append(" and vh.voucherNumber like '%" + voucherHeader.getVoucherNumber() + "%'");
            }
            if (voucherHeader.getFundId() != null) {
                sql.append(" and vh.fundId=" + voucherHeader.getFundId().getId());
            }
            if (voucherHeader.getVouchermis().getFundsource() != null) {
                sql.append(" and vmis.fundsourceId=" + voucherHeader.getVouchermis().getFundsource().getId());
            }
            if (voucherHeader.getVouchermis().getDepartmentid() != null) {
                sql.append(" and vmis.departmentid=" + voucherHeader.getVouchermis().getDepartmentid().getId());
            }
            if (voucherHeader.getVouchermis().getSchemeid() != null) {
                sql.append(" and vmis.schemeid=" + voucherHeader.getVouchermis().getSchemeid().getId());
            }
            if (voucherHeader.getVouchermis().getSubschemeid() != null) {
                sql.append(" and vmis.subschemeid=" + voucherHeader.getVouchermis().getSubschemeid().getId());
            }
            if (voucherHeader.getVouchermis().getFunctionary() != null) {
                sql.append(" and vmis.functionaryid=" + voucherHeader.getVouchermis().getFunctionary().getId());
            }
            if (voucherHeader.getVouchermis().getDivisionid() != null) {
                sql.append(" and vmis.divisionid=" + voucherHeader.getVouchermis().getDivisionid().getId());
            }
            sql.append(" and ph.bankaccountnumberid=" + parameters.get("bankaccount")[0]);
            sql.append(" and lower(ph.type)=lower('" + parameters.get("paymentMode")[0] + "')");
            List appList = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "APPROVEDVOUCHERSTATUS");
            String approvedstatus = ((AppConfigValues)appList.get(0)).getValue();
            ArrayList<String> descriptionList = new ArrayList<String>();
            descriptionList.add("New");
            descriptionList.add("Reconciled");
            List egwStatusList = this.egwStatusDAO.getStatusListByModuleAndCodeList("Instrument", descriptionList);
            String statusId = EMPTY_STRING;
            for (EgwStatus egwStatus : egwStatusList) {
                statusId = statusId + egwStatus.getId() + ",";
            }
            statusId = statusId.substring(0, statusId.length() - 1);
            this.persistenceService.find(" from Bankaccount where id=?", new Object[]{Long.valueOf(parameters.get("bankaccount")[0])});
            Query query = null;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("statusId -- > " + statusId));
            }
            this.chequeList = new ArrayList<ChequeAssignment>();
            if (voucherHeader.getName() != null && voucherHeader.getName().equalsIgnoreCase("Salary Bill Payment")) {
                query = this.getSession().createSQLQuery("select vh.id as voucherid ,vh.voucherNumber as voucherNumber ,vh.voucherDate as voucherDate,sum(misbill.paidamount) as paidAmount,current_date as chequeDate,  misbill.paidto as paidTo from Paymentheader ph,voucherheader vh  LEFT JOIN EGF_INSTRUMENTVOUCHER IV ON VH.ID=IV.VOUCHERHEADERID LEFT JOIN EGF_INSTRUMENTHEADER IH ON IV.INSTRUMENTHEADERID=IH.ID  ,vouchermis vmis, Miscbilldetail misbill  where ph.voucherheaderid=misbill.payvhid and ph.voucherheaderid=vh.id and vmis.voucherheaderid= vh.id and vh.status =" + approvedstatus + " " + sql + "  and  IV.VOUCHERHEADERID IS NULL  and vh.type='" + "Payment" + "' and vh.name ='" + "Salary Bill Payment" + "' group by vh.id,vh.voucherNumber,vh.voucherDate,misbill.paidto order by vh.voucherNumber ").addScalar("voucherid", (Type)BigDecimalType.INSTANCE).addScalar("voucherNumber").addScalar("voucherDate").addScalar("paidAmount").addScalar("chequeDate").addScalar("paidTo").setResultTransformer(Transformers.aliasToBean(ChequeAssignment.class));
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)(" for salary " + query));
                }
                chequeAssignmentList = query.list();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"checking  cheque assigned and surrendard");
                }
                query = this.getSession().createSQLQuery("select vh.id as voucherid ,vh.voucherNumber as voucherNumber ,vh.voucherDate as voucherDate,sum(misbill.paidamount) as paidAmount,current_date as chequeDate,  misbill.paidto as paidTo from Paymentheader ph,voucherheader vh  LEFT JOIN EGF_INSTRUMENTVOUCHER IV ON VH.ID=IV.VOUCHERHEADERID LEFT JOIN EGF_INSTRUMENTHEADER IH ON IV.INSTRUMENTHEADERID=IH.ID  ,vouchermis vmis, Miscbilldetail misbill , (select max(iv1.instrumentheaderid) as maxihid,iv1.voucherheaderid as iv1vhid from egf_instrumentvoucher iv1 group by iv1.voucherheaderid) as table1  where ph.voucherheaderid=misbill.payvhid and ph.voucherheaderid=vh.id and vmis.voucherheaderid= vh.id and vh.status =" + approvedstatus + " " + sql + "  and IV.VOUCHERHEADERID IS NOT  NULL  and iv.instrumentheaderid=table1.maxihid and table1.iv1vhid=vh.id and  ih.id_status not in (" + statusId + ")  and vh.type='" + "Payment" + "' and vh.name ='" + "Salary Bill Payment" + "' group by vh.id,vh.voucherNumber,vh.voucherDate,misbill.paidto order by vh.voucherNumber ").addScalar("voucherid", (Type)BigDecimalType.INSTANCE).addScalar("voucherNumber").addScalar("voucherDate").addScalar("paidAmount", (Type)BigDecimalType.INSTANCE).addScalar("chequeDate").addScalar("paidTo").setResultTransformer(Transformers.aliasToBean(ChequeAssignment.class));
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)(" for salary " + query));
                }
                chequeAssignmentList.addAll(query.list());
                tempChequeAssignmentList = chequeAssignmentList;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)(" interating  " + tempChequeAssignmentList.size() + " times"));
                }
                for (int i = 0; i < tempChequeAssignmentList.size(); ++i) {
                    for (int j = i + 1; j < tempChequeAssignmentList.size(); ++j) {
                        if (!tempChequeAssignmentList.get(j).getVoucherid().equals(tempChequeAssignmentList.get(i).getVoucherid()) || !tempChequeAssignmentList.get(j).getVoucherNumber().equals(tempChequeAssignmentList.get(i).getVoucherNumber())) continue;
                        Float paidAmt = Float.valueOf(tempChequeAssignmentList.get(i).getPaidAmount().floatValue());
                        paidAmt = Float.valueOf(paidAmt.floatValue() + tempChequeAssignmentList.get(j).getPaidAmount().floatValue());
                        tempChequeAssignmentList.get(i).setPaidAmount(new BigDecimal(paidAmt.floatValue()));
                        String paidTo = tempChequeAssignmentList.get(i).getPaidTo();
                        String nextPaidTo = tempChequeAssignmentList.get(j).getPaidTo();
                        tempChequeAssignmentList.get(i).setPaidTo(paidTo + " , " + nextPaidTo);
                        tempChequeAssignmentList.remove(j);
                        --j;
                    }
                }
                if (tempChequeAssignmentList.size() != chequeAssignmentList.size()) {
                    chequeAssignmentList = tempChequeAssignmentList;
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)(" interating  " + tempChequeAssignmentList.size() + " Done"));
                }
            } else if (voucherHeader.getName() != null && voucherHeader.getName().equalsIgnoreCase("Pension Bill Payment")) {
                query = this.getSession().createSQLQuery("select vh.id as voucherid ,vh.voucherNumber as voucherNumber ,vh.voucherDate as voucherDate,sum(misbill.paidamount) as paidAmount,current_date as chequeDate,  misbill.paidto as paidTo from Paymentheader ph,voucherheader vh  LEFT JOIN EGF_INSTRUMENTVOUCHER IV ON VH.ID=IV.VOUCHERHEADERID LEFT JOIN EGF_INSTRUMENTHEADER IH ON IV.INSTRUMENTHEADERID=IH.ID  ,vouchermis vmis, Miscbilldetail misbill  where ph.voucherheaderid=misbill.payvhid and ph.voucherheaderid=vh.id and vmis.voucherheaderid= vh.id and vh.status =" + approvedstatus + " " + sql + "  and  IV.VOUCHERHEADERID IS NULL  and vh.type='" + "Payment" + "' and vh.name ='" + "Pension Bill Payment" + "' group by vh.id,vh.voucherNumber,vh.voucherDate,misbill.paidto order by vh.voucherNumber ").addScalar("voucherid", (Type)BigDecimalType.INSTANCE).addScalar("voucherNumber").addScalar("voucherDate").addScalar("paidAmount", (Type)BigDecimalType.INSTANCE).addScalar("chequeDate").addScalar("paidTo").setResultTransformer(Transformers.aliasToBean(ChequeAssignment.class));
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)(" for salary " + query));
                }
                chequeAssignmentList = query.list();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"checking  cheque assigned and surrendard");
                }
                query = this.getSession().createSQLQuery("select vh.id as voucherid ,vh.voucherNumber as voucherNumber ,vh.voucherDate as voucherDate,sum(misbill.paidamount) as paidAmount,current_date as chequeDate,  misbill.paidto as paidTo from Paymentheader ph,voucherheader vh  LEFT JOIN EGF_INSTRUMENTVOUCHER IV ON VH.ID=IV.VOUCHERHEADERID LEFT JOIN EGF_INSTRUMENTHEADER IH ON IV.INSTRUMENTHEADERID=IH.ID  ,vouchermis vmis, Miscbilldetail misbill , (select max(iv1.instrumentheaderid) as maxihid,iv1.voucherheaderid as iv1vhid from egf_instrumentvoucher iv1 group by iv1.voucherheaderid) as table1  where ph.voucherheaderid=misbill.payvhid and ph.voucherheaderid=vh.id and vmis.voucherheaderid= vh.id and vh.status =" + approvedstatus + " " + sql + "  and IV.VOUCHERHEADERID IS NOT  NULL  and iv.instrumentheaderid=table1.maxihid and table1.iv1vhid=vh.id and  ih.id_status not in (" + statusId + ")  and vh.type='" + "Payment" + "' and vh.name ='" + "Pension Bill Payment" + "' group by vh.id,vh.voucherNumber,vh.voucherDate,misbill.paidto order by vh.voucherNumber ").addScalar("voucherid", (Type)BigDecimalType.INSTANCE).addScalar("voucherNumber").addScalar("voucherDate").addScalar("paidAmount", (Type)BigDecimalType.INSTANCE).addScalar("chequeDate").addScalar("paidTo").setResultTransformer(Transformers.aliasToBean(ChequeAssignment.class));
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)(" for salary " + query));
                }
                chequeAssignmentList.addAll(query.list());
                tempChequeAssignmentList = chequeAssignmentList;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)(" interating  " + tempChequeAssignmentList.size() + " times"));
                }
                for (int i = 0; i < tempChequeAssignmentList.size(); ++i) {
                    for (int j = i + 1; j < tempChequeAssignmentList.size(); ++j) {
                        if (!tempChequeAssignmentList.get(j).getVoucherid().equals(tempChequeAssignmentList.get(i).getVoucherid()) || !tempChequeAssignmentList.get(j).getVoucherNumber().equals(tempChequeAssignmentList.get(i).getVoucherNumber())) continue;
                        Float paidAmt = Float.valueOf(tempChequeAssignmentList.get(i).getPaidAmount().floatValue());
                        paidAmt = Float.valueOf(paidAmt.floatValue() + tempChequeAssignmentList.get(j).getPaidAmount().floatValue());
                        tempChequeAssignmentList.get(i).setPaidAmount(new BigDecimal(paidAmt.floatValue()));
                        String paidTo = tempChequeAssignmentList.get(i).getPaidTo();
                        String nextPaidTo = tempChequeAssignmentList.get(j).getPaidTo();
                        tempChequeAssignmentList.get(i).setPaidTo(paidTo + " , " + nextPaidTo);
                        tempChequeAssignmentList.remove(j);
                        --j;
                    }
                }
                if (tempChequeAssignmentList.size() != chequeAssignmentList.size()) {
                    chequeAssignmentList = tempChequeAssignmentList;
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)(" interating  " + tempChequeAssignmentList.size() + " Done"));
                }
            } else if (voucherHeader.getName() == null || !voucherHeader.getName().equalsIgnoreCase("Remittance Payment")) {
                query = this.getSession().createSQLQuery("select vh.id as voucherid ,vh.voucherNumber as voucherNumber ,vh.voucherDate as voucherDate,sum(misbill.paidamount) as paidAmount,current_date as chequeDate from Paymentheader ph,voucherheader vh   LEFT JOIN EGF_INSTRUMENTVOUCHER IV ON VH.ID=IV.VOUCHERHEADERID LEFT JOIN EGF_INSTRUMENTHEADER IH ON IV.INSTRUMENTHEADERID=IH.ID,vouchermis vmis, Miscbilldetail misbill  where ph.voucherheaderid=misbill.payvhid and ph.voucherheaderid=vh.id and vmis.voucherheaderid= vh.id and vh.status =" + approvedstatus + " " + sql + "  and  IV.VOUCHERHEADERID IS NULL  and vh.type='" + "Payment" + "' and vh.name NOT IN  ('" + "Remittance Payment" + "' , '" + "Salary Bill Payment" + "','" + "Pension Bill Payment" + "')  group by vh.id,vh.voucherNumber,vh.voucherDate order by vh.voucherNumber ").addScalar("voucherid", (Type)BigDecimalType.INSTANCE).addScalar("voucherNumber").addScalar("voucherDate").addScalar("paidAmount", (Type)BigDecimalType.INSTANCE).addScalar("chequeDate").setResultTransformer(Transformers.aliasToBean(ChequeAssignment.class));
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)(" for non salary and remittance" + query));
                }
                chequeAssignmentList = query.list();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"checking  cheque assigned and surrendard");
                }
                query = this.getSession().createSQLQuery("select vh.id as voucherid ,vh.voucherNumber as voucherNumber ,vh.voucherDate as voucherDate,sum(misbill.paidamount) as paidAmount,current_date as chequeDate from Paymentheader ph,voucherheader vh   LEFT JOIN EGF_INSTRUMENTVOUCHER IV ON VH.ID=IV.VOUCHERHEADERID LEFT JOIN EGF_INSTRUMENTHEADER IH ON IV.INSTRUMENTHEADERID=IH.ID,vouchermis vmis, Miscbilldetail misbill , (select max(iv1.instrumentheaderid) as maxihid,iv1.voucherheaderid as iv1vhid from egf_instrumentvoucher iv1 group by iv1.voucherheaderid) as table1  where ph.voucherheaderid=misbill.payvhid and ph.voucherheaderid=vh.id and vmis.voucherheaderid= vh.id and vh.status =" + approvedstatus + " " + sql + "  and  IV.VOUCHERHEADERID IS NOT  NULL and iv.instrumentheaderid=table1.maxihid and  table1.iv1vhid=vh.id and ih.id_status not in (" + statusId + ") and vh.type='" + "Payment" + "' and vh.name NOT IN ('" + "Remittance Payment" + "' , '" + "Salary Bill Payment" + "','" + "Pension Bill Payment" + "')  group by vh.id,vh.voucherNumber,vh.voucherDate order by vh.voucherNumber ").addScalar("voucherid", (Type)BigDecimalType.INSTANCE).addScalar("voucherNumber").addScalar("voucherDate").addScalar("paidAmount", (Type)BigDecimalType.INSTANCE).addScalar("chequeDate").setResultTransformer(Transformers.aliasToBean(ChequeAssignment.class));
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)(" for non salary and remittance" + query));
                }
                chequeAssignmentList.addAll(query.list());
            } else {
                query = this.getSession().createSQLQuery("select vh.id as voucherid ,vh.voucherNumber as voucherNumber ,vh.voucherDate as voucherDate,sum(misbill.paidamount) as paidAmount,current_date as chequeDate,misbill.paidto as paidTo from Paymentheader ph,voucherheader vh  LEFT JOIN EGF_INSTRUMENTVOUCHER IV ON VH.ID=IV.VOUCHERHEADERID LEFT JOIN EGF_INSTRUMENTHEADER IH ON IV.INSTRUMENTHEADERID=IH.ID,vouchermis vmis, Miscbilldetail misbill,Eg_remittance  rem  where ph.voucherheaderid=misbill.payvhid and  rem.paymentvhid=vh.id and rem.tdsid=" + parameters.get("recoveryId")[0] + "  and ph.voucherheaderid=vh.id and vmis.voucherheaderid= vh.id and vh.status =" + approvedstatus + " " + sql + "  and IV.VOUCHERHEADERID IS NULL  and vh.type='" + "Payment" + "' and vh.name ='" + "Remittance Payment" + "' group by vh.id,vh.voucherNumber,vh.voucherDate,misbill.paidto order by vh.voucherNumber ").addScalar("voucherid", (Type)BigDecimalType.INSTANCE).addScalar("voucherNumber").addScalar("voucherDate").addScalar("paidAmount", (Type)BigDecimalType.INSTANCE).addScalar("chequeDate").addScalar("paidTo").setResultTransformer(Transformers.aliasToBean(ChequeAssignment.class));
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)(" for salary and remittance" + query));
                }
                chequeAssignmentList = query.list();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"checking  cheque assigned and surrendard");
                }
                query = this.getSession().createSQLQuery("select vh.id as voucherid ,vh.voucherNumber as voucherNumber ,vh.voucherDate as voucherDate,sum(misbill.paidamount) as paidAmount,current_date as chequeDate,misbill.paidto as paidTo from Paymentheader ph,voucherheader vh  LEFT JOIN EGF_INSTRUMENTVOUCHER IV ON VH.ID=IV.VOUCHERHEADERID LEFT JOIN EGF_INSTRUMENTHEADER IH ON IV.INSTRUMENTHEADERID=IH.ID,vouchermis vmis, Miscbilldetail misbill,Eg_remittance  rem , (select max(iv1.instrumentheaderid) as maxihid,iv1.voucherheaderid as iv1vhid from egf_instrumentvoucher iv1 group by iv1.voucherheaderid) table1 where ph.voucherheaderid=misbill.payvhid and  rem.paymentvhid=vh.id and rem.tdsid=" + parameters.get("recoveryId")[0] + "  and ph.voucherheaderid=vh.id and vmis.voucherheaderid= vh.id and vh.status =" + approvedstatus + " " + sql + "  and  IV.VOUCHERHEADERID IS NOT  NULL  and iv.instrumentheaderid=table1.maxihid and table1.iv1vhid=vh.id and ih.id_status not in (" + statusId + ") and vh.type='" + "Payment" + "' and vh.name ='" + "Remittance Payment" + "' group by vh.id,vh.voucherNumber,vh.voucherDate,misbill.paidto order by vh.voucherNumber ").addScalar("voucherid", (Type)BigDecimalType.INSTANCE).addScalar("voucherNumber").addScalar("voucherDate").addScalar("paidAmount", (Type)BigDecimalType.INSTANCE).addScalar("chequeDate").addScalar("paidTo").setResultTransformer(Transformers.aliasToBean(ChequeAssignment.class));
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)(" for salary and remittance" + query));
                }
                chequeAssignmentList.addAll(query.list());
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed getPaymentVoucherNotInInstrument.");
        }
        return chequeAssignmentList;
    }

    private Map getSubledgerAmtForDeduction(Long payVhId) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting getSubledgerAmtForDeduction...");
        }
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        SQLQuery query = this.getSession().createSQLQuery(" select gld.detailtypeid,gld.detailkeyid,sum(gld.amount) from generalledgerdetail gld,generalledger gl, voucherheader vh, miscbilldetail misbill  where vh.id= gl.voucherheaderid and gl.id=gld.generalledgerid and gl.creditamount>0 and gl.glcodeid NOT in (:glcodeIdList) and misbill.billvhid=vh.id  and misbill.payvhid =" + payVhId + " group by gld.detailtypeid,gld.detailkeyid ");
        query.setParameterList("glcodeIdList", this.cBillGlcodeIdList);
        List list = query.list();
        if (list != null && !list.isEmpty()) {
            for (Object[] ob : list) {
                map.put(ob[0].toString() + DELIMETER + ob[1].toString(), (BigDecimal)ob[2]);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed getSubledgerAmtForDeduction.");
        }
        return map;
    }

    @Transactional
    public List<InstrumentHeader> createInstrument(List<ChequeAssignment> chequeAssignmentList, String paymentMode, Integer bankaccount, Map<String, String[]> parameters, Department dept) throws ApplicationRuntimeException, Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting createInstrument...");
        }
        ArrayList<InstrumentHeader> instHeaderList = new ArrayList();
        ArrayList<Long> selectedPaymentVHList = new ArrayList<Long>();
        HashMap<String, BigDecimal> payeeMap = new HashMap<String, BigDecimal>();
        BigDecimal totalPaidAmt = BigDecimal.ZERO;
        for (ChequeAssignment assignment : chequeAssignmentList) {
            if (!assignment.getIsSelected()) continue;
            selectedPaymentVHList.add(assignment.getVoucherid());
            if (payeeMap.containsKey(assignment.getPaidTo() + DELIMETER + assignment.getDetailtypeid() + DELIMETER + assignment.getDetailkeyid())) {
                payeeMap.put(assignment.getPaidTo() + DELIMETER + assignment.getDetailtypeid() + DELIMETER + assignment.getDetailkeyid(), ((BigDecimal)payeeMap.get(assignment.getPaidTo() + DELIMETER + assignment.getDetailtypeid() + DELIMETER + assignment.getDetailkeyid())).add(assignment.getPaidAmount()));
            } else {
                payeeMap.put(assignment.getPaidTo() + DELIMETER + assignment.getDetailtypeid() + DELIMETER + assignment.getDetailkeyid(), assignment.getPaidAmount());
            }
            totalPaidAmt = totalPaidAmt.add(assignment.getPaidAmount());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("selectedPaymentList===" + selectedPaymentVHList));
        }
        Bankaccount account = (Bankaccount)this.persistenceService.find(" from Bankaccount where  id=?", new Object[]{bankaccount.longValue()});
        List voucherList = this.persistenceService.findAllByNamedQuery("getVoucherList", new Object[]{selectedPaymentVHList});
        ArrayList<Map<String, Object>> instrumentHeaderList = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> instrumentVoucherList = new ArrayList<Map<String, Object>>();
        if (paymentMode.equals("cheque")) {
            HashMap<Long, CVoucherHeader> paymentVoucherMap = new HashMap<Long, CVoucherHeader>();
            for (CVoucherHeader voucherHeader : voucherList) {
                paymentVoucherMap.put(voucherHeader.getId(), voucherHeader);
            }
            if (this.isChequeNoGenerationAuto()) {
                String chequeNo = this.chequeService.nextChequeNumber(account.getId().toString(), payeeMap.size(), dept.getId().intValue());
                String[] chequeNoArray = StringUtils.split((String)chequeNo, (String)",");
                HashMap<String, String> chequeNoMap = new HashMap<String, String>();
                Iterator iterator = payeeMap.keySet().iterator();
                int i = 0;
                while (iterator.hasNext()) {
                    String key = iterator.next().toString();
                    instrumentHeaderList.add(this.prepareInstrumentHeader(account, chequeNoArray[i], "cheque".toLowerCase(), key.split(DELIMETER)[0], (BigDecimal)payeeMap.get(key), this.currentDate, key, null));
                    chequeNoMap.put(key, chequeNoArray[i]);
                    ++i;
                }
                instHeaderList = this.instrumentService.addToInstrument(instrumentHeaderList);
                for (ChequeAssignment assignment : chequeAssignmentList) {
                    if (!assignment.getIsSelected()) continue;
                    instrumentVoucherList.add(this.preapreInstrumentVoucher((CVoucherHeader)paymentVoucherMap.get(assignment.getVoucherid()), account, (String)chequeNoMap.get(assignment.getPaidTo() + DELIMETER + assignment.getDetailtypeid() + DELIMETER + assignment.getDetailkeyid()), assignment.getPaidTo()));
                }
                this.instVoucherList = this.instrumentService.updateInstrumentVoucherReference(instrumentVoucherList);
            } else {
                String text = EMPTY_STRING;
                HashMap<String, BigDecimal> partyChequeNoMap = new HashMap<String, BigDecimal>();
                for (ChequeAssignment assignment : chequeAssignmentList) {
                    if (!assignment.getIsSelected()) continue;
                    text = assignment.getPaidTo() + DELIMETER + assignment.getDetailtypeid() + DELIMETER + assignment.getDetailkeyid() + DELIMETER + assignment.getChequeNumber() + DELIMETER + this.formatter.format(assignment.getChequeDate()) + DELIMETER + assignment.getSerialNo();
                    if (partyChequeNoMap.containsKey(text)) {
                        partyChequeNoMap.put(text, ((BigDecimal)partyChequeNoMap.get(text)).add(assignment.getPaidAmount()));
                        continue;
                    }
                    partyChequeNoMap.put(text, assignment.getPaidAmount());
                }
                Iterator iterator = partyChequeNoMap.keySet().iterator();
                while (iterator.hasNext()) {
                    String key = iterator.next().toString();
                    instrumentHeaderList.add(this.prepareInstrumentHeader(account, key.split(DELIMETER)[3], "cheque".toLowerCase(), key.split(DELIMETER)[0], (BigDecimal)partyChequeNoMap.get(key), this.formatter.parse(key.split(DELIMETER)[4]), key, key.split(DELIMETER)[5]));
                }
                instHeaderList = this.instrumentService.addToInstrument(instrumentHeaderList);
                for (ChequeAssignment assignment : chequeAssignmentList) {
                    if (!assignment.getIsSelected()) continue;
                    instrumentVoucherList.add(this.preapreInstrumentVoucher((CVoucherHeader)paymentVoucherMap.get(assignment.getVoucherid()), account, assignment.getChequeNumber(), assignment.getPaidTo(), assignment.getSerialNo()));
                }
                this.instVoucherList = this.instrumentService.updateInstrumentVoucherReference(instrumentVoucherList);
            }
        } else {
            if (paymentMode.equals("rtgs")) {
                instrumentHeaderList.add(this.prepareInstrumentHeaderForRtgs(account, parameters.get("rtgsRefNo")[0], totalPaidAmt, this.formatter.parse(parameters.get("rtgsDate")[0]), EMPTY_STRING));
            } else if (this.isChequeNoGenerationAuto()) {
                String chequeNo = this.chequeService.nextChequeNumber(account.getId().toString(), 1, dept.getId().intValue());
                instrumentHeaderList.add(this.prepareInstrumentHeader(account, chequeNo, "cheque".toLowerCase(), parameters.get("inFavourOf")[0], totalPaidAmt, this.currentDate, EMPTY_STRING, null));
            } else {
                instrumentHeaderList.add(this.prepareInstrumentHeader(account, parameters.get("chequeNo")[0], "cheque".toLowerCase(), parameters.get("inFavourOf")[0], totalPaidAmt, this.formatter.parse(parameters.get("chequeDt")[0]), EMPTY_STRING, parameters.get("serialNo")[0]));
            }
            instHeaderList = this.instrumentService.addToInstrument(instrumentHeaderList);
            List paymentList = this.persistenceService.findAllByNamedQuery("getPaymentList", new Object[]{selectedPaymentVHList});
            HashMap<String, Object> instrumentVoucherMap = null;
            for (Paymentheader paymentheader : paymentList) {
                instrumentVoucherMap = new HashMap<String, Object>();
                instrumentVoucherMap.put("Voucher header", paymentheader.getVoucherheader());
                instrumentVoucherMap.put("Instrument header", instHeaderList.get(0));
                instrumentVoucherList.add(instrumentVoucherMap);
            }
            this.instVoucherList = this.instrumentService.updateInstrumentVoucherReference(instrumentVoucherList);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed createInstrument.");
        }
        return instHeaderList;
    }

    @Transactional
    public List<InstrumentHeader> reassignInstrument(List<ChequeAssignment> chequeAssignmentList, String paymentMode, Integer bankaccount, Map<String, String[]> parameters, Department dept) throws ApplicationRuntimeException, Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting reassignInstrument...");
        }
        ArrayList<InstrumentHeader> instHeaderList = new ArrayList<InstrumentHeader>();
        ArrayList<Long> selectedPaymentVHList = new ArrayList<Long>();
        HashMap<String, BigDecimal> payeeMap = new HashMap<String, BigDecimal>();
        BigDecimal totalPaidAmt = BigDecimal.ZERO;
        for (ChequeAssignment assignment : chequeAssignmentList) {
            if (!assignment.getIsSelected()) continue;
            selectedPaymentVHList.add(assignment.getVoucherid());
            if (payeeMap.containsKey(assignment.getPaidTo() + DELIMETER + assignment.getDetailtypeid() + DELIMETER + assignment.getDetailkeyid())) {
                payeeMap.put(assignment.getPaidTo() + DELIMETER + assignment.getDetailtypeid() + DELIMETER + assignment.getDetailkeyid(), ((BigDecimal)payeeMap.get(assignment.getPaidTo() + DELIMETER + assignment.getDetailtypeid() + DELIMETER + assignment.getDetailkeyid())).add(assignment.getPaidAmount()));
            } else {
                payeeMap.put(assignment.getPaidTo() + DELIMETER + assignment.getDetailtypeid() + DELIMETER + assignment.getDetailkeyid(), assignment.getPaidAmount());
            }
            totalPaidAmt = totalPaidAmt.add(assignment.getPaidAmount());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("selectedPaymentList===" + selectedPaymentVHList));
        }
        Bankaccount account = (Bankaccount)this.persistenceService.find(" from Bankaccount where  id=?", new Object[]{bankaccount});
        List voucherList = this.persistenceService.findAllByNamedQuery("getVoucherList", new Object[]{selectedPaymentVHList});
        new ArrayList();
        ArrayList<Map<String, Object>> instrumentVoucherList = new ArrayList<Map<String, Object>>();
        if (paymentMode.equals("cheque")) {
            HashMap<Long, CVoucherHeader> paymentVoucherMap = new HashMap<Long, CVoucherHeader>();
            for (CVoucherHeader voucherHeader : voucherList) {
                paymentVoucherMap.put(voucherHeader.getId(), voucherHeader);
            }
            String text = EMPTY_STRING;
            HashMap<String, BigDecimal> partyChequeNoMap = new HashMap<String, BigDecimal>();
            for (ChequeAssignment assignment : chequeAssignmentList) {
                if (!assignment.getIsSelected()) continue;
                text = assignment.getPaidTo() + DELIMETER + assignment.getDetailtypeid() + DELIMETER + assignment.getDetailkeyid() + DELIMETER + assignment.getChequeNumber() + DELIMETER + this.formatter.format(assignment.getChequeDate()) + DELIMETER + assignment.getSerialNo();
                if (partyChequeNoMap.containsKey(text)) {
                    partyChequeNoMap.put(text, ((BigDecimal)partyChequeNoMap.get(text)).add(assignment.getPaidAmount()));
                    continue;
                }
                partyChequeNoMap.put(text, assignment.getPaidAmount());
            }
            instHeaderList = new ArrayList();
            Iterator iterator = partyChequeNoMap.keySet().iterator();
            while (iterator.hasNext()) {
                String key = iterator.next().toString();
                instHeaderList.add(this.reassignInstrumentHeader(account, key.split(DELIMETER)[3], "cheque".toLowerCase(), key.split(DELIMETER)[0], (BigDecimal)partyChequeNoMap.get(key), this.formatter.parse(key.split(DELIMETER)[4]), key, key.split(DELIMETER)[5]));
            }
            for (ChequeAssignment assignment : chequeAssignmentList) {
                if (!assignment.getIsSelected()) continue;
                instrumentVoucherList.add(this.reassignInstrumentVoucher((CVoucherHeader)paymentVoucherMap.get(assignment.getVoucherid()), account, assignment.getChequeNumber(), assignment.getPaidTo(), assignment.getSerialNo()));
            }
            this.instVoucherList = this.instrumentService.updateInstrumentVoucherReference(instrumentVoucherList);
        } else {
            instHeaderList.add(this.reassignInstrumentHeader(account, parameters.get("chequeNo")[0], "cheque".toLowerCase(), parameters.get("inFavourOf")[0], totalPaidAmt, this.formatter.parse(parameters.get("chequeDt")[0]), EMPTY_STRING, parameters.get("serialNo")[0]));
            this.reassignInstrumentVoucher(null, account, parameters.get("chequeNo")[0], parameters.get("inFavourOf")[0], parameters.get("serialNo")[0]);
            List paymentList = this.persistenceService.findAllByNamedQuery("getPaymentList", new Object[]{selectedPaymentVHList});
            HashMap<String, Object> instrumentVoucherMap = null;
            for (Paymentheader paymentheader : paymentList) {
                instrumentVoucherMap = new HashMap<String, Object>();
                instrumentVoucherMap.put("Voucher header", paymentheader.getVoucherheader());
                instrumentVoucherMap.put("Instrument header", instHeaderList.get(0));
                instrumentVoucherList.add(instrumentVoucherMap);
            }
            this.instVoucherList = this.instrumentService.updateInstrumentVoucherReference(instrumentVoucherList);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed reassignInstrument.");
        }
        return instHeaderList;
    }

    protected Map<String, Object> prepareInstrumentHeader(Bankaccount account, String chqNo, String instType, String partyName, BigDecimal amount, Date date, String key, String serialNo) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting prepareInstrumentHeader...");
        }
        HashMap<String, Object> instrumentHeaderMap = new HashMap<String, Object>();
        instrumentHeaderMap.put("Is pay cheque", "1");
        instrumentHeaderMap.put("Instrument type", instType);
        instrumentHeaderMap.put("Instrument amount", amount);
        instrumentHeaderMap.put("Instrument number", chqNo);
        instrumentHeaderMap.put("Instrument serialNo", serialNo);
        instrumentHeaderMap.put("Instrument date", date);
        instrumentHeaderMap.put("Bank code", account.getBankbranch().getBank().getCode());
        instrumentHeaderMap.put("Pay to", partyName);
        instrumentHeaderMap.put("Bank account id", account.getId());
        if (!key.equals(EMPTY_STRING)) {
            if (key.split(DELIMETER)[1] != null && !key.split(DELIMETER)[1].equals(EMPTY_STRING) && !key.split(DELIMETER)[1].equals("null")) {
                instrumentHeaderMap.put("Detail type id", Integer.valueOf(key.split(DELIMETER)[1]));
            }
            if (key.split(DELIMETER)[2] != null && !key.split(DELIMETER)[2].equals(EMPTY_STRING) && !key.split(DELIMETER)[2].equals("null")) {
                instrumentHeaderMap.put("Detail key id", Long.valueOf(key.split(DELIMETER)[2]));
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed prepareInstrumentHeader.");
        }
        return instrumentHeaderMap;
    }

    protected Map<String, Object> prepareInstrumentHeaderForRtgs(Bankaccount account, String txnNo, BigDecimal amount, Date date, String key) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting prepareInstrumentHeaderForRtgs...");
        }
        HashMap<String, Object> instrumentHeaderMap = new HashMap<String, Object>();
        instrumentHeaderMap.put("Is pay cheque", "1");
        instrumentHeaderMap.put("Instrument type", "advice");
        instrumentHeaderMap.put("Instrument amount", amount);
        instrumentHeaderMap.put("Transaction number", txnNo);
        instrumentHeaderMap.put("Transaction date", date);
        instrumentHeaderMap.put("Bank code", account.getBankbranch().getBank().getCode());
        instrumentHeaderMap.put("Bank account id", account.getId());
        if (!key.equals(EMPTY_STRING)) {
            if (key.split(DELIMETER)[1] != null && !key.split(DELIMETER)[1].equals(EMPTY_STRING) && !key.split(DELIMETER)[1].equals("null")) {
                instrumentHeaderMap.put("Detail type id", Integer.valueOf(key.split(DELIMETER)[1]));
            }
            if (key.split(DELIMETER)[2] != null && !key.split(DELIMETER)[2].equals(EMPTY_STRING) && !key.split(DELIMETER)[2].equals("null")) {
                instrumentHeaderMap.put("Detail key id", Long.valueOf(key.split(DELIMETER)[2]));
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed prepareInstrumentHeaderForRtgs.");
        }
        return instrumentHeaderMap;
    }

    @Transactional
    public InstrumentHeader reassignInstrumentHeader(Bankaccount account, String chqNo, String instType, String partyName, BigDecimal amount, Date date, String key, String serialNo) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting reassignInstrumentHeader...");
        }
        InstrumentHeader ih = (InstrumentHeader)((Object)this.persistenceService.find("from InstrumentHeader where instrumentNumber=? and bankAccountId=? and isPayCheque=1 ", new Object[]{chqNo, account}));
        ih.setIsPayCheque("1");
        ih.setInstrumentAmount(amount);
        ih.setSerialNo(this.financialYearDAO.findById((Number)Long.valueOf(serialNo), false));
        ih.setInstrumentDate(date);
        ih.setPayTo(partyName);
        ih.setBankAccountId(account);
        ih.setSurrendarReason(null);
        ih.setStatusId(this.instrumentService.getStatusId("New"));
        if (!key.equals(EMPTY_STRING)) {
            if (key.split(DELIMETER)[1] != null && !key.split(DELIMETER)[1].equals(EMPTY_STRING) && !key.split(DELIMETER)[1].equals("null")) {
                ih.setDetailTypeId((Accountdetailtype)this.persistenceService.find("from Accountdetailtype where id=?", new Object[]{Integer.valueOf(key.split(DELIMETER)[1])}));
            }
            if (key.split(DELIMETER)[2] != null && !key.split(DELIMETER)[2].equals(EMPTY_STRING) && !key.split(DELIMETER)[2].equals("null")) {
                ih.setDetailKeyId(Long.valueOf(key.split(DELIMETER)[2]));
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed reassignInstrumentHeader.");
        }
        return (InstrumentHeader)((Object)this.instrumentHeaderService.persist((Object)ih));
    }

    protected Map<String, Object> preapreInstrumentVoucher(CVoucherHeader voucherHeader, Bankaccount account, String chqNo, String paidTo, String serialno) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting preapreInstrumentVoucher...");
        }
        HashMap<String, Object> instrumentVoucherMap = new HashMap<String, Object>();
        instrumentVoucherMap.put("Voucher header", voucherHeader);
        InstrumentHeader instrumentHeader = this.instrumentService.getInstrumentHeader(account.getId(), chqNo, paidTo, serialno);
        instrumentVoucherMap.put("Instrument header", (Object)instrumentHeader);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed preapreInstrumentVoucher.");
        }
        return instrumentVoucherMap;
    }

    protected Map<String, Object> preapreInstrumentVoucher(CVoucherHeader voucherHeader, Bankaccount account, String chqNo, String paidTo) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting preapreInstrumentVoucher...");
        }
        HashMap<String, Object> instrumentVoucherMap = new HashMap<String, Object>();
        instrumentVoucherMap.put("Voucher header", voucherHeader);
        InstrumentHeader instrumentHeader = this.instrumentService.getInstrumentHeader((long)account.getId(), chqNo, paidTo);
        instrumentVoucherMap.put("Instrument header", (Object)instrumentHeader);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed preapreInstrumentVoucher.");
        }
        return instrumentVoucherMap;
    }

    @Transactional
    public Map<String, Object> reassignInstrumentVoucher(CVoucherHeader voucherHeader, Bankaccount account, String chqNo, String paidTo, String serailNo) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting reassignInstrumentVoucher...");
        }
        InstrumentHeader instrumentHeader = this.instrumentService.getInstrumentHeader(account.getId(), chqNo, paidTo, serailNo);
        List findAllBy = this.persistenceService.findAllBy("from InstrumentVoucher where instrumentHeaderId=?", new Object[]{instrumentHeader});
        for (InstrumentVoucher iv : findAllBy) {
            this.persistenceService.delete((Object)iv);
        }
        this.getSession().refresh((Object)instrumentHeader);
        this.getSession().flush();
        HashMap<String, Object> instrumentVoucherMap = new HashMap<String, Object>();
        instrumentVoucherMap.put("Voucher header", voucherHeader);
        instrumentVoucherMap.put("Instrument header", (Object)instrumentHeader);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed reassignInstrumentVoucher.");
        }
        return instrumentVoucherMap;
    }

    public List<PaymentBean> getCSList(List<EgBillregister> billList, Map<Long, BigDecimal> deductionAmtMap, Map<Long, BigDecimal> paidAmtMap) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting getCSList...");
        }
        ArrayList<PaymentBean> contractorList = new ArrayList<PaymentBean>();
        PaymentBean paymentBean = null;
        if (billList != null && !billList.isEmpty()) {
            for (EgBillregister billregister : billList) {
                String region;
                paymentBean = new PaymentBean();
                paymentBean.setCsBillId(billregister.getId());
                paymentBean.setBillNumber(billregister.getBillnumber());
                paymentBean.setBillDate(billregister.getBilldate());
                paymentBean.setExpType(billregister.getExpendituretype());
                if (billregister.getExpendituretype().equals("Expense")) {
                    if (billregister.getEgBillregistermis().getEgBillSubType() != null) {
                        if (billregister.getEgBillregistermis().getEgBillSubType().getName().equalsIgnoreCase("TNEB")) {
                            paymentBean.setPayTo(billregister.getEgBillregistermis().getPayto());
                        } else {
                            paymentBean.setPayTo(this.getPayeeNameForCBill(billregister));
                        }
                    } else {
                        paymentBean.setPayTo(this.getPayeeNameForCBill(billregister));
                    }
                } else {
                    paymentBean.setPayTo(billregister.getEgBillregistermis().getPayto());
                }
                paymentBean.setDeductionAmt(deductionAmtMap.get(paymentBean.getCsBillId()) == null ? BigDecimal.ZERO : deductionAmtMap.get(paymentBean.getCsBillId()));
                BigDecimal passedamount = billregister.getPassedamount() == null ? BigDecimal.ZERO : billregister.getPassedamount().setScale(2, 6);
                paymentBean.setNetAmt(passedamount.subtract(paymentBean.getDeductionAmt() == null ? BigDecimal.ZERO : paymentBean.getDeductionAmt()));
                paymentBean.setEarlierPaymentAmt(paidAmtMap.get(paymentBean.getCsBillId()) == null ? BigDecimal.ZERO : paidAmtMap.get(paymentBean.getCsBillId()));
                paymentBean.setPayableAmt(paymentBean.getNetAmt().subtract(paymentBean.getEarlierPaymentAmt()));
                paymentBean.setPaymentAmt(paymentBean.getPayableAmt());
                if (paymentBean.getPaymentAmt().compareTo(BigDecimal.ZERO) == 0) continue;
                if (billregister.getEgBillregistermis().getFund() != null) {
                    paymentBean.setFundName(billregister.getEgBillregistermis().getFund().getName());
                }
                if (billregister.getEgBillregistermis().getEgDepartment() != null) {
                    paymentBean.setDeptName(billregister.getEgBillregistermis().getEgDepartment().getName());
                }
                if (billregister.getEgBillregistermis().getScheme() != null) {
                    paymentBean.setSchemeName(billregister.getEgBillregistermis().getScheme().getName());
                }
                if (billregister.getEgBillregistermis().getSubScheme() != null) {
                    paymentBean.setSubschemeName(billregister.getEgBillregistermis().getSubScheme().getName());
                }
                if (billregister.getEgBillregistermis().getFunctionaryid() != null) {
                    paymentBean.setFunctionaryName(billregister.getEgBillregistermis().getFunctionaryid().getName());
                }
                if (billregister.getEgBillregistermis().getFunction() != null) {
                    paymentBean.setFunctionName(billregister.getEgBillregistermis().getFunction().getName());
                }
                if (billregister.getEgBillregistermis().getFundsource() != null) {
                    paymentBean.setFundsourceName(billregister.getEgBillregistermis().getFundsource().getName());
                }
                if (billregister.getEgBillregistermis().getFieldid() != null) {
                    paymentBean.setFieldName(billregister.getEgBillregistermis().getFieldid().getName());
                }
                if (billregister.getEgBillregistermis().getVoucherHeader() != null) {
                    paymentBean.setBillVoucherNumber(billregister.getEgBillregistermis().getVoucherHeader().getVoucherNumber());
                    paymentBean.setBillVoucherDate(billregister.getEgBillregistermis().getVoucherHeader().getVoucherDate());
                }
                if (billregister.getEgBillregistermis().getEgBillSubType() != null && billregister.getEgBillregistermis().getEgBillSubType().getName().equalsIgnoreCase("TNEB") && (region = (String)this.persistenceService.find("select region from EBDetails where egBillregister.id = ?", new Object[]{billregister.getId()})) != null) {
                    paymentBean.setRegion(region);
                }
                contractorList.add(paymentBean);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed getCSList.");
        }
        return contractorList;
    }

    public String getPayeeNameForCBill(EgBillregister bill) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting getPayeeNameForCBill...");
        }
        List obj = null;
        String payeeName = EMPTY_STRING;
        obj = this.persistenceService.findAllByNamedQuery("getPayeeDetailsForPayableCode", new Object[]{bill.getId(), this.cBillGlcodeIdList});
        payeeName = obj == null || obj.size() == 0 ? ((obj = this.persistenceService.findAllByNamedQuery("getPayeeDetailsForDebitCode", new Object[]{bill.getId()})) == null || obj.size() == 0 ? bill.getEgBillregistermis().getPayto() : (obj.size() > 1 ? "MULTIPLE" : bill.getEgBillregistermis().getPayto())) : (obj.size() > 1 ? "MULTIPLE" : bill.getEgBillregistermis().getPayto());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed getPayeeNameForCBill.");
        }
        return payeeName;
    }

    @Transactional
    public Paymentheader createPaymentHeader(CVoucherHeader voucherHeader, Integer bankaccountId, String type, BigDecimal amount) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting createPaymentHeader...");
        }
        Paymentheader paymentheader = new Paymentheader();
        paymentheader.setType(type);
        paymentheader.setVoucherheader(voucherHeader);
        Bankaccount bankaccount = (Bankaccount)this.getSession().load(Bankaccount.class, (Serializable)Long.valueOf(bankaccountId.longValue()));
        paymentheader.setBankaccount(bankaccount);
        paymentheader.setPaymentAmount(amount);
        this.applyAuditing((AbstractAuditable)paymentheader);
        this.create(paymentheader);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed createPaymentHeader.");
        }
        return paymentheader;
    }

    public Paymentheader getPaymentHeaderByVoucherHeaderId(Long voucherHeaderId) {
        Paymentheader paymentheader = (Paymentheader)this.persistenceService.find(" from Paymentheader where voucherheader.id=?", new Object[]{voucherHeaderId});
        return paymentheader;
    }

    public Paymentheader updatePaymentHeader(Paymentheader paymentheader, CVoucherHeader voucherHeader, Integer bankaccountId, String type, BigDecimal amount) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting updatePaymentHeader...");
        }
        paymentheader.setType(type);
        paymentheader.setVoucherheader(voucherHeader);
        Bankaccount bankaccount = (Bankaccount)this.persistenceService.find("from Bankaccount where id=?", new Object[]{bankaccountId});
        paymentheader.setBankaccount(bankaccount);
        paymentheader.setPaymentAmount(amount);
        this.persistenceService.persist((Object)paymentheader);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed updatePaymentHeader.");
        }
        return paymentheader;
    }

    public List<ChequeAssignment> getPaymentVoucherForRemittanceRTGSInstrument(Map<String, String[]> parameters, CVoucherHeader voucherHeader) throws ApplicationException, ParseException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting getPaymentVoucherNotInInstrument...");
        }
        List<ChequeAssignment> chequeAssignmentList = new ArrayList<ChequeAssignment>();
        boolean nonSubledger = false;
        StringBuffer sql = new StringBuffer();
        if (!EMPTY_STRING.equals(parameters.get("fromDate")[0])) {
            sql.append(" and vh.voucherDate>='" + this.sdf.format(this.formatter.parse(parameters.get("fromDate")[0])) + "' ");
        }
        if (!EMPTY_STRING.equals(parameters.get("toDate")[0])) {
            sql.append(" and vh.voucherDate<='" + this.sdf.format(this.formatter.parse(parameters.get("toDate")[0])) + "'");
        }
        if (!StringUtils.isEmpty((String)voucherHeader.getVoucherNumber())) {
            sql.append(" and vh.voucherNumber like '%" + voucherHeader.getVoucherNumber() + "%'");
        }
        if (voucherHeader.getFundId() != null) {
            sql.append(" and vh.fundId=" + voucherHeader.getFundId().getId());
        }
        if (voucherHeader.getVouchermis().getFundsource() != null) {
            sql.append(" and vmis.fundsourceId=" + voucherHeader.getVouchermis().getFundsource().getId());
        }
        if (voucherHeader.getVouchermis().getDepartmentid() != null) {
            sql.append(" and vmis.departmentid=" + voucherHeader.getVouchermis().getDepartmentid().getId());
        }
        if (voucherHeader.getVouchermis().getSchemeid() != null) {
            sql.append(" and vmis.schemeid=" + voucherHeader.getVouchermis().getSchemeid().getId());
        }
        if (voucherHeader.getVouchermis().getSubschemeid() != null) {
            sql.append(" and vmis.subschemeid=" + voucherHeader.getVouchermis().getSubschemeid().getId());
        }
        if (voucherHeader.getVouchermis().getFunctionary() != null) {
            sql.append(" and vmis.functionaryid=" + voucherHeader.getVouchermis().getFunctionary().getId());
        }
        if (voucherHeader.getVouchermis().getDivisionid() != null) {
            sql.append(" and vmis.divisionid=" + voucherHeader.getVouchermis().getDivisionid().getId());
        }
        if (parameters.get("bankaccount") != null && !parameters.get("bankaccount")[0].equals("-1")) {
            sql.append(" and ph.bankaccountnumberid=" + parameters.get("bankaccount")[0]);
            sql.append(" and lower(ph.type)=lower('" + parameters.get("paymentMode")[0] + "')");
            sql.append(" and ph.bankaccountnumberid=ba.id");
        } else {
            sql.append(" and ph.bankaccountnumberid=ba.id").append(" and lower(ph.type)=lower('" + parameters.get("paymentMode")[0] + "')");
        }
        if (!"0".equals(parameters.get("drawingOfficerId")[0])) {
            sql.append(" and ph.drawingofficer_id = " + new Long(parameters.get("drawingOfficerId")[0]));
        }
        if (!EMPTY_STRING.equals(parameters.get("recoveryId")[0])) {
            Recovery recovery = (Recovery)((Object)this.persistenceService.find("from Recovery where id=?", new Object[]{new Long(parameters.get("recoveryId")[0])}));
            if (recovery.getChartofaccounts().getChartOfAccountDetails().isEmpty()) {
                nonSubledger = true;
            }
            sql.append(" and gl.glcodeid = " + recovery.getChartofaccounts().getId());
        } else {
            sql.append(" and gl.glcodeid in (select distinct glcodeid from tds where remittance_mode='A')");
        }
        sql.append(" and vmis.departmentid     =dept.id  ");
        List appList = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "APPROVEDVOUCHERSTATUS");
        String approvedstatus = ((AppConfigValues)appList.get(0)).getValue();
        ArrayList<String> descriptionList = new ArrayList<String>();
        descriptionList.add("New");
        descriptionList.add("Reconciled");
        List egwStatusList = this.egwStatusDAO.getStatusListByModuleAndCodeList("Instrument", descriptionList);
        String statusId = EMPTY_STRING;
        for (EgwStatus egwStatus : egwStatusList) {
            statusId = statusId + egwStatus.getId() + ",";
        }
        statusId = statusId.substring(0, statusId.length() - 1);
        this.persistenceService.find(" from Bankaccount where id=?", new Object[]{Long.valueOf(parameters.get("bankaccount")[0])});
        Query query = null;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("statusId -- > " + statusId));
        }
        this.chequeList = new ArrayList<ChequeAssignment>();
        if (voucherHeader.getName() == null || !voucherHeader.getName().equalsIgnoreCase("Remittance Payment")) {
            if (nonSubledger) {
                query = this.getSession().createSQLQuery(" select  vh.id as voucherid ,vh.voucherNumber as voucherNumber , dept.name   AS departmentName, vh.voucherDate as voucherDate,  recovery.remitted as paidTo,sum(misbill.paidamount) as paidAmount,current_date as chequeDate , ba.accountnumber   AS bankAccNumber, ba.id  AS bankAccountId , gl.glcodeid as glcodeId, CONCAT(CONCAT(DO.name,'/'),do.tan) AS drawingOfficerNameTAN  from Paymentheader ph, eg_department dept, bankaccount ba, voucherheader vh   LEFT JOIN  EGF_INSTRUMENTVOUCHER IV ON VH.ID=IV.VOUCHERHEADERID LEFT JOIN EGF_INSTRUMENTHEADER IH ON IV.INSTRUMENTHEADERID=IH.ID, vouchermis vmis, Miscbilldetail misbill ,generalledger gl,eg_drawingofficer do,tds recovery where recovery.type = '" + parameters.get("recoveryCode")[0] + "' and ph.voucherheaderid=misbill.payvhid and ph.voucherheaderid=vh.id and vmis.voucherheaderid= vh.id  and vh.id= gl.voucherheaderid and ph.drawingofficer_id= do.id  and vh.status =" + approvedstatus + " " + sql + "  and  IV.VOUCHERHEADERID IS NULL  and vh.type='" + "Payment" + "'  and vh.name = '" + "Remittance Payment" + "'  group by vh.id,  vh.voucherNumber,  dept.name ,  vh.voucherDate,misbill.paidto,  ba.accountnumber, ba.id , gl.glcodeid,DO.name,do.tan,recovery.remitted  order by ba.id,dept.name,vh.voucherNumber ").addScalar("voucherid", (Type)BigDecimalType.INSTANCE).addScalar("voucherNumber").addScalar("departmentName").addScalar("voucherDate").addScalar("paidTo").addScalar("paidAmount", (Type)BigDecimalType.INSTANCE).addScalar("chequeDate").addScalar("bankAccNumber").addScalar("bankAccountId", (Type)BigDecimalType.INSTANCE).addScalar("glcodeId", (Type)BigDecimalType.INSTANCE).addScalar("drawingOfficerNameTAN").setResultTransformer(Transformers.aliasToBean(ChequeAssignment.class));
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)(" for non salary and remittance" + query));
                }
                chequeAssignmentList = query.list();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"checking  cheque assigned and surrendard");
                }
                query = this.getSession().createSQLQuery("select vh.id as voucherid ,vh.voucherNumber as voucherNumber , dept.name   AS departmentName, vh.voucherDate as voucherDate, recovery.remitted as paidTo ,sum(misbill.paidamount) as paidAmount,current_date as chequeDate , ba.accountnumber AS bankAccNumber  , ba.id  AS bankAccountId ,  gl.glcodeid as glcodeId, CONCAT(CONCAT(DO.name,'/'),do.tan) AS drawingOfficerNameTAN  from Paymentheader ph,eg_department dept, bankaccount ba, generalledger gl,eg_drawingofficer do, voucherheader vh   LEFT  JOIN EGF_INSTRUMENTVOUCHER IV ON VH.ID=IV.VOUCHERHEADERID LEFT JOIN EGF_INSTRUMENTHEADER IH  ON IV.INSTRUMENTHEADERID=IH.ID,vouchermis vmis, Miscbilldetail misbill,tds recovery,(select max(iv1.instrumentheaderid) as maxihid,iv1.voucherheaderid as iv1vhid from egf_instrumentvoucher iv1 group by iv1.voucherheaderid) as table1  where recovery.type = '" + parameters.get("recoveryCode")[0] + "' and  ph.voucherheaderid=misbill.payvhid and ph.voucherheaderid=vh.id and vmis.voucherheaderid= vh.id  and vh.status =" + approvedstatus + " " + sql + "  and  IV.VOUCHERHEADERID IS NOT  NULL and iv.instrumentheaderid=table1.maxihid  and  table1.iv1vhid=vh.id and ih.id_status not in (" + statusId + ")  and vh.type='" + "Payment" + "' and vh.name = '" + "Remittance Payment" + "' and vh.id= gl.voucherheaderid  and ph.drawingofficer_id= do.id  group by   vh.id,  vh.voucherNumber,  dept.name ,  vh.voucherDate,misbill.paidto,ba.accountnumber, ba.id , gl.glcodeid,DO.name,do.tan,recovery.remitted  order by ba.id,dept.name,vh.voucherNumber ").addScalar("voucherid", (Type)BigDecimalType.INSTANCE).addScalar("voucherNumber").addScalar("departmentName").addScalar("voucherDate").addScalar("paidTo").addScalar("paidAmount", (Type)BigDecimalType.INSTANCE).addScalar("chequeDate").addScalar("bankAccNumber").addScalar("bankAccountId", (Type)BigDecimalType.INSTANCE).addScalar("glcodeId", (Type)BigDecimalType.INSTANCE).addScalar("drawingOfficerNameTAN").setResultTransformer(Transformers.aliasToBean(ChequeAssignment.class));
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)(" Surrendered rtgs nos" + query));
                }
                chequeAssignmentList.addAll(query.list());
            } else {
                query = this.getSession().createSQLQuery(" select  vh.id as voucherid ,vh.voucherNumber as voucherNumber , dept.name   AS departmentName, vh.voucherDate as voucherDate, misbill.paidto as paidTo,sum(misbill.paidamount) as paidAmount,current_date as chequeDate , ba.accountnumber   AS bankAccNumber, ba.id  AS bankAccountId , gl.glcodeid as glcodeId, CONCAT(CONCAT(DO.name,'/'),do.tan) AS drawingOfficerNameTAN  from Paymentheader ph, eg_department dept, bankaccount ba, voucherheader vh   LEFT JOIN  EGF_INSTRUMENTVOUCHER IV ON VH.ID=IV.VOUCHERHEADERID LEFT JOIN EGF_INSTRUMENTHEADER IH ON IV.INSTRUMENTHEADERID=IH.ID, vouchermis vmis, Miscbilldetail misbill ,  generalledgerdetail gld,generalledger gl,eg_drawingofficer do where ph.voucherheaderid=misbill.payvhid and ph.voucherheaderid=vh.id and vmis.voucherheaderid= vh.id  and vh.id= gl.voucherheaderid and gl.id=gld.generalledgerid and ph.drawingofficer_id= do.id  and vh.status =" + approvedstatus + " " + sql + "  and  IV.VOUCHERHEADERID IS NULL  and vh.type='" + "Payment" + "'  and vh.name = '" + "Remittance Payment" + "'  group by vh.id,  vh.voucherNumber,  dept.name ,  vh.voucherDate,misbill.paidto,  ba.accountnumber, ba.id , gl.glcodeid,DO.name,do.tan  order by ba.id,dept.name,vh.voucherNumber ").addScalar("voucherid", (Type)BigDecimalType.INSTANCE).addScalar("voucherNumber").addScalar("departmentName").addScalar("voucherDate").addScalar("paidTo").addScalar("paidAmount", (Type)BigDecimalType.INSTANCE).addScalar("chequeDate").addScalar("bankAccNumber").addScalar("bankAccountId").addScalar("glcodeId").addScalar("drawingOfficerNameTAN").setResultTransformer(Transformers.aliasToBean(ChequeAssignment.class));
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)(" for non salary and remittance" + query));
                }
                chequeAssignmentList = query.list();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"checking  cheque assigned and surrendard");
                }
                query = this.getSession().createSQLQuery("select vh.id as voucherid ,vh.voucherNumber as voucherNumber , dept.name   AS departmentName, vh.voucherDate as voucherDate, misbill.paidto as         paidTo ,sum(misbill.paidamount) as paidAmount,current_date as chequeDate , ba.accountnumber AS bankAccNumber  , ba.id  AS bankAccountId ,  gl.glcodeid as glcodeId, CONCAT(CONCAT(DO.name,'/'),do.tan) AS drawingOfficerNameTAN  from Paymentheader ph,eg_department dept, bankaccount ba, generalledgerdetail gld,generalledger gl,eg_drawingofficer do, voucherheader vh   LEFT  JOIN EGF_INSTRUMENTVOUCHER IV ON VH.ID=IV.VOUCHERHEADERID LEFT JOIN EGF_INSTRUMENTHEADER IH  ON IV.INSTRUMENTHEADERID=IH.ID,vouchermis vmis, Miscbilldetail misbill ,(select max(iv1.instrumentheaderid) as maxihid,iv1.voucherheaderid as iv1vhid from egf_instrumentvoucher iv1 group by iv1.voucherheaderid) as table1 where ph.voucherheaderid=misbill.payvhid and ph.voucherheaderid=vh.id and vmis.voucherheaderid= vh.id  and vh.status =" + approvedstatus + " " + sql + "  and  IV.VOUCHERHEADERID IS NOT  NULL and iv.instrumentheaderid=table1.maxihid  and  table1.iv1vhid=vh.id and ih.id_status not in (" + statusId + ")  and vh.type='" + "Payment" + "' and vh.name = '" + "Remittance Payment" + "' and vh.id= gl.voucherheaderid and gl.id=gld.generalledgerid  and gl.glcodeid in (select distinct glcodeid from tds where remittance_mode='A') and ph.drawingofficer_id= do.id  group by   vh.id,  vh.voucherNumber,  dept.name ,  vh.voucherDate,misbill.paidto,ba.accountnumber, ba.id , gl.glcodeid,DO.name,do.tan  order by ba.id,dept.name,vh.voucherNumber ").addScalar("voucherid", (Type)BigDecimalType.INSTANCE).addScalar("voucherNumber").addScalar("departmentName").addScalar("voucherDate").addScalar("paidTo").addScalar("paidAmount", (Type)BigDecimalType.INSTANCE).addScalar("chequeDate").addScalar("bankAccNumber").addScalar("bankAccountId", (Type)BigDecimalType.INSTANCE).addScalar("glcodeId", (Type)BigDecimalType.INSTANCE).addScalar("drawingOfficerNameTAN").setResultTransformer(Transformers.aliasToBean(ChequeAssignment.class));
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)(" Surrendered rtgs nos" + query));
                }
                chequeAssignmentList.addAll(query.list());
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed getPaymentVoucherNotInInstrument.");
        }
        return chequeAssignmentList;
    }

    @SkipValidation
    public List getPayeeDetailsForExpenseBill(Map<String, String[]> parameters, CVoucherHeader voucherHeader) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Inside getPayeeDetailsForExpenseBill...");
        }
        return new ArrayList();
    }

    public int backUpdateRemittanceDateInGL(Long paymentVoucherId) {
        String sql = "update   generalledger set remittancedate=null where remittancedate is  not null and  id in (select generalledgerid from generalledgerdetail where id in (select gldtlid from eg_remittance_gldtl where  id in (select remittancegldtlid from eg_remittance_detail where remittanceid in (select id from eg_remittance where paymentvhid=" + paymentVoucherId + "))))";
        int count = this.getSession().createSQLQuery(sql).executeUpdate();
        if (count == 0) {
            String sql1 = " update generalledger set remittancedate = null where id in  (select generalledgerid from eg_remittance_detail where remittanceid in  (select id from eg_remittance where paymentvhid =" + paymentVoucherId + "))";
            count = this.getSession().createSQLQuery(sql1).executeUpdate();
        }
        return count;
    }

    public Position getSuperiourPositionByPosition() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Inside getSuperiourPositionByPosition...");
        }
        return this.eisCommonService.getSuperiorPositionByObjectTypeAndPositionFrom(this.objectTypeService.getObjectTypeByName("Payment").getId(), this.getPosition().getId());
    }

    public Position getPosition() throws ApplicationRuntimeException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Inside getPosition...");
        }
        return this.eisCommonService.getPositionByUserId(ApplicationThreadLocals.getUserId());
    }

    public String getFunctionaryAndDesignation() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Inside getFunctionaryAndDesignation...");
        }
        Assignment assignment = this.getAssignment();
        return assignment.getFunctionary().getName() + "-" + assignment.getDesignation().getName();
    }

    public Assignment getAssignment() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Inside getAssignment...");
        }
        return this.eisCommonService.getLatestAssignmentForEmployeeByToDate(ApplicationThreadLocals.getUserId(), new Date());
    }

    public Position getPositionForEmployee(Employee emp) throws ApplicationRuntimeException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Inside getPositionForEmployee...");
        }
        return this.eisCommonService.getPrimaryAssignmentPositionForEmp(emp.getId());
    }

    public PersonalInformation getEmpForCurrentUser() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Inside getEmpForCurrentUser...");
        }
        return this.eisCommonService.getEmployeeByUserId(ApplicationThreadLocals.getUserId());
    }

    public String getEmployeeNameForPositionId(Position pos) throws ApplicationRuntimeException {
        Assignment assignment = (Assignment)this.assignmentService.getAssignmentsForPosition(Long.valueOf(pos.getId()), new Date()).get(0);
        return assignment.getEmployee().getName() + " (" + assignment.getDesignation().getName() + ")";
    }

    public void finalApproval(Long voucherid) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Inside finalApproval...");
        }
        this.billsAccountingService.createVoucherfromPreApprovedVoucher(voucherid);
    }

    public void setBillsAccountingService(BillsAccountingService billsAccountingService) {
        this.billsAccountingService = billsAccountingService;
    }

    public void setEisCommonService(EisCommonService eisCommonService) {
        this.eisCommonService = eisCommonService;
    }

    public void setInstrumentService(InstrumentService instrumentService) {
        this.instrumentService = instrumentService;
    }

    public void setChequeService(ChequeService chequeService) {
        this.chequeService = chequeService;
    }

    public List<InstrumentVoucher> getInstVoucherList() {
        return this.instVoucherList;
    }

    public void setInstVoucherList(List<InstrumentVoucher> instVoucherList) {
        this.instVoucherList = instVoucherList;
    }

    public FundFlowService getFundFlowService() {
        return this.fundFlowService;
    }

    public void setFundFlowService(FundFlowService fundFlowService) {
        this.fundFlowService = fundFlowService;
    }

    public void setChequeAssignmentService(ChequeAssignmentService chequeAssignmentService) {
        this.chequeAssignmentService = chequeAssignmentService;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public VoucherService getVoucherService() {
        return this.voucherService;
    }

    public void setVoucherService(VoucherService voucherService) {
        this.voucherService = voucherService;
    }

    public CreateVoucher getCreateVoucher() {
        return this.createVoucher;
    }

    public void setCreateVoucher(CreateVoucher createVoucher) {
        this.createVoucher = createVoucher;
    }
}

