/*
 * Decompiled with CFR 0.152.
 */
package org.egov.services.masters;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.egov.commons.Bank;
import org.egov.infstr.services.PersistenceService;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class BankService
extends PersistenceService<Bank, Integer> {
    public static final String BANK_BRANCH_ID = "bankBranchId";
    public static final String BANK_BRANCH_NAME = "bankBranchName";
    public static final String FUND_ID = "fundId";

    public BankService() {
        super(Bank.class);
    }

    public BankService(Class<Bank> type) {
        super(type);
    }

    public List<Map<String, Object>> getPaymentApprovedBankAndBranchName(Integer fundId, Date asOnDate) {
        ArrayList<Map<String, Object>> bankBranches = new ArrayList<Map<String, Object>>();
        ArrayList<String> addedBanks = new ArrayList<String>();
        for (Object[] account : this.fetchBankAndBranchNameHasApprovedPayment(fundId, asOnDate)) {
            String bankBranchName = account[1].toString();
            if (addedBanks.contains(bankBranchName)) continue;
            addedBanks.add(bankBranchName);
            HashMap<String, String> bankBrmap = new HashMap<String, String>();
            bankBrmap.put(BANK_BRANCH_ID, account[0].toString());
            bankBrmap.put(BANK_BRANCH_NAME, bankBranchName);
            bankBranches.add(bankBrmap);
        }
        return bankBranches;
    }

    public List<Map<String, Object>> getChequeAssignedBankAndBranchName(Date asOnDate) {
        ArrayList<Map<String, Object>> bankBranches = new ArrayList<Map<String, Object>>();
        for (Object[] element : this.fetchBankAndBankBranchWithAssignedCheques(asOnDate)) {
            HashMap<String, String> bankBrmap = new HashMap<String, String>();
            bankBrmap.put(BANK_BRANCH_ID, element[0].toString());
            bankBrmap.put(BANK_BRANCH_NAME, element[1].toString());
            bankBranches.add(bankBrmap);
        }
        return bankBranches;
    }

    public List<Map<String, Object>> getRTGSAssignedBankAndBranchName(Date asOnDate) {
        List<Object[]> bankBranch = this.fetchBankAndBranchNameWithRTGSAssigned(asOnDate);
        ArrayList<Map<String, Object>> bankBranches = new ArrayList<Map<String, Object>>();
        for (Object[] element : bankBranch) {
            HashMap<String, String> bankBrmap = new HashMap<String, String>();
            bankBrmap.put(BANK_BRANCH_ID, element[0].toString());
            bankBrmap.put(BANK_BRANCH_NAME, element[1].toString());
            bankBranches.add(bankBrmap);
        }
        return bankBranches;
    }

    public List<Map<String, Object>> getAllBankAndBranchName(Integer fundId) {
        ArrayList<Map<String, Object>> bankBranchList = new ArrayList<Map<String, Object>>();
        for (Object[] element : this.fetchAllBankAndBankbranchName(fundId)) {
            HashMap<String, String> bankBrmap = new HashMap<String, String>();
            bankBrmap.put(BANK_BRANCH_ID, element[0].toString());
            bankBrmap.put(BANK_BRANCH_NAME, element[1].toString());
            bankBranchList.add(bankBrmap);
        }
        return bankBranchList;
    }

    public List<Map<String, Object>> getBankByFundAndType(Integer fundId, String typeOfAccount) {
        ArrayList<Map<String, Object>> bankBranchList = new ArrayList<Map<String, Object>>();
        for (Object[] element : this.fetchBankByFundAndTypeOfAccount(fundId, typeOfAccount)) {
            HashMap<String, String> bankBrmap = new HashMap<String, String>();
            bankBrmap.put(BANK_BRANCH_ID, element[0].toString());
            bankBrmap.put(BANK_BRANCH_NAME, element[1].toString());
            bankBranchList.add(bankBrmap);
        }
        return bankBranchList;
    }

    private List<Object[]> fetchBankByFundAndTypeOfAccount(Integer fundId, String typeOfAccount) {
        StringBuilder query = new StringBuilder();
        query.append("select DISTINCT concat(concat(bank.id,'-'),bankBranch.id) as bankbranchid,concat(concat(bank.name,' '),bankBranch.branchname) as bankbranchname ").append("FROM Bank bank,Bankbranch bankBranch,Bankaccount bankaccount where  bank.isactive=true  and bankBranch.isactive=true and ").append(" bankaccount.isactive=true and bank.id = bankBranch.bank.id and bankBranch.id = bankaccount.bankbranch.id ");
        if (fundId != null) {
            query.append("and bankaccount.fund.id=:fundId and bankaccount.type in(");
        } else {
            query.append("and bankaccount.type in(");
        }
        if (typeOfAccount.indexOf(44) != -1) {
            String[] strArray = typeOfAccount.split(",");
            int index = 0;
            for (String type : strArray) {
                query.append("'").append(type).append("'");
                if (strArray.length <= ++index) continue;
                query.append(",");
            }
        } else {
            query.append("'").append(typeOfAccount).append("') order by 2 ");
        }
        List bankBranch = fundId != null ? this.getSession().createQuery(query.toString()).setInteger(FUND_ID, fundId.intValue()).list() : this.getSession().createQuery(query.toString()).list();
        return bankBranch;
    }

    private List<Object[]> fetchAllBankAndBankbranchName(Integer fundId) {
        StringBuilder query = new StringBuilder();
        query.append("select DISTINCT concat(concat(bank.id,'-'),bankBranch.id) as bankbranchid,concat(concat(bank.name,' '),bankBranch.branchname) as bankbranchname ").append(" FROM Bank bank,Bankbranch bankBranch,Bankaccount bankaccount  where  bank.isactive=true  and bankBranch.isactive=true and bankaccount.isactive=true ").append("and bank.id = bankBranch.bank.id and bankBranch.id = bankaccount.bankbranch.id and bankaccount.fund.id=:fundId order by 2");
        return this.getSession().createSQLQuery(query.toString()).setInteger(FUND_ID, fundId.intValue()).list();
    }

    private List<Object[]> fetchBankAndBranchNameWithRTGSAssigned(Date asOnDate) {
        StringBuilder vouchersWithNewInstrumentsQuery = new StringBuilder().append("select voucherheaderid from egf_instrumentvoucher eiv,egf_instrumentheader ih,").append(" egw_status egws where eiv.instrumentheaderid=ih.id and egws.id=ih.id_status and egws.moduletype='Instrument' and egws.description='New' and ").append(" ih.transactionNumber is not null");
        StringBuilder queryString = new StringBuilder();
        queryString = queryString.append("select DISTINCT concat(concat(bank.id,'-'),bankBranch.id) as bankbranchid,concat(concat(bank.name,' '),").append("bankBranch.branchname) as bankbranchname from  voucherheader vh,Bank bank,Bankbranch bankBranch,Bankaccount bankaccount, ").append(" paymentheader ph where  ph.voucherheaderid=vh.id and vh.id  in (").append((CharSequence)vouchersWithNewInstrumentsQuery).append(") and bank.isactive=true  and bankBranch.isactive=true ").append(" and  bank.id = bankBranch.bankid and bankBranch.id = bankaccount.BRANCHID and bankaccount.type in ('RECEIPTS_PAYMENTS','PAYMENTS') and vh.voucherdate <= :date").append(" and ph.bankaccountnumberid=bankaccount.id  and bankaccount.isactive=true order by 2");
        return this.getSession().createSQLQuery(queryString.toString()).setParameter("date", (Object)asOnDate).list();
    }

    private List<Object[]> fetchBankAndBankBranchWithAssignedCheques(Date asOnDate) {
        StringBuilder vouchersWithNewInstrumentsQuery = new StringBuilder().append("select voucherheaderid from egf_instrumentvoucher eiv,egf_instrumentheader ih,").append(" egw_status egws where eiv.instrumentheaderid=ih.id and egws.id=ih.id_status and egws.moduletype='Instrument' and egws.description='New' ");
        StringBuilder queryString = new StringBuilder();
        queryString.append("select DISTINCT concat(concat(bank.id,'-'),bankBranch.id) as bankbranchid,concat(concat(bank.name,' '),").append("bankBranch.branchname) as bankbranchname from  voucherheader vh,Bank bank,Bankbranch bankBranch,Bankaccount bankaccount, ").append(" paymentheader ph where ph.voucherheaderid=vh.id and vh.id  in (").append(vouchersWithNewInstrumentsQuery.toString()).append(") and bank.isactive=true  and bankBranch.isactive=true ").append(" and  bank.id = bankBranch.bankid and bankBranch.id = bankaccount.BRANCHID and bankaccount.type in ('RECEIPTS_PAYMENTS','PAYMENTS') and vh.voucherdate <= :date").append(" and ph.bankaccountnumberid=bankaccount.id  and bankaccount.isactive=true order by 2");
        return this.getSession().createSQLQuery(queryString.toString()).setParameter("date", (Object)asOnDate).list();
    }

    private List<Object[]> fetchBankAndBranchNameHasApprovedPayment(Integer fundId, Date asOnDate) {
        StringBuilder queryString = new StringBuilder();
        queryString.append("select distinct concat(concat(bank.id,'-'),bankBranch.id) as bankbranchid,concat(concat(bank.name,' '),").append(" bankBranch.branchname) as bankbranchname  from Bank bank,  Bankbranch bankBranch,   Bankaccount bankaccount where bankaccount.id in ( ").append(" select DISTINCT ph.bankaccountnumberid from  paymentheader ph,egf_instrumentvoucher iv right outer join voucherheader vh on ").append(" vh.id =iv.VOUCHERHEADERID where ph.voucherheaderid=vh.id  and  vh.status=0  and ").append(" ph.voucherheaderid=vh.id  and iv.VOUCHERHEADERID is null ");
        if (fundId != null && fundId > 0) {
            queryString.append(" and vh.fundid=:fundId");
        }
        queryString.append(" and vh.name NOT IN ( '").append("Remittance Payment").append("','").append("Salary Bill Payment").append("') ").append("and vh.voucherdate <= :asOnDate ) AND bank.id = bankBranch.bankid AND bank.isactive=true AND bankBranch.isactive=true ").append("AND bankaccount.type IN ('RECEIPTS_PAYMENTS','PAYMENTS') AND bankBranch.id = bankaccount.branchid");
        if (fundId != null && fundId > 0) {
            queryString.append(" and bankaccount.fundid=:fundId");
        }
        queryString.append(" union select distinct concat(concat(bank.id,'-'),bankBranch.id) as bankbranchid,concat(concat(bank.name,' '),").append("bankBranch.branchname) as bankbranchname from Bank bank,  Bankbranch bankBranch,   Bankaccount bankaccount where bankaccount.id in ( ").append(" select DISTINCT ph.bankaccountnumberid from egf_instrumentvoucher iv,voucherheader vh,").append(" paymentheader ph,egw_status egws,(select ih1.id,ih1.id_status from egf_instrumentheader ih1, ").append("(select bankid,bankaccountid,instrumentnumber,max(id) as id from egf_instrumentheader group by bankid,bankaccountid,").append("instrumentnumber) max_rec where max_rec.bankid=ih1.bankid and max_rec.bankaccountid=ih1.bankaccountid and max_rec.instrumentnumber=ih1.instrumentnumber ").append(" and max_rec.id=ih1.id) ih where ph.voucherheaderid=vh.id and vh.status=0  and ph.voucherheaderid=vh.id and iv.voucherheaderid=vh.id and iv.instrumentheaderid=ih.id and ").append("ih.id_status=egws.id and egws.description in  ('Surrendered','Surrender_For_Reassign')");
        if (fundId != null && fundId > 0) {
            queryString.append(" and vh.fundid=:fundId");
        }
        queryString.append("  and vh.voucherdate <= :asOnDate and vh.name NOT IN ( '").append("Remittance Payment").append("','").append("Salary Bill Payment").append("' ) ) ").append(" AND bank.id = bankBranch.bankid AND bank.isactive=true AND bankBranch.isactive=true ").append("AND bankaccount.type IN ('RECEIPTS_PAYMENTS','PAYMENTS') AND bankBranch.id = bankaccount.branchid");
        if (fundId != null && fundId > 0) {
            queryString.append(" and bankaccount.fundid=:fundId");
        }
        return this.getSession().createSQLQuery(queryString.toString()).setInteger(FUND_ID, fundId.intValue()).setDate("asOnDate", asOnDate).list();
    }
}

