/*
 * Decompiled with CFR 0.152.
 */
package org.egov.services.budget;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.eis.entity.Assignment;
import org.egov.eis.entity.Employee;
import org.egov.eis.service.EisCommonService;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.infra.workflow.service.WorkflowService;
import org.egov.infstr.services.PersistenceService;
import org.egov.infstr.utils.EGovConfig;
import org.egov.model.budget.Budget;
import org.egov.model.budget.BudgetDetail;
import org.egov.model.budget.BudgetGroup;
import org.egov.pims.commons.Position;
import org.egov.pims.model.PersonalInformation;
import org.hibernate.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.transaction.annotation.Transactional;

public class BudgetService
extends PersistenceService<Budget, Long> {
    private static final Logger LOGGER = Logger.getLogger(BudgetService.class);
    @Autowired
    protected EisCommonService eisCommonService;
    protected WorkflowService<Budget> budgetWorkflowService;
    @Autowired
    @Qualifier(value="workflowService")
    protected SimpleWorkflowService<BudgetDetail> budgetDetailWorkflowService;
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    private EgwStatusHibernateDAO egwStatusDAO;

    public void setEisCommonService(EisCommonService eisCommonService) {
        this.eisCommonService = eisCommonService;
    }

    public BudgetService() {
        super(Budget.class);
    }

    public BudgetService(Class<Budget> type) {
        super(type);
    }

    public Budget getByName(String name) {
        return (Budget)((Object)this.find("from Budget b where b.name = ?", new Object[]{name}));
    }

    public User getUser() {
        return (User)this.find(" from User where id=?", new Object[]{ApplicationThreadLocals.getUserId()});
    }

    public Position getPositionForEmployee(Employee emp) throws ApplicationRuntimeException {
        return this.eisCommonService.getPrimaryAssignmentPositionForEmp(emp.getId());
    }

    public Department getDepartmentForBudget(Budget budget) throws ApplicationRuntimeException {
        Department dept = null;
        List detailList = this.findAllBy("from  BudgetDetail budgetDetail where budgetDetail.budget=?", new Object[]{budget});
        if (detailList.isEmpty() || detailList.size() == 0) {
            throw new ApplicationRuntimeException("Details not found for the Budget" + budget.getName());
        }
        if (((BudgetDetail)((Object)detailList.get(0))).getExecutingDepartment() == null) {
            throw new ApplicationRuntimeException("Department not found for the Budget" + budget.getName());
        }
        dept = ((BudgetDetail)((Object)detailList.get(0))).getExecutingDepartment();
        return dept;
    }

    public Department depertmentForEmployee(Employee emp) {
        Department dept = null;
        Date currDate = new Date();
        try {
            Assignment empAssignment = this.eisCommonService.getLatestAssignmentForEmployeeByToDate(emp.getId(), currDate);
            dept = empAssignment.getDepartment();
            return dept;
        }
        catch (NullPointerException ne) {
            throw new ApplicationRuntimeException(ne.getMessage());
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("Error while getting Department fort the employee" + emp.getName());
        }
    }

    public boolean hasReForYear(Long financialYear) {
        return this.checkForRe("from  Budget where financialYear.id=? and isbere='RE' and isActiveBudget=true", financialYear);
    }

    public boolean hasApprovedBeForYear(Long financialYear) {
        return this.checkForRe("from  Budget where financialYear.id=? and isbere='BE' and isActiveBudget=true and parent is null and isPrimaryBudget=true and status.code='Approved'", financialYear);
    }

    public boolean hasApprovedReForYear(Long financialYear) {
        return this.checkForRe("from  Budget where financialYear.id=? and isbere='RE' and isActiveBudget=true and parent is null and isPrimaryBudget=true and status.code='Approved'", financialYear);
    }

    public boolean hasApprovedReAsonDate(Long finYearId, Date budgetApprovedDate) {
        Query qry = this.getSearchSession().createQuery("select name from  Budget where financialYear.id=:finYearId and isbere='RE' and isActiveBudget=true and parent is null and isPrimaryBudget=true and status.code='Approved' and to_date(state.createdDate)<=:budgetApprovedDate");
        qry.setParameter("finYearId", (Object)finYearId);
        qry.setParameter("budgetApprovedDate", (Object)budgetApprovedDate);
        String approvedBudgetName = (String)qry.uniqueResult();
        return approvedBudgetName != null;
    }

    private boolean checkForRe(String query, Long financialYear) {
        Budget budget = (Budget)((Object)this.find(query, new Object[]{financialYear}));
        return budget != null;
    }

    public List<Budget> moveBudgetTree(Budget b, Position position) {
        List budgetsList = this.findAllBy("from Budget b where b.materializedPath like '" + b.getMaterializedPath() + ".%'", new Object[0]);
        return budgetsList;
    }

    public void moveDetailsTree(List budgetsList, Budget b, String actionName) {
        for (Object o : budgetsList) {
            Budget childBudget = (Budget)((Object)o);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Budget name " + childBudget.getName() + "moved details are ..."));
            }
            ArrayList unsavedbudgetDetailList = new ArrayList();
            for (BudgetDetail detail : unsavedbudgetDetailList) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("moveDetails" + detail.getApprovedAmount()));
                }
                this.budgetDetailWorkflowService.transition(actionName, (StateAware)detail, detail.getComment());
            }
        }
    }

    public boolean canForwardParent(Position position, Budget b) {
        Budget treeBudget = b;
        List totalCountList = this.findAllBy("from Budget where parent=? and isActiveBudget=?", new Object[]{treeBudget.getParent(), true});
        List budgetList = this.findAllBy("from Budget where state.owner=? and parent.id=? and isActiveBudget=?", new Object[]{position, treeBudget.getParent().getId(), true});
        if (totalCountList.size() == budgetList.size()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Approving Parent Budget:... " + treeBudget.getParent().getName()));
            }
            return true;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Still some ChildBudgets are pending to  move  Parent .Exiting.... ");
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<CChartOfAccounts> getAccountCodeForBudgetHead(List<BudgetGroup> bgroupList) throws ValidationException {
        if (bgroupList == null) {
            throw new ValidationException(Arrays.asList(new ValidationError("BudgetGroup List is Null", "budgetgroup.list.is.null")));
        }
        if (bgroupList.size() == 0) {
            throw new ValidationException(Arrays.asList(new ValidationError("BudgetGroup List is Empty", "budgetgroup.list.is.empty")));
        }
        ArrayList<CChartOfAccounts> coaList = new ArrayList<CChartOfAccounts>();
        Integer maxpossibleGlcodeLength = Integer.parseInt(EGovConfig.getProperty((String)"egf_config.xml", (String)"glcodeMaxLength", (String)"", (String)"AccountCode"));
        String multipleZeros = new String("00000000000000000000");
        String multipleNines = new String("99999999999999999999");
        for (BudgetGroup bdgtgrp : bgroupList) {
            if (this.find("from BudgetGroup where id = ? ", new Object[]{bdgtgrp.getId()}) != null) continue;
            throw new ValidationException(Arrays.asList(new ValidationError("BudgetGroup with id:" + bdgtgrp.getId() + " and name:" + bdgtgrp.getName() + " does not exist ", "BudgetGroup with id:" + bdgtgrp.getId() + " and name:" + bdgtgrp.getName() + " does not exist ")));
        }
        for (BudgetGroup bdgtgrp : bgroupList) {
            List clist;
            if (bdgtgrp.getMajorCode() == null) {
                String glcodeTo;
                String glcodeFrom;
                CChartOfAccounts maxCode = bdgtgrp.getMaxCode();
                CChartOfAccounts minCode = bdgtgrp.getMinCode();
                if (maxCode == null || minCode == null) throw new ValidationException(Arrays.asList(new ValidationError("Maxcode or Mincode is null also Majorcode is null for BudgetGroup:" + bdgtgrp.getName(), "maxcode.or.mincode.is.null.and.majorcode.is.null.for.budgetgroup:" + bdgtgrp.getName())));
                String maxGlcodeStr = maxCode.getGlcode();
                String minGlcodeStr = minCode.getGlcode();
                if (maxpossibleGlcodeLength.intValue() == maxGlcodeStr.length()) {
                    glcodeFrom = minGlcodeStr;
                    glcodeTo = maxGlcodeStr;
                } else {
                    glcodeFrom = minGlcodeStr + multipleZeros.substring(0, maxpossibleGlcodeLength - minGlcodeStr.length());
                    glcodeTo = maxGlcodeStr + multipleNines.substring(0, maxpossibleGlcodeLength - maxGlcodeStr.length());
                }
                String query = new String("from  CChartOfAccounts coa where cast(coa.glcode,long) between ? and ? and coa.classification = ?  and coa.isActiveForPosting=? ");
                clist = this.findAllBy(query, new Object[]{Long.parseLong(glcodeFrom), Long.parseLong(glcodeTo), 4L, 1L});
            } else {
                clist = this.findAllBy("from  CChartOfAccounts coa where coa.glcode like '" + bdgtgrp.getMajorCode().getGlcode().toString() + "%' and coa.classification = ? and coa.isActiveForPosting= ? ", new Object[]{4L, 1L});
            }
            if (clist == null || clist.size() == 0) continue;
            coaList.addAll(clist);
        }
        if (coaList.size() == 0) {
            return null;
        }
        ArrayList<CChartOfAccounts> arrayList = coaList;
        return arrayList;
    }

    public void setBudgetWorkflowService(WorkflowService<Budget> budgetWorkflowService) {
        this.budgetWorkflowService = budgetWorkflowService;
    }

    public void setBudgetDetailWorkflowService(SimpleWorkflowService<BudgetDetail> budgetDetailWorkflowService) {
        this.budgetDetailWorkflowService = budgetDetailWorkflowService;
    }

    public String getEmployeeNameAndDesignationForPosition(Position pos) throws ApplicationRuntimeException {
        Employee pi = this.eisCommonService.getPrimaryAssignmentEmployeeForPos(pos.getId());
        Assignment assignment = this.eisCommonService.getLatestAssignmentForEmployee(pi.getId());
        return pi.getName() + " (" + assignment.getDesignation().getName() + ")";
    }

    public PersonalInformation getEmpForCurrentUser() {
        return this.eisCommonService.getEmployeeByUserId(ApplicationThreadLocals.getUserId());
    }

    public Budget getReferenceBudgetFor(Budget budget) {
        Budget refBudget = null;
        try {
            refBudget = (Budget)((Object)this.find("from Budget where referenceBudget.id=?", new Object[]{budget.getId()}));
        }
        catch (Exception e) {
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
        return refBudget;
    }

    public boolean isLeaf(Budget budget) {
        List budgetList = this.findAllBy("from Budget where financialYear.id=? and id in (select parent from Budget where financialYear.id=? and parent.id=?)", new Object[]{budget.getFinancialYear().getId(), budget.getFinancialYear().getId(), budget.getId()});
        return budgetList == null || budgetList.isEmpty();
    }

    public List getFYForNonApprovedBudgets() {
        return this.findAllBy("select distinct b.financialYear from Budget b where b.status.code=!'Approved' and isActiveBudget=true and isPrimaryBudget=true order by b.financialYear.finYearRange desc", new Object[0]);
    }

    public Budget getBudget(String budgetHead, String deptCode, String budgetType, String fyear) {
        String budgetName = budgetHead.substring(0, 1).equalsIgnoreCase("1") || budgetHead.substring(0, 1).equalsIgnoreCase("2") ? deptCode + "-" + budgetType + "-Rev-" + fyear : deptCode + "-" + budgetType + "-Cap-" + fyear;
        return this.getByName(budgetName);
    }

    public List<Budget> getBudgetsForUploadReport() {
        return this.findAllBy("select distinct b from Budget b where b.name like '%RE%' and b.materializedPath  in (select distinct substring(bd.materializedPath,  1 , 1) from BudgetDetail bd where bd.status.code = 'Created')", new Object[0]);
    }

    @Transactional
    public void updateByMaterializedPath(String materializedPath) {
        EgwStatus approvedStatus = this.egwStatusDAO.getStatusByModuleAndCode("BUDGET", "Approved");
        EgwStatus createdStatus = this.egwStatusDAO.getStatusByModuleAndCode("BUDGET", "Created");
        this.persistenceService.getSession().createSQLQuery("update egf_budget set status = :approvedStatus where status =:createdStatus and  materializedPath like'" + materializedPath + "%'").setLong("approvedStatus", (long)approvedStatus.getId().intValue()).setLong("createdStatus", (long)createdStatus.getId().intValue()).executeUpdate();
    }
}

