/*
 * Decompiled with CFR 0.152.
 */
package org.egov.services.bills;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.infstr.models.EgChecklists;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.bills.EgBillregister;
import org.egov.model.voucher.WorkflowBean;
import org.egov.pims.commons.Position;
import org.egov.services.voucher.JournalVoucherActionHelper;
import org.egov.utils.CheckListHelper;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class EgBillRegisterService
extends PersistenceService<EgBillregister, Long> {
    private static final Logger LOGGER = Logger.getLogger(JournalVoucherActionHelper.class);
    private static final String FAILED = "Transaction failed";
    private static final String EXCEPTION_WHILE_SAVING_DATA = "Exception while saving data";
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    @Qualifier(value="workflowService")
    private SimpleWorkflowService<EgBillregister> billRegisterWorkflowService;
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;

    public EgBillRegisterService() {
        super(EgBillregister.class);
    }

    public EgBillRegisterService(Class<EgBillregister> type) {
        super(type);
    }

    @Transactional
    public EgBillregister createBill(EgBillregister bill, WorkflowBean workflowBean, List<CheckListHelper> checkListsTable) {
        try {
            this.applyAuditing((AbstractAuditable)bill);
            if ("Create And Approve".equalsIgnoreCase(workflowBean.getWorkFlowAction()) && bill.getState() == null) {
                bill.setBillstatus("APPROVED");
                EgwStatus egwStatus = this.egwStatusHibernateDAO.getStatusByModuleAndCode("EXPENSEBILL", "Approved");
                bill.setStatus(egwStatus);
            } else {
                bill = this.transitionWorkFlow(bill, workflowBean);
                this.applyAuditing((AbstractAuditable)bill.getState());
            }
            this.persist(bill);
            bill.getEgBillregistermis().setSourcePath("/EGF/bill/contingentBill-beforeView.action?billRegisterId=" + bill.getId().toString());
            this.createCheckList(bill, checkListsTable);
        }
        catch (Exception e) {
            e.printStackTrace();
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", e.getMessage()));
            throw new ValidationException(errors);
        }
        return bill;
    }

    @Transactional
    public void createCheckList(EgBillregister bill, List<CheckListHelper> checkListsTable) {
        try {
            if (checkListsTable != null) {
                for (CheckListHelper clh : checkListsTable) {
                    EgChecklists checkList = new EgChecklists();
                    AppConfigValues configValue = (AppConfigValues)this.persistenceService.find("from AppConfigValues where id=?", new Object[]{clh.getId()});
                    checkList.setObjectid(bill.getId());
                    checkList.setAppconfigvalue(configValue);
                    checkList.setChecklistvalue(clh.getVal());
                    this.persistenceService.getSession().saveOrUpdate((Object)checkList);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", e.getMessage()));
            throw new ValidationException(errors);
        }
    }

    @Transactional
    public EgBillregister sendForApproval(EgBillregister bill, WorkflowBean workflowBean) {
        try {
            bill = this.transitionWorkFlow(bill, workflowBean);
            this.applyAuditing((AbstractAuditable)bill.getState());
            this.persist(bill);
        }
        catch (Exception e) {
            e.printStackTrace();
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", e.getMessage()));
            throw new ValidationException(errors);
        }
        return bill;
    }

    @Transactional
    public EgBillregister transitionWorkFlow(EgBillregister billregister, WorkflowBean workflowBean) {
        DateTime currentDate = new DateTime();
        User user = this.securityUtils.getCurrentUser();
        Assignment userAssignment = (Assignment)this.assignmentService.findByEmployeeAndGivenDate(user.getId(), new Date()).get(0);
        Position pos = null;
        Assignment wfInitiator = null;
        if (null != billregister.getId()) {
            wfInitiator = this.getWorkflowInitiator(billregister);
        }
        if ("Reject".equalsIgnoreCase(workflowBean.getWorkFlowAction())) {
            if (wfInitiator.equals(userAssignment)) {
                billregister.transition(true).end().withSenderName(user.getName()).withComments(workflowBean.getApproverComments()).withDateInfo(currentDate.toDate());
            } else {
                String stateValue = "Rejected";
                billregister.transition(true).withSenderName(user.getName()).withComments(workflowBean.getApproverComments()).withStateValue("Rejected").withDateInfo(currentDate.toDate()).withOwner(wfInitiator.getPosition()).withNextAction("EOA Approval Pending");
            }
        } else if ("Approve".equalsIgnoreCase(workflowBean.getWorkFlowAction())) {
            WorkFlowMatrix wfmatrix = this.billRegisterWorkflowService.getWfMatrix(billregister.getStateType(), null, null, null, billregister.getCurrentState().getValue(), null);
            billregister.transition(true).withSenderName(user.getName()).withComments(workflowBean.getApproverComments()).withStateValue(wfmatrix.getCurrentDesignation() + " Approved").withDateInfo(currentDate.toDate()).withOwner(pos).withNextAction(wfmatrix.getNextAction());
            EgwStatus egwStatus = this.egwStatusHibernateDAO.getStatusByModuleAndCode("EXPENSEBILL", "Approved");
            billregister.setStatus(egwStatus);
            billregister.transition(true).end().withSenderName(user.getName()).withComments(workflowBean.getApproverComments()).withDateInfo(currentDate.toDate());
        } else if ("Cancel".equalsIgnoreCase(workflowBean.getWorkFlowAction())) {
            EgwStatus egwStatus = this.egwStatusHibernateDAO.getStatusByModuleAndCode("EXPENSEBILL", "Cancelled");
            billregister.setStatus(egwStatus);
            billregister.setBillstatus("Cancelled");
            billregister.transition(true).end().withStateValue("Cancelled").withSenderName(user.getName()).withComments(workflowBean.getApproverComments()).withDateInfo(currentDate.toDate());
        } else {
            if (null != workflowBean.getApproverPositionId() && workflowBean.getApproverPositionId() != -1L) {
                pos = (Position)this.persistenceService.find("from Position where id=?", new Object[]{workflowBean.getApproverPositionId()});
            }
            if (null == billregister.getState()) {
                WorkFlowMatrix wfmatrix = this.billRegisterWorkflowService.getWfMatrix(billregister.getStateType(), null, null, null, workflowBean.getCurrentState(), null);
                billregister.transition().start().withSenderName(user.getName()).withComments(workflowBean.getApproverComments()).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner(pos).withNextAction(wfmatrix.getNextAction());
            } else if (billregister.getCurrentState().getNextAction().equalsIgnoreCase("END")) {
                billregister.transition(true).end().withSenderName(user.getName()).withComments(workflowBean.getApproverComments()).withDateInfo(currentDate.toDate());
            } else {
                WorkFlowMatrix wfmatrix = this.billRegisterWorkflowService.getWfMatrix(billregister.getStateType(), null, null, null, billregister.getCurrentState().getValue(), null);
                billregister.transition(true).withSenderName(user.getName()).withComments(workflowBean.getApproverComments()).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner(pos).withNextAction(wfmatrix.getNextAction());
            }
        }
        return billregister;
    }

    private Assignment getWorkflowInitiator(EgBillregister billregister) {
        Assignment wfInitiator = (Assignment)this.assignmentService.findByEmployeeAndGivenDate(billregister.getCreatedBy().getId(), new Date()).get(0);
        return wfInitiator;
    }
}

