/*
 * Decompiled with CFR 0.152.
 */
package org.egov.payment.services;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.egov.billsaccounting.services.CreateVoucher;
import org.egov.billsaccounting.services.VoucherConstant;
import org.egov.commons.Bankaccount;
import org.egov.commons.CFinancialYear;
import org.egov.commons.CFunction;
import org.egov.commons.CVoucherHeader;
import org.egov.commons.dao.FinancialYearHibernateDAO;
import org.egov.deduction.model.EgRemittance;
import org.egov.deduction.model.EgRemittanceDetail;
import org.egov.deduction.model.EgRemittanceGldtl;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.advance.EgAdvanceRequisition;
import org.egov.model.bills.EgBillregister;
import org.egov.model.bills.Miscbilldetail;
import org.egov.model.deduction.RemittanceBean;
import org.egov.model.payment.Paymentheader;
import org.egov.model.recoveries.Recovery;
import org.egov.model.voucher.CommonBean;
import org.egov.model.voucher.VoucherDetails;
import org.egov.model.voucher.WorkflowBean;
import org.egov.pims.commons.Position;
import org.egov.services.payment.MiscbilldetailService;
import org.egov.services.payment.PaymentService;
import org.egov.utils.FinancialConstants;
import org.hibernate.HibernateException;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
@Service
public class PaymentActionHelper {
    public static final String ZERO = "0";
    private static final String FAILED = "Transaction failed";
    private static final String EXCEPTION_WHILE_SAVING_DATA = "Exception while saving data";
    @Autowired
    @Qualifier(value="miscbilldetailService")
    private MiscbilldetailService miscbilldetailService;
    @Autowired
    private FinancialYearHibernateDAO financialYearDAO;
    private static final Logger LOGGER = Logger.getLogger(PaymentActionHelper.class);
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    protected AssignmentService assignmentService;
    @Autowired
    @Qualifier(value="workflowService")
    private SimpleWorkflowService<Paymentheader> paymentHeaderWorkflowService;
    @Autowired
    @Qualifier(value="createVoucher")
    private CreateVoucher createVoucher;
    @Autowired
    @Qualifier(value="paymentService")
    private PaymentService paymentService;

    @Transactional
    public Paymentheader createDirectBankPayment(Paymentheader paymentheader, CVoucherHeader voucherHeader, CVoucherHeader billVhId, CommonBean commonBean, List<VoucherDetails> billDetailslist, List<VoucherDetails> subLedgerlist, WorkflowBean workflowBean) {
        try {
            voucherHeader = this.createVoucherAndledger(voucherHeader, commonBean, billDetailslist, subLedgerlist);
            paymentheader = this.paymentService.createPaymentHeader(voucherHeader, Integer.valueOf(commonBean.getAccountNumberId()), commonBean.getModeOfPayment(), commonBean.getAmount());
            if (commonBean.getDocumentId() != null) {
                billVhId = (CVoucherHeader)this.persistenceService.getSession().load(CVoucherHeader.class, (Serializable)commonBean.getDocumentId());
            }
            this.createMiscBillDetail(billVhId, commonBean, voucherHeader);
            paymentheader = this.sendForApproval(paymentheader, workflowBean);
        }
        catch (ValidationException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", ((ValidationError)e.getErrors().get(0)).getMessage()));
            throw new ValidationException(errors);
        }
        catch (Exception e) {
            e.printStackTrace();
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", e.getMessage()));
            throw new ValidationException(errors);
        }
        return paymentheader;
    }

    @Transactional
    public Paymentheader createRemittancePayment(Paymentheader paymentheader, CVoucherHeader voucherHeader, Integer accountNumberId, String modeOfPayment, BigDecimal totalAmount, List<RemittanceBean> listRemitBean, Recovery recovery, RemittanceBean remittanceBean, String remittedTo, WorkflowBean workflowBean, HashMap<String, Object> headerDetails, CommonBean commonBean) {
        try {
            voucherHeader = this.createVoucherAndLedger(voucherHeader, remittanceBean, recovery, commonBean, headerDetails, listRemitBean);
            paymentheader = this.paymentService.createPaymentHeader(voucherHeader, accountNumberId, modeOfPayment, totalAmount);
            this.updateEgRemittanceglDtl(paymentheader.getVoucherheader(), listRemitBean, recovery);
            this.createMiscBillDetail(paymentheader.getVoucherheader(), remittanceBean, remittedTo);
            paymentheader = this.sendForApproval(paymentheader, workflowBean);
        }
        catch (ValidationException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", ((ValidationError)e.getErrors().get(0)).getMessage()));
            throw new ValidationException(errors);
        }
        catch (Exception e) {
            e.printStackTrace();
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", e.getMessage()));
            throw new ValidationException(errors);
        }
        return paymentheader;
    }

    @Transactional
    private CVoucherHeader createVoucherAndLedger(CVoucherHeader voucherHeader, RemittanceBean remittanceBean, Recovery recovery, CommonBean commonBean, HashMap<String, Object> headerDetails, List<RemittanceBean> listRemitBean) {
        headerDetails.put("sourcepath", "/EGF/deduction/remitRecovery-beforeView.action?voucherHeader.id=");
        HashMap<String, String> detailMap = null;
        ArrayList<HashMap<String, Object>> accountdetails = new ArrayList<HashMap<String, Object>>();
        List<HashMap<String, Object>> subledgerDetails = new ArrayList<HashMap<String, Object>>();
        detailMap = new HashMap<String, String>();
        detailMap.put("creditamount", remittanceBean.getTotalAmount().toString());
        detailMap.put("debitamount", ZERO);
        Bankaccount account = (Bankaccount)this.persistenceService.find("from Bankaccount where id=?", new Object[]{Long.valueOf(commonBean.getAccountNumberId())});
        detailMap.put("glcode", account.getChartofaccounts().getGlcode());
        accountdetails.add(detailMap);
        detailMap = new HashMap();
        detailMap.put("creditamount", ZERO);
        detailMap.put("debitamount", remittanceBean.getTotalAmount().toString());
        recovery = (Recovery)((Object)this.persistenceService.find("from Recovery where id=?", new Object[]{remittanceBean.getRecoveryId()}));
        detailMap.put("glcode", recovery.getChartofaccounts().getGlcode());
        accountdetails.add(detailMap);
        subledgerDetails = this.addSubledgerGroupBy(subledgerDetails, recovery.getChartofaccounts().getGlcode(), listRemitBean);
        voucherHeader = this.createVoucher.createPreApprovedVoucher(headerDetails, accountdetails, subledgerDetails);
        return voucherHeader;
    }

    private List<HashMap<String, Object>> addSubledgerGroupBy(List<HashMap<String, Object>> subledgerDetails, String glcode, List<RemittanceBean> listRemitBean) {
        HashMap detailTypesMap = new HashMap();
        Integer detailTypeId = null;
        ArrayList<Integer> detailTypeList = new ArrayList<Integer>();
        HashMap<String, Object> subledgertDetailMap = null;
        for (RemittanceBean rbean : listRemitBean) {
            detailTypeId = rbean.getDetailTypeId();
            if (detailTypeList.contains(detailTypeId)) {
                if (((List)detailTypesMap.get(detailTypeId)).contains(rbean.getDetailKeyid())) continue;
                ((List)detailTypesMap.get(detailTypeId)).add(rbean.getDetailKeyid());
                continue;
            }
            detailTypeList.add(detailTypeId);
            detailTypesMap.put(detailTypeId, new ArrayList());
            ((List)detailTypesMap.get(detailTypeId)).add(rbean.getDetailKeyid());
        }
        Set entrySet = detailTypesMap.entrySet();
        List<RemittanceBean> tempRemitBean = listRemitBean;
        for (Map.Entry o : entrySet) {
            List value = (List)o.getValue();
            for (Integer detailKey : value) {
                BigDecimal sumPerDetailKey = BigDecimal.ZERO;
                for (RemittanceBean remittanceBean2 : tempRemitBean) {
                    if (remittanceBean2.getDetailKeyid() == null || !remittanceBean2.getDetailKeyid().equals(detailKey)) continue;
                    sumPerDetailKey = sumPerDetailKey.add(remittanceBean2.getPartialAmount());
                }
                subledgertDetailMap = new HashMap<String, Object>();
                subledgertDetailMap.put("debitamount", sumPerDetailKey);
                subledgertDetailMap.put("creditamount", BigDecimal.ZERO);
                subledgertDetailMap.put("detailtypeid", ((Integer)o.getKey()).toString());
                subledgertDetailMap.put("detailkeyid", detailKey);
                subledgertDetailMap.put("glcode", glcode);
                subledgerDetails.add(subledgertDetailMap);
            }
        }
        return subledgerDetails;
    }

    @Transactional
    public Paymentheader sendForApproval(Paymentheader paymentheader, WorkflowBean workflowBean) {
        if ("Create And Approve".equalsIgnoreCase(workflowBean.getWorkFlowAction()) && paymentheader.getState() == null) {
            paymentheader.getVoucherheader().setStatus(FinancialConstants.CREATEDVOUCHERSTATUS);
        } else {
            this.paymentService.transitionWorkFlow(paymentheader, workflowBean);
            this.paymentService.applyAuditing((AbstractAuditable)paymentheader.getState());
        }
        this.paymentService.persist(paymentheader);
        return paymentheader;
    }

    @Transactional
    public EgBillregister setbillRegisterFunction(EgBillregister bill, CFunction function) {
        bill.getEgBillregistermis().setFunction(function);
        return bill;
    }

    @Transactional
    public List<Miscbilldetail> getPaymentBills(Paymentheader paymentheader) {
        List miscBillList = null;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Inside getPaymentBills");
        }
        try {
            miscBillList = this.miscbilldetailService.findAllBy(" from Miscbilldetail where payVoucherHeader.id = ? order by paidto", new Object[]{paymentheader.getVoucherheader().getId()});
        }
        catch (Exception e) {
            throw new ValidationException("", "Total Paid Amount Exceeding Net Amount For This Bill", new String[0]);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Retrived bill details fro the paymentheader");
        }
        return miscBillList;
    }

    protected Assignment getWorkflowInitiator(Paymentheader paymentheader) {
        Assignment wfInitiator = this.assignmentService.getPrimaryAssignmentForUser(paymentheader.getCreatedBy().getId());
        return wfInitiator;
    }

    @Transactional
    private void updateEgRemittanceglDtl(CVoucherHeader vh, List<RemittanceBean> listRemitBean, Recovery recovery) {
        EgRemittance remit = new EgRemittance();
        remit.setFund(vh.getFundId());
        remit.setRecovery(recovery);
        CFinancialYear financialYearByDate = this.financialYearDAO.getFinancialYearByDate(vh.getVoucherDate());
        remit.setFinancialyear(financialYearByDate);
        remit.setCreateddate(new Date());
        remit.setCreatedby(BigDecimal.valueOf(ApplicationThreadLocals.getUserId()));
        remit.setLastmodifiedby(BigDecimal.valueOf(ApplicationThreadLocals.getUserId()));
        remit.setLastmodifieddate(new Date());
        remit.setMonth(BigDecimal.valueOf(new Date().getMonth()));
        remit.setVoucherheader(vh);
        remit.setAsOnDate(vh.getVoucherDate());
        HashSet<EgRemittanceDetail> egRemittanceDetail = new HashSet<EgRemittanceDetail>();
        EgRemittanceDetail remitDetail = null;
        Date currDate = new Date();
        for (RemittanceBean rbean : listRemitBean) {
            EgRemittanceGldtl remittancegldtl = (EgRemittanceGldtl)this.persistenceService.find("from EgRemittanceGldtl where id=?", new Object[]{rbean.getRemittance_gl_dtlId()});
            remittancegldtl.setRemittedamt(rbean.getPartialAmount());
            this.persistenceService.persist((Object)remittancegldtl);
            remitDetail = new EgRemittanceDetail();
            remitDetail.setEgRemittance(remit);
            remitDetail.setEgRemittanceGldtl(remittancegldtl);
            remitDetail.setRemittedamt(rbean.getPartialAmount());
            remitDetail.setLastmodifieddate(currDate);
            egRemittanceDetail.add(remitDetail);
        }
        remit.setEgRemittanceDetail(egRemittanceDetail);
        this.persistenceService.persist((Object)remit);
    }

    @Transactional
    private void createMiscBillDetail(CVoucherHeader voucherHeader, RemittanceBean remittanceBean, String remittedTo) {
        Miscbilldetail miscbillDetail = new Miscbilldetail();
        miscbillDetail.setBillamount(remittanceBean.getTotalAmount());
        miscbillDetail.setPaidamount(remittanceBean.getTotalAmount());
        miscbillDetail.setPassedamount(remittanceBean.getTotalAmount());
        miscbillDetail.setPayVoucherHeader(voucherHeader);
        miscbillDetail.setPaidto(remittedTo);
        this.persistenceService.persist((Object)miscbillDetail);
    }

    @Transactional
    public void transitionWorkFlow(Paymentheader paymentheader, WorkflowBean workflowBean) {
        DateTime currentDate = new DateTime();
        User user = this.securityUtils.getCurrentUser();
        Assignment userAssignment = this.assignmentService.getPrimaryAssignmentForUser(user.getId());
        Position pos = null;
        Assignment wfInitiator = null;
        if (null != paymentheader.getId()) {
            wfInitiator = this.getWorkflowInitiator(paymentheader);
        }
        if ("Reject".equalsIgnoreCase(workflowBean.getWorkFlowAction())) {
            if (wfInitiator.equals(userAssignment)) {
                paymentheader.transition(true).end().withSenderName(user.getName()).withComments(workflowBean.getApproverComments()).withDateInfo(currentDate.toDate());
            } else {
                String stateValue = "Rejected";
                paymentheader.transition(true).withSenderName(user.getName()).withComments(workflowBean.getApproverComments()).withStateValue("Rejected").withDateInfo(currentDate.toDate()).withOwner(wfInitiator.getPosition()).withNextAction("EOA Approval Pending");
            }
        } else if ("Approve".equalsIgnoreCase(workflowBean.getWorkFlowAction())) {
            paymentheader.getVoucherheader().setStatus(FinancialConstants.CREATEDVOUCHERSTATUS);
            paymentheader.transition(true).end().withSenderName(user.getName()).withComments(workflowBean.getApproverComments()).withDateInfo(currentDate.toDate());
        } else if ("Cancel".equalsIgnoreCase(workflowBean.getWorkFlowAction())) {
            paymentheader.getVoucherheader().setStatus(FinancialConstants.CANCELLEDVOUCHERSTATUS);
            paymentheader.transition(true).end().withStateValue("Cancelled").withSenderName(user.getName()).withComments(workflowBean.getApproverComments()).withDateInfo(currentDate.toDate());
        } else {
            if (null != workflowBean.getApproverPositionId() && workflowBean.getApproverPositionId() != -1L) {
                pos = (Position)this.persistenceService.find("from Position where id=?", new Object[]{workflowBean.getApproverPositionId()});
            }
            if (null == paymentheader.getState()) {
                WorkFlowMatrix wfmatrix = this.paymentHeaderWorkflowService.getWfMatrix(paymentheader.getStateType(), null, null, null, workflowBean.getCurrentState(), null);
                paymentheader.transition().start().withSenderName(user.getName()).withComments(workflowBean.getApproverComments()).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner(pos).withNextAction(wfmatrix.getNextAction());
            } else if (paymentheader.getCurrentState().getNextAction().equalsIgnoreCase("END")) {
                paymentheader.transition(true).end().withSenderName(user.getName()).withComments(workflowBean.getApproverComments()).withDateInfo(currentDate.toDate());
            } else {
                WorkFlowMatrix wfmatrix = this.paymentHeaderWorkflowService.getWfMatrix(paymentheader.getStateType(), null, null, null, paymentheader.getCurrentState().getValue(), null);
                paymentheader.transition(true).withSenderName(user.getName()).withComments(workflowBean.getApproverComments()).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner(pos).withNextAction(wfmatrix.getNextAction());
            }
        }
    }

    @Transactional
    public List<EgAdvanceRequisition> getAdvanceRequisitionDetails(Paymentheader paymentheader) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Inside getAdvanceRequisitionDetails");
        }
        return this.persistenceService.findAllBy("from EgAdvanceRequisition where egAdvanceReqMises.voucherheader.id=?", new Object[]{paymentheader.getVoucherheader().getId()});
    }

    @Transactional
    private CVoucherHeader createVoucherAndledger(CVoucherHeader voucherHeader, CommonBean commonBean, List<VoucherDetails> billDetailslist, List<VoucherDetails> subLedgerlist) {
        try {
            HashMap<String, Object> headerDetails = this.createHeaderAndMisDetails(voucherHeader);
            headerDetails.put("sourcepath", "/EGF/payment/directBankPayment-beforeView.action?voucherHeader.id=");
            HashMap<String, String> detailMap = null;
            HashMap<String, Object> subledgertDetailMap = null;
            ArrayList<HashMap<String, Object>> accountdetails = new ArrayList<HashMap<String, Object>>();
            ArrayList<HashMap<String, Object>> subledgerDetails = new ArrayList<HashMap<String, Object>>();
            detailMap = new HashMap<String, String>();
            detailMap.put("creditamount", commonBean.getAmount().toString());
            detailMap.put("debitamount", ZERO);
            Bankaccount account = (Bankaccount)this.persistenceService.getSession().load(Bankaccount.class, (Serializable)Long.valueOf(commonBean.getAccountNumberId()));
            detailMap.put("glcode", account.getChartofaccounts().getGlcode());
            accountdetails.add(detailMap);
            HashMap<String, String> glcodeMap = new HashMap<String, String>();
            for (VoucherDetails voucherDetail : billDetailslist) {
                detailMap = new HashMap();
                if (voucherDetail.getFunctionIdDetail() != null) {
                    CFunction function = (CFunction)this.persistenceService.getSession().load(CFunction.class, (Serializable)voucherDetail.getFunctionIdDetail());
                    detailMap.put("functioncode", function.getCode());
                }
                if (voucherDetail.getCreditAmountDetail().compareTo(BigDecimal.ZERO) == 0) {
                    detailMap.put("debitamount", voucherDetail.getDebitAmountDetail().toString());
                    detailMap.put("creditamount", ZERO);
                    detailMap.put("glcode", voucherDetail.getGlcodeDetail());
                    accountdetails.add(detailMap);
                    glcodeMap.put(voucherDetail.getGlcodeDetail(), "debit");
                    continue;
                }
                detailMap.put("creditamount", voucherDetail.getCreditAmountDetail().toString());
                detailMap.put("debitamount", ZERO);
                detailMap.put("glcode", voucherDetail.getGlcodeDetail());
                accountdetails.add(detailMap);
                glcodeMap.put(voucherDetail.getGlcodeDetail(), "credit");
            }
            for (VoucherDetails voucherDetail : subLedgerlist) {
                String amountType;
                subledgertDetailMap = new HashMap<String, Object>();
                String string = amountType = glcodeMap.get(voucherDetail.getSubledgerCode()) != null ? glcodeMap.get(voucherDetail.getSubledgerCode()).toString() : null;
                if (null != amountType && amountType.equalsIgnoreCase("debit")) {
                    subledgertDetailMap.put("debitamount", voucherDetail.getAmount());
                } else if (null != amountType) {
                    subledgertDetailMap.put("creditamount", voucherDetail.getAmount());
                }
                subledgertDetailMap.put("detailtypeid", voucherDetail.getDetailType().getId());
                subledgertDetailMap.put("detailkeyid", voucherDetail.getDetailKeyId());
                subledgertDetailMap.put("glcode", voucherDetail.getSubledgerCode());
                subledgerDetails.add(subledgertDetailMap);
            }
            voucherHeader = this.createVoucher.createPreApprovedVoucher(headerDetails, accountdetails, subledgerDetails);
        }
        catch (HibernateException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new ValidationException(Arrays.asList(new ValidationError(EXCEPTION_WHILE_SAVING_DATA, FAILED)));
        }
        catch (ApplicationRuntimeException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
        catch (ValidationException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", ((ValidationError)e.getErrors().get(0)).getMessage()));
            throw new ValidationException(errors);
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Posted to Ledger " + voucherHeader.getId()));
        }
        return voucherHeader;
    }

    protected HashMap<String, Object> createHeaderAndMisDetails(CVoucherHeader voucherHeader) throws ValidationException {
        HashMap<String, Object> headerdetails = new HashMap<String, Object>();
        headerdetails.put("vouchername", voucherHeader.getName());
        headerdetails.put("vouchertype", voucherHeader.getType());
        headerdetails.put((String)VoucherConstant.VOUCHERSUBTYPE, voucherHeader.getVoucherSubType());
        headerdetails.put("vouchernumber", voucherHeader.getVoucherNumber());
        headerdetails.put("voucherdate", voucherHeader.getVoucherDate());
        headerdetails.put("description", voucherHeader.getDescription());
        if (voucherHeader.getVouchermis().getDepartmentid() != null) {
            headerdetails.put("departmentcode", voucherHeader.getVouchermis().getDepartmentid().getCode());
        }
        if (voucherHeader.getFundId() != null) {
            headerdetails.put("fundcode", voucherHeader.getFundId().getCode());
        }
        if (voucherHeader.getVouchermis().getSchemeid() != null) {
            headerdetails.put("schemecode", voucherHeader.getVouchermis().getSchemeid().getCode());
        }
        if (voucherHeader.getVouchermis().getSubschemeid() != null) {
            headerdetails.put("subschemecode", voucherHeader.getVouchermis().getSubschemeid().getCode());
        }
        if (voucherHeader.getVouchermis().getFundsource() != null) {
            headerdetails.put("fundsourcecode", voucherHeader.getVouchermis().getFundsource().getCode());
        }
        if (voucherHeader.getVouchermis().getDivisionid() != null) {
            headerdetails.put("divisionid", voucherHeader.getVouchermis().getDivisionid().getId());
        }
        if (voucherHeader.getVouchermis().getFunctionary() != null) {
            headerdetails.put("functionarycode", voucherHeader.getVouchermis().getFunctionary().getCode());
        }
        if (voucherHeader.getVouchermis().getFunction() != null) {
            headerdetails.put("functioncode", voucherHeader.getVouchermis().getFunction().getCode());
        }
        return headerdetails;
    }

    @Transactional
    private void createMiscBillDetail(CVoucherHeader billVhId, CommonBean commonBean, CVoucherHeader voucherHeader) {
        Miscbilldetail miscbillDetail = new Miscbilldetail();
        miscbillDetail.setBillnumber(commonBean.getDocumentNumber());
        miscbillDetail.setBilldate(commonBean.getDocumentDate());
        miscbillDetail.setBillamount(commonBean.getAmount());
        miscbillDetail.setPaidamount(commonBean.getAmount());
        miscbillDetail.setPassedamount(commonBean.getAmount());
        miscbillDetail.setPayVoucherHeader(voucherHeader);
        miscbillDetail.setBillVoucherHeader(billVhId);
        miscbillDetail.setPaidto(commonBean.getPaidTo().trim());
        this.miscbilldetailService.persist(miscbillDetail);
    }
}

