/*
 * Decompiled with CFR 0.152.
 */
package org.egov.model.budget;

import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.egov.commons.CChartOfAccounts;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.validator.annotation.Required;
import org.egov.infra.persistence.validator.annotation.Unique;
import org.egov.utils.BudgetAccountType;
import org.egov.utils.BudgetingType;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="EGF_BUDGETGROUP")
@SequenceGenerator(name="SEQ_EGF_BUDGETGROUP", sequenceName="SEQ_EGF_BUDGETGROUP", allocationSize=1)
@Unique(fields={"name"}, id="id", columnName={"NAME"}, tableName="EGF_BUDGETGROUP", message="budgetgroup.name.isunique")
public class BudgetGroup
extends AbstractAuditable {
    private static final long serialVersionUID = 8907540544512153346L;
    public static final String SEQ_BUDGETGROUP = "SEQ_EGF_BUDGETGROUP";
    @DocumentId
    @Id
    @GeneratedValue(generator="SEQ_EGF_BUDGETGROUP", strategy=GenerationType.SEQUENCE)
    private Long id;
    @Required(message="Name should not be empty")
    private String name;
    @Length(max=250, message="Max 250 characters are allowed for description")
    private String description;
    @ManyToOne
    @JoinColumn(name="majorCode")
    private CChartOfAccounts majorCode;
    @ManyToOne
    @JoinColumn(name="maxCode")
    private CChartOfAccounts maxCode;
    @ManyToOne
    @JoinColumn(name="minCode")
    private CChartOfAccounts minCode;
    @Enumerated(value=EnumType.STRING)
    private BudgetAccountType accountType;
    @Enumerated(value=EnumType.STRING)
    private BudgetingType budgetingType;
    private Boolean isActive;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CChartOfAccounts getMajorCode() {
        return this.majorCode;
    }

    public void setMajorCode(CChartOfAccounts majorCode) {
        this.majorCode = majorCode;
    }

    public CChartOfAccounts getMaxCode() {
        return this.maxCode;
    }

    public void setMaxCode(CChartOfAccounts maxCode) {
        this.maxCode = maxCode;
    }

    public CChartOfAccounts getMinCode() {
        return this.minCode;
    }

    public void setMinCode(CChartOfAccounts minCode) {
        this.minCode = minCode;
    }

    @NotNull(message="Please select accounttype")
    public BudgetAccountType getAccountType() {
        return this.accountType;
    }

    public void setAccountType(BudgetAccountType accountType) {
        this.accountType = accountType;
    }

    @NotNull(message="Please select budgetingtype")
    public BudgetingType getBudgetingType() {
        return this.budgetingType;
    }

    public void setBudgetingType(BudgetingType budgetingType) {
        this.budgetingType = budgetingType;
    }

    public boolean getIsActive() {
        return this.isActive;
    }

    public void setIsActive(boolean isActive) {
        this.isActive = isActive;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setIsActive(Boolean isActive) {
        this.isActive = isActive;
    }
}

