/*
 * Decompiled with CFR 0.152.
 */
package org.egov.model.bills;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import org.egov.commons.EgwStatus;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.model.bills.EgBilldetails;
import org.egov.model.bills.EgBillregistermis;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="EG_BILLREGISTER")
@Inheritance(strategy=InheritanceType.JOINED)
@SequenceGenerator(name="SEQ_EG_BILLREGISTER", sequenceName="SEQ_EG_BILLREGISTER", allocationSize=1)
public class EgBillregister
extends StateAware
implements Serializable {
    private static final long serialVersionUID = -4312140421386028968L;
    public static final String SEQ_EG_BILLREGISTER = "SEQ_EG_BILLREGISTER";
    @DocumentId
    @Id
    @GeneratedValue(generator="SEQ_EG_BILLREGISTER", strategy=GenerationType.SEQUENCE)
    private Long id;
    @NotNull
    @Length(min=1)
    private String billnumber;
    @NotNull
    private Date billdate;
    @NotNull
    private BigDecimal billamount;
    private BigDecimal fieldid;
    private String billstatus;
    private String narration;
    private BigDecimal passedamount;
    private String billtype;
    @NotNull
    private String expendituretype;
    private BigDecimal advanceadjusted;
    private String zone;
    private String division;
    private String workordernumber;
    private String billapprovalstatus;
    private Boolean isactive;
    private Date billpasseddate;
    private Date workorderdate;
    @ManyToOne
    @JoinColumn(name="statusid", nullable=true)
    private EgwStatus status;
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="egBillregister", targetEntity=EgBillregistermis.class)
    private EgBillregistermis egBillregistermis;
    private String worksdetailId;
    @Transient
    private User approver;
    @Transient
    private Date approvedOn;
    @OrderBy(value="id")
    @OneToMany(orphanRemoval=true, cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="egBillregister", targetEntity=EgBilldetails.class)
    private Set<EgBilldetails> egBilldetailes = new HashSet<EgBilldetails>(0);

    public String getWorksdetailId() {
        return this.worksdetailId;
    }

    public void setWorksdetailId(String worksdetail) {
        this.worksdetailId = worksdetail;
    }

    public EgBillregister() {
    }

    public EgBillregister(String billnumber, Date billdate, BigDecimal billamount, String billstatus, String expendituretype, BigDecimal createdby, Date createddate) {
        this.billnumber = billnumber;
        this.billdate = billdate;
        this.billamount = billamount;
        this.billstatus = billstatus;
        this.expendituretype = expendituretype;
    }

    public EgBillregister(String billnumber, Date billdate, BigDecimal billamount, BigDecimal fieldid, String billstatus, String narration, BigDecimal passedamount, String billtype, String expendituretype, BigDecimal advanceadjusted, BigDecimal createdby, Date createddate, BigDecimal lastmodifiedby, Date lastmodifieddate, String zone, String division, String workordernumber, String billapprovalstatus, Boolean isactive, Date billpasseddate, Date workorderdate, EgBillregistermis egBillregistermis, Set<EgBilldetails> egBilldetailes, EgwStatus status) {
        this.billnumber = billnumber;
        this.billdate = billdate;
        this.billamount = billamount;
        this.fieldid = fieldid;
        this.billstatus = billstatus;
        this.narration = narration;
        this.passedamount = passedamount;
        this.billtype = billtype;
        this.expendituretype = expendituretype;
        this.advanceadjusted = advanceadjusted;
        this.zone = zone;
        this.division = division;
        this.workordernumber = workordernumber;
        this.billapprovalstatus = billapprovalstatus;
        this.isactive = isactive;
        this.billpasseddate = billpasseddate;
        this.workorderdate = workorderdate;
        this.egBillregistermis = egBillregistermis;
        this.egBilldetailes = egBilldetailes;
        this.status = status;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getBillnumber() {
        return this.billnumber;
    }

    public void setBillnumber(String billnumber) {
        this.billnumber = billnumber;
    }

    public Date getBilldate() {
        return this.billdate;
    }

    public void setBilldate(Date billdate) {
        this.billdate = billdate;
    }

    public BigDecimal getBillamount() {
        return this.billamount;
    }

    public void setBillamount(BigDecimal billamount) {
        this.billamount = billamount;
    }

    public BigDecimal getFieldid() {
        return this.fieldid;
    }

    public void setFieldid(BigDecimal fieldid) {
        this.fieldid = fieldid;
    }

    public String getBillstatus() {
        return this.billstatus;
    }

    public void setBillstatus(String billstatus) {
        this.billstatus = billstatus;
    }

    @Length(max=1024, message="Max 1024 characters are allowed for narration")
    public String getNarration() {
        return this.narration;
    }

    public void setNarration(String narration) {
        this.narration = narration;
    }

    public BigDecimal getPassedamount() {
        return this.passedamount;
    }

    public void setPassedamount(BigDecimal passedamount) {
        this.passedamount = passedamount;
    }

    public String getBilltype() {
        return this.billtype;
    }

    public void setBilltype(String billtype) {
        this.billtype = billtype;
    }

    public String getExpendituretype() {
        return this.expendituretype;
    }

    public void setExpendituretype(String expendituretype) {
        this.expendituretype = expendituretype;
    }

    public BigDecimal getAdvanceadjusted() {
        return this.advanceadjusted;
    }

    public void setAdvanceadjusted(BigDecimal advanceadjusted) {
        this.advanceadjusted = advanceadjusted;
    }

    public String getZone() {
        return this.zone;
    }

    public void setZone(String zone) {
        this.zone = zone;
    }

    public String getDivision() {
        return this.division;
    }

    public void setDivision(String division) {
        this.division = division;
    }

    public String getWorkordernumber() {
        return this.workordernumber;
    }

    public void setWorkordernumber(String workordernumber) {
        this.workordernumber = workordernumber;
    }

    public String getBillapprovalstatus() {
        return this.billapprovalstatus;
    }

    public void setBillapprovalstatus(String billapprovalstatus) {
        this.billapprovalstatus = billapprovalstatus;
    }

    public Boolean getIsactive() {
        return this.isactive;
    }

    public void setIsactive(Boolean isactive) {
        this.isactive = isactive;
    }

    public Date getBillpasseddate() {
        return this.billpasseddate;
    }

    public void setBillpasseddate(Date billpasseddate) {
        this.billpasseddate = billpasseddate;
    }

    public Date getWorkorderdate() {
        return this.workorderdate;
    }

    public void setWorkorderdate(Date workorderdate) {
        this.workorderdate = workorderdate;
    }

    public EgBillregistermis getEgBillregistermis() {
        return this.egBillregistermis;
    }

    public void setEgBillregistermis(EgBillregistermis egBillregistermis) {
        this.egBillregistermis = egBillregistermis;
    }

    public Set<EgBilldetails> getEgBilldetailes() {
        return this.egBilldetailes;
    }

    public void setEgBilldetailes(Set<EgBilldetails> egBilldetailes) {
        this.egBilldetailes = egBilldetailes;
    }

    public void addEgBilldetailes(EgBilldetails egBilldetail) {
        this.getEgBilldetailes().add(egBilldetail);
    }

    public EgwStatus getStatus() {
        return this.status;
    }

    public void setStatus(EgwStatus status) {
        this.status = status;
    }

    public String getStateDetails() {
        return this.getBillnumber();
    }

    public User getApprover() {
        return this.approver;
    }

    public void setApprover(User approver) {
        this.approver = approver;
    }

    public Date getApprovedOn() {
        return this.approvedOn;
    }

    public void setApprovedOn(Date approvedOn) {
        this.approvedOn = approvedOn;
    }

    public void removeEgBilldetailes(EgBilldetails egBilldetail) {
        if (egBilldetail != null) {
            this.getEgBilldetailes().remove(egBilldetail);
        }
    }
}

