/*
 * Decompiled with CFR 0.152.
 */
package org.egov.billsaccounting.services;

import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.egov.billsaccounting.services.CreateVoucher;
import org.egov.commons.CVoucherHeader;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.voucher.PreApprovedVoucher;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class BillsAccountingService {
    private static final Logger LOGGER = Logger.getLogger(BillsAccountingService.class);
    private static final String MISSINGMSG = "is not defined in AppConfig values cannot proceed creating voucher";
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private CreateVoucher createVoucher;

    @Transactional
    public long createPreApprovedVoucherFromBill(int billId, String voucherNumber, Date voucherDate) throws ApplicationRuntimeException, ValidationException {
        String voucherStatus = null;
        long vh = -1L;
        try {
            List vStatusList = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "PREAPPROVEDVOUCHERSTATUS");
            if (vStatusList.isEmpty() || vStatusList.size() != 1) {
                throw new ApplicationRuntimeException("PREAPPROVEDVOUCHERSTATUSis not defined in AppConfig values cannot proceed creating voucher");
            }
            AppConfigValues appVal = (AppConfigValues)vStatusList.get(0);
            voucherStatus = appVal.getValue();
            vh = this.createVoucher.createVoucherFromBill(billId, voucherStatus, voucherNumber, voucherDate);
        }
        catch (ValidationException e) {
            LOGGER.error((Object)e.getErrors());
            throw new ValidationException(e.getErrors());
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage());
            throw new ApplicationRuntimeException(e.getMessage());
        }
        return vh;
    }

    @Transactional
    public long createPreApprovedVoucherFromBillForPJV(int billId, List<PreApprovedVoucher> voucherdetailList, List<PreApprovedVoucher> subLedgerList) throws ApplicationRuntimeException {
        String voucherStatus = null;
        long vh = -1L;
        try {
            List vStatusList = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "PREAPPROVEDVOUCHERSTATUS");
            if (vStatusList.isEmpty() || vStatusList.size() != 1) {
                throw new ApplicationRuntimeException("PREAPPROVEDVOUCHERSTATUSis not defined in AppConfig values cannot proceed creating voucher");
            }
            AppConfigValues appVal = (AppConfigValues)vStatusList.get(0);
            voucherStatus = appVal.getValue();
            vh = this.createVoucher.createVoucherFromBillForPJV(billId, voucherStatus, voucherdetailList, subLedgerList);
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage());
            throw new ApplicationRuntimeException(e.getMessage());
        }
        return vh;
    }

    @Transactional
    public void createVoucherfromPreApprovedVoucher(long vouhcerheaderid) throws ApplicationRuntimeException {
        String voucherStatus = null;
        try {
            List vStatusList = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "APPROVEDVOUCHERSTATUS");
            if (vStatusList.isEmpty() || vStatusList.size() != 1) {
                throw new ApplicationRuntimeException("APPROVEDVOUCHERSTATUSis not defined in AppConfig values cannot proceed creating voucher");
            }
            AppConfigValues appVal = (AppConfigValues)vStatusList.get(0);
            voucherStatus = appVal.getValue();
            this.createVoucher.createVoucherFromPreApprovedVoucher(vouhcerheaderid, voucherStatus);
        }
        catch (ApplicationRuntimeException e) {
            LOGGER.error((Object)e.getMessage());
            throw new ApplicationRuntimeException(e.getMessage());
        }
    }

    @Transactional
    public long createVoucherFromBill(int billId) throws ApplicationRuntimeException {
        try {
            String voucherStatus = null;
            List vStatusList = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "DEFAULTVOUCHERCREATIONSTATUS");
            if (vStatusList.isEmpty() || vStatusList.size() != 1) {
                throw new ApplicationRuntimeException("DEFAULTVOUCHERCREATIONSTATUSis not defined in AppConfig values cannot proceed creating voucher");
            }
            AppConfigValues appVal = (AppConfigValues)vStatusList.get(0);
            voucherStatus = appVal.getValue();
            long vh = this.createVoucher.createVoucherFromBill(billId, voucherStatus, null, null);
            return vh;
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage());
            throw new ApplicationRuntimeException(e.getMessage());
        }
    }

    @Transactional
    public void updatePJV(CVoucherHeader vh, List<PreApprovedVoucher> detailList, List<PreApprovedVoucher> subledgerlist) throws ApplicationRuntimeException {
        this.createVoucher.updatePJV(vh, detailList, subledgerlist);
    }

    @Transactional
    public CVoucherHeader getPJVNumberForBill(String billNumber) throws ApplicationException {
        try {
            Session session = this.persistenceService.getSession();
            Query query = session.createQuery("select br.egBillregistermis.voucherHeader from EgBillregister br where br.billnumber=:billNumber");
            query.setString("billNumber", billNumber);
            if (null == query.uniqueResult()) {
                throw new ApplicationException("PJV is not created for this bill number [" + billNumber + "]");
            }
            return (CVoucherHeader)query.uniqueResult();
        }
        catch (Exception e) {
            throw new ApplicationException(e.getMessage());
        }
    }
}

