/*
 * Decompiled with CFR 0.152.
 */
package com.exilant.exility.updateservice;

import com.exilant.exility.common.AbstractTask;
import com.exilant.exility.common.DataCollection;
import com.exilant.exility.common.TaskFailedException;
import com.exilant.exility.updateservice.DataUpdater;
import com.exilant.exility.updateservice.TableDefinition;
import com.exilant.exility.updateservice.Tables;
import java.sql.Connection;

public class BulkTask
extends AbstractTask {
    private static BulkTask singletonInstance;
    private final String BULK_ACTION = "bulkAction";
    private final String UPDATE_ACTION = "update";
    private final String INSERT_ACTION = "insert";
    private final String DELETE_ACTION = "delete";
    private final String NONE_ACTION = "none";

    public static BulkTask getTask() {
        if (singletonInstance == null) {
            singletonInstance = new BulkTask();
        }
        return singletonInstance;
    }

    private BulkTask() {
    }

    @Override
    public void execute(String tableName, String gridName, DataCollection dc, Connection con, boolean errorOnNoData, boolean gridHasColumnHeading, String prefix) throws TaskFailedException {
        TableDefinition tableDefinition = Tables.getTable(tableName);
        DataUpdater dataUpdater = DataUpdater.getUpdater();
        String sql = "";
        String nameInDC = tableDefinition.name + "_" + "bulkAction";
        if (dc.hasName(nameInDC)) {
            String action = dc.getValue(nameInDC);
            if (action == "none") {
                return;
            }
            if (action == "insert") {
                sql = tableDefinition.getInsertSQL(dc);
            } else if (action == "update") {
                sql = tableDefinition.getUpdateSQL(dc);
            } else if (action == "delete") {
                sql = tableDefinition.getDeleteSQL(dc);
            } else {
                dc.addMessage("exilInvalidBulkAction", tableName, action);
                throw new TaskFailedException();
            }
            dataUpdater.update(sql, con, dc, errorOnNoData);
            return;
        }
        if (dc.hasList(nameInDC)) {
            String[] actions = dc.getValueList(nameInDC);
            for (int i = 0; i < actions.length; ++i) {
                String action = actions[i];
                if (action == "none") continue;
                if (action == "insert") {
                    sql = tableDefinition.getInsertSQL(dc, i);
                } else if (action == "update") {
                    sql = tableDefinition.getUpdateSQL(dc, i);
                } else if (action == "delete") {
                    sql = tableDefinition.getDeleteSQL(dc, i);
                } else {
                    dc.addMessage("exilInvalidBulkAction", tableName, action);
                    throw new TaskFailedException();
                }
                dataUpdater.update(sql, con, dc, errorOnNoData);
            }
            return;
        }
        dataUpdater.update(sql, con, dc, errorOnNoData);
    }

    public static void main(String[] args) {
    }
}

