/*
 * Decompiled with CFR 0.152.
 */
package com.exilant.exility.dataservice;

import com.exilant.exility.common.DataCollection;
import com.exilant.exility.common.TaskFailedException;
import com.exilant.exility.common.XMLLoader;
import com.exilant.exility.dataservice.Job;
import java.net.URL;
import java.sql.Connection;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.egov.infstr.utils.EGovConfig;

public class JobService {
    private static final Logger LOGGER = Logger.getLogger(JobService.class);
    static JobService singletonInstance;
    protected Job job;
    public HashMap jobs;

    public static JobService getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new JobService();
        }
        return singletonInstance;
    }

    private JobService() {
        XMLLoader xmlLoader = new XMLLoader();
        URL url = EGovConfig.class.getClassLoader().getResource("config/resource/Jobs.xml");
        xmlLoader.load(url.toString(), this);
    }

    public void doService(DataCollection dc, Connection con) throws TaskFailedException {
        String serviceID = dc.getValue("serviceID");
        if (serviceID == null) {
            dc.addMessage("exilNoServiceID", serviceID);
        } else {
            Job aJob = (Job)this.jobs.get(serviceID);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)aJob);
            }
            if (aJob == null) {
                dc.addMessage("exilNoJobDefinition", serviceID);
            } else if (aJob.hasAccess(dc, con)) {
                aJob.execute(dc, con);
            } else {
                dc.addMessage("exilNoAccess", serviceID);
            }
        }
    }
}

