/*
 * Decompiled with CFR 0.152.
 */
package com.exilant.eGov.src.transactions;

import com.exilant.GLEngine.GeneralLedgerBean;
import com.exilant.exility.common.TaskFailedException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.CFinancialYear;
import org.egov.commons.dao.FinancialYearHibernateDAO;
import org.egov.commons.utils.EntityType;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infstr.services.PersistenceService;
import org.hibernate.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class RptSubLedgerSchedule {
    double totalDr;
    double totalCr;
    double totalOpgBal;
    double totalClosingBal;
    List<Object[]> resultset;
    NumberFormat formatter;
    TaskFailedException taskExc;
    String glCode;
    String accEntityId;
    String fundId;
    String fyId;
    String deptId;
    private CFinancialYear fyObj;
    String subLedgerTable;
    HashMap hm_opBal;
    LinkedList dataList;
    private static final Logger LOGGER = Logger.getLogger(RptSubLedgerSchedule.class);
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    private FinancialYearHibernateDAO financialYearDAO;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    Query pst;

    public LinkedList getSubLedgerTypeSchedule(GeneralLedgerBean reportBean) throws TaskFailedException {
        this.formatter = new DecimalFormat();
        this.formatter = new DecimalFormat("###############.00");
        this.glCode = reportBean.getGlcode();
        this.fundId = reportBean.getFund_id();
        this.deptId = reportBean.getDeptId();
        this.accEntityId = reportBean.getAccEntityId();
        reportBean.setAccEntityId(this.accEntityId);
        String startDate = "";
        String endDate = "";
        String formstartDate = "";
        String formendDate = "";
        String startDateDBFormat = "";
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        SimpleDateFormat formatter1 = new SimpleDateFormat("dd/MM/yyyy");
        Date dt = new Date();
        try {
            endDate = reportBean.getEndDate();
            dt = sdf.parse(endDate);
            formendDate = formatter1.format(dt);
            startDate = reportBean.getStartDate();
            if (!startDate.equalsIgnoreCase("null")) {
                dt = sdf.parse(startDate);
                formstartDate = formatter1.format(dt);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("Parse Error" + e));
            throw new TaskFailedException();
        }
        startDateDBFormat = formstartDate;
        endDate = formendDate;
        this.fyObj = this.financialYearDAO.getFinYearByDate(dt);
        this.fyId = this.fyObj.getId().toString();
        Date finYrStartingDate = this.fyObj.getStartingDate();
        String formatedDateStr = formatter1.format(finYrStartingDate);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)(".............The formated date is " + formatedDateStr));
        }
        try {
            this.getSubQuery(startDateDBFormat, endDate);
            this.formatSLTypeReport();
            reportBean.setAccName(this.getAccountname(this.glCode));
        }
        catch (Exception exception) {
            LOGGER.error((Object)("Exception in getSubLedgerTypeSchedule .." + exception.getMessage()));
            throw new TaskFailedException();
        }
        return this.dataList;
    }

    private void getSubQuery(String startDate, String endDate) throws TaskFailedException {
        block34: {
            List listAppConfVal;
            String defaultStatusExclude = null;
            String departmentFromCondition = "";
            String departmentWhereCondition = "";
            String departmentConditionTran = "";
            this.dataList = new LinkedList();
            this.totalCr = 0.0;
            this.totalDr = 0.0;
            this.totalOpgBal = 0.0;
            this.totalClosingBal = 0.0;
            if (this.deptId != null && !this.deptId.equalsIgnoreCase("")) {
                departmentConditionTran = " and DEPARTMENTID=? ";
                departmentFromCondition = ",vouchermis vmis";
                departmentWhereCondition = "AND vh.id = vmis.voucherheaderid and vmis.departmentid=? ";
            }
            if (null == (listAppConfVal = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "statusexcludeReport"))) {
                throw new ApplicationRuntimeException("Exlcude statuses not defined for Reports");
            }
            defaultStatusExclude = ((AppConfigValues)listAppConfVal.get(0)).getValue();
            String query = "Select complist.detkeyid as slid,sum(coalesce(complist.OpbCredit,0)) as OpgCreditBal,sum(coalesce(complist.OpbDebit,0)) as OpgDebitBal, sum(coalesce(complist.PrevDebit,0))  as PrvDb,sum(coalesce(complist.PrevCredit,0))  as PrvCr, sum(coalesce(complist.Credit,0)) as TxnCredit,sum(coalesce(complist.Debit,0)) as TxnDebit from( Select gld.detailkeyid as detkeyid,0 as OpbCredit,0 as OpbDebit,0 as PrevDebit,0 as PrevCredit,SUM (gld.amount)  AS Debit , 0 AS Credit FROM generalledgerdetail gld, generalledger gl,voucherheader vh " + departmentFromCondition + " WHERE gld.detailtypeid  = ? AND gld.generalledgerid = gl .ID  AND gl.glcodeid=(Select ID FROM chartofaccounts WHERE glcode = ?) AND gl.debitamount > 0 AND gl.voucherheaderid = vh .ID AND vh.voucherdate >= to_date(?,'dd/mm/yyyy') AND vh.voucherdate <= to_date(?,'dd/mm/yyyy')  AND vh.fundid= ? " + departmentWhereCondition + "  AND vh.status NOT IN (" + defaultStatusExclude + ") GROUP BY gld.detailkeyid  UNION ALL  Select gld.detailkeyid as detkeyid,0 as OpbCredit,0 as OpbDebit,0 as PrevDebit,0 as PrevCredit, 0 AS Debit , SUM (gld.amount) AS Credit  FROM generalledgerdetail gld, generalledger gl,voucherheader vh  " + departmentFromCondition + " WHERE gld.detailtypeid  = ? AND gld.generalledgerid = gl .ID AND gl.glcodeid=(Select ID FROM chartofaccounts WHERE glcode = ?)  AND gl.creditamount > 0 AND gl.voucherheaderid = vh .ID AND vh.voucherdate >= to_date(?,'dd/mm/yyyy') AND vh.voucherdate <=  to_date(?,'dd/mm/yyyy')  AND vh.fundid= ? " + departmentWhereCondition + " AND vh.status NOT IN (" + defaultStatusExclude + ") GROUP BY gld.detailkeyid   UNION ALL Select gld.detailkeyid AS detkeyid ,0 as OpbCredit,0 as OpbDebit,coalesce( SUM (gld.amount ),0)  AS PrevDebit , 0 AS PrevCredit ,0 AS Debit,0 AS Credit  FROM generalledgerdetail gld, generalledger gl, voucherheader vh  " + departmentFromCondition + " WHERE gld.detailtypeid  = ? AND gld.generalledgerid = gl.ID  AND gl.glcodeid=(Select ID FROM chartofaccounts WHERE glcode = ?) AND gl.debitamount > 0 AND gl.voucherheaderid = vh .ID  AND vh.voucherdate >=(Select startingdate FROM financialyear WHERE startingdate <= to_date(?,'dd/mm/yyyy')  AND endingdate >= to_date(?,'dd/mm/yyyy') ) AND vh.voucherdate <= to_date(?,'dd/mm/yyyy')-1 " + departmentWhereCondition + " AND vh.fundid = ? AND vh.status NOT  IN (" + defaultStatusExclude + ") GROUP BY gld.detailkeyid   UNION ALL Select gld.detailkeyid AS detkeyid ,0 as OpbCredit,0 as OpbDebit,0  AS PrevDebit , coalesce( SUM (gld.amount ),0) AS PrevCredit ,0 AS Debit,0 AS Credit  FROM generalledgerdetail gld, generalledger gl, voucherheader vh  " + departmentFromCondition + " WHERE gld.detailtypeid  = ? AND gld.generalledgerid = gl.ID  AND gl.glcodeid=(Select ID FROM chartofaccounts WHERE glcode = ?) AND gl.creditamount > 0 AND gl.voucherheaderid = vh .ID  AND vh.voucherdate >=(Select startingdate FROM financialyear WHERE startingdate <= to_date(?,'dd/mm/yyyy')  AND endingdate >= to_date(?,'dd/mm/yyyy') ) AND vh.voucherdate <= to_date(?,'dd/mm/yyyy')-1 " + departmentWhereCondition + " AND vh.fundid = ? AND vh.status NOT  IN (" + defaultStatusExclude + ") GROUP BY gld.detailkeyid  UNION ALL Select ACCOUNTDETAILKEY AS detkeyid , SUM(openingcreditbalance) AS OpbCredit , SUM(openingdebitbalance) AS OpbDebit,0  AS PrevDebit , 0 AS PrevCredit ,0 AS Debit,0 AS Credit  FROM transactionsummary WHERE glcodeid=(Select ID FROM chartofaccounts WHERE glcode = ?)  AND (openingcreditbalance > 0 OR openingdebitbalance > 0) AND accountdetailtypeid= ? AND fundid= ? AND financialyearid= ?  " + departmentConditionTran + " GROUP BY detkeyid ) as complist group by  slid order by slid";
            int i = 0;
            this.pst = this.persistenceService.getSession().createSQLQuery(query);
            this.pst.setLong(i++, (long)Integer.valueOf(this.accEntityId).intValue());
            this.pst.setString(i++, this.glCode);
            this.pst.setString(i++, startDate);
            this.pst.setString(i++, endDate);
            this.pst.setLong(i++, Long.parseLong(this.fundId));
            if (this.deptId != null && !this.deptId.equalsIgnoreCase("")) {
                this.pst.setLong(i++, Long.parseLong(this.deptId));
            }
            this.pst.setLong(i++, (long)Integer.valueOf(this.accEntityId).intValue());
            this.pst.setString(i++, this.glCode);
            this.pst.setString(i++, startDate);
            this.pst.setString(i++, endDate);
            this.pst.setLong(i++, Long.parseLong(this.fundId));
            if (this.deptId != null && !this.deptId.equalsIgnoreCase("")) {
                this.pst.setLong(i++, Long.parseLong(this.deptId));
            }
            this.pst.setLong(i++, (long)Integer.valueOf(this.accEntityId).intValue());
            this.pst.setString(i++, this.glCode);
            this.pst.setString(i++, startDate);
            this.pst.setString(i++, endDate);
            this.pst.setString(i++, startDate);
            if (this.deptId != null && !this.deptId.equalsIgnoreCase("")) {
                this.pst.setLong(i++, Long.parseLong(this.deptId));
            }
            this.pst.setLong(i++, Long.parseLong(this.fundId));
            this.pst.setLong(i++, (long)Integer.valueOf(this.accEntityId).intValue());
            this.pst.setString(i++, this.glCode);
            this.pst.setString(i++, startDate);
            this.pst.setString(i++, endDate);
            this.pst.setString(i++, startDate);
            if (this.deptId != null && !this.deptId.equalsIgnoreCase("")) {
                this.pst.setLong(i++, Long.parseLong(this.deptId));
            }
            this.pst.setLong(i++, Long.parseLong(this.fundId));
            this.pst.setString(i++, this.glCode);
            this.pst.setLong(i++, (long)Integer.valueOf(this.accEntityId).intValue());
            this.pst.setLong(i++, Long.parseLong(this.fundId));
            this.pst.setLong(i++, Long.parseLong(this.fyId));
            if (this.deptId != null && !this.deptId.equalsIgnoreCase("")) {
                this.pst.setLong(i++, Long.parseLong(this.deptId));
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("Main QUERY..." + query));
            }
            try {
                GeneralLedgerBean gb = null;
                this.resultset = this.pst.list();
                Accountdetailtype accountdetailtype = (Accountdetailtype)this.persistenceService.find(" from Accountdetailtype where id=?", new Object[]{Integer.valueOf(this.accEntityId)});
                EntityType entity = null;
                if (this.resultset.size() == 0) break block34;
                for (Object[] element : this.resultset) {
                    gb = new GeneralLedgerBean();
                    double openingBal = 0.0;
                    double closingBal = 0.0;
                    double opgCredit = 0.0;
                    double opgDebit = 0.0;
                    double prevDebit = 0.0;
                    double prevCredit = 0.0;
                    double debitamount = 0.0;
                    double creditamount = 0.0;
                    try {
                        entity = (EntityType)this.persistenceService.find(" from " + accountdetailtype.getFullQualifiedName() + " where id=" + element[0].toString());
                    }
                    catch (Exception ee) {
                        LOGGER.error((Object)ee.getMessage(), (Throwable)ee);
                        entity = (EntityType)this.persistenceService.find(" from " + accountdetailtype.getFullQualifiedName() + " where id=" + element[0].toString());
                    }
                    if (entity != null) {
                        gb.setCode(entity.getCode());
                        gb.setName(entity.getName());
                    } else {
                        gb.setCode("");
                        gb.setName("");
                    }
                    gb.setAccEntityKey(element[0].toString());
                    if (element[5].toString() != null) {
                        creditamount = Double.parseDouble(element[5].toString());
                    }
                    if (element[6].toString() != null) {
                        debitamount = Double.parseDouble(element[6].toString());
                    }
                    if (element[1].toString() != null) {
                        opgCredit = Double.parseDouble(element[1].toString());
                    }
                    if (element[2].toString() != null) {
                        opgDebit = Double.parseDouble(element[2].toString());
                    }
                    if (element[3].toString() != null) {
                        prevDebit = Double.parseDouble(element[3].toString());
                    }
                    if (element[4].toString() != null) {
                        prevCredit = Double.parseDouble(element[4].toString());
                    }
                    openingBal = opgCredit + prevCredit - (opgDebit + prevDebit);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("Calcualted opening balance... " + openingBal + "=="));
                    }
                    if (openingBal > 0.0) {
                        gb.setOpeningBal("" + RptSubLedgerSchedule.numberToString(Double.valueOf(openingBal).toString()) + " Cr");
                        this.totalOpgBal += openingBal;
                    } else if (openingBal < 0.0) {
                        this.totalOpgBal += openingBal;
                        double openingBal1 = openingBal * -1.0;
                        gb.setOpeningBal("" + RptSubLedgerSchedule.numberToString(Double.valueOf(openingBal1).toString()) + " Dr");
                    } else {
                        gb.setOpeningBal("&nbsp;");
                    }
                    closingBal = openingBal + creditamount - debitamount;
                    if (closingBal > 0.0) {
                        gb.setClosingBal("" + RptSubLedgerSchedule.numberToString(Double.valueOf(closingBal).toString()) + " Cr");
                    } else if (closingBal < 0.0) {
                        double closingBal1 = closingBal * -1.0;
                        gb.setClosingBal("" + RptSubLedgerSchedule.numberToString(Double.valueOf(closingBal1).toString()) + " Dr");
                    } else {
                        gb.setClosingBal("&nbsp;");
                    }
                    if (debitamount > 0.0) {
                        gb.setDebitamount("" + RptSubLedgerSchedule.numberToString(Double.valueOf(debitamount).toString()));
                        this.totalDr += debitamount;
                    } else {
                        gb.setDebitamount("&nbsp;");
                    }
                    if (creditamount > 0.0) {
                        gb.setCreditamount("" + RptSubLedgerSchedule.numberToString(Double.valueOf(creditamount).toString()));
                        this.totalCr += creditamount;
                    } else {
                        gb.setCreditamount("&nbsp;");
                    }
                    gb.setAccEntityId(this.accEntityId);
                    this.totalClosingBal = this.totalOpgBal + this.totalCr - this.totalDr;
                    this.dataList.add(gb);
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)("Error in subledger schedule report....." + e.getMessage()));
                throw new TaskFailedException();
            }
        }
    }

    private void formatSLTypeReport() {
        GeneralLedgerBean gb = new GeneralLedgerBean();
        gb.setAccEntityKey("");
        gb.setCode("<hr noshade color=black size=1><b>Total:<hr noshade color=black size=1></b>");
        gb.setName("");
        if (this.totalOpgBal > 0.0) {
            gb.setOpeningBal("<hr noshade color=black size=1><b>" + RptSubLedgerSchedule.numberToString(Double.valueOf(this.totalOpgBal).toString()) + " Cr<hr noshade color=black size=1></b>");
        } else if (this.totalOpgBal < 0.0) {
            this.totalOpgBal *= -1.0;
            gb.setOpeningBal("<hr noshade color=black size=1><b>" + RptSubLedgerSchedule.numberToString(Double.valueOf(this.totalOpgBal).toString()) + " Dr<hr noshade color=black size=1></b>");
        } else if (this.totalOpgBal == 0.0) {
            gb.setOpeningBal("");
        }
        if (this.totalClosingBal > 0.0) {
            gb.setClosingBal("<hr noshade color=black size=1><b>" + RptSubLedgerSchedule.numberToString(Double.valueOf(this.totalClosingBal).toString()) + " Cr<hr noshade color=black size=1></b>");
        } else if (this.totalClosingBal < 0.0) {
            this.totalClosingBal *= -1.0;
            gb.setClosingBal("<hr noshade color=black size=1><b>" + RptSubLedgerSchedule.numberToString(Double.valueOf(this.totalClosingBal).toString()) + " Dr<hr noshade color=black size=1></b>");
        } else if (this.totalClosingBal == 0.0) {
            gb.setClosingBal("");
        }
        gb.setDebitamount("<hr noshade color=black size=1><b>" + RptSubLedgerSchedule.numberToString(Double.valueOf(this.totalDr).toString()) + "<hr noshade color=black size=1></b>");
        gb.setCreditamount("<hr noshade color=black size=1><b>" + RptSubLedgerSchedule.numberToString(Double.valueOf(this.totalCr).toString()) + "<hr noshade color=black size=1></b>");
        this.dataList.add(gb);
    }

    private String getAccountname(String glCode) {
        String accName = "";
        try {
            String query = "select name from chartofaccounts where glCode= ?";
            this.pst = this.persistenceService.getSession().createSQLQuery("select name from chartofaccounts where glCode= ?");
            this.pst.setString(0, glCode);
            List list = this.pst.list();
            if (list.get(0) != null) {
                accName = list.get(0).toString();
            }
        }
        catch (Exception sqlex) {
            LOGGER.error((Object)("Exp in getAccountname" + sqlex.getMessage()), (Throwable)sqlex);
            return null;
        }
        return accName;
    }

    public static StringBuffer numberToString(String strNumberToConvert) {
        String strNumber = "";
        String signBit = "";
        if (strNumberToConvert.startsWith("-")) {
            strNumber = "" + strNumberToConvert.substring(1, strNumberToConvert.length());
            signBit = "-";
        } else {
            strNumber = "" + strNumberToConvert;
        }
        DecimalFormat dft = new DecimalFormat("##############0.00");
        String strtemp = "" + dft.format(Double.parseDouble(strNumber));
        StringBuffer strbNumber = new StringBuffer(strtemp);
        int intLen = strbNumber.length();
        for (int i = intLen - 6; i > 0; i -= 2) {
            strbNumber.insert(i, ',');
        }
        if (signBit.equals("-")) {
            strbNumber = strbNumber.insert(0, "-");
        }
        return strbNumber;
    }
}

