/*
 * Decompiled with CFR 0.152.
 */
package com.exilant.eGov.src.reports;

import com.exilant.exility.common.TaskFailedException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.egov.infstr.services.PersistenceService;
import org.hibernate.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class CommnFunctions {
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    private static final Logger LOGGER = Logger.getLogger(CommnFunctions.class);
    private List<Object[]> resultset;
    Query pstmt = null;
    private static TaskFailedException taskExc;
    public String[] reqFundId;
    public String[] reqFundName;

    public void getFundList(String fundId, String startDate, String endDate) throws Exception {
        String fundCondition = "";
        if (!fundId.equalsIgnoreCase("")) {
            fundCondition = " AND Id=? ";
        }
        try {
            String query = " select id,name from fund where isactive=true and isnotleaf!=true " + fundCondition + " order by id";
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("getFundList: " + query));
            }
            this.pstmt = this.persistenceService.getSession().createSQLQuery(query);
            if (!fundId.equalsIgnoreCase("")) {
                this.pstmt.setString(0, fundId);
            }
            this.resultset = this.pstmt.list();
            int resSize = 0;
            int i = 0;
            resSize = this.resultset.size();
            this.reqFundId = new String[resSize];
            this.reqFundName = new String[resSize];
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("resSize  " + resSize));
            }
            for (Object[] element : this.resultset) {
                this.reqFundId[i] = element[0].toString();
                this.reqFundName[i] = element[1].toString();
                ++i;
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)("ERROR in FundList coomonfun" + ex.getMessage()), (Throwable)ex);
            LOGGER.error((Object)"Error in getting fund list");
            throw taskExc;
        }
    }

    public void getOpeningBalance(String fundId, String type1, String type2, String substringVal, String startDate, String endDate, int classification, String[] reqFundId1, HashMap openingBal) throws Exception {
        String fundCondition = "";
        if (!fundId.equalsIgnoreCase("")) {
            fundCondition = "AND f.Id=? ";
        }
        String glcode = "";
        String fuId = "";
        String query = "SELECT substr(coa.glcode,0," + substringVal + ") as \"glcode\",ts.fundid as \"fundid\" , case when coa.type = ? then sum(ts.openingcreditbalance)-sum(ts.openingdebitbalance) else sum(ts.openingdebitbalance)-sum(ts.openingcreditbalance) end as \"amount\"  FROM transactionsummary ts,  chartofaccounts coa,fund  f   WHERE (coa.TYPE = ? OR coa.TYPE = ?) and coa.id = ts.glcodeid  AND financialyearid =(SELECT ID FROM financialyear WHERE startingdate <= ? AND endingdate >= ?)  " + fundCondition + " and f.id=ts.fundid and f.isactive=true and f.isnotleaf!=true  GROUP BY substr(coa.glcode,0," + substringVal + "), fundid ,coa.type ";
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("query " + query));
        }
        try {
            int j = 1;
            this.getFundList(fundId, startDate, endDate);
            this.pstmt = this.persistenceService.getSession().createSQLQuery(query);
            this.pstmt.setString(j++, type2);
            this.pstmt.setString(j++, type1);
            this.pstmt.setString(j++, type2);
            this.pstmt.setString(j++, startDate);
            this.pstmt.setString(j++, endDate);
            if (!fundId.equalsIgnoreCase("")) {
                this.pstmt.setString(j++, fundId);
            }
            this.resultset = this.pstmt.list();
            Double opeBal = null;
            HashMap<String, Double> openingBalsubList = null;
            for (Object[] element : this.resultset) {
                glcode = element[0].toString();
                fuId = element[1].toString();
                opeBal = Double.parseDouble(element[2].toString());
                if (!openingBal.containsKey(glcode)) {
                    openingBalsubList = new HashMap<String, Double>();
                    for (String element2 : reqFundId1) {
                        if (element2.equalsIgnoreCase(fuId)) {
                            openingBalsubList.put(element2, opeBal);
                            continue;
                        }
                        openingBalsubList.put(element2, new Double(0.0));
                    }
                    openingBal.put(glcode, openingBalsubList);
                    continue;
                }
                ((HashMap)openingBal.get(glcode)).put(fuId, opeBal);
            }
        }
        catch (Exception e) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("Error in getOpeningBalance" + e.getMessage()), (Throwable)e);
            }
            throw taskExc;
        }
    }

    public void getTxnBalance(Connection conn, String fundid, String type1, String type2, String substringVal, String startDate, String endDate, int classification, String effFilter, HashMap txnBalancehasmap) throws Exception {
        String fundCondition = " ";
        if (fundid != null && !fundid.equals("")) {
            fundCondition = " and vh.fundid= ?";
        }
        String query1 = "SELECT SUBSTR(coa.GLCODE,1,2)as \"glCode\",vh.fundid as \"fundId\",case when sum(gl.debitamount)-sum(gl.creditAmount) = null then 0 else sum(gl.debitamount)-sum(gl.creditAmount)as \"amount\" FROM chartofaccounts  coa,generalledger gl, voucherHeader vh WHERE coa.TYPE = ? and vh.ID =  gl.VOUCHERHEADERID AND  gl.glcode=coa.glcode  AND vh.VOUCHERDATE >= ? AND vh.VOUCHERDATE <= ?" + fundCondition + "  " + effFilter;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("getI: " + query1));
        }
        try {
            int j = 1;
            this.pstmt = this.persistenceService.getSession().createSQLQuery(query1);
            this.pstmt.setString(j++, type1);
            this.pstmt.setString(j++, startDate);
            this.pstmt.setString(j++, endDate);
            if (fundid != null && !fundid.equals("")) {
                this.pstmt.setString(j++, fundid);
            }
            this.resultset = this.pstmt.list();
            Object[] firstElement = this.resultset != null && this.resultset.size() > 0 ? this.resultset.get(1) : null;
            for (Object[] element : this.resultset) {
                String accntCode = element[0].toString();
                String fund = element[1].toString();
                String amt = element[2].toString();
                HashMap<String, Object> txnBalance = new HashMap<String, Object>();
                if (!txnBalancehasmap.containsKey(accntCode)) {
                    for (String element2 : this.reqFundId) {
                        if (element2.equalsIgnoreCase(fund)) {
                            txnBalance.put(fund, amt);
                            continue;
                        }
                        txnBalance.put(element2, new Double(0.0));
                    }
                    txnBalancehasmap.put(accntCode, txnBalance);
                } else {
                    ((HashMap)txnBalancehasmap.get(accntCode)).put(fund, amt);
                }
                if (!firstElement.equals(element)) {
                    txnBalancehasmap.put(accntCode, txnBalance);
                    continue;
                }
                break;
            }
        }
        catch (Exception se) {
            LOGGER.error((Object)("Error in getschedulewiseOB" + se.getMessage()), (Throwable)se);
            throw taskExc;
        }
    }

    public void getTxnCreditBalance(Connection conn, String fundId, String type1, String type2, String substringVal, String startDate, String endDate, int classification, HashMap txnCreditBalance) throws Exception {
        String fundCondition = "";
        if (!fundId.equalsIgnoreCase("")) {
            fundCondition = "AND f.Id=? ";
        }
        String glcode = "";
        String fuId = "";
        String type = "(coa.TYPE = ? OR coa.TYPE = ?) and";
        if (type1 == null || type1.trim().equals("")) {
            type = "";
        }
        String query = "SELECT substr(coa.glcode,0," + substringVal + ") as \"glcode\",ts.fundid as \"fundid\" , sum(ts.openingcreditbalance) as \"amount\"  FROM transactionsummary ts,  chartofaccounts coa,fund  f   WHERE " + type + " coa.id = ts.glcodeid  AND financialyearid =(SELECT ID FROM financialyear WHERE startingdate <= ? AND endingdate >= ?)  " + fundCondition + " and f.id=ts.fundid and f.isactive=true and f.isnotleaf!=true  GROUP BY substr(coa.glcode,0," + substringVal + "), fundid ,coa.type";
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("query " + query));
        }
        try {
            int j = 1;
            this.pstmt = this.persistenceService.getSession().createSQLQuery(query);
            if (type1 == null || type1.trim().equals("")) {
                this.pstmt.setString(j++, type1);
                this.pstmt.setString(j++, type2);
            }
            this.pstmt.setString(j++, startDate);
            this.pstmt.setString(j++, endDate);
            if (!fundId.equalsIgnoreCase("")) {
                this.pstmt.setString(j++, fundId);
            }
            this.resultset = this.pstmt.list();
            Double opeBal = null;
            HashMap<String, Double> creditBalsubList = null;
            for (Object[] element : this.resultset) {
                glcode = element[0].toString();
                fuId = element[1].toString();
                opeBal = Double.parseDouble(element[2].toString());
                if (!txnCreditBalance.containsKey(glcode)) {
                    creditBalsubList = new HashMap<String, Double>();
                    for (String element2 : this.reqFundId) {
                        if (element2.equalsIgnoreCase(fuId)) {
                            creditBalsubList.put(element2, opeBal);
                            continue;
                        }
                        creditBalsubList.put(element2, new Double(0.0));
                    }
                    txnCreditBalance.put(glcode, creditBalsubList);
                    continue;
                }
                ((HashMap)txnCreditBalance.get(glcode)).put(fuId, opeBal);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error in getCreditBalance");
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Exp=" + e.getMessage()), (Throwable)e);
            }
            throw new Exception();
        }
    }

    public void getTxnDebitBalance(Connection conn, String fundId, String type1, String type2, String substringVal, String startDate, String endDate, int classification, HashMap txnDebitBalance) throws Exception {
        String fundCondition = "";
        if (!fundId.equalsIgnoreCase("")) {
            fundCondition = "AND f.Id=? ";
        }
        String glcode = "";
        String fuId = "";
        String query = "SELECT substr(coa.glcode,0," + substringVal + ") as \"glcode\",ts.fundid as \"fundid\" , sum(ts.openingdebitbalance) as \"amount\"  FROM transactionsummary ts,  chartofaccounts coa,fund  f   WHERE (coa.TYPE = ? OR coa.TYPE = ?) and coa.id = ts.glcodeid  AND financialyearid =(SELECT ID FROM financialyear WHERE startingdate <= ? AND endingdate >= ?)  " + fundCondition + " and f.id=ts.fundid and f.isactive=true and f.isnotleaf!=true  GROUP BY substr(coa.glcode,0," + substringVal + "), fundid ,coa.type";
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("query " + query));
        }
        try {
            int j = 1;
            this.pstmt = this.persistenceService.getSession().createSQLQuery(query);
            this.pstmt.setString(j++, type1);
            this.pstmt.setString(j++, type2);
            this.pstmt.setString(j++, startDate);
            this.pstmt.setString(j++, endDate);
            if (!fundId.equalsIgnoreCase("")) {
                this.pstmt.setString(j++, fundId);
            }
            this.resultset = this.pstmt.list();
            Double opeBal = null;
            HashMap<String, Double> debitBalsubList = null;
            for (Object[] element : this.resultset) {
                glcode = element[0].toString();
                fuId = element[1].toString();
                opeBal = Double.parseDouble(element[2].toString());
                if (!txnDebitBalance.containsKey(glcode)) {
                    debitBalsubList = new HashMap<String, Double>();
                    for (String element2 : this.reqFundId) {
                        if (element2.equalsIgnoreCase(fuId)) {
                            debitBalsubList.put(element2, opeBal);
                            continue;
                        }
                        debitBalsubList.put(element2, new Double(0.0));
                    }
                    txnDebitBalance.put(glcode, debitBalsubList);
                    continue;
                }
                ((HashMap)txnDebitBalance.get(glcode)).put(fuId, opeBal);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error in getDebitBalance" + e.getMessage()), (Throwable)e);
            throw taskExc;
        }
    }

    public String formatAmt(String amt, String amt_In) {
        BigDecimal ammt = new BigDecimal(0.0);
        DecimalFormat formatter = new DecimalFormat("##############0.00");
        int val = amt_In.equalsIgnoreCase("thousand") ? 1 : (amt_In.equalsIgnoreCase("lakhs") ? 2 : 3);
        switch (val) {
            case 1: {
                ammt = BigDecimal.valueOf(Double.parseDouble(amt) / 1000.0);
                ammt = ammt.setScale(2, 4);
                break;
            }
            case 2: {
                ammt = BigDecimal.valueOf(Double.parseDouble(amt) / 100000.0);
                ammt = ammt.setScale(2, 4);
                break;
            }
            default: {
                ammt = BigDecimal.valueOf(Double.valueOf(amt));
                BigDecimal tmpAmt = new BigDecimal(ammt.toBigInteger());
                tmpAmt = tmpAmt.add(BigDecimal.valueOf(0.5));
                if (!(ammt.doubleValue() > tmpAmt.doubleValue())) break;
                ammt = ammt.setScale(0, 4);
            }
        }
        return formatter.format(Double.valueOf(ammt.toString()));
    }

    public String getStartDate(int finYearId) throws TaskFailedException {
        String startDate = "";
        String query = "SELECT TO_CHAR(startingdate,'DD/MM/YYYY') FROM FINANCIALYEAR WHERE id= ?";
        try {
            this.pstmt = this.persistenceService.getSession().createSQLQuery("SELECT TO_CHAR(startingdate,'DD/MM/YYYY') FROM FINANCIALYEAR WHERE id= ?");
            this.pstmt.setInteger(0, finYearId);
            List list = this.pstmt.list();
            if (list != null) {
                startDate = list.get(0).toString();
            }
        }
        catch (Exception sql) {
            LOGGER.error((Object)("Exp in getStartDate :" + sql.getMessage()), (Throwable)sql);
            throw taskExc;
        }
        return startDate;
    }

    public String getEndDate(int finYearId) throws TaskFailedException {
        String endDate = "";
        String query = "SELECT TO_CHAR(endingdate,'DD/MM/YYYY') FROM FINANCIALYEAR WHERE id= ?";
        try {
            this.pstmt = this.persistenceService.getSession().createSQLQuery("SELECT TO_CHAR(endingdate,'DD/MM/YYYY') FROM FINANCIALYEAR WHERE id= ?");
            this.pstmt.setInteger(0, finYearId);
            this.resultset = this.pstmt.list();
            for (Object[] element : this.resultset) {
                endDate = element[0].toString();
            }
        }
        catch (Exception sql) {
            LOGGER.error((Object)("error inside getEndDate" + sql.getMessage()), (Throwable)sql);
            throw taskExc;
        }
        return endDate;
    }

    public StringBuffer numberToString(String strNumberToConvert) {
        String strNumber = "";
        String signBit = "";
        if (strNumberToConvert.startsWith("-")) {
            strNumber = "" + strNumberToConvert.substring(1, strNumberToConvert.length());
            signBit = "-";
        } else {
            strNumber = "" + strNumberToConvert;
        }
        DecimalFormat dft = new DecimalFormat("##############0.00");
        String strtemp = "" + dft.format(Double.parseDouble(strNumber));
        StringBuffer strbNumber = new StringBuffer(strtemp);
        int intLen = strbNumber.length();
        for (int i = intLen - 6; i > 0; i -= 2) {
            strbNumber.insert(i, ',');
        }
        if (signBit.equals("-")) {
            strbNumber = strbNumber.insert(0, "-");
        }
        return strbNumber;
    }

    public String addToAddLessSubTotals(String glcode, BigDecimal amt, String[] tagName, int index, BigDecimal[] addSubtotals, BigDecimal[] lessSubtotals, String status) {
        String returnStatus = "";
        for (String element : tagName) {
            if (element.equals(glcode)) {
                if (lessSubtotals[index] == null) {
                    lessSubtotals[index] = BigDecimal.ZERO;
                }
                lessSubtotals[index] = lessSubtotals[index].add(amt);
            } else {
                if (addSubtotals[index] == null) {
                    addSubtotals[index] = BigDecimal.ZERO;
                }
                addSubtotals[index] = addSubtotals[index].add(amt);
            }
            if (tagName[0].equals(tagName[tagName.length - 1]) && tagName[0].equals(glcode)) {
                returnStatus = "addBothSubtotals";
                continue;
            }
            if (tagName[0].equals(glcode) && !status.equals("added-addSubtotals")) {
                returnStatus = "addSubtotals";
                continue;
            }
            if (!tagName[tagName.length - 1].equals(glcode)) continue;
            returnStatus = "lessSubtotals";
        }
        return returnStatus;
    }
}

