/*
 * Decompiled with CFR 0.152.
 */
package org.egov.utils;

import ar.com.fdvs.dj.core.DynamicJasperHelper;
import ar.com.fdvs.dj.core.layout.ClassicLayoutManager;
import ar.com.fdvs.dj.core.layout.LayoutManager;
import ar.com.fdvs.dj.domain.DJDataSource;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.ColumnBuilderException;
import ar.com.fdvs.dj.domain.builders.DynamicReportBuilder;
import ar.com.fdvs.dj.domain.builders.FastReportBuilder;
import ar.com.fdvs.dj.domain.constants.Border;
import ar.com.fdvs.dj.domain.constants.Font;
import ar.com.fdvs.dj.domain.constants.HorizontalAlign;
import ar.com.fdvs.dj.domain.constants.Page;
import ar.com.fdvs.dj.domain.constants.Transparency;
import ar.com.fdvs.dj.domain.constants.VerticalAlign;
import ar.com.fdvs.dj.domain.entities.Subreport;
import com.exilant.eGov.src.reports.TrialBalanceBean;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.export.JRHtmlExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.export.JRXlsExporterParameter;
import org.apache.log4j.Logger;
import org.egov.commons.Fund;
import org.egov.egf.model.BudgetReAppReportBean;
import org.egov.egf.model.CommonReportBean;
import org.egov.egf.model.DepartmentwiseExpenditureReport;
import org.egov.egf.model.FunctionwiseIE;
import org.egov.egf.model.ReportSearch;
import org.egov.egf.model.Statement;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.model.budget.BudgetProposalBean;
import org.egov.model.report.ReportBean;

public class ReportHelper {
    private static final int MB = 0x100000;
    ByteArrayOutputStream outputBytes;
    private InputStream reportStream;
    private static final Logger LOGGER = Logger.getLogger(ReportHelper.class);
    private static SimpleDateFormat FORMATDDMMYYYY = new SimpleDateFormat("dd/MM/yyyy", Locale.ENGLISH);

    public OutputStream getOutputBytes() {
        return this.outputBytes;
    }

    public InputStream exportXls(InputStream inputStream, String jasperPath, Map<String, Object> paramMap, List<Object> dataSource) throws JRException, IOException {
        JasperPrint jasperPrint = this.setUpAndGetJasperPrint(jasperPath, paramMap, dataSource);
        ByteArrayOutputStream xlsReport = new ByteArrayOutputStream();
        JRXlsExporter exporter = new JRXlsExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
        exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)xlsReport);
        exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_ONE_PAGE_PER_SHEET, (Object)Boolean.FALSE);
        exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_DETECT_CELL_TYPE, (Object)Boolean.TRUE);
        exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)Boolean.FALSE);
        exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_IGNORE_GRAPHICS, (Object)Boolean.FALSE);
        exporter.exportReport();
        inputStream = new ByteArrayInputStream(xlsReport.toByteArray());
        this.closeStream(this.reportStream);
        return inputStream;
    }

    public InputStream exportXls(InputStream inputStream, JasperPrint jasperPrint) throws JRException, IOException {
        this.outputBytes = new ByteArrayOutputStream(0x100000);
        ByteArrayOutputStream xlsReport = new ByteArrayOutputStream();
        JRXlsExporter exporter = new JRXlsExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
        exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)xlsReport);
        exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_ONE_PAGE_PER_SHEET, (Object)Boolean.FALSE);
        exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_DETECT_CELL_TYPE, (Object)Boolean.TRUE);
        exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)Boolean.FALSE);
        exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_IGNORE_GRAPHICS, (Object)Boolean.FALSE);
        exporter.exportReport();
        inputStream = new ByteArrayInputStream(xlsReport.toByteArray());
        this.closeStream(this.reportStream);
        return inputStream;
    }

    protected void closeStream(InputStream stream) {
        block3: {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    if (!LOGGER.isDebugEnabled()) break block3;
                    LOGGER.debug((Object)("Error" + e.getMessage()));
                }
            }
        }
    }

    protected JasperPrint setUpAndGetJasperPrint(String jasperPath, Map<String, Object> paramMap, List<Object> dataSource) throws JRException {
        this.reportStream = this.getClass().getResourceAsStream(jasperPath);
        this.outputBytes = new ByteArrayOutputStream(0x100000);
        if (dataSource.size() > 0) {
            return JasperFillManager.fillReport((InputStream)this.reportStream, paramMap, (JRDataSource)new JRBeanCollectionDataSource(dataSource));
        }
        return JasperFillManager.fillReport((InputStream)this.reportStream, paramMap, (JRDataSource)new JREmptyDataSource());
    }

    public InputStream exportHtml(InputStream inputStream, String jasperPath, Map<String, Object> paramMap, List dataSource, String sizeUnitPoint) {
        try {
            this.exportReport(this.setUpAndGetJasperPrint(jasperPath, paramMap, dataSource), sizeUnitPoint);
            inputStream = new ByteArrayInputStream(this.outputBytes.toByteArray());
            this.closeStream(this.reportStream);
        }
        catch (JRException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Error" + e.getMessage()));
            }
            throw new ApplicationRuntimeException("report.exception", (Throwable)e);
        }
        return inputStream;
    }

    public InputStream exportHtml(InputStream inputStream, JasperPrint jasperPrint) {
        try {
            this.outputBytes = new ByteArrayOutputStream(0x100000);
            this.exportReport(jasperPrint, JRHtmlExporterParameter.SIZE_UNIT_POINT);
            inputStream = new ByteArrayInputStream(this.outputBytes.toByteArray());
            this.closeStream(this.reportStream);
        }
        catch (JRException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Error" + e.getMessage()));
            }
            throw new ApplicationRuntimeException("report.exception", (Throwable)e);
        }
        return inputStream;
    }

    public InputStream exportHtml(InputStream inputStream, JasperPrint jasperPrint, String sizeunitpoint) {
        try {
            this.outputBytes = new ByteArrayOutputStream(0x100000);
            this.exportReport(jasperPrint, JRHtmlExporterParameter.SIZE_UNIT_POINT);
            inputStream = new ByteArrayInputStream(this.outputBytes.toByteArray());
            this.closeStream(this.reportStream);
        }
        catch (JRException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Error" + e.getMessage()));
            }
            throw new ApplicationRuntimeException("report.exception", (Throwable)e);
        }
        return inputStream;
    }

    public InputStream exportPdf(InputStream inputStream, String jasperPath, Map<String, Object> paramMap, List<Object> dataSource) throws JRException, IOException {
        JasperExportManager.exportReportToPdfStream((JasperPrint)this.setUpAndGetJasperPrint(jasperPath, paramMap, dataSource), (OutputStream)this.outputBytes);
        inputStream = new ByteArrayInputStream(this.outputBytes.toByteArray());
        this.closeStream(this.reportStream);
        return inputStream;
    }

    public InputStream exportPdf(InputStream inputStream, JasperPrint jasperPrint) throws JRException, IOException {
        this.outputBytes = new ByteArrayOutputStream(0x100000);
        JasperExportManager.exportReportToPdfStream((JasperPrint)jasperPrint, (OutputStream)this.outputBytes);
        inputStream = new ByteArrayInputStream(this.outputBytes.toByteArray());
        this.closeStream(this.reportStream);
        return inputStream;
    }

    public JasperPrint generateDepartmentwiseExpenditureJasperPrint(DepartmentwiseExpenditureReport deReport, String heading, String subreportheading) throws JRException, IOException, Exception {
        Style detailAmountStyle = this.getConcurrenceAmountStyle();
        FastReportBuilder drb = new FastReportBuilder();
        Style columnStyle = this.getConcurrenceColumnStyle();
        this.getDepartmentTitleStyle();
        drb = drb.addColumn("Sl No", "slNo", Integer.class.getName(), 8, columnStyle);
        drb.addColumn("Department Name", "departmentNm", String.class.getName(), 70, columnStyle).addColumn("Concurrence given \\n upto " + FORMATDDMMYYYY.format(deReport.getCurrentYearConcurrenceGivenUptoDate()), "concurrenceGiven", BigDecimal.class.getName(), 35, detailAmountStyle);
        for (String dt : deReport.getConcurrenceDateSet()) {
            drb.addColumn(dt, "dayAmountMap." + dt, BigDecimal.class.getName(), 22, false, "0.00", detailAmountStyle);
        }
        drb.addColumn("Total Concurrence\\n given till" + FORMATDDMMYYYY.format(deReport.getToDate()), "totalConcurrenceGivenTillDate", BigDecimal.class.getName(), 22, detailAmountStyle);
        drb.setTitle(heading).setSubtitle("                                                                                                                                                                                                          Amount in Lakh \\nFund :" + deReport.getFund().getName()).setPrintBackgroundOnOddRows(false).setWhenNoData("No data", null).setDefaultStyles(this.getBudgetTitleStyle(), this.getDepartmentwiseSubTitleStyle(), this.getHeaderStyle(), this.getDetailStyle()).setOddRowBackgroundStyle(this.getOddRowStyle()).setDetailHeight(10).setHeaderHeight(35).setUseFullPageWidth(true).setSubtitleStyle(this.getDepartmentwiseSubTitleStyle()).setSubtitleHeight(Integer.valueOf(30)).setTitleHeight(Integer.valueOf(40));
        drb.setFooterHeight(1000);
        drb.setPageSizeAndOrientation(Page.Page_Legal_Landscape());
        drb.addConcatenatedReport(this.createSubreport(deReport, subreportheading, drb));
        JRBeanCollectionDataSource ds = new JRBeanCollectionDataSource(deReport.getCurrentyearDepartmentList());
        JRBeanCollectionDataSource ds1 = new JRBeanCollectionDataSource(deReport.getPreviousyearDepartmentList());
        DynamicReport dr = drb.build();
        HashMap<String, JRBeanCollectionDataSource> myMap = new HashMap<String, JRBeanCollectionDataSource>();
        myMap.put("subreportds", ds1);
        dr.getOptions().setIgnorePagination(true);
        return DynamicJasperHelper.generateJasperPrint((DynamicReport)dr, (LayoutManager)new ClassicLayoutManager(), (JRDataSource)ds, myMap);
    }

    public Subreport createSubreport(DepartmentwiseExpenditureReport deReport, String heading, FastReportBuilder mainrep) throws JRException, IOException, Exception {
        Style detailAmountStyle = this.getConcurrenceAmountStyle();
        FastReportBuilder drb = new FastReportBuilder();
        Style columnStyle = this.getConcurrenceColumnStyle();
        this.getDepartmentTitleStyle();
        drb = drb.addColumn("Sl No", "slNo", Integer.class.getName(), 8, columnStyle);
        drb.addColumn("Department Name", "departmentNm", String.class.getName(), 70, columnStyle).addColumn("Concurrence given \\n upto " + FORMATDDMMYYYY.format(deReport.getPreviousYearConcurrenceGivenUptoDate()), "concurrenceGiven", BigDecimal.class.getName(), 35, detailAmountStyle);
        for (String dt : deReport.getPreviousConcurrenceDateSet()) {
            drb.addColumn(dt, "dayAmountMap." + dt, BigDecimal.class.getName(), 22, false, "0.00", detailAmountStyle);
        }
        drb.addColumn("Total Concurrence Given\\n till" + FORMATDDMMYYYY.format(deReport.getPreviousYearConcurrenceGivenTillDate()), "totalConcurrenceGivenTillDate", BigDecimal.class.getName(), 22, detailAmountStyle);
        drb.setTitle(heading).setPrintBackgroundOnOddRows(false).setWhenNoData("No data", null).setDefaultStyles(this.getBudgetTitleStyle(), this.getDepartmentwiseSubTitleStyle(), this.getHeaderStyle(), this.getDetailStyle()).setOddRowBackgroundStyle(this.getOddRowStyle()).setDetailHeight(10).setHeaderHeight(35).setUseFullPageWidth(true).setSubtitleHeight(Integer.valueOf(30)).setTitleHeight(Integer.valueOf(40));
        drb.setPageSizeAndOrientation(Page.Page_Legal_Landscape());
        new JRBeanCollectionDataSource(deReport.getPreviousyearDepartmentList());
        DJDataSource djds = new DJDataSource("subreportds", 0, 10);
        Subreport subRep = new Subreport();
        subRep.setLayoutManager((LayoutManager)new ClassicLayoutManager());
        subRep.setDynamicReport(drb.build());
        subRep.setDatasource(djds);
        subRep.setUseParentReportParameters(true);
        return subRep;
    }

    public JasperPrint generateIncomeExpenditureReportJasperPrint(Statement balanceSheet, String heading, String fromDate, String toDate, String subtitle, boolean showScheduleColumn) throws Exception {
        Style detailAmountStyle = this.getDetailAmountStyle();
        Style columnStyle = this.getColumnStyle();
        FastReportBuilder drb = new FastReportBuilder();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Generating Income Expenditure pdf/excel ");
        }
        drb = drb.addColumn("Account Code", "glCode", String.class.getName(), 55, columnStyle).addColumn("Head of Account", "accountName", String.class.getName(), 100, columnStyle);
        if (showScheduleColumn) {
            drb.addColumn("Schedule No", "scheduleNo", String.class.getName(), 60, columnStyle);
        }
        drb.addColumn("Revised Estimate" + balanceSheet.getFinancialYear().getFinYearRange(), "budgetAmount", BigDecimal.class.getName(), 70, false, "0.00", detailAmountStyle);
        drb.setTitle(heading).setSubtitle(subtitle + "                                                                                                                                                                                             Amount in " + balanceSheet.getCurrency()).setPrintBackgroundOnOddRows(true).setWhenNoData("No data", null).setDefaultStyles(this.getTitleStyle(), this.getAmountSubTitleStyle(), this.getHeaderStyle(), this.getDetailStyle()).setOddRowBackgroundStyle(this.getOddRowStyle()).setDetailHeight(20).setHeaderHeight(35).setUseFullPageWidth(true).setSubtitleHeight(Integer.valueOf(30)).setTitleHeight(Integer.valueOf(40));
        drb.setPageSizeAndOrientation(new Page(612, 792, false));
        if (balanceSheet.getFunds().size() == 1) {
            for (Fund fund : balanceSheet.getFunds()) {
                drb.addColumn(toDate + "(Rs)", "netAmount." + fund.getName(), BigDecimal.class.getName(), 70, false, "0.00", detailAmountStyle);
                drb.addColumn(fromDate + "(Rs)", "previousYearAmount." + fund.getName(), BigDecimal.class.getName(), 70, false, "0.00", detailAmountStyle);
            }
        } else {
            for (Fund fund : balanceSheet.getFunds()) {
                drb.addColumn(fund.getName() + " Totals As On:" + toDate + "(Rs)", "netAmount." + fund.getName(), BigDecimal.class.getName(), 70, false, "0.00", detailAmountStyle);
                drb.addColumn(fund.getName() + " Totals As On:" + fromDate + "(Rs)", "previousYearAmount." + fund.getName(), BigDecimal.class.getName(), 70, false, "0.00", detailAmountStyle);
            }
        }
        DynamicReport dr = drb.build();
        JRBeanCollectionDataSource ds = new JRBeanCollectionDataSource(balanceSheet.getIeEntries());
        return DynamicJasperHelper.generateJasperPrint((DynamicReport)dr, (LayoutManager)new ClassicLayoutManager(), (JRDataSource)ds);
    }

    public JasperPrint generateReceiptPaymentReportJasperPrint(Statement receiptPaymentObj, String heading, String subtitle, String currentYearDate, String PreviousYearDate, boolean showScheduleColumn) throws Exception {
        Style detailAmountStyle = this.getDetailAmountStyle();
        Style columnStyle = this.getColumnStyle();
        FastReportBuilder drb = new FastReportBuilder();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Generating generateReceiptPaymentReportJasperPrint pdf/excel ");
        }
        if (!showScheduleColumn) {
            drb.addColumn("Schedule Number", "accountName", String.class.getName(), 100, columnStyle);
            drb.addColumn("Account Code", "glCode", String.class.getName(), 55, columnStyle);
        }
        if (showScheduleColumn) {
            drb.addColumn("Head of Account", "accountName", String.class.getName(), 100, columnStyle);
            drb.addColumn("Schedule No", "scheduleNo", String.class.getName(), 60, columnStyle);
        }
        drb.setTitle(heading).setSubtitle(subtitle + "                                                                                                                                                                                             Amount in " + receiptPaymentObj.getCurrency()).setPrintBackgroundOnOddRows(true).setWhenNoData("No data", null).setDefaultStyles(this.getTitleStyle(), this.getAmountSubTitleStyle(), this.getHeaderStyle(), this.getDetailStyle()).setOddRowBackgroundStyle(this.getOddRowStyle()).setDetailHeight(20).setHeaderHeight(35).setUseFullPageWidth(true).setSubtitleHeight(Integer.valueOf(30)).setTitleHeight(Integer.valueOf(40));
        drb.setPageSizeAndOrientation(new Page(612, 792, false));
        if (receiptPaymentObj.getFunds().size() > 1) {
            for (Fund fund : receiptPaymentObj.getFunds()) {
                drb.addColumn(fund.getName() + " (Rs)", "fundWiseAmount." + fund.getCode(), BigDecimal.class.getName(), 55, false, "0.00", detailAmountStyle);
            }
        }
        drb.addColumn(currentYearDate + "(Rs)", "currentYearTotal", BigDecimal.class.getName(), 55, false, "0.00", detailAmountStyle);
        drb.addColumn(PreviousYearDate + "(Rs)", "previousYearTotal", BigDecimal.class.getName(), 55, false, "0.00", detailAmountStyle);
        DynamicReport dr = drb.build();
        JRBeanCollectionDataSource ds = new JRBeanCollectionDataSource(receiptPaymentObj.getEntries());
        return DynamicJasperHelper.generateJasperPrint((DynamicReport)dr, (LayoutManager)new ClassicLayoutManager(), (JRDataSource)ds);
    }

    public JasperPrint generateBudgetAppropriationJasperPrint(List<BudgetReAppReportBean> BudgetAppDisplay2, String heading, String subtitle, String budName, String showFundColumn, String showFunctionColumn, String showDepartmentColumn) throws Exception {
        Style detailAmountStyle = this.getDetailAmountStyle();
        Style columnStyle = this.getColumnStyle();
        FastReportBuilder drb = new FastReportBuilder();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"  Generating Budget Approprition Report pdf/excel ");
        }
        drb = drb.addColumn("Sl No", "slNo", Integer.class.getName(), 20, columnStyle);
        if (showFundColumn == "false") {
            drb.addColumn("Fund", "fund", String.class.getName(), 60, columnStyle);
        }
        if (showFunctionColumn == "false") {
            drb.addColumn("Function Center", "function", String.class.getName(), 75, columnStyle);
        }
        if (showDepartmentColumn == "false") {
            drb.addColumn("Department", "department", String.class.getName(), 60, columnStyle);
        }
        drb.addColumn("Budget Head", "budgetHead", String.class.getName(), 130, columnStyle).addColumn("Appropriation No", "budgetAppropriationNo", String.class.getName(), 50, columnStyle).addColumn("Appropriation Date", "appDate", String.class.getName(), 30, columnStyle).addColumn(budName, "actualAmount", BigDecimal.class.getName(), 35, false, "0.00", detailAmountStyle).addColumn("Addition Amount", "additionAmount", BigDecimal.class.getName(), 30, false, "0.00", detailAmountStyle).addColumn("Dedudction Amount", "deductionAmount", BigDecimal.class.getName(), 30, false, "0.00", detailAmountStyle);
        drb.setTitle(heading).setSubtitle("                                                                                                                                                               " + subtitle).setPrintBackgroundOnOddRows(true).setWhenNoData("No data", null).setDefaultStyles(this.getTitleStyle(), this.getBudgetSubTitleStyle(), this.getHeaderStyle(), this.getDetailStyle()).setOddRowBackgroundStyle(this.getOddRowStyle()).setDetailHeight(20).setHeaderHeight(35).setUseFullPageWidth(true).setSubtitleHeight(Integer.valueOf(30)).setTitleHeight(Integer.valueOf(40)).setSubtitleStyle(this.getBudgetSubTitleStyle());
        drb.setPageSizeAndOrientation(new Page(612, 792, false));
        DynamicReport dr = drb.build();
        JRBeanCollectionDataSource ds = new JRBeanCollectionDataSource(BudgetAppDisplay2);
        return DynamicJasperHelper.generateJasperPrint((DynamicReport)dr, (LayoutManager)new ClassicLayoutManager(), (JRDataSource)ds);
    }

    public JasperPrint generateBudgetReportForHOD(List<BudgetProposalBean> bpBeanList, String heading, String subtitle, String beforePreviousYearRange, String previousYearRange, String currentYearRange, String nextYearRange, boolean isConsolidated) throws Exception {
        this.getDetailAmountStyle();
        Style columnStyle = this.getBudgetColumnStyle();
        String conSubtitle = isConsolidated ? subtitle + "                                                                                                                                                                                                                                                                                                                                                  Amount in Thousand" : subtitle + "                                                                                                                                                                                                                                                                Amount in Rupees";
        FastReportBuilder drb = new FastReportBuilder();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"  Generating Budget Report for HOD  pdf/excel ");
        }
        drb = drb.addColumn("Budget\\nDepartment", "executingDepartment", String.class.getName(), 40, columnStyle).addColumn("Fund", "fund", String.class.getName(), 20, columnStyle).addColumn("Function", "function", String.class.getName(), 30, columnStyle).addColumn("Budget Group", "budgetGroup", String.class.getName(), 120, columnStyle).addColumn("Reference", "reference", String.class.getName(), 35, columnStyle).addColumn("Actuals\\n" + beforePreviousYearRange, "twoPreviousYearActuals", String.class.getName(), 30, columnStyle).addColumn("Actuals\\n" + previousYearRange, "previousYearActuals", String.class.getName(), 30, columnStyle).addColumn("BE\\n" + currentYearRange + " (A)", "currentYearBE", String.class.getName(), 20, columnStyle).addColumn("Addition/\\nReduction\\n(B)", "reappropriation", String.class.getName(), 30, columnStyle).addColumn("Total\\n(A+B)", "total", String.class.getName(), 25, columnStyle).addColumn("Actuals upto\\n" + currentYearRange, "currentYearActuals", String.class.getName(), 25, columnStyle).addColumn("Anticipatory\\nAmount till\\n31 March\\n" + currentYearRange, "anticipatory", String.class.getName(), 40, columnStyle);
        if (isConsolidated) {
            drb.addColumn("RE\\n" + currentYearRange + "\\nProposed", "proposedRE", BigDecimal.class.getName(), 25, columnStyle).addColumn("RE\\n" + currentYearRange + "\\nFixed", "approvedRE", BigDecimal.class.getName(), 25, columnStyle).addColumn("BE\\n" + nextYearRange + "\\nProposed", "proposedBE", BigDecimal.class.getName(), 25, columnStyle).addColumn("BE\\n" + nextYearRange + "\\nFixed", "approvedBE", BigDecimal.class.getName(), 20, columnStyle);
        } else {
            drb.addColumn("RE\\n" + currentYearRange + "\\nProposed", "proposedRE", BigDecimal.class.getName(), 25, columnStyle).addColumn("BE\\n" + nextYearRange + "\\nProposed", "proposedBE", BigDecimal.class.getName(), 20, columnStyle);
        }
        drb.setTitle(heading).setSubtitle(conSubtitle).setPrintBackgroundOnOddRows(true).setWhenNoData("No data", null).setDefaultStyles(this.getBudgetTitleStyle(), this.getBudgetSubTitleTwoStyle(), this.getHeaderBudgetStyle(), this.getDetailBudgetStyle()).setOddRowBackgroundStyle(this.getOddRowStyle()).setDetailHeight(20).setHeaderHeight(35).setUseFullPageWidth(true).setSubtitleHeight(Integer.valueOf(40)).setTitleHeight(Integer.valueOf(70));
        drb.setPageSizeAndOrientation(new Page(612, 1500, false));
        DynamicReport dr = drb.build();
        JRBeanCollectionDataSource ds = new JRBeanCollectionDataSource(bpBeanList);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)" -------------- populated Budget Report for HOD  pdf/excel -----------");
        }
        return DynamicJasperHelper.generateJasperPrint((DynamicReport)dr, (LayoutManager)new ClassicLayoutManager(), (JRDataSource)ds);
    }

    public JasperPrint generateFinancialStatementReportJasperPrint(Statement balanceSheet, String heading, String addheading, String fromDate, String toDate, boolean showScheduleColumn) throws Exception {
        Style detailAmountStyle = this.getDetailAmountStyle();
        FastReportBuilder drb = new FastReportBuilder();
        Style columnStyle = this.getColumnStyle();
        drb = drb.addColumn("Account Code", "glCode", String.class.getName(), 50, columnStyle).addColumn("Head of Account", "accountName", String.class.getName(), 100, columnStyle);
        if (showScheduleColumn) {
            drb.addColumn("Schedule No", "scheduleNo", String.class.getName(), 60, columnStyle);
        }
        drb.setTitle(heading + " " + balanceSheet.getFinancialYear().getFinYearRange() + " " + addheading).setSubtitle("Report Run Date:" + FORMATDDMMYYYY.format(new Date()) + "                                                                                                                                   Amount in " + balanceSheet.getCurrency()).setPrintBackgroundOnOddRows(true).setWhenNoData("No data", null).setDefaultStyles(this.getTitleStyle(), this.getSubTitleStyle(), this.getHeaderStyle(), this.getDetailStyle()).setOddRowBackgroundStyle(this.getOddRowStyle()).setDetailHeight(20).setHeaderHeight(50).setUseFullPageWidth(true);
        drb.setPageSizeAndOrientation(new Page(612, 792, false));
        if (balanceSheet.getFunds().size() > 1) {
            for (Fund fund : balanceSheet.getFunds()) {
                drb.addColumn(fund.getName() + " (Rs)", "fundWiseAmount." + fund.getName(), BigDecimal.class.getName(), 55, false, "0.00", detailAmountStyle);
            }
        }
        drb.addColumn(fromDate + "(Rs)", "currentYearTotal", BigDecimal.class.getName(), 55, false, "0.00", detailAmountStyle).addColumn(toDate + "(Rs)", "previousYearTotal", BigDecimal.class.getName(), 55, false, "0.00", detailAmountStyle);
        DynamicReport dr = drb.build();
        JRBeanCollectionDataSource ds = new JRBeanCollectionDataSource(balanceSheet.getEntries());
        return DynamicJasperHelper.generateJasperPrint((DynamicReport)dr, (LayoutManager)new ClassicLayoutManager(), (JRDataSource)ds);
    }

    public JasperPrint generateBudgetReportJasperPrint(List inputData, String heading, boolean enableBeApproved, boolean enableReApproved, String lastYearRange, String currentYearRange, String nextYearRange) throws Exception {
        Style detailAmountStyle = this.getBudgetReportDetailAmountStyle();
        FastReportBuilder drb = new FastReportBuilder();
        drb = drb.addColumn("Department Code", "departmentCode", String.class.getName(), 50).addColumn("Function Code", "functionCode", String.class.getName(), 50).addColumn("Account Head", "budgetGroupName", String.class.getName(), 90).addColumn("Actuals " + lastYearRange + "(Rs)", "actualsLastYear", BigDecimal.class.getName(), 100, false, "0.00", detailAmountStyle).addColumn("BE " + currentYearRange + "(Rs)", "beCurrentYearApproved", BigDecimal.class.getName(), 100, false, "0.00", detailAmountStyle).addColumn("RE Proposed " + currentYearRange + "(Rs)", "reCurrentYearOriginal", BigDecimal.class.getName(), 100, false, "0.00", detailAmountStyle);
        if (enableReApproved) {
            drb.addColumn("RE Approved " + currentYearRange + "(Rs)", "reCurrentYearApproved", BigDecimal.class.getName(), 100, false, "0.00", detailAmountStyle);
        }
        drb.addColumn("BE Proposed " + nextYearRange + "(Rs)", "beNextYearOriginal", BigDecimal.class.getName(), 100, false, "0.00", detailAmountStyle);
        if (enableBeApproved) {
            drb.addColumn("BE Approved " + nextYearRange + "(Rs)", "beNextYearApproved", BigDecimal.class.getName(), 100, false, "0.00", detailAmountStyle);
        }
        drb.setTitle(heading).setWhenNoData("No data", null).setDefaultStyles(this.getTitleStyle(), this.getSubTitleStyle(), this.getHeaderStyle(), this.getBudgetReportDetailStyle()).setDetailHeight(20).setHeaderHeight(30).setUseFullPageWidth(true);
        drb.setPageSizeAndOrientation(new Page(612, 792, false));
        return DynamicJasperHelper.generateJasperPrint((DynamicReport)drb.build(), (LayoutManager)new ClassicLayoutManager(), (JRDataSource)new JRBeanCollectionDataSource((Collection)inputData));
    }

    public JasperPrint generateFunctionwiseIEJasperPrint(FunctionwiseIE functionwiseIE, String cityName, String type) throws Exception {
        Style detailAmountStyle = this.getDetailAmountStyle();
        FastReportBuilder drb = new FastReportBuilder();
        drb = (FastReportBuilder)drb.addColumn("Sl.No.", "slNo", String.class.getName(), 10).addColumn("Function Code", "functionCode", String.class.getName(), 20).addColumn("Function Head", "functionName", String.class.getName(), 50).addColumn("Total " + type + " (Rs.)", "totalIncome", BigDecimal.class.getName(), 50, false, "0.00", detailAmountStyle).setTitle(cityName).setSubtitle("FUNCTIONWISE " + type.toUpperCase() + " SUBSIDARY REGISTER").setPrintBackgroundOnOddRows(true).setWhenNoData("No Data", null).setDefaultStyles(this.getTitleStyle(), this.getSubTitleStyle(), this.getHeaderStyle(), this.getDetailStyle()).setOddRowBackgroundStyle(this.getOddRowStyle()).setDetailHeight(20).setUseFullPageWidth(true).setTitleHeight(Integer.valueOf(50)).setSubtitleHeight(Integer.valueOf(35));
        for (String s : functionwiseIE.getMajorCodeList()) {
            drb.addColumn(s, "majorcodeWiseAmount." + s, BigDecimal.class.getName(), 35, false, "0.00", detailAmountStyle);
        }
        DynamicReport dr = drb.build();
        JRBeanCollectionDataSource ds = new JRBeanCollectionDataSource(functionwiseIE.getEntries());
        return DynamicJasperHelper.generateJasperPrint((DynamicReport)dr, (LayoutManager)new ClassicLayoutManager(), (JRDataSource)ds);
    }

    private Style getOddRowStyle() {
        Style oddRowStyle = new Style();
        oddRowStyle.setBackgroundColor(new Color(247, 247, 247));
        oddRowStyle.setTransparency(Transparency.OPAQUE);
        return oddRowStyle;
    }

    private Style getSubTitleStyle() {
        Style subTitleStyle = new Style("titleStyle");
        subTitleStyle.setFont(new Font(6, "Verdana", true));
        subTitleStyle.setHorizontalAlign(HorizontalAlign.CENTER);
        return subTitleStyle;
    }

    private Style getBudgetSubTitleStyle() {
        Style subTitleStyle = new Style("titleStyle");
        subTitleStyle.setFont(new Font(6, "Verdana", true));
        subTitleStyle.setHorizontalAlign(HorizontalAlign.RIGHT);
        subTitleStyle.setStretchWithOverflow(true);
        return subTitleStyle;
    }

    private Style getBudgetSubTitleTwoStyle() {
        Style subTitleStyle = new Style("titleStyle");
        subTitleStyle.setFont(new Font(12, "Arial", true));
        subTitleStyle.setHorizontalAlign(HorizontalAlign.RIGHT);
        subTitleStyle.setStretchWithOverflow(true);
        return subTitleStyle;
    }

    private Style getAmountSubTitleStyle() {
        Style subTitleStyle = new Style("SubAmountStyle");
        subTitleStyle.setFont(new Font(8, "Verdana", true));
        subTitleStyle.setHorizontalAlign(HorizontalAlign.CENTER);
        subTitleStyle.setStretchWithOverflow(true);
        return subTitleStyle;
    }

    private Style getTitleStyle() {
        Style titleStyle = new Style("titleStyle");
        titleStyle.setFont(new Font(9, "Verdana", true));
        titleStyle.setHorizontalAlign(HorizontalAlign.CENTER);
        return titleStyle;
    }

    private Style getBudgetTitleStyle() {
        Style titleStyle = new Style("titleStyle");
        titleStyle.setFont(new Font(12, "Arial", true));
        titleStyle.setHorizontalAlign(HorizontalAlign.CENTER);
        return titleStyle;
    }

    private Style getHeaderStyle() {
        Style headerStyle = new Style("header");
        headerStyle.setFont(Font.ARIAL_MEDIUM_BOLD);
        headerStyle.setBorder(Border.THIN());
        headerStyle.setBackgroundColor(new Color(204, 204, 204));
        headerStyle.setTextColor(Color.blue);
        headerStyle.setHorizontalAlign(HorizontalAlign.CENTER);
        headerStyle.setVerticalAlign(VerticalAlign.MIDDLE);
        headerStyle.setTransparency(Transparency.OPAQUE);
        headerStyle.setFont(new Font(8, "Verdana", true));
        headerStyle.setStretchWithOverflow(true);
        return headerStyle;
    }

    private Style getHeaderBudgetStyle() {
        Style headerStyle = new Style("header");
        headerStyle.setFont(Font.ARIAL_MEDIUM_BOLD);
        headerStyle.setBorder(Border.THIN());
        headerStyle.setBackgroundColor(new Color(204, 204, 204));
        headerStyle.setTextColor(Color.black);
        headerStyle.setHorizontalAlign(HorizontalAlign.CENTER);
        headerStyle.setVerticalAlign(VerticalAlign.MIDDLE);
        headerStyle.setTransparency(Transparency.OPAQUE);
        headerStyle.setFont(new Font(12, "Arial", true));
        headerStyle.setStretchWithOverflow(true);
        return headerStyle;
    }

    private Style getDetailAmountStyle() {
        Style detailAmountStyle = new Style("detailAmount");
        detailAmountStyle.setBorderLeft(Border.THIN());
        detailAmountStyle.setBorderRight(Border.THIN());
        detailAmountStyle.setTextColor(Color.blue);
        detailAmountStyle.setHorizontalAlign(HorizontalAlign.RIGHT);
        detailAmountStyle.setFont(new Font(6, "Verdana", true));
        detailAmountStyle.setPaddingRight(Integer.valueOf(2));
        detailAmountStyle.setTransparency(Transparency.OPAQUE);
        detailAmountStyle.setBorderBottom(Border.THIN());
        return detailAmountStyle;
    }

    private Style getConcurrenceAmountStyle() {
        Style detailAmountStyle = new Style("detailAmount");
        detailAmountStyle.setBorderLeft(Border.THIN());
        detailAmountStyle.setBorderRight(Border.THIN());
        detailAmountStyle.setTextColor(Color.BLACK);
        detailAmountStyle.setHorizontalAlign(HorizontalAlign.RIGHT);
        detailAmountStyle.setFont(new Font(6, "Arial", true));
        detailAmountStyle.setPaddingRight(Integer.valueOf(2));
        detailAmountStyle.setTransparency(Transparency.OPAQUE);
        detailAmountStyle.setBorderBottom(Border.THIN());
        return detailAmountStyle;
    }

    private Style getColumnStyle() {
        Style columnStyle = new Style("ColumnCss");
        columnStyle.setBorderLeft(Border.THIN());
        columnStyle.setBorderRight(Border.THIN());
        columnStyle.setTextColor(Color.blue);
        columnStyle.setHorizontalAlign(HorizontalAlign.CENTER);
        columnStyle.setFont(new Font(6, "Verdana", true));
        columnStyle.setTransparency(Transparency.OPAQUE);
        columnStyle.setBorderBottom(Border.THIN());
        return columnStyle;
    }

    private Style getDepartmentTitleStyle() {
        Style titleStyle = new Style("titleStyle");
        titleStyle.setFont(new Font(6, "Arial", true));
        titleStyle.setHorizontalAlign(HorizontalAlign.CENTER);
        return titleStyle;
    }

    private Style getDepartmentwiseSubTitleStyle() {
        Style titleStyle = new Style("titleStyle");
        titleStyle.setFont(new Font(6, "Arial", true));
        titleStyle.setHorizontalAlign(HorizontalAlign.LEFT);
        return titleStyle;
    }

    private Style getBudgetColumnStyle() {
        Style columnStyle = new Style("ColumnCss");
        columnStyle.setBorderLeft(Border.THIN());
        columnStyle.setBorderRight(Border.THIN());
        columnStyle.setTextColor(Color.black);
        columnStyle.setHorizontalAlign(HorizontalAlign.CENTER);
        columnStyle.setFont(new Font(11, "Arial", false));
        columnStyle.setTransparency(Transparency.OPAQUE);
        columnStyle.setBorderBottom(Border.THIN());
        return columnStyle;
    }

    private Style getConcurrenceColumnStyle() {
        Style columnStyle = new Style("ColumnCss");
        columnStyle.setBorderLeft(Border.THIN());
        columnStyle.setBorderRight(Border.THIN());
        columnStyle.setTextColor(Color.black);
        columnStyle.setHorizontalAlign(HorizontalAlign.CENTER);
        columnStyle.setFont(new Font(5, "Arial", false));
        columnStyle.setTransparency(Transparency.OPAQUE);
        columnStyle.setBorderBottom(Border.THIN());
        return columnStyle;
    }

    private Style getBudgetReportDetailAmountStyle() {
        Style detailAmountStyle = new Style("detailAmount");
        detailAmountStyle.setBorderLeft(Border.THIN());
        detailAmountStyle.setBorderRight(Border.THIN());
        detailAmountStyle.setBorderTop(Border.THIN());
        detailAmountStyle.setBorderBottom(Border.THIN());
        detailAmountStyle.setTextColor(Color.black);
        detailAmountStyle.setHorizontalAlign(HorizontalAlign.RIGHT);
        detailAmountStyle.setFont(new Font(8, "Verdana", true));
        detailAmountStyle.setTransparency(Transparency.OPAQUE);
        return detailAmountStyle;
    }

    private Style getFIEHeaderStyle() {
        Style headerStyle = new Style("header");
        headerStyle.setFont(Font.ARIAL_MEDIUM_BOLD);
        headerStyle.setBorder(Border.THIN());
        headerStyle.setBackgroundColor(new Color(204, 204, 204));
        headerStyle.setTextColor(Color.blue);
        headerStyle.setHorizontalAlign(HorizontalAlign.CENTER);
        headerStyle.setVerticalAlign(VerticalAlign.MIDDLE);
        headerStyle.setTransparency(Transparency.OPAQUE);
        headerStyle.setFont(new Font(7, "Verdana", true));
        return headerStyle;
    }

    private Style getFIEAmountStyle() {
        Style detailAmountStyle = new Style("detailAmount");
        detailAmountStyle.setBorderLeft(Border.THIN());
        detailAmountStyle.setBorderRight(Border.THIN());
        detailAmountStyle.setBorderTop(Border.THIN());
        detailAmountStyle.setBorderBottom(Border.THIN());
        detailAmountStyle.setTextColor(Color.black);
        detailAmountStyle.setHorizontalAlign(HorizontalAlign.RIGHT);
        detailAmountStyle.setFont(new Font(6, "Verdana", true));
        detailAmountStyle.setBlankWhenNull(true);
        detailAmountStyle.setPaddingRight(Integer.valueOf(2));
        detailAmountStyle.setPattern("0.00");
        detailAmountStyle.setTransparency(Transparency.OPAQUE);
        return detailAmountStyle;
    }

    private Style getFIECOAStyle() {
        Style detailAmountStyle = new Style("detailCOA");
        detailAmountStyle.setBorderLeft(Border.THIN());
        detailAmountStyle.setBorderRight(Border.THIN());
        detailAmountStyle.setBorderTop(Border.THIN());
        detailAmountStyle.setBorderBottom(Border.THIN());
        detailAmountStyle.setTextColor(Color.black);
        detailAmountStyle.setHorizontalAlign(HorizontalAlign.LEFT);
        detailAmountStyle.setFont(new Font(6, "Verdana", true));
        detailAmountStyle.setBlankWhenNull(true);
        detailAmountStyle.setPaddingLeft(Integer.valueOf(2));
        detailAmountStyle.setTransparency(Transparency.OPAQUE);
        return detailAmountStyle;
    }

    private Style getTBAmountStyle() {
        Style detailAmountStyle = new Style("detailAmount");
        detailAmountStyle.setBorderLeft(Border.THIN());
        detailAmountStyle.setBorderRight(Border.THIN());
        detailAmountStyle.setBorderTop(Border.THIN());
        detailAmountStyle.setBorderBottom(Border.THIN());
        detailAmountStyle.setTextColor(Color.black);
        detailAmountStyle.setHorizontalAlign(HorizontalAlign.RIGHT);
        detailAmountStyle.setFont(new Font(6, "Verdana", true));
        detailAmountStyle.setPaddingRight(Integer.valueOf(2));
        detailAmountStyle.setPattern("0.00");
        detailAmountStyle.setTransparency(Transparency.OPAQUE);
        return detailAmountStyle;
    }

    private Style getCOAStyle() {
        Style detailAmountStyle = new Style("detailCOA");
        detailAmountStyle.setBorderLeft(Border.THIN());
        detailAmountStyle.setBorderRight(Border.THIN());
        detailAmountStyle.setBorderTop(Border.THIN());
        detailAmountStyle.setBorderBottom(Border.THIN());
        detailAmountStyle.setTextColor(Color.black);
        detailAmountStyle.setHorizontalAlign(HorizontalAlign.LEFT);
        detailAmountStyle.setFont(new Font(6, "Verdana", false));
        detailAmountStyle.setBlankWhenNull(true);
        detailAmountStyle.setPaddingLeft(Integer.valueOf(2));
        detailAmountStyle.setTransparency(Transparency.OPAQUE);
        return detailAmountStyle;
    }

    private Style getDetailStyle() {
        Style detailStyle = new Style("detail");
        detailStyle.setBorderLeft(Border.THIN());
        detailStyle.setBorderRight(Border.THIN());
        detailStyle.setTextColor(Color.blue);
        detailStyle.setFont(new Font(8, "Verdana", true));
        detailStyle.setTransparency(Transparency.OPAQUE);
        return detailStyle;
    }

    private Style getDetailBudgetStyle() {
        Style detailStyle = new Style("detail");
        detailStyle.setBorderLeft(Border.THIN());
        detailStyle.setBorderRight(Border.THIN());
        detailStyle.setTextColor(Color.black);
        detailStyle.setFont(new Font(11, "Arial", false));
        detailStyle.setTransparency(Transparency.OPAQUE);
        return detailStyle;
    }

    private Style getBudgetReportDetailStyle() {
        Style detailStyle = new Style("detail");
        detailStyle.setBorderLeft(Border.THIN());
        detailStyle.setBorderRight(Border.THIN());
        detailStyle.setBorderTop(Border.THIN());
        detailStyle.setBorderBottom(Border.THIN());
        detailStyle.setTextColor(Color.black);
        detailStyle.setFont(new Font(8, "Verdana", true));
        detailStyle.setTransparency(Transparency.OPAQUE);
        return detailStyle;
    }

    private void exportReport(JasperPrint jasperPrint, String sizeUnitPoint) throws JRException {
        JRHtmlExporter exporter = new JRHtmlExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
        exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)this.outputBytes);
        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.BETWEEN_PAGES_HTML, (Object)"");
        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)Boolean.TRUE);
        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_USING_IMAGES_TO_ALIGN, (Object)false);
        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.SIZE_UNIT, (Object)sizeUnitPoint);
        exporter.exportReport();
    }

    public JasperPrint exportMajorAndMinorCodewise(List<CommonReportBean> ieWithBudgetList, String cityName, ReportSearch reportSearch, String heading) {
        Style amountStyle = this.getFIEAmountStyle();
        Style textStyle = this.getFIECOAStyle();
        String header = cityName + "\\n" + heading;
        try {
            Style detailAmountStyle = this.getDetailAmountStyle();
            FastReportBuilder drb = new FastReportBuilder();
            drb = reportSearch.getIncExp().equalsIgnoreCase("I") ? drb.addColumn("Sl.No", "slNo", Integer.class.getName(), 18, textStyle).addColumn("COA", "accCode", String.class.getName(), 30, textStyle).addColumn("Account Head", "name", String.class.getName(), 80, textStyle).addColumn("Schedule", "schedule", String.class.getName(), 25, textStyle).addColumn("BE (Rs)", "beAmount", BigDecimal.class.getName(), 70, amountStyle).addColumn("RE (Rs)", "reAmount", BigDecimal.class.getName(), 70, amountStyle).addColumn("Receipt(Current Year) (Rs)", "amount", BigDecimal.class.getName(), 70, amountStyle).addColumn("Receipt(Previous Year) (Rs)", "pyAmount", BigDecimal.class.getName(), 70, amountStyle) : drb.addColumn("Sl.No", "slNo", Integer.class.getName(), 18, textStyle).addColumn("COA", "accCode", String.class.getName(), 20, textStyle).addColumn("Account Head", "name", String.class.getName(), 80, textStyle).addColumn("Schedule", "schedule", String.class.getName(), 30, textStyle).addColumn("BE (Rs)", "beAmount", BigDecimal.class.getName(), 65, amountStyle).addColumn("BE-Appropriation (Rs)", "beAppAmount", BigDecimal.class.getName(), 65, amountStyle).addColumn("RE (Rs)", "reAmount", BigDecimal.class.getName(), 65, amountStyle).addColumn("RE-Appropriation (Rs)", "reAppAmount", BigDecimal.class.getName(), 65, amountStyle).addColumn("Expenditure As On(Previous Year) (Rs)", "pyAmount", BigDecimal.class.getName(), 65, amountStyle).addColumn("Expenditure As On(Current Year) (Rs)", "amount", BigDecimal.class.getName(), 65, amountStyle).addColumn("Balance (Rs)", "computedBalance", BigDecimal.class.getName(), 70, amountStyle);
            drb.setTitle(header).setSubtitle("Report Run Date:" + FORMATDDMMYYYY.format(new Date()) + "                                                                    Amount in Rupees").setPrintBackgroundOnOddRows(true).setWhenNoData("No Data", detailAmountStyle).setDefaultStyles(this.getTitleStyle(), this.getAmountSubTitleStyle(), this.getFIEHeaderStyle(), this.getBudgetReportDetailAmountStyle()).setOddRowBackgroundStyle(this.getOddRowStyle()).setDetailHeight(20).setTitleHeight(Integer.valueOf(50)).setSubtitleStyle(this.getAmountSubTitleStyle()).setSubtitleHeight(Integer.valueOf(30)).setUseFullPageWidth(true);
            DynamicReport dr = drb.build();
            JRBeanCollectionDataSource ds = new JRBeanCollectionDataSource(ieWithBudgetList);
            return DynamicJasperHelper.generateJasperPrint((DynamicReport)dr, (LayoutManager)new ClassicLayoutManager(), (JRDataSource)ds);
        }
        catch (ColumnBuilderException e) {
            LOGGER.error((Object)e, (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error((Object)e, (Throwable)e);
        }
        catch (JRException e) {
            LOGGER.error((Object)e, (Throwable)e);
        }
        return null;
    }

    public JasperPrint exportTBDateRange(List<TrialBalanceBean> al, String cityName, ReportBean rb, String heading, List<Fund> fundList, String expType) {
        Style amountStyle = this.getTBAmountStyle();
        Style textStyle = this.getCOAStyle();
        String header = cityName + "\\n" + heading;
        try {
            Style detailAmountStyle = this.getDetailAmountStyle();
            FastReportBuilder drb = new FastReportBuilder();
            new DynamicReportBuilder();
            if (rb.getReportType().equalsIgnoreCase("daterange")) {
                drb = drb.addColumn("Account Code", "accCode", String.class.getName(), 50, textStyle).addColumn("Account Head", "accName", String.class.getName(), 325, textStyle).addColumn("Opening Balance (Rs)", "openingBal", String.class.getName(), 70, amountStyle).addColumn("Debit (Rs)", "debit", String.class.getName(), 70, amountStyle).addColumn("Credit (Rs)", "credit", String.class.getName(), 70, amountStyle).addColumn("Closing Balance (Rs)", "closingBal", String.class.getName(), 70, amountStyle);
            } else {
                drb = drb.addColumn("Account Code", "accCode", String.class.getName(), 50, textStyle).addColumn("Account Head", "accName", String.class.getName(), 325, textStyle);
                for (Fund f : fundList) {
                    drb.addColumn(f.getName() + " (Rs)", "fundWiseMap." + f.getId() + "_amount", String.class.getName(), 70, false, "0.00", amountStyle);
                }
                drb.addColumn("Total (Rs)", "amount1", String.class.getName(), 70, false, "0.00", amountStyle);
            }
            drb.setTitle(header).setSubtitle("Report Run Date:" + FORMATDDMMYYYY.format(new Date()) + "                                                                    Amount in Rupees").setPrintBackgroundOnOddRows(true).setWhenNoData("No Data", detailAmountStyle).setDefaultStyles(this.getTitleStyle(), this.getAmountSubTitleStyle(), this.getFIEHeaderStyle(), this.getBudgetReportDetailAmountStyle()).setOddRowBackgroundStyle(this.getOddRowStyle()).setDetailHeight(20).setTitleHeight(Integer.valueOf(50)).setSubtitleStyle(this.getAmountSubTitleStyle()).setPageSizeAndOrientation(Page.Page_A4_Landscape()).setSubtitleHeight(Integer.valueOf(30)).setUseFullPageWidth(true);
            if (expType != null && expType.equals("xls")) {
                drb.setIgnorePagination(true);
            }
            DynamicReport dr = drb.build();
            JRBeanCollectionDataSource ds = new JRBeanCollectionDataSource(al);
            return DynamicJasperHelper.generateJasperPrint((DynamicReport)dr, (LayoutManager)new ClassicLayoutManager(), (JRDataSource)ds);
        }
        catch (ColumnBuilderException e) {
            LOGGER.error((Object)e, (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error((Object)e, (Throwable)e);
        }
        catch (JRException e) {
            LOGGER.error((Object)e, (Throwable)e);
        }
        return null;
    }

    public JasperPrint exportDeptwise(List<CommonReportBean> ieWithBudgetList, String cityName, ReportSearch reportSearch, String heading) {
        String header = cityName + "\\n" + heading;
        Style amountStyle = this.getFIEAmountStyle();
        Style textStyle = this.getFIECOAStyle();
        try {
            Style detailAmountStyle = this.getDetailAmountStyle();
            FastReportBuilder drb = new FastReportBuilder();
            drb = reportSearch.getIncExp().equalsIgnoreCase("I") ? drb.addColumn("Sl.No", "slNo", Integer.class.getName(), 18, textStyle).addColumn("Department", "deptName", String.class.getName(), 40, textStyle).addColumn("COA", "accCode", String.class.getName(), 20, textStyle).addColumn("BE (Rs)", "beAmount", BigDecimal.class.getName(), 70, amountStyle).addColumn("RE (Rs)", "reAmount", BigDecimal.class.getName(), 70, amountStyle).addColumn("Account Head", "name", String.class.getName(), 80, textStyle).addColumn("Receipt(Current Year) (Rs)", "amount", BigDecimal.class.getName(), 50, amountStyle).addColumn("Receipt(Previous Year) (Rs)", "pyAmount", BigDecimal.class.getName(), 50, amountStyle) : drb.addColumn("Sl.No", "slNo", Integer.class.getName(), 18, textStyle).addColumn("Department", "deptName", String.class.getName(), 50, textStyle).addColumn("COA", "accCode", String.class.getName(), 20, textStyle).addColumn("Account Head", "name", String.class.getName(), 80, textStyle).addColumn("BE (Rs)", "beAmount", BigDecimal.class.getName(), 60, amountStyle).addColumn("BE-Appropriation (Rs)", "beAppAmount", BigDecimal.class.getName(), 60, amountStyle).addColumn("RE (Rs)", "reAmount", BigDecimal.class.getName(), 60, amountStyle).addColumn("RE-Appropriation (Rs)", "reAppAmount", BigDecimal.class.getName(), 60, amountStyle).addColumn("Expenditure As On(Previous Year) (Rs)", "pyAmount", BigDecimal.class.getName(), 60, amountStyle).addColumn("Expenditure As On(Current Year) (Rs)", "amount", BigDecimal.class.getName(), 60, amountStyle).addColumn("Balance (Rs)", "computedBalance", BigDecimal.class.getName(), 60, amountStyle);
            drb.setTitle(header).setSubtitle("Report Run Date:" + FORMATDDMMYYYY.format(new Date()) + " Amount in Rupees").setPrintBackgroundOnOddRows(true).setWhenNoData("No Data", detailAmountStyle).setDefaultStyles(this.getTitleStyle(), this.getAmountSubTitleStyle(), this.getFIEHeaderStyle(), this.getBudgetReportDetailAmountStyle()).setOddRowBackgroundStyle(this.getOddRowStyle()).setTitleHeight(Integer.valueOf(50)).setSubtitleHeight(Integer.valueOf(20)).setSubtitleStyle(this.getAmountSubTitleStyle()).setDetailHeight(20).setUseFullPageWidth(true);
            DynamicReport dr = drb.build();
            JRBeanCollectionDataSource ds = new JRBeanCollectionDataSource(ieWithBudgetList);
            return DynamicJasperHelper.generateJasperPrint((DynamicReport)dr, (LayoutManager)new ClassicLayoutManager(), (JRDataSource)ds);
        }
        catch (ColumnBuilderException e) {
            LOGGER.error((Object)e, (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error((Object)e, (Throwable)e);
        }
        catch (JRException e) {
            LOGGER.error((Object)e, (Throwable)e);
        }
        return null;
    }

    public JasperPrint exportDetailwise(List<CommonReportBean> ieWithBudgetList, String cityName, ReportSearch reportSearch, String heading) {
        Style amountStyle = this.getFIEAmountStyle();
        Style textStyle = this.getFIECOAStyle();
        String header = cityName + "\\n" + heading;
        try {
            Style detailAmountStyle = this.getDetailAmountStyle();
            FastReportBuilder drb = new FastReportBuilder();
            drb = reportSearch.getIncExp().equalsIgnoreCase("I") ? drb.addColumn("Sl.No", "slNo", Integer.class.getName(), 15, textStyle).addColumn("COA", "accCode", String.class.getName(), 50, textStyle).addColumn("BE (Rs)", "beAmount", BigDecimal.class.getName(), 70, amountStyle).addColumn("RE (Rs)", "reAmount", BigDecimal.class.getName(), 70, amountStyle).addColumn("Account Head", "name", String.class.getName(), 80, textStyle).addColumn("Receipt(Current Year) (Rs)", "amount", BigDecimal.class.getName(), 50, amountStyle).addColumn("Receipt(Previous Year) (Rs)", "beAmount", BigDecimal.class.getName(), 50, amountStyle) : drb.addColumn("Sl.No", "slNo", Integer.class.getName(), 15, textStyle).addColumn("COA", "accCode", String.class.getName(), 50, textStyle).addColumn("Account Head", "name", String.class.getName(), 80, textStyle).addColumn("BE (Rs)", "beAmount", BigDecimal.class.getName(), 40, amountStyle).addColumn("BE-Appropriation (Rs)", "beAppAmount", BigDecimal.class.getName(), 40, amountStyle).addColumn("RE (Rs)", "reAmount", BigDecimal.class.getName(), 40, amountStyle).addColumn("RE-Appropriation (Rs)", "reAppAmount", BigDecimal.class.getName(), 40, amountStyle).addColumn("Expenditure As On(Previous Year) (Rs)", "pyAmount", BigDecimal.class.getName(), 40, amountStyle).addColumn("Expenditure As On(Current Year) (Rs)", "amount", BigDecimal.class.getName(), 40, amountStyle).addColumn("Balance (Rs)", "computedBalance", BigDecimal.class.getName(), 40, amountStyle);
            drb.setTitle(header).setSubtitle("Report Run Date:" + FORMATDDMMYYYY.format(new Date()) + "                                       Amount in Rupees").setPrintBackgroundOnOddRows(true).setWhenNoData("No Data", detailAmountStyle).setDefaultStyles(this.getTitleStyle(), this.getAmountSubTitleStyle(), this.getFIEHeaderStyle(), amountStyle).setOddRowBackgroundStyle(this.getOddRowStyle()).setTitleHeight(Integer.valueOf(60)).setSubtitleHeight(Integer.valueOf(20)).setDetailHeight(20).setUseFullPageWidth(true);
            DynamicReport dr = drb.build();
            JRBeanCollectionDataSource ds = new JRBeanCollectionDataSource(ieWithBudgetList);
            return DynamicJasperHelper.generateJasperPrint((DynamicReport)dr, (LayoutManager)new ClassicLayoutManager(), (JRDataSource)ds);
        }
        catch (ColumnBuilderException e) {
            LOGGER.error((Object)e, (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error((Object)e, (Throwable)e);
        }
        catch (JRException e) {
            LOGGER.error((Object)e, (Throwable)e);
        }
        return null;
    }
}

