/*
 * Decompiled with CFR 0.152.
 */
package org.egov.services.voucher;

import com.exilant.GLEngine.ChartOfAccounts;
import com.exilant.GLEngine.Transaxtion;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.egov.billsaccounting.services.CreateVoucher;
import org.egov.billsaccounting.services.VoucherConstant;
import org.egov.commons.CFunction;
import org.egov.commons.CVoucherHeader;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.voucher.VoucherDetails;
import org.egov.model.voucher.VoucherTypeBean;
import org.egov.model.voucher.WorkflowBean;
import org.egov.pims.commons.Position;
import org.egov.services.voucher.VoucherService;
import org.egov.utils.FinancialConstants;
import org.hibernate.HibernateException;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
@Service
public class JournalVoucherActionHelper {
    private static final Logger LOGGER = Logger.getLogger(JournalVoucherActionHelper.class);
    private static final String FAILED = "Transaction failed";
    private static final String EXCEPTION_WHILE_SAVING_DATA = "Exception while saving data";
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    @Qualifier(value="workflowService")
    private SimpleWorkflowService<CVoucherHeader> voucherHeaderWorkflowService;
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    @Qualifier(value="voucherService")
    private VoucherService voucherService;
    @Autowired
    @Qualifier(value="createVoucher")
    private CreateVoucher createVoucher;
    @Autowired
    @Qualifier(value="chartOfAccounts")
    private ChartOfAccounts chartOfAccounts;

    @Transactional
    public CVoucherHeader createVoucher(List<VoucherDetails> billDetailslist, List<VoucherDetails> subLedgerlist, CVoucherHeader voucherHeader, VoucherTypeBean voucherTypeBean, WorkflowBean workflowBean) throws Exception {
        try {
            voucherHeader.setName(voucherTypeBean.getVoucherName());
            voucherHeader.setType(voucherTypeBean.getVoucherType());
            voucherHeader.setVoucherSubType(voucherTypeBean.getVoucherSubType());
            voucherHeader = this.createVoucherAndledger(billDetailslist, subLedgerlist, voucherHeader);
            if (!"JVGeneral".equalsIgnoreCase(voucherTypeBean.getVoucherName())) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)(" Journal Voucher Action | Bill create | voucher name = " + voucherTypeBean.getVoucherName()));
                }
                this.voucherService.createBillForVoucherSubType(billDetailslist, subLedgerlist, voucherHeader, voucherTypeBean, new BigDecimal(voucherTypeBean.getTotalAmount()));
            }
            if ("Create And Approve".equalsIgnoreCase(workflowBean.getWorkFlowAction()) && voucherHeader.getState() == null) {
                voucherHeader.setStatus(FinancialConstants.CREATEDVOUCHERSTATUS);
            } else {
                voucherHeader = this.transitionWorkFlow(voucherHeader, workflowBean);
                this.voucherService.applyAuditing((AbstractAuditable)voucherHeader.getState());
            }
            this.voucherService.create(voucherHeader);
        }
        catch (ValidationException e) {
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", ((ValidationError)e.getErrors().get(0)).getMessage()));
            throw new ValidationException(errors);
        }
        catch (Exception e) {
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", e.getMessage()));
            throw new ValidationException(errors);
        }
        return voucherHeader;
    }

    @Transactional
    public CVoucherHeader editVoucher(List<VoucherDetails> billDetailslist, List<VoucherDetails> subLedgerlist, CVoucherHeader voucherHeader, VoucherTypeBean voucherTypeBean, WorkflowBean workflowBean, String totaldbamount) throws Exception {
        try {
            voucherHeader = this.voucherService.updateVoucherHeader(voucherHeader, voucherTypeBean);
            this.voucherService.deleteGLDetailByVHId(voucherHeader.getId());
            voucherHeader.getGeneralLedger().removeAll(voucherHeader.getGeneralLedger());
            List<Transaxtion> transactions = this.voucherService.postInTransaction(billDetailslist, subLedgerlist, voucherHeader);
            Transaxtion[] txnList = new Transaxtion[transactions.size()];
            txnList = transactions.toArray(txnList);
            SimpleDateFormat formatter = new SimpleDateFormat("dd-MMM-yyyy");
            if (!this.chartOfAccounts.postTransaxtions(txnList, formatter.format(voucherHeader.getVoucherDate()))) {
                ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
                errors.add(new ValidationError("exp", "Engine Validation failed"));
                throw new ValidationException(errors);
            }
            if (!"JVGeneral".equalsIgnoreCase(voucherHeader.getName())) {
                String totalamount = totaldbamount;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Journal Voucher Modify Action | Bill modify | voucher name = " + voucherHeader.getName()));
                }
                this.voucherService.updateBillForVSubType(billDetailslist, subLedgerlist, voucherHeader, voucherTypeBean, new BigDecimal(totalamount));
            }
            voucherHeader.setStatus(FinancialConstants.PREAPPROVEDVOUCHERSTATUS);
            voucherHeader = this.transitionWorkFlow(voucherHeader, workflowBean);
            this.voucherService.applyAuditing((AbstractAuditable)voucherHeader.getState());
            this.voucherService.persist(voucherHeader);
        }
        catch (ValidationException e) {
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", ((ValidationError)e.getErrors().get(0)).getMessage()));
            throw new ValidationException(errors);
        }
        catch (Exception e) {
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", e.getMessage()));
            throw new ValidationException(errors);
        }
        return voucherHeader;
    }

    @Transactional
    public CVoucherHeader transitionWorkFlow(CVoucherHeader voucherHeader, WorkflowBean workflowBean) {
        DateTime currentDate = new DateTime();
        User user = this.securityUtils.getCurrentUser();
        Assignment userAssignment = (Assignment)this.assignmentService.findByEmployeeAndGivenDate(user.getId(), new Date()).get(0);
        Position pos = null;
        Assignment wfInitiator = null;
        if (null != voucherHeader.getId()) {
            wfInitiator = this.getWorkflowInitiator(voucherHeader);
        }
        if ("Reject".equalsIgnoreCase(workflowBean.getWorkFlowAction())) {
            if (wfInitiator.equals(userAssignment)) {
                voucherHeader.transition(true).end().withSenderName(user.getName()).withComments(workflowBean.getApproverComments()).withDateInfo(currentDate.toDate());
            } else {
                String stateValue = "Rejected";
                voucherHeader.transition(true).withSenderName(user.getName()).withComments(workflowBean.getApproverComments()).withStateValue("Rejected").withDateInfo(currentDate.toDate()).withOwner(wfInitiator.getPosition()).withNextAction("EOA Approval Pending");
            }
        } else if ("Approve".equalsIgnoreCase(workflowBean.getWorkFlowAction())) {
            WorkFlowMatrix wfmatrix = this.voucherHeaderWorkflowService.getWfMatrix(voucherHeader.getStateType(), null, null, null, voucherHeader.getCurrentState().getValue(), null);
            voucherHeader.transition(true).withSenderName(user.getName()).withComments(workflowBean.getApproverComments()).withStateValue(wfmatrix.getCurrentDesignation() + " Approved").withDateInfo(currentDate.toDate()).withOwner(pos).withNextAction(wfmatrix.getNextAction());
            voucherHeader.setStatus(FinancialConstants.CREATEDVOUCHERSTATUS);
            voucherHeader.transition(true).end().withSenderName(user.getName()).withComments(workflowBean.getApproverComments()).withDateInfo(currentDate.toDate());
        } else if ("Cancel".equalsIgnoreCase(workflowBean.getWorkFlowAction())) {
            voucherHeader.setStatus(FinancialConstants.CANCELLEDVOUCHERSTATUS);
            voucherHeader.transition(true).end().withStateValue("Cancelled").withSenderName(user.getName()).withComments(workflowBean.getApproverComments()).withDateInfo(currentDate.toDate());
        } else {
            if (null != workflowBean.getApproverPositionId() && workflowBean.getApproverPositionId() != -1L) {
                pos = (Position)this.persistenceService.find("from Position where id=?", new Object[]{workflowBean.getApproverPositionId()});
            }
            if (null == voucherHeader.getState()) {
                WorkFlowMatrix wfmatrix = this.voucherHeaderWorkflowService.getWfMatrix(voucherHeader.getStateType(), null, null, null, workflowBean.getCurrentState(), null);
                voucherHeader.transition().start().withSenderName(user.getName()).withComments(workflowBean.getApproverComments()).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner(pos).withNextAction(wfmatrix.getNextAction());
            } else if (voucherHeader.getCurrentState().getNextAction().equalsIgnoreCase("END")) {
                voucherHeader.transition(true).end().withSenderName(user.getName()).withComments(workflowBean.getApproverComments()).withDateInfo(currentDate.toDate());
            } else {
                WorkFlowMatrix wfmatrix = this.voucherHeaderWorkflowService.getWfMatrix(voucherHeader.getStateType(), null, null, null, voucherHeader.getCurrentState().getValue(), null);
                voucherHeader.transition(true).withSenderName(user.getName()).withComments(workflowBean.getApproverComments()).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner(pos).withNextAction(wfmatrix.getNextAction());
            }
        }
        return voucherHeader;
    }

    private Assignment getWorkflowInitiator(CVoucherHeader voucherHeader) {
        Assignment wfInitiator = (Assignment)this.assignmentService.findByEmployeeAndGivenDate(voucherHeader.getCreatedBy().getId(), new Date()).get(0);
        return wfInitiator;
    }

    private HashMap<String, Object> createHeaderAndMisDetails(CVoucherHeader voucherHeader) throws ValidationException {
        HashMap<String, Object> headerdetails = new HashMap<String, Object>();
        headerdetails.put("vouchername", voucherHeader.getName());
        headerdetails.put("vouchertype", voucherHeader.getType());
        headerdetails.put((String)VoucherConstant.VOUCHERSUBTYPE, voucherHeader.getVoucherSubType());
        headerdetails.put("vouchernumber", voucherHeader.getVoucherNumber());
        headerdetails.put("voucherdate", voucherHeader.getVoucherDate());
        headerdetails.put("description", voucherHeader.getDescription());
        if (voucherHeader.getVouchermis().getDepartmentid() != null) {
            headerdetails.put("departmentcode", voucherHeader.getVouchermis().getDepartmentid().getCode());
        }
        if (voucherHeader.getFundId() != null) {
            headerdetails.put("fundcode", voucherHeader.getFundId().getCode());
        }
        if (voucherHeader.getVouchermis().getSchemeid() != null) {
            headerdetails.put("schemecode", voucherHeader.getVouchermis().getSchemeid().getCode());
        }
        if (voucherHeader.getVouchermis().getSubschemeid() != null) {
            headerdetails.put("subschemecode", voucherHeader.getVouchermis().getSubschemeid().getCode());
        }
        if (voucherHeader.getVouchermis().getFundsource() != null) {
            headerdetails.put("fundsourcecode", voucherHeader.getVouchermis().getFundsource().getCode());
        }
        if (voucherHeader.getVouchermis().getDivisionid() != null) {
            headerdetails.put("divisionid", voucherHeader.getVouchermis().getDivisionid().getId());
        }
        if (voucherHeader.getVouchermis().getFunctionary() != null) {
            headerdetails.put("functionarycode", voucherHeader.getVouchermis().getFunctionary().getCode());
        }
        if (voucherHeader.getVouchermis().getFunction() != null) {
            headerdetails.put("functioncode", voucherHeader.getVouchermis().getFunction().getCode());
        }
        return headerdetails;
    }

    @Transactional
    public CVoucherHeader createVoucherAndledger(List<VoucherDetails> billDetailslist, List<VoucherDetails> subLedgerlist, CVoucherHeader voucherHeader) {
        try {
            HashMap<String, Object> headerDetails = this.createHeaderAndMisDetails(voucherHeader);
            HashMap<String, String> detailMap = null;
            HashMap<String, Object> subledgertDetailMap = null;
            ArrayList<HashMap<String, Object>> accountdetails = new ArrayList<HashMap<String, Object>>();
            ArrayList<HashMap<String, Object>> subledgerDetails = new ArrayList<HashMap<String, Object>>();
            detailMap = new HashMap<String, String>();
            HashMap<String, String> glcodeMap = new HashMap<String, String>();
            for (VoucherDetails voucherDetail : billDetailslist) {
                detailMap = new HashMap();
                if (voucherDetail.getFunctionIdDetail() != null) {
                    if (voucherHeader.getIsRestrictedtoOneFunctionCenter().booleanValue()) {
                        detailMap.put("functioncode", voucherHeader.getVouchermis().getFunction().getCode());
                    } else if (null != voucherDetail.getFunctionIdDetail()) {
                        CFunction function = (CFunction)this.persistenceService.getSession().load(CFunction.class, (Serializable)voucherDetail.getFunctionIdDetail());
                        detailMap.put("functioncode", function.getCode());
                    } else if (null != voucherHeader.getVouchermis().getFunction()) {
                        detailMap.put("functioncode", voucherHeader.getVouchermis().getFunction().getCode());
                    }
                }
                if (voucherDetail.getCreditAmountDetail().compareTo(BigDecimal.ZERO) == 0) {
                    detailMap.put("debitamount", voucherDetail.getDebitAmountDetail().toString());
                    detailMap.put("creditamount", "0");
                    detailMap.put("glcode", voucherDetail.getGlcodeDetail());
                    accountdetails.add(detailMap);
                    glcodeMap.put(voucherDetail.getGlcodeDetail(), "debit");
                    continue;
                }
                detailMap.put("creditamount", voucherDetail.getCreditAmountDetail().toString());
                detailMap.put("debitamount", "0");
                detailMap.put("glcode", voucherDetail.getGlcodeDetail());
                accountdetails.add(detailMap);
                glcodeMap.put(voucherDetail.getGlcodeDetail(), "credit");
            }
            for (VoucherDetails voucherDetail : subLedgerlist) {
                String amountType;
                subledgertDetailMap = new HashMap<String, Object>();
                String string = amountType = glcodeMap.get(voucherDetail.getSubledgerCode()) != null ? glcodeMap.get(voucherDetail.getSubledgerCode()).toString() : null;
                if (voucherDetail.getFunctionDetail() != null && !voucherDetail.getFunctionDetail().equalsIgnoreCase("") && !voucherDetail.getFunctionDetail().equalsIgnoreCase("0")) {
                    CFunction function = (CFunction)this.persistenceService.find("from CFunction where id = ?", new Object[]{Long.parseLong(voucherDetail.getFunctionDetail())});
                    subledgertDetailMap.put("functioncode", function != null ? function.getCode() : "");
                }
                if (null != amountType && amountType.equalsIgnoreCase("debit")) {
                    subledgertDetailMap.put("debitamount", voucherDetail.getAmount());
                } else if (null != amountType) {
                    subledgertDetailMap.put("creditamount", voucherDetail.getAmount());
                }
                subledgertDetailMap.put("detailtypeid", voucherDetail.getDetailType().getId());
                subledgertDetailMap.put("detailkeyid", voucherDetail.getDetailKeyId());
                subledgertDetailMap.put("glcode", voucherDetail.getSubledgerCode());
                subledgerDetails.add(subledgertDetailMap);
            }
            voucherHeader = this.createVoucher.createPreApprovedVoucher(headerDetails, accountdetails, subledgerDetails);
        }
        catch (HibernateException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new ValidationException(Arrays.asList(new ValidationError(EXCEPTION_WHILE_SAVING_DATA, FAILED)));
        }
        catch (ApplicationRuntimeException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
        catch (ValidationException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Posted to Ledger " + voucherHeader.getId()));
        }
        return voucherHeader;
    }
}

