/*
 * Decompiled with CFR 0.152.
 */
package org.egov.services.report;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.egov.commons.Accountdetailtype;
import org.egov.egf.masters.model.LoanGrantBean;
import org.egov.infstr.services.PersistenceService;
import org.egov.utils.Constants;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.hibernate.type.BigDecimalType;
import org.hibernate.type.IntegerType;
import org.hibernate.type.LongType;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;

public class LoanGrantService
extends PersistenceService {
    static final Logger LOGGER = Logger.getLogger(LoanGrantService.class);

    public LoanGrantService() {
        super(null);
    }

    public LoanGrantService(Class type) {
        super(type);
    }

    public List<Object> schemeUtilizationBy(Integer schemeId, Integer subSchemeId, Date fromDate, Date toDate, List<Integer> projectCodeIdList, Integer fundId) {
        Accountdetailtype detailType = (Accountdetailtype)this.find("from Accountdetailtype where upper(name)=?", new Object[]{"PROJECTCODE"});
        StringBuffer schemeUtilSql = new StringBuffer(512);
        String pcStr = "";
        if (projectCodeIdList != null && projectCodeIdList.size() > 0) {
            pcStr = projectCodeIdList.toString();
            pcStr = pcStr.replace("[", "(");
            pcStr = pcStr.replace("]", ")");
        }
        if (subSchemeId != null) {
            schemeUtilSql.append("select ss.name as subScheme, pc.code as code, vh.voucherNumber as vouchernumber, vh.voucherDate as voucherdate, gld.amount as amount, gld.detailkeyid as id from voucherheader vh, generalledger gl, generalledgerdetail gld , egf_subscheme_project ssp, egw_projectcode pc,sub_scheme ss \twhere  vh.id= gl.voucherheaderid  and vh.status not in (1,2,4)  and gl.id= gld.generalledgerid ");
            if (fromDate != null) {
                schemeUtilSql.append(" and vh.voucherdate>='" + Constants.DD_MON_YYYYFORMAT.format(fromDate) + "'");
            }
            if (toDate != null) {
                schemeUtilSql.append(" and vh.voucherdate<='" + Constants.DD_MON_YYYYFORMAT.format(toDate) + "'");
            }
            schemeUtilSql.append(" and gld.detailtypeid=" + detailType.getId() + " and gld.detailkeyid= ssp.projectcodeid  and ssp.subschemeid=" + subSchemeId + " and ss.id=" + subSchemeId + " and ss.id=ssp.subschemeid and pc.id= gld.detailkeyid  and pc.id= ssp.projectcodeid and vh.fundid=" + fundId + " ");
            if (projectCodeIdList != null && projectCodeIdList.size() > 0) {
                schemeUtilSql.append(" and ssp.projectcodeid in " + pcStr + " ");
            }
            schemeUtilSql.append("ORDER by ss.name, pc.code,vh.voucherdate ");
        } else if (schemeId != null) {
            schemeUtilSql.append("select ss.name as subScheme, pc.code as code, vh.voucherNumber as vouchernumber, vh.voucherDate as voucherdate, gld.amount as amount, gld.detailkeyid as id from voucherheader vh, generalledger gl, generalledgerdetail gld , egf_subscheme_project ssp, egw_projectcode pc,sub_scheme ss,scheme s \twhere  vh.id= gl.voucherheaderid  and vh.status not in (1,2,4)  and gl.id= gld.generalledgerid ");
            if (fromDate != null) {
                schemeUtilSql.append(" and vh.voucherdate>='" + Constants.DD_MON_YYYYFORMAT.format(fromDate) + "'");
            }
            if (toDate != null) {
                schemeUtilSql.append(" and vh.voucherdate<='" + Constants.DD_MON_YYYYFORMAT.format(toDate) + "'");
            }
            schemeUtilSql.append(" and gld.detailtypeid=" + detailType.getId() + " and gld.detailkeyid= ssp.projectcodeid  and ssp.subschemeid=ss.id and ss.schemeid=s.id and s.id=" + schemeId + " and ss.id=ssp.subschemeid and pc.id= gld.detailkeyid  and pc.id= ssp.projectcodeid  and vh.fundid=" + fundId + " ");
            if (projectCodeIdList != null && projectCodeIdList.size() > 0) {
                schemeUtilSql.append(" and ssp.projectcodeid in " + pcStr + " ");
            }
            schemeUtilSql.append(" ORDER by ss.name, pc.code,vh.voucherdate ");
        }
        String schemeUtilSqlQry = schemeUtilSql.toString();
        SQLQuery schemeUtilQry = this.getSession().createSQLQuery(schemeUtilSqlQry);
        schemeUtilQry.addScalar("subScheme").addScalar("code").addScalar("voucherNumber").addScalar("voucherDate").addScalar("amount", (Type)BigDecimalType.INSTANCE).addScalar("id", (Type)LongType.INSTANCE).setResultTransformer(Transformers.aliasToBean(LoanGrantBean.class));
        List projecCodeResultList = schemeUtilQry.list();
        return projecCodeResultList;
    }

    public List<LoanGrantBean> fundingPatternBy(Integer subSchemeId, Integer schemeId) {
        List fundingPatternList = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" select ss.name as subScheme, fa.name  as name ,  sum(lgd.percentage) as amount  from egf_LoanGrantDetail lgd,egf_LoanGrantHeader lgh,egf_fundingAgency fa,sub_scheme ss ");
        if (schemeId != null && subSchemeId == null) {
            sql.append(",Scheme s ");
        }
        sql.append(" where lgd.headerid=lgh.id and fa.id=lgd.agencyid  and ss.id=lgh.subSchemeId ");
        if (schemeId != null && subSchemeId == null) {
            sql.append(" and s.id=ss.schemeid and  s.id= " + schemeId);
        } else {
            sql.append(" and lgh.subSchemeId=" + subSchemeId);
        }
        sql.append(" group by");
        sql.append(" ss.name , fa.name order by ss.name,fa.name");
        SQLQuery patternSql = this.getSearchSession().createSQLQuery(sql.toString());
        patternSql.addScalar("subScheme", (Type)StringType.INSTANCE).addScalar("name", (Type)StringType.INSTANCE).addScalar("amount", (Type)BigDecimalType.INSTANCE).setResultTransformer(Transformers.aliasToBean(LoanGrantBean.class));
        fundingPatternList = patternSql.list();
        return fundingPatternList;
    }

    public List<Object> searchGC(Integer schemeId, Integer subSchemeId, Date fromDate, Date toDate, Long agencyId, Integer pcTypeId, Integer faTypeId, Integer fundId) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting searchGC");
        }
        List<Object> grantContribList = new ArrayList();
        if (agencyId != null & agencyId != -1L) {
            grantContribList = subSchemeId != null ? this.getDataByAgency(schemeId, subSchemeId, fromDate, toDate, agencyId, pcTypeId, faTypeId, fundId) : this.getDataByAgency(schemeId, null, fromDate, toDate, agencyId, pcTypeId, faTypeId, fundId);
        } else {
            List fundingAgencyList = null;
            fundingAgencyList = subSchemeId != null ? this.findAllBy("select distinct fundingAgency.id from LoanGrantDetail lgd  where lgd.header.subScheme.id=? ", new Object[]{subSchemeId}) : this.findAllBy("select distinct lgd.fundingAgency.id from LoanGrantDetail lgd ,LoanGrantHeader lg,SubScheme ss,Scheme s where lg.subScheme.id=ss.id and s.id=ss.scheme.id and lg.id=lgd.header.id and s.id=?", new Object[]{schemeId});
            for (Long faId : fundingAgencyList) {
                List<Object> grantContribListByAgency = new ArrayList();
                grantContribListByAgency = subSchemeId != null ? this.getDataByAgency(schemeId, subSchemeId, fromDate, toDate, faId, pcTypeId, faTypeId, fundId) : this.getDataByAgency(schemeId, null, fromDate, toDate, faId, pcTypeId, faTypeId, fundId);
                grantContribList.addAll(grantContribListByAgency);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("exiting from searchGC  and result size" + grantContribList.size()));
        }
        return grantContribList;
    }

    private List<Object> getDataByAgency(Integer schemeId, Integer subSchemeId, Date fromDate, Date toDate, Long agencyId, Integer pcTypeId, Integer faTypeId, Integer fundId) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Starting getDataByAgency for agencyId:" + agencyId));
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select * from (select distinct vh.vouchernumber as voucherNumber, gld1.amount as amount, null as agencyAmount,pc.code as code, gld1.detailkeyid as detailKey, gld1.detailtypeid detailType from voucherheader vh, generalledger gl1,generalledger gl2, generalledgerdetail gld1, generalledgerdetail gld2, egf_subscheme_project ssp,egw_projectcode pc ");
        if (subSchemeId == null) {
            sql.append(",scheme s,sub_scheme ss ");
        }
        sql.append(" where vh.id= gl1.voucherheaderid and gl1.id= gld1.generalledgerid  and gl2.id=gld2.generalledgerid and gl2.voucherheaderid=vh.id and gl1.creditamount>0  and gl2.debitamount>0 and gld1.detailtypeid=" + pcTypeId + " and gld2.detailtypeid=" + faTypeId + " and ssp.projectcodeid=gld1.detailkeyid and pc.id=gld1.detailkeyid and pc.id=ssp.projectcodeid  and vh.type='Journal Voucher' and vh.name='JVGeneral' and vh.fundid=" + fundId + " ");
        if (subSchemeId != null) {
            sql.append(" and ssp.subschemeId=" + subSchemeId);
        } else {
            sql.append(" and ss.schemeid=s.id and s.id=" + schemeId + " and ssp.subschemeid=ss.id");
        }
        if (fromDate != null) {
            sql.append(" and vh.voucherdate>='" + Constants.DD_MON_YYYYFORMAT.format(fromDate) + "' ");
        }
        if (toDate != null) {
            sql.append(" and vh.voucherdate<='" + Constants.DD_MON_YYYYFORMAT.format(toDate) + "' ");
        }
        sql.append(" and  gld2.detailkeyid=" + agencyId);
        sql.append(" union ");
        sql.append(" select distinct vh.vouchernumber as voucherNumber,null as amount,gld2.amount as agencyAmount,null as code, gld2.detailKeyid as detailKey, gld2.detailtypeid detailType from voucherheader vh, generalledger gl1,generalledger gl2, generalledgerdetail gld1, generalledgerdetail gld2 ");
        sql.append(",egf_loangrantdetail lgd,egf_loanGrantHeader lg,egf_subscheme_project ssp ");
        if (subSchemeId == null) {
            sql.append(",scheme s,sub_scheme ss ");
        }
        sql.append(" where vh.id= gl1.voucherheaderid and gl1.id= gld1.generalledgerid and gl2.id=gld2.generalledgerid and gl2.voucherheaderid=vh.id and gl1.creditamount>0 and gl2.debitamount>0 and gld1.detailtypeid=" + pcTypeId + " and gld2.detailtypeid=" + faTypeId + "and vh.type='Journal Voucher' and vh.name='JVGeneral' and lg.id=lgd.headerid and ssp.projectcodeid=gld1.detailkeyid and vh.fundid=" + fundId + " ");
        if (subSchemeId != null) {
            sql.append("  and lg.subschemeId=" + subSchemeId + " and ssp.subschemeid=" + subSchemeId);
        } else {
            sql.append(" and ss.schemeid=s.id and s.id=" + schemeId + " and lg.subschemeId=ss.id and ssp.subschemeid=ss.id");
        }
        if (fromDate != null) {
            sql.append(" and vh.voucherdate>='" + Constants.DD_MON_YYYYFORMAT.format(fromDate) + "' ");
        }
        if (toDate != null) {
            sql.append(" and vh.voucherdate<='" + Constants.DD_MON_YYYYFORMAT.format(toDate) + "' ");
        }
        sql.append(" and  gld2.detailkeyid=" + agencyId);
        if (subSchemeId != null) {
            sql.append(" and lgd.agencyId= " + agencyId);
        }
        sql.append(" ) order by  voucherNumber,detailType desc,detailKey");
        SQLQuery gcSql = this.getSession().createSQLQuery(sql.toString());
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("sql:  " + sql.toString()));
        }
        gcSql.addScalar("voucherNumber").addScalar("code").addScalar("amount", (Type)BigDecimalType.INSTANCE).addScalar("agencyAmount", (Type)BigDecimalType.INSTANCE).addScalar("detailKey", (Type)IntegerType.INSTANCE).addScalar("detailType", (Type)IntegerType.INSTANCE).setResultTransformer(Transformers.aliasToBean(LoanGrantBean.class));
        List gcList = gcSql.list();
        if (gcList.size() > 0) {
            List<LoanGrantBean> grantAmountList = this.getGrantAmountBy(schemeId, subSchemeId, agencyId);
            if (grantAmountList != null && grantAmountList.size() > 0) {
                ((LoanGrantBean)gcList.get(0)).setAgencyName(grantAmountList.get(0).getAgencyName());
                ((LoanGrantBean)gcList.get(0)).setGrantAmount(grantAmountList.get(0).getGrantAmount());
            }
        } else {
            List<LoanGrantBean> grantAmountList = this.getGrantAmountBy(schemeId, subSchemeId, agencyId);
            if (grantAmountList != null && grantAmountList.size() > 0 && grantAmountList.get(0).getGrantAmount() != null && grantAmountList.get(0).getGrantAmount().compareTo(BigDecimal.ZERO) != 0) {
                gcList.add(0, new LoanGrantBean());
                ((LoanGrantBean)gcList.get(0)).setAgencyName(grantAmountList.get(0).getAgencyName());
                ((LoanGrantBean)gcList.get(0)).setGrantAmount(grantAmountList.get(0).getGrantAmount());
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"exiting getDataByAgency ");
        }
        return gcList;
    }

    private List<LoanGrantBean> getGrantAmountBy(Integer schemeId, Integer subSchemeId, Long agencyId) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Starting getGrantAmountBy for" + agencyId));
        }
        StringBuffer gaSql = new StringBuffer();
        gaSql.append("select fa.name as agencyName, sum( case when lgd.grantamount = null THEN 0 else lgd.grantamount end)*100000 as grantAmount");
        gaSql.append(" from egf_loangrantheader lg, egf_loangrantdetail lgd, egf_fundingagency fa");
        if (subSchemeId == null) {
            gaSql.append(", sub_scheme ss,scheme s");
        }
        gaSql.append(" where lg.id= lgd.headerid and lgd.agencyid=fa.id ");
        if (subSchemeId == null) {
            gaSql.append(" and lg.subschemeid=ss.id and ss.schemeid=s.id and s.id=" + schemeId);
        } else {
            gaSql.append(" and lg.subschemeid=" + subSchemeId);
        }
        gaSql.append(" and lgd.agencyid=" + agencyId);
        gaSql.append(" group by fa.name");
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("GrantAmoountSql for Schemeid" + schemeId + " SubSchemeId " + subSchemeId + "  agencyId" + agencyId + ":" + gaSql.toString()));
        }
        SQLQuery gaSQLQuery = this.getSearchSession().createSQLQuery(gaSql.toString());
        gaSQLQuery.addScalar("agencyName").addScalar("grantAmount", (Type)BigDecimalType.INSTANCE).setResultTransformer(Transformers.aliasToBean(LoanGrantBean.class));
        List galist = gaSQLQuery.list();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Exiting from  getGrantAmountBy for" + agencyId));
        }
        return galist;
    }

    public List<Object> getLoanBy(Integer schemeId, Long agencyId, Integer faTypeId, Integer fundId) {
        List<Object> loanByAgencyList = null;
        if (agencyId != null && agencyId != -1L) {
            loanByAgencyList = this.getLoanByAgency(schemeId, agencyId, faTypeId, fundId);
        } else {
            StringBuffer ss = new StringBuffer(256);
            ss.append("select distinct lgd.fundingAgency.id from LoanGrantDetail lgd ,LoanGrantHeader lg,SubScheme ss,Scheme s where lg.subScheme.id=ss.id and s.id=ss.scheme.id and lg.id=lgd.header.id and s.id=?");
            List agencyList = this.findAllBy(ss.toString(), new Object[]{schemeId});
            loanByAgencyList = new ArrayList<Object>();
            for (Long id : agencyList) {
                loanByAgencyList.addAll(this.getLoanByAgency(schemeId, id, faTypeId, fundId));
            }
        }
        return loanByAgencyList;
    }

    public List<Object> getLoanByAgency(Integer schemeId, Long agencyId, Integer faTypeId, Integer fundId) {
        StringBuffer sql = new StringBuffer(512);
        sql.append("SELECT DISTINCT vh.vouchernumber AS voucherNumber,  gld.amount    AS amount,   gld.detailkeyid               AS detailKey,   gld.detailtypeid detailType ,vh.voucherdate   FROM voucherheader vh,   vouchermis vmis,    generalledger gl,   generalledgerdetail gld   WHERE vh.id            = gl.voucherheaderid   AND gl.id             = gld.generalledgerid   AND gl.debitamount    >0   AND gld.detailtypeid  =  " + faTypeId + " AND vh.type            ='Payment'   AND vh.name            ='Direct Bank Payment'   and vh.status in (0,5)    and vmis.schemeid=  " + schemeId + " and vh.fundid=" + fundId + " and vmis.voucherheaderid=vh.id");
        if (agencyId != null && agencyId != -1L) {
            sql.append(" and  gld.detailkeyid =" + agencyId);
        }
        sql.append(" order by vh.voucherdate ");
        SQLQuery loanSql = this.getSearchSession().createSQLQuery(sql.toString());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("getLoanByAgency sql:" + sql.toString()));
        }
        loanSql.addScalar("voucherNumber").addScalar("amount", (Type)BigDecimalType.INSTANCE).addScalar("detailKey", (Type)IntegerType.INSTANCE).addScalar("detailType", (Type)IntegerType.INSTANCE).setResultTransformer(Transformers.aliasToBean(LoanGrantBean.class));
        List repayedList = loanSql.list();
        List<LoanGrantBean> loanAmountList = this.getLoanAmountBy(schemeId, agencyId);
        if (loanAmountList != null && loanAmountList.size() > 0 && loanAmountList.get(0).getLoanAmount() != null && loanAmountList.get(0).getLoanAmount().compareTo(BigDecimal.ZERO) != 0) {
            repayedList.add(0, new LoanGrantBean());
            ((LoanGrantBean)repayedList.get(0)).setAgencyName(loanAmountList.get(0).getAgencyName());
            ((LoanGrantBean)repayedList.get(0)).setLoanAmount(loanAmountList.get(0).getLoanAmount());
            BigDecimal loanPaidSoFar = this.getLoanPaidSoFar(schemeId, agencyId);
            ((LoanGrantBean)repayedList.get(0)).setAgencyAmount(loanPaidSoFar);
            ((LoanGrantBean)repayedList.get(0)).setBalance(loanAmountList.get(0).getLoanAmount().subtract(loanPaidSoFar));
        }
        return repayedList;
    }

    private BigDecimal getLoanPaidSoFar(Integer schemeId, Long agencyId) {
        BigDecimal amount = BigDecimal.ZERO;
        SQLQuery query = this.getSession().createSQLQuery("select amount as amount from egf_loan_paid where schemeid=" + schemeId + " and agencyid=" + agencyId);
        query.addScalar("amount", (Type)BigDecimalType.INSTANCE).setResultTransformer(Transformers.aliasToBean(LoanGrantBean.class));
        List list = query.list();
        if (list != null && list.size() > 0 && ((LoanGrantBean)list.get(0)).getAmount() != null) {
            amount = ((LoanGrantBean)list.get(0)).getAmount();
        }
        return amount;
    }

    private List<LoanGrantBean> getLoanAmountBy(Integer schemeId, Long agencyId) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Starting getLoanAmountBy for" + agencyId));
        }
        StringBuffer loanSql = new StringBuffer(256);
        loanSql.append("select fa.name as agencyName, sum( case when lgd.loanamount  = null then 0 else lgd.loanamount)*100000 as loanAmount");
        loanSql.append(" from egf_loangrantheader lg, egf_loangrantdetail lgd, egf_fundingagency fa,sub_scheme ss,scheme s");
        loanSql.append(" where lg.id= lgd.headerid and lgd.agencyid=fa.id ");
        loanSql.append(" and lgd.agencyid=" + agencyId);
        loanSql.append(" and lg.subSchemeId=ss.id");
        loanSql.append(" and s.id=" + schemeId);
        loanSql.append(" and s.id=ss.schemeid ");
        loanSql.append(" group by fa.name");
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("GrantAmoountSql for Schemeid" + schemeId + "  agencyId" + agencyId + ":" + loanSql.toString()));
        }
        SQLQuery gaSQLQuery = this.getSearchSession().createSQLQuery(loanSql.toString());
        gaSQLQuery.addScalar("agencyName").addScalar("loanAmount", (Type)BigDecimalType.INSTANCE).setResultTransformer(Transformers.aliasToBean(LoanGrantBean.class));
        List galist = gaSQLQuery.list();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Exiting from  getLoanAmountBy for" + agencyId));
        }
        return galist;
    }
}

