/*
 * Decompiled with CFR 0.152.
 */
package org.egov.model.budget;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import org.egov.commons.CFunction;
import org.egov.commons.EgwStatus;
import org.egov.commons.Functionary;
import org.egov.commons.Fund;
import org.egov.commons.Scheme;
import org.egov.commons.SubScheme;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.workflow.entity.State;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.model.budget.Budget;
import org.egov.model.budget.BudgetGroup;
import org.egov.model.budget.BudgetReAppropriation;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="EGF_BUDGETDETAIL")
@SequenceGenerator(name="SEQ_EGF_BUDGETDETAIL", sequenceName="SEQ_EGF_BUDGETDETAIL", allocationSize=1)
public class BudgetDetail
extends StateAware {
    private static final long serialVersionUID = 5908792258911500512L;
    public static final String SEQ_BUDGETDETAIL = "SEQ_EGF_BUDGETDETAIL";
    @DocumentId
    @Id
    @GeneratedValue(generator="SEQ_EGF_BUDGETDETAIL", strategy=GenerationType.SEQUENCE)
    private Long id;
    @Transient
    private Long nextYrId = null;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="budgetgroup")
    private BudgetGroup budgetGroup;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="budget")
    private Budget budget;
    private BigDecimal originalAmount = new BigDecimal("0.0");
    private BigDecimal approvedAmount = new BigDecimal("0.0");
    @Transient
    private BigDecimal nextYroriginalAmount = new BigDecimal("0.0");
    @Transient
    private BigDecimal nextYrapprovedAmount = new BigDecimal("0.0");
    private BigDecimal budgetAvailable = new BigDecimal("0.0");
    @Column(name="anticipatory_amount")
    private BigDecimal anticipatoryAmount = new BigDecimal("0.0");
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="using_department")
    private Department usingDepartment;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="executing_department")
    private Department executingDepartment;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="function")
    private CFunction function;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="scheme")
    private Scheme scheme;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="fund")
    private Fund fund;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="subScheme")
    private SubScheme subScheme;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="functionary")
    private Functionary functionary;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="boundary")
    private Boundary boundary;
    @Length(max=10)
    private String materializedPath;
    @OneToMany(mappedBy="budgetDetail", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private Set<BudgetReAppropriation> budgetReAppropriations = new HashSet<BudgetReAppropriation>(0);
    @Column(name="document_number")
    private Long documentNumber;
    @Length(max=32)
    private String uniqueNo;
    private BigDecimal planningPercent;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="status")
    private EgwStatus status;
    @Transient
    private String comment;

    public Set<BudgetReAppropriation> getBudgetReAppropriations() {
        return this.budgetReAppropriations;
    }

    public void setBudgetReAppropriations(Set<BudgetReAppropriation> budgetReAppropriations) {
        this.budgetReAppropriations = budgetReAppropriations;
    }

    public BigDecimal getAnticipatoryAmount() {
        return this.anticipatoryAmount;
    }

    public void setAnticipatoryAmount(BigDecimal anticipatoryAmount) {
        this.anticipatoryAmount = anticipatoryAmount;
    }

    public Fund getFund() {
        return this.fund;
    }

    public void setFund(Fund fund) {
        this.fund = fund;
    }

    public BigDecimal getApprovedAmount() {
        return this.approvedAmount;
    }

    public void setApprovedAmount(BigDecimal fixedAmount) {
        this.approvedAmount = fixedAmount;
    }

    public Department getUsingDepartment() {
        return this.usingDepartment;
    }

    public void setUsingDepartment(Department department) {
        this.usingDepartment = department;
    }

    public Department getExecutingDepartment() {
        return this.executingDepartment;
    }

    public void setExecutingDepartment(Department department) {
        this.executingDepartment = department;
    }

    public CFunction getFunction() {
        return this.function;
    }

    public void setFunction(CFunction function) {
        this.function = function;
    }

    public Scheme getScheme() {
        return this.scheme;
    }

    public void setScheme(Scheme scheme) {
        this.scheme = scheme;
    }

    public SubScheme getSubScheme() {
        return this.subScheme;
    }

    public void setSubScheme(SubScheme subscheme) {
        this.subScheme = subscheme;
    }

    public Functionary getFunctionary() {
        return this.functionary;
    }

    public void setFunctionary(Functionary functionary) {
        this.functionary = functionary;
    }

    public Budget getBudget() {
        return this.budget;
    }

    public void setBudget(Budget budget) {
        this.budget = budget;
    }

    public BigDecimal getBudgetAvailable() {
        return this.budgetAvailable;
    }

    public void setBudgetAvailable(BigDecimal budgetAvailable) {
        this.budgetAvailable = budgetAvailable;
    }

    public BudgetGroup getBudgetGroup() {
        return this.budgetGroup;
    }

    public void setBudgetGroup(BudgetGroup budgetGroup) {
        this.budgetGroup = budgetGroup;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public BigDecimal getOriginalAmount() {
        return this.originalAmount;
    }

    public void setOriginalAmount(BigDecimal originalAmount) {
        this.originalAmount = originalAmount;
    }

    public Boundary getBoundary() {
        return this.boundary;
    }

    public void setBoundary(Boundary boundaryID) {
        this.boundary = boundaryID;
    }

    public String getStateDetails() {
        return this.getBudget().getName() + "-" + this.getFunction().getName();
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getMaterializedPath() {
        return this.materializedPath;
    }

    public void setMaterializedPath(String materializedPath) {
        this.materializedPath = materializedPath;
    }

    public void copyFrom(BudgetDetail detail) {
        this.budget = detail.getBudget();
        this.budgetGroup = detail.getBudgetGroup();
        this.executingDepartment = detail.getExecutingDepartment();
        this.usingDepartment = detail.getUsingDepartment();
        this.function = detail.getFunction();
        this.functionary = detail.getFunctionary();
        this.boundary = detail.getBoundary();
        this.fund = detail.getFund();
        this.scheme = detail.getScheme();
        this.subScheme = detail.getSubScheme();
    }

    public List<BudgetReAppropriation> getNonApprovedReAppropriations() {
        ArrayList<BudgetReAppropriation> reAppList = new ArrayList<BudgetReAppropriation>();
        this.budgetReAppropriations = this.budgetReAppropriations == null ? new HashSet() : this.budgetReAppropriations;
        for (BudgetReAppropriation entry : this.budgetReAppropriations) {
            if (entry.getStatus().getDescription().equalsIgnoreCase("Approved")) continue;
            reAppList.add(entry);
        }
        return reAppList;
    }

    public BigDecimal getApprovedReAppropriationsTotal() {
        BigDecimal total = BigDecimal.ZERO;
        this.budgetReAppropriations = this.budgetReAppropriations == null ? new HashSet() : this.budgetReAppropriations;
        for (BudgetReAppropriation entry : this.budgetReAppropriations) {
            if (entry.getStatus().getDescription().equalsIgnoreCase("Cancelled")) continue;
            if (entry.getAdditionAmount() != null && BigDecimal.ZERO.compareTo(entry.getAdditionAmount()) != 0) {
                total = total.add(entry.getAdditionAmount());
                continue;
            }
            total = total.subtract(entry.getDeductionAmount());
        }
        return total;
    }

    public BigDecimal getApprovedReAppropriationsTotalAsOnDate(Date asOnDate) {
        BigDecimal total = BigDecimal.ZERO;
        this.budgetReAppropriations = this.budgetReAppropriations == null ? new HashSet() : this.budgetReAppropriations;
        for (BudgetReAppropriation entry : this.budgetReAppropriations) {
            if (entry.getStatus().getDescription().equalsIgnoreCase("Cancelled") || !entry.getCreatedDate().before(asOnDate)) continue;
            if (entry.getAdditionAmount() != null && BigDecimal.ZERO.compareTo(entry.getAdditionAmount()) != 0) {
                total = total.add(entry.getAdditionAmount());
                continue;
            }
            total = total.subtract(entry.getDeductionAmount());
        }
        return total;
    }

    public boolean compareTo(BudgetDetail other) {
        boolean same = true;
        if (this.budgetGroup != null && other.budgetGroup != null && !this.budgetGroup.getId().equals(other.getBudgetGroup().getId())) {
            same = false;
        }
        if (this.function != null && other.function != null && !this.function.getId().equals(other.getFunction().getId())) {
            same = false;
        }
        if (this.fund != null && other.fund != null && !this.fund.getId().equals(other.getFund().getId())) {
            same = false;
        }
        if (this.functionary != null && other.functionary != null && !this.functionary.getId().equals(other.getFunctionary().getId())) {
            same = false;
        }
        if (this.boundary != null && other.boundary != null && !this.boundary.getId().equals(other.getBoundary().getId())) {
            same = false;
        }
        if (this.executingDepartment != null && other.executingDepartment != null && !this.executingDepartment.getId().equals(other.getExecutingDepartment().getId())) {
            same = false;
        }
        if (this.scheme != null && other.scheme != null && !this.scheme.getId().equals(other.getScheme().getId())) {
            same = false;
        }
        if (this.subScheme != null && other.subScheme != null && !this.subScheme.getId().equals(other.getSubScheme().getId())) {
            same = false;
        }
        return same;
    }

    public void addApprovedReAppropriationAmount() {
        BigDecimal reAppAmount = this.getApprovedReAppropriationsTotal();
        this.approvedAmount.add(reAppAmount == null ? BigDecimal.ZERO : reAppAmount);
    }

    public void setDocumentNumber(Long documentNumber) {
        this.documentNumber = documentNumber;
    }

    public Long getDocumentNumber() {
        return this.documentNumber;
    }

    public String getUniqueNo() {
        return this.uniqueNo;
    }

    public void setUniqueNo(String uniqueNo) {
        this.uniqueNo = uniqueNo;
    }

    public BigDecimal getNextYroriginalAmount() {
        return this.nextYroriginalAmount;
    }

    public void setNextYroriginalAmount(BigDecimal nextYroriginalAmount) {
        this.nextYroriginalAmount = nextYroriginalAmount;
    }

    public BigDecimal getNextYrapprovedAmount() {
        return this.nextYrapprovedAmount;
    }

    public void setNextYrapprovedAmount(BigDecimal nextYrapprovedAmount) {
        this.nextYrapprovedAmount = nextYrapprovedAmount;
    }

    public Long getNextYrId() {
        return this.nextYrId;
    }

    public void setNextYrId(Long nextYrId) {
        this.nextYrId = nextYrId;
    }

    public BigDecimal getPlanningPercent() {
        return this.planningPercent;
    }

    public void setPlanningPercent(BigDecimal planningPercent) {
        this.planningPercent = planningPercent;
    }

    public String myLinkId() {
        return this.getBudget().getId().toString();
    }

    public void setWfState(State state) {
        this.setState(state);
    }

    public EgwStatus getStatus() {
        return this.status;
    }

    public void setStatus(EgwStatus status) {
        this.status = status;
    }
}

