/*
 * Decompiled with CFR 0.152.
 */
package org.egov.model.budget;

import java.util.Date;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.egov.commons.CFinancialYear;
import org.egov.commons.EgwStatus;
import org.egov.infra.persistence.validator.annotation.Required;
import org.egov.infra.persistence.validator.annotation.Unique;
import org.egov.infra.workflow.entity.State;
import org.egov.infra.workflow.entity.StateAware;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="EGF_BUDGET")
@SequenceGenerator(name="SEQ_EGF_BUDGET", sequenceName="SEQ_EGF_BUDGET", allocationSize=1)
@Unique(fields={"name"}, id="id", columnName={"NAME"}, tableName="EGF_BUDGET", enableDfltMsg=true)
public class Budget
extends StateAware {
    private static final long serialVersionUID = 3592259793739732756L;
    public static final String SEQ_BUDGET = "SEQ_EGF_BUDGET";
    @DocumentId
    @Id
    @GeneratedValue(generator="SEQ_EGF_BUDGET", strategy=GenerationType.SEQUENCE)
    private Long id;
    @Required(message="Name should not be empty")
    @Length(max=250, message="Max 250 characters are allowed for description")
    private String name;
    private String isbere;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FINANCIALYEARID")
    private CFinancialYear financialYear;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="parent")
    private Budget parent;
    @Length(max=250, message="Max 250 characters are allowed for description")
    private String description;
    @Column(name="AS_ON_DATE")
    private Date asOnDate;
    private boolean isActiveBudget;
    private boolean isPrimaryBudget;
    @Length(max=10, message="Max 10 characters are allowed for description")
    private String materializedPath;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="reference_budget")
    private Budget referenceBudget;
    @Column(name="DOCUMENT_NUMBER")
    private Long documentNumber;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="STATUS")
    private EgwStatus status;
    @Transient
    private String searchBere;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Budget getParent() {
        return this.parent;
    }

    public void setParent(Budget parent) {
        this.parent = parent;
    }

    public Date getAsOnDate() {
        return this.asOnDate;
    }

    public void setAsOnDate(Date asOnDate) {
        this.asOnDate = asOnDate;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    @Required(message="Financial Year is required")
    public CFinancialYear getFinancialYear() {
        return this.financialYear;
    }

    public void setFinancialYear(CFinancialYear finYear) {
        this.financialYear = finYear;
    }

    @Required(message="Name should not be empty")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Required(message="BE/RE is required")
    public String getIsbere() {
        if (this.isbere == null) {
            this.isbere = "BE";
        }
        return this.isbere;
    }

    public void setIsbere(String isbere) {
        this.isbere = isbere;
    }

    public boolean getIsActiveBudget() {
        return this.isActiveBudget;
    }

    public void setIsActiveBudget(boolean isActiveBudget) {
        this.isActiveBudget = isActiveBudget;
    }

    public boolean getIsPrimaryBudget() {
        return this.isPrimaryBudget;
    }

    public void setIsPrimaryBudget(boolean isPrimaryBudget) {
        this.isPrimaryBudget = isPrimaryBudget;
    }

    public String getStateDetails() {
        return this.name;
    }

    public String getMaterializedPath() {
        return this.materializedPath;
    }

    public void setMaterializedPath(String materializedPath) {
        this.materializedPath = materializedPath;
    }

    public void setReferenceBudget(Budget reference) {
        this.referenceBudget = reference;
    }

    public Budget getReferenceBudget() {
        return this.referenceBudget;
    }

    public void setDocumentNumber(Long documentNumber) {
        this.documentNumber = documentNumber;
    }

    public Long getDocumentNumber() {
        return this.documentNumber;
    }

    public String myLinkId() {
        return this.getId().toString();
    }

    public EgwStatus getStatus() {
        return this.status;
    }

    public void setStatus(EgwStatus status) {
        this.status = status;
    }

    public void setWfState(State state) {
        this.setState(state);
    }

    public String getSearchBere() {
        return this.searchBere;
    }

    public void setSearchBere(String searchBere) {
        this.searchBere = searchBere;
    }
}

