/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.utils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.workflow.entity.State;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.pims.commons.Position;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class FinancialUtils {
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private PositionMasterService positionMasterService;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public EgwStatus getStatusByModuleAndCode(String moduleType, String code) {
        return this.egwStatusHibernateDAO.getStatusByModuleAndCode(moduleType, code);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public List<EgwStatus> getStatusByModule(String moduleType) {
        return this.egwStatusHibernateDAO.getStatusByModule(moduleType);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public EgwStatus getStatusById(Integer id) {
        return this.egwStatusHibernateDAO.findById(id, true);
    }

    public String getApproverDetails(EgwStatus status, State state, Long id, Long approvalPosition) {
        Assignment currentUserAssignment = this.assignmentService.getPrimaryAssignmentForGivenRange(this.securityUtils.getCurrentUser().getId(), new Date(), new Date());
        Assignment assignObj = null;
        List<Object> asignList = null;
        if (approvalPosition != null) {
            assignObj = this.assignmentService.getPrimaryAssignmentForPositon(approvalPosition);
        }
        if (assignObj != null) {
            asignList = new ArrayList<Assignment>();
            asignList.add(assignObj);
        } else if (assignObj == null && approvalPosition != null) {
            asignList = this.assignmentService.getAssignmentsForPosition(approvalPosition, new Date());
        }
        String nextDesign = "";
        if (asignList != null) {
            nextDesign = !asignList.isEmpty() ? ((Assignment)asignList.get(0)).getDesignation().getName() : "";
        }
        String approverDetails = "";
        approverDetails = !status.getCode().equals("REJECTED".toString()) ? id + "," + this.getApproverName(approvalPosition) + "," + (currentUserAssignment != null ? currentUserAssignment.getDesignation().getName() : "") + "," + (nextDesign != null ? nextDesign : "") : id + "," + this.getApproverName(state.getOwnerPosition().getId()) + "," + (currentUserAssignment != null ? currentUserAssignment.getDesignation().getName() : "") + "," + (nextDesign != null ? state.getOwnerPosition().getDeptDesig().getDesignation().getName() : "");
        return approverDetails;
    }

    public String getApproverName(Long approvalPosition) {
        Assignment assignment = null;
        List<Object> asignList = null;
        if (approvalPosition != null) {
            assignment = this.assignmentService.getPrimaryAssignmentForPositionAndDate(approvalPosition, new Date());
        }
        if (assignment != null) {
            asignList = new ArrayList<Assignment>();
            asignList.add(assignment);
        } else if (assignment == null) {
            asignList = this.assignmentService.getAssignmentsForPosition(approvalPosition, new Date());
        }
        return !asignList.isEmpty() ? ((Assignment)asignList.get(0)).getEmployee().getName() : "";
    }

    public Long getApproverPosition(String designationName, State state, Long createdById) {
        String[] desgnArray;
        Set stateHistoryList = state.getHistory();
        Long approverPosition = 0L;
        String[] stringArray = desgnArray = designationName != null ? designationName.split(",") : null;
        if (stateHistoryList != null && !stateHistoryList.isEmpty()) {
            for (StateHistory stateHistory : stateHistoryList) {
                if (stateHistory.getOwnerPosition() == null) continue;
                List assignmentList = this.assignmentService.getAssignmentsForPosition(stateHistory.getOwnerPosition().getId(), new Date());
                block1: for (Assignment assgn : assignmentList) {
                    if (desgnArray == null) continue;
                    String[] stringArray2 = desgnArray;
                    int n = stringArray2.length;
                    for (int i = 0; i < n; ++i) {
                        String str = stringArray2[i];
                        if (!assgn.getDesignation().getName().equalsIgnoreCase(str)) continue;
                        approverPosition = stateHistory.getOwnerPosition().getId();
                        continue block1;
                    }
                }
            }
            if (approverPosition == 0L) {
                State stateObj = state;
                List assignmentList = this.assignmentService.getAssignmentsForPosition(stateObj.getOwnerPosition().getId(), new Date());
                block3: for (Assignment assgn : assignmentList) {
                    if (desgnArray == null) continue;
                    for (String str : desgnArray) {
                        if (!assgn.getDesignation().getName().equalsIgnoreCase(str)) continue;
                        approverPosition = stateObj.getOwnerPosition().getId();
                        continue block3;
                    }
                }
            }
        } else {
            Position posObjToClerk = this.positionMasterService.getCurrentPositionForUser(createdById);
            approverPosition = posObjToClerk.getId();
        }
        return approverPosition;
    }
}

