/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.model;

import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.egov.commons.CFinancialYear;

@Entity
@Table(name="closedperiods")
@SequenceGenerator(name="seq_closedperiods", sequenceName="seq_closedperiods", allocationSize=1)
public class ClosedPeriod
implements Comparable<ClosedPeriod> {
    private static final long serialVersionUID = 1L;
    public static final String SEQ = "seq_closedperiods";
    @Id
    @GeneratedValue(generator="seq_closedperiods", strategy=GenerationType.SEQUENCE)
    private Long id = null;
    private Date startingDate;
    private Date endingDate;
    private Boolean isClosed = false;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="financialYearId", nullable=false)
    private CFinancialYear cFinancialYearId;

    public Long getId() {
        return this.id;
    }

    public Boolean getIsClosed() {
        return this.isClosed;
    }

    public CFinancialYear getcFinancialYearId() {
        return this.cFinancialYearId;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setIsClosed(Boolean isClosed) {
        this.isClosed = isClosed;
    }

    public void setcFinancialYearId(CFinancialYear cFinancialYearId) {
        this.cFinancialYearId = cFinancialYearId;
    }

    public Date getStartingDate() {
        return this.startingDate;
    }

    public void setStartingDate(Date startingDate) {
        this.startingDate = startingDate;
    }

    public Date getEndingDate() {
        return this.endingDate;
    }

    public void setEndingDate(Date endingDate) {
        this.endingDate = endingDate;
    }

    @Override
    public int compareTo(ClosedPeriod p) {
        if (p.getcFinancialYearId().getFinYearRange().compareTo(this.getcFinancialYearId().getFinYearRange()) > 0) {
            return -1;
        }
        if (p.getcFinancialYearId().getFinYearRange().compareTo(this.getcFinancialYearId().getFinYearRange()) < 0) {
            return 1;
        }
        return 0;
    }
}

