/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.expensebill.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.script.ScriptContext;
import org.egov.commons.Scheme;
import org.egov.commons.SubScheme;
import org.egov.commons.service.CheckListService;
import org.egov.egf.autonumber.ExpenseBillNumberGenerator;
import org.egov.egf.billsubtype.service.EgBillSubTypeService;
import org.egov.egf.expensebill.repository.ExpenseBillRepository;
import org.egov.egf.utils.FinancialUtils;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.EisCommonService;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.script.service.ScriptService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.utils.autonumber.AutonumberServiceBeanResolver;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.workflow.entity.State;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.infstr.models.EgChecklists;
import org.egov.model.bills.EgBillregister;
import org.egov.pims.commons.Position;
import org.egov.services.masters.SchemeService;
import org.egov.services.masters.SubSchemeService;
import org.egov.services.voucher.VoucherService;
import org.egov.utils.CheckListHelper;
import org.hibernate.Session;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ExpenseBillService {
    private static final Logger LOG = LoggerFactory.getLogger(ExpenseBillService.class);
    @PersistenceContext
    private EntityManager entityManager;
    private final ExpenseBillRepository expenseBillRepository;
    @Autowired
    private EgBillSubTypeService egBillSubTypeService;
    @Autowired
    private SchemeService schemeService;
    @Autowired
    private SubSchemeService subSchemeService;
    @Autowired
    private FinancialUtils financialUtils;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    protected AppConfigValueService appConfigValuesService;
    @Autowired
    private AutonumberServiceBeanResolver beanResolver;
    private final ScriptService scriptExecutionService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private PositionMasterService positionMasterService;
    @Autowired
    @Qualifier(value="voucherService")
    private VoucherService voucherService;
    @Autowired
    private EisCommonService eisCommonService;
    @Autowired
    private CheckListService checkListService;
    @Autowired
    @Qualifier(value="workflowService")
    private SimpleWorkflowService<EgBillregister> egBillregisterRegisterWorkflowService;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Autowired
    public ExpenseBillService(ExpenseBillRepository expenseBillRepository, ScriptService scriptExecutionService) {
        this.expenseBillRepository = expenseBillRepository;
        this.scriptExecutionService = scriptExecutionService;
    }

    public EgBillregister getById(Long id) {
        return (EgBillregister)this.expenseBillRepository.findOne(id);
    }

    public EgBillregister getByBillnumber(String billNumber) {
        return this.expenseBillRepository.findByBillnumber(billNumber);
    }

    @Transactional
    public EgBillregister create(EgBillregister egBillregister, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction) {
        egBillregister.setBilltype("Final Bill");
        egBillregister.setExpendituretype("Expense");
        egBillregister.setPassedamount(egBillregister.getBillamount());
        egBillregister.getEgBillregistermis().setEgBillregister(egBillregister);
        egBillregister.getEgBillregistermis().setLastupdatedtime(new Date());
        if (egBillregister.getEgBillregistermis().getEgBillSubType() != null && egBillregister.getEgBillregistermis().getEgBillSubType().getId() != null) {
            egBillregister.getEgBillregistermis().setEgBillSubType(this.egBillSubTypeService.getById(egBillregister.getEgBillregistermis().getEgBillSubType().getId()));
        }
        if (egBillregister.getEgBillregistermis().getScheme() != null && egBillregister.getEgBillregistermis().getScheme().getId() != null) {
            egBillregister.getEgBillregistermis().setScheme((Scheme)this.schemeService.findById(egBillregister.getEgBillregistermis().getScheme().getId(), false));
        } else {
            egBillregister.getEgBillregistermis().setScheme(null);
        }
        if (egBillregister.getEgBillregistermis().getSubScheme() != null && egBillregister.getEgBillregistermis().getSubScheme().getId() != null) {
            egBillregister.getEgBillregistermis().setSubScheme((SubScheme)this.subSchemeService.findById(egBillregister.getEgBillregistermis().getSubScheme().getId(), false));
        } else {
            egBillregister.getEgBillregistermis().setSubScheme(null);
        }
        if (this.isBillNumberGenerationAuto()) {
            egBillregister.setBillnumber(this.getNextBillNumber(egBillregister));
        }
        try {
            this.checkBudgetAndGenerateBANumber(egBillregister);
        }
        catch (ValidationException e) {
            throw new ValidationException(e.getErrors());
        }
        List<CheckListHelper> checkLists = egBillregister.getCheckLists();
        EgBillregister savedEgBillregister = (EgBillregister)this.expenseBillRepository.save(egBillregister);
        this.createCheckList(egBillregister, checkLists);
        if (workFlowAction.equals("Create And Approve")) {
            egBillregister.setStatus(this.financialUtils.getStatusByModuleAndCode("EXPENSEBILL", "Approved"));
        } else {
            egBillregister.setStatus(this.financialUtils.getStatusByModuleAndCode("EXPENSEBILL", "CREATED"));
            this.createExpenseBillRegisterWorkflowTransition(savedEgBillregister, approvalPosition, approvalComent, additionalRule, workFlowAction);
        }
        savedEgBillregister.getEgBillregistermis().setSourcePath("/EGF/expensebill/view/" + savedEgBillregister.getId().toString());
        return (EgBillregister)this.expenseBillRepository.save(savedEgBillregister);
    }

    @Transactional
    public void createCheckList(EgBillregister egBillregister, List<CheckListHelper> checkLists) {
        for (CheckListHelper helper : checkLists) {
            EgChecklists checkList = new EgChecklists();
            AppConfigValues configValue = this.appConfigValuesService.getById(helper.getId());
            checkList.setObjectid(egBillregister.getId());
            checkList.setAppconfigvalue(configValue);
            if (helper.getVal() != null) {
                checkList.setChecklistvalue(helper.getVal());
            } else {
                checkList.setChecklistvalue("na");
            }
            this.checkListService.create(checkList);
        }
    }

    public void checkBudgetAndGenerateBANumber(EgBillregister egBillregister) {
        ScriptContext scriptContext = ScriptService.createContext((Object[])new Object[]{"voucherService", this.voucherService, "bill", egBillregister});
        this.scriptExecutionService.executeScript("egf.bill.budgetcheck", scriptContext);
    }

    @Transactional
    public EgBillregister update(EgBillregister egBillregister, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction) throws ValidationException, IOException {
        EgBillregister updatedegBillregister = null;
        this.expenseBillRegisterStatusChange(egBillregister, workFlowAction);
        updatedegBillregister = (EgBillregister)this.expenseBillRepository.save(egBillregister);
        this.createExpenseBillRegisterWorkflowTransition(updatedegBillregister, approvalPosition, approvalComent, additionalRule, workFlowAction);
        updatedegBillregister = (EgBillregister)this.expenseBillRepository.save(updatedegBillregister);
        return updatedegBillregister;
    }

    public void expenseBillRegisterStatusChange(EgBillregister egBillregister, String workFlowAction) throws ValidationException {
        if (null != egBillregister && null != egBillregister.getStatus() && null != egBillregister.getStatus().getCode()) {
            if ("CREATED".equals(egBillregister.getStatus().getCode()) && egBillregister.getState() != null && workFlowAction.equalsIgnoreCase("Approve")) {
                egBillregister.setStatus(this.financialUtils.getStatusByModuleAndCode("EXPENSEBILL", "Approved"));
            } else if (workFlowAction.equals("Reject")) {
                egBillregister.setStatus(this.financialUtils.getStatusByModuleAndCode("EXPENSEBILL", "Rejected"));
            } else if ("Rejected".equals(egBillregister.getStatus().getCode()) && workFlowAction.equals("Cancel")) {
                egBillregister.setStatus(this.financialUtils.getStatusByModuleAndCode("EXPENSEBILL", "Cancelled"));
            } else if ("Rejected".equals(egBillregister.getStatus().getCode()) && workFlowAction.equals("Forward")) {
                egBillregister.setStatus(this.financialUtils.getStatusByModuleAndCode("EXPENSEBILL", "CREATED"));
            }
        }
    }

    public boolean isBillNumberGenerationAuto() {
        List configValuesByModuleAndKey = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "Bill_Number_Geneartion_Auto");
        if (configValuesByModuleAndKey.size() > 0) {
            return "Y".equals(((AppConfigValues)configValuesByModuleAndKey.get(0)).getValue());
        }
        return false;
    }

    private String getNextBillNumber(EgBillregister bill) {
        ExpenseBillNumberGenerator b = (ExpenseBillNumberGenerator)this.beanResolver.getAutoNumberServiceFor(ExpenseBillNumberGenerator.class);
        String billNumber = b.getNextNumber(bill);
        return billNumber;
    }

    public void createExpenseBillRegisterWorkflowTransition(EgBillregister egBillregister, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(" Create WorkFlow Transition Started  ...");
        }
        User user = this.securityUtils.getCurrentUser();
        DateTime currentDate = new DateTime();
        Position pos = null;
        Assignment wfInitiator = null;
        String currState = "";
        if (null != egBillregister.getId()) {
            wfInitiator = this.assignmentService.getPrimaryAssignmentForUser(egBillregister.getCreatedBy().getId());
        }
        if ("Reject".toString().equalsIgnoreCase(workFlowAction)) {
            String stateValue = "Rejected";
            egBillregister.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue("Rejected").withDateInfo(currentDate.toDate()).withOwner(wfInitiator.getPosition()).withNextAction("").withNatureOfTask("Expense Bill");
        } else {
            if (null != approvalPosition && approvalPosition != -1L && !approvalPosition.equals(0L)) {
                pos = this.positionMasterService.getPositionById(approvalPosition);
            }
            WorkFlowMatrix wfmatrix = null;
            if (null == egBillregister.getState()) {
                wfmatrix = this.egBillregisterRegisterWorkflowService.getWfMatrix(egBillregister.getStateType(), null, null, additionalRule, "", null);
                egBillregister.transition().start().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue(wfmatrix.getNextState()).withDateInfo(new Date()).withOwner(pos).withNextAction(wfmatrix.getNextAction()).withNatureOfTask("Expense Bill");
            } else if ("Cancel".toString().equalsIgnoreCase(workFlowAction)) {
                String stateValue = "Cancelled";
                wfmatrix = this.egBillregisterRegisterWorkflowService.getWfMatrix(egBillregister.getStateType(), null, null, additionalRule, egBillregister.getCurrentState().getValue(), null);
                egBillregister.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue("Cancelled").withDateInfo(currentDate.toDate()).withOwner(pos).withNextAction("").withNatureOfTask("Expense Bill");
            } else {
                wfmatrix = this.egBillregisterRegisterWorkflowService.getWfMatrix(egBillregister.getStateType(), null, null, additionalRule, egBillregister.getCurrentState().getValue(), null);
                egBillregister.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue(wfmatrix.getNextState()).withDateInfo(new Date()).withOwner(pos).withNextAction(wfmatrix.getNextAction()).withNatureOfTask("Expense Bill");
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(" WorkFlow Transition Completed  ...");
        }
    }

    public Long getApprovalPositionByMatrixDesignation(EgBillregister egBillregister, String additionalRule, String mode, String workFlowAction) {
        Long approvalPosition = null;
        WorkFlowMatrix wfmatrix = this.egBillregisterRegisterWorkflowService.getWfMatrix(egBillregister.getStateType(), null, null, additionalRule, egBillregister.getCurrentState().getValue(), null);
        if (egBillregister.getState() != null && !egBillregister.getState().getHistory().isEmpty() && egBillregister.getState().getOwnerPosition() != null) {
            approvalPosition = egBillregister.getState().getOwnerPosition().getId();
        } else if (wfmatrix != null) {
            approvalPosition = this.financialUtils.getApproverPosition(wfmatrix.getNextDesignation(), egBillregister.getState(), egBillregister.getCreatedBy().getId());
        }
        if (workFlowAction.equals("Cancel") && wfmatrix.getNextState().equals("Created")) {
            approvalPosition = null;
        }
        return approvalPosition;
    }

    public List<HashMap<String, Object>> getHistory(State state, List<StateHistory> history) {
        User user = null;
        ArrayList<HashMap<String, Object>> historyTable = new ArrayList<HashMap<String, Object>>();
        HashMap<String, Object> map = new HashMap<String, Object>(0);
        if (null != state) {
            if (!history.isEmpty() && history != null) {
                Collections.reverse(history);
            }
            for (StateHistory stateHistory : history) {
                HashMap<String, Object> HistoryMap = new HashMap<String, Object>(0);
                HistoryMap.put("date", stateHistory.getDateInfo());
                HistoryMap.put("comments", stateHistory.getComments());
                HistoryMap.put("updatedBy", stateHistory.getLastModifiedBy().getUsername() + "::" + stateHistory.getLastModifiedBy().getName());
                HistoryMap.put("status", stateHistory.getValue());
                Position owner = stateHistory.getOwnerPosition();
                user = stateHistory.getOwnerUser();
                if (null != user) {
                    HistoryMap.put("user", user.getUsername() + "::" + user.getName());
                    HistoryMap.put("department", null != this.eisCommonService.getDepartmentForUser(user.getId()) ? this.eisCommonService.getDepartmentForUser(user.getId()).getName() : "");
                } else if (null != owner && null != owner.getDeptDesig()) {
                    user = this.eisCommonService.getUserForPosition(owner.getId(), new Date());
                    HistoryMap.put("user", null != user.getUsername() ? user.getUsername() + "::" + user.getName() : "");
                    HistoryMap.put("department", null != owner.getDeptDesig().getDepartment() ? owner.getDeptDesig().getDepartment().getName() : "");
                }
                historyTable.add(HistoryMap);
            }
            map.put("date", state.getDateInfo());
            map.put("comments", state.getComments() != null ? state.getComments() : "");
            map.put("updatedBy", state.getLastModifiedBy().getUsername() + "::" + state.getLastModifiedBy().getName());
            map.put("status", state.getValue());
            Position ownerPosition = state.getOwnerPosition();
            user = state.getOwnerUser();
            if (null != user) {
                map.put("user", user.getUsername() + "::" + user.getName());
                map.put("department", null != this.eisCommonService.getDepartmentForUser(user.getId()) ? this.eisCommonService.getDepartmentForUser(user.getId()).getName() : "");
            } else if (null != ownerPosition && null != ownerPosition.getDeptDesig()) {
                user = this.eisCommonService.getUserForPosition(ownerPosition.getId(), new Date());
                map.put("user", null != user.getUsername() ? user.getUsername() + "::" + user.getName() : "");
                map.put("department", null != ownerPosition.getDeptDesig().getDepartment() ? ownerPosition.getDeptDesig().getDepartment().getName() : "");
            }
            historyTable.add(map);
        }
        return historyTable;
    }
}

