/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.commons;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.egov.commons.Accountdetailkey;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.Bankaccount;
import org.egov.commons.Bankbranch;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.CFinancialYear;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.ChartOfAccountsDAO;
import org.egov.commons.dao.FinancialYearHibernateDAO;
import org.egov.commons.dao.FundHibernateDAO;
import org.egov.commons.service.EntityTypeService;
import org.egov.commons.utils.EntityType;
import org.egov.eis.service.EisCommonService;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.BoundaryType;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.workflow.entity.State;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.bills.EgBillregister;
import org.egov.model.budget.BudgetUsage;
import org.egov.model.instrument.InstrumentHeader;
import org.egov.model.masters.AccountCodePurpose;
import org.egov.pims.service.EmployeeServiceOld;
import org.egov.services.report.FundFlowService;
import org.egov.utils.Constants;
import org.egov.utils.FinancialConstants;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class EgovCommon {
    private static final Logger LOGGER = Logger.getLogger(EgovCommon.class);
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private ChartOfAccountsDAO chartOfAccountsDAO;
    @Autowired
    private FundHibernateDAO fundDAO;
    protected UserService userManager;
    private FundFlowService fundFlowService;
    @Autowired
    private FinancialYearHibernateDAO financialYearDAO;
    @Autowired
    private ApplicationContext context;

    public FundFlowService getFundFlowService() {
        return this.fundFlowService;
    }

    public void setFundFlowService(FundFlowService fundFlowService) {
        this.fundFlowService = fundFlowService;
    }

    public AppConfigValueService getAppConfigValuesService() {
        return this.appConfigValuesService;
    }

    public void setAppConfigValuesService(AppConfigValueService appConfigValuesService) {
        this.appConfigValuesService = appConfigValuesService;
    }

    public ChartOfAccountsDAO getChartOfAccountsDAO() {
        return this.chartOfAccountsDAO;
    }

    public void setChartOfAccountsDAO(ChartOfAccountsDAO chartOfAccountsDAO) {
        this.chartOfAccountsDAO = chartOfAccountsDAO;
    }

    public FundHibernateDAO getFundDAO() {
        return this.fundDAO;
    }

    public void setFundDAO(FundHibernateDAO fundDAO) {
        this.fundDAO = fundDAO;
    }

    public Boundary getBoundaryForUser(User user) {
        return null;
    }

    public Department getDepartmentForUser(User user, EisCommonService eisCommonService, EmployeeServiceOld employeeService, PersistenceService persistenceService) {
        try {
            SQLQuery qry1 = persistenceService.getSession().createSQLQuery(" select is_primary, dept_id from EG_EIS_EMPLOYEEINFO employeevi0_ where upper(trim(employeevi0_.CODE))='" + employeeService.getEmpForUserId(user.getId()).getCode() + "' and ((employeevi0_.TO_DATE is null) and employeevi0_.FROM_DATE<=CURRENT_DATE or employeevi0_.FROM_DATE<=CURRENT_DATE and employeevi0_.TO_DATE>CURRENT_DATE or employeevi0_.FROM_DATE in (select MAX(employeevi1_.FROM_DATE) from EG_EIS_EMPLOYEEINFO employeevi1_ where employeevi1_.ID=employeevi0_.ID and  not (exists (select employeevi2_.ID from EG_EIS_EMPLOYEEINFO employeevi2_ where employeevi2_.ID=employeevi0_.ID and ((employeevi2_.TO_DATE is null) and employeevi2_.FROM_DATE<=CURRENT_DATE or employeevi2_.FROM_DATE<=CURRENT_DATE and employeevi2_.TO_DATE>CURRENT_DATE))))) ");
            List employeeViewList = qry1.list();
            if (!employeeViewList.isEmpty()) {
                if (employeeViewList.size() == 1) {
                    return (Department)persistenceService.getSession().load(Department.class, (Serializable)Integer.valueOf(((Object[])employeeViewList.get(0))[1].toString()));
                }
                for (Object[] object : employeeViewList) {
                    if (!object[0].toString().equals("N")) continue;
                    return (Department)persistenceService.getSession().load(Department.class, (Serializable)Integer.valueOf(((Object[])employeeViewList.get(0))[1].toString()));
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Could not get list of assignments", (Throwable)e);
            throw new HibernateException((Throwable)e);
        }
        return null;
    }

    public BigDecimal getCashBalance(Date VoucherDate, String cashInHandCode, Integer fundId) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"EgovCommon | getCashBalance");
        }
        BigDecimal opeAvailable1 = BigDecimal.ZERO;
        BigDecimal opeAvailable2 = BigDecimal.ZERO;
        try {
            StringBuffer opBalncQuery1 = new StringBuffer(300);
            opBalncQuery1.append("SELECT case when sum(openingdebitbalance) is null then  0  else sum(openingdebitbalance) end  -").append("  case when sum(openingcreditbalance) is null then 0 else sum(openingcreditbalance) end as openingBalance from TransactionSummary").append(" where financialyear.id = ( select id from CFinancialYear where startingDate <= '").append(Constants.DDMMYYYYFORMAT1.format(VoucherDate)).append("' AND endingDate >='").append(Constants.DDMMYYYYFORMAT1.format(VoucherDate)).append("') and glcodeid.glcode=? and fund.id=?");
            List tsummarylist = this.getPersistenceService().findAllBy(opBalncQuery1.toString(), new Object[]{cashInHandCode, fundId});
            opeAvailable1 = BigDecimal.valueOf((Double)tsummarylist.get(0));
            List appList = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "cancelledstatus");
            String statusExclude = ((AppConfigValues)appList.get(0)).getValue();
            StringBuffer opBalncQuery2 = new StringBuffer(300);
            opBalncQuery2.append("SELECT (case when sum(gl.debitAmount) is null then 0 else sum(gl.debitAmount) end - case when sum(gl.creditAmount)  is null then 0 else sum(gl.creditAmount) end)").append(" as amount FROM  CGeneralLedger gl , CVoucherHeader vh WHERE gl.voucherHeaderId.id=vh.id and gl.glcode='").append(cashInHandCode).append("' and vh.voucherDate >= (select startingDate from CFinancialYear where  startingDate <= '").append(Constants.DDMMYYYYFORMAT1.format(VoucherDate)).append("' AND endingDate >='").append(Constants.DDMMYYYYFORMAT1.format(VoucherDate)).append("') and vh.voucherDate <='").append(Constants.DDMMYYYYFORMAT1.format(VoucherDate)).append(" 'and vh.status not in (").append(statusExclude).append(") and vh.fundId.id=?");
            List list = this.getPersistenceService().findAllBy(opBalncQuery2.toString(), new Object[]{fundId});
            opeAvailable2 = BigDecimal.valueOf((Double)list.get(0));
        }
        catch (HibernateException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"exception occuered while geeting cash balance", (Throwable)e);
            }
            throw new HibernateException((Throwable)e);
        }
        return opeAvailable1.add(opeAvailable2);
    }

    public BigDecimal getAccountBalance(Date VoucherDate, Long bankId) {
        return this.getAccountBalance(VoucherDate, bankId, null, null, null);
    }

    public BigDecimal getBankBalanceAvailableforPayment(Date VoucherDate, Integer bankaccountId) throws ValidationException {
        BigDecimal TotalbankBalance = BigDecimal.ZERO;
        BigDecimal bankBalanceasofBankBookReport = BigDecimal.ZERO;
        BigDecimal amountApprovedForPayment = BigDecimal.ZERO;
        bankBalanceasofBankBookReport = this.getAccountBalance(VoucherDate, bankaccountId.longValue(), null, null, null);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Bank balance as per Bank book:" + bankBalanceasofBankBookReport));
        }
        amountApprovedForPayment = this.getAmountApprovedForPaymentAndVoucherNotCreated(VoucherDate, bankaccountId);
        LOGGER.debug((Object)("Amount that are approved but voucher creation in progress:" + amountApprovedForPayment));
        TotalbankBalance = bankBalanceasofBankBookReport.subtract(amountApprovedForPayment);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Total amount available for payment :" + TotalbankBalance));
        }
        return TotalbankBalance;
    }

    public BigDecimal getAmountApprovedForPaymentAndVoucherNotCreated(Date VoucherDate, Integer bankaccountId) {
        LOGGER.debug((Object)"EgovCommon | getAmountApprovedForPaymentAndVoucherNotCreated");
        BigDecimal bankBalance = BigDecimal.ZERO;
        try {
            String paymentWFStatus = "";
            List list = this.getPersistenceService().findAllBy("select chartofaccounts.id from Bankaccount where id=?", new Object[]{bankaccountId});
            Integer glcodeid = Integer.valueOf(list.get(0).toString());
            CChartOfAccounts coa = (CChartOfAccounts)this.persistenceService.find("from CChartOfAccounts where id=?", new Object[]{(long)glcodeid.intValue()});
            List paymentStatusList = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "PAYMENT_WF_STATUS_FOR_BANK_BALANCE_CHECK");
            for (AppConfigValues values : paymentStatusList) {
                paymentWFStatus = paymentWFStatus + "'" + values.getValue() + "',";
            }
            if (!paymentWFStatus.equals("")) {
                paymentWFStatus = paymentWFStatus.substring(0, paymentWFStatus.length() - 1);
            }
            List preAppList = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "PREAPPROVEDVOUCHERSTATUS");
            String preApprovedStatus = ((AppConfigValues)preAppList.get(0)).getValue();
            StringBuffer paymentQuery = new StringBuffer(400);
            paymentQuery.append("SELECT (case when sum(gl.debitAmount) is null then 0 else sum(gl.debitAmount) end - case when sum(gl.creditAmount) is null then 0 else sum(gl.creditAmount) end  )").append(" as amount FROM  CGeneralLedger gl , CVoucherHeader vh,Paymentheader ph WHERE gl.voucherHeaderId.id=vh.id and ph.voucherheader.id=vh.id and gl.glcodeId=? ").append(" and vh.voucherDate >= (select startingDate from CFinancialYear where  startingDate <= '").append(Constants.DDMMYYYYFORMAT1.format(VoucherDate)).append("' AND endingDate >='").append(Constants.DDMMYYYYFORMAT1.format(VoucherDate)).append("') and vh.voucherDate <='").append(Constants.DDMMYYYYFORMAT1.format(VoucherDate)).append("'and vh.status in (").append(preApprovedStatus).append(")").append(" and ph.state in (from org.egov.infra.workflow.entity.State where type='Paymentheader' and value in (").append(paymentWFStatus).append(") )");
            list = this.getPersistenceService().findAllBy(paymentQuery.toString(), new Object[]{coa});
            bankBalance = BigDecimal.valueOf(Math.abs((Double)list.get(0)));
            LOGGER.debug((Object)("Total payment amount that are approved by FM Unit but voucher not yet created :" + bankBalance));
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("exception occuered while geeting cash balance" + e.getMessage()), (Throwable)e);
            }
            throw new HibernateException((Throwable)e);
        }
        return bankBalance;
    }

    public BigDecimal getAmountForApprovedPaymentAndChequeNotAssigned(Date voucherDate, Integer bankaccountId) {
        LOGGER.debug((Object)"EgovCommon | getAmountForApprovedPaymentAndChequeNotAssigned");
        BigDecimal bankBalance = BigDecimal.ZERO;
        try {
            Bankaccount bankAccount = (Bankaccount)this.getPersistenceService().find("from Bankaccount where id=?", new Object[]{bankaccountId});
            StringBuffer paymentQuery = new StringBuffer();
            paymentQuery = paymentQuery.append("SELECT (case when sum(gl.debitAmount) is null then 0 else sum(gl.debitAmount) end   -  case when sum(gl.creditAmount) is  null then 0 else sum(gl.creditAmount) ) as amount FROM  GeneralLedger gl ,voucherheader vh,  Paymentheader ph ,eg_wf_states es ,egf_instrumentvoucher iv right outer join voucherheader vh1 on vh1.id =iv.VOUCHERHEADERID WHERE gl.voucherHeaderId=vh.id and ph.voucherheaderid=vh.id and gl.glcodeId=" + bankAccount.getChartofaccounts().getId() + " and vh.voucherDate >= (select startingDate from FinancialYear where  startingDate <= :date AND endingDate >=:date) and  vh.voucherDate <= :date and ph.state_id=es.id and es.value='END' and vh.status=0 and vh1.id=vh.id and iv.VOUCHERHEADERID is null ").append(" union ").append("SELECT (case when sum(gl.debitAmount) is null then 0 else sum(gl.debitAmount) end - case when sum(gl.creditAmount) is null then 0 else sum(gl.creditAmount) ) as amount FROM  GeneralLedger gl ,voucherheader vh,  Paymentheader ph ,eg_wf_states es ,egf_instrumentvoucher iv,egw_status egws,(select ih1.id,ih1.id_status from egf_instrumentheader ih1, (select bankid,bankaccountid,instrumentnumber,max(lastmodifieddate) as lastmodifieddate from egf_instrumentheader group by bankid,bankaccountid,instrumentnumber) max_rec where max_rec.bankid=ih1.bankid and max_rec.bankaccountid=ih1.bankaccountid and max_rec.instrumentnumber=ih1.instrumentnumber and max_rec.lastmodifieddate=ih1.lastmodifieddate) ih WHERE gl.voucherHeaderId=vh.id and ph.voucherheaderid=vh.id and gl.glcodeId=" + bankAccount.getChartofaccounts().getId() + " and vh.voucherDate >= (select startingDate from FinancialYear where  startingDate <= :date AND endingDate >=:date) and vh.voucherDate <= :date and ph.state_id=es.id and es.value='END' and vh.status=0 and  iv.voucherheaderid=vh.id and iv.instrumentheaderid=ih.id and ih.id_status=egws.id and egws.description in ('Surrendered','Surrender_For_Reassign')");
            List list = this.persistenceService.getSession().createSQLQuery(paymentQuery.toString()).setDate("date", voucherDate).list();
            BigDecimal amount = (BigDecimal)list.get(0);
            bankBalance = amount == null ? BigDecimal.ZERO : amount;
            LOGGER.debug((Object)("Total payment amount that are approved by FM Unit but cheque not yet assigned:" + bankBalance));
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("exception occuered while getting cash balance" + e.getMessage()), (Throwable)e);
            }
            throw new HibernateException((Throwable)e);
        }
        return bankBalance.abs();
    }

    public List<Map<String, Object>> getInstrumentsDetailsForSubledgerTypeAndKey(Integer accountdetailType, Integer accountdetailKey, Date voucherToDate) {
        StringBuffer query = new StringBuffer(500);
        if (accountdetailType == null) {
            throw new ApplicationRuntimeException("AccountDetailType cannot be null");
        }
        if (accountdetailKey == null) {
            throw new ApplicationRuntimeException("AccountDetailKey cannot be null");
        }
        if (voucherToDate == null) {
            voucherToDate = new Date();
        }
        ArrayList resultList = null;
        try {
            query.append("select iv.instrumentHeaderId FROM CGeneralLedgerDetail gld, CGeneralLedger gl , CVoucherHeader vh, ").append(" InstrumentVoucher iv WHERE gld.generalLedgerId.id=gl.id AND gl.voucherHeaderId.id=vh.id").append(" AND iv.voucherHeaderId.id=vh.id AND gld.detailTypeId.id =? AND gld.detailKeyId=? AND gl.creditAmount >0").append(" AND vh.status=0 ").append(" AND vh.voucherDate<='").append(Constants.DDMMYYYYFORMAT1.format(voucherToDate)).append("' AND upper(iv.instrumentHeaderId.statusId.description) not in ('CANCELLED' , 'DISHONORED' ) ");
            List instrumentHeaderList = this.getPersistenceService().findAllBy(query.toString(), new Object[]{accountdetailType, accountdetailKey});
            resultList = new ArrayList();
            HashMap<String, Object> instrumentMap = null;
            if (instrumentHeaderList != null) {
                for (InstrumentHeader ih : instrumentHeaderList) {
                    instrumentMap = new HashMap<String, Object>();
                    instrumentMap.put("type", ih.getInstrumentType().getType());
                    if (ih.getInstrumentNumber() == null) {
                        instrumentMap.put("number", ih.getTransactionNumber());
                        instrumentMap.put("date", ih.getTransactionDate());
                    } else {
                        instrumentMap.put("number", ih.getInstrumentNumber());
                        instrumentMap.put("date", ih.getInstrumentDate());
                    }
                    instrumentMap.put("amount", ih.getInstrumentAmount());
                    resultList.add(instrumentMap);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exception occured while getting Instrument details-" + e.getMessage()), (Throwable)e);
            throw new ApplicationRuntimeException("Exception occured while getting Instrument details-" + e.getMessage());
        }
        return resultList == null || resultList.isEmpty() ? null : resultList;
    }

    public BigDecimal getAccountBalance(Date VoucherDate, Long bankId, BigDecimal amount, Long paymentId, Long accGlcodeId) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"EgovCommon | getCashBalance");
        }
        LOGGER.info((Object)"--------------------------------------------------------------------------------getAccountBalance-----------------");
        LOGGER.info((Object)"-------------------------------------------------------------------------------------------------");
        BigDecimal bankBalance = BigDecimal.ZERO;
        List appList = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "Balance Check Based on Fund Flow Report");
        String balanceChequeBasedOnFundFlowReport = ((AppConfigValues)appList.get(0)).getValue();
        try {
            bankBalance = balanceChequeBasedOnFundFlowReport.equalsIgnoreCase("Y") ? this.fundFlowService.getBankBalance((long)bankId, VoucherDate, accGlcodeId) : this.getAccountBalanceFromLedger(VoucherDate, bankId.intValue(), amount, paymentId);
            LOGGER.info((Object)("-------------------------------------------------------------------------------------bankBalance" + bankBalance));
        }
        catch (ValidationException e) {
            LOGGER.error((Object)("Balance Check Failed" + e.getMessage()), (Throwable)e);
            throw e;
        }
        return bankBalance;
    }

    public BigDecimal getSumOfBillAmount(String glcode, String subledgerType, Long accountdetailkeyId, Date toBillDate) throws ApplicationRuntimeException, ValidationException {
        StringBuffer query = new StringBuffer(500);
        Session session = this.persistenceService.getSession();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(" Inside getSumOfBillCreated -Glcode :" + glcode + " subledgerType: " + subledgerType + " accountdetailkeyId: " + accountdetailkeyId + " toBillDate: " + toBillDate));
        }
        if (glcode == null) {
            throw new ApplicationRuntimeException("Glcode cannot be null");
        }
        if (subledgerType == null) {
            throw new ApplicationRuntimeException("SubledgerType cannot be null");
        }
        if (accountdetailkeyId == null) {
            throw new ApplicationRuntimeException("AccountdetailkeyId cannot be null");
        }
        if (toBillDate == null) {
            throw new ApplicationRuntimeException("To Date cannot be null");
        }
        Query qry = session.createQuery("from CChartOfAccounts c where c.glcode=:glcode and c.classification=4 ");
        qry.setString("glcode", glcode);
        List coaRes = qry.list();
        if (null == coaRes || coaRes.size() == 0) {
            throw new ValidationException(Arrays.asList(new ValidationError(glcode, "Account code " + glcode + " does not exists ")));
        }
        Query actQry = session.createQuery("from Accountdetailkey adk where adk.accountdetailtype.name=:subledgerType and adk.detailkey=:detailkey");
        actQry.setString("subledgerType", subledgerType);
        actQry.setInteger("detailkey", accountdetailkeyId.intValue());
        List actRes = actQry.list();
        if (null == actRes || actRes.size() == 0) {
            throw new ValidationException(Arrays.asList(new ValidationError("Accountdetailkey", "The accountdetailkey  " + accountdetailkeyId + " for the accountdetailType : " + subledgerType + " does not exist ")));
        }
        query.append("select sum(epayee.debitAmount) FROM EgBillPayeedetails epayee,  EgwStatus estatus, CChartOfAccounts coa,Accountdetailtype act  ").append(" WHERE  act.name=:subledger and act.id=epayee.accountDetailTypeId and epayee.accountDetailKeyId=:accountdetailkey and  ").append(" coa.glcode=:glcode").append(" and  epayee.egBilldetailsId.egBillregister.status=estatus  and epayee.egBilldetailsId.egBillregister.egBillregistermis.voucherHeader.status=0 ").append(" and coa.id=epayee.egBilldetailsId.glcodeid and epayee.egBilldetailsId.egBillregister.billdate<=:billdate  ").append(" and epayee.egBilldetailsId.egBillregister.egBillregistermis.voucherHeader.moduleId is NULL ").append(" and epayee.egBilldetailsId.egBillregister.state is null and estatus.code ='APPROVED' ").append(" and epayee.egBilldetailsId.egBillregister.expendituretype='Works'  group by epayee.accountDetailKeyId");
        Query amountQry = session.createQuery(query.toString());
        amountQry.setString("subledger", subledgerType);
        amountQry.setInteger("accountdetailkey", accountdetailkeyId.intValue());
        amountQry.setString("glcode", glcode);
        amountQry.setDate("billdate", toBillDate);
        BigDecimal result = BigDecimal.ZERO;
        result = !amountQry.list().isEmpty() ? (BigDecimal)amountQry.list().get(0) : BigDecimal.ZERO;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(" Total bill amount generated for the " + subledgerType + "is :" + result));
        }
        return result;
    }

    public BigDecimal getAccountBalanceFromLedger(Date VoucherDate, Integer bankId, BigDecimal amount, Long paymentId) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"EgovCommon | getCashBalance");
        }
        BigDecimal opeAvailable = BigDecimal.ZERO;
        BigDecimal bankBalance = BigDecimal.ZERO;
        try {
            StringBuffer opBalncQuery1 = new StringBuffer(300);
            opBalncQuery1.append("SELECT CASE WHEN sum(openingdebitbalance) is null THEN 0 ELSE sum(openingdebitbalance) END -").append(" CASE WHEN sum(openingcreditbalance) is null THEN 0 ELSE sum(openingcreditbalance) END  as openingBalance from TransactionSummary").append(" where financialyear.id = ( select id from CFinancialYear where startingDate <= '").append(Constants.DDMMYYYYFORMAT1.format(VoucherDate)).append("' AND endingDate >='").append(Constants.DDMMYYYYFORMAT1.format(VoucherDate)).append("') and glcodeid.id=(select chartofaccounts.id from Bankaccount where id=? )");
            List tsummarylist = this.getPersistenceService().findAllBy(opBalncQuery1.toString(), new Object[]{bankId.longValue()});
            opeAvailable = BigDecimal.valueOf(Double.parseDouble(tsummarylist.get(0).toString()));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("opeAvailable :" + opeAvailable));
            }
            StringBuffer opBalncQuery2 = new StringBuffer(300);
            List list = this.getPersistenceService().findAllBy("select chartofaccounts.id from Bankaccount where id=?", new Object[]{bankId.longValue()});
            Integer glcodeid = Integer.valueOf(list.get(0).toString());
            List appList = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "statusexcludeReport");
            String statusExclude = ((AppConfigValues)appList.get(0)).getValue();
            opBalncQuery2.append("SELECT (CASE WHEN sum(gl.debitAmount) is null THEN 0 ELSE sum(gl.debitAmount) END - CASE WHEN sum(gl.creditAmount) is null THEN 0 ELSE sum(gl.creditAmount) END)").append(" as amount FROM  CGeneralLedger gl , CVoucherHeader vh WHERE gl.voucherHeaderId.id=vh.id and gl.glcodeId=? ").append(" and vh.voucherDate >= (select startingDate from CFinancialYear where  startingDate <= '").append(Constants.DDMMYYYYFORMAT1.format(VoucherDate)).append("' AND endingDate >='").append(Constants.DDMMYYYYFORMAT1.format(VoucherDate)).append("') and vh.voucherDate <='").append(Constants.DDMMYYYYFORMAT1.format(VoucherDate)).append("'and vh.status not in (").append(statusExclude).append(")");
            CChartOfAccounts coa = (CChartOfAccounts)this.persistenceService.find("from CChartOfAccounts where id=?", new Object[]{(long)glcodeid.intValue()});
            list = this.getPersistenceService().findAllBy(opBalncQuery2.toString(), new Object[]{coa});
            bankBalance = BigDecimal.valueOf(Double.parseDouble(list.get(0).toString()));
            bankBalance = opeAvailable.add(bankBalance);
            boolean amountTobeInclude = false;
            if (paymentId != null) {
                State s = (State)this.persistenceService.find(" from org.egov.infra.workflow.entity.State where id in (select state.id from Paymentheader where id=?) ", new Object[]{paymentId});
                String paymentWFStatus = "";
                List paymentStatusList = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "PAYMENT_WF_STATUS_FOR_BANK_BALANCE_CHECK");
                for (AppConfigValues values : paymentStatusList) {
                    if (s.getValue().equals(values.getValue())) {
                        amountTobeInclude = true;
                    }
                    paymentWFStatus = paymentWFStatus + "'" + values.getValue() + "',";
                }
                if (!paymentWFStatus.equals("")) {
                    paymentWFStatus = paymentWFStatus.substring(0, paymentWFStatus.length() - 1);
                }
                List preAppList = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "PREAPPROVEDVOUCHERSTATUS");
                String preApprovedStatus = ((AppConfigValues)preAppList.get(0)).getValue();
                StringBuffer paymentQuery = new StringBuffer(400);
                paymentQuery.append("SELECT (CASE WHEN sum(gl.debitAmount) is null THEN 0 ELSE sum(gl.debitAmount) END  - CASE WHEN sum(gl.creditAmount) is null THEN 0 ELSE sum(gl.creditAmount) END )").append(" as amount FROM  CGeneralLedger gl , CVoucherHeader vh,Paymentheader ph WHERE gl.voucherHeaderId.id=vh.id and ph.voucherheader.id=vh.id and gl.glcodeId=? ").append(" and vh.voucherDate >= (select startingDate from CFinancialYear where  startingDate <= '").append(Constants.DDMMYYYYFORMAT1.format(VoucherDate)).append("' AND endingDate >='").append(Constants.DDMMYYYYFORMAT1.format(VoucherDate)).append("') and vh.voucherDate <='").append(Constants.DDMMYYYYFORMAT1.format(VoucherDate)).append("'and vh.status in (").append(preApprovedStatus).append(")").append(" and ph.state in (from org.egov.infra.workflow.entity.State where type='Paymentheader' and value in (").append(paymentWFStatus).append(") )");
                list = this.getPersistenceService().findAllBy(paymentQuery.toString(), new Object[]{coa});
                bankBalance = bankBalance.subtract(BigDecimal.valueOf(Math.abs((Double)list.get(0))));
                Integer voucherStatus = (Integer)this.persistenceService.find("select status from CVoucherHeader where id in (select voucherheader.id from Paymentheader where id=?)", new Object[]{paymentId});
                if (voucherStatus == 0) {
                    amountTobeInclude = true;
                }
                if (amountTobeInclude) {
                    bankBalance = bankBalance.add(amount);
                }
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("bankBalance :" + bankBalance));
            }
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("exception occuered while geeting cash balance" + e.getMessage()), (Throwable)e);
            }
            throw new HibernateException((Throwable)e);
        }
        return bankBalance;
    }

    public PersistenceService getPersistenceService() {
        return this.persistenceService;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public EntityType getEntityType(Accountdetailtype accountdetailtype, Serializable detailkey) throws ApplicationException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"EgovCommon | getEntityType| Start");
        }
        EntityType entity = null;
        try {
            Class<?> aClass = Class.forName(accountdetailtype.getFullQualifiedName());
            Method method = aClass.getMethod("getId", new Class[0]);
            String dataType = method.getReturnType().getSimpleName();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("data Type = " + dataType));
            }
            entity = dataType.equals("Long") ? (EntityType)this.persistenceService.getSession().load(aClass, (Serializable)Long.valueOf(detailkey.toString())) : (EntityType)this.persistenceService.getSession().load(aClass, detailkey);
        }
        catch (ClassCastException e) {
            LOGGER.error((Object)e);
            throw new ApplicationException(e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exception to get EntityType=" + e.getMessage()), (Throwable)e);
            throw new ApplicationException(e.getMessage());
        }
        return entity;
    }

    /*
     * Unable to fully structure code
     */
    public Map<String, Object> getCashChequeInfoForBoundary() throws ValidationException {
        chequeInHand = null;
        chequeInHandId = null;
        cashInHand = null;
        cashInHandId = null;
        appList = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "boundaryforaccounts");
        boundaryTypeval = ((AppConfigValues)appList.get(0)).getValue();
        if (EgovCommon.LOGGER.isDebugEnabled()) {
            EgovCommon.LOGGER.debug((Object)("Boundary Type Level  = " + boundaryTypeval));
        }
        if (null == boundaryTypeval || boundaryTypeval.trim().equals("")) {
            throw new ValidationException(Arrays.asList(new ValidationError[]{new ValidationError("configuration.parameter.missing", "boundaryforaccounts is missing in appconfig master")}));
        }
        listBoundType = this.persistenceService.findAllBy("from BoundaryType where lower(name)=? and lower(hierarchyType.name)='administration'", new Object[]{boundaryTypeval.toLowerCase()});
        if (EgovCommon.LOGGER.isDebugEnabled()) {
            EgovCommon.LOGGER.debug((Object)("listBoundType size   = " + listBoundType.size()));
        }
        boundaryTypeId = ((BoundaryType)listBoundType.get(0)).getId();
        listBndryLvl = this.persistenceService.findAllBy("from Boundary where boundaryType.id=?", new Object[]{boundaryTypeId});
        if (EgovCommon.LOGGER.isDebugEnabled()) {
            EgovCommon.LOGGER.debug((Object)("listBndryLvl size   = " + listBndryLvl.size()));
        }
        if (null != listBndryLvl && !listBndryLvl.isEmpty()) {
            boundary = (Boundary)listBndryLvl.get(0);
            boundaryId = boundary.getId();
            try {
                connection = null;
                bndQry = "SELECT glcode AS chequeinhand,id FROM CHARTOFACCOUNTS where id = (SELECT chequeinhand FROM CODEMAPPING WHERE EG_BOUNDARYID=?)";
                pstmt = connection.prepareStatement("SELECT glcode AS chequeinhand,id FROM CHARTOFACCOUNTS where id = (SELECT chequeinhand FROM CODEMAPPING WHERE EG_BOUNDARYID=?)");
                pstmt.setLong(0, boundaryId);
                if (EgovCommon.LOGGER.isDebugEnabled()) {
                    EgovCommon.LOGGER.debug((Object)"Cheque In hand account code query =SELECT glcode AS chequeinhand,id FROM CHARTOFACCOUNTS where id = (SELECT chequeinhand FROM CODEMAPPING WHERE EG_BOUNDARYID=?)");
                }
                if ((resultSet = pstmt.executeQuery()).next()) {
                    chequeInHand = resultSet.getString("chequeinhand");
                    chequeInHandId = resultSet.getLong("id");
                }
                if (EgovCommon.LOGGER.isDebugEnabled()) {
                    EgovCommon.LOGGER.debug((Object)("chequeInHand is " + chequeInHand + " chequeInHandId is " + chequeInHandId));
                }
                sqlQuery2 = "SELECT glcode AS cashinhand,id FROM CHARTOFACCOUNTS where id = (SELECT cashinhand FROM CODEMAPPING WHERE EG_BOUNDARYID=?)";
                pstmt1 = connection.prepareStatement("SELECT glcode AS cashinhand,id FROM CHARTOFACCOUNTS where id = (SELECT cashinhand FROM CODEMAPPING WHERE EG_BOUNDARYID=?)");
                pstmt1.setLong(0, boundaryId);
                if (EgovCommon.LOGGER.isDebugEnabled()) {
                    EgovCommon.LOGGER.debug((Object)"Cheque In hand account code query =SELECT glcode AS cashinhand,id FROM CHARTOFACCOUNTS where id = (SELECT cashinhand FROM CODEMAPPING WHERE EG_BOUNDARYID=?)");
                }
                if ((resultSet = pstmt1.executeQuery()).next()) {
                    cashInHand = resultSet.getString("cashinhand");
                    cashInHandId = resultSet.getLong("id");
                }
                if (!EgovCommon.LOGGER.isDebugEnabled()) ** GOTO lbl50
                EgovCommon.LOGGER.debug((Object)("cashInHand is " + cashInHand + " cashInHandId is " + cashInHandId));
            }
            catch (Exception e) {
                EgovCommon.LOGGER.error((Object)("Exception occuerd while getting  " + e.getMessage()), (Throwable)e);
                throw new ApplicationRuntimeException(e.getMessage());
            }
        } else {
            if (EgovCommon.LOGGER.isDebugEnabled()) {
                EgovCommon.LOGGER.debug((Object)"listBndryLvl is either null or blank");
            }
            throw new ValidationException(Arrays.asList(new ValidationError[]{new ValidationError("boundary.value.missing", "Boundary value missing for" + boundaryTypeval)}));
        }
lbl50:
        // 2 sources

        boundaryMap = new HashMap<String, Object>();
        boundaryMap.put("listBndryLvl", listBndryLvl);
        boundaryMap.put("chequeInHand", chequeInHand);
        boundaryMap.put("cashInHand", cashInHand);
        boundaryMap.put("chequeInHandID", chequeInHandId);
        boundaryMap.put("cashInHandID", cashInHandId);
        return boundaryMap;
    }

    public boolean isShowChequeNumber() {
        String value = ((AppConfigValues)this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "Cheque_no_generation_auto").get(0)).getValue();
        return !"Y".equalsIgnoreCase(value);
    }

    public BigDecimal getAccountBalanceforDate(Date asondate, String glcode, String fundcode, Integer accountdetailType, Integer accountdetailkey, Integer deptId) throws ValidationException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"EgovCommon | getAccountBalanceforDate | Start");
        }
        this.validateParameterData(asondate, glcode, fundcode, accountdetailType, accountdetailkey);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"validation of data is sucessfull");
        }
        BigDecimal opBalAsonDate = this.getOpeningBalAsonDate(asondate, glcode, fundcode, accountdetailType, accountdetailkey, deptId);
        BigDecimal glBalAsonDate = this.getGlcodeBalBeforeDate(asondate, glcode, fundcode, accountdetailType, accountdetailkey, deptId);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"EgovCommon | getAccountBalanceforDate | Start");
        }
        return opBalAsonDate.add(glBalAsonDate);
    }

    public BigDecimal getAccountBalanceTillDate(Date asondate, String glcode, String fundcode, Integer accountdetailType, Integer accountdetailkey, Integer deptId) throws ValidationException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"EgovCommon | getAccountBalanceTillDate | Start");
        }
        this.validateParameterData(asondate, glcode, fundcode, accountdetailType, accountdetailkey);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"validation of data is sucessfull");
        }
        BigDecimal opBalAsonDate = this.getOpeningBalAsonDate(asondate, glcode, fundcode, accountdetailType, accountdetailkey, deptId);
        BigDecimal glBalAsonDate = this.getGlcodeBalTillDate(asondate, glcode, fundcode, accountdetailType, accountdetailkey, deptId);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("EgovCommon | getAccountBalanceTillDate | Opening Balance :" + opBalAsonDate + " Txn Balance  :" + glBalAsonDate));
        }
        return opBalAsonDate.add(glBalAsonDate);
    }

    private void validateParameterData(Date asondate, String glcode, String fundcode, Integer accountdetailType, Integer accountdetailkey) {
        Query qry;
        Session session;
        if (null == asondate) {
            throw new ValidationException(Arrays.asList(new ValidationError("asondate", "asondate supplied is null")));
        }
        if (null == glcode || StringUtils.isEmpty((String)glcode)) {
            throw new ValidationException(Arrays.asList(new ValidationError("glcode", "glcode supplied is either null or empty")));
        }
        if (null == this.chartOfAccountsDAO.getCChartOfAccountsByGlCode(glcode)) {
            throw new ValidationException(Arrays.asList(new ValidationError("glcode", "not a valid glcode :" + glcode)));
        }
        if (null == fundcode || StringUtils.isEmpty((String)fundcode)) {
            throw new ValidationException(Arrays.asList(new ValidationError("fundcode", "Fundcode supplied is either null or empty")));
        }
        if (null == this.fundDAO.fundByCode(fundcode)) {
            throw new ValidationException(Arrays.asList(new ValidationError("fundcode", "The Fundcode supplied : " + fundcode + " is not present in the system.")));
        }
        if (null != accountdetailType) {
            session = this.persistenceService.getSession();
            qry = session.createQuery("from CChartOfAccountDetail cd,CChartOfAccounts c where cd.glCodeId = c.id and c.glcode=:glcode and cd.detailTypeId=:detailTypeId");
            qry.setString("glcode", glcode);
            qry.setString("detailTypeId", accountdetailType.toString());
            if (null == qry.list() || qry.list().size() == 0) {
                throw new ValidationException(Arrays.asList(new ValidationError("accountdetailType", "Glcode " + glcode + " is not a control code for the supplied detailed type.")));
            }
        }
        if (null != accountdetailkey) {
            session = this.persistenceService.getSession();
            qry = session.createQuery("from Accountdetailkey adk where adk.accountdetailtype=:detailtypeid and adk.detailkey=:detailkey");
            qry.setString("detailtypeid", accountdetailType.toString());
            qry.setString("detailkey", accountdetailkey.toString());
            if (null == qry.list() || qry.list().size() == 0) {
                throw new ValidationException(Arrays.asList(new ValidationError("accountdetailkey", "The accountdetailkey supplied : " + accountdetailkey + " for the accountdetailType : " + accountdetailType + " is not correct")));
            }
        }
    }

    public BigDecimal getOpeningBalAsonDate(Date asondate, String glcode, String fundCode, Integer accountdetailType, Integer accountdetailkey, Integer deptId) throws ValidationException {
        BigDecimal opBalAsonDate = BigDecimal.ZERO;
        StringBuffer opBalncQuery = new StringBuffer(300);
        String deptCondition = "";
        String fundConidtion = "";
        if (fundCode != null) {
            fundConidtion = " and fund.code='" + fundCode + "'";
        }
        if (deptId != null) {
            deptCondition = " and departmentid.id=" + deptId;
        }
        opBalncQuery.append("SELECT case when sum(openingdebitbalance) is null then  0  else sum(openingdebitbalance) end -").append("  case when sum(openingcreditbalance) is null then 0 else sum(openingcreditbalance) end  as openingBalance from TransactionSummary").append(" where financialyear.id = ( select id from CFinancialYear where startingDate <= '").append(Constants.DDMMYYYYFORMAT1.format(asondate)).append("' AND endingDate >='").append(Constants.DDMMYYYYFORMAT1.format(asondate)).append("') and glcodeid.glcode=? ").append(fundConidtion + deptCondition);
        if (null != accountdetailType) {
            opBalncQuery.append(" and accountdetailtype.id=").append(accountdetailType);
        }
        if (null != accountdetailkey) {
            opBalncQuery.append(" and accountdetailkey=").append(accountdetailkey);
        }
        List tsummarylist = this.getPersistenceService().findAllBy(opBalncQuery.toString(), new Object[]{glcode});
        opBalAsonDate = BigDecimal.valueOf(((Integer)tsummarylist.get(0)).intValue());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Opening balance :" + opBalAsonDate));
        }
        return opBalAsonDate;
    }

    private BigDecimal getCreditOpeningBalAsonDate(Date asondate, String glcode, String fundCode, Integer accountdetailType, Integer accountdetailkey) throws ValidationException {
        BigDecimal opBalAsonDate = BigDecimal.ZERO;
        StringBuffer opBalncQuery = new StringBuffer(300);
        if (null != accountdetailkey && null != accountdetailType) {
            opBalncQuery.append(" Select sum(txns.openingcreditbalance) as openingBalance ").append("From transactionsummary txns,fund fd, chartofaccounts coa,accountdetailtype adt,accountdetailkey adk").append(" where coa.id=txns.glcodeid and fd.id=txns.fundid  and adt.id=txns.accountdetailtypeid and adk.detailkey=txns.accountdetailkey ").append(" and coa.glcode='").append(glcode).append("' and fd.code='").append(fundCode).append("'and txns.financialyearid in(select id from financialyear where startingdate<='").append(Constants.DDMMYYYYFORMAT1.format(asondate)).append("' and endingdate>='").append(Constants.DDMMYYYYFORMAT1.format(asondate)).append("')").append(" and txns.accountdetailtypeid=").append(accountdetailType).append(" and txns.accountdetailkey=").append(accountdetailkey).append(" and adk.detailtypeid=").append(accountdetailType).append(" Group by txns.GLCODEID,txns.fundid,txns.FINANCIALYEARID,txns.accountdetailtypeid,txns.accountdetailkey ");
        } else {
            opBalncQuery.append(" Select sum(txns.openingcreditbalance) as openingBalance From transactionsummary txns,fund fd, chartofaccounts coa").append(" where coa.id=txns.glcodeid and fd.id=txns.fundid ").append(" and coa.glcode='").append(glcode).append("' and fd.code='").append(fundCode).append("'and txns.financialyearid in(select id from financialyear where startingdate<='").append(Constants.DDMMYYYYFORMAT1.format(asondate)).append("' and endingdate>='").append(Constants.DDMMYYYYFORMAT1.format(asondate)).append("')").append(" Group by txns.GLCODEID,txns.fundid,txns.FINANCIALYEARID ");
        }
        List list = this.persistenceService.getSession().createSQLQuery(opBalncQuery.toString()).list();
        if (list != null && list.size() > 0) {
            opBalAsonDate = (BigDecimal)list.get(0);
        }
        opBalAsonDate = opBalAsonDate == null ? BigDecimal.ZERO : opBalAsonDate;
        return opBalAsonDate;
    }

    protected BigDecimal getGlcodeBalBeforeDate(Date asondate, String glcode, String fundcode, Integer accountdetailType, Integer accountdetailkey, Integer deptId) throws ValidationException {
        StringBuffer glCodeBalQry = new StringBuffer(400);
        StringBuffer glCodeDbtBalQry = new StringBuffer(400);
        StringBuffer glCodeCrdBalQry = new StringBuffer(400);
        BigDecimal glCodeBalance = BigDecimal.ZERO;
        BigDecimal glCodeDbtBalance = BigDecimal.ZERO;
        BigDecimal glCodeCrdBalance = BigDecimal.ZERO;
        String deptCond = "";
        String misTab = "";
        String fundCond = "";
        if (fundcode != null) {
            fundCond = " and vh.fundId.code='" + fundcode + "'";
        }
        if (deptId != null) {
            misTab = ",Vouchermis mis";
            deptCond = " and mis.voucherheaderid.id=vh.id and mis.departmentid.id=" + deptId;
        }
        List appList = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "statusexcludeReport");
        String statusExclude = ((AppConfigValues)appList.get(0)).getValue();
        if (null == accountdetailType && null == accountdetailkey) {
            glCodeBalQry.append("SELECT (case when sum(gl.debitAmount) is null then 0 else sum(gl.debitAmount) end - case when sum(gl.creditAmount)  is null then 0 else sum(gl.creditAmount) end)").append(" as amount FROM  CGeneralLedger gl , CVoucherHeader vh  ").append(misTab).append(" WHERE gl.voucherHeaderId.id=vh.id and gl.glcodeId.glcode=?").append(fundCond + deptCond).append(" and vh.voucherDate >= (select startingDate from CFinancialYear where  startingDate <= '").append(Constants.DDMMYYYYFORMAT1.format(asondate)).append("' AND endingDate >='").append(Constants.DDMMYYYYFORMAT1.format(asondate)).append("') and vh.voucherDate <'").append(Constants.DDMMYYYYFORMAT1.format(asondate)).append("'and vh.status not in (").append(statusExclude).append(")");
            List list = this.getPersistenceService().findAllBy(glCodeBalQry.toString(), new Object[]{glcode});
            glCodeBalance = BigDecimal.valueOf(((Integer)list.get(0)).intValue());
        } else {
            glCodeDbtBalQry.append("SELECT sum(gld.amount)  as debitamount from CVoucherHeader vh , CGeneralLedger gl,CGeneralLedgerDetail gld ").append(misTab).append(" WHERE gl.voucherHeaderId.id=vh.id and gl.id = gld.generalLedgerId.id and gl.glcodeId.glcode=? ").append(fundCond).append(deptCond).append(" and vh.voucherDate >= (select startingDate from CFinancialYear where  startingDate <= '").append(Constants.DDMMYYYYFORMAT1.format(asondate)).append("' AND endingDate >='").append(Constants.DDMMYYYYFORMAT1.format(asondate)).append("') and vh.voucherDate <'").append(Constants.DDMMYYYYFORMAT1.format(asondate)).append("'and vh.status not in (").append(statusExclude).append(")").append(" and gld.detailTypeId.id =").append(accountdetailType);
            if (null != accountdetailkey) {
                glCodeDbtBalQry.append(" and gld.detailKeyId =").append(accountdetailkey);
            }
            glCodeDbtBalQry.append(" and gl.debitAmount >0");
            List listDbt = this.getPersistenceService().findAllBy(glCodeDbtBalQry.toString(), new Object[]{glcode});
            BigDecimal bigDecimal = glCodeDbtBalance = (BigDecimal)listDbt.get(0) == null ? BigDecimal.ZERO : (BigDecimal)listDbt.get(0);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)(" total debit amount :  " + glCodeDbtBalance));
            }
            glCodeCrdBalQry.append("SELECT sum(gld.amount) as creditamount from CVoucherHeader vh , CGeneralLedger gl,CGeneralLedgerDetail gld").append(misTab).append(" WHERE gl.voucherHeaderId.id=vh.id and gl.id = gld.generalLedgerId.id and gl.glcodeId.glcode=? ").append(fundCond).append(deptCond).append(" and vh.voucherDate >= (select startingDate from CFinancialYear where  startingDate <= '").append(Constants.DDMMYYYYFORMAT1.format(asondate)).append("' AND endingDate >='").append(Constants.DDMMYYYYFORMAT1.format(asondate)).append("') and vh.voucherDate <'").append(Constants.DDMMYYYYFORMAT1.format(asondate)).append("'and vh.status not in (").append(statusExclude).append(")").append(" and gld.detailTypeId.id =").append(accountdetailType);
            if (null != accountdetailkey) {
                glCodeCrdBalQry.append(" and gld.detailKeyId =").append(accountdetailkey);
            }
            glCodeCrdBalQry.append(" and gl.creditAmount >0");
            List listCrd = this.getPersistenceService().findAllBy(glCodeCrdBalQry.toString(), new Object[]{glcode});
            BigDecimal bigDecimal2 = glCodeCrdBalance = (BigDecimal)listCrd.get(0) == null ? BigDecimal.ZERO : (BigDecimal)listCrd.get(0);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)(" total credit amount :  " + glCodeCrdBalance));
            }
            glCodeBalance = glCodeDbtBalance.subtract(glCodeCrdBalance);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)(" total balance amount :  " + glCodeBalance));
            }
        }
        return glCodeBalance;
    }

    protected BigDecimal getGlcodeBalTillDate(Date asondate, String glcode, String fundcode, Integer accountdetailType, Integer accountdetailkey, Integer deptId) throws ValidationException {
        StringBuffer glCodeBalQry = new StringBuffer(400);
        StringBuffer glCodeDbtBalQry = new StringBuffer(400);
        StringBuffer glCodeCrdBalQry = new StringBuffer(400);
        BigDecimal glCodeBalance = BigDecimal.ZERO;
        BigDecimal glCodeDbtBalance = BigDecimal.ZERO;
        BigDecimal glCodeCrdBalance = BigDecimal.ZERO;
        String deptCond = "";
        String misTab = "";
        String fundCond = "";
        if (fundcode != null) {
            fundCond = " and vh.fundId.code='" + fundcode + "'";
        }
        if (deptId != null) {
            misTab = ",Vouchermis mis";
            deptCond = " and mis.voucherheaderid.id=vh.id and mis.departmentid.id=" + deptId;
        }
        List appList = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "statusexcludeReport");
        String statusExclude = ((AppConfigValues)appList.get(0)).getValue();
        if (null == accountdetailType && null == accountdetailkey) {
            glCodeBalQry.append("SELECT (case when sum(gl.debitAmount)=null then 0 else sum(gl.debitAmount) end - case when sum(gl.creditAmount)  = null then 0 else sum(gl.creditAmount) end)").append(" as amount FROM  CGeneralLedger gl , CVoucherHeader vh  ").append(misTab).append(" WHERE gl.voucherHeaderId.id=vh.id and gl.glcodeId.glcode=?").append(fundCond + deptCond).append(" and vh.voucherDate >= (select startingDate from CFinancialYear where  startingDate <= '").append(Constants.DDMMYYYYFORMAT1.format(asondate)).append("' AND endingDate >='").append(Constants.DDMMYYYYFORMAT1.format(asondate)).append("') and vh.voucherDate <='").append(Constants.DDMMYYYYFORMAT1.format(asondate)).append("'and vh.status not in (").append(statusExclude).append(")");
            List list = this.getPersistenceService().findAllBy(glCodeBalQry.toString(), new Object[]{glcode});
            glCodeBalance = BigDecimal.valueOf((Double)list.get(0));
        } else {
            glCodeDbtBalQry.append("SELECT sum(gld.amount)  as debitamount from CVoucherHeader vh , CGeneralLedger gl,CGeneralLedgerDetail gld ").append(misTab).append(" WHERE gl.voucherHeaderId.id=vh.id and gl.id = gld.generalLedgerId.id and gl.glcodeId.glcode=? ").append(fundCond).append(deptCond).append(" and vh.voucherDate >= (select startingDate from CFinancialYear where  startingDate <= '").append(Constants.DDMMYYYYFORMAT1.format(asondate)).append("' AND endingDate >='").append(Constants.DDMMYYYYFORMAT1.format(asondate)).append("') and vh.voucherDate <='").append(Constants.DDMMYYYYFORMAT1.format(asondate)).append("'and vh.status not in (").append(statusExclude).append(")").append(" and gld.detailTypeId.id =").append(accountdetailType);
            if (null != accountdetailkey) {
                glCodeDbtBalQry.append(" and gld.detailKeyId =").append(accountdetailkey);
            }
            glCodeDbtBalQry.append(" and gl.debitAmount >0");
            List listDbt = this.getPersistenceService().findAllBy(glCodeDbtBalQry.toString(), new Object[]{glcode});
            BigDecimal bigDecimal = glCodeDbtBalance = (BigDecimal)listDbt.get(0) == null ? BigDecimal.ZERO : (BigDecimal)listDbt.get(0);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)(" total debit amount :  " + glCodeDbtBalance));
            }
            glCodeCrdBalQry.append("SELECT sum(gld.amount) as creditamount from CVoucherHeader vh , CGeneralLedger gl,CGeneralLedgerDetail gld").append(misTab).append(" WHERE gl.voucherHeaderId.id=vh.id and gl.id = gld.generalLedgerId.id and gl.glcodeId.glcode=? ").append(fundCond).append(deptCond).append(" and vh.voucherDate >= (select startingDate from CFinancialYear where  startingDate <= '").append(Constants.DDMMYYYYFORMAT1.format(asondate)).append("' AND endingDate >='").append(Constants.DDMMYYYYFORMAT1.format(asondate)).append("') and vh.voucherDate <='").append(Constants.DDMMYYYYFORMAT1.format(asondate)).append("'and vh.status not in (").append(statusExclude).append(")").append(" and gld.detailTypeId.id =").append(accountdetailType);
            if (null != accountdetailkey) {
                glCodeCrdBalQry.append(" and gld.detailKeyId =").append(accountdetailkey);
            }
            glCodeCrdBalQry.append(" and gl.creditAmount >0");
            List listCrd = this.getPersistenceService().findAllBy(glCodeCrdBalQry.toString(), new Object[]{glcode});
            BigDecimal bigDecimal2 = glCodeCrdBalance = (BigDecimal)listCrd.get(0) == null ? BigDecimal.ZERO : (BigDecimal)listCrd.get(0);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)(" total credit amount :  " + glCodeCrdBalance));
            }
            glCodeBalance = glCodeDbtBalance.subtract(glCodeCrdBalance);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)(" total balance amount :  " + glCodeBalance));
            }
        }
        return glCodeBalance;
    }

    public List<Map<String, Object>> getBankBranchForActiveBanks() {
        int i;
        List unorderedBankBranch = this.persistenceService.findAllBy("select DISTINCT concat(concat(bank.id,'-'),bankBranch.id) as bankbranchid,concat(concat(bank.name,' '),bankBranch.branchname) as bankbranchname  FROM Bank bank,Bankbranch bankBranch,Bankaccount bankaccount  where  bank.isactive=true  and bankBranch.isactive=true and bank.id = bankBranch.bank.id and bankBranch.id = bankaccount.bankbranch.id and bankaccount.isactive=? ", new Object[]{true});
        ArrayList<String> bankBranchStrings = new ArrayList<String>();
        int len = unorderedBankBranch.size();
        for (i = 0; i < len; ++i) {
            bankBranchStrings.add(((Object[])unorderedBankBranch.get(i))[1].toString());
        }
        Collections.sort(bankBranchStrings);
        ArrayList bankBranch = new ArrayList();
        for (i = 0; i < len; ++i) {
            for (int j = 0; j < len; ++j) {
                if (!((String)bankBranchStrings.get(i)).equalsIgnoreCase(((Object[])unorderedBankBranch.get(j))[1].toString())) continue;
                bankBranch.add(unorderedBankBranch.get(j));
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Bank list size is " + bankBranch.size()));
        }
        ArrayList<Map<String, Object>> bankBranchList = new ArrayList<Map<String, Object>>();
        for (Object[] element : bankBranch) {
            HashMap<String, String> bankBrmap = new HashMap<String, String>();
            bankBrmap.put("bankBranchId", element[0].toString());
            bankBrmap.put("bankBranchName", element[1].toString());
            bankBranchList.add(bankBrmap);
        }
        LOGGER.info((Object)("data" + bankBranchList));
        return bankBranchList;
    }

    public List<Bankbranch> getActiveBankBranchForActiveBanks() {
        return this.persistenceService.findAllBy("from Bankbranch bankBranch where  bank.isactive=true  and isactive=true", new Object[0]);
    }

    public List<CChartOfAccounts> getSubledgerAccountCodesForAccountDetailTypeAndNonSubledgers(Integer accountDetailTypeId) {
        if (accountDetailTypeId == 0 || accountDetailTypeId == -1) {
            return this.persistenceService.findAllBy("from CChartOfAccounts a where a.isActiveForPosting=true and a.classification=4 and size(a.chartOfAccountDetails) = 0  order by a.id", new Object[0]);
        }
        return this.persistenceService.findAllBy("from CChartOfAccounts  a LEFT OUTER JOIN  fetch a.chartOfAccountDetails  b where (size(a.chartOfAccountDetails) = 0 or b.detailTypeId.id=?)and a.isActiveForPosting=true and a.classification=4 order by a.id", new Object[]{accountDetailTypeId});
    }

    public List<CChartOfAccounts> getAllAccountCodesForAccountDetailType(Integer accountDetailTypeId) {
        LOGGER.debug((Object)("Initiating getAllAccountCodesForAccountDetailType for detailtypeId " + accountDetailTypeId + "..."));
        List<CChartOfAccounts> subledgerCodes = this.getSubledgerAccountCodesForAccountDetailTypeAndNonSubledgers(accountDetailTypeId);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("finished getAllAccountCodesForAccountDetailType for detailtypeId " + accountDetailTypeId + ".size:" + subledgerCodes.size() + "."));
        }
        return subledgerCodes;
    }

    public BigDecimal getOpeningBalAsonDate(Date asondate, String glcode, String fundCode) throws ValidationException {
        BigDecimal opBalAsonDate = BigDecimal.ZERO;
        StringBuffer opBalncQuery = new StringBuffer(300);
        opBalncQuery.append("SELECT case when sum(openingdebitbalance) = null then  0  else sum(openingdebitbalance) end -").append("  case when sum(openingcreditbalance) = null then 0 else sum(openingcreditbalance) end  as openingBalance from TransactionSummary").append(" where financialyear.id = ( select id from CFinancialYear where startingDate <= '").append(Constants.DDMMYYYYFORMAT1.format(asondate)).append("' AND endingDate >='").append(Constants.DDMMYYYYFORMAT1.format(asondate)).append("') and glcodeid.glcode=? and fund.code=?");
        List tsummarylist = this.getPersistenceService().findAllBy(opBalncQuery.toString(), new Object[]{glcode, fundCode});
        opBalAsonDate = BigDecimal.valueOf((Double)tsummarylist.get(0));
        return opBalAsonDate;
    }

    public List<BudgetUsage> getListBudgetUsage(Map<String, Object> queryParamMap) {
        StringBuffer query = new StringBuffer();
        List listBudgetUsage = null;
        query.append("select bu from BudgetUsage bu,BudgetDetail bd where  bu.budgetDetail.id=bd.id");
        HashMap<String, String> mandatoryFields = new HashMap<String, String>();
        List appConfigList = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "DEFAULTTXNMISATTRRIBUTES");
        for (AppConfigValues appConfigVal : appConfigList) {
            String value = appConfigVal.getValue();
            String header = value.substring(0, value.indexOf("|"));
            String mandate = value.substring(value.indexOf("|") + 1);
            if (!mandate.equalsIgnoreCase("M")) continue;
            mandatoryFields.put(header, "M");
        }
        if (this.isNotNull(mandatoryFields.get("fund")) && !this.isNotNull(queryParamMap.get("fundId"))) {
            throw new ValidationException(Arrays.asList(new ValidationError("fund", "fund cannot be null")));
        }
        if (this.isNotNull(queryParamMap.get("fundId"))) {
            query.append(" and bd.fund.id=").append(Integer.valueOf(queryParamMap.get("fundId").toString()));
        }
        if (this.isNotNull(mandatoryFields.get("department")) && !this.isNotNull(queryParamMap.get("ExecutionDepartmentId"))) {
            throw new ValidationException(Arrays.asList(new ValidationError("department", "department cannot be null")));
        }
        if (this.isNotNull(queryParamMap.get("ExecutionDepartmentId"))) {
            query.append(" and bd.executingDepartment.id=").append(Integer.valueOf(queryParamMap.get("ExecutionDepartmentId").toString()));
        }
        if (this.isNotNull(mandatoryFields.get("function")) && !this.isNotNull(queryParamMap.get("functionId"))) {
            throw new ValidationException(Arrays.asList(new ValidationError("function", "function cannot be null")));
        }
        if (this.isNotNull(queryParamMap.get("functionId"))) {
            query.append(" and bd.function.id=").append(Long.valueOf(queryParamMap.get("functionId").toString()));
        }
        if (this.isNotNull(queryParamMap.get("moduleId"))) {
            query.append(" and bu.moduleId=").append(Integer.valueOf(queryParamMap.get("moduleId").toString()));
        }
        if (this.isNotNull(queryParamMap.get("financialYearId"))) {
            query.append(" and bu.financialYearId=").append(Integer.valueOf(queryParamMap.get("financialYearId").toString()));
        }
        if (this.isNotNull(queryParamMap.get("budgetgroupId"))) {
            query.append(" and bd.budgetGroup.id=").append(Long.valueOf(queryParamMap.get("budgetgroupId").toString()));
        }
        if (this.isNotNull(queryParamMap.get("fromDate"))) {
            query.append(" and bu.updatedTime >=:from");
        }
        if (this.isNotNull(queryParamMap.get("toDate"))) {
            query.append(" and bu.updatedTime <=:to");
        }
        if (this.isNotNull(queryParamMap.get("Order By"))) {
            query.append(" Order By ").append(queryParamMap.get("Order By"));
        } else {
            query.append(" Order By bu.updatedTime");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Budget Usage Query >>>>>>>> " + query.toString()));
        }
        Query query1 = this.persistenceService.getSession().createQuery(query.toString());
        if (this.isNotNull(queryParamMap.get("fromDate"))) {
            query1.setTimestamp("from", (Date)queryParamMap.get("fromDate"));
        }
        if (this.isNotNull(queryParamMap.get("toDate"))) {
            Date date = (Date)queryParamMap.get("toDate");
            date.setMinutes(59);
            date.setHours(23);
            date.setSeconds(59);
            query1.setTimestamp("to", date);
        }
        listBudgetUsage = query1.list();
        return listBudgetUsage;
    }

    private boolean isNotNull(Object ob) {
        return ob != null;
    }

    public List<EntityType> loadEntitesFor(Accountdetailtype detailType) throws ClassNotFoundException {
        String table = detailType.getFullQualifiedName();
        Class<?> service = Class.forName(table);
        String simpleName = service.getSimpleName();
        simpleName = simpleName.substring(0, 1).toLowerCase() + simpleName.substring(1) + "Service";
        EntityTypeService entityService = (EntityTypeService)this.context.getBean(simpleName);
        return entityService.getAllActiveEntities(detailType.getId());
    }

    public BigDecimal getBillAccountBalanceforDate(Date asondate, String glcode, String fundcode, Integer accountdetailType, Integer accountdetailkey) throws ValidationException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"EgovCommon | getBillAccountBalanceforDate | Start");
        }
        LOGGER.debug((Object)("Data Received asondate = " + asondate + " glcode = " + glcode + " fundcode = " + fundcode + " accountdetailType = " + accountdetailType + " accountdetailkey = " + accountdetailkey));
        this.validateParameterData(asondate, glcode, fundcode, accountdetailType, accountdetailkey);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"validation of data is sucessfull");
        }
        BigDecimal billBalAsonDate = this.getBillAccBalAsonDate(asondate, glcode, fundcode, accountdetailType, accountdetailkey);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"EgovCommon | getBillAccountBalanceforDate | End");
        }
        return billBalAsonDate;
    }

    private BigDecimal getBillAccBalAsonDate(Date asondate, String glcode, String fundcode, Integer accountdetailType, Integer accountdetailkey) throws ValidationException {
        StringBuffer query = new StringBuffer(400);
        BigDecimal billAccCodeBalance = BigDecimal.ZERO;
        if (null == accountdetailType && null == accountdetailkey) {
            query.append("SELECT (case when sum(egd.debitamount) = null then 0 else sum(egd.debitamount) end - case when sum(egd.creditamount) = null THEN 0 else sum(egd.creditamount) end)").append("as amount FROM EgBillregister egb, EgBilldetails egd,EgBillregistermis egmis ");
            query.append(" Where egb.id = egmis.egBillregister.id and egd.egBillregister.id = egb.id and egmis.voucherHeader is null ").append(" and egd.glcodeid=(select id from CChartOfAccounts where glcode=?) and egmis.fund.code=?").append(" and egb.billdate <='").append(Constants.DDMMYYYYFORMAT1.format(asondate)).append("' and egb.status IN (select id from ").append(" EgwStatus where UPPER(code)!='CANCELLED')");
        } else {
            query.append("SELECT (case when sum(egp.debitAmount) = null then 0 else sum(egp.debitAmount) - case when sum(egp.creditAmount) = null then 0 else sum(egp.creditAmount))").append("as amount FROM EgBillregister egb, EgBilldetails egd,EgBillregistermis egmis,EgBillPayeedetails egp");
            query.append(" Where egb.id = egmis.egBillregister.id and egd.egBillregister.id = egb.id and egmis.voucherHeader is null ").append(" and egp.egBilldetailsId.id=egd.id and egd.glcodeid=(select id from CChartOfAccounts where glcode=?) and egmis.fund.code=?").append(" and egb.billdate <='").append(Constants.DDMMYYYYFORMAT1.format(asondate)).append("' and egb.status IN (select id from ").append(" EgwStatus where UPPER(code)!='CANCELLED')").append(" and egp.accountDetailTypeId=").append(accountdetailType);
            if (null != accountdetailkey) {
                query.append(" and egp.accountDetailKeyId=").append(accountdetailkey);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("getBillAccBalAsonDate query = " + query.toString()));
        }
        List listAmt = this.getPersistenceService().findAllBy(query.toString(), new Object[]{glcode, fundcode});
        listAmt.get(0);
        listAmt.get(0);
        billAccCodeBalance = BigDecimal.valueOf(listAmt.get(0) == null ? 0.0 : (Double)listAmt.get(0));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("getBillAccBalAsonDate | Bill Account Balance = " + billAccCodeBalance));
        }
        return billAccCodeBalance;
    }

    public BigDecimal getCreditBalanceforDate(Date asondate, String glcode, String fundcode, Integer accountdetailType, Integer accountdetailkey) throws ValidationException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"EgovCommon | getCreditBalanceforDate | Start");
        }
        LOGGER.debug((Object)("Data Received asondate = " + asondate + " glcode = " + glcode + " fundcode = " + fundcode + " accountdetailType = " + accountdetailType + " accountdetailkey = " + accountdetailkey));
        this.validateParameterData(asondate, glcode, fundcode, accountdetailType, accountdetailkey);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"validation of data is sucessfull");
        }
        BigDecimal creditOpeningBalance = this.getCreditOpeningBalAsonDate(asondate, glcode, fundcode, accountdetailType, accountdetailkey);
        BigDecimal creditBalance = null;
        StringBuffer query = new StringBuffer(400);
        if (null == accountdetailType && null == accountdetailkey) {
            query.append("SELECT  sum(gl.creditAmount)").append(" as amount FROM  CGeneralLedger gl , CVoucherHeader vh WHERE ").append(" gl.voucherHeaderId.id=vh.id and gl.glcodeId.glcode=? and vh.fundId.code=? ").append(" and vh.voucherDate >= (select startingDate from CFinancialYear where  startingDate <= '").append(Constants.DDMMYYYYFORMAT1.format(asondate)).append("' AND endingDate >='").append(Constants.DDMMYYYYFORMAT1.format(asondate)).append("') and vh.voucherDate <='").append(Constants.DDMMYYYYFORMAT1.format(asondate)).append("'and vh.status=0");
            List list = this.getPersistenceService().findAllBy(query.toString(), new Object[]{glcode, fundcode});
            Double amount = (Double)list.get(0) == null ? 0.0 : (Double)list.get(0);
            creditBalance = BigDecimal.valueOf(amount);
        } else {
            query.append("SELECT sum(gld.amount) as creditamount from CVoucherHeader vh , CGeneralLedger gl,CGeneralLedgerDetail gld").append(" WHERE gl.voucherHeaderId.id=vh.id and gl.id = gld.generalLedgerId.id and gl.glcodeId.glcode=? and vh.fundId.code=? ").append(" and vh.voucherDate >= (select startingDate from CFinancialYear where  startingDate <= '").append(Constants.DDMMYYYYFORMAT1.format(asondate)).append("' AND endingDate >='").append(Constants.DDMMYYYYFORMAT1.format(asondate)).append("') and vh.voucherDate <='").append(Constants.DDMMYYYYFORMAT1.format(asondate)).append("'and vh.status = 0").append(" and gld.detailTypeId.id =").append(accountdetailType);
            if (null != accountdetailkey) {
                query.append(" and gld.detailKeyId =").append(accountdetailkey);
            }
            query.append(" and gl.creditAmount >0");
            List listCrd = this.getPersistenceService().findAllBy(query.toString(), new Object[]{glcode, fundcode});
            creditBalance = (BigDecimal)listCrd.get(0) == null ? BigDecimal.ZERO : (BigDecimal)listCrd.get(0);
        }
        creditOpeningBalance = creditOpeningBalance == null ? BigDecimal.ZERO : creditOpeningBalance;
        creditBalance = creditBalance.add(creditOpeningBalance);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"EgovCommon | getCreditBalanceforDate | End");
        }
        return creditBalance;
    }

    public BigDecimal getDepositAmountForDepositCode(Date asondate, String glcode, String fundcode, Integer accountdetailType, Integer accountdetailkey) throws ValidationException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"EgovCommon | getCreditBalanceforDate | Start");
        }
        LOGGER.debug((Object)("Data Received asondate = " + asondate + " glcode = " + glcode + " fundcode = " + fundcode + " accountdetailType = " + accountdetailType + " accountdetailkey = " + accountdetailkey));
        this.validateParameterData(asondate, glcode, fundcode, accountdetailType, accountdetailkey);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"validation of data is sucessfull");
        }
        StringBuffer queryString = new StringBuffer(400);
        queryString.append("SELECT MIN(vh.voucherDate) as vhDate from CVoucherHeader vh , CGeneralLedger gl,CGeneralLedgerDetail gld").append(" WHERE gl.voucherHeaderId.id=vh.id and gl.id = gld.generalLedgerId.id and gl.glcodeId.glcode=? and vh.fundId.code=? ").append(" and vh.voucherDate <= '").append(Constants.DDMMYYYYFORMAT1.format(asondate)).append("' and vh.status = 0").append(" and gld.detailTypeId.id =").append(accountdetailType);
        queryString.append(" and gld.detailKeyId =").append(accountdetailkey);
        queryString.append(" and gl.creditAmount >0");
        Date minVouDate = (Date)this.getPersistenceService().findAllBy(queryString.toString(), new Object[]{glcode, fundcode}).get(0);
        if (minVouDate == null) {
            minVouDate = new Date();
        }
        BigDecimal creditOpeningBalance = this.getFirstCreditOpeningBalForDepositCodeAsonDate(minVouDate, glcode, fundcode, accountdetailkey);
        BigDecimal creditBalance = null;
        StringBuffer query = new StringBuffer(400);
        query.append("SELECT sum(gld.amount) as creditamount from CVoucherHeader vh , CGeneralLedger gl,CGeneralLedgerDetail gld").append(" WHERE gl.voucherHeaderId.id=vh.id and gl.id = gld.generalLedgerId.id and gl.glcodeId.glcode=? and vh.fundId.code=? ").append(" and vh.voucherDate <= '").append(Constants.DDMMYYYYFORMAT1.format(asondate)).append("' and vh.status = 0").append(" and gld.detailTypeId.id =").append(accountdetailType);
        if (null != accountdetailkey) {
            query.append(" and gld.detailKeyId =").append(accountdetailkey);
        }
        query.append(" and gl.creditAmount >0");
        List listCrd = this.getPersistenceService().findAllBy(query.toString(), new Object[]{glcode, fundcode});
        creditBalance = (BigDecimal)listCrd.get(0) == null ? BigDecimal.ZERO : (BigDecimal)listCrd.get(0);
        creditOpeningBalance = creditOpeningBalance == null ? BigDecimal.ZERO : creditOpeningBalance;
        creditBalance = creditBalance.add(creditOpeningBalance);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"EgovCommon | getCreditBalanceforDate | End");
        }
        return creditBalance;
    }

    private BigDecimal getFirstCreditOpeningBalForDepositCodeAsonDate(Date asondate, String glcode, String fundCode, Integer accountdetailkey) throws ValidationException {
        List list;
        BigDecimal opBalAsonDate = BigDecimal.ZERO;
        StringBuffer opBalncQuery = new StringBuffer(300);
        if (null != accountdetailkey) {
            opBalncQuery.append("SELECT SUM(txns.openingcreditbalance) FROM transactionsummary txns, chartofaccounts coa, fund fd, accountdetailtype adt, financialyear fy WHERE txns.fundid           = fd.id AND fd.code                 = '").append(fundCode).append("' AND txns.accountdetailkey   =").append(accountdetailkey).append(" AND txns.accountdetailtypeid= adt.id AND upper(adt.name)         = 'DEPOSITCODE' AND txns.glcodeid           = coa.id AND coa.glcode              = '").append(glcode).append("' AND txns.financialyearid    = fy.id AND fy.startingdate        <='").append(Constants.DDMMYYYYFORMAT1.format(asondate)).append("' GROUP BY fy.startingdate ORDER BY fy.startingdate");
        }
        if ((list = this.persistenceService.getSession().createSQLQuery(opBalncQuery.toString()).list()) != null && list.size() > 0) {
            opBalAsonDate = (BigDecimal)list.get(0);
        }
        opBalAsonDate = opBalAsonDate == null ? BigDecimal.ZERO : opBalAsonDate;
        return opBalAsonDate;
    }

    public BigDecimal getAccCodeBalanceForIndirectExpense(Date asondate, String glcode, Integer accountdetailType, String accountdetailkey) throws ValidationException, Exception {
        LOGGER.debug((Object)"EgovCommon | getAccCodeBalanceForIndirectExpense | Start");
        this.validateParameterData(asondate, glcode, accountdetailType, accountdetailkey);
        StringBuffer glCodeBalQry = new StringBuffer(400);
        StringBuffer glCodeDbtBalQry = new StringBuffer(400);
        StringBuffer glCodeCrdBalQry = new StringBuffer(400);
        BigDecimal glCodeBalance = BigDecimal.ZERO;
        BigDecimal subledgerDbtBalance = BigDecimal.ZERO;
        BigDecimal subledgerCrdBalance = BigDecimal.ZERO;
        List appList = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "statusexcludeReport");
        String statusExclude = ((AppConfigValues)appList.get(0)).getValue();
        if (null == accountdetailType && null == accountdetailkey) {
            glCodeBalQry.append("SELECT (case when sum(gl.debitAmount)=null then 0 else sum(gl.debitAmount) end - case when sum(gl.creditAmount)  = null then 0 else sum(gl.creditAmount) end)").append(" as amount FROM  CGeneralLedger gl , CVoucherHeader vh WHERE  gl.voucherHeaderId.id=vh.id and gl.glcodeId.glcode=?").append(" and vh.voucherDate >= (select startingDate from CFinancialYear where  startingDate <= '").append(Constants.DDMMYYYYFORMAT1.format(asondate)).append("' AND endingDate >='").append(Constants.DDMMYYYYFORMAT1.format(asondate)).append("') and vh.voucherDate <='").append(Constants.DDMMYYYYFORMAT1.format(asondate)).append("'and vh.status not in (").append(statusExclude).append(") and ((vh.name='Contractor Journal' and state_id is null) or(vh.name !='Contractor Journal' and vh.name !='CapitalisedAsset' ) )");
            List list = this.getPersistenceService().findAllBy(glCodeBalQry.toString(), new Object[]{glcode});
            glCodeBalance = BigDecimal.valueOf((Double)list.get(0));
        } else {
            glCodeDbtBalQry.append("SELECT sum(gld.amount)  as debitamount from CVoucherHeader vh , CGeneralLedger gl,CGeneralLedgerDetail gld").append(" WHERE gl.voucherHeaderId.id=vh.id and gl.id = gld.generalLedgerId.id and gl.glcodeId.glcode=?  ").append(" and vh.voucherDate >= (select startingDate from CFinancialYear where  startingDate <= '").append(Constants.DDMMYYYYFORMAT1.format(asondate)).append("' AND endingDate >='").append(Constants.DDMMYYYYFORMAT1.format(asondate)).append("') and vh.voucherDate <='").append(Constants.DDMMYYYYFORMAT1.format(asondate)).append("'and vh.status not in (").append(statusExclude).append(")and ((vh.name='Contractor Journal' and state_id is null) or(vh.name !='Contractor Journal' and vh.name !='CapitalisedAsset') ) ").append(" and gld.detailTypeId.id =").append(accountdetailType);
            if (null != accountdetailkey) {
                glCodeDbtBalQry.append(" and gld.detailKeyId in (").append(accountdetailkey).append(")");
            }
            glCodeDbtBalQry.append(" and gl.debitAmount >0");
            List listDbt = this.getPersistenceService().findAllBy(glCodeDbtBalQry.toString(), new Object[]{glcode});
            BigDecimal bigDecimal = subledgerDbtBalance = (BigDecimal)listDbt.get(0) == null ? BigDecimal.ZERO : (BigDecimal)listDbt.get(0);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)(" total debit amount :  " + subledgerDbtBalance));
            }
            glCodeCrdBalQry.append("SELECT sum(gld.amount) as creditamount from CVoucherHeader vh , CGeneralLedger gl,CGeneralLedgerDetail gld").append(" WHERE gl.voucherHeaderId.id=vh.id and gl.id = gld.generalLedgerId.id and gl.glcodeId.glcode=?  ").append(" and vh.voucherDate >= (select startingDate from CFinancialYear where  startingDate <= '").append(Constants.DDMMYYYYFORMAT1.format(asondate)).append("' AND endingDate >='").append(Constants.DDMMYYYYFORMAT1.format(asondate)).append("') and vh.voucherDate <='").append(Constants.DDMMYYYYFORMAT1.format(asondate)).append("'and vh.status not in (").append(statusExclude).append(")and ((vh.name='Contractor Journal' and state_id is null) or(vh.name !='Contractor Journal' and vh.name !='CapitalisedAsset' ) )").append(" and gld.detailTypeId.id =").append(accountdetailType);
            if (null != accountdetailkey) {
                glCodeCrdBalQry.append(" and gld.detailKeyId in(").append(accountdetailkey).append(")");
            }
            glCodeCrdBalQry.append(" and gl.creditAmount >0");
            List listCrd = this.getPersistenceService().findAllBy(glCodeCrdBalQry.toString(), new Object[]{glcode});
            BigDecimal bigDecimal2 = subledgerCrdBalance = (BigDecimal)listCrd.get(0) == null ? BigDecimal.ZERO : (BigDecimal)listCrd.get(0);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)(" total credit amount :  " + subledgerCrdBalance));
            }
            glCodeBalance = subledgerDbtBalance.subtract(subledgerCrdBalance);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)(" total balance amount :  " + glCodeBalance));
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"EgovCommon | getAccCodeBalanceForIndirectExpense | End");
        }
        glCodeBalance = glCodeBalance.setScale(2);
        return glCodeBalance;
    }

    private void validateParameterData(Date asondate, String glcode, Integer accountdetailType, String accountdetailkey) {
        Query qry;
        Session session;
        if (null == asondate) {
            throw new ValidationException(Arrays.asList(new ValidationError("asondate", "asondate supplied is null")));
        }
        if (null == glcode || StringUtils.isEmpty((String)glcode)) {
            throw new ValidationException(Arrays.asList(new ValidationError("glcode", "glcode supplied is either null or empty")));
        }
        if (null == this.chartOfAccountsDAO.getCChartOfAccountsByGlCode(glcode)) {
            throw new ValidationException(Arrays.asList(new ValidationError("glcode", "not a valid glcode :" + glcode)));
        }
        if (null != accountdetailType) {
            session = this.persistenceService.getSession();
            qry = session.createQuery("from CChartOfAccountDetail cd,CChartOfAccounts c where cd.glCodeId = c.id and c.glcode=:glcode and cd.detailTypeId=:detailTypeId");
            qry.setString("glcode", glcode);
            qry.setString("detailTypeId", accountdetailType.toString());
            if (null == qry.list() || qry.list().size() == 0) {
                throw new ValidationException(Arrays.asList(new ValidationError("accountdetailType", "Glcode " + glcode + " is not a control code for the supplied detailed type.")));
            }
        }
        if (null != accountdetailkey) {
            session = this.persistenceService.getSession();
            qry = session.createQuery("from Accountdetailkey adk where adk.accountdetailtype=:detailtypeid and adk.detailkey=:detailkey");
            qry.setString("detailtypeid", accountdetailType.toString());
            qry.setString("detailkey", accountdetailkey.toString());
            if (null == qry.list() || qry.list().size() == 0) {
                throw new ValidationException(Arrays.asList(new ValidationError("accountdetailkey", "The accountdetailkey supplied : " + accountdetailkey + " for the accountdetailType : " + accountdetailType + " is not correct")));
            }
        }
    }

    public AccountCodePurpose getAccountCodePurposeByName(String name) {
        if (name == null || name.isEmpty()) {
            throw new ApplicationRuntimeException("Name is Null Or Empty");
        }
        return (AccountCodePurpose)((Object)this.persistenceService.find("from AccountCodePurpose where upper(name)=upper(?)", new Object[]{name}));
    }

    public Map<String, BigDecimal> getPaymentInfoforProjectCode(List<Long> projectCodeIdList, Date asOnDate) throws ApplicationException {
        if (projectCodeIdList == null || projectCodeIdList.size() == 0) {
            throw new ApplicationException("ProjectCode Id list is null or empty");
        }
        if (asOnDate == null) {
            throw new ApplicationException("asOnDate is null");
        }
        String strAsOnDate = Constants.DDMMYYYYFORMAT1.format(asOnDate);
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
        ArrayList<String> commaSeperatedEntitiesList = new ArrayList<String>();
        ArrayList limitedEntityList = new ArrayList();
        String commaSeperatedEntities = "";
        ArrayList<Long> tempEntityIdList = new ArrayList<Long>();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(" Size of entityIdList-" + projectCodeIdList.size() + " asOnDate - " + asOnDate));
        }
        for (int i = 0; i < projectCodeIdList.size(); ++i) {
            Long entityId = projectCodeIdList.get(i);
            commaSeperatedEntities = commaSeperatedEntities + entityId + ",";
            tempEntityIdList.add(entityId);
            if ((i == 0 || i % 998 != 0) && i != projectCodeIdList.size() - 1) continue;
            commaSeperatedEntitiesList.add(commaSeperatedEntities.substring(0, commaSeperatedEntities.length() - 1));
            limitedEntityList.add(tempEntityIdList);
            commaSeperatedEntities = "";
            tempEntityIdList = new ArrayList();
        }
        String validationQuery = "SELECT detailkey FROM accountdetailkey WHERE detailtypeid= (SELECT id FROM accountdetailtype WHERE name ='PROJECTCODE' AND description='PROJECTCODE' ) and detailkey in (";
        List dbEntIdList = new ArrayList();
        ArrayList<Long> incorrectEntityIds = new ArrayList<Long>();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)" Validation Starts ");
        }
        for (int i = 0; i < commaSeperatedEntitiesList.size(); ++i) {
            boolean isPresent = false;
            String dbEntIdQuery = "SELECT detailkey FROM accountdetailkey WHERE detailtypeid= (SELECT id FROM accountdetailtype WHERE name ='PROJECTCODE' AND description='PROJECTCODE' ) and detailkey in (" + (String)commaSeperatedEntitiesList.get(i) + " ) order by detailkey ";
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)(i + ":dbEntIdQuery- " + dbEntIdQuery));
            }
            if ((dbEntIdList = this.persistenceService.getSession().createSQLQuery(dbEntIdQuery).list()) == null || dbEntIdList.size() == ((List)limitedEntityList.get(i)).size()) continue;
            for (Long entId : (List)limitedEntityList.get(i)) {
                isPresent = false;
                for (BigDecimal dbEntId : dbEntIdList) {
                    if (dbEntId.longValue() != entId.longValue()) continue;
                    isPresent = true;
                    break;
                }
                if (isPresent) continue;
                incorrectEntityIds.add(entId);
            }
        }
        if (incorrectEntityIds.size() != 0) {
            throw new ApplicationException("Incorrect detail key Ids - " + incorrectEntityIds);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)" Validation Succeded ");
        }
        String qryForExpense = "";
        String qryForNonExpense = "";
        BigDecimal totalExpensePaymentAmount = BigDecimal.ZERO;
        BigDecimal totalExpensePaymentCount = BigDecimal.ZERO;
        BigDecimal totalNonExpensePaymentAmount = BigDecimal.ZERO;
        BigDecimal totalNonExpensePaymentCount = BigDecimal.ZERO;
        BigDecimal tempAmountObj = BigDecimal.ZERO;
        BigDecimal tempCountObj = BigDecimal.ZERO;
        for (int i = 0; i < commaSeperatedEntitiesList.size(); ++i) {
            qryForExpense = this.getPaymentInfoQuery((String)commaSeperatedEntitiesList.get(i), strAsOnDate, true);
            qryForNonExpense = this.getPaymentInfoQuery((String)commaSeperatedEntitiesList.get(i), strAsOnDate, false);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)(i + ": qryForExpense- " + qryForExpense));
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)(i + ": qryForNonExpense- " + qryForNonExpense));
            }
            List objForExpense = this.persistenceService.getSession().createSQLQuery(qryForExpense).list();
            List objForNonExpense = this.persistenceService.getSession().createSQLQuery(qryForNonExpense).list();
            if (objForExpense != null && objForExpense.size() != 0) {
                tempAmountObj = new BigDecimal(((Object[])objForExpense.get(0))[0].toString());
                tempCountObj = new BigDecimal(((Object[])objForExpense.get(0))[1].toString());
                totalExpensePaymentAmount = totalExpensePaymentAmount.add(tempAmountObj);
                totalExpensePaymentCount = totalExpensePaymentCount.add(tempCountObj);
            }
            if (objForNonExpense == null || objForNonExpense.size() == 0) continue;
            tempAmountObj = new BigDecimal(((Object[])objForNonExpense.get(0))[0].toString());
            tempCountObj = new BigDecimal(((Object[])objForNonExpense.get(0))[1].toString());
            totalNonExpensePaymentAmount = totalNonExpensePaymentAmount.add(tempAmountObj);
            totalNonExpensePaymentCount = totalNonExpensePaymentCount.add(tempCountObj);
        }
        result.put("count", totalExpensePaymentCount.add(totalNonExpensePaymentCount));
        result.put("amount", totalExpensePaymentAmount.add(totalNonExpensePaymentAmount));
        return result;
    }

    public Map<String, BigDecimal> getTotalPaymentforProjectCode(List<Long> projectCodeIdList, Date asOnDate) throws ApplicationException {
        List objForExpense;
        int i;
        if (projectCodeIdList == null || projectCodeIdList.size() == 0) {
            throw new ApplicationException("ProjectCode Id list is null or empty");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(" Size of entityIdList-" + projectCodeIdList.size()));
        }
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
        ArrayList<String> commaSeperatedEntitiesList = new ArrayList<String>();
        ArrayList limitedEntityList = new ArrayList();
        String commaSeperatedEntities = "";
        String asondateCondition = "";
        ArrayList<Long> tempEntityIdList = new ArrayList<Long>();
        String projectCodeListCondition = "";
        BigDecimal totalPaymentAmount = BigDecimal.ZERO;
        BigDecimal totalCount = BigDecimal.ZERO;
        for (i = 0; i < projectCodeIdList.size(); ++i) {
            Long entityId = projectCodeIdList.get(i);
            commaSeperatedEntities = commaSeperatedEntities + entityId + ",";
            tempEntityIdList.add(entityId);
            if ((i == 0 || i % 998 != 0) && i != projectCodeIdList.size() - 1) continue;
            commaSeperatedEntitiesList.add(commaSeperatedEntities.substring(0, commaSeperatedEntities.length() - 1));
            limitedEntityList.add(tempEntityIdList);
            commaSeperatedEntities = "";
            tempEntityIdList = new ArrayList();
        }
        for (i = 0; i < commaSeperatedEntitiesList.size(); ++i) {
            String stringIdsList = (String)commaSeperatedEntitiesList.get(i);
            projectCodeListCondition = i != 0 ? projectCodeListCondition + ") or bp.ACCOUNTDETAILKEYID in (" + stringIdsList : stringIdsList;
        }
        if (asOnDate != null) {
            asondateCondition = "and vh1.voucherdate <= '" + Constants.DDMMYYYYFORMAT1.format(asOnDate) + "'";
        }
        String payQuery = "SELECT coalesce(sum(mb.paidamount),0),count(vh1.id) FROM    miscbilldetail mb,voucherheader vh1 WHERE vh1.id=mb.PAYVHID " + asondateCondition + " and vh1.status=" + FinancialConstants.CREATEDVOUCHERSTATUS + " and mb.BILLVHID in( select vh.id FROM eg_billregister br,eg_billdetails bd, eg_billpayeedetails bp,voucherheader vh,eg_billregistermis ms WHERE br.id=bd.billid and bd.id=bp.BILLDETAILID and vh.id=ms.VOUCHERHEADERID and ms.BILLID=br.id and br.STATUSID in(select id from egw_status where lower(code)='approved' and moduletype in('SALBILL','EXPENSEBILL','SBILL','CONTRACTORBILL','CBILL')) and bd.DEBITAMOUNT>0  and vh.STATUS=" + FinancialConstants.CREATEDVOUCHERSTATUS + " and bp.ACCOUNTDETAILTYPEID= (SELECT id FROM accountdetailtype WHERE name ='PROJECTCODE' AND description='PROJECTCODE' ) and (bp.ACCOUNTDETAILKEYID in(" + projectCodeListCondition + ")))";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Final payQuery - " + payQuery));
        }
        if ((objForExpense = this.persistenceService.getSession().createSQLQuery(payQuery).list()) != null && objForExpense.size() != 0) {
            totalPaymentAmount = new BigDecimal(((Object[])objForExpense.get(0))[0].toString());
            totalCount = new BigDecimal(((Object[])objForExpense.get(0))[1].toString());
        }
        result.put("count", totalCount);
        result.put("amount", totalPaymentAmount);
        return result;
    }

    public Map<String, String> getPaymentInfoforProjectCodeByDepartment(List<Long> projectCodeIdList, Date asOnDate) throws ApplicationException {
        if (projectCodeIdList == null || projectCodeIdList.size() == 0) {
            throw new ApplicationException("ProjectCode Id list is null or empty");
        }
        if (asOnDate == null) {
            throw new ApplicationException("asOnDate is null");
        }
        String strAsOnDate = Constants.DDMMYYYYFORMAT1.format(asOnDate);
        HashMap<String, String> result = new HashMap<String, String>();
        ArrayList<String> commaSeperatedEntitiesList = new ArrayList<String>();
        ArrayList limitedEntityList = new ArrayList();
        String commaSeperatedEntities = "";
        ArrayList<Long> tempEntityIdList = new ArrayList<Long>();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(" Size of entityIdList-" + projectCodeIdList.size() + " asOnDate - " + asOnDate));
        }
        for (int i = 0; i < projectCodeIdList.size(); ++i) {
            Long entityId = projectCodeIdList.get(i);
            commaSeperatedEntities = commaSeperatedEntities + entityId + ",";
            tempEntityIdList.add(entityId);
            if ((i == 0 || i % 998 != 0) && i != projectCodeIdList.size() - 1) continue;
            commaSeperatedEntitiesList.add(commaSeperatedEntities.substring(0, commaSeperatedEntities.length() - 1));
            limitedEntityList.add(tempEntityIdList);
            commaSeperatedEntities = "";
            tempEntityIdList = new ArrayList();
        }
        String qryForExpense = "";
        String qryForNonExpense = "";
        BigDecimal totalExpensePaymentAmount = BigDecimal.ZERO;
        String deptName = null;
        BigDecimal tempAmountObj = BigDecimal.ZERO;
        boolean ifDeptExist = false;
        for (int i = 0; i < commaSeperatedEntitiesList.size(); ++i) {
            qryForExpense = this.getPaymentAmountByDept((String)commaSeperatedEntitiesList.get(i), strAsOnDate, true);
            qryForNonExpense = this.getPaymentAmountByDept((String)commaSeperatedEntitiesList.get(i), strAsOnDate, false);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)(i + ": qryForExpense- " + qryForExpense));
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)(i + ": qryForNonExpense- " + qryForNonExpense));
            }
            List objForExpense = this.persistenceService.getSession().createSQLQuery(qryForExpense).list();
            List objForNonExpense = this.persistenceService.getSession().createSQLQuery(qryForNonExpense).list();
            if (objForExpense != null && objForExpense.size() != 0) {
                tempAmountObj = new BigDecimal(((Object[])objForExpense.get(0))[0].toString());
                deptName = ((Object[])objForExpense.get(0))[1].toString();
                ifDeptExist = result.containsValue(deptName);
                if (ifDeptExist) {
                    result.put(deptName, totalExpensePaymentAmount.add(tempAmountObj).toString());
                    result.put("departmentname", deptName);
                } else {
                    result.put(deptName, tempAmountObj.toString());
                    result.put("departmentname", deptName);
                }
            }
            ifDeptExist = false;
            if (objForNonExpense == null || objForNonExpense.size() == 0) continue;
            tempAmountObj = new BigDecimal(((Object[])objForNonExpense.get(0))[0].toString());
            deptName = ((Object[])objForNonExpense.get(0))[1].toString();
            ifDeptExist = result.containsValue(deptName);
            if (ifDeptExist) {
                result.put(deptName, totalExpensePaymentAmount.add(tempAmountObj).toString());
                result.put("departmentname", deptName);
                continue;
            }
            result.put(deptName, tempAmountObj.toString());
            result.put("departmentname", deptName);
        }
        return result;
    }

    public BigDecimal getPaymentAmount(Long billId) throws ApplicationException {
        List paymentAmount;
        if (billId == null) {
            throw new ApplicationException("Parameter passed is null.");
        }
        EgBillregister billRegister = (EgBillregister)this.persistenceService.getSession().load(EgBillregister.class, (Serializable)billId);
        if (billRegister == null) {
            throw new ApplicationException("Incorrect billId - " + billId);
        }
        EgwStatus billStatus = billRegister.getStatus();
        if (billStatus.getDescription().equalsIgnoreCase("Cancelled")) {
            throw new ApplicationException("Bill with id - " + billId + " is cancelled.");
        }
        String sqlQuery = "SELECT nvl(sum(misc.paidamount),0) FROM eg_billregister br, eg_billregistermis bmis, voucherheader bvh,  miscbilldetail misc, voucherheader pvh WHERE br.id=" + billRegister.getId() + " and br.id=bmis.billid  AND bmis.voucherheaderid=bvh.id AND bvh.id= misc.billvhid and pvh.id= misc.payvhid  and pvh.status=" + FinancialConstants.CREATEDVOUCHERSTATUS + " ";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("sqlQuery- " + sqlQuery));
        }
        return (paymentAmount = this.persistenceService.getSession().createSQLQuery(sqlQuery).list()).get(0) == null ? BigDecimal.ZERO : (BigDecimal)paymentAmount.get(0);
    }

    private String getPaymentInfoQuery(String stringIdsList, String strDate, boolean isExpenseType) {
        String qryForExpense = "select nvl(sum(amt),0), count(*) from ( select sum(" + (isExpenseType ? "gd.amount" : "m.paidamount") + ") as amt, count(*), pvh.id as pvh_id from generalledger g, generalledgerdetail gd, voucherheader bvh,  miscbilldetail m, voucherheader pvh where g.id= gd.generalledgerid and g.voucherheaderid=bvh.id and m.billvhid= bvh.id and m.payvhid= pvh.id and gd.detailtypeid=(SELECT id FROM accountdetailtype WHERE name ='PROJECTCODE' AND description='PROJECTCODE' )  and pvh.status=" + FinancialConstants.CREATEDVOUCHERSTATUS + " and gd.detailkeyid in (" + stringIdsList + ")   and pvh.voucherdate<='" + strDate + "'  and bvh.name" + (isExpenseType ? "=" : "!=") + "'" + "Expense Journal" + "' group by pvh.id) ";
        return qryForExpense;
    }

    private String getPaymentAmountByDept(String stringIdsList, String strDate, boolean isExpenseType) {
        String qryForExpense = "select sum(" + (isExpenseType ? "gd.amount" : "m.paidamount") + ") as amt, dept.dept_name as dept_name from generalledger g, generalledgerdetail gd,voucherheader bvh,vouchermis mis,eg_department dept,   miscbilldetail m, voucherheader pvh where g.id= gd.generalledgerid and g.voucherheaderid=bvh.id  and m.billvhid= bvh.id and mis.voucherheaderid=pvh.id and dept.id_dept=mis.departmentid  and m.payvhid= pvh.id and gd.detailtypeid=(SELECT id FROM accountdetailtype WHERE name ='PROJECTCODE' AND description='PROJECTCODE' )  and pvh.status=" + FinancialConstants.CREATEDVOUCHERSTATUS + " and gd.detailkeyid in (" + stringIdsList + ")   and pvh.voucherdate<='" + strDate + "'  and bvh.name" + (isExpenseType ? "=" : "!=") + "'" + "Expense Journal" + "' group by dept.dept_name ";
        return qryForExpense;
    }

    public List<Map<String, String>> getExpenditureDetailsforProject(Long projectCodeId, Date asOnDate) throws ApplicationRuntimeException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting getExpenditureDetailsforProject .....");
        }
        if (projectCodeId.equals(0L)) {
            throw new ApplicationRuntimeException("ProjectCode is null or empty");
        }
        if (asOnDate == null || asOnDate.equals(null)) {
            throw new ApplicationRuntimeException("asOnDate is null");
        }
        Accountdetailkey adk = (Accountdetailkey)this.persistenceService.find("FROM Accountdetailkey where accountdetailtype.name='PROJECTCODE' and detailkey=?", new Object[]{projectCodeId.intValue()});
        if (adk == null || adk.equals(null)) {
            throw new ApplicationRuntimeException("There is no project code");
        }
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        String queryForGLList = "SELECT gld.amount, vh.id, vh.voucherNumber, vh.voucherDate, egmis.billid, egbill.billnumber FROM generalledger gl, generalledgerdetail gld, accountdetailkey adk, accountdetailtype adt, voucherheader vh left outer join eg_billregistermis egmis on vh.id=egmis.voucherheaderid left outer join eg_billregister egbill on egmis.billid=egbill.id WHERE gl.id           = gld.generalledgerid AND gl.voucherheaderid= vh.id AND gld.detailtypeid  = adt.id AND gld.detailkeyid   = adk.detailkey AND adt.name          ='PROJECTCODE' AND adk.detailtypeid  = adt.id AND adk.detailkey     =" + projectCodeId + " AND gl.debitamount<>0 AND vh.voucherdate<='" + Constants.DDMMYYYYFORMAT1.format(asOnDate) + "' AND vh.status=0";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("queryForGLList >> " + queryForGLList));
        }
        List generalLedgerList = this.persistenceService.getSession().createSQLQuery(queryForGLList).list();
        for (Object[] objects : generalLedgerList) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)"Project code has vouchers.");
            }
            HashMap<String, String> mp = new HashMap<String, String>();
            if (objects[0].toString() != null) {
                mp.put("Amount", objects[0].toString());
            }
            if (objects[2] != null && objects[3] != null) {
                mp.put("VoucherNumber", objects[2].toString());
                mp.put("VoucherDate", Constants.DDMMYYYYFORMAT2.format(objects[3]));
            }
            if (objects[4] != null && objects[5] != null) {
                mp.put("BillNumber", objects[5].toString());
                mp.put("BillId", objects[4].toString());
            }
            result.add(mp);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed getExpenditureDetailsforProject.");
        }
        return result;
    }

    public List<Map<String, String>> getExpenditureDetailsforDepositCode(Long depositCodeId, Date asOnDate) throws ApplicationRuntimeException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting getExpenditureDetailsforDepositCode .....");
        }
        if (depositCodeId.equals(0L)) {
            throw new ApplicationRuntimeException("DepositCode is null or empty");
        }
        if (asOnDate == null || asOnDate.equals(null)) {
            throw new ApplicationRuntimeException("asOnDate is null");
        }
        Accountdetailkey adk = (Accountdetailkey)this.persistenceService.find("FROM Accountdetailkey where accountdetailtype.name='DEPOSITCODE' and detailkey=?", new Object[]{depositCodeId.intValue()});
        if (adk == null || adk.equals(null)) {
            throw new ApplicationRuntimeException("There is no such Deposit code");
        }
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        String queryForGLList = "SELECT gld.amount, vh.id, vh.voucherNumber, vh.voucherDate, egmis.billid, egbill.billnumber FROM generalledger gl, generalledgerdetail gld, accountdetailkey adk, accountdetailtype adt, voucherheader vh left outer join eg_billregistermis egmis on vh.id=egmis.voucherheaderid left outer join eg_billregister egbill on egmis.billid=egbill.id WHERE gl.id           = gld.generalledgerid AND gl.voucherheaderid= vh.id AND gld.detailtypeid  = adt.id AND gld.detailkeyid   = adk.detailkey AND adt.name          ='DEPOSITCODE' AND adk.detailtypeid  = adt.id AND adk.detailkey     =" + depositCodeId + " AND gl.debitamount<>0 AND vh.voucherdate<='" + Constants.DDMMYYYYFORMAT1.format(asOnDate) + "' AND vh.status=0";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("queryForGLList >> " + queryForGLList));
        }
        List generalLedgerList = this.persistenceService.getSession().createSQLQuery(queryForGLList).list();
        for (Object[] objects : generalLedgerList) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)"Deposit code has vouchers.");
            }
            HashMap<String, String> mp = new HashMap<String, String>();
            if (objects[0].toString() != null) {
                mp.put("Amount", objects[0].toString());
            }
            if (objects[2] != null && objects[3] != null) {
                mp.put("VoucherNumber", objects[2].toString());
                mp.put("VoucherDate", Constants.DDMMYYYYFORMAT2.format(objects[3]));
            }
            if (objects[4] != null && objects[5] != null) {
                mp.put("BillNumber", objects[5].toString());
                mp.put("BillId", objects[4].toString());
            }
            result.add(mp);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed getExpenditureDetailsforDepositCode.");
        }
        return result;
    }

    public List<Map<String, String>> getExpenditureDetailsforProjectforFinYear(Long projectCodeId, Date asOnDate) throws ApplicationRuntimeException {
        LOGGER.debug((Object)"Starting getExpenditureDetailsforProjectforFinYear .....");
        if (projectCodeId.equals(0L)) {
            throw new ApplicationRuntimeException("ProjectCode is null or empty");
        }
        if (asOnDate == null || asOnDate.equals(null)) {
            throw new ApplicationRuntimeException("asOnDate is null");
        }
        Accountdetailkey adk = (Accountdetailkey)this.persistenceService.find("FROM Accountdetailkey where accountdetailtype.name='PROJECTCODE' and detailkey=?", new Object[]{projectCodeId.intValue()});
        if (adk == null || adk.equals(null)) {
            throw new ApplicationRuntimeException("There is no project code");
        }
        CFinancialYear finYear = this.financialYearDAO.getFinancialYearByDate(asOnDate);
        Date startDate = finYear.getStartingDate();
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        String queryForGLList = "SELECT gld.amount, vh.id, vh.voucherNumber, vh.voucherDate, egmis.billid, egbill.billnumber FROM generalledger gl, generalledgerdetail gld, accountdetailkey adk, accountdetailtype adt, voucherheader vh left outer join eg_billregistermis egmis on vh.id=egmis.voucherheaderid left outer join eg_billregister egbill on egmis.billid=egbill.id WHERE gl.id           = gld.generalledgerid AND gl.voucherheaderid= vh.id AND gld.detailtypeid  = adt.id AND gld.detailkeyid   = adk.detailkey AND adt.name          ='PROJECTCODE' AND adk.detailtypeid  = adt.id AND adk.detailkey     =" + projectCodeId + " AND gl.debitamount<>0 AND vh.voucherdate>='" + Constants.DDMMYYYYFORMAT1.format(startDate) + "' AND vh.voucherdate<='" + Constants.DDMMYYYYFORMAT1.format(asOnDate) + "' AND vh.status=0";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("queryForGLList >> " + queryForGLList));
        }
        List generalLedgerList = this.persistenceService.getSession().createSQLQuery(queryForGLList).list();
        for (Object[] objects : generalLedgerList) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)"Project code has vouchers.");
            }
            HashMap<String, String> mp = new HashMap<String, String>();
            if (objects[0].toString() != null) {
                mp.put("Amount", objects[0].toString());
            }
            if (objects[2] != null && objects[3] != null) {
                mp.put("VoucherNumber", objects[2].toString());
                mp.put("VoucherDate", Constants.DDMMYYYYFORMAT2.format(objects[3]));
            }
            if (objects[4] != null && objects[5] != null) {
                mp.put("BillNumber", objects[5].toString());
                mp.put("BillId", objects[4].toString());
            }
            result.add(mp);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed getExpenditureDetailsforProjectforFinYear.");
        }
        return result;
    }

    public BigDecimal getVoucherExpenditureByEntities(Integer detailTypeId, List<Integer> entityIdList) {
        BigDecimal voucherSum = BigDecimal.ZERO;
        if (detailTypeId == null || entityIdList == null || entityIdList.size() == 0) {
            throw new ValidationException("DetailTypeId or EntityIdList not provided", "DetailTypeId or EntityIdList not provided", new String[0]);
        }
        String query = "select sum(gld.amount) from CGeneralLedger gl, CGeneralLedgerDetail gld, CVoucherHeader vh  WHERE gl.voucherHeaderId= vh and gl.id = gld.generalLedgerId.id and  gld.detailTypeId.id  in ( :detailTypeId ) and gld.detailKeyId   in ( :entityIdList ) and gl.debitAmount>0 and vh.status!=4 and vh.type = 'Journal Voucher'";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"query For getVoucherExpenditureByEntities >> select sum(gld.amount) from CGeneralLedger gl, CGeneralLedgerDetail gld, CVoucherHeader vh  WHERE gl.voucherHeaderId= vh and gl.id = gld.generalLedgerId.id and  gld.detailTypeId.id  in ( :detailTypeId ) and gld.detailKeyId   in ( :entityIdList ) and gl.debitAmount>0 and vh.status!=4 and vh.type = 'Journal Voucher'");
        }
        Query expenditureQuery = this.persistenceService.getSession().createQuery("select sum(gld.amount) from CGeneralLedger gl, CGeneralLedgerDetail gld, CVoucherHeader vh  WHERE gl.voucherHeaderId= vh and gl.id = gld.generalLedgerId.id and  gld.detailTypeId.id  in ( :detailTypeId ) and gld.detailKeyId   in ( :entityIdList ) and gl.debitAmount>0 and vh.status!=4 and vh.type = 'Journal Voucher'");
        expenditureQuery.setInteger("detailTypeId", detailTypeId.intValue());
        expenditureQuery.setParameterList("entityIdList", entityIdList);
        List result = expenditureQuery.list();
        if (result != null) {
            voucherSum = this.getBigDecimalValue(result.get(0));
        }
        return voucherSum;
    }

    public BigDecimal getDirectBankPaymentExpenditureByEntities(Integer detailTypeId, List<Integer> entityIdList) {
        if (detailTypeId == null || entityIdList == null || entityIdList.size() == 0) {
            throw new ValidationException("DetailTypeId or EntityIdList not provided", "DetailTypeId or EntityIdList not provided", new String[0]);
        }
        BigDecimal dbpSum = BigDecimal.ZERO;
        String query = "select sum(gld.amount) from CGeneralLedger gl, CGeneralLedgerDetail gld, CVoucherHeader vh  WHERE gl.voucherHeaderId= vh and gl.id = gld.generalLedgerId.id and  gld.detailTypeId.id  in ( :detailTypeId ) and gld.detailKeyId   in ( :entityIdList ) and gl.debitAmount>0 and vh.status!=4 and vh.name = 'Direct Bank Payment'";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"query For getDirectBankPaymentExpenditureByEntities >> select sum(gld.amount) from CGeneralLedger gl, CGeneralLedgerDetail gld, CVoucherHeader vh  WHERE gl.voucherHeaderId= vh and gl.id = gld.generalLedgerId.id and  gld.detailTypeId.id  in ( :detailTypeId ) and gld.detailKeyId   in ( :entityIdList ) and gl.debitAmount>0 and vh.status!=4 and vh.name = 'Direct Bank Payment'");
        }
        Query expenditureQuery = this.persistenceService.getSession().createQuery("select sum(gld.amount) from CGeneralLedger gl, CGeneralLedgerDetail gld, CVoucherHeader vh  WHERE gl.voucherHeaderId= vh and gl.id = gld.generalLedgerId.id and  gld.detailTypeId.id  in ( :detailTypeId ) and gld.detailKeyId   in ( :entityIdList ) and gl.debitAmount>0 and vh.status!=4 and vh.name = 'Direct Bank Payment'");
        expenditureQuery.setInteger("detailTypeId", detailTypeId.intValue());
        expenditureQuery.setParameterList("entityIdList", entityIdList);
        List result = expenditureQuery.list();
        if (result != null) {
            dbpSum = this.getBigDecimalValue(result.get(0));
        }
        return dbpSum;
    }

    private BigDecimal getBigDecimalValue(Object object) {
        return object != null ? new BigDecimal(object.toString()) : BigDecimal.ZERO;
    }
}

