/*
 * Decompiled with CFR 0.152.
 */
package org.egov.dao.voucher;

import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.CGeneralLedger;
import org.egov.commons.CGeneralLedgerDetail;
import org.egov.commons.CVoucherHeader;
import org.egov.commons.utils.EntityType;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infstr.services.PersistenceService;
import org.egov.utils.Constants;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class VoucherHibernateDAO
extends PersistenceService<CVoucherHeader, Long> {
    private static final Logger LOGGER = Logger.getLogger(VoucherHibernateDAO.class);
    @Autowired
    private AppConfigValueService appConfigValuesService;
    private PersistenceService persistenceService;

    public VoucherHibernateDAO() {
        super(CVoucherHeader.class);
    }

    public VoucherHibernateDAO(Class<CVoucherHeader> type) {
        super(type);
    }

    public List<CVoucherHeader> getVoucherList(CVoucherHeader voucherHeader, Map<String, Object> searchFilterMap) throws ApplicationException, ParseException {
        StringBuffer sql = new StringBuffer(500);
        sql.append(" and vh.type='Journal Voucher' ");
        sql.append(" and vh.isConfirmed != 1 ");
        if (null != voucherHeader.getVoucherNumber() && StringUtils.isNotEmpty((String)voucherHeader.getVoucherNumber())) {
            sql.append(" and vh.voucherNumber like '%").append(voucherHeader.getVoucherNumber()).append("%'");
        }
        if (null != searchFilterMap.get("voucherDateFrom") && StringUtils.isNotEmpty((String)searchFilterMap.get("voucherDateFrom").toString())) {
            sql.append(" and vh.voucherDate>='").append(Constants.DDMMYYYYFORMAT1.format(Constants.DDMMYYYYFORMAT2.parse(searchFilterMap.get("voucherDateFrom").toString()))).append("'");
        }
        if (null != searchFilterMap.get("voucherDateTo") && StringUtils.isNotEmpty((String)searchFilterMap.get("voucherDateTo").toString())) {
            sql.append(" and vh.voucherDate<='").append(Constants.DDMMYYYYFORMAT1.format(Constants.DDMMYYYYFORMAT2.parse(searchFilterMap.get("voucherDateTo").toString()))).append("'");
        }
        if (null != voucherHeader.getFundId()) {
            sql.append(" and vh.fundId=").append(voucherHeader.getFundId().getId());
        }
        if (null != voucherHeader.getVouchermis().getFundsource()) {
            sql.append(" and vh.fundsourceId=").append(voucherHeader.getVouchermis().getFundsource().getId());
        }
        if (null != voucherHeader.getVouchermis().getDepartmentid()) {
            sql.append(" and vh.vouchermis.departmentid=").append(voucherHeader.getVouchermis().getDepartmentid().getId());
        }
        if (voucherHeader.getVouchermis().getSchemeid() != null) {
            sql.append(" and vh.vouchermis.schemeid=").append(voucherHeader.getVouchermis().getSchemeid().getId());
        }
        if (null != voucherHeader.getVouchermis().getSubschemeid()) {
            sql.append(" and vh.vouchermis.subschemeid=").append(voucherHeader.getVouchermis().getSubschemeid().getId());
        }
        if (null != voucherHeader.getVouchermis().getFunctionary()) {
            sql.append(" and vh.vouchermis.functionary=").append(voucherHeader.getVouchermis().getFunctionary().getId());
        }
        if (null != voucherHeader.getVouchermis().getDivisionid()) {
            sql.append(" and vh.vouchermis.divisionid=").append(voucherHeader.getVouchermis().getDivisionid().getId());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("sql====================" + sql.toString()));
        }
        List appList = this.appConfigValuesService.getConfigValuesByModuleAndKey("finance", "statusexcludeReport");
        String statusExclude = ((AppConfigValues)appList.get(0)).getValue();
        List list = this.findAllBy(" from CVoucherHeader vh where vh.status not in (" + statusExclude + ") " + sql.toString() + " order by vh.cgn,vh.voucherNumber,vh.voucherDate ", new Object[0]);
        return list;
    }

    public CVoucherHeader getVoucherHeaderById(Long voucherId) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"VoucherHibernateDAO | getVoucherHeaderById | Start ");
        }
        List vhList = this.getSession().createCriteria(CVoucherHeader.class).add((Criterion)Restrictions.eq((String)"id", (Object)voucherId)).list();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("numer of voucher with voucherheaderid " + voucherId + "=" + vhList.size()));
        }
        return (CVoucherHeader)vhList.get(0);
    }

    public List<CGeneralLedger> getGLInfo(Long voucherId) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"VoucherHibernateDAO | getGLInfo | Start ");
        }
        return this.getSession().createCriteria(CGeneralLedger.class).createCriteria("voucherHeaderId").add((Criterion)Restrictions.eq((String)"id", (Object)voucherId)).list();
    }

    public List<CGeneralLedgerDetail> getGeneralledgerdetail(Long gledgerId) {
        Criteria criteria = this.getSession().createCriteria(CGeneralLedgerDetail.class);
        criteria.add((Criterion)Restrictions.eq((String)"generalLedgerId.id", (Object)gledgerId));
        return criteria.list();
    }

    public Accountdetailtype getAccountDetailById(Integer accDetailTypeId) {
        Criteria criteria = this.getSession().createCriteria(Accountdetailtype.class);
        criteria.add((Criterion)Restrictions.eq((String)"id", (Object)accDetailTypeId));
        return (Accountdetailtype)criteria.list().get(0);
    }

    public EntityType getEntityInfo(Integer detailKeyId, Integer detailtypeId) throws ValidationException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"VoucherHibernateDAO | getDetailCodeName | start");
        }
        EntityType entity = null;
        try {
            Accountdetailtype accountdetailtype = this.getAccountDetailById(detailtypeId);
            Class<?> service = Class.forName(accountdetailtype.getFullQualifiedName());
            String detailTypeName = service.getSimpleName();
            String dataType = "";
            Method method = service.getMethod("getId", new Class[0]);
            dataType = method.getReturnType().getSimpleName();
            entity = dataType.equals("Long") ? (EntityType)this.persistenceService.find("from " + detailTypeName + " where id=? order by name", new Object[]{detailKeyId.longValue()}) : (EntityType)this.persistenceService.find("from " + detailTypeName + " where id=? order by name", new Object[]{detailKeyId});
        }
        catch (Exception e) {
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", e.getMessage()));
            throw new ValidationException(errors);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"VoucherHibernateDAO | getDetailCodeName | End");
        }
        return entity;
    }

    @Transactional
    public void deleteGLDetailByVHId(Object voucherHeaderId) {
        try {
            List<CGeneralLedger> glList = this.getGLInfo(Long.parseLong(voucherHeaderId.toString()));
            for (CGeneralLedger generalLedger : glList) {
                List glDetailList = this.getSession().createCriteria(CGeneralLedgerDetail.class).add((Criterion)Restrictions.eq((String)"generalLedgerId.id", (Object)generalLedger.getId())).list();
                for (CGeneralLedgerDetail generalLedgerDetail : glDetailList) {
                    Query qry = this.getSession().createQuery("delete from EgRemittanceGldtl where generalledgerdetail.id=:gldetailId");
                    qry.setInteger("gldetailId", Integer.valueOf(generalLedgerDetail.getId().toString()).intValue());
                    qry.executeUpdate();
                }
            }
        }
        catch (HibernateException e) {
            throw new HibernateException("exception in voucherHibDao while deleting from general ledger" + (Object)((Object)e));
        }
        catch (ApplicationRuntimeException e) {
            throw new ApplicationRuntimeException("exception in voucherHibDao while deleting from general ledger" + (Object)((Object)e));
        }
    }

    public PersistenceService getPersistenceService() {
        return this.persistenceService;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }
}

