/*
 * Decompiled with CFR 0.152.
 */
package org.egov.dao.recoveries;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.log4j.Logger;
import org.egov.commons.EgPartytype;
import org.egov.commons.EgwTypeOfWork;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.recoveries.Recovery;
import org.hibernate.LockMode;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional(readOnly=true)
public class TdsHibernateDAO {
    @PersistenceContext
    private EntityManager entityManager;
    private final Logger LOGGER = Logger.getLogger(TdsHibernateDAO.class);
    public static final SimpleDateFormat DDMMYYYYFORMAT1 = new SimpleDateFormat("dd-MMM-yyyy", new Locale("en", "IN"));
    private Session session;
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService<Recovery, Integer> persistenceService;

    @Transactional
    public Recovery update(Recovery entity) {
        this.getCurrentSession().update((Object)entity);
        return entity;
    }

    @Transactional
    public Recovery create(Recovery entity) {
        this.getCurrentSession().persist((Object)entity);
        return entity;
    }

    @Transactional
    public void delete(Recovery entity) {
        this.getCurrentSession().delete((Object)entity);
    }

    public Recovery findById(Number id, boolean lock) {
        return (Recovery)((Object)this.getCurrentSession().load(Recovery.class, (Serializable)id));
    }

    public List<Recovery> findAll() {
        return this.getCurrentSession().createCriteria(Recovery.class).list();
    }

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public Recovery findById(Long id, boolean lock) {
        this.session = this.getCurrentSession();
        Recovery recovery = lock ? (Recovery)((Object)this.session.load(Recovery.class, (Serializable)id, LockMode.UPGRADE)) : (Recovery)((Object)this.session.load(Recovery.class, (Serializable)id));
        return recovery;
    }

    public List findByEstDate(String estimateDate) {
        this.session = this.getCurrentSession();
        Query qry = this.session.createQuery("from Recovery tds where tds.isactive=true and tds.effectivefrom<=:estimateDate order by upper(type)");
        qry.setString("estimateDate", estimateDate);
        return qry.list();
    }

    public Recovery getTdsByType(String type) {
        this.session = this.getCurrentSession();
        Query qry = this.session.createQuery("from Recovery tds where upper(tds.type) =:type");
        qry.setString("type", type.toUpperCase().trim());
        return (Recovery)((Object)qry.uniqueResult());
    }

    public List getAllTds() {
        this.session = this.getCurrentSession();
        Query qry = this.session.createQuery("from Recovery order by upper(type)");
        return qry.list();
    }

    public List<Recovery> getAllActiveAutoRemitTds() {
        this.session = this.getCurrentSession();
        Query qry = this.session.createQuery("from Recovery where isactive=true and remittanceMode='A'   order by upper(type)");
        return qry.list();
    }

    public List<Recovery> getAllActiveTds() {
        this.session = this.getCurrentSession();
        Query qry = this.session.createQuery("from Recovery where isactive=true and isEarning is null or isEarning='0' order by upper(type)");
        return qry.list();
    }

    public List<Recovery> getActiveTdsFilterBy(String estimateDate, BigDecimal estCost, EgPartytype egPartytype, EgwTypeOfWork egwTypeOfWork, EgwTypeOfWork egwSubTypeOfWork) {
        this.session = this.getCurrentSession();
        StringBuffer qryStr = new StringBuffer();
        List tdsList = null;
        qryStr.append("from Recovery tds where tds.isactive=true ");
        Query qry = this.session.createQuery(qryStr.toString());
        if (egPartytype != null) {
            qryStr.append(" and tds.egPartytype=:egPartytype");
            qry = this.session.createQuery(qryStr.toString());
        }
        if (estCost != null) {
            qryStr.append(" and tds.id in (select ed.recovery.id from EgDeductionDetails ed where (ed.lowlimit<=:estCost and ed.highlimit>=:estCost and ed.highlimit is not null) or (ed.lowlimit<=:estCost and ed.highlimit is null)) ");
            qry = this.session.createQuery(qryStr.toString());
        }
        if (estimateDate != null && !estimateDate.equals("")) {
            qryStr.append(" and tds.id in (select ed.recovery.id from EgDeductionDetails ed where (ed.datefrom<=:estimateDate and ed.dateto>=:estimateDate and ed.dateto is not null) or(ed.datefrom<=:estimateDate and ed.dateto is null))");
            qry = this.session.createQuery(qryStr.toString());
        }
        if (egwTypeOfWork != null) {
            qryStr.append(" and tds.id in (select ed.recovery.id from EgDeductionDetails ed where ed.workDocType =:egwTypeOfWork)");
            qry = this.session.createQuery(qryStr.toString());
        }
        if (egwSubTypeOfWork != null) {
            qryStr.append("  and tds.id in (select ed.recovery.id from EgDeductionDetails ed where ed.workDocSubType =:egwSubTypeOfWork)");
            qry = this.session.createQuery(qryStr.toString());
        }
        qryStr.append(" order by upper(type)");
        qry = this.session.createQuery(qryStr.toString());
        if (estimateDate != null && !estimateDate.equals("")) {
            qry.setString("estimateDate", estimateDate);
        }
        if (estCost != null) {
            qry.setBigDecimal("estCost", estCost);
        }
        if (egPartytype != null) {
            qry.setEntity("egPartytype", (Object)egPartytype);
        }
        if (egwTypeOfWork != null) {
            qry.setEntity("egwTypeOfWork", (Object)egwTypeOfWork);
        }
        if (egwSubTypeOfWork != null) {
            qry.setEntity("egwSubTypeOfWork", (Object)egwSubTypeOfWork);
        }
        tdsList = qry.list();
        return tdsList;
    }

    public List<Recovery> getAllTdsByPartyType(String partyType) {
        this.session = this.getCurrentSession();
        Query qry = this.session.createQuery("from Recovery tds where upper(tds.egPartytype.code) =:partyType");
        qry.setString("partyType", partyType.toUpperCase().trim());
        List tdses = qry.list();
        return tdses;
    }

    public List<Recovery> recoveryForPartyContractor(Date asOndate) throws ValidationException {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)"EgovCommon | recoveryForPartyContractor | Start ");
        }
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)("asONDate value received : " + asOndate));
        }
        StringBuffer recoveryQuery = new StringBuffer(400);
        recoveryQuery.append("From Recovery where egPartytype.id in ( select id from EgPartytype where code=?) and isactive=true");
        if (null != asOndate) {
            recoveryQuery.append(" and id in (select recovery.id from EgDeductionDetails where datefrom <= '").append(DDMMYYYYFORMAT1.format(asOndate)).append("' AND dateto >='").append(DDMMYYYYFORMAT1.format(asOndate)).append("')");
        }
        List listTds = this.persistenceService.findAllBy(recoveryQuery.toString(), new Object[]{"Contractor"});
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)("The size of recovery for party type Contractor is :" + listTds.size()));
        }
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)"EgovCommon | recoveryForPartyContractor | End ");
        }
        return listTds;
    }

    public EgPartytype getPartytypeByCode(String code) {
        this.session = this.getCurrentSession();
        Query qry = this.session.createQuery("from EgPartytype where code=:code");
        qry.setString("code", code.trim());
        return (EgPartytype)qry.uniqueResult();
    }

    public EgwTypeOfWork getTypeOfWorkByCode(String code) {
        this.session = this.getCurrentSession();
        Query qry = this.session.createQuery("from EgwTypeOfWork where code=:code");
        qry.setString("code", code.trim());
        return (EgwTypeOfWork)qry.uniqueResult();
    }

    public EgPartytype getSubPartytypeByCode(String code) {
        this.session = this.getCurrentSession();
        Query qry = this.session.createQuery("from EgPartytype where code=:code and parentid is not null");
        qry.setString("code", code.trim());
        return (EgPartytype)qry.uniqueResult();
    }

    public Recovery getTdsByTypeAndPartyType(String type, EgPartytype egPartytype) {
        this.session = this.getCurrentSession();
        Query qry = this.session.createQuery("from Recovery tds where upper(tds.type) =:type and tds.egPartytype =:egPartytype");
        qry.setString("type", type.toUpperCase().trim());
        qry.setEntity("egPartytype", (Object)egPartytype);
        return (Recovery)((Object)qry.uniqueResult());
    }

    public Recovery findActiveTdsByGlcodeId(Long glcodeId) {
        return (Recovery)((Object)this.getCurrentSession().createQuery("from Recovery tds where tds.isactive=true and chartofaccounts.id=" + glcodeId).uniqueResult());
    }
}

