/*
 * Decompiled with CFR 0.152.
 */
package org.egov.billsaccounting.services;

import com.exilant.GLEngine.ChartOfAccounts;
import com.exilant.GLEngine.Transaxtion;
import com.exilant.GLEngine.TransaxtionParameter;
import com.exilant.eGov.src.transactions.VoucherTypeForULB;
import com.exilant.exility.common.TaskFailedException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.egov.billsaccounting.services.VoucherConstant;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.Bankaccount;
import org.egov.commons.Bankreconciliation;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.CFiscalPeriod;
import org.egov.commons.CFunction;
import org.egov.commons.CGeneralLedger;
import org.egov.commons.CGeneralLedgerDetail;
import org.egov.commons.CVoucherHeader;
import org.egov.commons.Functionary;
import org.egov.commons.Fund;
import org.egov.commons.Fundsource;
import org.egov.commons.Scheme;
import org.egov.commons.SubScheme;
import org.egov.commons.Vouchermis;
import org.egov.commons.dao.AccountdetailtypeHibernateDAO;
import org.egov.commons.dao.BankHibernateDAO;
import org.egov.commons.dao.BankaccountHibernateDAO;
import org.egov.commons.dao.ChartOfAccountsHibernateDAO;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.commons.dao.FiscalPeriodHibernateDAO;
import org.egov.commons.dao.FunctionDAO;
import org.egov.commons.dao.FunctionaryHibernateDAO;
import org.egov.commons.dao.FundHibernateDAO;
import org.egov.commons.dao.FundSourceHibernateDAO;
import org.egov.commons.dao.SchemeHibernateDAO;
import org.egov.commons.dao.SubSchemeHibernateDAO;
import org.egov.commons.dao.VoucherHeaderDAO;
import org.egov.commons.exception.NoSuchObjectException;
import org.egov.commons.exception.TooManyValuesException;
import org.egov.dao.bills.EgBillRegisterHibernateDAO;
import org.egov.egf.autonumber.VouchernumberGenerator;
import org.egov.eis.service.EisCommonService;
import org.egov.infra.admin.master.entity.AppConfig;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.entity.HierarchyType;
import org.egov.infra.admin.master.service.AppConfigService;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.admin.master.service.HierarchyTypeService;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.utils.ApplicationSequenceNumberGenerator;
import org.egov.infra.utils.autonumber.AutonumberServiceBeanResolver;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infstr.services.PersistenceService;
import org.egov.infstr.utils.EGovConfig;
import org.egov.model.bills.EgBillPayeedetails;
import org.egov.model.bills.EgBilldetails;
import org.egov.model.bills.EgBillregister;
import org.egov.model.bills.EgBillregistermis;
import org.egov.model.contra.ContraJournalVoucher;
import org.egov.model.voucher.PreApprovedVoucher;
import org.egov.pims.commons.Designation;
import org.egov.pims.commons.Position;
import org.egov.pims.dao.PersonalInformationDAO;
import org.egov.services.bills.BillsService;
import org.egov.services.voucher.GeneralLedgerDetailService;
import org.egov.services.voucher.GeneralLedgerService;
import org.egov.services.voucher.VoucherService;
import org.egov.utils.FinancialConstants;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CreateVoucher {
    private static final String DD_MMM_YYYY = "dd-MMM-yyyy";
    private static final String DD_MM_YYYY = "dd/MM/yyyy";
    private static final String REVERSAL_VOUCHER_DATE = "Reversal voucher date";
    private static final String VOUCHER_HEADER_ID = "Original voucher header id";
    private static final Logger LOGGER = Logger.getLogger(CreateVoucher.class);
    private static final String CONBILL = "Works";
    private static final String SUPBILL = "Purchase";
    private static final String SALBILL = "Salary";
    private static final String PENSBILL = "Pension";
    private static final String GRATBILL = "Gratuity";
    private static final String FUNDMISSINGMSG = "Fund is not used in Bill ,cannot create Voucher";
    private static final String FAILED = "Transaction failed";
    private static final String EXCEPTION_WHILE_SAVING_DATA = "Exception while saving data";
    private final String ISREQUIRED = ".required";
    private final String SELECT = "  Please Select  ";
    @Autowired
    private AppConfigService appConfigService;
    @Autowired
    private VoucherTypeForULB voucherTypeForULB;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    private AutonumberServiceBeanResolver beanResolver;
    private SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
    private SimpleDateFormat formatter = new SimpleDateFormat("dd-MMM-yyyy");
    @Autowired
    private BillsService billsService;
    @Autowired
    private FundHibernateDAO fundDAO;
    @Autowired
    private ChartOfAccounts chartOfAccounts;
    @Autowired
    private FunctionaryHibernateDAO functionaryDAO;
    @Autowired
    private FinancialYearDAO financialYearDAO;
    @Autowired
    private SchemeHibernateDAO schemeDAO;
    @Autowired
    private SubSchemeHibernateDAO subSchemeDAO;
    @Autowired
    private FundSourceHibernateDAO fundSourceDAO;
    @Autowired
    private FunctionDAO functionDAO;
    @Autowired
    private ChartOfAccountsHibernateDAO chartOfAccountsDAO;
    @Autowired
    private VoucherHeaderDAO voucherHeaderDAO;
    @Autowired
    private BankaccountHibernateDAO bankAccountDAO;
    @Autowired
    private BankHibernateDAO bankDAO;
    @Autowired
    private EgBillRegisterHibernateDAO egBillRegisterHibernateDAO;
    @Autowired
    @Qualifier(value="voucherService")
    private VoucherService voucherService;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private ApplicationSequenceNumberGenerator applicationSequenceNumberGenerator;
    private static final String ERR = "Exception in CreateVoucher";
    private static final String DEPTMISSINGMSG = "Department is missing in the Bill cannot proceed creating vouvher";
    private static final String IS_MISSING = "is missing";
    private static final String NAME = "Reversal voucher name";
    private static final String IS_EMPTY = "is empty";
    private static final String TYPE = "Reversal voucher type";
    private static final String REVERSAL_VOUCHER_NUMBER = "Reversal voucher number";
    @Autowired
    private DepartmentService deptM;
    @Autowired
    private BoundaryService boundary;
    @Autowired
    private UserService userMngr;
    @Autowired
    private EisCommonService eisCommonService;
    @Autowired
    private HierarchyTypeService hierarchyTypeService;
    PersistenceService<Bankreconciliation, Integer> bankReconSer;
    PersistenceService<EgBillregistermis, Integer> billMisSer;
    PersistenceService<EgBilldetails, Integer> billDetailSer;
    PersistenceService<Fund, Integer> fundService;
    @Autowired
    @Qualifier(value="generalLedgerService")
    private GeneralLedgerService generalLedgerService;
    @Autowired
    @Qualifier(value="generalLedgerDetailService")
    private GeneralLedgerDetailService generalLedgerDetailService;
    @Autowired
    private PersonalInformationDAO personalInformationDAO;
    @Autowired
    private AccountdetailtypeHibernateDAO accountdetailtypeHibernateDAO;
    @Autowired
    private FiscalPeriodHibernateDAO fiscalPeriodHibernateDAO;

    public CreateVoucher() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Initializing CreateVoucher Service");
        }
    }

    public long createVoucherFromBill(int billId, String voucherStatus, String voucherNumber, Date voucherDate) throws ApplicationRuntimeException, SQLException, TaskFailedException {
        CVoucherHeader vh = null;
        try {
            Date vdt;
            List configValues;
            if (voucherStatus == null) {
                List vStatusList = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "PREAPPROVEDVOUCHERSTATUS");
                if (!vStatusList.isEmpty() && vStatusList.size() == 1) {
                    AppConfigValues appVal = (AppConfigValues)vStatusList.get(0);
                    voucherStatus = appVal.getValue();
                } else {
                    throw new ApplicationRuntimeException("PREAPPROVEDVOUCHERSTATUSis not defined in AppConfig values cannot proceed creating voucher");
                }
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)" ---------------Generating Voucher for Bill-------");
            }
            EgBillregister egBillregister = null;
            egBillregister = this.billsService.getBillRegisterById(billId);
            EgBillregistermis billMis = egBillregister.getEgBillregistermis();
            try {
                CVoucherHeader result;
                if (billMis.getVoucherHeader() != null && (result = (CVoucherHeader)this.voucherService.find("select vh from CVoucherHeader vh where vh.id = ? and vh.status!=?", new Object[]{billMis.getVoucherHeader().getId(), FinancialConstants.CANCELLEDVOUCHERSTATUS})) != null) {
                    throw new ApplicationRuntimeException("Voucher " + result.getVoucherNumber() + " already exists for this bill ");
                }
            }
            catch (Exception e) {
                throw new ApplicationRuntimeException(e.getMessage());
            }
            Fund fund = billMis.getFund();
            if (fund == null) {
                LOGGER.error((Object)FUNDMISSINGMSG);
                throw new ApplicationRuntimeException(FUNDMISSINGMSG);
            }
            fund.getId();
            String deptMandatory = EGovConfig.getProperty((String)"egf_config.xml", (String)"deptRequired", (String)"", (String)"general");
            if (deptMandatory.equalsIgnoreCase("Y") && billMis.getEgDepartment() == null) {
                throw new ApplicationRuntimeException(DEPTMISSINGMSG);
            }
            Fundsource fundSrc = billMis.getFundsource();
            if (fundSrc != null) {
                Integer.valueOf(fundSrc.getId().toString());
            }
            if (billMis.getScheme() != null) {
                billMis.getScheme().getId();
            }
            if (billMis.getSubScheme() != null) {
                billMis.getSubScheme().getId();
            }
            String expType = egBillregister.getExpendituretype();
            String voucherType = null;
            String voucherSubType = null;
            String name = "";
            if (expType.equalsIgnoreCase(CONBILL)) {
                name = "Contractor Journal";
                voucherSubType = "Contractor Journal";
            } else if (expType.equalsIgnoreCase(SUPBILL)) {
                name = "Supplier Journal";
                voucherSubType = null != billMis.getEgBillSubType() && billMis.getEgBillSubType().getName().equalsIgnoreCase("Fixed Asset") ? "Fixedasset Journal" : "Purchase Journal";
            } else if (expType.equalsIgnoreCase(SALBILL)) {
                name = "Salary Journal";
                voucherSubType = "Salary Journal";
            } else if (expType.equalsIgnoreCase("Expense")) {
                name = "Expense Journal";
                voucherSubType = "Expense Journal";
            } else if (expType.equalsIgnoreCase(PENSBILL)) {
                name = "Pension Journal";
                voucherSubType = "Pension Journal";
            } else if (expType.equalsIgnoreCase(GRATBILL)) {
                name = "Gratuity Journal";
                voucherSubType = FinancialConstants.CBILL_VOUCHERNO_TYPE;
            } else {
                name = "JVGeneral";
                voucherSubType = "Journal Voucher";
            }
            voucherType = "Journal Voucher";
            HashMap<String, Object> headerDetails = new HashMap<String, Object>();
            HashMap<String, Object> detailMap = null;
            HashMap<String, Object> subledgertDetailMap = null;
            ArrayList<HashMap<String, Object>> accountdetails = new ArrayList<HashMap<String, Object>>();
            ArrayList<HashMap<String, Object>> subledgerDetails = new ArrayList<HashMap<String, Object>>();
            Set<EgBilldetails> billDetailslist = egBillregister.getEgBilldetailes();
            detailMap = new HashMap<String, Object>();
            new HashMap();
            headerDetails.put("vouchername", name);
            headerDetails.put("vouchertype", voucherType);
            headerDetails.put("vouchersubtype", voucherSubType);
            new SimpleDateFormat(DD_MMM_YYYY);
            headerDetails.put("vouchernumber", voucherNumber == null ? "" : voucherNumber);
            Date dt = new Date();
            String purposeValueVN = "";
            String purposeValue = "";
            try {
                configValues = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "VOUCHERDATE_FROM_UI");
                for (AppConfigValues appConfigVal : configValues) {
                    purposeValueVN = appConfigVal.getValue();
                }
            }
            catch (Exception e) {
                throw new ApplicationRuntimeException("Appconfig value for VOUCHERDATE_FROM_UI is not defined in the system");
            }
            if (purposeValueVN.equals("Y")) {
                if (voucherDate == null) {
                    throw new ValidationException(Arrays.asList(new ValidationError("Voucherdate Should be entered by user", "voucherfrombill.voucherdate.mandatory")));
                }
                vdt = dt = voucherDate;
            } else {
                try {
                    configValues = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "USE BILLDATE IN CREATE VOUCHER FROM BILL");
                    for (AppConfigValues appConfigVal : configValues) {
                        purposeValueVN = appConfigVal.getValue();
                    }
                }
                catch (Exception e) {
                    throw new ApplicationRuntimeException("Appconfig value for USE BILLDATE IN CREATE VOUCHER FROM BILL is not defined in the system");
                }
                if ("".equals("Y")) {
                    vdt = egBillregister.getBilldate();
                    dt = egBillregister.getBilldate();
                } else {
                    vdt = dt;
                }
            }
            headerDetails.put("voucherdate", vdt);
            if (egBillregister.getId() != null) {
                headerDetails.put("billid", egBillregister.getId());
            }
            if (billMis.getSourcePath() != null) {
                headerDetails.put("sourcepath", billMis.getSourcePath());
            }
            if (billMis.getEgDepartment() != null) {
                headerDetails.put("departmentcode", billMis.getEgDepartment().getCode());
            }
            if (billMis.getFund() != null) {
                headerDetails.put("fundcode", billMis.getFund().getCode());
            }
            if (billMis.getScheme() != null) {
                headerDetails.put("schemecode", billMis.getScheme().getCode());
            }
            if (billMis.getSubScheme() != null) {
                headerDetails.put("subschemecode", billMis.getSubScheme().getCode());
            }
            if (billMis.getFundsource() != null) {
                headerDetails.put("fundsourcecode", billMis.getFundsource().getCode());
            }
            if (billMis.getFieldid() != null && billMis.getFieldid().getId() != null) {
                headerDetails.put("divisionid", billMis.getFieldid().getId().toString());
            }
            if (billMis.getFunctionaryid() != null) {
                headerDetails.put("functionarycode", billMis.getFunctionaryid().getCode());
            }
            if (billMis.getFunction() != null) {
                headerDetails.put("functioncode", billMis.getFunction().getCode());
            }
            for (EgBilldetails egBilldetails : billDetailslist) {
                detailMap = new HashMap();
                if (null != egBilldetails.getFunctionid()) {
                    // empty if block
                }
                detailMap.put("debitamount", egBilldetails.getDebitamount() == null ? BigDecimal.ZERO : egBilldetails.getDebitamount());
                detailMap.put("creditamount", egBilldetails.getCreditamount() == null ? BigDecimal.ZERO : egBilldetails.getCreditamount());
                String glcode = this.persistenceService.getSession().createQuery("select glcode from CChartOfAccounts where id = " + egBilldetails.getGlcodeid().longValue()).list().get(0).toString();
                detailMap.put("glcode", glcode);
                accountdetails.add(detailMap);
                Set<EgBillPayeedetails> subLedgerlist = egBilldetails.getEgBillPaydetailes();
                for (EgBillPayeedetails egBillPayeedetails : subLedgerlist) {
                    subledgertDetailMap = new HashMap<String, Object>();
                    subledgertDetailMap.put("debitamount", egBillPayeedetails.getDebitAmount() == null ? BigDecimal.ZERO : egBillPayeedetails.getDebitAmount());
                    subledgertDetailMap.put("creditamount", egBillPayeedetails.getCreditAmount() == null ? BigDecimal.ZERO : egBillPayeedetails.getCreditAmount());
                    subledgertDetailMap.put("detailtypeid", egBillPayeedetails.getAccountDetailTypeId());
                    subledgertDetailMap.put("detailkeyid", egBillPayeedetails.getAccountDetailKeyId());
                    subledgertDetailMap.put("glcode", glcode);
                    subledgerDetails.add(subledgertDetailMap);
                }
            }
            vh = this.createPreApprovedVoucher(headerDetails, accountdetails, subledgerDetails);
            egBillregister.getEgBillregistermis().setVoucherHeader(vh);
        }
        catch (ValidationException e) {
            LOGGER.error((Object)e.getErrors());
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", ((ValidationError)e.getErrors().get(0)).getMessage()));
            throw new ValidationException(errors);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error in create voucher from bill" + e.getMessage()));
            throw new ApplicationRuntimeException(e.getMessage());
        }
        return vh.getId();
    }

    public long createVoucherFromBillForPJV(int billId, String voucherStatus, List<PreApprovedVoucher> voucherdetailList, List<PreApprovedVoucher> subLedgerList) throws ApplicationRuntimeException, SQLException, TaskFailedException {
        Object vh = null;
        try {
            String expType;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)" ---------------Generating Voucher-------");
            }
            EgBillregister egBillregister = null;
            egBillregister = this.billsService.getBillRegisterById(billId);
            String name = "";
            EgBillregistermis billMis = egBillregister.getEgBillregistermis();
            Fund fund = billMis.getFund();
            if (fund == null) {
                LOGGER.error((Object)FUNDMISSINGMSG);
                throw new ApplicationRuntimeException(FUNDMISSINGMSG);
            }
            fund.getId();
            String deptMandatory = EGovConfig.getProperty((String)"egf_config.xml", (String)"deptRequired", (String)"", (String)"general");
            if (deptMandatory.equalsIgnoreCase("Y") && billMis.getEgDepartment() == null) {
                throw new ApplicationRuntimeException(DEPTMISSINGMSG);
            }
            Fundsource fundSrc = billMis.getFundsource();
            if (fundSrc != null) {
                Integer.valueOf(fundSrc.getId().toString());
            }
            if (billMis.getScheme() != null) {
                billMis.getScheme().getId();
            }
            if (billMis.getSubScheme() != null) {
                billMis.getSubScheme().getId();
            }
            name = (expType = egBillregister.getExpendituretype()).equalsIgnoreCase(CONBILL) ? "Contractor Journal" : (expType.equalsIgnoreCase(SUPBILL) ? "Supplier Journal" : (expType.equalsIgnoreCase(SALBILL) ? "Salary Journal" : (expType.equalsIgnoreCase("Expense") ? "Expense Journal" : (expType.equalsIgnoreCase(PENSBILL) ? "Pension Journal" : (expType.equalsIgnoreCase(GRATBILL) ? "Gratuity Journal" : "JVGeneral")))));
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error in createVoucherFromBillForPJV " + e.getMessage()));
            throw new ApplicationRuntimeException(e.getMessage());
        }
        return vh.getId();
    }

    public void createVoucherFromPreApprovedVoucher(long vouhcerheaderid, String status) throws ApplicationRuntimeException {
        try {
            CVoucherHeader vh = this.voucherHeaderDAO.findById((Number)vouhcerheaderid, false);
            vh.setStatus(Integer.valueOf(status));
            this.voucherHeaderDAO.update(vh);
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage());
            throw new ApplicationRuntimeException(e.getMessage());
        }
    }

    @Transactional
    public CVoucherHeader createPreApprovedVoucher(HashMap<String, Object> headerdetails, List<HashMap<String, Object>> accountcodedetails, List<HashMap<String, Object>> subledgerdetails) throws ApplicationRuntimeException, ValidationException {
        CVoucherHeader vh;
        AppConfig appConfig = this.appConfigService.getAppConfigByKeyName("PREAPPROVEDVOUCHERSTATUS");
        if (null != appConfig && null != appConfig.getConfValues()) {
            for (AppConfigValues appConfigVal : appConfig.getConfValues()) {
                headerdetails.put("status", Integer.valueOf(appConfigVal.getValue()));
            }
        } else {
            throw new ApplicationRuntimeException("Appconfig value for PREAPPROVEDVOUCHERSTATUS is not defined in the system");
        }
        try {
            vh = this.createVoucher(headerdetails, accountcodedetails, subledgerdetails);
        }
        catch (ValidationException ve) {
            LOGGER.error((Object)ERR, (Throwable)ve);
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", ((ValidationError)ve.getErrors().get(0)).getMessage()));
            throw new ValidationException(errors);
        }
        catch (Exception e) {
            LOGGER.error((Object)ERR, (Throwable)e);
            throw new ApplicationRuntimeException(e.getMessage());
        }
        return vh;
    }

    public void startWorkflow(CVoucherHeader voucherheader) throws ValidationException {
        try {
            ClassPathXmlApplicationContext applicationContext = new ClassPathXmlApplicationContext(new String[]{"classpath:org/serviceconfig-Bean.xml", "classpath:org/egov/infstr/beanfactory/globalApplicationContext.xml", "classpath:org/egov/infstr/beanfactory/applicationContext-egf.xml", "classpath:org/egov/infstr/beanfactory/applicationContext-pims.xml"});
            if (voucherheader.getType().equals("Journal Voucher") || voucherheader.getType().equals("Receipt")) {
                LOGGER.error((Object)("Calling StartWorkflow...in create voucher.....for ......ContraJournalVoucher......" + voucherheader.getType() + " ----" + voucherheader.getName()));
                String billtype = this.egBillRegisterHibernateDAO.getBillTypeforVoucher(voucherheader);
                if (billtype == null) {
                    applicationContext.getBean("voucherWorkflowService");
                    voucherheader.start().withOwner(this.getPosition());
                    VoucherService vs = (VoucherService)((Object)applicationContext.getBean("voucherService"));
                    PersistenceService persistenceService = (PersistenceService)applicationContext.getBean("persistenceService");
                    Position nextPosition = this.getNextPosition(voucherheader, vs, persistenceService, null);
                    voucherheader.transition(true).withStateValue("WORKFLOW INITIATED").withOwner(nextPosition).withComments("WORKFLOW STARTED");
                }
            }
        }
        catch (Exception e) {
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            LOGGER.error((Object)ERR, (Throwable)e);
            errors.add(new ValidationError("Exp in startWorkflow for JV/Receipt voucher=", e.getMessage()));
            throw new ValidationException(errors);
        }
    }

    private Position getNextPosition(CVoucherHeader voucherheader, VoucherService vs, PersistenceService persistenceService, Position position) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Getting next Position for WorkFlow");
        }
        Position nextPosition = null;
        Department department = vs.getTempDepartmentForWfItem(voucherheader, position);
        if (department == null) {
            LOGGER.warn((Object)"Not able to get tempoaray Assignment defaulting to primary asssigment");
            department = vs.getDepartmentForWfItem(voucherheader);
            if (department == null) {
                ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
                errors.add(new ValidationError("Unable to get Temp Department", "Unable to get Temp Department"));
                throw new ValidationException(errors);
            }
        }
        String functionaryName = "";
        String designationName = "";
        designationName = "SECTION MANAGER";
        Boundary boundaryForUser = null;
        if (department.getCode().equalsIgnoreCase("A")) {
            HierarchyType hierarchyTypeByName = this.hierarchyTypeService.getHierarchyTypeByName("ADMINISTRATION");
            List topBoundaries = this.boundaryService.getTopLevelBoundaryByHierarchyType(hierarchyTypeByName);
            if (topBoundaries != null && topBoundaries.size() > 0) {
                boundaryForUser = (Boundary)topBoundaries.get(0);
            }
            functionaryName = "Compilation";
        } else {
            boundaryForUser = vs.getBoundaryForUser(voucherheader);
            functionaryName = "ZONE";
        }
        Designation next_desig = (Designation)persistenceService.find("from Designation  where upper(name)=upper(?)", new Object[]{designationName});
        Functionary functionary = (Functionary)persistenceService.find("from Functionary where upper(name)=upper(?)", new Object[]{functionaryName});
        try {
            this.personalInformationDAO.getEmployeeByFunctionary(department.getId(), next_desig.getId(), boundaryForUser.getId(), functionary.getId());
        }
        catch (TooManyValuesException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("Too Many  Employee Exists", "Too Many  Employee Exists"));
            throw new ValidationException(errors);
        }
        catch (NoSuchObjectException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("No  Employee Exists", "No  Employee Exists"));
            throw new ValidationException(errors);
        }
        if (nextPosition != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Returning next Position for WorkFlow" + nextPosition.getName()));
            }
        } else {
            LOGGER.error((Object)"Could not get next Position for WorkFlow");
        }
        return nextPosition;
    }

    @Deprecated
    public void startWorkflow(ContraJournalVoucher cjv) throws ValidationException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting Contra Journal Voucher Workflow....startWorkflow(ContraJournalVoucher cjv)...");
        }
        try {
            if (cjv.getVoucherHeaderId().getState() == null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Calling StartWorkflow...in create voucher.....for ......ContraJournalVoucher.....................................................................................");
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"fetching voucherWorkflowService from application context.......");
                }
                ClassPathXmlApplicationContext applicationContext = new ClassPathXmlApplicationContext(new String[]{"classpath:org/serviceconfig-Bean.xml", "classpath:org/egov/infstr/beanfactory/globalApplicationContext.xml", "classpath:org/egov/infstr/beanfactory/applicationContext-egf.xml", "classpath:org/egov/infstr/beanfactory/applicationContext-pims.xml"});
                applicationContext.getBean("voucherWorkflowService");
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"completed voucherWorkflowService from application context.......");
                }
                cjv.getVoucherHeaderId().start().withOwner(this.getPosition());
                Position position = this.eisCommonService.getPositionByUserId(ApplicationThreadLocals.getUserId());
                cjv.transition(true).withStateValue("WORKFLOW INITIATED").withOwner(position).withComments("WORKFLOW STARTED");
                VoucherService vs = (VoucherService)((Object)applicationContext.getBean("voucherService"));
                PersistenceService persistenceService = (PersistenceService)applicationContext.getBean("persistenceService");
                Position nextPosition = this.getNextPosition(cjv.getVoucherHeaderId(), vs, persistenceService, null);
                cjv.transition(true).withStateValue("WORKFLOW INITIATED").withOwner(nextPosition).withComments("WORKFLOW STARTED");
            }
        }
        catch (Exception e) {
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            LOGGER.error((Object)ERR, (Throwable)e);
            errors.add(new ValidationError("Exp in startWorkflow for Contra=", e.getMessage()));
            throw new ValidationException(errors);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed Contra Journal Voucher Workflow.......");
        }
    }

    public void startWorkflowForCashUpdate(CVoucherHeader voucherHeader) throws ValidationException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting  Journal Voucher Workflow.  for contra......");
        }
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Calling StartWorkflow...For Cash");
            }
            ClassPathXmlApplicationContext applicationContext = new ClassPathXmlApplicationContext(new String[]{"classpath:org/serviceconfig-Bean.xml", "classpath:org/egov/infstr/beanfactory/globalApplicationContext.xml", "classpath:org/egov/infstr/beanfactory/applicationContext-egf.xml", "classpath:org/egov/infstr/beanfactory/applicationContext-pims.xml"});
            applicationContext.getBean("voucherWorkflowService");
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"completed voucherWorkflowService from application context.......");
            }
            voucherHeader.start().withOwner(this.getPosition());
            VoucherService vs = (VoucherService)((Object)applicationContext.getBean("voucherService"));
            PersistenceService persistenceService = (PersistenceService)applicationContext.getBean("persistenceService");
            Position nextPosition = this.getNextPosition(voucherHeader, vs, persistenceService, null);
            voucherHeader.transition(true).withStateValue("Forwarded").withOwner(nextPosition).withComments("Forwarded");
        }
        catch (Exception e) {
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            LOGGER.error((Object)ERR, (Throwable)e);
            errors.add(new ValidationError("Exp in startWorkflow for Contra=", e.getMessage()));
            throw new ValidationException(errors);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed Contra Journal Voucher Workflow.......");
        }
    }

    public Position getPosition() throws ApplicationRuntimeException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("getPosition====" + ApplicationThreadLocals.getUserId()));
        }
        Position pos = this.eisCommonService.getPositionByUserId(ApplicationThreadLocals.getUserId());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("position===" + pos.getId()));
        }
        return null;
    }

    @Transactional
    public CVoucherHeader createVoucher(HashMap<String, Object> headerdetails, List<HashMap<String, Object>> accountcodedetails, List<HashMap<String, Object>> subledgerdetails) throws ApplicationRuntimeException {
        CVoucherHeader vh;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"start | createVoucher API");
        }
        try {
            SimpleDateFormat formatter;
            this.validateMandateFields(headerdetails);
            this.validateLength(headerdetails);
            this.validateVoucherMIS(headerdetails);
            this.validateTransaction(accountcodedetails, subledgerdetails);
            this.validateFunction(headerdetails, accountcodedetails);
            vh = this.createVoucherHeader(headerdetails);
            Vouchermis mis = this.createVouchermis(headerdetails);
            mis.setVoucherheaderid(vh);
            vh.setVouchermis(mis);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"start | insertIntoVoucherHeader");
            }
            String vdt = this.formatter.format(vh.getVoucherDate());
            String fiscalPeriod = null;
            try {
                fiscalPeriod = this.getFiscalPeriod(vdt);
            }
            catch (TaskFailedException e) {
                throw new ApplicationRuntimeException("error while getting fiscal period");
            }
            if (null == fiscalPeriod) {
                throw new ApplicationRuntimeException("Voucher Date not within an open period or Financial year not open for posting, fiscalPeriod := " + fiscalPeriod);
            }
            vh.setFiscalPeriodId(Integer.valueOf(fiscalPeriod));
            vh.setCgvn(this.getCGVNNumber(vh));
            try {
                if (!this.isUniqueVN(vh.getVoucherNumber(), vdt)) {
                    throw new ValidationException(Arrays.asList(new ValidationError("Duplicate Voucher Number", "Duplicate Voucher Number")));
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)ERR, (Throwable)e);
                throw new ApplicationRuntimeException(e.getMessage());
            }
            this.voucherService.applyAuditing((AbstractAuditable)vh);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("++++++++++++++++++" + vh.toString()));
            }
            this.voucherService.persist(vh);
            if (null != vh.getVouchermis().getSourcePath() && null == vh.getModuleId() && vh.getVouchermis().getSourcePath().length() == vh.getVouchermis().getSourcePath().indexOf("=") + 1) {
                StringBuffer sourcePath = new StringBuffer();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Source Path received : " + vh.getVouchermis().getSourcePath()));
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Voucher Header Id  : " + vh.getId()));
                }
                sourcePath.append(vh.getVouchermis().getSourcePath()).append(vh.getId().toString());
                vh.getVouchermis().setSourcePath(sourcePath.toString());
                this.voucherService.applyAuditing((AbstractAuditable)vh);
                this.voucherService.update(vh);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"End | insertIntoVoucherHeader");
            }
            List<Transaxtion> transactions = this.createTransaction(headerdetails, accountcodedetails, subledgerdetails, vh);
            Transaxtion[] txnList = new Transaxtion[transactions.size()];
            if (!this.chartOfAccounts.postTransaxtions(txnList = transactions.toArray(txnList), (formatter = new SimpleDateFormat(DD_MMM_YYYY)).format(vh.getVoucherDate()))) {
                throw new ApplicationRuntimeException("Voucher creation Failed");
            }
        }
        catch (ValidationException ve) {
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", ((ValidationError)ve.getErrors().get(0)).getMessage()));
            throw new ValidationException(errors);
        }
        catch (Exception e) {
            LOGGER.error((Object)ERR, (Throwable)e);
            throw new ApplicationRuntimeException(e.getMessage());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"End | createVoucher API");
        }
        return vh;
    }

    private void validateFunction(HashMap<String, Object> headerdetails, List<HashMap<String, Object>> accountcodedetails) {
        List appConfigValues = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "ifRestrictedToOneFunctionCenter");
        if (appConfigValues == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"app config ifRestrictedToOneFunctionCenter is not defined");
            }
            throw new ValidationException("Error", "Use Single Function For a transaction is not defined", new String[0]);
        }
        if (((AppConfigValues)appConfigValues.get(0)).getValue().equalsIgnoreCase("No")) {
            boolean foundInHeader = false;
            HashMap<String, String> functionMap = new HashMap<String, String>();
            String functionCodeInHeader = "";
            if (null != headerdetails.get("functioncode")) {
                functionCodeInHeader = (String)headerdetails.get("functioncode");
                functionMap.put(functionCodeInHeader, functionCodeInHeader);
                foundInHeader = true;
            }
            if (foundInHeader) {
                for (HashMap<String, Object> accDetailMap : accountcodedetails) {
                    accDetailMap.put("functioncode", headerdetails.get("functioncode"));
                }
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Not a single Function Transaction  No need of Further check on function");
            }
            return;
        }
        if (((AppConfigValues)appConfigValues.get(0)).getValue().equalsIgnoreCase("Yes")) {
            boolean foundInHeader = false;
            boolean atLeastOneMissing = false;
            HashMap<String, String> functionMap = new HashMap<String, String>();
            String functionCodeInHeader = "";
            String functionCodeInDetail = "";
            if (null != headerdetails.get("functioncode")) {
                functionCodeInHeader = (String)headerdetails.get("functioncode");
                functionMap.put(functionCodeInHeader, functionCodeInHeader);
                foundInHeader = true;
            }
            for (HashMap<String, Object> accDetailMap : accountcodedetails) {
                if (null != accDetailMap.get("functioncode") && "" != accDetailMap.get("functioncode")) {
                    functionCodeInDetail = accDetailMap.get("functioncode").toString();
                    functionMap.put(functionCodeInDetail, functionCodeInDetail);
                    continue;
                }
                atLeastOneMissing = true;
            }
            if (functionMap.size() > 1) {
                LOGGER.error((Object)"multiple functions found in Header and details Cannot Continue Transaction....");
                throw new ValidationException(Arrays.asList(new ValidationError("multiple functions found in Header and details", "multiple.functions.found.in.Header.and.details")));
            }
            if (functionMap.isEmpty()) {
                LOGGER.error((Object)"Function not found in Header or details Cannot Continue Transaction....");
                throw new ValidationException(Arrays.asList(new ValidationError("function not found in Header or details", "function.not.found.in.Header.or.details")));
            }
            if (!foundInHeader) {
                headerdetails.put("functioncode", functionCodeInDetail);
            }
            if (atLeastOneMissing) {
                for (HashMap<String, Object> accDetailMap : accountcodedetails) {
                    if (null != accDetailMap.get("functioncode") && "" != accDetailMap.get("functioncode")) continue;
                    accDetailMap.put("functioncode", headerdetails.get("functioncode"));
                }
            }
        }
    }

    private void validateLength(HashMap<String, Object> headerdetails) {
        if (headerdetails.get("description") != null && headerdetails.get("description").toString().length() > 250) {
            throw new ValidationException(Arrays.asList(new ValidationError("voucher.description.exceeds.max.length", "Narration exceeds maximum length")));
        }
        String vNumGenMode = this.voucherTypeForULB.readVoucherTypes(headerdetails.get("vouchertype").toString());
        if (!vNumGenMode.equals("Auto") && headerdetails.get("vouchernumber") != null) {
            int typeLength = Integer.valueOf(FinancialConstants.VOUCHERNO_TYPE_LENGTH);
            int voucherNumberColumnLength = 30;
            boolean fundIdentfierLength = true;
            if (headerdetails.get("vouchernumber").toString().length() > 30 - (typeLength + 1)) {
                String voucheNumberErrMsg = " VoucherNumber length should be lessthan " + (30 - (typeLength + 1));
                throw new ValidationException(Arrays.asList(new ValidationError("voucher.number.exceeds.max.length", voucheNumberErrMsg)));
            }
        }
    }

    protected void insertIntoVoucherHeader(CVoucherHeader vh) throws ApplicationRuntimeException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"start | insertIntoVoucherHeader");
        }
        String vdt = this.formatter.format(vh.getVoucherDate());
        String fiscalPeriod = null;
        try {
            CFiscalPeriod fis = this.fiscalPeriodHibernateDAO.getFiscalPeriodByDate(vh.getVoucherDate());
            if (fis != null) {
                fiscalPeriod = fis.getId().toString();
            }
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("error while getting fiscal period");
        }
        if (null == fiscalPeriod) {
            throw new ApplicationRuntimeException("Voucher Date not within an open period or Financial year not open for posting, fiscalPeriod := " + fiscalPeriod);
        }
        vh.setFiscalPeriodId(Integer.valueOf(fiscalPeriod));
        vh.setCgvn(this.getCGVNNumber(vh));
        try {
            if (!this.isUniqueVN(vh.getVoucherNumber(), vdt)) {
                throw new ValidationException(Arrays.asList(new ValidationError("Duplicate Voucher Number", "Duplicate Voucher Number")));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)ERR, (Throwable)e);
            throw new ApplicationRuntimeException(e.getMessage());
        }
        vh.setCreatedBy(this.userMngr.getUserById(Long.valueOf(ApplicationThreadLocals.getUserId())));
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("++++++++++++++++++" + vh.toString()));
        }
        this.voucherService.persist(vh);
        if (null != vh.getVouchermis().getSourcePath() && null == vh.getModuleId() && vh.getVouchermis().getSourcePath().length() == vh.getVouchermis().getSourcePath().indexOf("=") + 1) {
            StringBuffer sourcePath = new StringBuffer();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Source Path received : " + vh.getVouchermis().getSourcePath()));
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Voucher Header Id  : " + vh.getId()));
            }
            sourcePath.append(vh.getVouchermis().getSourcePath()).append(vh.getId().toString());
            vh.getVouchermis().setSourcePath(sourcePath.toString());
            this.voucherService.update(vh);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"End | insertIntoVoucherHeader");
        }
    }

    protected String getCgnType(String vouType) {
        String vType = vouType.toUpperCase().replaceAll(" ", "");
        String cgnType = null;
        String typetoCheck = vType;
        if (vType.equalsIgnoreCase("JOURNAL VOUCHER")) {
            typetoCheck = "JOURNALVOUCHER";
        }
        switch (voucherTypeEnum.valueOf(typetoCheck.toUpperCase())) {
            case JOURNALVOUCHER: {
                cgnType = "JVG";
                break;
            }
            case CONTRA: {
                cgnType = "CSL";
                break;
            }
            case RECEIPT: {
                cgnType = "MSR";
                break;
            }
            case PAYMENT: {
                cgnType = "DBP";
                break;
            }
        }
        return cgnType;
    }

    public void validateVoucherMIS(HashMap<String, Object> headerdetails) throws ApplicationRuntimeException {
        Fundsource fundsource;
        Functionary functionary;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"START | validateVoucherMIS");
        }
        Department dept = null;
        if (headerdetails.containsKey("departmentcode") && null != headerdetails.get("departmentcode") && (dept = this.deptM.getDepartmentByCode(headerdetails.get("departmentcode").toString())) == null) {
            throw new ApplicationRuntimeException("not a valid Department");
        }
        if (null != headerdetails.get("functionarycode") && null == (functionary = this.functionaryDAO.getFunctionaryByCode(BigDecimal.valueOf(Long.valueOf(headerdetails.get("functionarycode").toString()))))) {
            throw new ApplicationRuntimeException("not a valid functionary");
        }
        String fundCode = null;
        Fund fund = null;
        if (headerdetails.containsKey("fundcode") && null != headerdetails.get("fundcode")) {
            fundCode = headerdetails.get("fundcode").toString();
            fund = this.fundDAO.fundByCode(fundCode);
            if (null == fund) {
                throw new ApplicationRuntimeException("not a valid fund");
            }
        } else {
            throw new ApplicationRuntimeException("fund value is missing");
        }
        Scheme scheme = null;
        if (headerdetails.containsKey("schemecode") && null != headerdetails.get("schemecode")) {
            String schemecode = headerdetails.get("schemecode").toString();
            scheme = this.schemeDAO.getSchemeByCode(schemecode);
            if (null == scheme) {
                throw new ApplicationRuntimeException("not a valid scheme");
            }
            if (!fund.getId().equals(scheme.getFund().getId())) {
                throw new ApplicationRuntimeException("This scheme does not belong to this fund");
            }
        }
        SubScheme subScheme = null;
        if (headerdetails.containsKey("subschemecode") && null != headerdetails.get("subschemecode")) {
            String subSchemeCode = headerdetails.get("subschemecode").toString();
            subScheme = this.subSchemeDAO.getSubSchemeByCode(subSchemeCode);
            if (null == subScheme) {
                throw new ApplicationRuntimeException("not a valid subscheme");
            }
            if (!subScheme.getScheme().getId().equals(scheme.getId())) {
                throw new ApplicationRuntimeException("This subscheme does not belong to this scheme");
            }
        }
        if (headerdetails.containsKey("fundsourcecode") && null != headerdetails.get("fundsourcecode") && null == (fundsource = this.fundSourceDAO.getFundSourceByCode(headerdetails.get("fundsourcecode").toString()))) {
            throw new ApplicationRuntimeException("not a valid fund source");
        }
        if (headerdetails.containsKey("divisionid") && null != headerdetails.get("divisionid") && null == this.boundary.getBoundaryById(Long.valueOf(Long.parseLong(headerdetails.get("divisionid").toString())))) {
            throw new ApplicationRuntimeException("not a valid divisionid");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"END | validateVoucherMIS");
        }
    }

    public void validateMandateFields(HashMap<String, Object> headerdetails) {
        List<String> headerMandateFields = this.getHeaderMandateFields();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Inside Validate Method");
        }
        this.checkMandatoryField("vouchernumber", headerdetails.get("vouchernumber"), headerdetails, headerMandateFields);
        this.checkMandatoryField("voucherdate", headerdetails.get("voucherdate"), headerdetails, headerMandateFields);
        this.checkMandatoryField("fund", headerdetails.get("fundcode"), headerdetails, headerMandateFields);
        this.checkMandatoryField("department", headerdetails.get("departmentcode"), headerdetails, headerMandateFields);
        this.checkMandatoryField("scheme", headerdetails.get("schemecode"), headerdetails, headerMandateFields);
        this.checkMandatoryField("subscheme", headerdetails.get("subschemecode"), headerdetails, headerMandateFields);
        this.checkMandatoryField("functionary", headerdetails.get("functionarycode"), headerdetails, headerMandateFields);
        this.checkMandatoryField("fundsource", headerdetails.get("fundsourcecode"), headerdetails, headerMandateFields);
        this.checkMandatoryField("field", headerdetails.get("divisionid"), headerdetails, headerMandateFields);
    }

    private void validateVoucherType(String vouType) {
        voucherTypeEnum[] allvoucherTypeEnum;
        String voucherType = vouType.toUpperCase().replaceAll(" ", "");
        boolean typeFound = false;
        for (voucherTypeEnum voucherTypeEnum2 : allvoucherTypeEnum = voucherTypeEnum.values()) {
            if (!voucherTypeEnum2.toString().equalsIgnoreCase(voucherType)) continue;
            typeFound = true;
            break;
        }
        if (!typeFound) {
            throw new ApplicationRuntimeException("Voucher type is not valid");
        }
    }

    @Transactional
    public CVoucherHeader createVoucherHeader(HashMap<String, Object> headerdetails) throws ApplicationRuntimeException, Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"START | createVoucherHeader");
        }
        Query query = null;
        CVoucherHeader cVoucherHeader = new CVoucherHeader();
        try {
            cVoucherHeader.setName(headerdetails.get("vouchername").toString());
            String voucherType = headerdetails.get("vouchertype").toString();
            cVoucherHeader.setType(headerdetails.get("vouchertype").toString());
            String vNumGenMode = null;
            vNumGenMode = "Journal Voucher".equalsIgnoreCase(voucherType) ? this.voucherTypeForULB.readVoucherTypes("Journal") : this.voucherTypeForULB.readVoucherTypes(voucherType);
            voucherType = voucherType.toUpperCase().replaceAll(" ", "");
            String voucherSubType = null;
            if (headerdetails.get(VoucherConstant.VOUCHERSUBTYPE) != null) {
                voucherSubType = (String)headerdetails.get(VoucherConstant.VOUCHERSUBTYPE);
                voucherSubType = voucherSubType.toUpperCase().replaceAll(" ", "");
            }
            String voucherNumberPrefix = this.getVoucherNumberPrefix(voucherType, voucherSubType);
            String voucherNumber = null;
            if (headerdetails.get("description") != null) {
                cVoucherHeader.setDescription(headerdetails.get("description").toString());
            }
            Date voucherDate = (Date)headerdetails.get("voucherdate");
            cVoucherHeader.setVoucherDate(voucherDate);
            Fund fundByCode = this.fundDAO.fundByCode(headerdetails.get("fundcode").toString());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Voucher Type is :" + voucherType));
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("vNumGenMode is  :" + vNumGenMode));
            }
            if (headerdetails.get("vouchernumber") != null) {
                voucherNumber = headerdetails.get("vouchernumber").toString();
            }
            if (null != headerdetails.get("moduleid")) {
                vNumGenMode = "Auto";
            }
            cVoucherHeader.setFundId(fundByCode);
            if (vNumGenMode.equals("Auto")) {
                cVoucherHeader.setVoucherNumberPrefix(voucherNumberPrefix);
                VouchernumberGenerator v = (VouchernumberGenerator)this.beanResolver.getAutoNumberServiceFor(VouchernumberGenerator.class);
                String strVoucherNumber = v.getNextNumber(cVoucherHeader);
                cVoucherHeader.setVoucherNumber(strVoucherNumber);
            }
            if (headerdetails.containsKey("moduleid") && null != headerdetails.get("moduleid")) {
                cVoucherHeader.setModuleId(Integer.valueOf(headerdetails.get("moduleid").toString()));
                cVoucherHeader.setIsConfirmed(Integer.valueOf(1));
            }
            if (headerdetails.containsKey("status") && null != headerdetails.get("status")) {
                cVoucherHeader.setStatus(Integer.valueOf(headerdetails.get("status").toString()));
            } else {
                List list = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "DEFAULTVOUCHERCREATIONSTATUS");
                cVoucherHeader.setStatus(Integer.valueOf(Integer.parseInt(((AppConfigValues)list.get(0)).getValue())));
            }
            if (null != headerdetails.get("originalvoucher")) {
                Long origionalVId = Long.parseLong(headerdetails.get("originalvoucher").toString());
                query = this.persistenceService.getSession().createQuery("from CVoucherHeader where id=:id");
                query.setLong("id", origionalVId.longValue());
                if (query.list().size() == 0) {
                    throw new ApplicationRuntimeException("Not a valid origional voucherheader id");
                }
                cVoucherHeader.setOriginalvcId(origionalVId);
            }
            cVoucherHeader.setRefvhId((Long)headerdetails.get("refvoucher"));
            cVoucherHeader.setEffectiveDate(new Date());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Printing Voucher Details------------------------------------------------------------------------------");
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)cVoucherHeader.toString());
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Printing Voucher Details------------------------------------------------------------------------------");
            }
        }
        catch (ValidationException e) {
            LOGGER.error((Object)e.getMessage());
            throw e;
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            throw new Exception(e.getMessage());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"END | createVoucherHeader");
        }
        return cVoucherHeader;
    }

    private String getVoucherNumberPrefix(String type, String vsubtype) {
        if (vsubtype == null) {
            vsubtype = type;
        }
        String subtype = vsubtype.toUpperCase().trim();
        String voucherNumberPrefix = null;
        String typetoCheck = subtype;
        if (subtype.equalsIgnoreCase("JOURNAL VOUCHER")) {
            typetoCheck = "JOURNALVOUCHER";
        }
        switch (voucherSubTypeEnum.valueOf(typetoCheck)) {
            case JVGENERAL: {
                voucherNumberPrefix = FinancialConstants.JOURNAL_VOUCHERNO_TYPE;
                break;
            }
            case JOURNALVOUCHER: {
                voucherNumberPrefix = FinancialConstants.JOURNAL_VOUCHERNO_TYPE;
                break;
            }
            case CONTRA: {
                voucherNumberPrefix = FinancialConstants.CONTRA_VOUCHERNO_TYPE;
                break;
            }
            case RECEIPT: {
                voucherNumberPrefix = FinancialConstants.RECEIPT_VOUCHERNO_TYPE;
                break;
            }
            case PAYMENT: {
                voucherNumberPrefix = FinancialConstants.PAYMENT_VOUCHERNO_TYPE;
                break;
            }
            case PURCHASEJOURNAL: {
                voucherNumberPrefix = FinancialConstants.PURCHBILL_VOUCHERNO_TYPE;
                break;
            }
            case WORKS: {
                voucherNumberPrefix = FinancialConstants.WORKSBILL_VOUCHERNO_TYPE;
                break;
            }
            case CONTRACTORJOURNAL: {
                voucherNumberPrefix = FinancialConstants.WORKSBILL_VOUCHERNO_TYPE;
                break;
            }
            case WORKSJOURNAL: {
                voucherNumberPrefix = FinancialConstants.WORKSBILL_VOUCHERNO_TYPE;
                break;
            }
            case FIXEDASSETJOURNAL: {
                voucherNumberPrefix = FinancialConstants.FIXEDASSET_VOUCHERNO_TYPE;
                break;
            }
            case CONTINGENTJOURNAL: {
                voucherNumberPrefix = FinancialConstants.CBILL_VOUCHERNO_TYPE;
                break;
            }
            case PURCHASE: {
                voucherNumberPrefix = FinancialConstants.PURCHBILL_VOUCHERNO_TYPE;
                break;
            }
            case EXPENSEJOURNAL: {
                voucherNumberPrefix = FinancialConstants.CBILL_VOUCHERNO_TYPE;
                break;
            }
            case EXPENSE: {
                voucherNumberPrefix = FinancialConstants.CBILL_VOUCHERNO_TYPE;
                break;
            }
            case SALARYJOURNAL: {
                voucherNumberPrefix = FinancialConstants.SALBILL_VOUCHERNO_TYPE;
                break;
            }
            case SALARY: {
                voucherNumberPrefix = FinancialConstants.SALBILL_VOUCHERNO_TYPE;
                break;
            }
            case FIXEDASSET: {
                voucherNumberPrefix = FinancialConstants.FIXEDASSET_VOUCHERNO_TYPE;
                break;
            }
            case PENSIONJOURNAL: {
                voucherNumberPrefix = FinancialConstants.PENBILL_VOUCHERNO_TYPE;
                break;
            }
            case PENSION: {
                voucherNumberPrefix = FinancialConstants.PENBILL_VOUCHERNO_TYPE;
                break;
            }
            default: {
                if (voucherNumberPrefix != null) break;
                voucherNumberPrefix = this.checkwithvouchertype(type);
            }
        }
        return voucherNumberPrefix;
    }

    private String checkwithvouchertype(String type) {
        String typetoCheck = type;
        if (type.equalsIgnoreCase("JOURNAL VOUCHER")) {
            typetoCheck = "JOURNALVOUCHER";
        }
        String voucherNumberPrefix = null;
        switch (voucherTypeEnum.valueOf(typetoCheck)) {
            case JOURNALVOUCHER: {
                voucherNumberPrefix = FinancialConstants.JOURNAL_VOUCHERNO_TYPE;
                break;
            }
            case CONTRA: {
                voucherNumberPrefix = FinancialConstants.CONTRA_VOUCHERNO_TYPE;
                break;
            }
            case RECEIPT: {
                voucherNumberPrefix = FinancialConstants.RECEIPT_VOUCHERNO_TYPE;
                break;
            }
            case PAYMENT: {
                voucherNumberPrefix = FinancialConstants.PAYMENT_VOUCHERNO_TYPE;
                break;
            }
        }
        return voucherNumberPrefix;
    }

    @Transactional
    public Vouchermis createVouchermis(HashMap<String, Object> headerdetails) throws ApplicationRuntimeException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"START | createVouchermis");
        }
        Vouchermis vouchermis = new Vouchermis();
        if (headerdetails.containsKey("departmentcode") && null != headerdetails.get("departmentcode")) {
            String departmentCode = headerdetails.get("departmentcode").toString();
            vouchermis.setDepartmentid(this.deptM.getDepartmentByCode(departmentCode));
        }
        if (headerdetails.containsKey("schemecode") && null != headerdetails.get("schemecode")) {
            String schemecode = headerdetails.get("schemecode").toString();
            vouchermis.setSchemeid(this.schemeDAO.getSchemeByCode(schemecode));
        }
        if (headerdetails.containsKey("subschemecode") && null != headerdetails.get("subschemecode")) {
            String subschemecode = headerdetails.get("subschemecode").toString();
            vouchermis.setSubschemeid(this.subSchemeDAO.getSubSchemeByCode(subschemecode));
        }
        if (headerdetails.containsKey("fundsourcecode") && null != headerdetails.get("fundsourcecode")) {
            String fundsourcecode = headerdetails.get("fundsourcecode").toString();
            vouchermis.setFundsource(this.fundSourceDAO.getFundSourceByCode(fundsourcecode));
        }
        if (null != headerdetails.get("functionarycode")) {
            vouchermis.setFunctionary(this.functionaryDAO.getFunctionaryByCode(BigDecimal.valueOf(Long.valueOf(headerdetails.get("functionarycode").toString()))));
        }
        if (headerdetails.containsKey("functioncode") && null != headerdetails.get("functioncode")) {
            String functionCode = headerdetails.get("functioncode").toString();
            vouchermis.setFunction(this.functionDAO.getFunctionByCode(functionCode));
        }
        if (null != headerdetails.get("sourcepath")) {
            vouchermis.setSourcePath(headerdetails.get("sourcepath").toString());
        }
        if (headerdetails.containsKey("divisionid") && null != headerdetails.get("divisionid")) {
            vouchermis.setDivisionid(this.boundary.getBoundaryById(Long.valueOf(Long.parseLong(headerdetails.get("divisionid").toString()))));
        }
        if (headerdetails.containsKey("Budget check required") && null != headerdetails.get("Budget check required")) {
            vouchermis.setBudgetCheckReq((Boolean)headerdetails.get("Budget check required"));
        } else {
            vouchermis.setBudgetCheckReq(Boolean.valueOf(true));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"END | createVouchermis");
        }
        return vouchermis;
    }

    public void validateTransaction(List<HashMap<String, Object>> accountcodedetails, List<HashMap<String, Object>> subledgerdetails) throws ApplicationRuntimeException, Exception {
        String glcode;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"START | validateTransaction");
        }
        BigDecimal totaldebitAmount = BigDecimal.valueOf(0L);
        BigDecimal totalcreditAmount = BigDecimal.valueOf(0L);
        HashMap<String, BigDecimal> accDetAmtMap = new HashMap<String, BigDecimal>();
        for (HashMap<String, Object> accDetailMap : accountcodedetails) {
            String functionCode;
            String glcode2 = null;
            BigDecimal debitAmount = new BigDecimal(accDetailMap.get("debitamount").toString());
            BigDecimal creditAmount = new BigDecimal(accDetailMap.get("creditamount").toString());
            totaldebitAmount = totaldebitAmount.add(debitAmount);
            totalcreditAmount = totalcreditAmount.add(creditAmount);
            if (accDetailMap.containsKey("glcode") && null != accDetailMap.get("glcode")) {
                glcode2 = accDetailMap.get("glcode").toString();
                if (null == this.chartOfAccountsDAO.getCChartOfAccountsByGlCode(glcode2)) {
                    throw new ApplicationRuntimeException("Not a valid account code" + glcode2);
                }
            } else {
                throw new ApplicationRuntimeException("glcode is missing or null");
            }
            if (debitAmount.compareTo(BigDecimal.ZERO) != 0 && creditAmount.compareTo(BigDecimal.ZERO) != 0) {
                throw new ApplicationRuntimeException("Both debit amount and credit amount cannot be greater than zero");
            }
            if (debitAmount.compareTo(BigDecimal.ZERO) == 0 && creditAmount.compareTo(BigDecimal.ZERO) == 0) {
                throw new ApplicationRuntimeException("debit and credit both amount is Zero");
            }
            if (null != accDetailMap.get("functioncode") && "" != accDetailMap.get("functioncode") && null == this.functionDAO.getFunctionByCode(functionCode = accDetailMap.get("functioncode").toString())) {
                throw new ApplicationRuntimeException("not a valid function code");
            }
            if (debitAmount.compareTo(BigDecimal.ZERO) != 0) {
                if (null != accDetAmtMap.get("debit" + glcode2)) {
                    BigDecimal accountCodeTotDbAmt = ((BigDecimal)accDetAmtMap.get("debit" + glcode2)).add(debitAmount);
                    accDetAmtMap.put("debit" + glcode2, accountCodeTotDbAmt);
                    continue;
                }
                accDetAmtMap.put("debit" + glcode2, debitAmount);
                continue;
            }
            if (creditAmount.compareTo(BigDecimal.ZERO) == 0) continue;
            if (null != accDetAmtMap.get("credit" + glcode2)) {
                BigDecimal accountCodeTotCrAmt = ((BigDecimal)accDetAmtMap.get("credit" + glcode2)).add(creditAmount);
                accDetAmtMap.put("credit" + glcode2, accountCodeTotCrAmt);
                continue;
            }
            accDetAmtMap.put("credit" + glcode2, creditAmount);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Total Debit  amount   :" + totaldebitAmount));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Total Credit amount   :" + totalcreditAmount));
        }
        totaldebitAmount = totaldebitAmount.setScale(2, 4);
        totalcreditAmount = totalcreditAmount.setScale(2, 4);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Total Debit  amount after round off :" + totaldebitAmount));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Total Credit amount after round off :" + totalcreditAmount));
        }
        if (totaldebitAmount.compareTo(totalcreditAmount) != 0) {
            throw new ApplicationRuntimeException("total debit and total credit amount is not matching");
        }
        HashMap<String, BigDecimal> subledAmtmap = new HashMap<String, BigDecimal>();
        for (HashMap<String, Object> subdetailDetailMap : subledgerdetails) {
            Query qry;
            Session session;
            glcode = null;
            String detailtypeid = null;
            String detailKeyId = null;
            if (null != subdetailDetailMap.get("glcode")) {
                glcode = subdetailDetailMap.get("glcode").toString();
                if (null == this.chartOfAccountsDAO.getCChartOfAccountsByGlCode(glcode)) {
                    throw new ApplicationRuntimeException("not a valid glcode");
                }
            } else {
                throw new ApplicationRuntimeException("glcode is missing");
            }
            Query querytds = this.persistenceService.getSession().createQuery("select t.id from Recovery t where t.chartofaccounts.glcode=:glcode");
            querytds.setString("glcode", glcode);
            querytds.setCacheable(true);
            if (null == querytds.list() || querytds.list().size() <= 0 || null != subdetailDetailMap.get("tdsId") || null == subdetailDetailMap.get("creditamount") || new BigDecimal(subdetailDetailMap.get("creditamount").toString()).compareTo(BigDecimal.ZERO) != 0) {
                // empty if block
            }
            Query query = this.persistenceService.getSession().createQuery("from CChartOfAccountDetail cd,CChartOfAccounts c where cd.glCodeId = c.id and c.glcode=:glcode");
            query.setString("glcode", glcode);
            query.setCacheable(true);
            if (null == query.list() || query.list().size() == 0) {
                throw new ApplicationRuntimeException("This code is not a control code" + glcode);
            }
            if (null != subdetailDetailMap.get("detailtypeid")) {
                detailtypeid = subdetailDetailMap.get("detailtypeid").toString();
                session = this.persistenceService.getSession();
                qry = session.createQuery("from CChartOfAccountDetail cd,CChartOfAccounts c where cd.glCodeId = c.id and c.glcode=:glcode and cd.detailTypeId.id=:detailTypeId");
                qry.setString("glcode", glcode);
                qry.setInteger("detailTypeId", Integer.valueOf(detailtypeid).intValue());
                qry.setCacheable(true);
                if (null == qry.list() || qry.list().size() == 0) {
                    throw new ApplicationRuntimeException("The subledger type mapped to this account code is not correct " + glcode);
                }
            } else {
                throw new ApplicationRuntimeException("Subledger type value is missing for account code " + glcode);
            }
            if (null != subdetailDetailMap.get("detailkeyid")) {
                detailKeyId = subdetailDetailMap.get("detailkeyid").toString();
                session = this.persistenceService.getSession();
                qry = session.createQuery("from Accountdetailkey adk where adk.accountdetailtype.id=:detailtypeid and adk.detailkey=:detailkey");
                qry.setInteger("detailtypeid", Integer.valueOf(detailtypeid).intValue());
                qry.setInteger("detailkey", Integer.valueOf(detailKeyId).intValue());
                qry.setCacheable(true);
                if (null == qry.list() || qry.list().size() == 0) {
                    throw new ApplicationRuntimeException("Subledger data is not valid for account code " + glcode);
                }
            } else {
                throw new ApplicationRuntimeException("detailkeyid is missing");
            }
            if (null != subdetailDetailMap.get("debitamount") && new BigDecimal(subdetailDetailMap.get("debitamount").toString()).compareTo(BigDecimal.ZERO) != 0) {
                BigDecimal dbtAmount = new BigDecimal(subdetailDetailMap.get("debitamount").toString());
                if (null != subledAmtmap.get("debit" + glcode)) {
                    subledAmtmap.put("debit" + glcode, ((BigDecimal)subledAmtmap.get("debit" + glcode)).add(dbtAmount));
                    continue;
                }
                subledAmtmap.put("debit" + glcode, dbtAmount);
                continue;
            }
            if (null != subdetailDetailMap.get("creditamount") && new BigDecimal(subdetailDetailMap.get("creditamount").toString()).compareTo(BigDecimal.ZERO) != 0) {
                BigDecimal creditAmt = new BigDecimal(subdetailDetailMap.get("creditamount").toString());
                if (null != subledAmtmap.get("credit" + glcode)) {
                    subledAmtmap.put("credit" + glcode, ((BigDecimal)subledAmtmap.get("credit" + glcode)).add(creditAmt));
                    continue;
                }
                subledAmtmap.put("credit" + glcode, creditAmt);
                continue;
            }
            throw new ApplicationRuntimeException("Incorrect Sub ledger amount supplied for glcode : " + glcode);
        }
        for (HashMap<String, Object> accDetailMap : accountcodedetails) {
            glcode = accDetailMap.get("glcode").toString();
            if (null != subledAmtmap.get("debit" + glcode) && ((BigDecimal)subledAmtmap.get("debit" + glcode)).compareTo((BigDecimal)accDetAmtMap.get("debit" + glcode)) != 0) {
                throw new ApplicationRuntimeException("Total of subleger debit amount is not matching with the account code amount " + glcode);
            }
            if (null == subledAmtmap.get("credit" + glcode) || ((BigDecimal)subledAmtmap.get("credit" + glcode)).compareTo((BigDecimal)accDetAmtMap.get("credit" + glcode)) == 0) continue;
            throw new ApplicationRuntimeException("Total of subleger credit amount is not matching with the account code amount " + glcode);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"END | validateTransaction");
        }
    }

    public List<Transaxtion> createTransaction(HashMap<String, Object> headerdetails, List<HashMap<String, Object>> accountcodedetails, List<HashMap<String, Object>> subledgerdetails, CVoucherHeader vh) throws ApplicationRuntimeException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Start | createTransaction ");
        }
        ArrayList<Transaxtion> transaxtionList = new ArrayList<Transaxtion>();
        try {
            Integer voucherLineId = 1;
            for (HashMap<String, Object> accDetailMap : accountcodedetails) {
                String glcode = accDetailMap.get("glcode").toString();
                String debitAmount = accDetailMap.get("debitamount").toString();
                String creditAmount = accDetailMap.get("creditamount").toString();
                String functionId = null;
                String functioncode = null;
                if (null != accDetailMap.get("narration")) {
                    accDetailMap.get("narration").toString();
                }
                if (null != accDetailMap.get("functioncode") && "" != accDetailMap.get("functioncode")) {
                    functioncode = accDetailMap.get("functioncode").toString();
                    functionId = this.functionDAO.getFunctionByCode(accDetailMap.get("functioncode").toString()).getId().toString();
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("functionId>>>>>>>> " + functionId));
                    }
                }
                CChartOfAccounts chartOfAcc = this.chartOfAccountsDAO.getCChartOfAccountsByGlCode(glcode);
                Transaxtion transaction = new Transaxtion();
                transaction.setGlCode(chartOfAcc.getGlcode());
                transaction.setGlName(chartOfAcc.getName());
                Integer n = voucherLineId;
                voucherLineId = voucherLineId + 1;
                Integer n2 = voucherLineId;
                transaction.setVoucherLineId(String.valueOf(n));
                transaction.setVoucherHeaderId(vh.getId().toString());
                transaction.setCrAmount(creditAmount);
                transaction.setDrAmount(debitAmount);
                transaction.setFunctionId(functionId);
                if (headerdetails != null && headerdetails.get("billid") != null) {
                    transaction.setBillId((Long)headerdetails.get("billid"));
                }
                ArrayList<TransaxtionParameter> reqParams = new ArrayList<TransaxtionParameter>();
                for (HashMap hashMap : subledgerdetails) {
                    String detailGlCode = hashMap.get("glcode").toString();
                    String detailtypeid = hashMap.get("detailtypeid").toString();
                    if (hashMap.containsKey("functioncode") && null != hashMap.get("functioncode") && "" != hashMap.get("functioncode")) {
                        String detailFunctionCode = hashMap.get("functioncode").toString();
                        if (!glcode.equals(detailGlCode) || functioncode == null || !functioncode.equals(detailFunctionCode)) continue;
                        TransaxtionParameter reqData = new TransaxtionParameter();
                        Accountdetailtype adt = this.accountdetailtypeHibernateDAO.findById((Number)Integer.valueOf(detailtypeid), false);
                        reqData.setDetailName(adt.getAttributename());
                        reqData.setGlcodeId(chartOfAcc.getId().toString());
                        if (null != hashMap.get("debitamount") && new BigDecimal(hashMap.get("debitamount").toString()).compareTo(BigDecimal.ZERO) != 0) {
                            reqData.setDetailAmt(hashMap.get("debitamount").toString());
                        } else {
                            reqData.setDetailAmt(hashMap.get("creditamount").toString());
                        }
                        reqData.setDetailKey(hashMap.get("detailkeyid").toString());
                        reqData.setDetailTypeId(detailtypeid);
                        reqData.setTdsId(hashMap.get("tdsId") != null ? hashMap.get("tdsId").toString() : null);
                        reqParams.add(reqData);
                        continue;
                    }
                    if (!glcode.equals(detailGlCode)) continue;
                    TransaxtionParameter reqData = new TransaxtionParameter();
                    Accountdetailtype adt = this.accountdetailtypeHibernateDAO.findById((Number)Integer.valueOf(detailtypeid), false);
                    reqData.setDetailName(adt.getAttributename());
                    reqData.setGlcodeId(chartOfAcc.getId().toString());
                    if (null != hashMap.get("debitamount") && new BigDecimal(hashMap.get("debitamount").toString()).compareTo(BigDecimal.ZERO) != 0) {
                        reqData.setDetailAmt(hashMap.get("debitamount").toString());
                    } else {
                        reqData.setDetailAmt(hashMap.get("creditamount").toString());
                    }
                    reqData.setDetailKey(hashMap.get("detailkeyid").toString());
                    reqData.setDetailTypeId(detailtypeid);
                    reqData.setTdsId(hashMap.get("tdsId") != null ? hashMap.get("tdsId").toString() : null);
                    reqParams.add(reqData);
                }
                if (reqParams != null && reqParams.size() > 0) {
                    transaction.setTransaxtionParam(reqParams);
                }
                transaxtionList.add(transaction);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Exception occured while posting data into voucher detail and transaction");
            throw new ApplicationRuntimeException("Exception occured while posting data into voucher detail and transaction" + e.getMessage());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"END | createTransaction ");
        }
        return transaxtionList;
    }

    public Functionary getFunctionaryByCode(BigDecimal code) {
        Functionary functionary = (Functionary)this.persistenceService.find("from Functionary where code=?", new Object[]{code});
        return functionary;
    }

    public void validateVoucherHeader(CVoucherHeader voucherHeader) {
        if (null == voucherHeader) {
            throw new ApplicationRuntimeException("voucherHeader object passed is null");
        }
        if (null == voucherHeader.getType() || !voucherHeader.getType().equalsIgnoreCase(voucherTypeEnum.RECEIPT.toString())) {
            throw new ApplicationRuntimeException("Voucher type is not Receipt");
        }
    }

    public void validateReceiptDetails(HashMap<String, Object> receiptdetails) {
        String modeofcollection = null;
        if (null == receiptdetails) {
            throw new ApplicationRuntimeException("receiptdetails is null");
        }
        if (null == receiptdetails.get("modeofcollection")) {
            throw new ApplicationRuntimeException("modeofcollection is null");
        }
        modeofcollection = this.chkModeOfCollection(receiptdetails.get("modeofcollection").toString());
        if (null == modeofcollection) {
            throw new ApplicationRuntimeException("Not a valid modeofcollection");
        }
        if ("Bank".equalsIgnoreCase(modeofcollection)) {
            this.validateBankDetails(receiptdetails);
        }
        if (null == receiptdetails.get("netamount")) {
            throw new ApplicationRuntimeException("Net amount is null");
        }
    }

    public void validateBankDetails(HashMap<String, Object> receiptdetails) {
        String bankCode = null;
        String bankBranchCode = null;
        String bankAccNumber = null;
        if (null == receiptdetails.get("bankcode")) {
            throw new ApplicationRuntimeException("Bank Code is null");
        }
        if (null == receiptdetails.get("bankbranchcode")) {
            throw new ApplicationRuntimeException("Bank branch code  is null");
        }
        if (null == receiptdetails.get("bankaccountnumber")) {
            throw new ApplicationRuntimeException("Bank Account number is null");
        }
        bankCode = receiptdetails.get("bankcode").toString();
        bankBranchCode = receiptdetails.get("bankbranchcode").toString();
        bankAccNumber = receiptdetails.get("bankaccountnumber").toString();
        Bankaccount bankAccount = this.bankAccountDAO.getBankAccountByAccBranchBank(bankAccNumber, bankBranchCode, bankCode);
        if (null == bankAccount) {
            throw new ApplicationRuntimeException("not a valid bank account number");
        }
        receiptdetails.put("bankaccountid", bankAccount.getId());
    }

    public void validateInstrumentdetails(List<HashMap<String, Object>> instrumentdetailsList, HashMap<String, Object> receiptdetails) {
        String bankCode = null;
        BigDecimal chequeAmounts = BigDecimal.valueOf(0L);
        for (HashMap<String, Object> instrumentdetails : instrumentdetailsList) {
            if (null == instrumentdetails.get("instrumentno")) {
                throw new ApplicationRuntimeException("Cheque number is null");
            }
            if (null == instrumentdetails.get("instrumentdate")) {
                throw new ApplicationRuntimeException("Cheque date is null");
            }
            if (null == instrumentdetails.get("instrumentamount")) {
                throw new ApplicationRuntimeException("Cheque amount is null");
            }
            chequeAmounts = chequeAmounts.add(new BigDecimal(instrumentdetails.get("instrumentamount").toString()));
            if (null == instrumentdetails.get("bankcode") || null != this.bankDAO.getBankByCode(bankCode = instrumentdetails.get("bankcode").toString())) continue;
            throw new ApplicationRuntimeException("not a valid bank code");
        }
        if (!chequeAmounts.equals(receiptdetails.get("netamount"))) {
            throw new ApplicationRuntimeException("total cheque amount is not matching with net amount");
        }
    }

    private String chkModeOfCollection(String mode) {
        String collectionMode = null;
        try {
            switch (Integer.valueOf(mode)) {
                case 1: {
                    collectionMode = modeOfCollectionEnum.Cheque.toString();
                    break;
                }
                case 2: {
                    collectionMode = modeOfCollectionEnum.Cash.toString();
                    break;
                }
                case 3: {
                    collectionMode = modeOfCollectionEnum.Bank.toString();
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)ERR, (Throwable)e);
            throw new ApplicationRuntimeException("Not a valid modeofcollection");
        }
        return collectionMode;
    }

    public void updatePJV(CVoucherHeader vh, List<PreApprovedVoucher> detailList, List<PreApprovedVoucher> subledgerlist) throws ApplicationRuntimeException {
        try {
            this.deleteVoucherdetailAndGL(vh);
            HashMap<String, Object> detailMap = null;
            HashMap<String, Object> subledgerMap = null;
            ArrayList<HashMap<String, Object>> accountdetails = new ArrayList<HashMap<String, Object>>();
            ArrayList<HashMap<String, Object>> subledgerdetails = new ArrayList<HashMap<String, Object>>();
            CChartOfAccounts coa = null;
            CFunction function = null;
            for (PreApprovedVoucher detail : detailList) {
                detailMap = new HashMap<String, Object>();
                detailMap.put("glcode", detail.getGlcodeDetail());
                detailMap.put("debitamount", detail.getDebitAmountDetail());
                detailMap.put("creditamount", detail.getCreditAmountDetail());
                if (detail.getFunctionIdDetail() != null) {
                    function = this.functionDAO.getFunctionById(detail.getFunctionIdDetail());
                    detailMap.put("functioncode", function.getCode());
                }
                accountdetails.add(detailMap);
            }
            if (subledgerlist != null) {
                for (PreApprovedVoucher subledger : subledgerlist) {
                    subledgerMap = new HashMap<String, Object>();
                    coa = this.chartOfAccountsDAO.findById((Number)subledger.getGlcode().getId(), false);
                    subledgerMap.put("glcode", coa.getGlcode());
                    subledgerMap.put("detailtypeid", subledger.getDetailType().getId());
                    subledgerMap.put("detailkeyid", subledger.getDetailKeyId());
                    if (subledger.getDebitAmountDetail() == null || subledger.getDebitAmountDetail().compareTo(BigDecimal.ZERO) == 0) {
                        subledgerMap.put("creditamount", subledger.getCreditAmount());
                    } else {
                        subledgerMap.put("debitamount", subledger.getDebitAmount());
                    }
                    subledgerdetails.add(subledgerMap);
                }
            }
            List<Transaxtion> transactions = this.createTransaction(null, accountdetails, subledgerdetails, vh);
            this.persistenceService.getSession().flush();
            Transaxtion[] txnList = new Transaxtion[transactions.size()];
            txnList = transactions.toArray(txnList);
            SimpleDateFormat formatter = new SimpleDateFormat(DD_MMM_YYYY);
            if (!this.chartOfAccounts.postTransaxtions(txnList, formatter.format(vh.getVoucherDate()))) {
                throw new ApplicationRuntimeException("Voucher creation Failed");
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("Inside exception updatePJV" + e.getMessage()));
            throw new ApplicationRuntimeException(e.getMessage());
        }
    }

    public void deleteVoucherdetailAndGL(CVoucherHeader vh) throws SQLException, ApplicationRuntimeException {
        try {
            SQLQuery pstmt1 = null;
            SQLQuery pstmt2 = null;
            SQLQuery pstmt3 = null;
            SQLQuery pstmt4 = null;
            String glQry = "select id from generalledger where voucherheaderid= ?";
            String glidQry = "select id from generalledgerdetail where generalledgerid= ?";
            String delQry = "delete from EG_REMITTANCE_GLDTL where gldtlid= ?";
            String delQrr = "delete from generalledgerdetail where generalledgerid=?";
            String delgl = " delete from generalledger where voucherheaderid=?";
            String delvh = " delete from voucherdetail where voucherheaderid=?";
            pstmt1 = this.persistenceService.getSession().createSQLQuery("select id from generalledger where voucherheaderid= ?");
            pstmt1.setFloat(0, (float)vh.getId().longValue());
            List rs = pstmt1.list();
            List rs1 = null;
            boolean delete = false;
            while (rs != null && rs.size() > 0) {
                pstmt2 = this.persistenceService.getSession().createSQLQuery("select id from generalledgerdetail where generalledgerid= ?");
                pstmt2.setLong(0, Long.parseLong(((Object[])rs.get(1)).toString()));
                rs1 = pstmt2.list();
                while (rs1 != null && rs1.size() > 0) {
                    delete = true;
                    pstmt3 = this.persistenceService.getSession().createSQLQuery("delete from EG_REMITTANCE_GLDTL where gldtlid= ?");
                    pstmt3.setLong(0, Long.parseLong(((Object[])rs1.get(1)).toString()));
                    pstmt3.executeUpdate();
                }
                if (!delete) continue;
                pstmt4 = this.persistenceService.getSession().createSQLQuery("delete from generalledgerdetail where generalledgerid=?");
                pstmt4.setLong(0, Long.parseLong(((Object[])rs1.get(1)).toString()));
                pstmt4.executeUpdate();
            }
            pstmt1 = this.persistenceService.getSession().createSQLQuery(" delete from generalledger where voucherheaderid=?");
            pstmt1.setLong(0, vh.getId().longValue());
            pstmt1.executeUpdate();
            pstmt1 = this.persistenceService.getSession().createSQLQuery(" delete from voucherdetail where voucherheaderid=?");
            pstmt1.setLong(0, vh.getId().longValue());
            pstmt1.executeUpdate();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Inside exception deleteVoucherdetailAndGL" + e.getMessage()));
            throw new ApplicationRuntimeException(e.getMessage());
        }
    }

    @Transactional
    public CVoucherHeader reverseVoucher(List<HashMap<String, Object>> paramList) throws ApplicationRuntimeException, ParseException {
        CVoucherHeader reversalVoucherObj = new CVoucherHeader();
        CVoucherHeader originalVocher = null;
        for (HashMap<String, Object> paramMap : paramList) {
            if (paramMap.get(VOUCHER_HEADER_ID) == null) {
                throw new IllegalArgumentException("Original voucher header idis missing");
            }
            try {
                originalVocher = (CVoucherHeader)this.voucherService.find("from CVoucherHeader where id=?", new Object[]{(Long)paramMap.get(VOUCHER_HEADER_ID)});
            }
            catch (Exception e) {
                throw new ApplicationRuntimeException("cannot find Original voucher header idin the system");
            }
            reversalVoucherObj.setOriginalvcId(originalVocher.getId());
            if (paramMap.get(REVERSAL_VOUCHER_DATE) == null) {
                SimpleDateFormat sdf = new SimpleDateFormat(DD_MM_YYYY);
                Date reversalVoucherDate = sdf.parse(sdf.format(originalVocher.getVoucherDate()));
                reversalVoucherObj.setVoucherDate(reversalVoucherDate);
                continue;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Voucher  end REVERSAL_VOUCHER_DAT :" + paramMap.get(REVERSAL_VOUCHER_DATE)));
            }
            Date reversalVoucherDate = this.sdf.parse(this.sdf.format(paramMap.get(REVERSAL_VOUCHER_DATE)));
            reversalVoucherObj.setVoucherDate(reversalVoucherDate);
        }
        originalVocher = (CVoucherHeader)this.persistenceService.find("from CVoucherHeader where id=?", new Object[]{reversalVoucherObj.getOriginalvcId()});
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("original voucher is " + reversalVoucherObj.getOriginalvcId()));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("reversalVoucherObj getVoucherDate is " + reversalVoucherObj.getVoucherDate()));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("originalVocher getVoucherDate is " + originalVocher.getVoucherDate()));
        }
        if (reversalVoucherObj.getVoucherDate().before(originalVocher.getVoucherDate())) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Reversal Voucher Date should be greater than the Origianal Voucher Date");
            }
            throw new ValidationException(Arrays.asList(new ValidationError("reversal.voucher.date.validate", "Reversal Voucher Date should be greater than the Original Voucher Date")));
        }
        reversalVoucherObj.setName(originalVocher.getName());
        reversalVoucherObj.setType(originalVocher.getType());
        reversalVoucherObj.setVoucherSubType(originalVocher.getVoucherSubType());
        reversalVoucherObj.setVoucherNumber("");
        reversalVoucherObj.setDescription(originalVocher.getDescription());
        reversalVoucherObj.setVouchermis(originalVocher.getVouchermis());
        reversalVoucherObj.setFundId(originalVocher.getFundId());
        HashMap<String, Object> headerDetails = this.createHeaderAndMisDetails(reversalVoucherObj);
        List orginalLedgerEntries = this.generalLedgerService.findAllBy("from CGeneralLedger where voucherHeaderId=?", new Object[]{originalVocher});
        HashMap<String, Object> detailMap = null;
        HashMap<String, Object> subledgerMap = null;
        ArrayList<HashMap<String, Object>> accountdetails = new ArrayList<HashMap<String, Object>>();
        ArrayList<HashMap<String, Object>> subledgerdetails = new ArrayList<HashMap<String, Object>>();
        CFunction function = null;
        for (CGeneralLedger ledger : orginalLedgerEntries) {
            detailMap = new HashMap<String, Object>();
            detailMap.put("glcode", ledger.getGlcode());
            detailMap.put("debitamount", ledger.getCreditAmount());
            detailMap.put("creditamount", ledger.getDebitAmount());
            if (ledger.getFunctionId() != null) {
                function = this.functionDAO.getFunctionById(Long.valueOf(ledger.getFunctionId().longValue()));
                detailMap.put("functioncode", function.getCode());
            }
            List ledgerDetailSet = this.generalLedgerDetailService.findAllBy("from CGeneralLedgerDetail where generalLedgerId.id=?", new Object[]{ledger.getId()});
            for (CGeneralLedgerDetail ledgerDetail : ledgerDetailSet) {
                subledgerMap = new HashMap<String, Object>();
                subledgerMap.put("glcode", ledger.getGlcode());
                subledgerMap.put("detailtypeid", ledgerDetail.getDetailTypeId().getId());
                subledgerMap.put("detailkeyid", ledgerDetail.getDetailKeyId());
                if (BigDecimal.valueOf(ledger.getDebitAmount()).compareTo(BigDecimal.ZERO) != 0) {
                    subledgerMap.put("creditamount", ledgerDetail.getAmount());
                } else {
                    subledgerMap.put("debitamount", ledgerDetail.getAmount().setScale(2, 6));
                }
                subledgerdetails.add(subledgerMap);
            }
            accountdetails.add(detailMap);
        }
        try {
            reversalVoucherObj = this.createVoucher(headerDetails, accountdetails, subledgerdetails);
        }
        catch (HibernateException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new ValidationException(Arrays.asList(new ValidationError(EXCEPTION_WHILE_SAVING_DATA, FAILED)));
        }
        catch (ApplicationRuntimeException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
        catch (ValidationException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
        originalVocher.setStatus(Integer.valueOf(1));
        originalVocher.setEffectiveDate(new Date());
        this.voucherService.applyAuditing((AbstractAuditable)originalVocher);
        this.voucherService.update(originalVocher);
        reversalVoucherObj.setOriginalvcId(originalVocher.getId());
        reversalVoucherObj.setStatus(Integer.valueOf(2));
        this.voucherService.applyAuditing((AbstractAuditable)reversalVoucherObj);
        this.voucherService.persist(reversalVoucherObj);
        return reversalVoucherObj;
    }

    private CVoucherHeader validateAndAssignReversalVoucherParams(List<HashMap<String, Object>> paramList) throws ParseException {
        CVoucherHeader reversalVoucher = new CVoucherHeader();
        for (HashMap<String, Object> paramMap : paramList) {
            CVoucherHeader originalVoucher = null;
            if (paramMap.get(VOUCHER_HEADER_ID) == null) {
                throw new IllegalArgumentException("Original voucher header idis missing");
            }
            try {
                originalVoucher = this.voucherHeaderDAO.findById((Number)((Long)paramMap.get(VOUCHER_HEADER_ID)), false);
            }
            catch (Exception e) {
                throw new ApplicationRuntimeException("cannot find Original voucher header idin the system");
            }
            reversalVoucher.setOriginalvcId(originalVoucher.getId());
            if (paramMap.get(NAME) == null || ((String)paramMap.get(NAME)).isEmpty()) {
                throw new IllegalArgumentException("Reversal voucher nameis missingoris empty");
            }
            reversalVoucher.setName((String)paramMap.get(NAME));
            if (paramMap.get(TYPE) == null || ((String)paramMap.get(TYPE)).isEmpty()) {
                throw new IllegalArgumentException("Reversal voucher typeis missingoris empty");
            }
            this.validateVoucherType((String)paramMap.get(TYPE));
            reversalVoucher.setType("Journal Voucher");
            if (paramMap.get(REVERSAL_VOUCHER_DATE) == null) {
                SimpleDateFormat sdf = new SimpleDateFormat(DD_MM_YYYY);
                Date reversalVoucherDate = sdf.parse(sdf.format(originalVoucher.getVoucherDate()));
                reversalVoucher.setVoucherDate(reversalVoucherDate);
            } else {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("vo end REVERSAL_VOUCHER_DAT :" + paramMap.get(REVERSAL_VOUCHER_DATE)));
                }
                reversalVoucher.setVoucherDate((Date)paramMap.get(REVERSAL_VOUCHER_DATE));
            }
            reversalVoucher.setVoucherNumber((String)paramMap.get(REVERSAL_VOUCHER_NUMBER));
        }
        return reversalVoucher;
    }

    protected void validateMandotyFields(HashMap<String, Object> headerdetails) {
    }

    protected void checkMandatoryField(String fieldName, Object value, HashMap<String, Object> headerdetails, List<String> mandatoryFields) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Filed name :=" + fieldName + " Value = :" + value));
        }
        String vNumGenMode = null;
        if (fieldName.equals("vouchernumber")) {
            if (headerdetails.get("vouchertype") == null) {
                throw new ValidationException(Arrays.asList(new ValidationError("vouchertype.required", "vouchertype.required")));
            }
            this.validateVoucherType(headerdetails.get("vouchertype").toString());
            vNumGenMode = "Journal Voucher".equalsIgnoreCase(headerdetails.get("vouchertype").toString()) ? this.voucherTypeForULB.readVoucherTypes("Journal") : this.voucherTypeForULB.readVoucherTypes(headerdetails.get("vouchertype").toString());
            if (!"Auto".equalsIgnoreCase(vNumGenMode) && (value == null || ((String)value).isEmpty()) && headerdetails.get("moduleid") == null) {
                throw new ValidationException(Arrays.asList(new ValidationError("  Please Select  " + fieldName, "  Please Select  " + fieldName)));
            }
        } else if (mandatoryFields.contains(fieldName) && (value == null || StringUtils.isEmpty((String)value.toString()))) {
            throw new ValidationException(Arrays.asList(new ValidationError("  Please Select  " + fieldName, "  Please Select  " + fieldName)));
        }
    }

    protected List<String> getHeaderMandateFields() {
        ArrayList<String> mandatoryFields = new ArrayList<String>();
        List appConfigList = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "DEFAULTTXNMISATTRRIBUTES");
        for (AppConfigValues appConfigVal : appConfigList) {
            String value = appConfigVal.getValue();
            String header = value.substring(0, value.indexOf("|"));
            String mandate = value.substring(value.indexOf("|") + 1);
            if (!mandate.equalsIgnoreCase("M")) continue;
            mandatoryFields.add(header);
        }
        return mandatoryFields;
    }

    private HashMap<String, Object> createHeaderAndMisDetails(CVoucherHeader voucherHeader) throws ValidationException {
        HashMap<String, Object> headerdetails = new HashMap<String, Object>();
        headerdetails.put("vouchername", "JVGeneral");
        headerdetails.put("vouchertype", "Journal Voucher");
        headerdetails.put((String)VoucherConstant.VOUCHERSUBTYPE, voucherHeader.getVoucherSubType());
        headerdetails.put("vouchernumber", voucherHeader.getVoucherNumber());
        headerdetails.put("voucherdate", voucherHeader.getVoucherDate());
        headerdetails.put("description", voucherHeader.getDescription());
        if (voucherHeader.getVouchermis().getDepartmentid() != null) {
            headerdetails.put("departmentcode", voucherHeader.getVouchermis().getDepartmentid().getCode());
        }
        if (voucherHeader.getFundId() != null) {
            headerdetails.put("fundcode", voucherHeader.getFundId().getCode());
        }
        if (voucherHeader.getVouchermis().getSchemeid() != null) {
            headerdetails.put("schemecode", voucherHeader.getVouchermis().getSchemeid().getCode());
        }
        if (voucherHeader.getVouchermis().getSubschemeid() != null) {
            headerdetails.put("subschemecode", voucherHeader.getVouchermis().getSubschemeid().getCode());
        }
        if (voucherHeader.getVouchermis().getFundsource() != null) {
            headerdetails.put("fundsourcecode", voucherHeader.getVouchermis().getFundsource().getCode());
        }
        if (voucherHeader.getVouchermis().getDivisionid() != null) {
            headerdetails.put("divisionid", voucherHeader.getVouchermis().getDivisionid().getId());
        }
        if (voucherHeader.getVouchermis().getFunctionary() != null) {
            headerdetails.put("functionarycode", voucherHeader.getVouchermis().getFunctionary().getCode());
        }
        if (voucherHeader.getVouchermis().getFunction() != null) {
            headerdetails.put("functioncode", voucherHeader.getVouchermis().getFunction().getCode());
        }
        return headerdetails;
    }

    public String getCGVNNumber(CVoucherHeader vh) {
        String cgvnNumber = "";
        String sequenceName = "";
        CFiscalPeriod fiscalPeriod = this.fiscalPeriodHibernateDAO.getFiscalPeriodByDate(vh.getVoucherDate());
        if (fiscalPeriod == null) {
            throw new ApplicationRuntimeException("Fiscal period is not defined for the voucher date");
        }
        sequenceName = "sq_" + vh.getFundId().getIdentifier() + "_" + this.getCgnType(vh.getType()).toLowerCase() + "_cgvn_" + fiscalPeriod.getName();
        Serializable nextSequence = this.applicationSequenceNumberGenerator.getNextSequence(sequenceName);
        cgvnNumber = String.format("%s/%s/%s%010d", vh.getFundId().getIdentifier(), this.getCgnType(vh.getType()), "CGVN", nextSequence);
        return cgvnNumber;
    }

    public AppConfigService getAppConfigService() {
        return this.appConfigService;
    }

    public void setAppConfigService(AppConfigService appConfigService) {
        this.appConfigService = appConfigService;
    }

    public PersistenceService getPersistenceService() {
        return this.persistenceService;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public FinancialYearDAO getFinancialYearDAO() {
        return this.financialYearDAO;
    }

    public void setFinancialYearDAO(FinancialYearDAO financialYearDAO) {
        this.financialYearDAO = financialYearDAO;
    }

    public AppConfigValueService getAppConfigValuesService() {
        return this.appConfigValuesService;
    }

    public void setAppConfigValuesService(AppConfigValueService appConfigValuesService) {
        this.appConfigValuesService = appConfigValuesService;
    }

    public boolean isUniqueVN(String vcNum, String vcDate) throws Exception, TaskFailedException {
        boolean isUnique = false;
        String fyStartDate = "";
        String fyEndDate = "";
        vcNum = vcNum.toUpperCase();
        SQLQuery pst = null;
        List rs = null;
        try {
            String query1 = "SELECT to_char(startingDate, 'DD-Mon-YYYY') AS \"startingDate\", to_char(endingDate, 'DD-Mon-YYYY') AS \"endingDate\" FROM financialYear WHERE startingDate <= '" + vcDate + "' AND endingDate >= '" + vcDate + "'";
            pst = this.persistenceService.getSession().createSQLQuery(query1);
            rs = pst.list();
            if (rs != null && rs.size() > 0) {
                for (Object[] element : rs) {
                    fyStartDate = element[0].toString();
                    fyEndDate = element[1].toString();
                }
            }
            String query2 = "SELECT id FROM voucherHeader WHERE voucherNumber = '" + vcNum + "' AND voucherDate>='" + fyStartDate + "' AND voucherDate<='" + fyEndDate + "' and status!=4";
            pst = this.persistenceService.getSession().createSQLQuery(query2);
            rs = pst.list();
            if (rs != null && rs.size() > 0) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Duplicate Voucher Number");
                }
            } else {
                isUnique = true;
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)"error in finding unique VoucherNumber");
            throw new ApplicationRuntimeException("error in finding unique VoucherNumber");
        }
        return isUnique;
    }

    public String getFiscalPeriod(String vDate) throws TaskFailedException {
        BigInteger fiscalPeriod = null;
        String sql = "select id from fiscalperiod  where '" + vDate + "' between startingdate and endingdate";
        try {
            SQLQuery pst = this.persistenceService.getSession().createSQLQuery(sql);
            List rset = pst.list();
            fiscalPeriod = rset != null ? (BigInteger)rset.get(0) : BigInteger.ZERO;
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exception..." + e.getMessage()));
            throw new TaskFailedException(e.getMessage());
        }
        return fiscalPeriod.toString();
    }

    static enum modeOfCollectionEnum {
        Cheque,
        Cash,
        Bank;

    }

    static enum voucherSubTypeEnum {
        JOURNALVOUCHER,
        CONTRA,
        RECEIPT,
        PAYMENT,
        PURCHASEJOURNAL,
        PENSIONJOURNAL,
        PURCHASE,
        WORKS,
        CONTRACTORJOURNAL,
        FIXEDASSETJOURNAL,
        FIXEDASSET,
        PENSION,
        WORKSJOURNAL,
        CONTINGENTJOURNAL,
        SALARY,
        SALARYJOURNAL,
        EXPENSE,
        EXPENSEJOURNAL,
        JVGENERAL;

    }

    static enum voucherTypeEnum {
        JOURNALVOUCHER,
        CONTRA,
        RECEIPT,
        PAYMENT;

    }
}

