/*
 * Decompiled with CFR 0.152.
 */
package com.exilant.exility.updateservice;

import com.exilant.exility.common.AbstractTask;
import com.exilant.exility.common.DataCollection;
import com.exilant.exility.common.TaskFailedException;
import com.exilant.exility.updateservice.DataUpdater;
import com.exilant.exility.updateservice.TableDefinition;
import com.exilant.exility.updateservice.Tables;
import java.sql.Connection;
import org.apache.log4j.Logger;

public class UpdateTask
extends AbstractTask {
    private static final Logger LOGGER = Logger.getLogger(UpdateTask.class);
    private static UpdateTask singletonInstance;

    public static UpdateTask getTask() {
        if (singletonInstance == null) {
            singletonInstance = new UpdateTask();
        }
        return singletonInstance;
    }

    private UpdateTask() {
    }

    @Override
    public void execute(String tableName, String gridName, DataCollection dc, Connection con, boolean errorOnNoData, boolean gridHasColumnHeading, String prefix) throws TaskFailedException {
        TableDefinition tableDefinition = Tables.getTable(tableName);
        String sql = tableDefinition.getUpdateSQL(dc);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("UPDATE SQL>>>>>>>>>>>>" + sql));
        }
        DataUpdater dataUpdater = DataUpdater.getUpdater();
        dataUpdater.update(sql, con, dc, false);
    }

    public static void main(String[] args) {
    }
}

